/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.cli.client;

import com.sun.net.ssl.internal.ssl.Provider;
import com.sun.netstorage.array.mgmt.cfg.cli.client.CLIProxy;
import com.sun.netstorage.array.mgmt.cfg.cli.client.Encoder;
import com.sun.netstorage.array.mgmt.cfg.cli.client.ProxyServer;
import com.sun.netstorage.array.mgmt.cfg.cli.server.CommandResult;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.Security;
import java.util.Date;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.apache.soap.SOAPException;
import org.apache.soap.rpc.Call;

public class ProxyServerThread
extends Thread {
    public static final String DEFAULT_VERSION = "2.1.4";
    public static final int DEFAULT_RETRIES = 10;
    public static final String SUCCESS_CODE = "0";
    public static final String ERROR_CODE = "100";
    public static final String LOGIN_NAME = "777";
    public static final String LOGIN_CODE = "888";
    public static final String MODIFY_PASSWORD_CODE = "999";
    private static final String SOAP_SECURE_PROTOCOL = "https";
    private static final String SOAP_OPEN_PROTOCOL = "http";
    private static final String SOAP_SECURE_PORT_MR = "9443";
    private static final String SOAP_OPEN_PORT_MR = "9080";
    private static final String SOAP_URI_MR = "se6000ui/servlet/rpcrouter";
    private static final String SOAP_SECURE_PORT_E = "6789";
    private static final String SOAP_OPEN_PORT_E = "9080";
    private static final String SOAP_URI_E = "se6920ui/servlet/rpcrouter";
    private static final String SOAP_SECURE_PORT_TF = "6789";
    private static final String SOAP_OPEN_PORT_TF = "9080";
    private static final String SOAP_URI_TF = "se6130ui/servlet/rpcrouter";
    private String soapProtocol = "https";
    private String soapPort = "6789";
    private Call callObject = null;
    private byte[] token;
    private int serverPort;
    private Date lastConnection = new Date();
    private boolean stop = false;
    private boolean shutDown = false;
    private boolean isSecure = true;
    private CLIProxy cli = null;
    private String soapServer = "localhost";
    private boolean userLoggedIn = false;
    private static ResourceBundle resource = ResourceBundle.getBundle("com.sun.netstorage.array.mgmt.cfg.cli.ini.CLIResource", Locale.getDefault());
    private static final String[] REMOVE_OPTIONS_WITH_ARG = new String[]{"-s", "--system-type"};
    protected static int SERVER_TYPE_UNKNOWN = -1;
    protected static int SERVER_TYPE_MR = 1;
    protected static String SERVER_TYPE_MR_ARG1 = "6120";
    protected static String SERVER_TYPE_MR_ARG2 = "6320";
    protected static int SERVER_TYPE_ENT = 2;
    protected static String SERVER_TYPE_ENT_ARG = "6920";
    protected static int SERVER_TYPE_TF = 3;
    protected static String SERVER_TYPE_TF_ARG = "6130";
    private int _serverType = SERVER_TYPE_UNKNOWN;

    public ProxyServerThread(byte[] token, int port) {
        Trace.constructor((Object)this);
        this.token = token;
        this.serverPort = port;
        Trace.verbose((Object)this, (String)"constructor", (String)("token is " + new String(token)));
        Trace.verbose((Object)this, (String)"constructor", (String)("port is " + port));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        String METHOD_NAME = "run";
        String request = "";
        Trace.methodBegin((Object)this, (String)"run");
        try {
            this.setupKeystore();
            ServerSocket server = new ServerSocket(this.getServerPort());
            ProxyServer.setConnected(true);
            this.callObject = new Call();
            while (!this.shutDown) {
                Socket client = null;
                DataInputStream in = null;
                DataOutputStream out = null;
                CommandResult cr = new CommandResult();
                try {
                    Trace.verbose((Object)this, (String)"run", (String)"Waiting for connection");
                    client = server.accept();
                    out = new DataOutputStream(client.getOutputStream());
                    if (this.isLocal(client)) {
                        ProxyServer.setLastConnection(new Date());
                        Trace.verbose((Object)this, (String)"run", (String)"Client connected.");
                        in = new DataInputStream(client.getInputStream());
                        try {
                            cr = this.processRequest(in, out);
                        }
                        catch (Exception cle) {
                            cr.setErrorId(ERROR_CODE);
                            cr.setResult(resource.getString("error.general.systemError"));
                        }
                        if (this.shutDown) {
                            Trace.verbose((Object)this, (String)"run", (String)"SHUTTING DOWN");
                        }
                        this.fixNewLine(cr);
                        Trace.verbose((Object)this, (String)"run", (String)(" return info is:\n  " + cr.getResult()));
                        this.writeOutput(cr.getErrorId(), out, this.token);
                        this.writeOutput(cr.getResult(), out, this.token);
                    } else {
                        this.remoteConnect(client, out, cr);
                    }
                    this.closeSockets(client, in, out);
                }
                catch (IOException ioe) {
                    this.processIOEx(ioe);
                }
                finally {
                    this.closeSockets(client, in, out);
                }
                Trace.verbose((Object)this, (String)"run", (String)(" Shutdown value is " + this.shutDown));
            }
            ProxyServer.setStop(true);
        }
        catch (BindException mre) {
            Trace.verbose((Object)this, (String)"run", (String)(" Couldn't bind to selected port " + this.getServerPort()));
            ProxyServer.setStop(true);
        }
        catch (IOException ioe) {
            Trace.verbose((Object)this, (String)"Problem starting server", (Throwable)ioe);
        }
        Trace.verbose((Object)this, (String)"run", (String)"Method end.");
    }

    private void setupKeystore() {
        String keyStore = System.getProperty("KEYSTORE");
        if (null != keyStore) {
            Trace.verbose((Object)this, (String)"setupKeystore", (String)("Using Keystore (" + keyStore + ")"));
            System.setProperty("javax.net.ssl.trustStore", keyStore);
            System.setProperty("java.protocol.handler.pkgs", "com.sun.net.ssl.internal.www.protocol");
            Security.addProvider((java.security.Provider)new Provider());
        } else {
            Trace.verbose((Object)this, (String)"setupKeystore", (String)"Keystore not specified");
        }
    }

    public void closeSockets(Socket client, DataInputStream in, DataOutputStream out) {
        if (out != null) {
            try {
                out.close();
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        try {
            if (client != null) {
                client.close();
            }
        }
        catch (IOException ioe) {
            // empty catch block
        }
    }

    public void processIOEx(IOException ioe) {
        if (ioe instanceof InterruptedIOException) {
            Trace.verbose((Object)this, (String)"processIOEx", (String)("server timed out on the port" + this.getServerPort()));
            this.shutDown = true;
        } else {
            Trace.verbose((Object)this, (String)"processIOEx", (String)"Problem with accepting connection from client.");
        }
    }

    public void remoteConnect(Socket client, DataOutputStream out, CommandResult cr) throws IOException {
        Trace.verbose((Object)this, (String)"remoteConnect", (String)("Attempted Connection From Non Local Host" + client.getInetAddress().getAddress()));
        cr.setErrorId(ERROR_CODE);
        cr.setResult(resource.getString("error.remote.proxy.connection") + client.getInetAddress().getAddress());
        this.writeOutput(cr.getErrorId(), out, this.token);
        this.writeOutput(cr.getResult(), out, this.token);
    }

    private CommandResult processRequest(DataInputStream in, DataOutputStream out) throws Exception, IOException {
        CommandResult cr = new CommandResult();
        String request = this.readInput(in, this.token);
        if (request != null) {
            try {
                if (request.indexOf("login") >= 0) {
                    cr = this.login(request, in, out);
                } else if (this.userLoggedIn && "logout".equals(request.trim())) {
                    cr = this.logout(request, in, out);
                } else if (this.userLoggedIn) {
                    cr = this.processCommand(request, in, out);
                } else {
                    cr.setResult(resource.getString("login.notLoggedIn"));
                    cr.setErrorId(ERROR_CODE);
                }
            }
            catch (SOAPException se) {
                cr.setErrorId(ERROR_CODE);
                cr.setResult(this.soapServer + ": " + resource.getString("login.unableToConnect"));
            }
            catch (UnknownHostException uhe) {
                cr.setErrorId(ERROR_CODE);
                cr.setResult(this.soapServer + ": " + resource.getString("login.unableToConnect"));
            }
            catch (Exception e) {
                cr.setResult(resource.getString("error.systemError"));
                cr.setErrorId(ERROR_CODE);
            }
        }
        return cr;
    }

    private CommandResult login(String request, DataInputStream in, DataOutputStream out) throws SOAPException, Exception {
        CommandResult result = null;
        String systemTypeArg = null;
        this.resetServerType();
        this.isSecure = true;
        StringTokenizer tokenizer = new StringTokenizer(request, "\n");
        boolean dashHOptionFound = false;
        boolean dashHOptionArgumentFound = false;
        boolean dashSOptionFound = false;
        boolean dashSOptionArgumentOK = false;
        while (tokenizer.hasMoreTokens()) {
            String arg = tokenizer.nextToken();
            if (arg.equals("-h") || arg.equals("--hostname")) {
                dashHOptionFound = true;
                if (!tokenizer.hasMoreTokens()) continue;
                this.soapServer = tokenizer.nextToken();
                dashHOptionArgumentFound = true;
                continue;
            }
            if (arg.equals("-s") || arg.equals("--system-type")) {
                dashSOptionFound = true;
                if (!tokenizer.hasMoreTokens()) continue;
                systemTypeArg = tokenizer.nextToken();
                dashSOptionArgumentOK = this.setServerType(systemTypeArg);
                continue;
            }
            if (!arg.equals("-t") && !arg.equals("--http")) continue;
            this.isSecure = false;
        }
        if (!dashHOptionFound || !dashHOptionArgumentFound || dashSOptionFound && !dashSOptionArgumentOK) {
            result = new CommandResult();
            result.setErrorId(ERROR_CODE);
            result.setResult(resource.getString("login.usage"));
            return result;
        }
        if (dashSOptionFound) {
            request = this.cleanRequest(request);
        }
        request = request + "--sscsversion\n" + this.getSoapProperty("sscs.version", DEFAULT_VERSION);
        if (this._serverType == SERVER_TYPE_UNKNOWN) {
            ProxyServer.setDiscover(true);
        }
        int type = this.getServerType();
        ProxyServer.setDiscover(false);
        if (type == SERVER_TYPE_ENT) {
            this.reInitSession(this.getEnterpriseSoapUrlString());
        } else if (type == SERVER_TYPE_MR) {
            this.reInitSession(this.getMidrangeSoapUrlString());
        } else if (type == SERVER_TYPE_TF) {
            this.reInitSession(this.getTreefrogSoapUrlString());
        } else {
            throw new UnknownHostException();
        }
        result = this.processCommand(request, in, out);
        this.userLoggedIn = SUCCESS_CODE.equals(result.getErrorId());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CommandResult processGetUrl(String url, String request, DataInputStream in, DataOutputStream out) throws Exception {
        int bytesRead;
        byte[] buf;
        boolean done;
        CommandResult result = new CommandResult();
        StringBuffer contents = null;
        InputStream is = null;
        try {
            URL theUrl = new URL(url);
            is = theUrl.openStream();
            contents = new StringBuffer();
            done = false;
            while (!done) {
                buf = new byte[1024];
                bytesRead = is.read(buf);
                if (bytesRead == -1) {
                    done = true;
                    break;
                }
                contents.append(new String(buf));
            }
        }
        catch (Exception e) {
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        if (contents == null) {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(url);
                contents = new StringBuffer();
                done = false;
                while (!done) {
                    buf = new byte[1024];
                    bytesRead = fis.read(buf);
                    if (bytesRead == -1) {
                        done = true;
                        break;
                    }
                    contents.append(new String(buf));
                }
            }
            catch (FileNotFoundException fnfe) {
            }
            finally {
                if (fis != null) {
                    fis.close();
                }
            }
        }
        result = contents != null ? this.processCommand(contents.toString().trim(), in, out) : this.processCommand(null, in, out);
        return result;
    }

    private void reInitSession(String url) throws SOAPException {
        if (this.cli != null) {
            try {
                this.cli.processCommand("logout");
                this.callObject = new Call();
            }
            catch (Exception e) {
                Trace.verbose((Object)this, (String)"reInitSession", (Throwable)e);
            }
        }
        this.cli = new CLIProxy(url, this.callObject);
    }

    private CommandResult logout(String request, DataInputStream in, DataOutputStream out) throws Exception {
        this.shutDown = true;
        return this.processCommand(request, in, out);
    }

    private String readInput(DataInputStream in, byte[] token) throws IOException {
        String METHOD_NAME = "readInput";
        Trace.methodBegin((Object)this, (String)"readInput");
        int howMany = in.readUnsignedByte();
        Trace.verbose((Object)this, (String)"readInput", (String)("There is " + howMany + " to read."));
        if (howMany == 0) {
            howMany = in.readUnsignedShort();
            Trace.verbose((Object)this, (String)"readInput", (String)("reread " + howMany + " to read."));
        }
        byte[] readArray = null;
        if (howMany >= 0) {
            readArray = new byte[howMany];
            for (int i = 0; i < howMany; ++i) {
                Trace.verbose((Object)this, (String)"readInput", (String)("Reading " + i));
                readArray[i] = in.readByte();
            }
        } else {
            throw new IOException("Cannot read " + howMany + " characters.");
        }
        String result = Encoder.decode(readArray, token);
        return result;
    }

    private void writeOutput(String str, DataOutputStream out, byte[] token) throws IOException {
        int i;
        String METHOD_NAME = "writeOutput";
        Trace.methodBegin((Object)this, (String)"writeOutput");
        Trace.verbose((Object)this, (String)"writeOutput", (String)("Writing output " + str));
        byte[] encodedArray = Encoder.encode(str, token);
        int len = encodedArray.length;
        String strLength = String.valueOf(len);
        char[] strLenChars = strLength.toCharArray();
        int lenOfLen = strLenChars.length;
        out.writeByte(lenOfLen);
        for (i = 0; i < lenOfLen; ++i) {
            out.writeByte(strLenChars[i]);
        }
        out.flush();
        for (i = 0; i < len; ++i) {
            out.writeByte(encodedArray[i]);
        }
        out.flush();
    }

    private CommandResult processCommand(String request, DataInputStream in, DataOutputStream out) throws SOAPException {
        String METHOD_NAME = "processCommand";
        Trace.methodBegin((Object)this, (String)"processCommand");
        CommandResult cr = new CommandResult();
        cr.setRequest(request);
        try {
            cr = this.cli.processCommand(request);
            if (cr.getErrorId().equals("25") && request.indexOf("login") == 0) {
                request = request.substring(0, request.indexOf("--sscsversion"));
                cr = this.cli.processCommand(request);
            }
            if (cr.getErrorId().equals("666")) {
                Trace.verbose((Object)this, (String)"processCommand", (String)("get url contents request: " + cr.getResult()));
                return this.processGetUrl(cr.getResult(), request, in, out);
            }
            while (cr.getErrorId().equals(LOGIN_CODE) || cr.getErrorId().equals(LOGIN_NAME)) {
                this.writeOutput(cr.getErrorId(), out, this.token);
                this.writeOutput(cr.getResult(), out, this.token);
                Trace.verbose((Object)this, (String)"processCommand", (String)">>>>>>>>>>>>>>>>>>read input");
                request = this.readInput(in, this.token);
                cr = this.cli.processCommand(request);
                if (cr.getResult() == null || cr.getResult().indexOf("parsing error: org.xml.sax.SAXParseException") < 0) continue;
                cr.setErrorId(ERROR_CODE);
                cr.setResult(resource.getString("error.invalid.input"));
            }
        }
        catch (SOAPException e) {
            Trace.verbose((Object)this, (String)"processCommand", (String)("SoapException: " + (Object)((Object)e)));
            throw e;
        }
        catch (Exception e) {
            Trace.verbose((Object)this, (String)"processCommand", (Throwable)e);
            String msg = e.getMessage();
            String res = resource.getString("system.error");
            if (msg != null && msg.indexOf("SSLHandshakeException") >= 0) {
                res = resource.getString("SSLHandshakeException");
                if (msg.indexOf("trusted cert") >= 0) {
                    res = res + resource.getString("error.trusted.certificate");
                }
            }
            cr.setResult(res);
            cr.setErrorId(ERROR_CODE);
        }
        return cr;
    }

    private boolean isLocal(Socket client) {
        String METHOD_NAME = "isLocal";
        Trace.methodBegin((Object)this, (String)"isLocal");
        InetAddress clientAddress = client.getInetAddress();
        InetAddress localhost = null;
        try {
            localhost = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            Trace.verbose((Object)this, (String)"isLocal", (String)"Exception while trying to get localhost address");
            return false;
        }
        Trace.verbose((Object)this, (String)"isLocal", (String)("Client IP(" + clientAddress.getHostAddress() + ") Hostname(" + clientAddress.getHostName() + ")"));
        Trace.verbose((Object)this, (String)"isLocal", (String)("Client: " + clientAddress.getHostAddress()));
        if (localhost.getHostAddress().equals(clientAddress.getHostAddress()) || "127.0.0.1".equals(clientAddress.getHostAddress())) {
            Trace.verbose((Object)this, (String)"isLocal", (String)"accepting connection");
            return true;
        }
        Trace.verbose((Object)this, (String)"isLocal", (String)"dropping connection");
        Trace.verbose((Object)this, (String)"isLocal", (String)"Method end.");
        return false;
    }

    public byte[] getToken() {
        return this.token;
    }

    public void setToken(byte[] token) {
        this.token = token;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
    }

    protected String getTreefrogSoapUrlString() {
        return this.getSoapUrl(SOAP_URI_TF, "6789", "9080");
    }

    protected String getEnterpriseSoapUrlString() {
        return this.getSoapUrl(SOAP_URI_E, "6789", "9080");
    }

    protected String getMidrangeSoapUrlString() {
        return this.getSoapUrl(SOAP_URI_MR, SOAP_SECURE_PORT_MR, "9080");
    }

    private String getSoapUrl(String uri, String securePort, String openPort) {
        String soapURI = uri;
        soapURI = this.getSoapProperty("soap.uri", soapURI);
        if (this.isSecure) {
            this.soapProtocol = this.getSoapProperty("soap.secure.protocol", SOAP_SECURE_PROTOCOL);
            this.soapPort = this.getSoapProperty("soap.secure.port", securePort);
        } else {
            this.soapProtocol = this.getSoapProperty("soap.open.protocol", SOAP_OPEN_PROTOCOL);
            this.soapPort = this.getSoapProperty("soap.open.port", openPort);
        }
        String url = this.soapProtocol + "://" + this.soapServer + ":" + this.soapPort + "/" + soapURI;
        Trace.verbose((Object)this, (String)"getSoapUrl", (String)url);
        return url;
    }

    private String getSoapProperty(String property, String defaultValue) {
        String value = System.getProperty(property) == null ? defaultValue : System.getProperty(property);
        return value;
    }

    private void fixNewLine(CommandResult cr) {
        String result;
        if (cr.getResult() != null && !"".equals(result = cr.getResult().trim()) && !result.endsWith("\n")) {
            cr.setResult(result + "\n");
        }
    }

    private String cleanRequest(String request) {
        for (int i = 0; i < REMOVE_OPTIONS_WITH_ARG.length; ++i) {
            String arg = REMOVE_OPTIONS_WITH_ARG[i];
            int startIndex = request.indexOf("\n" + arg + "\n");
            if (startIndex <= 0) continue;
            int newline1 = request.indexOf("\n", ++startIndex);
            int newline2 = request.indexOf("\n", newline1 + 1);
            request = request.substring(0, startIndex) + request.substring(newline2 + 1);
        }
        return request;
    }

    private void resetServerType() {
        this._serverType = SERVER_TYPE_UNKNOWN;
    }

    protected boolean setServerType(String type) {
        Trace.verbose((Object)this, (String)"setServerType(String)", (String)("set server type arg: " + type));
        if (type == null) {
            return false;
        }
        if (SERVER_TYPE_TF_ARG.equals(type)) {
            this._serverType = SERVER_TYPE_TF;
        } else if (SERVER_TYPE_ENT_ARG.equals(type)) {
            this._serverType = SERVER_TYPE_ENT;
        } else if (SERVER_TYPE_MR_ARG1.equals(type) || SERVER_TYPE_MR_ARG2.equals(type)) {
            this._serverType = SERVER_TYPE_MR;
        } else {
            return false;
        }
        return true;
    }

    protected synchronized void setServerType(int type) {
        if (this._serverType != SERVER_TYPE_UNKNOWN) {
            return;
        }
        this._serverType = type;
        Trace.verbose((Object)this, (String)"setServerType", (String)("set server type: " + type));
        this.notifyAll();
    }

    protected synchronized int getServerType() {
        Trace.methodBegin((Object)this, (String)"getServerType");
        if (this._serverType == SERVER_TYPE_UNKNOWN) {
            try {
                this.wait(20000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        Trace.verbose((Object)this, (String)"getServerType", (String)("get server type: " + this._serverType));
        return this._serverType;
    }
}

