/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.bui.utilities;

import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.BadParameterException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Validate {
    private static final String IP_PATTERN = "\\d+\\.\\d+\\.\\d+\\.\\d+";
    private static final String EMAIL_PATTERN = "^[a-zA-Z][\\w\\.-]*[a-zA-Z0-9]@[a-zA-Z0-9][\\w\\.-]*[a-zA-Z0-9]\\.[a-zA-Z][a-zA-Z\\.]*[a-zA-Z]$";
    private static final String NET_MASK_PATTERN = "1+0*";
    private static final String OBJECT_NAME_PATTERN = "[a-zA-Z0-9_-]*";
    private static final String OBJECT_NAME_WITH_SPACE_PATTERN = "[a-zA-Z 0-9_-]*";
    private static final String OBJECT_NAME_PATTERN_DESC = "[\\w\\.\\- ]*";
    private static final String NEGATIVE_OBJECT_NAME_PATTERN = "[^a-zA-Z0-9_-]";
    private static final String NEGATIVE_DESC_PATTERN = "[^\\w\\.\\- ]";
    public static String ARRAY_DESC_OBJECT = "Array.Description";
    public static String INITIATOR_DESC_OBJECT = "Initiator.Description";
    public static String PROFILE_DESC_OBJECT = "Profile.Description";
    public static String PROFILE_NAME_OBJECT = "Profile.Name";
    public static final String EMAIL_DELIMITER = ", ";
    static /* synthetic */ Class class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$Validate;

    public static boolean ipAddress(String ipAddress) {
        Trace.methodBegin((Class)(class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$Validate == null ? (class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$Validate = Validate.class$("com.sun.netstorage.array.mgmt.cfg.bui.utilities.Validate")) : class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$Validate), (String)"ipAddress");
        if (!Pattern.matches(IP_PATTERN, ipAddress)) {
            return false;
        }
        try {
            InetAddress address = InetAddress.getByName(ipAddress);
            String hostAddress = address.getHostAddress();
            return ipAddress.equals(hostAddress);
        }
        catch (UnknownHostException e) {
            return false;
        }
        catch (SecurityException e) {
            Trace.error((Class)(class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$Validate == null ? (class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$Validate = Validate.class$("com.sun.netstorage.array.mgmt.cfg.bui.utilities.Validate")) : class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$Validate), (String)"ipAddress", (String)"SecurityException in Validate:ipAddress");
            return true;
        }
    }

    public static boolean netMask(String netMask) {
        Trace.methodBegin((Class)(class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$Validate == null ? (class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$Validate = Validate.class$("com.sun.netstorage.array.mgmt.cfg.bui.utilities.Validate")) : class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$Validate), (String)"netMask");
        try {
            StringTokenizer tokenizer = new StringTokenizer(netMask, ".");
            StringBuffer binaryAddress = new StringBuffer();
            while (tokenizer.hasMoreElements()) {
                binaryAddress.append(Integer.toBinaryString(Integer.parseInt(tokenizer.nextElement().toString())));
            }
            if (Pattern.matches(NET_MASK_PATTERN, binaryAddress.toString())) {
                return true;
            }
        }
        catch (Exception e) {
            Trace.error((Class)(class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$Validate == null ? (class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$Validate = Validate.class$("com.sun.netstorage.array.mgmt.cfg.bui.utilities.Validate")) : class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$Validate), (String)"netMask", (String)e.getMessage());
        }
        return false;
    }

    public static boolean timeString(String dateString, int stylePattern, Locale userLocale) {
        Trace.methodBegin((Class)(class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$Validate == null ? (class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$Validate = Validate.class$("com.sun.netstorage.array.mgmt.cfg.bui.utilities.Validate")) : class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$Validate), (String)"timeString");
        try {
            DateFormat df = DateFormat.getTimeInstance(stylePattern, userLocale);
            df.parse(dateString);
        }
        catch (ParseException e) {
            return false;
        }
        return true;
    }

    public static boolean dateFields(String year, String month, String date) {
        Trace.methodBegin((Class)(class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$Validate == null ? (class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$Validate = Validate.class$("com.sun.netstorage.array.mgmt.cfg.bui.utilities.Validate")) : class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$Validate), (String)"dateFields");
        Calendar calendar = Calendar.getInstance();
        calendar.setLenient(false);
        try {
            int yearInt = Integer.parseInt(year);
            int monthInt = Integer.parseInt(month) - 1;
            int dateInt = Integer.parseInt(date);
            calendar.set(yearInt, monthInt, dateInt);
            calendar.getTime();
        }
        catch (Exception e) {
            Trace.verbose((Class)(class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$Validate == null ? (class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$Validate = Validate.class$("com.sun.netstorage.array.mgmt.cfg.bui.utilities.Validate")) : class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$Validate), (String)"dateFields", (String)"validation error");
            return false;
        }
        return true;
    }

    public static boolean numberInRange(String numberString, int lowest, int highest) {
        try {
            int number = Integer.parseInt(numberString);
            return number >= lowest && number <= highest;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean emailAddress(String emailAddress) {
        if (emailAddress == null) {
            return false;
        }
        return Pattern.matches(EMAIL_PATTERN, emailAddress);
    }

    public static boolean emailAddressList(String emailAddresses) {
        StringTokenizer tokenizer = new StringTokenizer(emailAddresses, EMAIL_DELIMITER);
        while (tokenizer.hasMoreElements()) {
            if (Validate.emailAddress(tokenizer.nextToken())) continue;
            return false;
        }
        return true;
    }

    public static boolean emailAddressList(List emailAddresses) {
        if (emailAddresses == null) {
            return false;
        }
        Iterator addrIterator = emailAddresses.iterator();
        while (addrIterator.hasNext()) {
            if (Validate.emailAddress((String)addrIterator.next())) continue;
            return false;
        }
        return true;
    }

    public static void objectName(String object, String nameForValidation) throws BadParameterException {
        String pattern = OBJECT_NAME_PATTERN;
        String negPattern = NEGATIVE_OBJECT_NAME_PATTERN;
        String exceptionKey = "error.bizobj.invalidCharacter";
        if (object != null) {
            if (object.equals(ARRAY_DESC_OBJECT) || object.equals(INITIATOR_DESC_OBJECT) || object.equals(PROFILE_DESC_OBJECT)) {
                pattern = OBJECT_NAME_PATTERN_DESC;
                negPattern = NEGATIVE_DESC_PATTERN;
                exceptionKey = "error.bizobj.invalidDescCharacter";
            } else if (object.equals(PROFILE_NAME_OBJECT)) {
                pattern = OBJECT_NAME_WITH_SPACE_PATTERN;
            }
        }
        Validate.validateName(pattern, negPattern, nameForValidation, exceptionKey);
    }

    public static void validateName(String pattern, String negativePattern, String nameForValidation) throws BadParameterException {
        Validate.validateName(pattern, negativePattern, nameForValidation, "error.bizobj.invalidDescCharacter");
    }

    public static void validateName(String pattern, String negativePattern, String nameForValidation, String exceptionKey) throws BadParameterException {
        if (nameForValidation == null || nameForValidation.trim().length() == 0) {
            throw new BadParameterException("", "error.bizobj.noName");
        }
        if (!Pattern.matches(pattern, nameForValidation)) {
            Pattern p = Pattern.compile(negativePattern);
            Matcher m = p.matcher(nameForValidation);
            int start = 0;
            String invalidChar = "";
            while (m.find()) {
                start = m.start();
                invalidChar = invalidChar + nameForValidation.substring(start, start + 1);
            }
            throw new BadParameterException(invalidChar, exceptionKey);
        }
    }

    public static void validateNameLength(String name, int maxAllowedLength) throws BadParameterException {
        Validate.validateNameLength(name, maxAllowedLength, "error.bizobj.nameTooLongMaxLength");
    }

    public static void validateNameLength(String name, int maxAllowedLenght, String exceptionKey) throws BadParameterException {
        String methodName = "validateNameLength";
        Trace.methodBegin((Class)(class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$Validate == null ? (class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$Validate = Validate.class$("com.sun.netstorage.array.mgmt.cfg.bui.utilities.Validate")) : class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$Validate), (String)methodName);
        if (name != null && name.length() > maxAllowedLenght) {
            Trace.verbose((Class)(class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$Validate == null ? (class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$Validate = Validate.class$("com.sun.netstorage.array.mgmt.cfg.bui.utilities.Validate")) : class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$Validate), (String)methodName, (String)"Name is too long");
            throw new BadParameterException(new String[]{name.substring(0, maxAllowedLenght - 1) + "...", "" + maxAllowedLenght}, exceptionKey);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

