/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.bui.utilities;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.RequestHandlingViewBase;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.ViewBeanBase;
import com.iplanet.jato.view.html.Option;
import com.iplanet.jato.view.html.OptionList;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.CoreViewBean;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.SEAlert;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.SizeConvert;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Constants;
import com.sun.netstorage.array.mgmt.cfg.core.MethodCallStatus;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.ini.Repository;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.ManageDataServicesFactory;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.ManageMirrorServicesEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.MirrorComponentEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.MirroredVolumeEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStoragePoolsFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StoragePoolInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageVolumeEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.ManageStoragePools;
import com.sun.netstorage.array.mgmt.cfg.ui.core.data.ActiveUserInfo;
import com.sun.netstorage.array.mgmt.cfg.util.ItemNotFoundException;
import com.sun.netstorage.array.mgmt.cfg.util.Size;
import com.sun.netstorage.mgmt.dm.util.authorization.AuthorizationUtility;
import com.sun.web.ui.model.CCMastheadModel;
import com.sun.web.ui.model.CCMastheadModelInterface;
import com.sun.web.ui.view.html.CCOption;
import com.sun.web.ui.view.masthead.CCPrimaryMasthead;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class UIUtil {
    public static String USER_ROLE_ADMIN = "admin";
    public static String USER_ROLE_STORAGE = "storage";
    public static String USER_ROLE_GUEST = "guest";
    public static String USER_ROLE_ROOT = "root";
    public static boolean ROOT_EXCLUSIVE = true;
    public static boolean ADMIN_EXCLUSIVE = true;
    public static boolean STORAGE_EXCLUSIVE = true;
    public static boolean GUEST_EXCLUSIVE = false;
    public static String[] ROOT_EXCLUSIVE_ROLES = new String[]{USER_ROLE_ROOT, USER_ROLE_ADMIN, USER_ROLE_STORAGE};
    public static String[] STORAGE_EXCLUSIVE_ROLES = new String[]{USER_ROLE_ROOT, USER_ROLE_STORAGE};
    public static String[] ADMIN_EXCLUSIVE_ROLES = new String[]{USER_ROLE_ROOT, USER_ROLE_ADMIN};
    public static final String EXCLUSIVE_ACCESS = "EXCLUSIVE_ROLE_ACCESS";
    public static String NO_DOMAIN_ID = "";
    static /* synthetic */ Class class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$UIUtil;
    static /* synthetic */ Class class$com$sun$web$ui$view$html$CCTextField;

    public static String getMultiplierSuffix(String Multiplier) {
        String UIStr = "";
        try {
            BigDecimal mx = new BigDecimal(Multiplier);
            if (mx.equals(Constants.StorageSize.ONE_TB)) {
                UIStr = UIUtil.getBUIString("se6x20ui.sizesuffix.TB");
            } else if (mx.equals(Constants.StorageSize.ONE_GB)) {
                UIStr = UIUtil.getBUIString("se6x20ui.sizesuffix.GB");
            } else if (mx.equals(Constants.StorageSize.ONE_MB)) {
                UIStr = UIUtil.getBUIString("se6x20ui.sizesuffix.MB");
            } else if (mx.equals(Constants.StorageSize.ONE_KB)) {
                UIStr = UIUtil.getBUIString("se6x20ui.sizesuffix.KB");
            } else if (mx.equals(Constants.StorageSize.ONE_BLOCK)) {
                UIStr = UIUtil.getBUIString("se6x20ui.sizesuffix.Blocks");
            } else if (mx.equals(Constants.StorageSize.ONE_BYTE)) {
                UIStr = UIUtil.getBUIString("se6x20ui.sizesuffix.Bytes");
            }
        }
        catch (NumberFormatException nfe) {
            Trace.error((Class)(class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$UIUtil == null ? (class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$UIUtil = UIUtil.class$("com.sun.netstorage.array.mgmt.cfg.bui.utilities.UIUtil")) : class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$UIUtil), (String)"getMultiplierSuffix", (String)"Invalid multiplier");
        }
        return UIStr;
    }

    public static CCPrimaryMasthead mastheadCreate(ViewBeanBase viewBean, String name) {
        CCPrimaryMasthead child = new CCPrimaryMasthead((ContainerView)viewBean, null, name);
        child.registerChild("SearchValue", class$com$sun$web$ui$view$html$CCTextField == null ? (class$com$sun$web$ui$view$html$CCTextField = UIUtil.class$("com.sun.web.ui.view.html.CCTextField")) : class$com$sun$web$ui$view$html$CCTextField);
        CCMastheadModel mhmodel = new CCMastheadModel();
        mhmodel.setSrc("masthead.logo");
        mhmodel.setWidth(UIUtil.getBUIString("masthead.width"));
        mhmodel.setHeight(UIUtil.getBUIString("masthead.height"));
        mhmodel.setAlt("masthead.altText");
        mhmodel.setShowUserRole(true);
        mhmodel.setShowServer(true);
        child.setCCMastheadModel((CCMastheadModelInterface)mhmodel);
        return child;
    }

    public static void underConstructionAlert(ViewBean targetView, RequestHandlingViewBase view, String msg) throws ServletException, IOException {
        SEAlert.underConstruction((CoreViewBean)targetView, msg);
    }

    public static Locale getLocale() {
        RequestContext rq = RequestManager.getRequestContext();
        HttpServletRequest httprq = rq.getRequest();
        return httprq.getLocale();
    }

    public static String getBUINumber(BigDecimal number) {
        NumberFormat nf = NumberFormat.getInstance(UIUtil.getLocale());
        nf.setMaximumFractionDigits(3);
        nf.setMinimumFractionDigits(3);
        return nf.format(number);
    }

    public static String getDisplaySize(Size size) {
        String locUnit = UIUtil.getBUIString("sizesuffix." + size.getUnit());
        return size.getConvertedSizeStr() + " " + locUnit;
    }

    public static String getBUIString(String key) {
        if ("".equals(key)) {
            return key;
        }
        String retStr = key;
        try {
            ResourceBundle res = ResourceBundle.getBundle("com.sun.netstorage.array.mgmt.cfg.bui.resources.Resources", UIUtil.getLocale());
            retStr = res.getString(key);
        }
        catch (Exception e) {
            Trace.verbose((Class)(class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$UIUtil == null ? (class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$UIUtil = UIUtil.class$("com.sun.netstorage.array.mgmt.cfg.bui.utilities.UIUtil")) : class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$UIUtil), (String)"getBUIString", (String)("Resource key not found: " + key));
        }
        return retStr;
    }

    public static String getBUIString1Subst(String key, String subst1) {
        MessageFormat msgFmt = new MessageFormat(UIUtil.getBUIString(key));
        Object[] args = new Object[]{subst1};
        return msgFmt.format(args);
    }

    public static String getBUIString2Subst(String key, String subst1, String subst2) {
        MessageFormat msgFmt = new MessageFormat(UIUtil.getBUIString(key));
        Object[] args = new Object[]{subst1, subst2};
        return msgFmt.format(args);
    }

    public static String getBUIString3Subst(String key, String subst1, String subst2, String subst3) {
        MessageFormat msgFmt = new MessageFormat(UIUtil.getBUIString(key));
        Object[] args = new Object[]{subst1, subst2, subst3};
        return msgFmt.format(args);
    }

    public static String getBUIString(String key, String[] args) {
        MessageFormat msgFmt = new MessageFormat(UIUtil.getBUIString(key));
        return msgFmt.format(args);
    }

    public static String ConstantListToStringList(String bundleBaseName, String resPrefix, Set constantList, String resDelimiter) {
        String stringList = new String();
        boolean bFirst = true;
        try {
            ResourceBundle res = ResourceBundle.getBundle(bundleBaseName, UIUtil.getLocale());
            String delim = res.getString(resDelimiter);
            Iterator it = constantList.iterator();
            while (it.hasNext()) {
                Integer value = (Integer)it.next();
                if (!bFirst) {
                    stringList = stringList.concat(delim);
                }
                stringList = stringList.concat(res.getString(resPrefix + value.toString()));
                bFirst = false;
            }
        }
        catch (Exception e) {
            System.out.println("UIUtil::ConstantListToStringList - Returning 'UNDEFINED' indicator: " + e.toString());
            stringList = "---";
        }
        return stringList;
    }

    public static boolean isMCSSuccess(MethodCallStatus status) {
        return status == null || status.getReturnCode() == 0;
    }

    public static ConfigContext getConfigContext() {
        RequestContext rq = RequestManager.getRequestContext();
        HttpServletRequest httprq = rq.getRequest();
        HttpSession session = httprq.getSession();
        return (ConfigContext)session.getAttribute("ConfigContext");
    }

    public static boolean isReadWrite(Class clazz) {
        RequestContext rq = RequestManager.getRequestContext();
        HttpServletRequest request = rq.getRequest();
        HttpSession session = request.getSession();
        ActiveUserInfo aui = (ActiveUserInfo)((Object)session.getAttribute("UserInfo"));
        if (aui != null) {
            return UIUtil.isReadWrite(clazz, aui.username);
        }
        return false;
    }

    public static boolean isReadWrite(Class clazz, String user) {
        HttpSession session;
        HttpServletRequest request;
        boolean isLocked = false;
        RequestContext rq = RequestManager.getRequestContext();
        if (rq != null && (request = rq.getRequest()) != null && (session = request.getSession()) != null) {
            Boolean isLockedB = (Boolean)session.getAttribute("ArrayLocked");
            isLocked = isLockedB == null ? false : isLockedB;
        }
        return AuthorizationUtility.getInstance().checkAuthName(user, clazz.getPackage().getName()) && !isLocked;
    }

    public static boolean isExclusive(String role) {
        Repository rep = Repository.getRepository();
        if (rep.getProperty((Object)EXCLUSIVE_ACCESS) != null && "true".equals((String)rep.getProperty((Object)EXCLUSIVE_ACCESS))) {
            return USER_ROLE_ROOT.equals(role) || USER_ROLE_ADMIN.equals(role) || USER_ROLE_STORAGE.equals(role);
        }
        return false;
    }

    public static String[] getExclusiveRoles(String role) {
        if (USER_ROLE_ROOT.equals(role)) {
            return ROOT_EXCLUSIVE_ROLES;
        }
        if (USER_ROLE_ADMIN.equals(role)) {
            return ADMIN_EXCLUSIVE_ROLES;
        }
        if (USER_ROLE_STORAGE.equals(role)) {
            return STORAGE_EXCLUSIVE_ROLES;
        }
        return null;
    }

    public static String timeStamp() {
        Calendar timeStamp = Calendar.getInstance();
        String year = Integer.toString(timeStamp.get(1));
        year = year.substring(year.length() - 2) + year.substring(year.length());
        String month = "0" + Integer.toString(timeStamp.get(2));
        month = month.substring(month.length() - 2) + month.substring(month.length());
        String day = "0" + Integer.toString(timeStamp.get(8));
        day = day.substring(day.length() - 2) + day.substring(day.length());
        String hour = "0" + Integer.toString(timeStamp.get(11));
        hour = hour.substring(hour.length() - 2) + hour.substring(hour.length());
        String min = "0" + Integer.toString(timeStamp.get(12));
        min = min.substring(min.length() - 2) + min.substring(min.length());
        String second = "0" + Integer.toString(timeStamp.get(13));
        second = second.substring(second.length() - 2) + second.substring(second.length());
        String ts = year + month + day + hour + min + second;
        return ts;
    }

    public static String getElapsedTime(Date time1, Date time2, String fmtStr) {
        long t1 = time1.getTime();
        long t2 = time2.getTime();
        int seconds = (int)Math.abs(t2 / 1000L - t1 / 1000L);
        int secInHour = 3600;
        int hours = seconds / secInHour;
        int secInMin = 60;
        int minutes = (seconds -= hours * secInHour) / secInMin;
        DecimalFormat df = new DecimalFormat("00");
        String[] args = new String[]{"", "", "", ""};
        args[1] = df.format(hours);
        args[2] = df.format(minutes);
        args[3] = df.format(seconds -= minutes * secInMin);
        return UIUtil.getBUIString(fmtStr, args);
    }

    public static String getTimeRemaining(Date time1, Date time2, int percentComplete, String fmtStr) {
        if (percentComplete == 100 || percentComplete == 0) {
            return UIUtil.getBUIString("se6920ui.bui.notavailable");
        }
        long t1 = time1.getTime();
        long t2 = time2.getTime();
        long elapsedTime = t2 - t1;
        long completeTime = elapsedTime * 100L / (long)percentComplete;
        long remainingTime = completeTime - elapsedTime;
        int seconds = (int)Math.abs(remainingTime / 1000L);
        int secInHour = 3600;
        int hours = seconds / secInHour;
        int secInMin = 60;
        int minutes = (seconds -= hours * secInHour) / secInMin;
        DecimalFormat df = new DecimalFormat("00");
        String[] args = new String[]{"", "", "", ""};
        args[1] = df.format(hours);
        args[2] = df.format(minutes);
        args[3] = df.format(seconds -= minutes * secInMin);
        return UIUtil.getBUIString(fmtStr, args);
    }

    public static int getInitParamInt(String key) {
        int value = -1;
        Repository repository = Repository.getRepository();
        String property = (String)repository.getProperty((Object)key);
        if (property != null) {
            value = Integer.parseInt(property);
            Trace.verbose((Class)(class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$UIUtil == null ? (class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$UIUtil = UIUtil.class$("com.sun.netstorage.array.mgmt.cfg.bui.utilities.UIUtil")) : class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$UIUtil), (String)"getInitParamInt", (String)("Value retrieved for " + key + ": " + value));
        } else {
            Trace.error((Class)(class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$UIUtil == null ? (class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$UIUtil = UIUtil.class$("com.sun.netstorage.array.mgmt.cfg.bui.utilities.UIUtil")) : class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$UIUtil), (String)"getInitParamInt", (String)("No value retrieved for " + key + ", returning -1"));
        }
        return value;
    }

    public static String getEnglishBUIString(String key) {
        String retStr = key;
        try {
            ResourceBundle res = ResourceBundle.getBundle("com.sun.netstorage.array.mgmt.cfg.bui.resources.Resources", Locale.ENGLISH);
            retStr = res.getString(key);
        }
        catch (Exception e) {
            Trace.verbose((Class)(class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$UIUtil == null ? (class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$UIUtil = UIUtil.class$("com.sun.netstorage.array.mgmt.cfg.bui.utilities.UIUtil")) : class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$UIUtil), (String)"getEnglishBUIString", (String)("Resource key not found: " + key));
        }
        return retStr;
    }

    public static String getEnglishBUIString1Subst(String key, String subst1) {
        MessageFormat msgFmt = new MessageFormat(UIUtil.getEnglishBUIString(key));
        Object[] args = new Object[]{subst1};
        return msgFmt.format(args);
    }

    public static String getEnglishBUIString2Subst(String key, String subst1, String subst2) {
        MessageFormat msgFmt = new MessageFormat(UIUtil.getEnglishBUIString(key));
        Object[] args = new Object[]{subst1, subst2};
        return msgFmt.format(args);
    }

    public static String getEnglishBUIString3Subst(String key, String subst1, String subst2, String subst3) {
        MessageFormat msgFmt = new MessageFormat(UIUtil.getEnglishBUIString(key));
        Object[] args = new Object[]{subst1, subst2, subst3};
        return msgFmt.format(args);
    }

    public static String getEnglishBUIString(String key, String[] args) {
        MessageFormat msgFmt = new MessageFormat(UIUtil.getEnglishBUIString(key));
        return msgFmt.format(args);
    }

    public static String getNetworkIpAddress() {
        RequestContext rq = RequestManager.getRequestContext();
        HttpServletRequest httprq = rq.getRequest();
        String ipAddress = httprq.getServerName();
        Trace.verbose((Class)(class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$UIUtil == null ? (class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$UIUtil = UIUtil.class$("com.sun.netstorage.array.mgmt.cfg.bui.utilities.UIUtil")) : class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$UIUtil), (String)"getNetworkIpAddress", (String)("ipAddress (or name): " + ipAddress));
        return ipAddress;
    }

    public static OptionList getVolumeSnapshotPolicyOptionList() {
        OptionList optionList = new OptionList();
        for (int i = 0; i < StorageVolumeEnt1Interface.VOLUME_SNAPSHOT_POLICY_VALUES.length; ++i) {
            int policy = StorageVolumeEnt1Interface.VOLUME_SNAPSHOT_POLICY_VALUES[i];
            String label = UIUtil.getBUIString("se6920.volume.snapshot.policy." + policy);
            String value = Integer.toString(policy);
            CCOption option = new CCOption(label, value);
            optionList.add((Option)option);
        }
        return optionList;
    }

    public static OptionList getVolumeSnapshotActivityOptionList() {
        OptionList optionList = new OptionList();
        for (int i = 0; i < StorageVolumeEnt1Interface.VOLUME_SNAPSHOT_ACTIVITY_LEVELS.length; ++i) {
            int level = StorageVolumeEnt1Interface.VOLUME_SNAPSHOT_ACTIVITY_LEVELS[i];
            String label = UIUtil.getBUIString("se6920.volume.snapshot.activitylevel." + level);
            String value = Integer.toString(level);
            CCOption option = new CCOption(UIUtil.getBUIString2Subst("se6x20ui.volumesnapshot.activityoption", label, value), value);
            optionList.add((Option)option);
        }
        return optionList;
    }

    public static OptionList getVolumeSnapshotNumSnapsOptionList(boolean includeNone) {
        int start;
        OptionList optionList = new OptionList();
        for (int i = start = includeNone ? 0 : 1; i <= 32; ++i) {
            String label = UIUtil.getBUIString("se6x20ui.volumesnapshot.numsnaps." + i);
            String value = Integer.toString(i);
            CCOption option = new CCOption(label, value);
            optionList.add((Option)option);
        }
        return optionList;
    }

    public static OptionList getVolumeSnapshotAllocateFromOptionList(String domainName, boolean bIncludeNone) {
        OptionList optionList = new OptionList();
        ArrayList poolList = null;
        if (bIncludeNone) {
            optionList.add("se6x20ui.wizards.volume.NewVolumeSnapshotPage.AllocateFromOption.NoneAllocated", NO_DOMAIN_ID);
        }
        ConfigContext cfgctx = UIUtil.getConfigContext();
        ManageStoragePools mgr = (ManageStoragePools)ManageStoragePoolsFactory.getManager();
        Trace.verbose((Class)(class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$UIUtil == null ? (class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$UIUtil = UIUtil.class$("com.sun.netstorage.array.mgmt.cfg.bui.utilities.UIUtil")) : class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$UIUtil), (String)"createVolumeSnapshotAllocateFromOptionList", (String)("Get suitable pools in domain: " + domainName));
        try {
            mgr.init(cfgctx, null);
            Trace.verbose((Class)(class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$UIUtil == null ? (class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$UIUtil = UIUtil.class$("com.sun.netstorage.array.mgmt.cfg.bui.utilities.UIUtil")) : class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$UIUtil), (String)"createAllocateFromOptionList", (String)"Init complete...");
            poolList = mgr.getItemsForSnapshotSpace(domainName);
        }
        catch (ConfigMgmtException cex) {
            Trace.error((Class)(class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$UIUtil == null ? (class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$UIUtil = UIUtil.class$("com.sun.netstorage.array.mgmt.cfg.bui.utilities.UIUtil")) : class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$UIUtil), (String)"createVolumeSnapshotAllocateFromOptionList", (String)"ConfigMgmtException: Error getting list of suitable storage pools.");
        }
        catch (ItemNotFoundException iex) {
            Trace.error((Class)(class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$UIUtil == null ? (class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$UIUtil = UIUtil.class$("com.sun.netstorage.array.mgmt.cfg.bui.utilities.UIUtil")) : class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$UIUtil), (String)"createVolumeSnapshotAllocateFromOptionList", (String)"ItemNotFoundException: Error getting list of suitable storage pools.");
        }
        if (poolList != null && poolList.size() > 0) {
            Trace.verbose((Class)(class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$UIUtil == null ? (class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$UIUtil = UIUtil.class$("com.sun.netstorage.array.mgmt.cfg.bui.utilities.UIUtil")) : class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$UIUtil), (String)"createVolumeSnapshotAllocateFromOptionList", (String)("Suitable pool list, size: " + poolList.size()));
            StoragePoolInterface pool = null;
            Iterator it = poolList.iterator();
            while (it.hasNext()) {
                pool = (StoragePoolInterface)it.next();
                String poolName = pool.getName();
                String poolCapacity = SizeConvert.bytesStringToDisplayValue(pool.getUnAllocatedCapacity().toString()).toLocalizedString();
                CCOption option = new CCOption(UIUtil.getBUIString2Subst("se6x20ui.wizards.volume.NewVolumeSnapshotPage.AllocateFromOption", poolName, poolCapacity), poolName);
                optionList.add((Option)option);
            }
        } else {
            Trace.verbose((Class)(class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$UIUtil == null ? (class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$UIUtil = UIUtil.class$("com.sun.netstorage.array.mgmt.cfg.bui.utilities.UIUtil")) : class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$UIUtil), (String)"createVolumeSnapshotAllocateFromOptionList", (String)"NO suitable pools");
            CCOption option = new CCOption("se6x20ui.wizards.volume.NewVolumeSnapshotPage.AllocateFromOption.NoneAvailable", NO_DOMAIN_ID);
            optionList.add((Option)option);
        }
        return optionList;
    }

    public static BigInteger getUISizeEditValue(String decimalStr, String unit) throws NumberFormatException {
        BigInteger value = BigInteger.ZERO;
        BigDecimal decimal = new BigDecimal(decimalStr);
        BigDecimal multiplier = new BigDecimal(unit);
        decimal = decimal.multiply(multiplier);
        decimal = decimal.setScale(0, 4);
        value = decimal.toBigInteger();
        return value;
    }

    public static OptionList getSnapshotMirrorComponentsOptionList(String mirrorName, String domainName, boolean bIncludeNone) {
        OptionList optionList = new OptionList();
        ArrayList componentList = null;
        if (bIncludeNone) {
            optionList.add("se6x20ui.wizards.volume.NewVolumeSnapshotPage.MirrorComponentOption.NoneSelected", NO_DOMAIN_ID);
        }
        ConfigContext cfgctx = UIUtil.getConfigContext();
        ManageMirrorServicesEnt1Interface mms = (ManageMirrorServicesEnt1Interface)ManageDataServicesFactory.getMirrorServicesManager((ConfigContext)cfgctx);
        MirroredVolumeEnt1Interface mirVol = null;
        Trace.verbose((Class)(class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$UIUtil == null ? (class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$UIUtil = UIUtil.class$("com.sun.netstorage.array.mgmt.cfg.bui.utilities.UIUtil")) : class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$UIUtil), (String)"createSnapshotMirrorComponentsOptionList", (String)"Get mirror components: ");
        try {
            mms.init(cfgctx, null, null);
            Trace.verbose((Class)(class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$UIUtil == null ? (class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$UIUtil = UIUtil.class$("com.sun.netstorage.array.mgmt.cfg.bui.utilities.UIUtil")) : class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$UIUtil), (String)"createSnapshotMirrorComponentsOptionList", (String)"Init complete...");
            mirVol = (MirroredVolumeEnt1Interface)mms.getMirroredVolumeByName(mirrorName, domainName);
            if (mirVol != null) {
                componentList = mirVol.getAssociatedComponents();
            }
        }
        catch (ConfigMgmtException cex) {
            Trace.error((Class)(class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$UIUtil == null ? (class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$UIUtil = UIUtil.class$("com.sun.netstorage.array.mgmt.cfg.bui.utilities.UIUtil")) : class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$UIUtil), (String)"createSnapshotMirrorComponentsOptionList", (String)"ConfigMgmtException: Error getting mirror components.");
        }
        if (componentList != null && componentList.size() > 0) {
            Trace.verbose((Class)(class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$UIUtil == null ? (class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$UIUtil = UIUtil.class$("com.sun.netstorage.array.mgmt.cfg.bui.utilities.UIUtil")) : class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$UIUtil), (String)"createSnapshotMirrorComponentsOptionList", (String)("Suitable component list, size: " + componentList.size()));
            MirrorComponentEnt1Interface component = null;
            Iterator it = componentList.iterator();
            while (it.hasNext()) {
                component = (MirrorComponentEnt1Interface)it.next();
                String componentName = component.getName();
                CCOption option = new CCOption(componentName, componentName);
                optionList.add((Option)option);
            }
        } else {
            Trace.verbose((Class)(class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$UIUtil == null ? (class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$UIUtil = UIUtil.class$("com.sun.netstorage.array.mgmt.cfg.bui.utilities.UIUtil")) : class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$UIUtil), (String)"createSnapshotMirrorComponentsOptionList", (String)"NO suitable components");
            CCOption option = new CCOption("se6x20ui.wizards.volume.NewVolumeSnapshotPage.MirrorComponentOption.NoneAvailable", NO_DOMAIN_ID);
            optionList.add((Option)option);
        }
        return optionList;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

