/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.bui.utilities;

import com.sun.netstorage.array.mgmt.cfg.bui.utilities.Size;
import com.sun.netstorage.array.mgmt.cfg.core.Constants;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SizeConvert {
    static /* synthetic */ Class class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$SizeConvert;

    public static Size bytesStringToDisplayValue(String bytes) {
        Size size = null;
        try {
            BigDecimal bdSize = new BigDecimal(bytes);
            String unit = "Bytes";
            bdSize = bdSize.setScale(4, 1);
            if (bdSize.compareTo(Constants.StorageSize.ONE_TB) >= 0) {
                bdSize = bdSize.divide(Constants.StorageSize.ONE_TB, 1);
                unit = "TB";
            } else if (bdSize.compareTo(Constants.StorageSize.ONE_GB) >= 0) {
                bdSize = bdSize.divide(Constants.StorageSize.ONE_GB, 1);
                unit = "GB";
            } else if (bdSize.compareTo(Constants.StorageSize.ONE_MB) >= 0) {
                bdSize = bdSize.divide(Constants.StorageSize.ONE_MB, 1);
                unit = "MB";
            } else if (bdSize.compareTo(Constants.StorageSize.ONE_KB) >= 0) {
                bdSize = bdSize.divide(Constants.StorageSize.ONE_KB, 1);
                unit = "KB";
            } else if (bdSize.compareTo(Constants.StorageSize.ONE_BLOCK) >= 0) {
                bdSize = bdSize.divide(Constants.StorageSize.ONE_BLOCK, 1);
                unit = "BLK";
            }
            size = new Size(bdSize, unit);
            Trace.verbose((Class)(class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$SizeConvert == null ? (class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$SizeConvert = SizeConvert.class$("com.sun.netstorage.array.mgmt.cfg.bui.utilities.SizeConvert")) : class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$SizeConvert), (String)"bytesStringToDisplayValue", (String)("Returning Display conversion string = " + size.toString()));
        }
        catch (ArithmeticException ae) {
            Trace.verbose((Class)(class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$SizeConvert == null ? (class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$SizeConvert = SizeConvert.class$("com.sun.netstorage.array.mgmt.cfg.bui.utilities.SizeConvert")) : class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$SizeConvert), (String)"Exception trying to convert bytes to DisplayValue", (Throwable)ae);
        }
        return size;
    }

    public static BigInteger stringToBytes(String size) {
        Pattern sizePattern = null;
        Matcher sizeMatch = null;
        BigInteger sizeInBytes = BigInteger.ZERO;
        sizePattern = Pattern.compile("\\s*([1-9]{1})\\s*T{1}B?\\s*", 2);
        sizeMatch = sizePattern.matcher(size);
        if (sizeMatch.matches()) {
            sizeInBytes = new BigInteger(sizeMatch.group(1));
            sizeInBytes = sizeInBytes.multiply(Constants.StorageSize.ONE_TB.toBigInteger());
        } else {
            sizePattern = Pattern.compile("\\s*([1-9]{1}\\d{0,3})\\s*G{1}B?\\s*", 2);
            sizeMatch = sizePattern.matcher(size);
            if (sizeMatch.matches()) {
                sizeInBytes = new BigInteger(sizeMatch.group(1));
                sizeInBytes = sizeInBytes.multiply(Constants.StorageSize.ONE_GB.toBigInteger());
            } else {
                sizePattern = Pattern.compile("\\s*([1-9]{1}\\d{0,6})\\s*M{1}B?\\s*", 2);
                sizeMatch = sizePattern.matcher(size);
                if (sizeMatch.matches()) {
                    sizeInBytes = new BigInteger(sizeMatch.group(1));
                    sizeInBytes = sizeInBytes.multiply(Constants.StorageSize.ONE_MB.toBigInteger());
                } else {
                    sizePattern = Pattern.compile("\\s*([1-9]{1}\\d{0,9})\\s*K{1}B?\\s*", 2);
                    sizeMatch = sizePattern.matcher(size);
                    if (sizeMatch.matches()) {
                        sizeInBytes = new BigInteger(sizeMatch.group(1));
                        sizeInBytes = sizeInBytes.multiply(Constants.StorageSize.ONE_KB.toBigInteger());
                    }
                }
            }
        }
        return sizeInBytes;
    }

    public static String bytesToGB(BigInteger bytes) {
        String size = "";
        try {
            if (bytes != null) {
                size = SizeConvert.bytesStringToGB(bytes.toString());
            }
        }
        catch (Exception ae) {
            Trace.verbose((Class)(class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$SizeConvert == null ? (class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$SizeConvert = SizeConvert.class$("com.sun.netstorage.array.mgmt.cfg.bui.utilities.SizeConvert")) : class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$SizeConvert), (String)"Exception trying to convert bytes to GB", (Throwable)ae);
        }
        return size;
    }

    public static String bytesStringToGB(String bytes) {
        String size = "";
        try {
            BigDecimal bdSize = new BigDecimal(bytes);
            bdSize = bdSize.setScale(2, 1);
            bdSize = bdSize.divide(Constants.StorageSize.ONE_GB, 1);
            size = bdSize.toString();
            Trace.verbose((Class)(class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$SizeConvert == null ? (class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$SizeConvert = SizeConvert.class$("com.sun.netstorage.array.mgmt.cfg.bui.utilities.SizeConvert")) : class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$SizeConvert), (String)"bytesStringToGB", (String)("Returning gb conversion string = " + size));
        }
        catch (ArithmeticException ae) {
            Trace.verbose((Class)(class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$SizeConvert == null ? (class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$SizeConvert = SizeConvert.class$("com.sun.netstorage.array.mgmt.cfg.bui.utilities.SizeConvert")) : class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$SizeConvert), (String)"Exception trying to convert bytes to GB", (Throwable)ae);
        }
        return size;
    }

    public static String bytesStringToMBOrGB(String bytes) {
        String methodName = "bytesStringToMBOrGB";
        String size = "";
        try {
            BigDecimal bdSize = new BigDecimal(bytes);
            bdSize = bdSize.setScale(2, 0);
            if (bdSize.compareTo(Constants.StorageSize.ONE_GB) == -1) {
                Trace.verbose((Class)(class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$SizeConvert == null ? (class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$SizeConvert = SizeConvert.class$("com.sun.netstorage.array.mgmt.cfg.bui.utilities.SizeConvert")) : class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$SizeConvert), (String)methodName, (String)"Given bytes size is less than 1 GB; convert to MB!");
                bdSize = bdSize.divide(Constants.StorageSize.ONE_MB, 0);
            } else {
                Trace.verbose((Class)(class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$SizeConvert == null ? (class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$SizeConvert = SizeConvert.class$("com.sun.netstorage.array.mgmt.cfg.bui.utilities.SizeConvert")) : class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$SizeConvert), (String)methodName, (String)"Given bytes size is greater than 1 GB; convert to GB!");
                bdSize = bdSize.divide(Constants.StorageSize.ONE_GB, 0);
            }
            size = bdSize.toString();
            if (size != null && size.indexOf(".") < 0) {
                size = size + ".00";
            }
            Trace.verbose((Class)(class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$SizeConvert == null ? (class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$SizeConvert = SizeConvert.class$("com.sun.netstorage.array.mgmt.cfg.bui.utilities.SizeConvert")) : class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$SizeConvert), (String)methodName, (String)("Returning conversion string = " + size));
        }
        catch (ArithmeticException ae) {
            Trace.verbose((Class)(class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$SizeConvert == null ? (class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$SizeConvert = SizeConvert.class$("com.sun.netstorage.array.mgmt.cfg.bui.utilities.SizeConvert")) : class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$SizeConvert), (String)"Exception trying to convert bytes to MB or GB", (Throwable)ae);
        }
        return size;
    }

    public static String getMBOrGBString(String bytes) {
        String methodName = "getMBOrGBString";
        try {
            BigDecimal bdSize = new BigDecimal(bytes);
            bdSize = bdSize.setScale(2, 0);
            if (bdSize.compareTo(Constants.StorageSize.ONE_GB) == -1) {
                Trace.verbose((Class)(class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$SizeConvert == null ? (class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$SizeConvert = SizeConvert.class$("com.sun.netstorage.array.mgmt.cfg.bui.utilities.SizeConvert")) : class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$SizeConvert), (String)methodName, (String)"Given bytes size is less than 1 GB; return  MB!");
                return "MB";
            }
        }
        catch (Exception ae) {
            Trace.verbose((Class)(class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$SizeConvert == null ? (class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$SizeConvert = SizeConvert.class$("com.sun.netstorage.array.mgmt.cfg.bui.utilities.SizeConvert")) : class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$SizeConvert), (String)"Exception trying to get MB or GB string", (Throwable)ae);
        }
        Trace.verbose((Class)(class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$SizeConvert == null ? (class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$SizeConvert = SizeConvert.class$("com.sun.netstorage.array.mgmt.cfg.bui.utilities.SizeConvert")) : class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$SizeConvert), (String)methodName, (String)"Given bytes size is greater than 1 GB; return  GB!");
        return "GB";
    }

    public static BigInteger MBStringToBytes(String megabytes) throws NumberFormatException {
        String methodName = "MBStringToBytes";
        Trace.methodBegin((Class)(class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$SizeConvert == null ? (class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$SizeConvert = SizeConvert.class$("com.sun.netstorage.array.mgmt.cfg.bui.utilities.SizeConvert")) : class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$SizeConvert), (String)methodName);
        Trace.verbose((Class)(class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$SizeConvert == null ? (class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$SizeConvert = SizeConvert.class$("com.sun.netstorage.array.mgmt.cfg.bui.utilities.SizeConvert")) : class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$SizeConvert), (String)methodName, (String)("Trying to convert MB string to bytes; string = " + megabytes));
        BigDecimal bdSize = new BigDecimal(megabytes);
        bdSize = bdSize.setScale(2, 0);
        bdSize = bdSize.multiply(Constants.StorageSize.ONE_MB);
        Trace.verbose((Class)(class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$SizeConvert == null ? (class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$SizeConvert = SizeConvert.class$("com.sun.netstorage.array.mgmt.cfg.bui.utilities.SizeConvert")) : class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$SizeConvert), (String)methodName, (String)("big decimal bytes = " + bdSize.toString()));
        BigInteger bi = bdSize.toBigInteger();
        Trace.verbose((Class)(class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$SizeConvert == null ? (class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$SizeConvert = SizeConvert.class$("com.sun.netstorage.array.mgmt.cfg.bui.utilities.SizeConvert")) : class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$SizeConvert), (String)methodName, (String)("BD converted to BI = " + bi.toString()));
        return bi;
    }

    public static BigInteger GBStringToBytes(String gigabytes) throws NumberFormatException {
        String methodName = "GBStringToBytes";
        Trace.methodBegin((Class)(class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$SizeConvert == null ? (class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$SizeConvert = SizeConvert.class$("com.sun.netstorage.array.mgmt.cfg.bui.utilities.SizeConvert")) : class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$SizeConvert), (String)methodName);
        Trace.verbose((Class)(class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$SizeConvert == null ? (class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$SizeConvert = SizeConvert.class$("com.sun.netstorage.array.mgmt.cfg.bui.utilities.SizeConvert")) : class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$SizeConvert), (String)methodName, (String)("Trying to convert GB string to bytes; string = " + gigabytes));
        BigDecimal bdSize = new BigDecimal(gigabytes);
        bdSize = bdSize.setScale(2, 1);
        bdSize = bdSize.multiply(Constants.StorageSize.ONE_GB);
        Trace.verbose((Class)(class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$SizeConvert == null ? (class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$SizeConvert = SizeConvert.class$("com.sun.netstorage.array.mgmt.cfg.bui.utilities.SizeConvert")) : class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$SizeConvert), (String)methodName, (String)("big decimal bytes = " + bdSize.toString()));
        BigInteger bi = bdSize.toBigInteger();
        Trace.verbose((Class)(class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$SizeConvert == null ? (class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$SizeConvert = SizeConvert.class$("com.sun.netstorage.array.mgmt.cfg.bui.utilities.SizeConvert")) : class$com$sun$netstorage$array$mgmt$cfg$bui$utilities$SizeConvert), (String)methodName, (String)("BD converted to BI = " + bi.toString()));
        return bi;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

