/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.bui.utilities;

import com.sun.netstorage.array.mgmt.cfg.bui.utilities.UIUtil;
import com.sun.netstorage.array.mgmt.cfg.core.Constants;
import java.math.BigDecimal;

public class Size {
    private BigDecimal value;
    private String unit;

    public Size(BigDecimal val, String unitStr) {
        this.value = val;
        this.unit = unitStr;
    }

    public BigDecimal getValue() {
        return this.value;
    }

    public String getValueString() {
        return this.value.toString();
    }

    public String getLocalizedValueString() {
        return UIUtil.getBUINumber(this.value);
    }

    public String getUnit() {
        return this.unit;
    }

    public BigDecimal getUnitMultiplier() {
        BigDecimal multiplier = "TB".equalsIgnoreCase(this.unit) ? Constants.StorageSize.ONE_TB : ("GB".equalsIgnoreCase(this.unit) ? Constants.StorageSize.ONE_GB : ("MB".equalsIgnoreCase(this.unit) ? Constants.StorageSize.ONE_MB : ("KB".equalsIgnoreCase(this.unit) ? Constants.StorageSize.ONE_KB : ("BLK".equalsIgnoreCase(this.unit) ? Constants.StorageSize.ONE_BLOCK : Constants.StorageSize.ONE_BYTE))));
        return multiplier;
    }

    public String getLocalizedUnit() {
        if ("TB".equalsIgnoreCase(this.unit)) {
            return UIUtil.getBUIString("se6x20ui.sizesuffix.TB");
        }
        if ("GB".equalsIgnoreCase(this.unit)) {
            return UIUtil.getBUIString("se6x20ui.sizesuffix.GB");
        }
        if ("MB".equalsIgnoreCase(this.unit)) {
            return UIUtil.getBUIString("se6x20ui.sizesuffix.MB");
        }
        if ("KB".equalsIgnoreCase(this.unit)) {
            return UIUtil.getBUIString("se6x20ui.sizesuffix.KB");
        }
        if ("Bytes".equalsIgnoreCase(this.unit)) {
            return UIUtil.getBUIString("se6x20ui.sizesuffix.Bytes");
        }
        if ("BLK".equalsIgnoreCase(this.unit)) {
            return UIUtil.getBUIString("se6x20ui.sizesuffix.Blocks");
        }
        return UIUtil.getBUIString("se6x20ui.error.unknown");
    }

    public String toString() {
        return this.getValueString() + " " + this.getUnit();
    }

    public String toLocalizedString() {
        return this.getLocalizedValueString() + " " + this.getLocalizedUnit();
    }
}

