/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.bui.utilities;

import com.sun.netstorage.array.mgmt.cfg.bui.utilities.SEActionQueueThread;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.ini.Repository;
import com.sun.netstorage.array.mgmt.cfg.ui.core.data.ActiveUserInfo;
import com.sun.netstorage.array.mgmt.cfg.ui.core.data.UserData;
import java.util.ArrayList;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;

public class SessionListener
implements HttpSessionListener {
    private static final long SLEEP_TIME = 500L;
    private static final int RETRY_TIME = 30;

    public void sessionDestroyed(HttpSessionEvent se) {
        block13: {
            Trace.methodBegin((Object)this, (String)"sessionDestroyed");
            try {
                HttpSession session = se.getSession();
                String id = session.getId();
                Trace.verbose((Object)this, (String)"sessionDestroyed", (String)("SessionID:" + id));
                Repository rep = Repository.getRepository();
                ActiveUserInfo aui = (ActiveUserInfo)((Object)rep.getProperty((Object)id));
                rep.removeProperty((Object)id);
                ArrayList au = (ArrayList)rep.getProperty((Object)"ActiveUsersListProperty");
                if (au != null) {
                    int i = au.indexOf(id);
                    if (i < 0) {
                        Trace.verbose((Object)this, (String)"sessionDestroyed", (String)"Session not found in active users list.");
                    } else {
                        au.remove(i);
                        if (aui != null) {
                            Trace.verbose((Object)this, (String)"sessionDestroyed", (String)("user [" + aui.username + "] removed from active users list."));
                            if (aui.username != null && aui.username.equals("storage")) {
                                this.killJobThreads(rep);
                            }
                        } else {
                            Trace.verbose((Object)this, (String)"sessionDestroyed", (String)"aui is null, hm? (SNH)");
                        }
                    }
                } else {
                    Trace.verbose((Object)this, (String)"sessionDestroyed", (String)"Active users list property not found!! (SNH)");
                }
                if (aui != null && !aui.isLoggedOff && !UserData.getInstance().allowMultipleSessions(aui.username) && aui.role != null) {
                    rep.removeProperty((Object)aui.role);
                }
                if (aui == null || aui.configContext == null) break block13;
                if (aui.configContext.getClient() != null) {
                    try {
                        Trace.verbose((Object)this, (String)"sessionDestroyed", (String)"Close CIM connection");
                        aui.configContext.getClient().close();
                        Trace.verbose((Object)this, (String)"sessionDestroyed", (String)"CIM connection closed");
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                System.gc();
            }
            catch (Exception e) {
                Trace.verbose((Object)this, (String)"sessionDestroyed", (Throwable)e);
            }
        }
        Trace.verbose((Object)this, (String)"sessionDestroyed", (String)"END OF METHOD");
    }

    public void sessionCreated(HttpSessionEvent se) {
        Trace.methodBegin((Object)this, (String)"sessionCreated");
        try {
            HttpSession session = se.getSession();
            session.getId();
            String id = session.getId();
            Trace.verbose((Object)this, (String)"sessionCreated", (String)("Session ID:" + id));
        }
        catch (Exception e) {
            Trace.verbose((Object)this, (String)"sessionCreated", (Throwable)e);
        }
    }

    private void killJobThreads(Repository rep) {
        Trace.methodBegin((Object)this, (String)"killJobThreads");
        SEActionQueueThread tasks = (SEActionQueueThread)rep.getProperty((Object)"ActionTaskProperty");
        if (tasks != null) {
            tasks.kill();
            Trace.verbose((Object)this, (String)"killJobThreads", (String)"Make sure all action threads are killed");
            int iter = (int)(tasks.getMaxTimeOut() / 500L);
            Thread cur_thread = Thread.currentThread();
            if (tasks.isEmpty() && tasks.isAlive()) {
                tasks.wakeUp();
            }
            while (!tasks.isEmpty() && iter != 0) {
                Trace.verbose((Object)this, (String)"killJobThreads", (String)"Wait...");
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException ie) {
                    Trace.verbose((Object)this, (String)"killJobThreads", (Throwable)ie);
                }
                --iter;
            }
            Trace.verbose((Object)this, (String)"killJobThreads", (String)"All threads are killed or timeout");
            if (!tasks.isEmpty()) {
                tasks.clear();
                tasks.closeConnection();
            }
            rep.removeProperty((Object)"ActionTaskProperty");
            Trace.verbose((Object)this, (String)"killJobThreads", (String)"Removed threadlist from repository");
            tasks = null;
        }
    }
}

