/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.bui.utilities;

import com.sun.netstorage.array.mgmt.cfg.bui.common.SEExceptionHelper;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.UIUtil;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class SETransaction {
    private LinkedList operations = null;
    private int numOperations = 0;
    private int numSuccess = 0;
    private int numFailure = 0;
    private int numPending = 0;
    private boolean systemFailure = false;
    String summary = null;
    String summaryExtra = null;
    private boolean summaryIsJobRelated = false;

    public SETransaction() {
        this.initialize();
    }

    public SETransaction(String bundleName) {
        this.initialize();
    }

    private void initialize() {
        this.operations = new LinkedList();
        this.summary = new String("");
        this.summaryExtra = new String("");
        this.clear();
    }

    public void clear() {
        this.operations.clear();
        this.numOperations = 0;
        this.numSuccess = 0;
        this.numFailure = 0;
        this.numPending = 0;
        this.summary = "";
        this.summaryExtra = "";
    }

    public void addSuccessfulOperation(String name) {
        name = UIUtil.getBUIString(name);
        Trace.verbose((Object)this, (String)"addSuccessfulOperation", (String)("Name: " + name));
        TransactionOperation op = new TransactionOperation(name, 1, null);
        this.operations.add(op);
        ++this.numOperations;
        ++this.numSuccess;
    }

    public void addFailedOperation() {
        if (!this.systemFailure) {
            Trace.verbose((Object)this, (String)"addFailedOperation", (String)"A system error has occurred.");
            TransactionOperation op = new TransactionOperation(UIUtil.getBUIString("se6x20ui.error.systemerror.left"), 2, UIUtil.getBUIString("se6x20ui.error.systemerror.right"));
            this.operations.add(op);
            ++this.numOperations;
            ++this.numFailure;
            this.systemFailure = true;
        }
    }

    public void addFailedOperation(String name, String message) {
        name = UIUtil.getBUIString(name);
        message = UIUtil.getBUIString(message);
        Trace.verbose((Object)this, (String)"addFailedOperation", (String)("Name: " + name + ", Message: " + message));
        TransactionOperation op = new TransactionOperation(name, 2, message);
        this.operations.add(op);
        ++this.numOperations;
        ++this.numFailure;
    }

    public void addFailedOperation(String name, Exception ex) {
        String METHOD = "addFailedOperation(String, Exception)";
        String message = "";
        List messageList = null;
        name = UIUtil.getBUIString(name);
        if (ex instanceof ConfigMgmtException) {
            Trace.verbose((Object)this, (String)"addFailedOperation(String, Exception)", (String)"Handling CME.");
            ConfigMgmtException cme = (ConfigMgmtException)((Object)ex);
            if (cme.isMulti()) {
                Trace.verbose((Object)this, (String)"addFailedOperation(String, Exception)", (String)"Handling multi-result CME.");
                messageList = SEExceptionHelper.multiExceptionHelper(cme);
            } else {
                Trace.verbose((Object)this, (String)"addFailedOperation(String, Exception)", (String)"Handling single result CME.");
                message = SEExceptionHelper.exceptionHelper(ex);
            }
        } else {
            message = SEExceptionHelper.exceptionHelper(ex);
        }
        if (messageList != null && messageList.size() != 0) {
            Trace.verbose((Object)this, (String)"addFailedOperation(String, Exception)", (String)("Message List Size: " + messageList.size()));
            for (int i = 0; i < messageList.size(); ++i) {
                Trace.verbose((Object)this, (String)"addFailedOperation", (String)("Name: " + name + ", Message: " + (String)messageList.get(i)));
                TransactionOperation op = new TransactionOperation(name, 2, (String)messageList.get(i));
                this.operations.add(op);
                ++this.numOperations;
                ++this.numFailure;
            }
            Trace.verbose((Object)this, (String)"addFailedOperation", (Throwable)ex);
        } else {
            Trace.verbose((Object)this, (String)"addFailedOperation", (String)("Name: " + name + ", Message: " + message));
            Trace.verbose((Object)this, (String)"addFailedOperation", (Throwable)ex);
            TransactionOperation op = new TransactionOperation(name, 2, message);
            this.operations.add(op);
            ++this.numOperations;
            ++this.numFailure;
        }
    }

    public void addPendingOperation(String name) {
        name = UIUtil.getBUIString(name);
        Trace.verbose((Object)this, (String)"addPendingOperation", (String)("Name: " + name));
        TransactionOperation op = new TransactionOperation(name, 3, null);
        this.operations.add(op);
        ++this.numOperations;
        ++this.numPending;
    }

    public boolean isSuccess() {
        return this.numOperations == this.numSuccess;
    }

    public boolean isAnyOperations() {
        return this.numOperations > 0;
    }

    public boolean isAnySuccess() {
        return this.numSuccess > 0;
    }

    public boolean isAnyFailure() {
        return this.numFailure > 0;
    }

    public boolean isAnyPending() {
        return this.numPending > 0;
    }

    public String getDelimitedSuccessList() {
        return this.getDelimitedOperationNameList(1);
    }

    public String getDelimitedPendingList() {
        return this.getDelimitedOperationNameList(3);
    }

    public String getDelimitedFailureList() {
        Trace.methodBegin((Object)this, (String)"getDelimitedFailureList");
        String failure = new String();
        Iterator iter = this.operations.iterator();
        while (iter.hasNext()) {
            TransactionOperation op = (TransactionOperation)iter.next();
            if (op.getStatus() == 2) {
                Trace.verbose((Object)this, (String)"getDelimitedFailureList", (String)("Appending: " + op.getName()));
                if (failure.length() != 0) {
                    failure = failure.concat("<BR>");
                }
                if (op.getName() != null) {
                    failure = failure.concat(op.getName());
                } else {
                    failure = failure.concat("se6x20ui.error.unknown");
                    Trace.verbose((Object)this, (String)"getDelimitedFailureList", (String)"Name is equal to NULL.");
                }
                failure = failure.concat(" - ");
                if (op.getMessage() != null) {
                    failure = failure.concat(op.getMessage());
                    continue;
                }
                failure = failure.concat("se6x20ui.error.unknown");
                Trace.verbose((Object)this, (String)"getDelimitedFailureList", (String)"Message is equal to NULL.");
                continue;
            }
            Trace.verbose((Object)this, (String)"getDelimitedFailureList", (String)("Skipping: " + op.getName()));
        }
        Trace.verbose((Object)this, (String)"getDelimitedFailureList", (String)("Returning: " + failure));
        return failure;
    }

    private String getDelimitedOperationNameList(int opType) {
        String calledFrom = opType == 1 ? "getDelimitedSuccessList" : "getDelimitedPendingList";
        Trace.methodBegin((Object)this, (String)calledFrom);
        String success = new String();
        Iterator iter = this.operations.iterator();
        while (iter.hasNext()) {
            TransactionOperation op = (TransactionOperation)iter.next();
            if (op.getStatus() == opType) {
                Trace.verbose((Object)this, (String)calledFrom, (String)("Appending: " + op.getName()));
                if (success.length() != 0) {
                    success = success.concat(", ");
                }
                success = success.concat(op.getName());
                continue;
            }
            Trace.verbose((Object)this, (String)calledFrom, (String)("Skipping: " + op.getName()));
        }
        Trace.verbose((Object)this, (String)calledFrom, (String)("Returning: " + success));
        return success;
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String str) {
        this.summary = str;
    }

    public String getSummaryExtra() {
        return this.summaryExtra;
    }

    public void setSummaryExtra(String str) {
        this.summaryExtra = str;
    }

    public void setSummaryIsJobRelated() {
        this.summaryIsJobRelated = true;
    }

    public boolean getSummaryIsJobRelated() {
        return this.summaryIsJobRelated;
    }

    private class TransactionOperation {
        private String name;
        private int status;
        protected static final int OP_SUCCESS = 1;
        protected static final int OP_FAILURE = 2;
        protected static final int OP_PENDING = 3;
        String bundleBase = null;
        private String message;

        public TransactionOperation(String paramName, int paramStatus, String paramMessage) {
            this.name = paramName;
            this.status = paramStatus;
            this.message = paramMessage;
        }

        public String getName() {
            return this.name;
        }

        public int getStatus() {
            return this.status;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

