/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.bui.utilities;

import com.sun.netstorage.array.mgmt.cfg.bui.utilities.SEAction;
import com.sun.netstorage.array.mgmt.cfg.core.CIMOMHandleWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.ConnectionFactory;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.ini.Repository;
import java.util.LinkedList;

public class SEActionQueueThread
extends Thread {
    private LinkedList items;
    private boolean killed;
    private ConfigContext context;
    private long maxTimeOut;
    private long operation;
    private boolean isNewConnection;

    public SEActionQueueThread(ConfigContext cfgcontext) {
        Trace.constructor((Object)this);
        this.setName("ActionQueue Thread");
        try {
            this.context = this.createNewConnection(cfgcontext);
        }
        catch (ConfigMgmtException cex) {
            Trace.error((Object)this, (String)"ActionQueueThread", (String)"Failed creating new connection. Using callers connection");
            this.context = cfgcontext;
        }
        this.items = new LinkedList();
        this.start();
        this.killed = false;
    }

    public synchronized SEAction enqueue(SEAction element) {
        Trace.methodBegin((Object)this, (String)"enqueue");
        element.setConfigContext(this.context);
        this.items.add(element);
        if (this.items.size() == 1) {
            this.wakeUp();
        }
        return element;
    }

    public synchronized SEAction dequeue() {
        Trace.methodBegin((Object)this, (String)"dequeue");
        if (this.items.size() == 0) {
            return null;
        }
        SEAction o = (SEAction)this.items.removeFirst();
        this.wakeUp();
        return o;
    }

    public synchronized SEAction front() {
        Trace.methodBegin((Object)this, (String)"front");
        if (this.items.size() == 0) {
            return null;
        }
        return (SEAction)this.items.getFirst();
    }

    public synchronized int size() {
        return this.items.size();
    }

    public synchronized boolean isEmpty() {
        return this.items.size() == 0;
    }

    public synchronized void clear() {
        this.items.clear();
    }

    public boolean isKilled() {
        return this.killed;
    }

    public void kill() {
        int s = this.size();
        for (int i = 0; i < s; ++i) {
            SEAction action = (SEAction)this.items.get(i);
            action.kill();
        }
        this.killed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeUp() {
        Trace.methodBegin((Object)this, (String)"wakeUp");
        SEActionQueueThread sEActionQueueThread = this;
        synchronized (sEActionQueueThread) {
            this.notify();
        }
    }

    public void setConfigContext(ConfigContext context) {
        this.context = context;
    }

    public ConfigContext getConfigContext() {
        return this.context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Trace.methodBegin((Object)this, (String)"run");
        SEAction action = null;
        while (!this.killed || !this.isEmpty()) {
            Thread t;
            if (!this.isEmpty() && (action = this.front()) != null) {
                this.maxTimeOut = action.getMaxTimeOutOperation();
                t = new Thread(action);
                t.setPriority(1);
                t.start();
            }
            try {
                t = this;
                synchronized (t) {
                    Trace.verbose((Object)this, (String)"run", (String)"ActionQueue thread waiting....");
                    this.wait();
                    if (action != null) {
                        this.maxTimeOut = action.getMaxTimeOutOperation();
                    }
                    Trace.verbose((Object)this, (String)"run", (String)"ActionQueue thread got notified");
                }
            }
            catch (InterruptedException inte) {
                Trace.error((Object)this, (String)"run", (String)("InterruptedException for wait(): " + inte.getMessage()));
            }
        }
        Trace.verbose((Object)this, (String)"run", (String)"Got killed......");
        this.closeConnection();
    }

    public void closeConnection() {
        if (this.isNewConnection) {
            if (this.context != null) {
                Trace.verbose((Object)this, (String)"closeConnection", (String)"Closing ActionQueueThread connection");
                this.context.getClient().close();
                this.isNewConnection = false;
            }
            this.context = null;
        }
    }

    public long getMaxTimeOut() {
        return this.maxTimeOut;
    }

    private ConfigContext createNewConnection(ConfigContext context) throws ConfigMgmtException {
        Repository rep = Repository.getRepository();
        ConfigContext n_context = context;
        if (context != null) {
            CIMOMHandleWrapper client = ConnectionFactory.createHandleForNamespace((ConfigContext)context, (String)rep.getNameSpace());
            n_context = new ConfigContext(client, context);
            this.isNewConnection = true;
            Trace.verbose((Object)this, (String)"createNewConnection", (String)"New connection created");
        } else {
            Trace.error((Object)this, (String)"createNewConnection", (String)"Callers config context is null");
        }
        return n_context;
    }
}

