/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.bui.utilities;

import com.sun.netstorage.array.mgmt.cfg.access.business.InitiatorInterface;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.InitiatorVolumeMappingInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageVolumeInterface;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;

public class SEActionOperands {
    private static final int OPTYPE_NONE = -1;
    private static final int OPTYPE_KEYNAME = 0;
    private static final int OPTYPE_MAPPING = 1;
    private static final int OPTYPE_NAMEONLY = 2;
    private static final int OPTYPE_GENERIC = 100;
    private int operandType = -1;
    private Vector keyOperands = null;
    private Vector nameOperands = null;
    private Object actionObject = null;
    private LinkedList fromOperands = null;
    private LinkedList toOperands = null;
    private String sepString = null;
    private boolean nameListGenerated = false;
    private List genericArguments = null;
    private Object manager = null;
    private String managerMethod = null;
    private boolean managerMethodHasReturnValue = false;
    private List objectNames = null;
    private List objectTypes = null;

    public SEActionOperands() {
        this.operandType = -1;
    }

    public SEActionOperands(Object mgr, String mMethod, List argList, List nList, List tList, boolean hasReturnValue) {
        this.operandType = 100;
        this.genericArguments = argList;
        this.objectNames = nList;
        this.objectTypes = tList;
        this.manager = mgr;
        this.managerMethod = mMethod;
        this.managerMethodHasReturnValue = hasReturnValue;
    }

    public void add(Collection key, String name) {
        this.operandType = 0;
        if (this.keyOperands == null) {
            this.keyOperands = new Vector();
            this.nameOperands = new Vector();
        }
        this.keyOperands.addElement(key);
        if (this.actionObject != null) {
            String toName = null;
            if (this.actionObject instanceof StorageVolumeInterface) {
                toName = ((StorageVolumeInterface)this.actionObject).getName();
            } else if (this.actionObject instanceof InitiatorInterface) {
                toName = ((InitiatorInterface)this.actionObject).getName();
            } else {
                Trace.error((Object)this, (String)"add", (String)"unsupported object type in actionObject");
            }
            this.nameOperands.addElement(toName + this.sepString + name);
        } else {
            this.nameOperands.addElement(name);
        }
    }

    public void add(String name) {
        this.operandType = 2;
        if (this.nameOperands == null) {
            this.nameOperands = new Vector();
        }
        this.nameOperands.addElement(name);
    }

    public void setActionObject(StorageVolumeInterface volume, String sep) {
        this.actionObject = volume;
        this.sepString = sep;
    }

    public void setActionObject(InitiatorInterface initiator, String sep) {
        this.actionObject = initiator;
        this.sepString = sep;
    }

    public Object getActionObject() {
        return this.actionObject;
    }

    public void add(LinkedList fromOperands, LinkedList toOperands, String sepString) {
        this.operandType = 1;
        this.fromOperands = fromOperands;
        this.toOperands = toOperands;
        this.sepString = sepString;
    }

    public Collection getKey(int ix) {
        Collection collection = null;
        if (this.operandType == 0) {
            collection = (Collection)this.keyOperands.get(ix);
        }
        return collection;
    }

    public String getName(int ix) {
        String name = null;
        if (this.operandType == 0 || this.operandType == 2) {
            name = (String)this.nameOperands.get(ix);
        } else if (this.operandType == 1) {
            if (this.nameListGenerated) {
                name = (String)this.nameOperands.get(ix);
            } else {
                Object fromObj = this.fromOperands.get(this.getFromIx(ix));
                InitiatorVolumeMappingInterface mapData = (InitiatorVolumeMappingInterface)this.toOperands.get(this.getToIx(ix));
                String fromName = null;
                String toName = null;
                if (fromObj instanceof StorageVolumeInterface) {
                    StorageVolumeInterface volume = (StorageVolumeInterface)fromObj;
                    InitiatorInterface initiator = (InitiatorInterface)mapData.getObject();
                    fromName = volume.getName();
                    toName = initiator.getName();
                } else if (fromObj instanceof InitiatorInterface) {
                    InitiatorInterface initiator = (InitiatorInterface)fromObj;
                    StorageVolumeInterface volume = (StorageVolumeInterface)mapData.getObject();
                    fromName = initiator.getName();
                    toName = volume.getName();
                }
                name = fromName + this.sepString + toName;
            }
        }
        return name;
    }

    public Vector getNames() {
        if (this.operandType == 1 && this.nameOperands == null) {
            this.nameOperands = new Vector();
            for (int i = 0; i < this.getSize(); ++i) {
                this.nameOperands.addElement(this.getName(i));
            }
        }
        this.nameListGenerated = true;
        return this.nameOperands;
    }

    public Object getMapFromObject(int ix) {
        Object object = null;
        if (this.operandType == 1) {
            object = this.fromOperands.get(this.getFromIx(ix));
        }
        return object;
    }

    public Object getMapToObject(int ix) {
        Object object = null;
        if (this.operandType == 1) {
            object = this.toOperands.get(this.getToIx(ix));
        }
        return object;
    }

    public int getSize() {
        int size = 0;
        if (this.operandType == 0 || this.operandType == 2) {
            size = this.nameOperands.size();
        } else if (this.operandType == 1) {
            size = this.fromOperands.size() * this.toOperands.size();
        }
        return size;
    }

    private int getFromIx(int ix) {
        int fromIx = 0;
        if (this.operandType == 1) {
            fromIx = ix / this.toOperands.size();
        }
        return fromIx;
    }

    private int getToIx(int ix) {
        int toIx = 0;
        if (this.operandType == 1) {
            toIx = ix % this.toOperands.size();
        }
        return toIx;
    }

    public List getGenericArguments() {
        return this.genericArguments;
    }

    public List getObjectNames() {
        return this.objectNames;
    }

    public String getManagerMethod() {
        return this.managerMethod;
    }

    public Object getManager() {
        return this.manager;
    }

    public boolean managerMethodHasReturnValue() {
        return this.managerMethodHasReturnValue;
    }

    public List getObjectTypes() {
        return this.objectTypes;
    }
}

