/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.bui.utilities;

import com.sun.netstorage.array.mgmt.cfg.access.business.InitiatorInterface;
import com.sun.netstorage.array.mgmt.cfg.access.business.ManageInitiatorsFactory;
import com.sun.netstorage.array.mgmt.cfg.access.business.ManageInitiatorsInterface;
import com.sun.netstorage.array.mgmt.cfg.bui.common.SEExceptionHelper;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.SEActionOperands;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.SEActionParameters;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.SEActionQueueThread;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.SETransaction;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.UIUtil;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.CoreManagerInterface;
import com.sun.netstorage.array.mgmt.cfg.core.ManagerInterface;
import com.sun.netstorage.array.mgmt.cfg.core.MethodCallStatus;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.BadParameterException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.ini.Repository;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.ManageDataServicesFactory;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.ManageReplicationServicesEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.ManageSnapShotServicesEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.jobs.business.JobInterface;
import com.sun.netstorage.array.mgmt.cfg.jobs.business.JobManagerFactory;
import com.sun.netstorage.array.mgmt.cfg.jobs.business.JobManagerInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.InitiatorVolumeMappingInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStoragePoolsFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStoragePoolsInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStorageProfilesFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStorageProfilesInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStorageVolumesFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStorageVolumesInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageVDisksFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageVDisksInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageVolumeInterface;
import com.sun.netstorage.array.mgmt.cfg.util.ItemNotFoundException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.Vector;

public class SEAction
implements Runnable {
    private ConfigContext context = null;
    private SEActionOperands operands = null;
    private SEActionParameters params = null;
    private SETransaction transaction = null;
    private String jobID = null;
    private boolean async = false;
    private static final String NONJOBID = "Syncronous Operation, NOT a job";
    private Object mgr = null;
    private int opNum_0Based = 0;
    private boolean killed = false;
    private boolean cancelled = false;
    private boolean localContext = false;
    private SEActionQueueThread tasks;
    private JobManagerInterface jmgr = null;
    private JobInterface job = null;
    private long maxOperationTime;

    public SEAction(ConfigContext context, SEActionOperands operands, SEActionParameters params, boolean requestAsync) {
        this.context = context;
        this.operands = operands;
        this.params = params;
        if (params.getType() == 100) {
            String maxOpTimeParameter = operands.getManager().getClass().getName() + "." + operands.getManagerMethod() + "-TIME";
            this.maxOperationTime = UIUtil.getInitParamInt(maxOpTimeParameter);
            if (this.maxOperationTime <= 0L) {
                this.maxOperationTime = 30000L;
            }
        } else {
            this.maxOperationTime = params.ACTION_TIMES.length > params.getType() ? params.ACTION_TIMES[params.getType()] : params.ACTION_TIMES[params.ACTION_TIMES.length - 1];
        }
        if (!requestAsync) {
            this.transaction = new SETransaction("com.sun.netstorage.array.mgmt.cfg.bui.resources.Resources");
            this.jobID = NONJOBID;
        } else {
            this.initializeJob();
        }
    }

    public SEAction(ConfigContext context, SEActionOperands operands, SEActionParameters params) {
        this(context, operands, params, false);
    }

    public void kill() {
        this.killed = true;
        Trace.verbose((Object)this, (String)"kill", (String)("Killing job: " + this.jobID));
    }

    public boolean isAsync() {
        return this.async;
    }

    public boolean isKilled() {
        return this.killed;
    }

    public JobInterface getJob() {
        return this.job;
    }

    public String getJobID() {
        if (this.job == null) {
            return null;
        }
        return this.job.getId();
    }

    public SETransaction getTransaction() {
        return this.transaction;
    }

    public void setConfigContext(ConfigContext n_context) {
        Trace.methodBegin((Object)this, (String)"setConfigContext");
        this.context = n_context;
    }

    public void execute() {
        Trace.methodBegin((Object)this, (String)"execute");
        if (this.async) {
            this.registerWithQueue();
        } else {
            this.run();
        }
    }

    public int getActionType() {
        return this.params.getType();
    }

    public long getMaxTimeOutOperation() {
        return this.maxOperationTime;
    }

    public void run() {
        String actionNameRK;
        int actionType;
        block57: {
            actionType = this.params.getType();
            actionNameRK = "se6920.action.name." + this.params.getType();
            if (this.params.getType() == 100) {
                actionNameRK = this.operands.getManager().getClass().getName() + "." + this.operands.getManagerMethod();
            }
            Trace.verbose((Object)this, (String)"run", (String)("Starting action: " + UIUtil.getEnglishBUIString(actionNameRK) + ", job: " + this.jobID));
            if (this.async) {
                try {
                    this.job = this.jmgr.getItemByUniqueID(this.jobID);
                }
                catch (ConfigMgmtException ex) {
                    Trace.error((Object)this, (String)"run", (String)("Unable to get job for async action, terminating: " + UIUtil.getEnglishBUIString(actionNameRK)));
                    this.unregisterFromQueue();
                    return;
                }
            }
            switch (actionType) {
                case 2: 
                case 3: 
                case 4: 
                case 12: 
                case 13: {
                    this.mgr = ManageStorageVolumesFactory.getManager();
                    break;
                }
                case 5: {
                    this.mgr = (ManageSnapShotServicesEnt1Interface)ManageDataServicesFactory.getSnapShotServicesManager();
                    break;
                }
                case 1: {
                    this.mgr = ManageStorageProfilesFactory.getManager();
                    break;
                }
                case 6: {
                    this.mgr = ManageVDisksFactory.getManager();
                    break;
                }
                case 7: {
                    this.mgr = ManageStoragePoolsFactory.getManager();
                    break;
                }
                case 8: 
                case 9: 
                case 10: {
                    this.mgr = ManageInitiatorsFactory.getManager();
                    break;
                }
                case 11: 
                case 14: {
                    this.mgr = null;
                    break;
                }
                case 15: 
                case 16: {
                    this.mgr = JobManagerFactory.create();
                    break;
                }
                case 100: {
                    Trace.verbose((Object)this, (String)"run", (String)"Generic action detected - use reflection");
                    this.mgr = this.operands.getManager();
                    break;
                }
                case 17: {
                    this.mgr = (ManageReplicationServicesEnt1Interface)ManageDataServicesFactory.getReplicationServicesManager();
                    break;
                }
                default: {
                    Trace.verbose((Object)this, (String)"run", (String)"No operation set, terminating action");
                    if (this.async) {
                        try {
                            this.job.setJobStatus("Complete");
                            this.job.save();
                        }
                        catch (ConfigMgmtException ex) {
                            Trace.verbose((Object)this, (String)"run", (String)"Unable to complete job");
                        }
                        this.unregisterFromQueue();
                    }
                    return;
                }
            }
            if (this.mgr != null) {
                try {
                    CoreManagerInterface mgrInterface;
                    if (this.mgr instanceof CoreManagerInterface) {
                        mgrInterface = (CoreManagerInterface)this.mgr;
                        mgrInterface.init(this.context, null);
                        break block57;
                    }
                    if (this.mgr instanceof ManagerInterface) {
                        mgrInterface = (ManagerInterface)this.mgr;
                        mgrInterface.init(this.context, null, null);
                        break block57;
                    }
                    if (actionType == 100) {
                        Trace.verbose((Object)this, (String)"run", (String)"WARNING: Object that should perform an action is not a manager!");
                        break block57;
                    }
                    Trace.error((Object)this, (String)"run", (String)("Unknown manager, terminating action: " + UIUtil.getEnglishBUIString(actionNameRK)));
                    return;
                }
                catch (ConfigMgmtException cex) {
                    Trace.error((Object)this, (String)"run", (String)("Unable to initialize manager, terminating action: " + UIUtil.getEnglishBUIString(actionNameRK)));
                    if (this.async) {
                        this.unregisterFromQueue();
                        try {
                            this.job = this.jmgr.getItemByUniqueID(this.jobID);
                            if (this.job != null) {
                                try {
                                    this.job.setJobStatus("Failed");
                                    this.job.save();
                                    Trace.verbose((Object)this, (String)"run", (String)"action terminated, job marked complete");
                                }
                                catch (ConfigMgmtException cex1) {
                                    this.job = null;
                                }
                            }
                        }
                        catch (ConfigMgmtException cex2) {
                            this.job = null;
                        }
                    }
                    if (this.job == null) {
                        Trace.error((Object)this, (String)"run", (String)"Unable to complete job after job interface initialization failure");
                    }
                    return;
                }
            }
        }
        if (actionType == 100) {
            this.executeGenericAction(actionNameRK);
            return;
        }
        int nOps = this.operands.getSize();
        Trace.verbose((Object)this, (String)"run", (String)("Action: " + UIUtil.getEnglishBUIString(actionNameRK) + " (" + nOps + " iterations)"));
        String lastSnapName = null;
        long t_operation = 0L;
        this.opNum_0Based = 0;
        while (this.opNum_0Based < nOps && !this.isKilled()) {
            int opNum_1Based = this.opNum_0Based + 1;
            if (!this.async || this.job.isActive()) {
                Collection key = this.operands.getKey(this.opNum_0Based);
                String name = this.operands.getName(this.opNum_0Based);
                Trace.verbose((Object)this, (String)"run", (String)("Starting action: " + UIUtil.getEnglishBUIString(actionNameRK) + "(" + opNum_1Based + " of " + nOps + "), job: " + this.jobID));
                t_operation = System.currentTimeMillis();
                switch (actionType) {
                    case 5: {
                        this.snapVolume(this.job, key, name, lastSnapName);
                        break;
                    }
                    case 2: {
                        this.deleteVolume(this.job, key, name);
                        break;
                    }
                    case 3: 
                    case 13: {
                        StorageVolumeInterface volume = (StorageVolumeInterface)this.operands.getMapFromObject(this.opNum_0Based);
                        InitiatorVolumeMappingInterface mapData = (InitiatorVolumeMappingInterface)this.operands.getMapToObject(this.opNum_0Based);
                        this.mapVolume(this.job, volume, name, Integer.parseInt(mapData.getLun()), mapData.getPermissions(), (InitiatorInterface)mapData.getObject());
                        break;
                    }
                    case 4: {
                        StorageVolumeInterface volume = (StorageVolumeInterface)this.operands.getMapFromObject(this.opNum_0Based);
                        InitiatorVolumeMappingInterface mapData = (InitiatorVolumeMappingInterface)this.operands.getMapToObject(this.opNum_0Based);
                        this.mapVolume(this.job, volume, name, -1, mapData.getPermissions(), (InitiatorInterface)mapData.getObject());
                        break;
                    }
                    case 1: {
                        this.deleteProfile(this.job, key, name);
                        break;
                    }
                    case 7: {
                        this.deletePool(this.job, key, name);
                        break;
                    }
                    case 6: {
                        this.deleteVDisk(this.job, key, name);
                        break;
                    }
                    case 8: {
                        this.deleteInitiator(this.job, key, name);
                        break;
                    }
                    case 9: {
                        InitiatorInterface initiator = (InitiatorInterface)this.operands.getMapFromObject(this.opNum_0Based);
                        InitiatorVolumeMappingInterface mapData = (InitiatorVolumeMappingInterface)this.operands.getMapToObject(this.opNum_0Based);
                        this.mapInitiator(this.job, initiator, name, Integer.parseInt(mapData.getLun()), mapData.getPermissions(), (StorageVolumeInterface)mapData.getObject());
                        break;
                    }
                    case 10: {
                        InitiatorInterface initiator = (InitiatorInterface)this.operands.getMapFromObject(this.opNum_0Based);
                        InitiatorVolumeMappingInterface mapData = (InitiatorVolumeMappingInterface)this.operands.getMapToObject(this.opNum_0Based);
                        this.mapInitiator(this.job, initiator, name, -1, mapData.getPermissions(), (StorageVolumeInterface)mapData.getObject());
                        break;
                    }
                    case 14: {
                        this.unmap(this.job, this.operands.getActionObject(), key, name);
                        break;
                    }
                    case 11: {
                        this.deleteSnapshot(this.job, this.operands.getActionObject(), key, name);
                        break;
                    }
                    case 12: {
                        this.resnapSnapshot(this.job, key, name);
                        break;
                    }
                    case 16: {
                        this.removeJob(this.job, name);
                        break;
                    }
                    case 15: {
                        this.cancelJob(this.job, name);
                        break;
                    }
                    case 17: {
                        this.deleteRepSet(this.job, key, name);
                        break;
                    }
                    default: {
                        Trace.error((Object)this, (String)"run", (String)"Unknown operation type.");
                    }
                }
                this.updateJobProgress(actionNameRK, nOps, opNum_1Based);
                long tot_operation = System.currentTimeMillis() - t_operation;
                if (this.maxOperationTime < tot_operation) {
                    this.maxOperationTime = tot_operation;
                    if (Trace.isTraceEnabled((Object)this)) {
                        Trace.verbose((Object)this, (String)"run", (String)("Maximum time of one operation(msec) for " + UIUtil.getEnglishBUIString(actionNameRK) + ": " + this.maxOperationTime));
                    }
                }
                if (Trace.isTraceEnabled((Object)this)) {
                    Trace.verbose((Object)this, (String)"run", (String)("Total time of one operation(msec) for " + UIUtil.getEnglishBUIString(actionNameRK) + ": " + tot_operation));
                }
            } else {
                Trace.verbose((Object)this, (String)"run", (String)"Job terminated by user, quitting loop");
                this.cancelled = true;
                break;
            }
            ++this.opNum_0Based;
        }
        this.checkIfKilledOrCanceled();
        this.unregisterFromQueue();
        Trace.verbose((Object)this, (String)"run", (String)("Completed action: " + UIUtil.getEnglishBUIString(actionNameRK)));
    }

    private void checkIfKilledOrCanceled() {
        if (this.isKilled() || this.cancelled) {
            try {
                if (this.job != null) {
                    this.job.kill();
                    Trace.verbose((Object)this, (String)"run", (String)("Killed job: " + this.jobID));
                }
            }
            catch (ConfigMgmtException ex) {
                this.job = null;
                Trace.verbose((Object)this, (String)"run", (String)("Failed to kill job: " + this.jobID));
            }
        }
    }

    private boolean updateJobProgress(String actionNameRK, int nOps, int opNum_1Based) {
        String METHOD = "updateJobProgress";
        if (opNum_1Based == 0) {
            opNum_1Based = 1;
        }
        int percentDone = opNum_1Based * 100 / nOps;
        Trace.verbose((Object)this, (String)"updateJobProgress", (String)("Action: " + UIUtil.getEnglishBUIString(actionNameRK) + ", " + percentDone + "% complete, job: " + this.jobID));
        if (this.async) {
            try {
                this.job.setPercentComplete(percentDone);
                this.job.save();
                this.job = this.jmgr.getItemByUniqueID(this.jobID);
                Trace.verbose((Object)this, (String)"updateJobProgress", (String)("Retrieved job: " + this.jobID));
            }
            catch (ConfigMgmtException ex) {
                this.job = null;
                Trace.verbose((Object)this, (String)"updateJobProgress", (String)("Failed to retrieve job: " + this.jobID));
            }
            if (this.job == null) {
                Trace.error((Object)this, (String)"updateJobProgress", (String)("Terminating action: " + UIUtil.getEnglishBUIString(actionNameRK)));
                this.unregisterFromQueue();
                return false;
            }
        }
        return true;
    }

    private void executeGenericAction(String actionNameRK) {
        String METHOD = "executeGenericAction";
        Trace.methodBegin((Object)this, (String)"executeGenericAction");
        List ga = this.operands.getGenericArguments();
        List on = this.operands.getObjectNames();
        List types = this.operands.getObjectTypes();
        int sz = ga == null ? 0 : ga.size();
        for (int i = 0; i < sz && !this.isKilled(); ++i) {
            this.opNum_0Based = i;
            if (!this.async || this.job.isActive()) {
                Object[] params = (Object[])ga.get(i);
                Class[] pClass = (Class[])types.get(i);
                try {
                    Trace.verbose((Object)this, (String)"run", (String)("Invoking method:" + this.operands.getManagerMethod() + " on Manager:" + this.mgr.getClass().getName()));
                    Class<?> cls = Class.forName(this.mgr.getClass().getName());
                    Method m = cls.getMethod(this.operands.getManagerMethod(), pClass);
                    if (this.operands.managerMethodHasReturnValue()) {
                        Object retObj = m.invoke(this.mgr, params);
                        if (retObj instanceof MethodCallStatus) {
                            if (UIUtil.isMCSSuccess((MethodCallStatus)retObj)) {
                                this.addSuccess(this.job, (String)on.get(i));
                                Trace.verbose((Object)this, (String)"executeGenericAction", (String)("generic action success: " + (String)on.get(i)));
                            } else {
                                this.addFailure(this.job, (String)on.get(i), "error.cim." + ((MethodCallStatus)retObj).getReturnCode());
                                Trace.error((Object)this, (String)"executeGenericAction", (String)("Error invoking method on object: " + (String)on.get(i)));
                                Trace.error((Object)this, (String)"executeGenericAction", (String)("DSP err #: " + ((MethodCallStatus)retObj).getReturnCode()));
                            }
                        }
                    } else {
                        m.invoke(this.mgr, params);
                    }
                    Trace.verbose((Object)this, (String)"executeGenericAction", (String)"Method completed.");
                }
                catch (SecurityException e) {
                    Trace.error((Object)this, (String)"executeGenericAction", (Throwable)e);
                    this.addFailure(this.job, (String)on.get(i), e);
                }
                catch (IllegalArgumentException e) {
                    Trace.error((Object)this, (String)"executeGenericAction", (Throwable)e);
                    this.addFailure(this.job, (String)on.get(i), e);
                }
                catch (NoSuchMethodException e) {
                    Trace.error((Object)this, (String)"executeGenericAction", (Throwable)e);
                    this.addFailure(this.job, (String)on.get(i), e);
                }
                catch (IllegalAccessException e) {
                    Trace.error((Object)this, (String)"executeGenericAction", (Throwable)e);
                    this.addFailure(this.job, (String)on.get(i), e);
                }
                catch (InvocationTargetException e) {
                    Trace.error((Object)this, (String)"executeGenericAction", (Throwable)e);
                    this.addFailure(this.job, (String)on.get(i), e);
                }
                catch (Exception e) {
                    Trace.error((Object)this, (String)"executeGenericAction", (Throwable)e);
                    this.addFailure(this.job, (String)on.get(i), e);
                }
                if (this.updateJobProgress(actionNameRK, sz, i + 1)) continue;
                return;
            }
            Trace.verbose((Object)this, (String)"run", (String)"Job terminated by user, quitting loop");
            this.cancelled = true;
            break;
        }
        this.checkIfKilledOrCanceled();
        this.unregisterFromQueue();
    }

    private void registerWithQueue() {
        if (this.async && this.tasks != null) {
            Trace.verbose((Object)this, (String)"registerWithQueue", (String)("Adding jobID: " + this.jobID));
            this.tasks.enqueue(this);
        }
    }

    private void unregisterFromQueue() {
        Repository rep;
        Trace.methodBegin((Object)this, (String)"unregisterFromQueue");
        if (this.async && (rep = Repository.getRepository()) != null) {
            this.tasks = (SEActionQueueThread)rep.getProperty((Object)"ActionTaskProperty");
            if (this.tasks != null) {
                this.tasks.dequeue();
                Trace.verbose((Object)this, (String)"unregisterFromQueue", (String)("Removed jobID: " + this.jobID));
            }
        }
    }

    private void addSuccess(JobInterface job, String name) {
        if (job == null) {
            Trace.verbose((Object)this, (String)"addSuccess", (String)("Adding success to transaction: " + name));
            this.transaction.addSuccessfulOperation(name);
        } else {
            Trace.verbose((Object)this, (String)"addSuccess", (String)("Adding success to job: " + name));
            job.setTaskResult(this.opNum_0Based, "", true);
        }
    }

    private void addFailure(JobInterface job, String name, String reason) {
        if (job == null) {
            Trace.verbose((Object)this, (String)"addFailure", (String)("Adding failure to transaction: " + name + " - " + UIUtil.getEnglishBUIString(reason)));
            this.transaction.addFailedOperation(name, UIUtil.getBUIString(reason));
            this.transaction.setSummary(UIUtil.getBUIString(reason));
        } else {
            Trace.verbose((Object)this, (String)"addFailure", (String)("Adding failure to job: " + name + " - " + UIUtil.getEnglishBUIString(reason)));
            try {
                job.setTaskResult(this.opNum_0Based, UIUtil.getBUIString(reason), false);
            }
            catch (Exception e) {
                Trace.error((Object)this, (String)"addFailure", (Throwable)e);
            }
        }
    }

    private void addFailure(JobInterface job, String name, Exception ex) {
        String message = SEExceptionHelper.exceptionHelper(ex);
        String messageEnglish = SEExceptionHelper.exceptionHelperEnglish(ex);
        if (job == null) {
            Trace.verbose((Object)this, (String)"addFailure", (String)("Adding exception failure to transaction: " + name + " - " + messageEnglish));
            this.transaction.setSummary(message);
            this.transaction.addFailedOperation(name, message);
        } else {
            Trace.verbose((Object)this, (String)"addFailure", (String)("Adding exception failure to job: " + name + " - " + messageEnglish));
            try {
                job.setTaskResult(this.opNum_0Based, message, false);
            }
            catch (Exception e) {
                Trace.error((Object)this, (String)"addFailure", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeJob() {
        block10: {
            this.jobID = Long.toString(System.currentTimeMillis());
            this.jmgr = JobManagerFactory.create();
            try {
                Vector vectorTasks;
                this.jmgr.init(this.context, null);
                Trace.verbose((Object)this, (String)"initializeJob", (String)("Creating job: " + this.jobID));
                String actionName = UIUtil.getBUIString("se6920.action.name." + this.params.getType());
                String actionDesc = UIUtil.getBUIString2Subst("se6920.action.description", actionName, Integer.toString(this.operands.getSize()));
                Vector taskList = this.operands.getNames();
                Vector vector = vectorTasks = taskList == null ? new Vector() : new Vector(taskList);
                if (this.params.getType() == 100) {
                    actionName = UIUtil.getBUIString(this.operands.getManager().getClass().getName() + "." + this.operands.getManagerMethod());
                    int sz = this.operands.getGenericArguments() == null ? 1 : this.operands.getGenericArguments().size();
                    actionDesc = UIUtil.getBUIString2Subst("se6920.action.description", actionName, Integer.toString(sz));
                    vectorTasks = new Vector(this.operands.getObjectNames());
                    Trace.verbose((Object)this, (String)"initializeJob", (String)("Number of tasks:" + vectorTasks.size()));
                }
                MethodCallStatus mcs = this.jmgr.createUIJob(actionName, this.jobID, actionDesc, vectorTasks);
                Trace.verbose((Object)this, (String)"initializeJob", (String)("After calling jmgr create job: " + this.jobID));
                if (UIUtil.isMCSSuccess(mcs)) {
                    this.job = this.jmgr.getItemByUniqueID(this.jobID);
                    Trace.verbose((Object)this, (String)"initializeJob", (String)("After getting the job instance: " + this.job.getId()));
                    if (this.job != null) {
                        this.async = true;
                        Trace.verbose((Object)this, (String)"initializeJob", (String)("Created job: " + this.jobID));
                        Repository rep = Repository.getRepository();
                        if (rep == null) break block10;
                        this.tasks = (SEActionQueueThread)rep.getProperty((Object)"ActionTaskProperty");
                        if (this.tasks == null || this.tasks.isKilled()) {
                            this.tasks = new SEActionQueueThread(this.context);
                            Repository repository = rep;
                            synchronized (repository) {
                                rep.setProperty((Object)"ActionTaskProperty", (Object)this.tasks);
                            }
                        }
                        this.jmgr.init(this.tasks.getConfigContext(), null);
                        this.job.setConfigContext(this.tasks.getConfigContext());
                        break block10;
                    }
                    this.async = false;
                    this.jobID = null;
                    Trace.error((Object)this, (String)"initializeJob", (String)"Unable to retrieve job, sync operation possible...");
                    break block10;
                }
                this.async = false;
                this.jobID = null;
                Trace.error((Object)this, (String)"initializeJob", (String)"Error creating job, sync operation possible...");
            }
            catch (ConfigMgmtException cex) {
                this.async = false;
                this.jobID = null;
                Trace.error((Object)this, (String)"initializeJob", (String)"UException, unable to create job, sync operation possible...");
            }
        }
        if (!this.async) {
            this.transaction = new SETransaction("com.sun.netstorage.array.mgmt.cfg.bui.resources.Resources");
            this.jobID = NONJOBID;
        }
    }

    private void snapVolume(JobInterface job, Collection key, String name, String lastSnapName) {
        try {
            String snapName = null;
            while ((snapName = "snap" + UIUtil.timeStamp()).equals(lastSnapName)) {
            }
            lastSnapName = snapName;
            Trace.verbose((Object)this, (String)"snapVolume", (String)("Attempting to take snapshot of " + name + ", name:" + snapName));
            ManageSnapShotServicesEnt1Interface smgr = (ManageSnapShotServicesEnt1Interface)this.mgr;
            MethodCallStatus mcs = smgr.createSnapshot(key, snapName, "");
            if (UIUtil.isMCSSuccess(mcs)) {
                this.addSuccess(job, name);
                Trace.verbose((Object)this, (String)"snapVolume", (String)"Snapshot success");
            } else {
                this.addFailure(job, name, "error.cim." + mcs.getReturnCode());
                Trace.error((Object)this, (String)"snapVolume", (String)("Error making snapshot:" + name));
                Trace.error((Object)this, (String)"snapVolume", (String)("DSP err #: " + mcs.getReturnCode()));
            }
        }
        catch (BadParameterException bad) {
            Trace.error((Object)this, (String)"snapVolume", (String)("BadParameter exception snapping volume: " + name));
            Trace.error((Object)this, (String)"snapVolume", (ConfigMgmtException)((Object)bad));
            this.addFailure(job, name, (Exception)((Object)bad));
        }
        catch (ConfigMgmtException cex) {
            Trace.error((Object)this, (String)"snapVolume", (String)("ConfigMgmt exception snapping volume: " + name));
            Trace.error((Object)this, (String)"snapVolume", (ConfigMgmtException)cex);
            this.addFailure(job, name, (Exception)((Object)cex));
        }
    }

    private void deleteVolume(JobInterface job, Collection key, String name) {
        try {
            ManageStorageVolumesInterface vmgr = (ManageStorageVolumesInterface)this.mgr;
            MethodCallStatus mcs = vmgr.delete(key);
            if (UIUtil.isMCSSuccess(mcs)) {
                this.addSuccess(job, name);
                Trace.verbose((Object)this, (String)"deleteVolume", (String)("Deleted volume: " + name));
            } else {
                this.addFailure(job, name, "error.cim." + mcs.getReturnCode());
                Trace.error((Object)this, (String)"deleteVolume", (String)("Error deleting volume: " + name));
                Trace.error((Object)this, (String)"deleteVolume", (String)("DSP err #: " + mcs.getReturnCode()));
            }
        }
        catch (ConfigMgmtException cex) {
            Trace.error((Object)this, (String)"deleteVolume", (String)("ConfigMgmt exception deleting volume: " + name));
            Trace.error((Object)this, (String)"deleteVolume", (ConfigMgmtException)cex);
            this.addFailure(job, name, (Exception)((Object)cex));
        }
        catch (ItemNotFoundException iex) {
            Trace.error((Object)this, (String)"deleteVolume", (String)("ItemNotFound exception deleting volume: " + name));
            Trace.error((Object)this, (String)"deleteVolume", (Throwable)iex);
            this.addFailure(job, name, (Exception)((Object)iex));
        }
    }

    private void deleteProfile(JobInterface job, Collection key, String name) {
        try {
            ManageStorageProfilesInterface pmgr = (ManageStorageProfilesInterface)this.mgr;
            MethodCallStatus mcs = pmgr.delete(key);
            if (UIUtil.isMCSSuccess(mcs)) {
                this.addSuccess(job, name);
                Trace.verbose((Object)this, (String)"deleteProfile", (String)("Deleted profile: " + name));
            } else {
                this.addFailure(job, name, "error.cim." + mcs.getReturnCode());
                Trace.error((Object)this, (String)"deleteProfile", (String)("Error deleting profile: " + name));
                Trace.error((Object)this, (String)"deleteProfile", (String)("DSP err #: " + mcs.getReturnCode()));
            }
        }
        catch (ConfigMgmtException cex) {
            Trace.error((Object)this, (String)"deleteProfile", (String)("ConfigMgmt exception deleting profile: " + name));
            Trace.error((Object)this, (String)"deleteProfile", (ConfigMgmtException)cex);
            this.addFailure(job, name, (Exception)((Object)cex));
        }
        catch (ItemNotFoundException iex) {
            Trace.error((Object)this, (String)"deleteProfile", (String)("ItemNotFound exception deleting profile: " + name));
            Trace.error((Object)this, (String)"deleteProfile", (Throwable)iex);
            this.addFailure(job, name, (Exception)((Object)iex));
        }
    }

    private void deletePool(JobInterface job, Collection key, String name) {
        try {
            ManageStoragePoolsInterface pmgr = (ManageStoragePoolsInterface)this.mgr;
            MethodCallStatus mcs = pmgr.delete(key);
            if (UIUtil.isMCSSuccess(mcs)) {
                this.addSuccess(job, name);
                Trace.verbose((Object)this, (String)"deletePool", (String)("Deleted pool: " + name));
            } else {
                this.addFailure(job, name, "error.cim." + mcs.getReturnCode());
                Trace.error((Object)this, (String)"deletePool", (String)("Error deleting pool: " + name));
                Trace.error((Object)this, (String)"deletePool", (String)("DSP err #: " + mcs.getReturnCode()));
            }
        }
        catch (ConfigMgmtException cex) {
            Trace.error((Object)this, (String)"deletePool", (String)("ConfigMgmt exception deleting pool: " + name));
            Trace.error((Object)this, (String)"deletePool", (ConfigMgmtException)cex);
            this.addFailure(job, name, (Exception)((Object)cex));
        }
        catch (ItemNotFoundException iex) {
            Trace.error((Object)this, (String)"deletePool", (String)("ItemNotFound exception deleting pool: " + name));
            Trace.error((Object)this, (String)"deletePool", (Throwable)iex);
            this.addFailure(job, name, (Exception)((Object)iex));
        }
    }

    private void deleteInitiator(JobInterface job, Collection key, String name) {
        try {
            ManageInitiatorsInterface imgr = (ManageInitiatorsInterface)this.mgr;
            MethodCallStatus mcs = imgr.delete(key);
            if (UIUtil.isMCSSuccess(mcs)) {
                this.addSuccess(job, name);
                Trace.verbose((Object)this, (String)"deleteInitiator", (String)("Deleted initiator: " + name));
            } else {
                this.addFailure(job, name, "error.cim." + mcs.getReturnCode());
                Trace.error((Object)this, (String)"deleteInitiator", (String)("Error deleting initiator: " + name));
                Trace.error((Object)this, (String)"deleteInitiator", (String)("DSP err #: " + mcs.getReturnCode()));
            }
        }
        catch (ConfigMgmtException cex) {
            Trace.error((Object)this, (String)"deleteInitiator", (String)("ConfigMgmt exception deleting initiator: " + name));
            Trace.error((Object)this, (String)"deleteInitiator", (ConfigMgmtException)cex);
            this.addFailure(job, name, (Exception)((Object)cex));
        }
        catch (ItemNotFoundException iex) {
            Trace.error((Object)this, (String)"deleteInitiator", (String)("ItemNotFound exception deleting initiator: " + name));
            Trace.error((Object)this, (String)"deleteInitiator", (Throwable)iex);
            this.addFailure(job, name, (Exception)((Object)iex));
        }
    }

    private void deleteVDisk(JobInterface job, Collection key, String name) {
        try {
            ManageVDisksInterface vmgr = (ManageVDisksInterface)this.mgr;
            MethodCallStatus mcs = vmgr.delete(key);
            if (UIUtil.isMCSSuccess(mcs)) {
                this.addSuccess(job, name);
                Trace.verbose((Object)this, (String)"deleteVDisk", (String)("Deleted vdisk: " + name));
            } else {
                this.addFailure(job, name, "error.cim." + mcs.getReturnCode());
                Trace.error((Object)this, (String)"deleteVDisk", (String)("Error deleting vdisk: " + name));
                Trace.error((Object)this, (String)"deleteVDisk", (String)("DSP err #: " + mcs.getReturnCode()));
            }
        }
        catch (ConfigMgmtException cex) {
            Trace.error((Object)this, (String)"deleteVDisk", (String)("ConfigMgmt exception deleting vdisk: " + name));
            Trace.error((Object)this, (String)"deleteVDisk", (ConfigMgmtException)cex);
            this.addFailure(job, name, (Exception)((Object)cex));
        }
        catch (ItemNotFoundException iex) {
            Trace.error((Object)this, (String)"deleteVDisk", (String)("ItemNotFound exception deleting vdisk: " + name));
            Trace.error((Object)this, (String)"deleteVDisk", (Throwable)iex);
            this.addFailure(job, name, (Exception)((Object)iex));
        }
    }

    private void mapVolume(JobInterface job, StorageVolumeInterface volume, String name, int lun, Set permission, InitiatorInterface initiator) {
        block7: {
            if (volume != null) {
                try {
                    MethodCallStatus mcs = null;
                    if (lun >= 0) {
                        Trace.verbose((Object)this, (String)"mapVolume", (String)("Map to LUN: " + lun));
                        mcs = volume.createMapping(lun, permission, initiator);
                    } else {
                        Trace.verbose((Object)this, (String)"mapVolume", (String)"Map to next available LUN");
                        mcs = volume.createMapping(permission, initiator);
                    }
                    if (UIUtil.isMCSSuccess(mcs)) {
                        Trace.verbose((Object)this, (String)"mapVolume", (String)("Mapped successfully: " + name));
                        this.addSuccess(job, name);
                        break block7;
                    }
                    Trace.error((Object)this, (String)"mapVolume", (String)("Mapping failure: " + name));
                    Trace.error((Object)this, (String)"mapVolume", (String)UIUtil.getEnglishBUIString("error.cim." + mcs.getReturnCode()));
                    this.addFailure(job, name, "error.cim." + mcs.getReturnCode());
                }
                catch (ConfigMgmtException ex) {
                    Trace.error((Object)this, (String)"mapVolume", (String)("ConfigMgmt exception mapping volume: " + name));
                    Trace.error((Object)this, (String)"mapVolume", (ConfigMgmtException)ex);
                    this.addFailure(job, name, (Exception)((Object)ex));
                }
            } else {
                Trace.error((Object)this, (String)"mapVolume", (String)("Error mapping :" + name + ", volume is null"));
                this.addFailure(job, name, "se6x20ui.error.systemerror");
            }
        }
    }

    private void mapInitiator(JobInterface job, InitiatorInterface initiator, String name, int lun, Set permission, StorageVolumeInterface volume) {
        block7: {
            if (initiator != null) {
                try {
                    MethodCallStatus mcs = null;
                    if (lun >= 0) {
                        Trace.verbose((Object)this, (String)"mapInitiator", (String)("Map to LUN: " + lun));
                        mcs = initiator.createMapping(lun, permission, volume);
                    } else {
                        Trace.verbose((Object)this, (String)"mapInitiator", (String)"Map to next available LUN");
                        mcs = initiator.createMapping(permission, volume);
                    }
                    if (UIUtil.isMCSSuccess(mcs)) {
                        Trace.verbose((Object)this, (String)"mapInitiator", (String)("Mapped successfully: " + name));
                        this.addSuccess(job, name);
                        break block7;
                    }
                    Trace.error((Object)this, (String)"mapInitiator", (String)("Mapping failure: " + name));
                    Trace.error((Object)this, (String)"mapInitiator", (String)UIUtil.getEnglishBUIString("error.cim." + mcs.getReturnCode()));
                    this.addFailure(job, name, "error.cim." + mcs.getReturnCode());
                }
                catch (ConfigMgmtException ex) {
                    Trace.error((Object)this, (String)"mapInitiator", (String)("ConfigMgmt exception mapping initiator: " + name));
                    Trace.error((Object)this, (String)"mapInitiator", (ConfigMgmtException)ex);
                    this.addFailure(job, name, (Exception)((Object)ex));
                }
            } else {
                Trace.error((Object)this, (String)"mapInitiator", (String)("Error mapping :" + name + ", initiator is null"));
                this.addFailure(job, name, "se6x20ui.error.systemerror");
            }
        }
    }

    private void unmap(JobInterface job, Object unmapFrom, Collection key, String name) {
        block10: {
            if (unmapFrom != null) {
                try {
                    MethodCallStatus mcs = null;
                    if (unmapFrom instanceof StorageVolumeInterface) {
                        ManageInitiatorsInterface imgr = ManageInitiatorsFactory.getManager();
                        imgr.init(this.context, null);
                        InitiatorInterface initiator = imgr.getByKey(key);
                        mcs = ((StorageVolumeInterface)unmapFrom).removeMapping(initiator);
                    } else if (unmapFrom instanceof InitiatorInterface) {
                        ManageStorageVolumesInterface vmgr = ManageStorageVolumesFactory.getManager();
                        vmgr.init(this.context, null);
                        StorageVolumeInterface volume = vmgr.getByKey(key);
                        mcs = ((InitiatorInterface)unmapFrom).removeMapping(volume);
                    } else {
                        Trace.error((Object)this, (String)"unmap", (String)"unsupported object type in unmapFrom");
                    }
                    if (UIUtil.isMCSSuccess(mcs)) {
                        Trace.verbose((Object)this, (String)"unmap", (String)("Mapping deleted:" + name));
                        this.addSuccess(job, name);
                        break block10;
                    }
                    Trace.error((Object)this, (String)"unmap", (String)("Mapping NOT deleted: " + name));
                    Trace.error((Object)this, (String)"unmap", (String)UIUtil.getEnglishBUIString("error.cim." + mcs.getReturnCode()));
                    this.addFailure(job, name, "error.cim." + mcs.getReturnCode());
                }
                catch (ConfigMgmtException cex) {
                    Trace.error((Object)this, (String)"unmap", (String)("ConfigMgmt exception unmapping: " + name));
                    Trace.error((Object)this, (String)"unmap", (ConfigMgmtException)cex);
                    this.addFailure(job, name, (Exception)((Object)cex));
                }
                catch (ItemNotFoundException iex) {
                    Trace.error((Object)this, (String)"unmap", (String)("ItemNotFound exception unmapping: " + name));
                    Trace.error((Object)this, (String)"unmap", (Throwable)iex);
                    this.addFailure(job, name, (Exception)((Object)iex));
                }
            } else {
                Trace.error((Object)this, (String)"unmap", (String)("Error unmapping: " + name + ", parent is null"));
                this.addFailure(job, name, "se6x20ui.error.systemerror");
            }
        }
    }

    private void deleteSnapshot(JobInterface job, Object parent, Collection key, String name) {
        block8: {
            if (parent != null) {
                if (parent instanceof StorageVolumeInterface) {
                    try {
                        StorageVolumeInterface volume = (StorageVolumeInterface)parent;
                        MethodCallStatus mcs = volume.deleteSnapshot(key);
                        if (UIUtil.isMCSSuccess(mcs)) {
                            Trace.verbose((Object)this, (String)"deleteSnapshot", (String)("Deleted snapshot: " + name));
                            this.addSuccess(job, name);
                            break block8;
                        }
                        Trace.error((Object)this, (String)"deleteSnapshot", (String)("Error deleting snapshot: " + name));
                        Trace.error((Object)this, (String)"deleteSnapshot", (String)("DSP err #: " + mcs.getReturnCode()));
                        this.addFailure(job, name, "error.cim." + mcs.getReturnCode());
                    }
                    catch (ConfigMgmtException cex) {
                        Trace.error((Object)this, (String)"deleteSnapshot", (String)("ConfigMgmt deleting snapshot: " + name));
                        Trace.error((Object)this, (String)"deleteSnapshot", (ConfigMgmtException)cex);
                        this.addFailure(job, name, (Exception)((Object)cex));
                    }
                    catch (ItemNotFoundException iex) {
                        Trace.error((Object)this, (String)"deleteSnapshot", (String)("ItemNotFound deleting snapshot: " + name));
                        Trace.error((Object)this, (String)"deleteSnapshot", (Throwable)iex);
                        this.addFailure(job, name, (Exception)((Object)iex));
                    }
                } else {
                    Trace.error((Object)this, (String)"deleteSnapshot", (String)("Error deleting snapshot: " + name + ", parent not a StorageVolumeInterface"));
                    this.addFailure(job, name, "se6x20ui.error.systemerror");
                }
            } else {
                Trace.error((Object)this, (String)"deleteSnapshot", (String)("Error deleting snapshot: " + name + ", parent is null"));
                this.addFailure(job, name, "se6x20ui.error.systemerror");
            }
        }
    }

    private void resnapSnapshot(JobInterface job, Collection key, String name) {
        try {
            ManageStorageVolumesInterface vmgr = (ManageStorageVolumesInterface)this.mgr;
            StorageVolumeInterface snapshot = vmgr.getByKey(key);
            Trace.verbose((Object)this, (String)"resnapSnapshot", (String)("Resnapping snapshot:" + name));
            MethodCallStatus mcs = snapshot.resetSnapshot();
            if (UIUtil.isMCSSuccess(mcs)) {
                Trace.verbose((Object)this, (String)"resnapSnapshot", (String)("Resnapped snapshot: " + name));
                this.addSuccess(job, name);
            } else {
                Trace.error((Object)this, (String)"resnapSnapshot", (String)("Error resnapping snapshot: " + name));
                Trace.error((Object)this, (String)"resnapSnapshot", (String)("DSP err #: " + mcs.getReturnCode()));
                this.addFailure(job, name, "error.cim." + mcs.getReturnCode());
            }
        }
        catch (ConfigMgmtException cex) {
            Trace.error((Object)this, (String)"resnapSnapshot", (String)("ConfigMgmt exception resnapping snapshot: " + name));
            Trace.error((Object)this, (String)"resnapSnapshot", (ConfigMgmtException)cex);
            this.addFailure(job, name, (Exception)((Object)cex));
        }
    }

    private void removeJob(JobInterface job, String id) {
        JobManagerInterface jmgr = (JobManagerInterface)this.mgr;
        jmgr.setShowAllJobs(true);
        List jobList = null;
        try {
            jobList = jmgr.getItemList();
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, (String)"removeJob", (String)"Unable to get list of historical jobs");
            Trace.error((Object)this, (String)"removeJob", (ConfigMgmtException)cme);
            this.addFailure(job, id, (Exception)((Object)cme));
            return;
        }
        int numJobs = jobList.size();
        for (int i = 0; i < numJobs; ++i) {
            JobInterface jobIF = (JobInterface)jobList.get(i);
            if (!jobIF.getId().equals(id)) continue;
            try {
                jobIF.delete();
                Trace.verbose((Object)this, (String)"removeJob", (String)("Removed job:" + id));
                this.addSuccess(job, id);
            }
            catch (ConfigMgmtException cme) {
                Trace.error((Object)this, (String)"removeJob", (String)("ConfigMgmt exception removing job: " + id));
                Trace.error((Object)this, (String)"removeJob", (ConfigMgmtException)cme);
                this.addFailure(job, id, (Exception)((Object)cme));
            }
            break;
        }
    }

    private void cancelJob(JobInterface job, String id) {
        JobManagerInterface jmgr = (JobManagerInterface)this.mgr;
        jmgr.setShowAllJobs(false);
        List jobList = null;
        try {
            jobList = jmgr.getItemList();
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, (String)"cancelJob", (String)"Unable to get list of current jobs");
            Trace.error((Object)this, (String)"cancelJob", (ConfigMgmtException)cme);
            this.addFailure(job, id, (Exception)((Object)cme));
            return;
        }
        int numJobs = jobList.size();
        for (int i = 0; i < numJobs; ++i) {
            JobInterface jobIF = (JobInterface)jobList.get(i);
            if (!jobIF.getId().equals(id)) continue;
            try {
                jobIF.kill();
                Trace.verbose((Object)this, (String)"cancelJob", (String)("Cancelled job:" + id));
                this.addSuccess(job, id);
            }
            catch (ConfigMgmtException cme) {
                Trace.error((Object)this, (String)"cancelJob", (String)("ConfigMgmt exception cancelling job: " + id));
                Trace.error((Object)this, (String)"cancelJob", (ConfigMgmtException)cme);
                this.addFailure(job, id, (Exception)((Object)cme));
            }
            break;
        }
    }

    private void deleteRepSet(JobInterface job, Collection key, String name) {
        try {
            ManageReplicationServicesEnt1Interface rsmgr = (ManageReplicationServicesEnt1Interface)this.mgr;
            MethodCallStatus mcs = rsmgr.delete((Object)key);
            if (UIUtil.isMCSSuccess(mcs)) {
                this.addSuccess(job, name);
                Trace.verbose((Object)this, (String)"deleteRepSet", (String)("Deleted replication set: " + name));
            } else {
                this.addFailure(job, name, "error.cim." + mcs.getReturnCode());
                Trace.error((Object)this, (String)"deleteRepSet", (String)("Error deleting replication set: " + name));
                Trace.error((Object)this, (String)"deleteRepSet", (String)("DSP err #: " + mcs.getReturnCode()));
            }
        }
        catch (ConfigMgmtException cex) {
            Trace.error((Object)this, (String)"deleteRepSet", (String)("ConfigMgmt exception deleting replication set: " + name));
            Trace.error((Object)this, (String)"deleteRepSet", (ConfigMgmtException)cex);
            this.addFailure(job, name, (Exception)((Object)cex));
        }
    }
}

