/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.bui.utilities;

import com.iplanet.jato.RequestManager;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.UIUtil;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.FeatureNotSupportedException;
import com.sun.netstorage.array.mgmt.cfg.core.ini.Repository;
import com.sun.netstorage.array.mgmt.cfg.util.Convert;
import com.sun.netstorage.array.mgmt.cfg.util.Size;
import com.sun.netstorage.array.mgmt.cfg.util.XMLUtils;
import com.sun.web.ui.model.CCActionTableModel;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.beanutils.PropertyUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class CoreModel
extends CCActionTableModel {
    public static final String SIZE_CONVERT_METHOD = "sizeInBytesToLocalizableSize";
    private static final String PARTIAL_MODEL_POPULATION_PARAM = "partial-model-population";
    public static final String NAME_PROPERTY = "name";
    private static final boolean partialPopulation = Repository.getRepository().getProperty((Object)"partial-model-population") == null ? false : new Boolean((String)Repository.getRepository().getProperty((Object)"partial-model-population"));
    private static String[] rawCompareFields = new String[]{"size", "rawTotalCapacity", "rawAvailableCapacity", "maxVolumeSize", "configuredCapacity", "totalCapacity"};
    String xmlFile = null;
    Document document = null;
    Document transDoc = null;
    List savedData = null;
    HashMap convert = new HashMap();
    HashMap prefix = new HashMap();
    HashMap suffix = new HashMap();
    boolean isPopulated = false;
    String primarySortName = null;
    String primarySortOrder = null;
    int[] si = null;

    public CoreModel(String xFile) {
        this(RequestManager.getRequestContext().getServletContext(), xFile);
    }

    public CoreModel(ServletContext ctx, String xFile) {
        super(ctx, xFile);
        this.xmlFile = xFile;
        this.document = this.getDocument();
        this.transDoc = this.parseFile(this.xmlFile + "t");
        if (partialPopulation) {
            this.setAvailableRows(0);
            this.setMaxRows(15);
            this.setPage(1);
        }
        this.isPopulated = false;
        this.initHeaders(this.document);
        Trace.verbose((Object)((Object)this), (String)"constructor", (String)("Used XML:" + this.xmlFile));
    }

    private int getValidIndex(int row) {
        int result = row;
        if (this.getAvailableRows() > -1) {
            row = Math.min(Math.max(row, 0), this.getAvailableRows());
        }
        return row;
    }

    public int getFirstRow() {
        if (!partialPopulation) {
            return super.getFirstRow();
        }
        int page = super.getPage() > 0 ? super.getPage() : 1;
        int row = this.getShowPaginationControls() == null || this.getShowPaginationControls() != false ? (page - 1) * this.getMaxRows() + 1 : 0;
        int fri = this.getValidIndex(row);
        super.setFirstRowIndex(fri);
        return fri;
    }

    public void sort() {
    }

    public int[] getSortIndex() {
        if (this.si == null) {
            int numOfRows = this.getNumRows();
            this.si = new int[numOfRows];
            for (int i = 0; i < numOfRows; ++i) {
                this.si[i] = i;
            }
        }
        return this.si;
    }

    public int getLastRow() {
        if (!partialPopulation) {
            return super.getLastRow();
        }
        int row = this.getFirstRow() + this.getMaxRows() - 1;
        return this.getValidIndex(row);
    }

    public void setShowPaginationControls(boolean arg0) {
        Trace.verbose((Object)((Object)this), (String)"setShowPaginationControls", (String)("Show paginationControls:" + arg0));
        if (partialPopulation && (this.getShowPaginationControls() == null || this.getShowPaginationControls() != arg0) && this.savedData != null) {
            int sz = this.savedData.size();
            this.setAvailableRows(sz);
            if (!arg0 && sz > this.getMaxRows()) {
                this.setMaxRows(sz);
            } else {
                this.setMaxRows(15);
            }
            try {
                this.initModelRows(this.savedData);
            }
            catch (ConfigMgmtException e) {
                Trace.error((Object)((Object)this), (String)"setShowPaginationControls", (ConfigMgmtException)e);
            }
        } else {
            Trace.verbose((Object)((Object)this), (String)"setShowPaginationControls", (String)("Not setting values:" + this.getAvailableRows() + " maxRows:" + this.getMaxRows()));
        }
        super.setShowPaginationControls(arg0);
    }

    public void setPage(int arg0) {
        super.setPage(arg0);
        if (partialPopulation && this.savedData != null) {
            try {
                this.initModelRows(this.savedData);
                if (this.getShowPaginationControls() != null) {
                    if (this.getShowPaginationControls().booleanValue()) {
                        this.setMaxRows(15);
                    } else if (this.savedData.size() > this.getMaxRows()) {
                        this.setMaxRows(this.getAvailableRows());
                    }
                }
            }
            catch (ConfigMgmtException e) {
                Trace.error((Object)((Object)this), (String)"setPage", (ConfigMgmtException)e);
            }
        }
    }

    public int getFirstRowIndex() {
        if (!partialPopulation) {
            return super.getFirstRowIndex();
        }
        return 0;
    }

    public int getLastRowIndex() {
        if (!partialPopulation) {
            return super.getLastRowIndex();
        }
        Trace.verbose((Object)((Object)this), (String)"getLastRowIndex", (String)("Return last row index as:" + this.getAvailableRows()));
        super.setLastRowIndex(this.getAvailableRows());
        return this.getAvailableRows();
    }

    private Document parseFile(String xFile) {
        InputStream in = RequestManager.getRequestContext().getServletContext().getResourceAsStream(xFile);
        return XMLUtils.parseFile((InputStream)in);
    }

    protected void initHeaders(Document doc) {
        Element root = this.document.getDocumentElement();
        NodeList nl = root.getElementsByTagName("column");
        int size = nl == null ? 0 : nl.getLength();
        for (int i = 0; i < size; ++i) {
            String name = ((Element)nl.item(i)).getAttribute(NAME_PROPERTY);
            this.setActionValue(name, name);
        }
    }

    public void setPrimarySortName(String arg0) {
        if (partialPopulation) {
            Trace.verbose((Object)((Object)this), (String)"setPrimarySortName", (String)("Existing primary sortName:" + super.getPrimarySortName() + " new:" + arg0));
            if ((this.getPrimarySortName() == null && arg0 != null || !arg0.equals(this.getPrimarySortName())) && this.savedData != null) {
                LocalModelComparator comp = new LocalModelComparator(arg0, this.getPrimarySortOrder());
                if (this.isRawCompare(arg0)) {
                    comp.setRawCompare(true);
                }
                try {
                    Collections.sort(this.savedData, comp);
                    this.initModelRows(this.savedData);
                }
                catch (Exception e) {
                    Trace.error((Object)((Object)this), (String)"setPrimarySortName", (Throwable)e);
                }
            }
        }
        super.setPrimarySortName(arg0);
    }

    public void setPrimarySortOrder(String arg0) {
        if (partialPopulation) {
            Trace.verbose((Object)((Object)this), (String)"setPrimarySortOrder", (String)("Existing primary sortOrder:" + super.getPrimarySortOrder() + " new:" + arg0));
            if ((this.getPrimarySortOrder() == null && arg0 != null || !arg0.equals(this.getPrimarySortOrder())) && this.savedData != null) {
                String psn = this.getPrimarySortName();
                LocalModelComparator comp = new LocalModelComparator(psn, arg0);
                if (this.isRawCompare(psn)) {
                    comp.setRawCompare(true);
                }
                try {
                    Collections.sort(this.savedData, comp);
                    this.initModelRows(this.savedData);
                }
                catch (Exception e) {
                    Trace.error((Object)((Object)this), (String)"setPrimarySortOrder", (Throwable)e);
                }
            }
        }
        super.setPrimarySortOrder(arg0);
    }

    private boolean isRawCompare(String sortByFieldName) {
        boolean rawComp = false;
        if (sortByFieldName == null) {
            return rawComp;
        }
        for (int i = 0; i < rawCompareFields.length && !rawComp; ++i) {
            if (!sortByFieldName.equals(rawCompareFields[i])) continue;
            rawComp = true;
        }
        return rawComp;
    }

    public void initModelRows(List data) throws ConfigMgmtException {
        String methodName = "initModelRows";
        Trace.methodBegin((Object)((Object)this), (String)"PROFILE: initModelRows");
        this.isPopulated = true;
        if (partialPopulation && data != null && (this.savedData == null || !((Object)this.savedData).equals(data))) {
            if (this.getPrimarySortName() == null) {
                super.setPrimarySortName(NAME_PROPERTY);
            }
            if (this.getPrimarySortOrder() == null) {
                super.setPrimarySortOrder("ascending");
            }
            LocalModelComparator comp = new LocalModelComparator(this.getPrimarySortName(), this.getPrimarySortOrder());
            try {
                Collections.sort(data, comp);
            }
            catch (Exception e) {
                Trace.error((Object)((Object)this), (String)"initModelRows", (Throwable)e);
            }
            this.savedData = data;
            Trace.verbose((Object)((Object)this), (String)"initModelRows", (String)"PROFILE: Sort complete");
        }
        boolean shouldClearSelections = RequestManager.getRequest().getAttribute("leave-selections") == null;
        this.clear();
        this.clearModelData();
        if (data == null) {
            Trace.verbose((Object)((Object)this), (String)"initModelRows", (String)"This model has NO DATA!");
            this.setAvailableRows(0);
            return;
        }
        List columnsToSet = new ArrayList();
        if (data != null && !data.isEmpty()) {
            columnsToSet = this.getColumnsToSet();
        }
        this.convert = new HashMap();
        this.prefix = new HashMap();
        this.suffix = new HashMap();
        if (this.transDoc != null) {
            this.mapTranslations(this.transDoc, this.convert, "convert");
            this.mapTranslations(this.transDoc, this.prefix, "prefix");
            this.mapTranslations(this.transDoc, this.suffix, "suffix");
        }
        long appendRowTime = 0L;
        long setRowPropsTime = 0L;
        int firstRow = 0;
        int lastRow = 0;
        if (data != null) {
            int dataSize = data.size();
            this.setAvailableRows(dataSize);
            super.setLastRowIndex(dataSize);
            if (this.getMaxRows() == 0 && dataSize > 0) {
                this.setMaxRows(dataSize);
            }
            if (partialPopulation) {
                firstRow = this.getFirstRow() - 1;
                if (firstRow < 0) {
                    firstRow = 0;
                }
                lastRow = Math.min(this.getLastRow(), dataSize - 1);
            } else {
                firstRow = 0;
                lastRow = data.size() - 1;
            }
            long ct = 0L;
            this.si = new int[lastRow - firstRow + 1];
            Trace.verbose((Object)((Object)this), (String)"initModelRows", (String)("First row:" + firstRow + " lastRow:" + lastRow));
            int i = firstRow;
            int j = 0;
            while (i <= lastRow) {
                if (Trace.isTraceEnabled((Object)((Object)this))) {
                    ct = System.currentTimeMillis();
                }
                this.appendRow();
                this.si[j] = j;
                if (Trace.isTraceEnabled((Object)((Object)this))) {
                    appendRowTime += System.currentTimeMillis() - ct;
                }
                if (shouldClearSelections) {
                    this.setRowSelected(false);
                }
                if (Trace.isTraceEnabled((Object)((Object)this))) {
                    ct = System.currentTimeMillis();
                }
                this.setRowProperties(data.get(i), columnsToSet, this.convert, this.prefix, this.suffix);
                if (Trace.isTraceEnabled((Object)((Object)this))) {
                    setRowPropsTime += System.currentTimeMillis() - ct;
                }
                ++i;
                ++j;
            }
        }
        if (data != null && data.size() > 0) {
            this.setRowIndex(0);
            this.setRowProperties(data.get(firstRow), columnsToSet, this.convert, this.prefix, this.suffix);
        }
        if (Trace.isTraceEnabled((Object)((Object)this))) {
            try {
                Trace.verbose((Object)((Object)this), (String)"initModelRows", (String)("First row:" + PropertyUtils.getProperty(data.get(firstRow), (String)NAME_PROPERTY)));
            }
            catch (Throwable t) {
                // empty catch block
            }
            Trace.verbose((Object)((Object)this), (String)"initModelRows", (String)"PROFILE: model created and data is populated");
            Trace.verbose((Object)((Object)this), (String)"initModelRows", (String)("PROFILE: All row append time:" + appendRowTime));
            Trace.verbose((Object)((Object)this), (String)"initModelRows", (String)("PROFILE: All set row properties time:" + setRowPropsTime));
        }
    }

    public Integer[] getSelectedRows() {
        Integer[] selRows = null;
        if (!partialPopulation) {
            return super.getSelectedRows();
        }
        if (this.getSelectionType() == null) {
            if ((selRows = this.processSingleSelection(selRows, this.getTableName())) == null || selRows.length == 0) {
                selRows = this.processMultiSelection(this.getTableName());
            }
        } else if (this.getSelectionType().equals("single")) {
            selRows = this.processSingleSelection(selRows, this.getTableName());
        } else if (this.getSelectionType().equals("multiple")) {
            selRows = this.processMultiSelection(this.getTableName());
        }
        return selRows;
    }

    public Integer[] getSelectedTableRows(String tableName) {
        Integer[] selRows = null;
        if (!partialPopulation) {
            return super.getSelectedRows();
        }
        if (this.getSelectionType().equals("single")) {
            selRows = this.processSingleSelection(selRows, tableName);
        } else if (this.getSelectionType().equals("multiple")) {
            selRows = this.processMultiSelection(tableName);
        }
        return selRows;
    }

    public boolean isPartialPopulation() {
        return partialPopulation;
    }

    public boolean isPopulated() {
        return this.savedData != null && !this.savedData.isEmpty();
    }

    private void mergeJatoSelections(List selI) {
        Integer[] jsi = super.getSelectedRows();
        if (jsi != null && jsi.length > 0) {
            for (int i = 0; i < jsi.length; ++i) {
                if (selI.contains(jsi[i])) continue;
                selI.add(jsi[i]);
            }
        }
    }

    private Integer[] processMultiSelection(String tableName) {
        String fieldName = tableName + ".SelectionCheckbox";
        String fnJB = fieldName + ".jato_boolean";
        HttpServletRequest req = RequestManager.getRequest();
        Enumeration en = req.getParameterNames();
        ArrayList<Integer> selI = new ArrayList<Integer>();
        while (en.hasMoreElements()) {
            String pn = (String)en.nextElement();
            int ind = pn.indexOf(fieldName);
            if (ind < 0 || pn.indexOf(fnJB) >= 0) continue;
            String val = req.getParameter(pn);
            Trace.verbose((Object)((Object)this), (String)"getSelectedRows", (String)("PROFILE: parameter:" + pn + " has value:" + val));
            if (val == null || !"true".equals(val)) continue;
            String sin = pn.substring(ind + fieldName.length());
            Trace.verbose((Object)((Object)this), (String)"getSelectedRows", (String)("PROFILE: set selected index:" + sin));
            Integer si = new Integer(sin);
            this.setRowSelected(si, true);
            selI.add(si);
        }
        this.mergeJatoSelections(selI);
        Integer[] selRows = new Integer[selI.size()];
        for (int i = 0; i < selI.size(); ++i) {
            selRows[i] = (Integer)selI.get(i);
        }
        return selRows;
    }

    private Integer[] processSingleSelection(Integer[] selRows, String tableName) {
        String fieldName = tableName + ".SelectionRadiobutton";
        String fnJB = fieldName + ".jato_boolean";
        HttpServletRequest req = RequestManager.getRequest();
        Enumeration en = req.getParameterNames();
        while (en.hasMoreElements() && selRows == null) {
            String pn = (String)en.nextElement();
            int ind = pn.indexOf(fieldName);
            if (ind < 0 || pn.indexOf(fnJB) >= 0) continue;
            String val = req.getParameter(pn);
            Trace.verbose((Object)((Object)this), (String)"getSelectedRows", (String)("PROFILE: parameter:" + pn + "; has value:" + val));
            selRows = new Integer[]{new Integer(val)};
        }
        if (selRows == null || selRows.length == 0) {
            selRows = super.getSelectedRows();
        }
        return selRows;
    }

    public String getTableName() {
        String tableName = "";
        if (this.xmlFile != null) {
            int nameStartIndex = this.xmlFile.lastIndexOf("/");
            Trace.verbose((Object)((Object)this), (String)"getChildActionTableName", (String)("last index is:" + nameStartIndex));
            if (nameStartIndex >= 0 && this.xmlFile.length() > nameStartIndex) {
                tableName = this.xmlFile.substring(nameStartIndex + 1);
                Trace.verbose((Object)((Object)this), (String)"getChildName", (String)("Table Name phase1:" + tableName));
            } else {
                tableName = this.xmlFile;
            }
            int nameEndIndex = tableName.lastIndexOf(".");
            if (nameEndIndex >= 0) {
                tableName = tableName.substring(0, nameEndIndex);
            }
        }
        return tableName;
    }

    private void mapTranslations(Document doc, Map map, String nodeName) {
        NodeList l = doc.getElementsByTagName(nodeName);
        if (l != null && l.item(0) != null) {
            NodeList nl = ((Element)l.item(0)).getElementsByTagName("column");
            int size = nl == null ? 0 : nl.getLength();
            for (int i = 0; i < size; ++i) {
                Element el = (Element)nl.item(i);
                if (Trace.isTraceEnabled((Object)((Object)this))) {
                    Trace.verbose((Object)((Object)this), (String)"mapTranslations", (String)("MAP:" + nodeName + " name:" + el.getAttribute(NAME_PROPERTY) + " value:" + el.getAttribute("with")));
                }
                map.put(el.getAttribute(NAME_PROPERTY), el.getAttribute("with"));
            }
        }
    }

    private List getColumnsToSet() {
        ArrayList<String> columnList = new ArrayList<String>();
        NodeList nl = this.document.getDocumentElement().getElementsByTagName("column");
        int size = nl == null ? 0 : nl.getLength();
        for (int i = 0; i < size; ++i) {
            Element column = (Element)nl.item(i);
            NodeList ccnl = column.getElementsByTagName("cc");
            int ccsize = ccnl == null ? 0 : ccnl.getLength();
            for (int j = 0; j < ccsize; ++j) {
                Element cc = (Element)ccnl.item(j);
                columnList.add(cc.getAttribute(NAME_PROPERTY));
            }
        }
        return columnList;
    }

    protected void setRowProperties(Object data, List columnsToSet, Map convert, Map prefix, Map suffix) throws ConfigMgmtException, FeatureNotSupportedException {
        int size = columnsToSet == null ? 0 : columnsToSet.size();
        for (int i = 0; i < size; ++i) {
            String columnName = (String)columnsToSet.get(i);
            try {
                this.setOneColumn(data, convert, prefix, suffix, columnName, columnName);
            }
            catch (IllegalAccessException e) {
                Trace.verbose((Object)((Object)this), (String)"setRowPropertties", (String)e.getMessage());
            }
            catch (InvocationTargetException e) {
                Trace.verbose((Object)((Object)this), (String)"setRowPropertties", (String)e.getMessage());
            }
            catch (NoSuchMethodException e) {
                try {
                    if (((String)columnsToSet.get(i)).length() > 5) {
                        String newName = ((String)columnsToSet.get(i)).substring(5);
                        this.setOneColumn(data, convert, prefix, suffix, columnName, newName);
                    }
                }
                catch (IllegalAccessException e1) {
                    Trace.verbose((Object)((Object)this), (String)"setRowPropertties", (String)e.getMessage());
                }
                catch (InvocationTargetException e1) {
                    Trace.verbose((Object)((Object)this), (String)"setRowPropertties", (String)e.getMessage());
                }
                catch (NoSuchMethodException e1) {
                    Trace.verbose((Object)((Object)this), (String)"setRowPropertties", (String)e.getMessage());
                }
            }
            this.setCustomProps(data, columnName);
        }
    }

    private void setOneColumn(Object data, Map convert, Map prefix, Map suffix, String columnName, String fieldName) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object valueToSet = "";
        valueToSet = this.getValueToSetInColumn(data, convert, prefix, suffix, columnName, fieldName);
        this.setValue(columnName, valueToSet);
    }

    public Object getChildValueFromRequest(String arg0) {
        if (partialPopulation) {
            HttpServletRequest req = RequestManager.getRequest();
            return RequestManager.getRequest().getParameter(arg0);
        }
        return super.getValue(arg0);
    }

    private Object getValueToSetInColumn(Object data, Map convert, Map prefix, Map suffix, String columnName, String fieldName) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        String newVal = "";
        Object prop = PropertyUtils.getProperty((Object)data, (String)fieldName);
        if (convert.get(fieldName) != null) {
            prop = this.convertValue(convert, fieldName, prop);
        } else if (convert.get(columnName) != null) {
            prop = this.convertValue(convert, columnName, prop);
        }
        if (prefix.get(fieldName) != null && prop != null) {
            newVal = (String)prefix.get(fieldName) + prop;
        }
        if (suffix.get(fieldName) != null && prop != null) {
            newVal = newVal + prop + " " + UIUtil.getBUIString((String)suffix.get(fieldName));
        }
        Object valueToSet = newVal.equals("") ? (prop == null ? "empty.table.data" : prop) : newVal;
        return valueToSet;
    }

    private Object convertValue(Map convert, String columnName, Object prop) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (prop == null) {
            return null;
        }
        try {
            Object retobj;
            Class<?> cls = Class.forName("com.sun.netstorage.array.mgmt.cfg.util.Convert");
            String convertMethodName = (String)convert.get(columnName);
            if (convertMethodName == null) {
                Trace.error((Object)((Object)this), (String)"convertValue", (String)("Could not find convert method for:" + columnName));
                return null;
            }
            if (convertMethodName != null && SIZE_CONVERT_METHOD.equals(convertMethodName)) {
                Locale locale = UIUtil.getLocale();
                Class[] paramTypes = new Class[]{prop.getClass(), locale.getClass()};
                Method meth = cls.getMethod(convertMethodName, paramTypes);
                Object[] arglist = new Object[]{prop, locale};
                Object retobj2 = meth.invoke((Object)new Convert(), arglist);
                Size size = (Size)retobj2;
                return UIUtil.getDisplaySize(size);
            }
            if (convertMethodName.equalsIgnoreCase("dateTimeToLocalString") || convertMethodName.equalsIgnoreCase("longSecToDateString")) {
                Locale locale = UIUtil.getLocale();
                Class[] paramTypes = new Class[]{prop.getClass(), locale.getClass()};
                Method meth = cls.getMethod(convertMethodName, paramTypes);
                Object[] arglist = new Object[]{prop, locale};
                Object retobj3 = meth.invoke((Object)new Convert(), arglist);
                return retobj3;
            }
            Class[] partypes = new Class[]{prop.getClass()};
            Method meth = cls.getMethod(convertMethodName, partypes);
            Object[] arglist = new Object[]{prop};
            prop = retobj = meth.invoke((Object)new Convert(), arglist);
        }
        catch (SecurityException e1) {
            Trace.error((Object)((Object)this), (Throwable)e1);
        }
        catch (IllegalArgumentException e1) {
            Trace.error((Object)((Object)this), (Throwable)e1);
        }
        catch (ClassNotFoundException e1) {
            Trace.error((Object)((Object)this), (Throwable)e1);
        }
        return prop;
    }

    protected boolean setCustomProps(Object data, String columnToSet) {
        return false;
    }

    class LocalModelComparator
    implements Comparator {
        String propertyName = null;
        String sortOrder = null;
        boolean rawCompare = false;

        public LocalModelComparator(String cName, String cOrder) {
            if (cName == null) {
                cName = CoreModel.NAME_PROPERTY;
            }
            if (cOrder == null) {
                cOrder = "ascending";
            }
            this.propertyName = cName;
            this.sortOrder = cOrder;
        }

        public void setRawCompare(boolean rc) {
            this.rawCompare = rc;
        }

        public boolean getRawCompare() {
            return this.rawCompare;
        }

        public int compare(Object arg0, Object arg1) {
            int ret;
            Comparable o1 = null;
            Comparable o2 = null;
            try {
                if (this.rawCompare) {
                    o1 = (Comparable)PropertyUtils.getProperty((Object)arg0, (String)this.propertyName);
                    o2 = (Comparable)PropertyUtils.getProperty((Object)arg1, (String)this.propertyName);
                } else {
                    o1 = (Comparable)CoreModel.this.getValueToSetInColumn(arg0, CoreModel.this.convert, CoreModel.this.prefix, CoreModel.this.suffix, this.propertyName, this.propertyName);
                    o2 = (Comparable)CoreModel.this.getValueToSetInColumn(arg1, CoreModel.this.convert, CoreModel.this.prefix, CoreModel.this.suffix, this.propertyName, this.propertyName);
                }
            }
            catch (IllegalAccessException e) {
                Trace.error((Object)this, (String)"compare", (Throwable)e);
                return 0;
            }
            catch (InvocationTargetException e) {
                Trace.error((Object)this, (String)"compare", (Throwable)e);
                return 0;
            }
            catch (NoSuchMethodException e) {
                Trace.error((Object)this, (String)"compare", (Throwable)e);
                Trace.error((Object)this, (String)"compare", (String)arg0.getClass().getName());
                Trace.error((Object)this, (String)"compare", (String)arg1.getClass().getName());
                return 0;
            }
            if (o1 instanceof String && o2 instanceof String) {
                if (!this.propertyName.equals(CoreModel.NAME_PROPERTY)) {
                    String s1 = UIUtil.getBUIString((String)((Object)o1));
                    String s2 = UIUtil.getBUIString((String)((Object)o2));
                    ret = s1.compareToIgnoreCase(s2);
                } else {
                    ret = ((String)((Object)o1)).compareToIgnoreCase((String)((Object)o2));
                }
            } else {
                ret = o1.compareTo(o2);
                Trace.verbose((Object)this, (String)"compare", (String)("o1:" + o1 + "; o2:" + o2 + "; ret=" + ret + " rawCompare:" + this.rawCompare));
            }
            if (!this.sortOrder.equals("ascending")) {
                if (ret < 0) {
                    ret = 1;
                } else if (ret > 0) {
                    ret = -1;
                }
            }
            return ret;
        }
    }
}

