/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.bui.login;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.ViewBeanBase;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.management.services.authentication.PasswordCredential;
import com.sun.management.services.authentication.UserPrincipal;
import com.sun.netstorage.array.mgmt.cfg.bui.common.SEExceptionHelper;
import com.sun.netstorage.array.mgmt.cfg.bui.login.Login;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.UIUtil;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.UnauthorizedException;
import com.sun.netstorage.array.mgmt.cfg.core.ini.Repository;
import com.sun.netstorage.array.mgmt.cfg.ui.core.data.ActiveUserInfo;
import com.sun.netstorage.mgmt.dm.util.authorization.AuthorizationUtility;
import com.sun.web.ui.view.alert.CCAlertInline;
import com.sun.web.ui.view.html.CCButton;
import com.sun.web.ui.view.masthead.CCPrimaryMasthead;
import java.io.IOException;
import java.util.ArrayList;
import javax.security.auth.Subject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class PrimaryLoginViewBean
extends ViewBeanBase {
    private static final String CHILD_MASTHEAD = "Masthead";
    private static final String CHILD_ALERT = "Alert";
    private static final String CHILD_FORCEBUTTON = "ForceButton";
    private static final String PAGE_NAME = "PrimaryLogin";
    private static final String DEFAULT_DISPLAY_URL = "/jsp/login/PrimaryLogin.jsp";
    static /* synthetic */ Class class$com$sun$web$ui$view$masthead$CCPrimaryMasthead;
    static /* synthetic */ Class class$com$sun$web$ui$view$alert$CCAlertInline;
    static /* synthetic */ Class class$com$sun$web$ui$view$html$CCButton;
    static /* synthetic */ Class class$com$sun$netstorage$array$mgmt$cfg$bui$login$LogoffViewBean;

    public PrimaryLoginViewBean() {
        super(PAGE_NAME);
        Trace.verbose((Object)((Object)this), (String)"PrimaryLoginViewBean", (String)"start");
        this.setDefaultDisplayURL(DEFAULT_DISPLAY_URL);
        this.registerChildren();
    }

    protected void registerChildren() {
        this.registerChild(CHILD_MASTHEAD, class$com$sun$web$ui$view$masthead$CCPrimaryMasthead == null ? (class$com$sun$web$ui$view$masthead$CCPrimaryMasthead = PrimaryLoginViewBean.class$("com.sun.web.ui.view.masthead.CCPrimaryMasthead")) : class$com$sun$web$ui$view$masthead$CCPrimaryMasthead);
        this.registerChild(CHILD_ALERT, class$com$sun$web$ui$view$alert$CCAlertInline == null ? (class$com$sun$web$ui$view$alert$CCAlertInline = PrimaryLoginViewBean.class$("com.sun.web.ui.view.alert.CCAlertInline")) : class$com$sun$web$ui$view$alert$CCAlertInline);
        this.registerChild(CHILD_FORCEBUTTON, class$com$sun$web$ui$view$html$CCButton == null ? (class$com$sun$web$ui$view$html$CCButton = PrimaryLoginViewBean.class$("com.sun.web.ui.view.html.CCButton")) : class$com$sun$web$ui$view$html$CCButton);
    }

    protected View createChild(String name) {
        if (name.equals(CHILD_MASTHEAD)) {
            CCPrimaryMasthead child = UIUtil.mastheadCreate(this, name);
            return child;
        }
        if (name.equals(CHILD_ALERT)) {
            CCAlertInline child = new CCAlertInline((ContainerView)this, name, null);
            return child;
        }
        if (name.equals(CHILD_FORCEBUTTON)) {
            CCButton child = new CCButton((ContainerView)this, name, null);
            return child;
        }
        throw new IllegalArgumentException("Invalid child name [" + name + "]");
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        block17: {
            Trace.methodBegin((Object)((Object)this), (String)"beginDisplay");
            RequestContext rq = this.getRequestContext();
            HttpSession session = this.getSession();
            Repository rep = Repository.getRepository();
            ActiveUserInfo userLog = (ActiveUserInfo)((Object)rep.getProperty((Object)session.getId()));
            if (userLog == null || userLog.isLoggedOff) {
                String action = (String)rq.getRequest().getAttribute("force");
                Trace.verbose((Object)((Object)this), (String)"beginDisplay", (String)("Action: " + action));
                CCAlertInline alert = (CCAlertInline)this.getChild(CHILD_ALERT);
                ActiveUserInfo aui = new ActiveUserInfo();
                try {
                    boolean acceptUser = this.initLogin(aui, rq.getRequest(), action);
                    if (!acceptUser) {
                        if (alert != null) {
                            alert.setValue((Object)"warning");
                            if (aui != null) {
                                String details = "";
                                if (aui.clientType.equals("admin.users.list.clienttype.gui")) {
                                    details = "bui.login.clientType.gui";
                                } else if (aui.clientType.equals("admin.users.list.clienttype.cli")) {
                                    details = "bui.login.clientType.cli";
                                } else if (aui.clientType.equals("admin.users.list.clienttype.unknown")) {
                                    details = "bui.login.clientType.unknown";
                                }
                                alert.setSummary(UIUtil.getBUIString("error.login"));
                                alert.setDetail(UIUtil.getBUIString3Subst("error.alreadyloggedin", aui.username, aui.ipaddress, UIUtil.getBUIString(details)));
                                Trace.verbose((Object)((Object)this), (String)"beginDisplay", (String)(aui.username + " already logged in from " + aui.ipaddress + "which is a " + details));
                            }
                        }
                        break block17;
                    }
                    Trace.verbose((Object)((Object)this), (String)"beginDisplay", (String)("User accepted: " + aui.username));
                    this.goToUserDefault(aui);
                }
                catch (SSOException ssoe) {
                    alert.setValue((Object)"error");
                    alert.setSummary(UIUtil.getBUIString("se6x20ui.error.systemerror"));
                    Trace.error((Object)((Object)this), (String)"beginDisplay", (Throwable)ssoe);
                }
                catch (ConfigMgmtException cfge) {
                    alert.setValue((Object)"error");
                    alert.setSummary(UIUtil.getBUIString("se6x20ui.error.login"));
                    alert.setDetail(SEExceptionHelper.exceptionHelper(cfge));
                    Trace.error((Object)((Object)this), (String)"beginDisplay", (ConfigMgmtException)cfge);
                }
                catch (UnauthorizedException uex) {
                    Trace.error((Object)((Object)this), (String)"beginDisplay", (String)(aui.username + " is an unauthorized user."));
                    HttpServletRequest httprq = this.getRequestContext().getRequest();
                    String message = UIUtil.getBUIString1Subst("error.login.unauthorizeduser", aui.username);
                    httprq.setAttribute("ErrorRequest", (Object)message);
                    ViewBean target = this.getViewBean(class$com$sun$netstorage$array$mgmt$cfg$bui$login$LogoffViewBean == null ? (class$com$sun$netstorage$array$mgmt$cfg$bui$login$LogoffViewBean = PrimaryLoginViewBean.class$("com.sun.netstorage.array.mgmt.cfg.bui.login.LogoffViewBean")) : class$com$sun$netstorage$array$mgmt$cfg$bui$login$LogoffViewBean);
                    target.forwardTo(this.getRequestContext());
                }
                catch (Exception e) {
                    Trace.error((Object)((Object)this), (String)"beginDisplay", (Throwable)e);
                    ViewBean target = this.getViewBean(class$com$sun$netstorage$array$mgmt$cfg$bui$login$LogoffViewBean == null ? (class$com$sun$netstorage$array$mgmt$cfg$bui$login$LogoffViewBean = PrimaryLoginViewBean.class$("com.sun.netstorage.array.mgmt.cfg.bui.login.LogoffViewBean")) : class$com$sun$netstorage$array$mgmt$cfg$bui$login$LogoffViewBean);
                    target.forwardTo(this.getRequestContext());
                }
            } else {
                Trace.verbose((Object)((Object)this), (String)"beginDisplay", (String)("User already logged in: " + userLog.username));
                try {
                    this.goToUserDefault(userLog);
                }
                catch (Exception e) {
                    Trace.error((Object)((Object)this), (String)"beginDisplay", (Throwable)e);
                    ViewBean target = this.getViewBean(class$com$sun$netstorage$array$mgmt$cfg$bui$login$LogoffViewBean == null ? (class$com$sun$netstorage$array$mgmt$cfg$bui$login$LogoffViewBean = PrimaryLoginViewBean.class$("com.sun.netstorage.array.mgmt.cfg.bui.login.LogoffViewBean")) : class$com$sun$netstorage$array$mgmt$cfg$bui$login$LogoffViewBean);
                    target.forwardTo(this.getRequestContext());
                }
            }
        }
    }

    public void handleForceButtonRequest(RequestInvocationEvent event) throws ServletException, IOException {
        RequestContext rq = this.getRequestContext();
        HttpServletRequest request = rq.getRequest();
        request.setAttribute("force", (Object)"force");
        this.forwardTo(rq);
    }

    protected boolean initLogin(ActiveUserInfo aui, HttpServletRequest request, String action) throws SSOException, ConfigMgmtException, UnauthorizedException {
        Trace.methodBegin((Object)((Object)this), (String)"initLogin");
        String loginUsername = null;
        String loginPassword = null;
        String loginRole = null;
        this.getSession().removeAttribute("ArrayLocked");
        try {
            UserPrincipal p;
            Object o;
            int i;
            SSOTokenManager manager = SSOTokenManager.getInstance();
            SSOToken token = manager.createSSOToken(request);
            Subject subject = token.getSubject();
            Object[] ups = subject.getPrincipals().toArray();
            Object[] pcs = subject.getPrivateCredentials().toArray();
            for (i = 0; i < ups.length; ++i) {
                o = ups[i];
                p = null;
                if (o instanceof UserPrincipal) {
                    p = (UserPrincipal)ups[i];
                    loginUsername = p.getUserName();
                    continue;
                }
                Trace.verbose((Object)((Object)this), (String)"initLogin", (String)"Principal is not UserRolePrincipal!");
                Trace.verbose((Object)((Object)this), (String)"initLogin", (String)("Principal is instance of:" + o.getClass().getName() + " at index:" + i));
            }
            for (i = 0; i < pcs.length; ++i) {
                o = pcs[i];
                if (o instanceof PasswordCredential) {
                    p = (PasswordCredential)pcs[i];
                    loginPassword = p.getUserPassword();
                    continue;
                }
                Trace.verbose((Object)((Object)this), (String)"initLogin", (String)"credential is not UserRoleCredential!");
                Trace.verbose((Object)((Object)this), (String)"initLogin", (String)("Credential is instance of:" + o.getClass().getName() + " at index:" + i));
            }
        }
        catch (SSOException ssoe) {
            if ("true".equals(Repository.getRepository().getProperty((Object)"DEV"))) {
                Trace.error((Object)((Object)this), (String)"DEVELOPMENT ENVIRONMENT", (String)"**DEVELOPMENT ENVIRONMENT**");
                loginUsername = request.getParameter("username");
                loginPassword = request.getParameter("password");
                action = request.getParameter("force");
            }
            throw ssoe;
        }
        aui.username = loginUsername;
        Login login = new Login();
        action = action == null ? "" : action;
        Trace.verbose((Object)((Object)this), (String)"initLogin", (String)("Initiate user login: " + loginUsername));
        if (!UIUtil.isReadWrite(((Object)((Object)this)).getClass(), loginUsername)) {
            Trace.verbose((Object)((Object)this), (String)"initLogin", (String)("User:" + loginUsername + " UNAUTHORIZED! Class:" + ((Object)((Object)this)).getClass()));
            throw new UnauthorizedException("error.login.noaccess");
        }
        loginRole = loginRole == null ? AuthorizationUtility.getInstance().getRole(loginUsername) : loginRole;
        Trace.verbose((Object)((Object)this), (String)"initLogin", (String)("Initiate user role: " + loginRole));
        ConfigContext context = (ConfigContext)login.initUserSession(loginRole, loginPassword, request.getLocale());
        Trace.verbose((Object)((Object)this), (String)"initLogin", (String)"User authenticated, establish access...");
        if (!login.canEstablishAccess(aui, loginUsername, loginRole, action)) {
            Trace.verbose((Object)((Object)this), (String)"initLogin", (String)"Cannot establish access");
            if (context != null && context.getClient() != null) {
                context.getClient().close();
            }
            return false;
        }
        Repository rep = Repository.getRepository();
        HttpSession session = request.getSession();
        this.addToSession(aui, request, loginUsername, loginRole, session, context, rep);
        return true;
    }

    protected void addToSession(ActiveUserInfo aui, HttpServletRequest request, String userName, String userRole, HttpSession session, ConfigContext context, Repository rep) {
        Trace.methodBegin((Object)((Object)this), (String)"addToSession");
        if (aui == null) {
            aui = new ActiveUserInfo();
        }
        aui.ipaddress = request.getRemoteAddr() == null ? "Unknown" : request.getRemoteAddr();
        Trace.verbose((Object)((Object)this), (String)"addToSession", (String)("remote ip:" + aui.ipaddress));
        aui.sessionId = session.getId();
        aui.clientType = "admin.users.list.clienttype.gui";
        aui.username = userName;
        aui.role = userRole;
        aui.configContext = context;
        Trace.verbose((Object)((Object)this), (String)"addToSession", (String)("user is " + aui.username));
        Trace.verbose((Object)((Object)this), (String)"addToSession", (String)("role is " + aui.role));
        rep.setProperty((Object)userRole, (Object)aui);
        rep.setProperty((Object)session.getId(), (Object)aui);
        session.setAttribute("ConfigContext", (Object)context);
        session.setAttribute("UserInfo", (Object)aui);
        ArrayList au = (ArrayList)rep.getProperty((Object)"ActiveUsersListProperty");
        if (au != null) {
            au.add(session.getId());
            Trace.verbose((Object)((Object)this), (String)"addToSession", (String)("add [" + aui.username + "] to active users list"));
            Trace.verbose((Object)((Object)this), (String)"addToSession", (String)("there are now " + au.size() + " active users"));
        } else {
            Trace.verbose((Object)((Object)this), (String)"addToSession", (String)"Active users list property not found!!");
        }
    }

    private void goToUserDefault(ActiveUserInfo auiArg) throws ClassNotFoundException {
        ViewBean view = null;
        String defaultPage = (String)Repository.getRepository().getProperty((Object)"default-page");
        if (defaultPage == null) {
            defaultPage = auiArg.role.equals(UIUtil.USER_ROLE_ADMIN) ? "com.sun.netstorage.array.mgmt.cfg.bui.admin.GeneralViewBean" : "com.sun.netstorage.array.mgmt.cfg.bui.reports.VolumesSummaryViewBean";
        }
        view = this.getRequestContext().getViewBeanManager().getViewBean(defaultPage);
        view.forwardTo(this.getRequestContext());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

