/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.se6120.internal;

import com.sun.netstorage.array.mgmt.se6120.internal.ArrayObject;
import com.sun.netstorage.array.mgmt.util.WBEMDebug;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sun.net.TelnetInputStream;
import sun.net.TelnetOutputStream;
import sun.net.ftp.FtpClient;
import sun.net.ftp.FtpLoginException;

public class Uploader {
    static final int SLEEP = 5000;
    static final String DIRECTORY = "/web";
    static final int BUFSIZE = 1024;
    static final String TEMP_FILE_NAME = "tempuploadfile.txt";
    private static int maxNumberRetries = 3;
    static final String RETRY_PROP_NAME = "Uploader.maxNumberRetries";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void upload(ArrayObject device, File file, String filename) throws IOException {
        long lenFromFile = file.length();
        boolean haveSucceeded = false;
        for (int triesRemaining = maxNumberRetries; !haveSucceeded && triesRemaining > 0; --triesRemaining) {
            FileInputStream fileData = null;
            try {
                fileData = new FileInputStream(file);
                Uploader.doUpload(device.getHost(), device.getUser(), device.getPassword(), fileData, filename, lenFromFile);
                haveSucceeded = true;
                continue;
            }
            catch (IOException ioe) {
                WBEMDebug.trace1((String)("Uploader.upload: Failed when triesRemaining: " + triesRemaining), (Throwable)ioe);
                if (triesRemaining > 0) continue;
                throw ioe;
            }
            finally {
                if (fileData != null) {
                    fileData.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void doUpload(String host, String user, String pass, InputStream fileData, String filename, long lenFromFile) throws IOException {
        if (host == null || user == null || pass == null || fileData == null || filename == null || filename.equals("")) {
            throw new IOException("NULL argument(s)");
        }
        FtpClient client = new FtpClient();
        client.openServer(host);
        try {
            client.login(user, pass);
        }
        catch (FtpLoginException ftple) {
            if (pass != null && pass.equals("")) {
                client.login(user, "\r");
            }
            throw ftple;
        }
        client.binary();
        client.cd(DIRECTORY);
        long transmitted = 0L;
        int len = 0;
        byte[] buf = new byte[1024];
        TelnetOutputStream out = client.put(TEMP_FILE_NAME);
        WBEMDebug.trace3((String)("Uploader.doUpload: Uploading temp file \"tempuploadfile.txt\" to \"" + host + "\" for eventual filename: " + filename));
        do {
            if ((len = fileData.read(buf)) <= 0) continue;
            ((OutputStream)out).write(buf, 0, len);
            transmitted += (long)len;
        } while (len > 0);
        ((OutputStream)out).close();
        WBEMDebug.trace3((String)("Uploader.doUpload: Transmitted bytes: " + transmitted));
        if (lenFromFile != transmitted) {
            throw new IOException("File not entirely uploaded. File length of: " + lenFromFile + " does not match transmitted length: " + transmitted);
        }
        TelnetInputStream is = null;
        StringBuffer listing = new StringBuffer();
        try {
            is = client.list();
            do {
                if ((len = ((InputStream)is).read(buf)) <= 0) continue;
                listing.append(new String(buf, 0, len));
            } while (len > 0);
        }
        finally {
            if (is != null) {
                ((InputStream)is).close();
            }
        }
        if (!Uploader.listingIsValid(listing.toString(), TEMP_FILE_NAME, transmitted)) {
            throw new IOException("File not entirely uploaded size of: " + transmitted + " not found for file: " + TEMP_FILE_NAME + " in listing: " + listing.toString());
        }
        WBEMDebug.trace3((String)("Uploader.doUpload: renaming temp file to: " + filename));
        client.rename(TEMP_FILE_NAME, filename);
        client.closeServer();
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
    }

    public static boolean listingIsValid(String listing, String filename, long transmitted) {
        String patString = "\\s\\b" + transmitted + "\\s*\\w+\\s*\\d+\\s*\\d+:\\d+\\s*" + filename + "\\b";
        Pattern getSizePattern = Pattern.compile(patString);
        Matcher m = getSizePattern.matcher(listing);
        return m.find();
    }

    public static void main(String[] args) {
        if (args.length == 3) {
            System.out.println(Uploader.listingIsValid(args[0], args[1], Long.parseLong(args[2])));
            System.exit(0);
        } else if (args.length != 5) {
            System.out.println("Usage:\n\t\njava Uploader dest_host user pass file_to_be_uploaded dest_filename");
            System.exit(1);
        }
        try {
            File file = new File(args[3]);
            FileInputStream fileStream = new FileInputStream(file);
            System.out.println("About to upload.");
            Uploader.doUpload(args[0], args[1], args[2], fileStream, args[4], file.length());
            System.out.println("Finished uploading.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        try {
            FileInputStream propStream = new FileInputStream("/opt/se6x20/resources/StorEdge_6120.properties");
            Properties props = new Properties();
            props.load(propStream);
            String tmpRetriesStr = props.getProperty(RETRY_PROP_NAME);
            if (tmpRetriesStr != null) {
                int tmpRetries;
                maxNumberRetries = tmpRetries = Integer.parseInt(tmpRetriesStr);
            }
            try {
                propStream.close();
            }
            catch (Exception exception) {}
        }
        catch (Exception e) {
            WBEMDebug.trace1((String)"Uploader.<init> failed to get properties.", (Throwable)e);
        }
    }
}

