/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.se6120.internal;

import com.sun.netstorage.array.mgmt.se6120.internal.ArrayObject;
import com.sun.netstorage.array.mgmt.se6120.internal.CIMInstanceCache;
import com.sun.netstorage.array.mgmt.se6120.internal.CIMUtils;
import com.sun.netstorage.array.mgmt.se6120.internal.RequestBroker;
import com.sun.netstorage.array.mgmt.util.WBEMDebug;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.wbem.cim.CIMDataType;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt16;
import javax.wbem.cim.UnsignedInt8;

public class UpdateClusterDiskUsage {
    private static final String CLASSNAME = "UpdateClusterDiskUsage";
    private ArrayObject array;
    private List currentUsedDisks = new ArrayList();
    private BitSet[] usedDisksByTray;
    private BitSet[] allExistingDisks = new BitSet[6];
    private List currentUsedSpares = new ArrayList();
    private BitSet[] usedSparesByTray;
    private HashSet[] poolsOnTray = new HashSet[6];
    private boolean hasJobs = false;
    private int maxNoRedun = 0;
    private int maxWithRedun = 0;
    private boolean sparesNotFixedInLastDrive;

    public void updateClusterFromNewPoolJobAddition(ArrayObject array, Vector queuedDisks, Vector hotSpareDisks, String newPoolName) {
        this.array = array;
        this.sparesNotFixedInLastDrive = array.isFeatureSupported(3);
        this.hasJobs = true;
        String HDR = "UpdateClusterDiskUsage.updateClusterFromNewPoolJobAddition: ";
        WBEMDebug.trace3((String)"UpdateClusterDiskUsage.updateClusterFromNewPoolJobAddition: entered.");
        try {
            this.currentUsedDisks.addAll(queuedDisks);
            this.currentUsedSpares.addAll(hotSpareDisks);
            TrayAndSlotInfo tsi = this.getTrayAndSlotInfo((String)queuedDisks.get(0));
            this.recordPoolName(newPoolName, tsi);
            CIMInstance[] existingDisks = RequestBroker.getInstance().enumerateInstances(array, new CIMObjectPath("SunStorEdge_6120StorageExtent", "\\root\\se6x20"), false, true, false, null, null);
            this.findUsedDisks(existingDisks);
            CIMInstance[] insts = RequestBroker.getInstance().enumerateInstances(array, new CIMObjectPath("SunStorEdge_6120Cluster", "\\root\\se6x20"), false, true, false, null, null);
            CIMInstance cluster = insts[0];
            this.updateClusterForDisks(cluster);
            RequestBroker.getInstance().addInstance(cluster);
        }
        catch (Exception e) {
            WBEMDebug.trace1((String)"UpdateClusterDiskUsage.updateClusterFromNewPoolJobAddition:  caught and ignored exception. ", (Throwable)e);
        }
    }

    public void updateDiskInfoForCluster(CIMInstanceCache cache, CIMInstance cluster, ArrayObject array, List allDisks) {
        String HDR = "UpdateClusterDiskUsage.updateDiskInfoForCluster: ";
        WBEMDebug.trace3((String)"UpdateClusterDiskUsage.updateDiskInfoForCluster: entered.");
        this.array = array;
        this.sparesNotFixedInLastDrive = array.isFeatureSupported(3);
        try {
            this.findUsedDisks(allDisks.toArray(new CIMInstance[0]));
            this.updateClusterForDisks(cluster);
            cache.add(array, cluster);
        }
        catch (Exception e) {
            WBEMDebug.trace1((String)"UpdateClusterDiskUsage.updateDiskInfoForCluster:  caught and ignored exception. ", (Throwable)e);
        }
    }

    private void findUsedDisks(CIMInstance[] existingDisks) throws CIMException {
        String HDR = "UpdateClusterDiskUsage.findUsedDisks: ";
        int numDisks = existingDisks == null ? 0 : existingDisks.length;
        int roleIndex = -1;
        int poolNameIndex = -1;
        for (int i = 0; i < numDisks; ++i) {
            if (roleIndex < 0 || poolNameIndex < 0) {
                roleIndex = CIMUtils.getArrayPropertyIndex(existingDisks[i], "IdentifyingDescriptions", "Extent Role");
                poolNameIndex = CIMUtils.getArrayPropertyIndex(existingDisks[i], "IdentifyingDescriptions", "StoragePool Name");
            }
            TrayAndSlotInfo tsi = this.getTrayAndSlotInfo(existingDisks[i].getObjectPath().toString());
            this.recordDiskExistence(tsi);
            CIMProperty otherIdInfoProp = existingDisks[i].getProperty("OtherIdentifyingInfo");
            Vector otherIdVector = (Vector)otherIdInfoProp.getValue().getValue();
            String role = (String)otherIdVector.get(roleIndex);
            if ("unassigned".equalsIgnoreCase(role) || role == null || role.length() <= 0) continue;
            WBEMDebug.trace3((String)("UpdateClusterDiskUsage.findUsedDisks: found used disk: " + existingDisks[i].getProperty("DeviceID").getValue().getValue() + " with role: " + role));
            if (this.sparesNotFixedInLastDrive) {
                this.currentUsedDisks.add(existingDisks[i].getObjectPath().toString());
            } else if ("dataDisk".equals(role)) {
                this.currentUsedDisks.add(existingDisks[i].getObjectPath().toString());
            } else {
                this.currentUsedSpares.add(existingDisks[i].getObjectPath().toString());
            }
            String poolName = (String)otherIdVector.get(poolNameIndex);
            if (poolName == null || poolName.length() <= 0 || poolName.equals(" ")) continue;
            this.recordPoolName(poolName, tsi);
        }
        this.findJobs();
        this.usedDisksByTray = this.processUsedDisksByTray(this.currentUsedDisks);
        this.usedSparesByTray = this.processUsedDisksByTray(this.currentUsedSpares);
    }

    private void findJobs() throws CIMException {
        String HDR = "UpdateClusterDiskUsage.findJobs: ";
        WBEMDebug.trace3((String)"UpdateClusterDiskUsage.findJobs: entered");
        CIMInstance[] jobs = RequestBroker.getInstance().enumerateInstances(this.array, new CIMObjectPath("SunStorEdge_6120CreateStoragePoolJob", "\\root\\se6x20"), false, false, false, null, null);
        UnsignedInt16 completedStatus = new UnsignedInt16(17);
        UnsignedInt16 errorStatus = new UnsignedInt16(6);
        for (int i = 0; jobs != null && i < jobs.length; ++i) {
            Vector opStatus = (Vector)jobs[i].getProperty("OperationalStatus").getValue().getValue();
            String jobInstId = (String)jobs[i].getProperty("InstanceID").getValue().getValue();
            if (opStatus.contains(completedStatus) || opStatus.contains(errorStatus) || !jobInstId.startsWith(this.array.getHost() + ":")) continue;
            WBEMDebug.trace3((String)"UpdateClusterDiskUsage.findJobs: have live job for this array.");
            this.hasJobs = true;
            Vector queuedDisks = (Vector)jobs[i].getProperty("StorageExtents").getValue().getValue();
            Vector hotSpareDisks = (Vector)jobs[i].getProperty("HotSpareExtents").getValue().getValue();
            String poolName = (String)jobs[i].getProperty("StoragePoolName").getValue().getValue();
            TrayAndSlotInfo tsi = this.getTrayAndSlotInfo((String)queuedDisks.get(0));
            this.recordPoolName(poolName, tsi);
            this.currentUsedDisks.addAll(queuedDisks);
            this.currentUsedSpares.addAll(hotSpareDisks);
        }
    }

    private void recordPoolName(String poolName, TrayAndSlotInfo tsi) {
        HashSet<String> hs = this.poolsOnTray[tsi.getTray()];
        if (hs == null) {
            hs = new HashSet<String>();
        }
        hs.add(poolName);
        this.poolsOnTray[tsi.getTray()] = hs;
    }

    private BitSet[] processUsedDisksByTray(Collection usedDisks) {
        String HDR = "UpdateClusterDiskUsage.processUsedDisksByTray: ";
        WBEMDebug.trace3((String)"UpdateClusterDiskUsage.processUsedDisksByTray: entered");
        BitSet[] newList = new BitSet[6];
        if (usedDisks == null) {
            WBEMDebug.trace3((String)"UpdateClusterDiskUsage.processUsedDisksByTray: emtpty Collection sent in");
            return newList;
        }
        Iterator usedDisksIter = usedDisks.iterator();
        while (usedDisksIter.hasNext()) {
            String data = (String)usedDisksIter.next();
            TrayAndSlotInfo tsi = this.getTrayAndSlotInfo(data);
            WBEMDebug.trace3((String)("UpdateClusterDiskUsage.processUsedDisksByTray: found tray: " + tsi.getTray() + " and slot: " + tsi.getSlot()));
            BitSet bits = newList[tsi.getTray()];
            if (bits != null) {
                bits.set(tsi.getSlot());
                continue;
            }
            BitSet newTray = new BitSet(15);
            newTray.set(tsi.getSlot());
            newList[tsi.getTray()] = newTray;
        }
        return newList;
    }

    public void updateClusterForDisks(CIMInstance cluster) throws CIMException {
        String HDR = "UpdateClusterDiskUsage.updateClusterForDisks: ";
        WBEMDebug.trace3((String)"UpdateClusterDiskUsage.updateClusterForDisks: entered.");
        int numTrays = this.allExistingDisks == null ? 0 : this.allExistingDisks.length;
        for (int i = 0; i < numTrays; ++i) {
            int numPoolsOnTray = 0;
            HashSet hs = this.poolsOnTray[i];
            if (hs != null) {
                numPoolsOnTray = hs.size();
            }
            BitSet currentTrayExistingDisks = this.allExistingDisks[i];
            BitSet origTray = this.usedDisksByTray[i];
            if (origTray != null) {
                int walkCounter;
                BitSet tray = (BitSet)origTray.clone();
                if (this.usedSparesByTray[i] != null) {
                    tray.or(this.usedSparesByTray[i]);
                }
                WBEMDebug.trace3((String)("UpdateClusterDiskUsage.updateClusterForDisks: for tray: " + i + " have bitSet: " + tray));
                int firstOpen = -1;
                for (walkCounter = 1; walkCounter < currentTrayExistingDisks.length() && firstOpen < 0; ++walkCounter) {
                    if (!currentTrayExistingDisks.get(walkCounter) || tray.get(walkCounter)) continue;
                    firstOpen = walkCounter;
                }
                if (firstOpen >= currentTrayExistingDisks.length() || firstOpen < 0) continue;
                int openNum = 1;
                int nextUsed = -1;
                boolean done = false;
                for (walkCounter = firstOpen + 1; walkCounter < currentTrayExistingDisks.length() && !done; ++walkCounter) {
                    if (currentTrayExistingDisks.get(walkCounter)) {
                        if (tray.get(walkCounter)) {
                            done = true;
                            continue;
                        }
                        ++openNum;
                        continue;
                    }
                    done = true;
                }
                WBEMDebug.trace3((String)("UpdateClusterDiskUsage.updateClusterForDisks: for tray: " + i + " have span of open disks: " + openNum));
                this.updateMaxCounters(i, tray, numPoolsOnTray, openNum, firstOpen);
                continue;
            }
            int openNum = this.getMaxDisksOnTray(i);
            this.updateMaxCounters(i, origTray, numPoolsOnTray, openNum, 1);
        }
        if (this.hasJobs) {
            cluster.setProperty("EnabledState", new CIMValue((Object)new UnsignedInt16(2), new CIMDataType(2)));
        }
        if (this.maxNoRedun < 2) {
            this.maxNoRedun = 0;
        }
        if (this.maxWithRedun < 2) {
            this.maxWithRedun = 0;
        }
        WBEMDebug.trace3((String)("UpdateClusterDiskUsage.updateClusterForDisks: have maxNoRedun: " + this.maxNoRedun + " and maxWithRedun: " + this.maxWithRedun));
        cluster.setProperty("MaxDisksAvailableForUseNoRedundancy", new CIMValue((Object)new UnsignedInt8((short)this.maxNoRedun), new CIMDataType(0)));
        cluster.setProperty("MaxDisksAvailableForUseWithRedundancy", new CIMValue((Object)new UnsignedInt8((short)this.maxWithRedun), new CIMDataType(0)));
    }

    private void updateMaxCounters(int trayId, BitSet tray, int numPoolsOnTray, int newMax, int firstOpen) {
        String HDR = "UpdateClusterDiskUsage.updateMaxCounters: ";
        if (newMax > this.maxNoRedun && numPoolsOnTray < 2) {
            WBEMDebug.trace3((String)("UpdateClusterDiskUsage.updateMaxCounters: tray: " + trayId + " has avail num: " + newMax));
            this.maxNoRedun = newMax;
        }
        if (newMax > this.maxWithRedun && numPoolsOnTray < 2) {
            if (this.sparesNotFixedInLastDrive) {
                BitSet disksOnCurrentTray = this.allExistingDisks[trayId];
                boolean done = false;
                for (int walkCounter = firstOpen + newMax + 1; walkCounter <= disksOnCurrentTray.length() && !done; ++walkCounter) {
                    if (!disksOnCurrentTray.get(walkCounter) || tray != null && tray.get(walkCounter)) continue;
                    this.maxWithRedun = newMax;
                    done = true;
                }
                if (!done) {
                    this.maxWithRedun = newMax - 1;
                }
            } else {
                boolean lastSlotUsedForData;
                boolean spareDiskExists = this.allExistingDisks[trayId].get(14);
                if (spareDiskExists && !(lastSlotUsedForData = this.usedDisksByTray[trayId].get(14))) {
                    this.maxWithRedun = firstOpen + newMax >= 14 ? newMax - 1 : newMax;
                }
            }
        }
    }

    private void recordDiskExistence(TrayAndSlotInfo tsi) {
        BitSet bs = this.allExistingDisks[tsi.getTray()];
        if (bs == null) {
            bs = new BitSet(15);
        }
        bs.set(tsi.getSlot());
        this.allExistingDisks[tsi.getTray()] = bs;
    }

    private int getMaxDisksOnTray(int tray) {
        int max = 0;
        BitSet bs = this.allExistingDisks[tray];
        if (bs != null) {
            max = bs.nextClearBit(1) - 1;
        }
        return max;
    }

    private TrayAndSlotInfo getTrayAndSlotInfo(String data) {
        Pattern getTrayAndSlotPattern = Pattern.compile("DeviceID=\\W+u(\\d+)d(\\d+)");
        Matcher mTrayAndSlot = getTrayAndSlotPattern.matcher(data);
        int trayId = -1;
        int slotId = -1;
        if (mTrayAndSlot.find()) {
            String tray = mTrayAndSlot.group(1);
            trayId = Integer.parseInt(tray) - 1;
            String slot = mTrayAndSlot.group(2);
            slotId = Integer.parseInt(slot);
        }
        return new TrayAndSlotInfo(trayId, slotId);
    }

    private class TrayAndSlotInfo {
        private int tray;
        private int slot;

        public TrayAndSlotInfo(int tray, int slot) {
            this.tray = tray;
            this.slot = slot;
        }

        public int getTray() {
            return this.tray;
        }

        public int getSlot() {
            return this.slot;
        }
    }
}

