/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.se6120.internal;

import com.sun.netstorage.array.mgmt.se6120.internal.ArrayException;
import com.sun.netstorage.array.mgmt.se6120.internal.ArrayObject;
import com.sun.netstorage.array.mgmt.se6120.internal.DevComm;
import com.sun.netstorage.array.mgmt.se6120.internal.ModifyConfigService;
import com.sun.netstorage.array.mgmt.se6120.internal.ModifyModule;
import com.sun.netstorage.array.mgmt.se6120.internal.ModifyRequest;
import com.sun.netstorage.array.mgmt.se6120.internal.RequestBroker;
import com.sun.netstorage.array.mgmt.se6120.internal.SetRequest;
import com.sun.netstorage.array.mgmt.se6120.internal.StorEdgeIOException;
import com.sun.netstorage.array.mgmt.util.WBEMDebug;
import java.util.Properties;
import java.util.Vector;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.UnsignedInt16;

public class ModifyPools
extends ModifyModule {
    private static String STORAGE_POOL_CLASS = "SunStorEdge_6120StoragePool";
    private static int OP_STAT_OK = 2;
    private static int OP_STAT_ERROR = 6;
    private static int OP_STAT_STARTING = 8;
    private static int OP_STAT_DORMANT = 15;

    public void shutdown() {
    }

    public boolean handleRequest(ModifyRequest request) throws CIMException, ArrayException, StorEdgeIOException {
        String METHOD = "handleRequest";
        String classname = request.getCIMClassName();
        if (!classname.equals(STORAGE_POOL_CLASS)) {
            return false;
        }
        if (!(request instanceof SetRequest)) {
            WBEMDebug.trace2((String)(STORAGE_POOL_CLASS + METHOD + "Class does not support any change other than setInstance"));
            throw new CIMException("CIM_ERR_NOT_SUPPORTED");
        }
        Properties props = ((SetRequest)request).getProperties();
        Vector ops = null;
        int value = -1;
        String cmd = null;
        String poolName = null;
        ops = (Vector)((SetRequest)request).getPropertyValue("OperationalStatus");
        if (ops != null) {
            CIMInstance aPool = RequestBroker.getInstance().getInstance(request.getObjectPath(), false, true, false, null, null);
            if (aPool != null) {
                CIMProperty poolNameProp = aPool.getProperty("ElementName");
                if (poolNameProp.getValue() == null || poolNameProp.getValue().getValue() == null) {
                    WBEMDebug.trace3((String)(STORAGE_POOL_CLASS + METHOD + ":Could not find pool to match"));
                    throw new CIMException("CIM_ERR_INVALID_PARAMETER");
                }
                poolName = (String)poolNameProp.getValue().getValue();
                CIMProperty poolOpStatus = aPool.getProperty("OperationalStatus");
                Vector statV = (Vector)poolOpStatus.getValue().getValue();
                int stat = ((UnsignedInt16)statV.get(0)).intValue();
                if (stat == OP_STAT_ERROR || stat == OP_STAT_STARTING) {
                    throw new CIMException("CIM_ERR_FAILED");
                }
            }
            value = ((UnsignedInt16)ops.get(0)).intValue();
            int opCode = -1;
            if (value == OP_STAT_DORMANT) {
                cmd = "vol unmount " + poolName;
                opCode = 5;
            } else if (value == OP_STAT_OK) {
                cmd = "vol mount " + poolName;
                opCode = 4;
            } else {
                throw new CIMException("CIM_ERR_INVALID_PARAMETER");
            }
            try {
                ModifyConfigService.createStorADELock(this.getSystem().getHost(), opCode);
                DevComm.getInstance().telnetPost(this.getSystem(), cmd);
            }
            catch (ArrayException ex) {
                throw ex;
            }
            finally {
                ModifyConfigService.removeStorADELock(this.getSystem().getHost());
            }
            RequestBroker.getInstance().invalidateCache(this.getSystem());
        }
        return true;
    }

    public ModifyPools(ArrayObject array) {
        super(array);
    }
}

