/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.se6120.internal;

import com.sun.netstorage.array.mgmt.logger.LogAPI;
import com.sun.netstorage.array.mgmt.se6120.internal.ArrayException;
import com.sun.netstorage.array.mgmt.se6120.internal.ArrayObject;
import com.sun.netstorage.array.mgmt.se6120.internal.CIMInstanceCache;
import com.sun.netstorage.array.mgmt.se6120.internal.CreateRequest;
import com.sun.netstorage.array.mgmt.se6120.internal.DeleteRequest;
import com.sun.netstorage.array.mgmt.se6120.internal.DevComm;
import com.sun.netstorage.array.mgmt.se6120.internal.InstanceFormer;
import com.sun.netstorage.array.mgmt.se6120.internal.InvokeRequest;
import com.sun.netstorage.array.mgmt.se6120.internal.ModifyBroker;
import com.sun.netstorage.array.mgmt.se6120.internal.ModifyConfigService;
import com.sun.netstorage.array.mgmt.se6120.internal.ModifyModule;
import com.sun.netstorage.array.mgmt.se6120.internal.ModifyRequest;
import com.sun.netstorage.array.mgmt.se6120.internal.RequestBroker;
import com.sun.netstorage.array.mgmt.se6120.internal.SetRequest;
import com.sun.netstorage.array.mgmt.se6120.internal.StorEdgeIOException;
import com.sun.netstorage.array.mgmt.se6120.internal.SunStorEdge_6120ArrayProvider;
import com.sun.netstorage.array.mgmt.se6120.internal.UpdateClusterDiskUsage;
import com.sun.netstorage.array.mgmt.se6120.internal.Uploader;
import com.sun.netstorage.array.mgmt.util.StorEdge_PersistentStorage;
import com.sun.netstorage.array.mgmt.util.WBEMDebug;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMDataType;
import javax.wbem.cim.CIMDateTime;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt16;
import javax.wbem.cim.UnsignedInt64;

public class ModifyJobs
extends ModifyModule {
    private static int MAX_STALL_COUNT_IN_MIN = 120;
    private static final String MAX_STALL_COUNT_IN_MIN_KEY = "ModifyJobs.maxStallCountInMin";
    private static final int ONE_MINUTE = 60000;
    String[] classes = new String[]{"SunStorEdge_6120ConcreteJob", "SunStorEdge_6120CreateStoragePoolJob", "SunStorEdge_6120CreateStorageVolumeJob", "SunStorEdge_6120CreateMappedStorageVolumeJob", "SunStorEdge_6120DeleteStoragePoolJob", "SunStorEdge_6120InitializeStoragePoolJob", "SunStorEdge_6120DeleteStorageVolumeJob"};
    private static final String CLASSNAME = "ModifyJobs";
    private static final String FILENAME = "volInfoFile";
    private static final String PROPS = "/opt/se6x20/resources/StorEdge_6120.properties";
    private static final String T4_VOL_INFO_FILE = "/opt/se6x20/t4files/volinfo.htm";
    private static String T4FILENAME = "volinfo.htm";
    private static CIMObjectPath staticclassop = null;
    private CIMClass cimJob = null;
    private CIMClass cimJobConfigAssoc = null;
    private CIMClass poolclass = null;
    private CIMObjectPath configService = null;
    private CIMObjectPath classop = null;
    private CIMObjectPath poolcop = null;
    private static CIMClass createPoolClass = null;
    private static CIMClass createVolumeClass = null;
    private static CIMClass createMappedVolumeClass = null;
    private static CIMClass deletePoolClass = null;
    private static CIMClass deleteVolumeClass = null;
    private static CIMClass initializePoolClass = null;
    private int jobcounter = 1;
    private HashMap jobs = new HashMap();
    private ArrayList waitq = new ArrayList();
    Job activejob = null;
    Job activeInitJob = null;
    private String sysId = null;
    private JobThread jobthread = null;
    private boolean initialized = false;

    public static ModifyJobs getInstance(String hostname) {
        return (ModifyJobs)ModifyBroker.getInstance().getModule(hostname, CLASSNAME);
    }

    public static void update(String hostname) throws CIMException {
        CIMInstance[] disjobs;
        WBEMDebug.trace3((String)("ModifyJobs: in ModifyJob.update() with hostname=" + hostname));
        if (staticclassop == null) {
            staticclassop = new CIMObjectPath("SunStorEdge_6120ConcreteJob");
            staticclassop.setNameSpace("\\root\\se6x20");
        }
        if ((disjobs = RequestBroker.getInstance().enumerateInstances(staticclassop, false, true, true, null, null)) == null) {
            WBEMDebug.trace3((String)"ModifyJobs: Discovery returned no jobs.");
            return;
        }
        WBEMDebug.trace3((String)("ModifyJobs: Discovery returned " + disjobs.length + " jobs."));
        for (int i = 0; i < disjobs.length; ++i) {
            if (RequestBroker.getInstance().isSyntheticCacheInstance(disjobs[i].getObjectPath())) {
                WBEMDebug.trace3((String)"ModifyJobs: is user job");
                continue;
            }
            WBEMDebug.trace3((String)"ModifyJobs: is retrieved job");
            RequestBroker.getInstance().deleteInstance(disjobs[i].getObjectPath());
        }
        WBEMDebug.trace3((String)"ModifyJobs: returning from ModifyJob.update() ");
    }

    private void initSynCache() {
        try {
            CIMInstance[] disjobs;
            this.initialized = true;
            if (this.classop == null) {
                this.classop = new CIMObjectPath("SunStorEdge_6120ConcreteJob");
                this.classop.setNameSpace("\\root\\se6x20");
            }
            if (this.cimJob == null) {
                this.cimJob = SunStorEdge_6120ArrayProvider.getCIMOMHandle().getClass(this.classop, false, true, true, null);
            }
            if ((disjobs = RequestBroker.getInstance().enumerateInstances(this.getSystem(), this.classop, false, true, true, null, this.cimJob)) == null || disjobs.length == 0) {
                return;
            }
            for (int i = 0; i < disjobs.length; ++i) {
                if (RequestBroker.getInstance().isSyntheticCacheInstance(disjobs[i].getObjectPath())) continue;
                String instanceId = (String)disjobs[i].getProperty("InstanceID").getValue().getValue();
                int perComp = ((UnsignedInt16)disjobs[i].getProperty("PercentComplete").getValue().getValue()).intValue();
                if (perComp < 100 && perComp > 0) {
                    this.activejob = new Job();
                    this.activejob.type = "createPool";
                    this.activejob.instanceId = instanceId;
                    this.activejob.counter = 0;
                    this.activejob.startTime = System.currentTimeMillis();
                    String desc = (String)disjobs[i].getProperty("Description").getValue().getValue();
                    this.activejob.volWWN = desc.substring(0, desc.indexOf(58));
                    Vector<String> postv = new Vector<String>();
                    int col1 = instanceId.indexOf(58);
                    int col2 = instanceId.indexOf(58, col1 + 1);
                    int col3 = instanceId.indexOf(58, col2 + 1);
                    postv.add("unitIndex=" + instanceId.substring(col1 + 1, col2));
                    postv.add("volIndex=" + instanceId.substring(col2 + 1, col3));
                    this.activejob.postIndex = postv;
                    boolean running = true;
                    if (desc.indexOf(58) == desc.length() - 1) {
                        running = false;
                    }
                    if (!running) {
                        this.activejob.status = "Error";
                        this.activejob = null;
                        return;
                    }
                    this.activejob.status = "OK";
                    this.jobs.put(this.activejob.instanceId + this.activejob.counter, this.activejob);
                    this.activejob.percentComplete = perComp;
                    this.activejob.jobStatus = (String)disjobs[i].getProperty("JobStatus").getValue().getValue();
                    RequestBroker.getInstance().addSyntheticCacheInstance(this.activejob.getInstance());
                    RequestBroker.getInstance().addSyntheticCacheInstance(this.activejob.getConfigAssocInstance());
                    if (this.waitq.size() == 0) {
                        this.waitq.add(0, this.activejob);
                        if (this.jobthread.isAlive()) {
                            this.jobthread.trigger();
                        }
                    }
                }
                RequestBroker.getInstance().deleteInstance(disjobs[i].getObjectPath());
            }
        }
        catch (CIMException cex) {
            WBEMDebug.trace3((String)("ModifyJobs: Error adding active job:" + (Object)((Object)cex)));
        }
    }

    public ModifyJobs(ArrayObject t4) throws Exception {
        super(t4);
        try {
            FileInputStream propStream = new FileInputStream(PROPS);
            Properties props = new Properties();
            props.load(propStream);
            T4FILENAME = props.getProperty(FILENAME);
            MAX_STALL_COUNT_IN_MIN = Integer.parseInt(props.getProperty(MAX_STALL_COUNT_IN_MIN_KEY, new Integer(MAX_STALL_COUNT_IN_MIN).toString()));
        }
        catch (Exception e) {
            WBEMDebug.trace1((String)"ModifyJobs: Unable to load properties!", (Throwable)e);
        }
        this.sysId = this.getSystem().getHost();
        this.jobcounter = 1;
        this.jobthread = new JobThread();
        this.jobthread.setName("StorEdge JobThread " + this.getSystem().getHost());
        this.jobthread.setDaemon(true);
        this.jobthread.start();
    }

    public void shutdown() {
        WBEMDebug.trace1((String)("ModifyJobs: Shutting down jobs module " + this));
        this.jobthread.exist = false;
        this.waitq = null;
        if (this.activejob != null && !this.activejob.deleted) {
            this.jobthread.abort();
        }
        Iterator keys = this.jobs.keySet().iterator();
        WBEMDebug.trace1((String)("ModifyJobs: Cleaning up " + this.jobs.size() + " jobs for array " + this.getSystem().getHost()));
        while (keys.hasNext()) {
            Job job = (Job)this.jobs.get(keys.next());
            try {
                RequestBroker.getInstance().deleteSyntheticCacheInstance(job.getInstance().getObjectPath());
                RequestBroker.getInstance().deleteSyntheticCacheInstance(job.getConfigAssocInstance().getObjectPath());
            }
            catch (CIMException ex) {
                WBEMDebug.trace1((String)"ModifyJobs: Exception in shutdown", (Throwable)ex);
            }
        }
        this.jobs = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleRequest(ModifyRequest request) throws CIMException, ArrayException {
        WBEMDebug.trace3((String)"ModifyJobs: entered handleRequest");
        boolean validClass = false;
        String classname = request.getCIMClassName();
        for (int arrind = 0; arrind < this.classes.length; ++arrind) {
            if (!classname.equalsIgnoreCase(this.classes[arrind])) continue;
            validClass = true;
        }
        if (!validClass) {
            WBEMDebug.trace3((String)("ModifyJobshandleRequest: invalid classname: " + classname));
            return false;
        }
        if (request instanceof SetRequest) {
            WBEMDebug.trace3((String)"ModifyJobshandleRequest: in SetRequest");
            Properties props = ((SetRequest)request).getProperties();
            Job job = (Job)this.jobs.get(props.getProperty("InstanceID"));
            if (job == null) {
                WBEMDebug.trace3((String)("ModifyJobshandleRequest: could not find job: " + props.getProperty("InstanceID")));
                return true;
            }
            if (props.getProperty("Description") != null) {
                job.description = props.getProperty("Description");
            }
            if (props.getProperty("Name") != null) {
                job.name = props.getProperty("Name");
            }
            if (props.getProperty("Notify") != null) {
                if (job.status.equalsIgnoreCase("Completed") || job.status.equalsIgnoreCase("Aborted") || job.status.equalsIgnoreCase("Error")) {
                    throw new CIMException("CIM_ERR_NOT_SUPPORTED");
                }
                job.notify = props.getProperty("Notify");
            }
            if (props.getProperty("DeleteOnCompletion") != null) {
                job.deleteOnCompletion = "true".equalsIgnoreCase(props.getProperty("DeleteOnCompletion"));
                WBEMDebug.trace3((String)("ModifyJobs: setting DeleteOnCompletion to: " + job.deleteOnCompletion));
            }
            RequestBroker.getInstance().addSyntheticCacheInstance(job.getInstance());
        } else {
            if (request instanceof CreateRequest) {
                throw new CIMException("CIM_ERR_NOT_SUPPORTED");
            }
            if (request instanceof DeleteRequest) {
                Job job = null;
                Vector props = request.getObjectPath().getKeys();
                for (int i = 0; i < props.size(); ++i) {
                    if (!((CIMProperty)props.elementAt(i)).getName().equals("InstanceID")) continue;
                    job = (Job)this.jobs.get((String)((CIMProperty)props.elementAt(i)).getValue().getValue());
                }
                if (job == null) {
                    return true;
                }
                if (job == this.activejob) {
                    this.jobthread.abort();
                }
                job.deleted = true;
                this.jobs.remove(job.instanceId + job.counter);
                RequestBroker.getInstance().deleteSyntheticCacheInstance(job.getInstance().getObjectPath());
                RequestBroker.getInstance().deleteSyntheticCacheInstance(job.getConfigAssocInstance().getObjectPath());
            } else if (request instanceof InvokeRequest) {
                if (!((InvokeRequest)request).getMethodName().equalsIgnoreCase("killJob")) {
                    throw new CIMException("CIM_ERR_NOT_SUPPORTED");
                }
                ModifyJobs modifyJobs = this;
                synchronized (modifyJobs) {
                    Job job = null;
                    Vector props = request.getObjectPath().getKeys();
                    for (int i = 0; i < props.size(); ++i) {
                        if (!((CIMProperty)props.elementAt(i)).getName().equalsIgnoreCase("InstanceID")) continue;
                        job = (Job)this.jobs.get((String)((CIMProperty)props.elementAt(i)).getValue().getValue());
                    }
                    if (job == null) {
                        return true;
                    }
                    String[] args = new String[]{job.instanceId + job.counter};
                    if (job.status.equalsIgnoreCase("Dormant")) {
                        job.deleted = true;
                        job.status = "Aborted";
                        job.jobStatus = "Aborted";
                        RequestBroker.getInstance().addSyntheticCacheInstance(job.getInstance());
                        LogAPI.staticLog((String)"ARRAY_JOB_TERMINATION", (String[])args, (String[])job.getNotifyList());
                    } else {
                        if (job.status.equalsIgnoreCase("Complete")) {
                            return true;
                        }
                        if (job.status.equalsIgnoreCase("Aborted")) {
                            return true;
                        }
                        if (job.status.equalsIgnoreCase("Error")) {
                            return true;
                        }
                        if (job.status.equalsIgnoreCase("OK")) {
                            if (!job.type.equalsIgnoreCase("createPool") && !job.type.equalsIgnoreCase("initializePool")) {
                                WBEMDebug.trace3((String)("ModifyJobs: Abort failure on " + job.type + " for " + job.instanceId + job.counter));
                                CIMException cimex = new CIMException("CIM_ERR_NOT_SUPPORTED");
                                cimex.setDescription("This Operation cannot be aborted while running");
                                throw cimex;
                            }
                            this.activejob = job;
                            this.jobthread.abort();
                            RequestBroker.getInstance().addSyntheticCacheInstance(job.getInstance());
                            LogAPI.staticLog((String)"ARRAY_JOB_TERMINATION", (String[])args, (String[])job.getNotifyList());
                            RequestBroker.getInstance().invalidateCache(this.getSystem());
                        } else {
                            WBEMDebug.trace3((String)"ModifyJobs: Job.Status undefined");
                        }
                    }
                    if (job.deleteOnCompletion) {
                        WBEMDebug.trace3((String)"ModifyJobs cleaning up job per settings request.");
                        this.jobs.remove(job.instanceId + job.counter);
                        RequestBroker.getInstance().deleteSyntheticCacheInstance(job.getInstance().getObjectPath());
                        RequestBroker.getInstance().deleteSyntheticCacheInstance(job.getConfigAssocInstance().getObjectPath());
                    }
                }
            } else {
                throw new CIMException("CIM_ERR_NOT_SUPPORTED");
            }
        }
        return true;
    }

    public CIMObjectPath createJob(String jobType, Vector postArgs) {
        return this.createJob(jobType, postArgs, null);
    }

    public CIMObjectPath createJob(String jobType, Vector postArgs, String[] telcmd) {
        return this.createJob(jobType, postArgs, telcmd, null);
    }

    public CIMObjectPath createJob(String jobType, Vector postArgs, String[] telcmd, String jobDescription) {
        WBEMDebug.trace3((String)("ModifyJobs: createJob " + jobType + postArgs));
        String unitId = this.rhsValue((String)postArgs.elementAt(0));
        String volId = this.rhsValue((String)postArgs.elementAt(1));
        Job job = new Job();
        WBEMDebug.trace3((String)"ModifyJobs: past element 1 & 2");
        job.type = jobType;
        job.postArgs = postArgs;
        job.telnetcmd = telcmd;
        Vector<String> postv = new Vector<String>();
        postv.add("unitIndex=" + unitId);
        postv.add("volIndex=" + volId);
        job.postIndex = postv;
        job.description = jobDescription;
        job.counter = this.jobcounter++;
        job.status = "Dormant";
        job.jobStatus = "Queued";
        job.timeSubmitted = Calendar.getInstance().getTime();
        this.jobcounter %= 1000000000;
        if (job.type.equalsIgnoreCase("createPool")) {
            job.storagePoolName = this.rhsValue((String)postArgs.elementAt(2));
            job.storagePoolHotSpareExtents = (Vector)postArgs.elementAt(postArgs.size() - 1);
            postArgs.remove(postArgs.size() - 1);
            job.storagePoolProfile = (String)postArgs.elementAt(postArgs.size() - 1);
            postArgs.remove(postArgs.size() - 1);
            job.storagePoolExtents = (Vector)postArgs.elementAt(postArgs.size() - 1);
            postArgs.remove(postArgs.size() - 1);
        } else if (job.type.equalsIgnoreCase("createVolume")) {
            job.storageVolumeName = this.rhsValue((String)postArgs.elementAt(3));
            job.storageVolumeSize = (UnsignedInt64)postArgs.elementAt(postArgs.size() - 1);
            postArgs.remove(postArgs.size() - 1);
            job.storagePoolName = (String)postArgs.elementAt(postArgs.size() - 1);
            postArgs.remove(postArgs.size() - 1);
        } else if (job.type.equalsIgnoreCase("createMappedVolume")) {
            WBEMDebug.trace3((String)"Creating mapped volume");
            job.storageVolumeName = this.rhsValue((String)postArgs.elementAt(3));
            job.storageVolumeSize = (UnsignedInt64)postArgs.elementAt(postArgs.size() - 1);
            postArgs.remove(postArgs.size() - 1);
            job.storagePoolName = (String)postArgs.elementAt(postArgs.size() - 1);
            postArgs.remove(postArgs.size() - 1);
            if (postArgs.elementAt(postArgs.size() - 1) != null) {
                job.accessMode = (UnsignedInt16)postArgs.elementAt(postArgs.size() - 1);
            }
            if (postArgs.elementAt(postArgs.size() - 2) != null) {
                job.deviceNumber = (UnsignedInt16)postArgs.elementAt(postArgs.size() - 2);
            }
        } else if (job.type.equalsIgnoreCase("initializePool")) {
            job.storagePoolName = this.rhsValue((String)postArgs.elementAt(2));
        } else if (job.type.equalsIgnoreCase("deletePool")) {
            job.storagePoolName = this.rhsValue((String)postArgs.elementAt(2));
        } else if (job.type.equalsIgnoreCase("deleteVolume")) {
            job.storagePoolName = (String)postArgs.elementAt(postArgs.size() - 1);
            postArgs.remove(postArgs.size() - 1);
            job.storageVolumeName = this.rhsValue((String)postArgs.elementAt(2));
        } else {
            WBEMDebug.trace1((String)("ModifyJobs: Unknown job type " + job.type));
        }
        job.instanceId = new String(this.getSystem().getHost() + ":" + unitId + ":" + job.storagePoolName + ":");
        try {
            RequestBroker.getInstance().addSyntheticCacheInstance(job.getInstance());
            RequestBroker.getInstance().addSyntheticCacheInstance(job.getConfigAssocInstance());
            if (job.type.equalsIgnoreCase("createpool")) {
                UpdateClusterDiskUsage updater = new UpdateClusterDiskUsage();
                updater.updateClusterFromNewPoolJobAddition(this.getSystem(), job.storagePoolExtents, job.storagePoolHotSpareExtents, job.storagePoolName);
            }
        }
        catch (CIMException ce) {
            WBEMDebug.trace1((String)"ModifyJobs: Error in adding synthetic cache instances");
            RequestBroker.getInstance().deleteSyntheticCacheInstance(job.getInstance().getObjectPath());
            return null;
        }
        this.jobs.put(job.instanceId + job.counter, job);
        this.waitq.add(0, job);
        if (!this.jobthread.isAlive()) {
            WBEMDebug.trace3((String)"ModifyJobs: jobthread created");
            this.jobthread = new JobThread();
            this.jobthread.start();
        } else if (!this.jobthread.isalive) {
            this.jobthread.trigger();
        }
        return job.getInstance().getObjectPath();
    }

    private String rhsValue(String str) {
        if (str == null) {
            return null;
        }
        int eq = str.indexOf(61);
        return str.substring(eq + 1);
    }

    private boolean compareIds(String hostn, String sysn) {
        WBEMDebug.trace3((String)("ModifyJobs: compareIds arg1=" + hostn + " arg2=" + sysn));
        return sysn.equalsIgnoreCase(hostn);
    }

    public static String getHostname(CIMObjectPath jobop) {
        Vector keys = jobop.getKeys();
        for (int i = 0; i < keys.size(); ++i) {
            if (!((CIMProperty)keys.elementAt(i)).getName().equalsIgnoreCase("InstanceID")) continue;
            return ModifyJobs.getHostname((String)((CIMProperty)keys.elementAt(i)).getValue().getValue());
        }
        return null;
    }

    public static String getHostname(String instanceid) {
        if (instanceid == null) {
            return null;
        }
        return instanceid.substring(0, instanceid.indexOf(58));
    }

    static /* synthetic */ String access$200() {
        return T4FILENAME;
    }

    static /* synthetic */ boolean access$300(ModifyJobs x0, String x1, String x2) {
        return x0.compareIds(x1, x2);
    }

    static /* synthetic */ JobThread access$400(ModifyJobs x0) {
        return x0.jobthread;
    }

    private class JobThread
    extends Thread {
        private boolean waiting = false;
        private boolean stopped = false;
        private boolean isalive = false;
        private boolean exist = true;
        public boolean initstarted = false;
        public long initstarttime = 0L;

        private JobThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (this.exist) {
                WBEMDebug.trace3((String)"*JobThread* started ");
                this.isalive = true;
                while (ModifyJobs.this.waitq != null && ModifyJobs.this.waitq.size() > 0) {
                    block62: {
                        this.waiting = false;
                        WBEMDebug.trace3((String)"*JobThread* next job ");
                        try {
                            if (ModifyJobs.this.activejob != null) {
                                if (!ModifyJobs.this.activejob.status.equalsIgnoreCase("OK")) {
                                    if (ModifyJobs.this.activejob.deleteOnCompletion) {
                                        WBEMDebug.trace3((String)"ModifyJobs removing job since deleteOnCompletion is true.");
                                        ModifyJobs.this.jobs.remove(ModifyJobs.this.activejob.instanceId + ModifyJobs.this.activejob.counter);
                                        RequestBroker.getInstance().deleteSyntheticCacheInstance(ModifyJobs.this.activejob.getInstance().getObjectPath());
                                        RequestBroker.getInstance().deleteSyntheticCacheInstance(ModifyJobs.this.activejob.getConfigAssocInstance().getObjectPath());
                                    } else {
                                        RequestBroker.getInstance().addSyntheticCacheInstance(ModifyJobs.this.activejob.getInstance());
                                    }
                                    ModifyJobs.this.activejob = null;
                                } else {
                                    try {
                                        ModifyJobs.this.activejob.deleted = true;
                                        if (!ModifyJobs.this.activejob.type.equalsIgnoreCase("createPool")) {
                                            ModifyJobs.this.activejob.status = "Error";
                                            throw new Exception("Not a CreatePool job");
                                        }
                                        ModifyJobs.this.activejob.jobStatus = "initializing";
                                        JobThread jobThread = this;
                                        synchronized (jobThread) {
                                            this.waiting = true;
                                            for (int i = 0; i < 80; ++i) {
                                                this.wait(120000L);
                                                RequestBroker.getInstance().invalidateCache(ModifyJobs.this.getSystem());
                                                if (!ModifyJobs.this.activejob.status.equalsIgnoreCase("OK") || !ModifyJobs.this.activejob.jobStatus.equalsIgnoreCase("initializing")) break;
                                            }
                                            this.waiting = false;
                                        }
                                        if (ModifyJobs.this.activejob.jobStatus.equalsIgnoreCase("initialized")) {
                                            DevComm.getInstance().post(ModifyJobs.this.getSystem(), ModifyJobs.this.activejob.postIndex, "volMount");
                                            ModifyJobs.this.activejob.jobStatus = "Mounted";
                                        }
                                    }
                                    catch (InterruptedException iex) {
                                        WBEMDebug.trace1((String)ModifyJobs.CLASSNAME, (Throwable)iex);
                                        this.waiting = false;
                                        ModifyJobs.this.activejob.status = "Aborted";
                                        ModifyJobs.this.activejob.jobStatus = "Aborted";
                                        this.cleanup(ModifyJobs.this.activejob.postIndex, ModifyJobs.this.activejob.storagePoolName);
                                    }
                                    if (ModifyJobs.this.activejob.status.equalsIgnoreCase("OK")) {
                                        ModifyJobs.this.activejob.status = "Completed";
                                    }
                                    if (!ModifyJobs.this.activejob.deleted) {
                                        RequestBroker.getInstance().addSyntheticCacheInstance(ModifyJobs.this.activejob.getInstance());
                                    }
                                }
                            }
                            try {
                                while (ModifyJobs.this.waitq.size() > 0 && (ModifyJobs.this.activejob == null || ModifyJobs.this.activejob.deleted)) {
                                    ModifyJobs.this.activejob = (Job)ModifyJobs.this.waitq.get(ModifyJobs.this.waitq.size() - 1);
                                    ModifyJobs.this.waitq.remove(ModifyJobs.this.waitq.size() - 1);
                                    if (!ModifyJobs.this.activejob.deleted) continue;
                                    ModifyJobs.this.activejob = null;
                                }
                                if (ModifyJobs.this.activejob == null) {
                                    WBEMDebug.trace3((String)"*JobThread* breaking out of loop ");
                                    break;
                                }
                                WBEMDebug.trace3((String)("*JobThread* job=" + ModifyJobs.this.activejob.instanceId + ModifyJobs.this.activejob.counter));
                                ModifyJobs.this.activejob.status = "OK";
                                if (!ModifyJobs.this.activejob.deleted) {
                                    RequestBroker.getInstance().addSyntheticCacheInstance(ModifyJobs.this.activejob.getInstance());
                                }
                                if (ModifyJobs.this.activejob.type.equalsIgnoreCase("createPool")) {
                                    this.createVol();
                                } else if (ModifyJobs.this.activejob.type.equalsIgnoreCase("deletePool")) {
                                    this.deleteVol();
                                } else if (ModifyJobs.this.activejob.type.equalsIgnoreCase("initializePool")) {
                                    Thread worker = this.initializeVol();
                                    if (!ModifyJobs.this.getSystem().isFeatureSupported(2) && worker != null) {
                                        worker.join();
                                    }
                                } else if (ModifyJobs.this.activejob.type.equalsIgnoreCase("createVolume")) {
                                    this.createSlice();
                                } else if (ModifyJobs.this.activejob.type.equalsIgnoreCase("createMappedVolume")) {
                                    this.createMappedSlice();
                                } else if (ModifyJobs.this.activejob.type.equalsIgnoreCase("deleteVolume")) {
                                    this.deleteSlice();
                                }
                            }
                            catch (Exception ex) {
                                WBEMDebug.trace1((String)("*JobThread* Exception:" + ex));
                                boolean badDisk = false;
                                if (ex.getMessage() != null && ex.getMessage().indexOf("VN_BAD_DRIVE_STATE") != -1) {
                                    badDisk = true;
                                }
                                WBEMDebug.trace1((String)ModifyJobs.CLASSNAME, (Throwable)ex);
                                if (ModifyJobs.this.activejob.status.equals("Aborted")) {
                                    this.waiting = false;
                                    ModifyJobs.this.activejob.status = "Aborted";
                                    ModifyJobs.this.activejob.jobStatus = "Aborted";
                                    this.cleanup(ModifyJobs.this.activejob.postIndex, ModifyJobs.this.activejob.storagePoolName);
                                } else {
                                    ModifyJobs.this.activejob.status = "Error";
                                    ModifyJobs.this.activejob.jobStatus = "Error";
                                    if (!badDisk) {
                                        ModifyJobs.this.activejob.errorCode = 1;
                                        ModifyJobs.this.activejob.errorDescription = ex.getMessage();
                                    } else {
                                        ModifyJobs.this.activejob.errorCode = 2;
                                        ModifyJobs.this.activejob.updateBadDiskDescription();
                                    }
                                    ModifyJobs.this.activejob.elapsedTime = System.currentTimeMillis();
                                }
                                if (!ModifyJobs.this.activejob.deleted) {
                                    RequestBroker.getInstance().addSyntheticCacheInstance(ModifyJobs.this.activejob.getInstance());
                                }
                                try {
                                    if (ModifyJobs.this.activejob.type.equalsIgnoreCase("createPool")) {
                                        LogAPI.staticLog((String)"POOL_CREATE_ERROR", (String[])ModifyJobs.this.activejob.getVolLogArgs(), (String[])ModifyJobs.this.activejob.getNotifyList());
                                    } else if (ModifyJobs.this.activejob.type.equalsIgnoreCase("initializePool")) {
                                        LogAPI.staticLog((String)"POOL_INITIALIZE_ERROR", (String[])ModifyJobs.this.activejob.getSliceLogArgs(), (String[])ModifyJobs.this.activejob.getNotifyList());
                                    } else if (ModifyJobs.this.activejob.type.equalsIgnoreCase("deletePool")) {
                                        LogAPI.staticLog((String)"POOL_DELETE_ERROR", (String[])ModifyJobs.this.activejob.getVolLogArgs(), (String[])ModifyJobs.this.activejob.getNotifyList());
                                    } else if (ModifyJobs.this.activejob.type.equalsIgnoreCase("createVolume") || ModifyJobs.this.activejob.type.equalsIgnoreCase("createMappedVolume")) {
                                        LogAPI.staticLog((String)"VOLUME_CREATE_ERROR", (String[])ModifyJobs.this.activejob.getSliceLogArgs(), (String[])ModifyJobs.this.activejob.getNotifyList());
                                    } else if (ModifyJobs.this.activejob.type.equalsIgnoreCase("deleteVolume")) {
                                        LogAPI.staticLog((String)"VOLUME_DELETE_ERROR", (String[])ModifyJobs.this.activejob.getSliceLogArgs(), (String[])ModifyJobs.this.activejob.getNotifyList());
                                    }
                                }
                                catch (Exception exception) {}
                            }
                        }
                        catch (Exception exc) {
                            WBEMDebug.trace1((String)("*JobThread* Main Loop Exception: " + exc));
                            WBEMDebug.trace1((String)ModifyJobs.CLASSNAME, (Throwable)exc);
                            if (!ModifyJobs.this.activejob.status.equalsIgnoreCase("OK")) break block62;
                            ModifyJobs.this.activejob.status = "Error";
                        }
                    }
                    RequestBroker.getInstance().invalidateCache(ModifyJobs.this.getSystem());
                    if (!ModifyJobs.this.activejob.deleted) {
                        RequestBroker.getInstance().addSyntheticCacheInstance(ModifyJobs.this.activejob.getInstance());
                    }
                    if (!ModifyJobs.this.activejob.deleteOnCompletion) {
                        ModifyJobs.this.activejob = null;
                        continue;
                    }
                    WBEMDebug.trace3((String)"ModifyJobs disposing of job since deleteOnCompletion is true.");
                    ModifyJobs.this.jobs.remove(ModifyJobs.this.activejob.instanceId + ModifyJobs.this.activejob.counter);
                    try {
                        ModifyJobs.this.activejob.deleted = true;
                        RequestBroker.getInstance().deleteSyntheticCacheInstance(ModifyJobs.this.activejob.getInstance().getObjectPath());
                        RequestBroker.getInstance().deleteSyntheticCacheInstance(ModifyJobs.this.activejob.getConfigAssocInstance().getObjectPath());
                    }
                    catch (CIMException cime) {
                        WBEMDebug.trace1((String)"ModifyJobs: Error deleting job on completion", (Throwable)cime);
                    }
                }
                WBEMDebug.trace3((String)"*JobThread* Terminating as no more jobs.");
                try {
                    JobThread cime = this;
                    synchronized (cime) {
                        this.isalive = false;
                        this.wait(3600000L);
                        this.isalive = true;
                    }
                }
                catch (InterruptedException iex) {
                    this.isalive = true;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void createVol() throws Exception {
            int i;
            WBEMDebug.trace3((String)("*JobThread* createVol for " + ModifyJobs.this.activejob.instanceId + ModifyJobs.this.activejob.counter));
            this.stopped = false;
            ModifyJobs.this.activejob.jobStatus = "Started";
            ModifyJobs.this.activejob.status = "OK";
            ModifyJobs.this.activejob.startTime = System.currentTimeMillis();
            int sep1 = ModifyJobs.this.activejob.instanceId.lastIndexOf(58);
            int sep2 = ModifyJobs.this.activejob.instanceId.lastIndexOf(58, sep1 - 1);
            int sep3 = ModifyJobs.this.activejob.instanceId.lastIndexOf(58, sep2 - 1);
            if (sep3 < 0) {
                WBEMDebug.trace3((String)"*JobThread* ModifyJobs: instanceId malformed");
                ModifyJobs.this.activejob.status = "Error";
                ModifyJobs.this.activejob.jobStatus = ModifyJobs.this.activejob.jobStatus + "Error";
                ModifyJobs.this.activejob.errorDescription = "Malformed instanceId";
                return;
            }
            String unitId = ModifyJobs.this.activejob.instanceId.substring(sep3 + 1, sep2);
            String volId = ModifyJobs.this.activejob.instanceId.substring(sep2 + 1, sep1);
            ModifyJobs.this.activejob.percentComplete = 0;
            if (!this.stopped) {
                ModifyJobs.this.activejob.jobStatus = "Creating";
                try {
                    ModifyConfigService.createStorADELock(ModifyJobs.this.activejob.telnetcmd[3], 2);
                    DevComm.getInstance().telnetPost(ModifyJobs.this.getSystem(), ModifyJobs.this.activejob.telnetcmd[0]);
                }
                finally {
                    ModifyConfigService.removeStorADELock(ModifyJobs.this.activejob.telnetcmd[3]);
                }
            }
            CIMInstanceCache tmpCache = RequestBroker.getCIMInstanceCache(ModifyJobs.this.getSystem());
            CIMInstance[] pools = tmpCache.enumerate(ModifyJobs.this.getSystem(), new CIMObjectPath("SunStorEdge_6120StoragePool"));
            String poolname = null;
            if (pools == null) {
                throw new Exception("Pool Creation Failed. Discovery didnot find" + (String)ModifyJobs.this.activejob.postArgs.elementAt(2));
            }
            for (i = 0; i < pools.length; ++i) {
                WBEMDebug.trace3((String)("pool[" + i + "]=" + pools[i]));
                poolname = (String)pools[i].getProperty("ElementName").getValue().getValue();
                if (!poolname.equalsIgnoreCase(ModifyJobs.this.rhsValue((String)ModifyJobs.this.activejob.postArgs.elementAt(2)))) continue;
                String poolid = (String)pools[i].getProperty("PoolID").getValue().getValue();
                WBEMDebug.trace3((String)("*JobThread* poolid=" + poolid + " old postIndex=" + ModifyJobs.this.activejob.postIndex));
                ModifyJobs.this.activejob.postIndex.set(0, "unitIndex=" + poolid.substring(poolid.indexOf(117) + 1, poolid.indexOf(118)));
                ModifyJobs.this.activejob.postIndex.set(1, "volIndex=" + poolid.substring(poolid.indexOf(118) + 1));
                WBEMDebug.trace3((String)("*JobThread* pool postIndex=" + ModifyJobs.this.activejob.postIndex));
                String wwn = (String)pools[i].getProperty("InstanceID").getValue().getValue();
                StorEdge_PersistentStorage.getInstance().setPersistentString("SunStorEdge_6120StoragePool." + wwn + ".ProfileKey", ModifyJobs.this.activejob.storagePoolProfile, true);
                break;
            }
            if (i == pools.length) {
                throw new Exception("Pool Creation Failed. Discovery did not find" + (String)ModifyJobs.this.activejob.postArgs.elementAt(2));
            }
            RequestBroker.getInstance().invalidateCache(ModifyJobs.this.getSystem());
            Thread worker = null;
            JobThread jobThread = this;
            synchronized (jobThread) {
                if (!this.stopped && !ModifyJobs.this.activejob.deleted) {
                    worker = this.initializeVol();
                }
            }
            if (!ModifyJobs.this.getSystem().isFeatureSupported(2) && worker != null) {
                worker.join();
            }
        }

        private synchronized Thread initializeVol() throws Exception {
            ModifyJobs modifyJobs = ModifyJobs.this;
            modifyJobs.getClass();
            InitVolThread initThread = modifyJobs.new InitVolThread(this);
            initThread.start();
            return initThread;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void deleteVol() throws Exception {
            WBEMDebug.trace3((String)("*JobThread* deleteVol " + ModifyJobs.this.activejob.instanceId + ModifyJobs.this.activejob.counter));
            this.stopped = false;
            ModifyJobs.this.activejob.startTime = System.currentTimeMillis();
            ModifyJobs.this.activejob.jobStatus = "Started";
            ModifyJobs.this.activejob.status = "OK";
            ModifyJobs.this.activejob.percentComplete = 0;
            if (!this.stopped) {
                ModifyJobs.this.activejob.jobStatus = "Deleting";
                try {
                    ModifyConfigService.createStorADELock(ModifyJobs.this.activejob.telnetcmd[2], 5);
                    DevComm.getInstance().telnetPost(ModifyJobs.this.getSystem(), ModifyJobs.this.activejob.telnetcmd[0]);
                    ModifyConfigService.removeStorADELock(ModifyJobs.this.activejob.telnetcmd[2]);
                    ModifyConfigService.createStorADELock(ModifyJobs.this.activejob.telnetcmd[2], 3);
                    DevComm.getInstance().telnetPost(ModifyJobs.this.getSystem(), ModifyJobs.this.activejob.telnetcmd[1]);
                }
                finally {
                    ModifyConfigService.removeStorADELock(ModifyJobs.this.activejob.telnetcmd[2]);
                }
            }
            ModifyJobs.this.activejob.percentComplete = 100;
            ModifyJobs.this.activejob.elapsedTime = System.currentTimeMillis();
            if (this.stopped) {
                ModifyJobs.this.activejob.status = "Aborted";
                ModifyJobs.this.activejob.jobStatus = ModifyJobs.this.activejob.jobStatus + "Aborted";
                LogAPI.staticLog((String)"POOL_DELETE_ABORT", (String[])ModifyJobs.this.activejob.getVolLogArgs(), (String[])ModifyJobs.this.activejob.getNotifyList());
            } else {
                ModifyJobs.this.activejob.jobStatus = "Completed";
                ModifyJobs.this.activejob.status = "Completed";
                LogAPI.staticLog((String)"POOL_DELETE", (String[])ModifyJobs.this.activejob.getVolLogArgs(), (String[])ModifyJobs.this.activejob.getNotifyList());
            }
            WBEMDebug.trace3((String)("*JobThread* deleteVol end " + ModifyJobs.this.activejob.instanceId + ModifyJobs.this.activejob.counter));
            JobThread.yield();
        }

        private void createMappedSlice() throws Exception {
            WBEMDebug.trace3((String)("*JobThread* createMappedSli " + ModifyJobs.this.activejob.instanceId + ModifyJobs.this.activejob.counter));
            this.stopped = false;
            ModifyJobs.this.activejob.startTime = System.currentTimeMillis();
            ModifyJobs.this.activejob.jobStatus = "Started";
            ModifyJobs.this.activejob.status = "OK";
            ModifyJobs.this.activejob.percentComplete = 0;
            if (!this.stopped) {
                ModifyJobs.this.activejob.jobStatus = "Deleting";
                DevComm.getInstance().telnetPost(ModifyJobs.this.getSystem(), ModifyJobs.this.activejob.telnetcmd[0]);
            }
            RequestBroker.getInstance().invalidateCache(ModifyJobs.this.getSystem());
            CIMObjectPath volOp = new CIMObjectPath("SunStorEdge_6120StorageVolume");
            volOp.setNameSpace("\\root\\se6x20");
            CIMInstance[] vols = RequestBroker.getInstance().enumerateInstances(ModifyJobs.this.getSystem(), volOp, false, true, false, null, null);
            CIMInstance ourVol = null;
            for (int i = 0; vols != null && i < vols.length; ++i) {
                String instName = (String)((Vector)vols[i].getProperty("OtherIdentifyingInfo").getValue().getValue()).get(0);
                if (!instName.equals(ModifyJobs.this.activejob.storageVolumeName)) continue;
                ourVol = vols[i];
                break;
            }
            if (ourVol == null) {
                WBEMDebug.trace1((String)("Could not find instance of StorageVolume that we are looking for, " + ModifyJobs.this.activejob.storageVolumeName));
                CIMException ce = new CIMException("CIM_ERR_NOT_FOUND");
                ce.setDescription("StorageVolume " + ModifyJobs.this.activejob.storageVolumeName + " was not found");
                throw ce;
            }
            CIMInstance newVol = ourVol.filterProperties(null, true, true);
            if (ModifyJobs.this.activejob.postArgs.get(5) != null) {
                newVol.setProperty("DeviceNumber", new CIMValue((Object)((UnsignedInt16)ModifyJobs.this.activejob.postArgs.get(5)).toString()));
            }
            if (ModifyJobs.this.activejob.postArgs.get(6) != null) {
                String defAccess = ((UnsignedInt16)ModifyJobs.this.activejob.postArgs.get(6)).toString();
                if (defAccess.equals("2")) {
                    defAccess = "None";
                } else if (defAccess.equals("3")) {
                    defAccess = "Read/Write";
                } else if (defAccess.equals("4")) {
                    defAccess = "Read-only";
                }
                Vector<String> defVector = new Vector<String>();
                defVector.add(defAccess);
                newVol.setProperty("AccessType", new CIMValue(defVector));
            }
            ModifyBroker.getInstance().setInstance(newVol.getObjectPath(), newVol, true, null);
            ModifyJobs.this.activejob.percentComplete = 100;
            ModifyJobs.this.activejob.elapsedTime = System.currentTimeMillis();
            if (this.stopped) {
                ModifyJobs.this.activejob.status = "Aborted";
                ModifyJobs.this.activejob.jobStatus = ModifyJobs.this.activejob.jobStatus + "Aborted";
                LogAPI.staticLog((String)"VOLUME_CREATE_ABORT", (String[])ModifyJobs.this.activejob.getSliceLogArgs(), (String[])ModifyJobs.this.activejob.getNotifyList());
            } else {
                ModifyJobs.this.activejob.jobStatus = "Completed";
                ModifyJobs.this.activejob.status = "Completed";
                LogAPI.staticLog((String)"VOLUME_CREATE", (String[])ModifyJobs.this.activejob.getSliceLogArgs(), (String[])ModifyJobs.this.activejob.getNotifyList());
            }
            WBEMDebug.trace3((String)("*JobThread* createMappedSlice end " + ModifyJobs.this.activejob.instanceId + ModifyJobs.this.activejob.counter));
            JobThread.yield();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void createSlice() throws Exception {
            WBEMDebug.trace3((String)("*JobThread* createSli " + ModifyJobs.this.activejob.instanceId + ModifyJobs.this.activejob.counter));
            this.stopped = false;
            ModifyJobs.this.activejob.startTime = System.currentTimeMillis();
            ModifyJobs.this.activejob.jobStatus = "Started";
            ModifyJobs.this.activejob.status = "OK";
            ModifyJobs.this.activejob.percentComplete = 0;
            if (!this.stopped) {
                ModifyJobs.this.activejob.jobStatus = "Deleting";
                try {
                    ModifyConfigService.createStorADELock(ModifyJobs.this.activejob.telnetcmd[1], 0);
                    DevComm.getInstance().telnetPost(ModifyJobs.this.getSystem(), ModifyJobs.this.activejob.telnetcmd[0]);
                }
                finally {
                    ModifyConfigService.removeStorADELock(ModifyJobs.this.activejob.telnetcmd[1]);
                }
            }
            ModifyJobs.this.activejob.percentComplete = 100;
            ModifyJobs.this.activejob.elapsedTime = System.currentTimeMillis();
            if (this.stopped) {
                ModifyJobs.this.activejob.status = "Aborted";
                ModifyJobs.this.activejob.jobStatus = ModifyJobs.this.activejob.jobStatus + "Aborted";
                LogAPI.staticLog((String)"VOLUME_CREATE_ABORT", (String[])ModifyJobs.this.activejob.getSliceLogArgs(), (String[])ModifyJobs.this.activejob.getNotifyList());
            } else {
                ModifyJobs.this.activejob.jobStatus = "Completed";
                ModifyJobs.this.activejob.status = "Completed";
                LogAPI.staticLog((String)"VOLUME_CREATE", (String[])ModifyJobs.this.activejob.getSliceLogArgs(), (String[])ModifyJobs.this.activejob.getNotifyList());
            }
            WBEMDebug.trace3((String)("*JobThread* createSli end " + ModifyJobs.this.activejob.instanceId + ModifyJobs.this.activejob.counter));
            JobThread.yield();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void deleteSlice() throws Exception {
            WBEMDebug.trace3((String)("*JobThread* deleteSli " + ModifyJobs.this.activejob.instanceId + ModifyJobs.this.activejob.counter));
            this.stopped = false;
            ModifyJobs.this.activejob.startTime = System.currentTimeMillis();
            ModifyJobs.this.activejob.jobStatus = "Started";
            ModifyJobs.this.activejob.status = "OK";
            ModifyJobs.this.activejob.percentComplete = 0;
            if (!this.stopped) {
                ModifyJobs.this.activejob.jobStatus = "Deleting";
                String[] dscmds = new String[]{ModifyJobs.this.activejob.telnetcmd[0], "y"};
                String[] dsresp = new String[]{"Continue ?", ":/:<"};
                String[] dserrs = new String[]{"ERROR", "usage: ", "Command not reentrant", "Command not found"};
                int[] dswait = new int[]{30000, 120000};
                try {
                    ModifyConfigService.createStorADELock(ModifyJobs.this.activejob.telnetcmd[1], 1);
                    DevComm.getInstance().telnetMultiPost(ModifyJobs.this.getSystem(), dscmds, dsresp, dserrs, dsresp, dswait);
                }
                finally {
                    ModifyConfigService.removeStorADELock(ModifyJobs.this.activejob.telnetcmd[1]);
                }
            }
            ModifyJobs.this.activejob.percentComplete = 100;
            ModifyJobs.this.activejob.elapsedTime = System.currentTimeMillis();
            if (this.stopped) {
                ModifyJobs.this.activejob.status = "Aborted";
                ModifyJobs.this.activejob.jobStatus = ModifyJobs.this.activejob.jobStatus + "Aborted";
                LogAPI.staticLog((String)"VOLUME_DELETE_ABORT", (String[])ModifyJobs.this.activejob.getSliceLogArgs(), (String[])ModifyJobs.this.activejob.getNotifyList());
            } else {
                ModifyJobs.this.activejob.jobStatus = "Completed";
                ModifyJobs.this.activejob.status = "Completed";
                LogAPI.staticLog((String)"VOLUME_DELETE", (String[])ModifyJobs.this.activejob.getSliceLogArgs(), (String[])ModifyJobs.this.activejob.getNotifyList());
            }
            WBEMDebug.trace3((String)("*JobThread* deleteSli end " + ModifyJobs.this.activejob.instanceId + ModifyJobs.this.activejob.counter));
            JobThread.yield();
        }

        public synchronized void trigger() {
            WBEMDebug.trace3((String)"ModifyJobs jobthread trigger-ed ");
            this.notifyAll();
        }

        public void abort() {
            WBEMDebug.trace3((String)("*JobThread* Abort " + ModifyJobs.this.activejob.instanceId + ModifyJobs.this.activejob.counter));
            this.stopped = true;
            ModifyJobs.this.activejob.status = "Aborted";
            ModifyJobs.this.activejob.jobStatus = ModifyJobs.this.activejob.jobStatus + "Aborted";
            this.cleanup(ModifyJobs.this.activejob.postIndex, ModifyJobs.this.activejob.storagePoolName);
            if (this.waiting) {
                this.interrupt();
            }
        }

        protected void cleanup(Vector postv, String poolName) {
            WBEMDebug.trace2((String)("**JobThread* Cleanup postv:" + postv));
            WBEMDebug.trace2((String)("**JobThread* Cleanup poolName:" + poolName));
            try {
                DevComm.getInstance().post(ModifyJobs.this.getSystem(), postv, "volAbort");
                try {
                    Thread.sleep(5000L);
                }
                catch (Exception extime) {
                    // empty catch block
                }
                DevComm.getInstance().telnetPost(ModifyJobs.this.getSystem(), "vol -y remove " + poolName);
            }
            catch (Exception aex) {
                WBEMDebug.trace2((String)"*JobThread* Exception during jobthread cleanup", (Throwable)aex);
            }
        }
    }

    private class Job {
        String type = null;
        boolean deleted = false;
        Vector postIndex = null;
        Vector postArgs = null;
        String[] telnetcmd = null;
        String storagePoolName = null;
        Vector storagePoolExtents = null;
        Vector storagePoolHotSpareExtents = null;
        String storageVolumeName = null;
        String storagePoolProfile = null;
        UnsignedInt64 storageVolumeSize = null;
        UnsignedInt16 deviceNumber = null;
        UnsignedInt16 accessMode = null;
        String volWWN = null;
        String instanceId = null;
        int counter;
        String name = null;
        String description = null;
        long startTime = 0L;
        Date timeSubmitted = null;
        long elapsedTime = 0L;
        String notify = null;
        int percentComplete = 0;
        String status = null;
        String jobStatus = null;
        String operationalStatus = null;
        String errorDescription = null;
        boolean deleteOnCompletion = false;
        int errorCode = 0;
        public static final int NO_ERROR_ERROR_CODE = 0;
        public static final int GENERAL_ERROR_CODE = 1;
        public static final int BAD_DISK_ERROR_CODE = 2;
        public static final String BAD_DISK_ERR_MSG = "VN_BAD_DRIVE_STATE";

        private Job() {
        }

        CIMInstance getInstance() {
            CIMObjectPath cop;
            CIMInstance inst = null;
            if (this.type.equalsIgnoreCase("createPool")) {
                if (createPoolClass == null) {
                    try {
                        cop = new CIMObjectPath("SunStorEdge_6120CreateStoragePoolJob");
                        cop.setNameSpace("\\root\\se6x20");
                        createPoolClass = SunStorEdge_6120ArrayProvider.getCIMOMHandle().getClass(cop, false, true, true, null);
                        inst = createPoolClass.newInstance();
                    }
                    catch (CIMException ce) {
                        WBEMDebug.trace3((String)"ModifyJobs: Failed to get CIMClass", (Throwable)ce);
                        inst = new CIMInstance();
                    }
                } else {
                    inst = createPoolClass.newInstance();
                }
                try {
                    inst.setProperty("Profile", new CIMValue((Object)this.storagePoolProfile));
                    inst.setProperty("StoragePoolName", new CIMValue((Object)this.storagePoolName));
                    inst.setProperty("StorageExtents", new CIMValue(this.storagePoolExtents, new CIMDataType(22)));
                    inst.setProperty("HotSpareExtents", new CIMValue(this.storagePoolHotSpareExtents, new CIMDataType(22)));
                }
                catch (CIMException ce) {
                    WBEMDebug.trace3((String)"ModifyJobs: Failed to set property", (Throwable)ce);
                }
            } else if (this.type.equalsIgnoreCase("createVolume")) {
                if (createVolumeClass == null) {
                    try {
                        cop = new CIMObjectPath("SunStorEdge_6120CreateStorageVolumeJob");
                        cop.setNameSpace("\\root\\se6x20");
                        createVolumeClass = SunStorEdge_6120ArrayProvider.getCIMOMHandle().getClass(cop, false, true, true, null);
                        inst = createVolumeClass.newInstance();
                    }
                    catch (CIMException ce) {
                        WBEMDebug.trace3((String)"ModifyJobs: Failed to get CIMClass", (Throwable)ce);
                        inst = new CIMInstance();
                    }
                } else {
                    inst = createVolumeClass.newInstance();
                }
                try {
                    inst.setProperty("StoragePoolName", new CIMValue((Object)this.storagePoolName));
                    inst.setProperty("StorageVolumeName", new CIMValue((Object)this.storageVolumeName));
                    inst.setProperty("Size", new CIMValue((Object)this.storageVolumeSize, new CIMDataType(6)));
                }
                catch (CIMException ce) {
                    WBEMDebug.trace3((String)"ModifyJobs: Failed to set property", (Throwable)ce);
                }
            } else if (this.type.equalsIgnoreCase("createMappedVolume")) {
                if (createMappedVolumeClass == null) {
                    try {
                        cop = new CIMObjectPath("SunStorEdge_6120CreateMappedStorageVolumeJob");
                        cop.setNameSpace("\\root\\se6x20");
                        createVolumeClass = SunStorEdge_6120ArrayProvider.getCIMOMHandle().getClass(cop, false, true, true, null);
                        inst = createVolumeClass.newInstance();
                    }
                    catch (CIMException ce) {
                        WBEMDebug.trace3((String)"ModifyJobs: Failed to get CIMClass", (Throwable)ce);
                        inst = new CIMInstance();
                    }
                } else {
                    inst = createMappedVolumeClass.newInstance();
                }
                try {
                    inst.setProperty("StoragePoolName", new CIMValue((Object)this.storagePoolName));
                    inst.setProperty("StorageVolumeName", new CIMValue((Object)this.storageVolumeName));
                    inst.setProperty("Size", new CIMValue((Object)this.storageVolumeSize, new CIMDataType(6)));
                    inst.setProperty("DeviceNumber", new CIMValue((Object)this.deviceNumber, new CIMDataType(2)));
                    inst.setProperty("AccessMode", new CIMValue((Object)this.accessMode, new CIMDataType(2)));
                }
                catch (CIMException ce) {
                    WBEMDebug.trace3((String)"ModifyJobs: Failed to set property", (Throwable)ce);
                }
            } else if (this.type.equalsIgnoreCase("initializePool")) {
                if (initializePoolClass == null) {
                    try {
                        cop = new CIMObjectPath("SunStorEdge_6120InitializeStoragePoolJob");
                        cop.setNameSpace("\\root\\se6x20");
                        initializePoolClass = SunStorEdge_6120ArrayProvider.getCIMOMHandle().getClass(cop, false, true, true, null);
                        inst = initializePoolClass.newInstance();
                    }
                    catch (CIMException ce) {
                        WBEMDebug.trace3((String)"ModifyJobs: Failed to get CIMClass", (Throwable)ce);
                        inst = new CIMInstance();
                    }
                } else {
                    inst = initializePoolClass.newInstance();
                }
                try {
                    inst.setProperty("StoragePoolName", new CIMValue((Object)this.storagePoolName));
                }
                catch (CIMException ce) {
                    WBEMDebug.trace3((String)"ModifyJobs: Failed to set property", (Throwable)ce);
                }
            } else if (this.type.equalsIgnoreCase("deletePool")) {
                if (deletePoolClass == null) {
                    try {
                        cop = new CIMObjectPath("SunStorEdge_6120DeleteStoragePoolJob");
                        cop.setNameSpace("\\root\\se6x20");
                        deletePoolClass = SunStorEdge_6120ArrayProvider.getCIMOMHandle().getClass(cop, false, true, true, null);
                        inst = deletePoolClass.newInstance();
                    }
                    catch (CIMException ce) {
                        WBEMDebug.trace3((String)"ModifyJobs: Failed to get CIMClass", (Throwable)ce);
                        inst = new CIMInstance();
                    }
                } else {
                    inst = deletePoolClass.newInstance();
                }
                try {
                    inst.setProperty("StoragePoolName", new CIMValue((Object)this.storagePoolName));
                }
                catch (CIMException ce) {
                    WBEMDebug.trace3((String)"ModifyJobs: Failed to set property", (Throwable)ce);
                }
            } else if (this.type.equalsIgnoreCase("deleteVolume")) {
                if (deleteVolumeClass == null) {
                    try {
                        cop = new CIMObjectPath("SunStorEdge_6120DeleteStorageVolumeJob");
                        cop.setNameSpace("\\root\\se6x20");
                        deleteVolumeClass = SunStorEdge_6120ArrayProvider.getCIMOMHandle().getClass(cop, false, true, true, null);
                        inst = deleteVolumeClass.newInstance();
                    }
                    catch (CIMException ce) {
                        WBEMDebug.trace3((String)"ModifyJobs: Failed to get CIMClass", (Throwable)ce);
                        inst = new CIMInstance();
                    }
                } else {
                    inst = deleteVolumeClass.newInstance();
                }
                try {
                    inst.setProperty("StorageVolumeName", new CIMValue((Object)this.storageVolumeName));
                }
                catch (CIMException ce) {
                    WBEMDebug.trace3((String)"ModifyJobs: Failed to set property", (Throwable)ce);
                }
            } else {
                WBEMDebug.trace1((String)"ModifyJobs: Unknown job type");
                return null;
            }
            try {
                inst.setProperty("InstanceID", new CIMValue((Object)(this.instanceId + this.counter)));
                inst.setProperty("Name", new CIMValue((Object)this.name));
                inst.setProperty("Description", new CIMValue((Object)this.description));
                inst.setProperty("SystemName", new CIMValue((Object)ModifyJobs.this.getSystem().getHost()));
                inst.setProperty("Notify", new CIMValue((Object)this.notify));
            }
            catch (CIMException ce) {
                WBEMDebug.trace3((String)"ModifyJobs: Failed to set property", (Throwable)ce);
            }
            if (this.status.equalsIgnoreCase("Completed")) {
                this.percentComplete = 100;
            }
            try {
                inst.setProperty("PercentComplete", new CIMValue((Object)new UnsignedInt16(this.percentComplete), new CIMDataType(2)));
            }
            catch (CIMException ce) {
                WBEMDebug.trace3((String)"ModifyJobs: Failed to set property", (Throwable)ce);
            }
            Vector<UnsignedInt16> u16a = new Vector<UnsignedInt16>();
            if (this.status.equalsIgnoreCase("Dormant")) {
                u16a.add(new UnsignedInt16(15));
            } else if (this.status.equalsIgnoreCase("Completed")) {
                u16a.add(new UnsignedInt16(17));
                u16a.add(new UnsignedInt16(2));
            } else if (this.status.equalsIgnoreCase("Error")) {
                u16a.add(new UnsignedInt16(17));
                u16a.add(new UnsignedInt16(6));
            } else if (this.status.equalsIgnoreCase("Aborted")) {
                u16a.add(new UnsignedInt16(17));
                u16a.add(new UnsignedInt16(14));
            } else if (this.status.equalsIgnoreCase("OK")) {
                u16a.add(new UnsignedInt16(2));
            }
            try {
                inst.setProperty("OperationalStatus", new CIMValue(u16a, new CIMDataType(16)));
                inst.setProperty("JobStatus", new CIMValue((Object)this.jobStatus));
                if (this.startTime != 0L) {
                    inst.setProperty("StartTime", new CIMValue((Object)new CIMDateTime(new Date(this.startTime)), new CIMDataType(12)));
                }
                if (this.timeSubmitted != null) {
                    inst.setProperty("TimeSubmitted", new CIMValue((Object)new CIMDateTime(this.timeSubmitted), new CIMDataType(12)));
                }
                if (this.elapsedTime != 0L) {
                    inst.setProperty("ElapsedTime", new CIMValue((Object)new CIMDateTime(new Date(this.elapsedTime - this.startTime)), new CIMDataType(12)));
                }
                inst.setProperty("ErrorCode", new CIMValue((Object)new UnsignedInt16(this.errorCode), new CIMDataType(2)));
                inst.setProperty("ErrorDescription", new CIMValue((Object)this.errorDescription));
                inst.setProperty("DeleteOnCompletion", new CIMValue((Object)new Boolean(this.deleteOnCompletion)));
            }
            catch (CIMException ce) {
                WBEMDebug.trace3((String)"ModifyJobs: Failed to set property", (Throwable)ce);
            }
            return inst;
        }

        CIMInstance getConfigAssocInstance() throws CIMException {
            try {
                if (ModifyJobs.this.cimJobConfigAssoc == null) {
                    CIMObjectPath assocop = new CIMObjectPath("SunStorEdge_6120ConfigurationServiceJobElement");
                    assocop.setNameSpace("\\root\\se6x20");
                    ModifyJobs.this.cimJobConfigAssoc = SunStorEdge_6120ArrayProvider.getCIMOMHandle().getClass(assocop, false, true, true, null);
                }
                if (ModifyJobs.this.configService == null) {
                    CIMObjectPath csvcop = new CIMObjectPath("SunStorEdge_6120StorageConfigurationService");
                    csvcop.setNameSpace("\\root\\se6x20");
                    ModifyJobs.this.poolcop = new CIMObjectPath("SunStorEdge_6120StoragePool");
                    ModifyJobs.this.poolcop.setNameSpace("\\root\\se6x20");
                    ModifyJobs.this.poolclass = SunStorEdge_6120ArrayProvider.getCIMOMHandle().getClass(ModifyJobs.this.poolcop, false, true, true, null);
                    CIMClass csvccls = SunStorEdge_6120ArrayProvider.getCIMOMHandle().getClass(csvcop, false, true, true, null);
                    CIMInstance[] csvclist = RequestBroker.getInstance().enumerateInstances(ModifyJobs.this.getSystem(), csvcop, false, true, true, null, csvccls);
                    if (csvccls == null) {
                        CIMException ce = new CIMException("CIM_ERR_FAILED");
                        ce.setDescription("ModifyJobs: ConfigService not found.");
                        throw ce;
                    }
                    for (int i = 0; i < csvclist.length; ++i) {
                        if (!csvclist[i].getProperty("SystemName").getValue().getValue().toString().equalsIgnoreCase(ModifyJobs.this.getSystem().getHost())) continue;
                        ModifyJobs.this.configService = csvclist[i].getObjectPath();
                        break;
                    }
                    if (ModifyJobs.this.configService == null) {
                        CIMException ce = new CIMException("CIM_ERR_FAILED");
                        ce.setDescription("ModifyJobs: ConfigService not found");
                        throw ce;
                    }
                    WBEMDebug.trace3((String)("ModifyJobs: configservice = " + ModifyJobs.this.configService));
                }
            }
            catch (CIMException cex) {
                WBEMDebug.trace3((String)"ModifyJobs Construction failed: ", (Throwable)cex);
            }
            CIMInstance inst = ModifyJobs.this.cimJobConfigAssoc.newInstance();
            inst.setProperty("OwningElement", new CIMValue((Object)ModifyJobs.this.configService));
            inst.setProperty("OwnedElement", new CIMValue((Object)this.getInstance().getObjectPath()));
            return inst;
        }

        public String[] getNotifyList() {
            if (this.notify == null) {
                return new String[0];
            }
            StringTokenizer tk = new StringTokenizer(this.notify, ",");
            String[] ids = new String[tk.countTokens()];
            int i = 0;
            while (tk.hasMoreElements()) {
                ids[i] = tk.nextToken();
                ++i;
            }
            return ids;
        }

        public String[] getVolLogArgs() {
            String[] logargs = new String[]{this.storagePoolName, ModifyJobs.this.getSystem().getHostName()};
            return logargs;
        }

        public String[] getSliceLogArgs() {
            String[] logargs = new String[]{this.storageVolumeName, ModifyJobs.this.getSystem().getHostName(), this.storagePoolName};
            return logargs;
        }

        void updateBadDiskDescription() {
            Vector opStatusVector;
            CIMInstance extent;
            StringBuffer badDiskDesc = new StringBuffer();
            Iterator it = this.storagePoolExtents.iterator();
            while (it.hasNext()) {
                extent = RequestBroker.getInstance().findInstance(new CIMObjectPath((String)it.next()));
                WBEMDebug.trace2((String)(" extent = " + extent));
                opStatusVector = (Vector)extent.getProperty("OperationalStatus").getValue().getValue();
                WBEMDebug.trace2((String)(" opStat = " + opStatusVector.get(0)));
                WBEMDebug.trace2((String)(" opStat type = " + opStatusVector.get(0).getClass()));
                badDiskDesc.append(" ").append(extent.getProperty("DeviceID").getValue().getValue());
            }
            it = this.storagePoolHotSpareExtents.iterator();
            while (it.hasNext()) {
                extent = RequestBroker.getInstance().findInstance(new CIMObjectPath((String)it.next()));
                WBEMDebug.trace2((String)(" extent = " + extent));
                opStatusVector = (Vector)extent.getProperty("OperationalStatus").getValue().getValue();
                WBEMDebug.trace2((String)(" opStat = " + opStatusVector.get(0)));
                WBEMDebug.trace2((String)(" opStat type = " + opStatusVector.get(0).getClass()));
                badDiskDesc.append(" ").append(extent.getProperty("DeviceID").getValue().getValue());
            }
            this.errorDescription = "One of the following disks is not OK: " + badDiskDesc.toString();
        }
    }

    private class InitVolThread
    extends Thread {
        JobThread parentThread = null;
        Job activeJobCopy = null;
        boolean aborted = false;
        boolean updateCacheOnce = true;

        public InitVolThread(JobThread parentThread) {
            this.parentThread = parentThread;
            this.activeJobCopy = ModifyJobs.this.activejob;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Object volInitCmd;
                WBEMDebug.trace3((String)("*JobThread* initializeVol " + ModifyJobs.this.activejob.instanceId + ModifyJobs.this.activejob.counter));
                this.aborted = false;
                this.activeJobCopy.startTime = System.currentTimeMillis();
                this.activeJobCopy.jobStatus = "Started";
                this.activeJobCopy.status = "OK";
                if (!this.aborted) {
                    volInitCmd = "volInit";
                    if (ModifyJobs.this.getSystem().isFeatureSupported(2)) {
                        volInitCmd = "volParallelInit";
                    }
                    WBEMDebug.trace3((String)("Command to create vol: " + (String)volInitCmd));
                    DevComm.getInstance().post(ModifyJobs.this.getSystem(), this.activeJobCopy.postIndex, (String)volInitCmd);
                    this.activeJobCopy.jobStatus = "Initializing";
                }
                this.parentThread.initstarted = false;
                this.parentThread.initstarttime = System.currentTimeMillis();
                this.jobWait();
                volInitCmd = this.parentThread;
                synchronized (volInitCmd) {
                    if (this.activeJobCopy.status.equalsIgnoreCase("Error")) {
                        throw new Exception("Error in initializing StoragePool");
                    }
                    if (this.activeJobCopy.status.equalsIgnoreCase("Aborted")) {
                        this.aborted = true;
                    }
                    if (!this.aborted) {
                        this.activeJobCopy.jobStatus = "Mounting";
                        WBEMDebug.trace3((String)("*JobThread* mounting initialized Vol " + this.activeJobCopy.postIndex));
                        try {
                            ModifyConfigService.createStorADELock(this.activeJobCopy.telnetcmd[3], 4);
                            DevComm.getInstance().telnetPost(ModifyJobs.this.getSystem(), this.activeJobCopy.telnetcmd[2]);
                        }
                        finally {
                            ModifyConfigService.removeStorADELock(this.activeJobCopy.telnetcmd[3]);
                        }
                        this.activeJobCopy.percentComplete = 100;
                    }
                    this.activeJobCopy.elapsedTime = System.currentTimeMillis();
                    if (this.aborted) {
                        this.activeJobCopy.status = "Aborted";
                        this.activeJobCopy.jobStatus = this.activeJobCopy.jobStatus + "Aborted";
                        LogAPI.staticLog((String)"POOL_INITIALIZE_ABORT", (String[])this.activeJobCopy.getVolLogArgs(), (String[])this.activeJobCopy.getNotifyList());
                    } else {
                        this.activeJobCopy.jobStatus = "Completed";
                        this.activeJobCopy.status = "Completed";
                        LogAPI.staticLog((String)"POOL_INITIALIZE", (String[])this.activeJobCopy.getVolLogArgs(), (String[])this.activeJobCopy.getNotifyList());
                    }
                }
                RequestBroker.getInstance().addSyntheticCacheInstance(this.activeJobCopy.getInstance());
                WBEMDebug.trace3((String)("*JobThread* initializeVol end " + this.activeJobCopy.instanceId + this.activeJobCopy.counter));
                InitVolThread.yield();
            }
            catch (Exception ex) {
                WBEMDebug.trace3((String)"InitVolThread caught this: ", (Throwable)ex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void jobWait() {
            InitVolThread.yield();
            try {
                InitVolThread initVolThread = this;
                synchronized (initVolThread) {
                    this.parentThread.waiting = true;
                    WBEMDebug.trace3((String)("*JobThread* Wait " + this.activeJobCopy.instanceId + this.activeJobCopy.counter));
                    boolean keepTrying = true;
                    int stalledCount = 0;
                    while (keepTrying) {
                        this.wait(60000L);
                        int oldPercentComplete = this.activeJobCopy.percentComplete;
                        this.update();
                        WBEMDebug.trace3((String)("*JobThread* old % complete: " + oldPercentComplete + "  new % complete: " + this.activeJobCopy.percentComplete));
                        if (oldPercentComplete >= 0 && this.updateCacheOnce) {
                            RequestBroker.getInstance().invalidateCache(ModifyJobs.this.getSystem());
                            this.updateCacheOnce = false;
                        }
                        stalledCount = oldPercentComplete == this.activeJobCopy.percentComplete ? ++stalledCount : 0;
                        if (!this.activeJobCopy.status.equalsIgnoreCase("OK") || !this.activeJobCopy.jobStatus.equalsIgnoreCase("initializing")) {
                            WBEMDebug.trace3((String)"*JobThread* job not OK or initializing, so will no longer update status.");
                            keepTrying = false;
                            continue;
                        }
                        if (stalledCount <= MAX_STALL_COUNT_IN_MIN) continue;
                        WBEMDebug.trace1((String)("*JobThread* stalled for too long with no progress. Will abort initialization after %complete: " + this.activeJobCopy.percentComplete));
                        keepTrying = false;
                    }
                    WBEMDebug.trace3((String)("*JobThread* Wait end " + this.activeJobCopy.instanceId + this.activeJobCopy.counter));
                    this.parentThread.waiting = false;
                }
                WBEMDebug.trace3((String)("*JobThread* %complete=" + this.activeJobCopy.percentComplete));
                if (!this.activeJobCopy.jobStatus.equalsIgnoreCase("initialized")) {
                    if (this.activeJobCopy.status.equalsIgnoreCase("OK")) {
                        this.activeJobCopy.jobStatus = this.activeJobCopy.jobStatus + "Error";
                        this.activeJobCopy.status = "Error";
                    }
                    this.activeJobCopy.errorDescription = "Error in vol initializing";
                    this.parentThread.cleanup(this.activeJobCopy.postIndex, this.activeJobCopy.storagePoolName);
                    return;
                }
            }
            catch (InterruptedException iex) {
                this.aborted = true;
                this.parentThread.waiting = false;
                this.parentThread.cleanup(this.activeJobCopy.postIndex, this.activeJobCopy.storagePoolName);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        void update() {
            block29: {
                disjobs = null;
                inStream = null;
                try {
                    inStream = DevComm.getInstance().get(ModifyJobs.this.getSystem(), ModifyJobs.access$200());
                    disjobs = (ArrayList)InstanceFormer.parseXml(inStream);
                    var6_3 = null;
                    ** if (inStream == null) goto lbl-1000
                }
                catch (Throwable var5_15) {
                    var6_4 = null;
                    if (inStream != null) {
                        try {
                            inStream.close();
                        }
                        catch (IOException ignore) {
                            // empty catch block
                        }
                    }
                    throw var5_15;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        inStream.close();
                    }
                    catch (IOException ignore) {}
                }
lbl-1000:
                // 2 sources

                {
                    break block29;
                    catch (StorEdgeIOException ioex) {
                        WBEMDebug.trace1((String)("ModifyJobs: StorEdgeIOException" + ioex.getMessage()), (Throwable)ioex);
                        if (ioex.getType() == 1 && ModifyJobs.this.getSystem().permitUpload()) {
                            try {
                                file = new File("/opt/se6x20/t4files/volinfo.htm");
                                if (file != null) {
                                    Uploader.upload(ModifyJobs.this.getSystem(), file, ModifyJobs.access$200());
                                    disjobs = (ArrayList)InstanceFormer.parseXml(DevComm.getInstance().get(ModifyJobs.this.getSystem(), ModifyJobs.access$200()));
                                } else {
                                    WBEMDebug.trace1((String)"Unable to find volinfo file to upload.");
                                }
                            }
                            catch (Exception ex) {
                                WBEMDebug.trace1((String)("ModifyJobs: ERROR: Uploading " + ModifyJobs.access$200()), (Throwable)ex);
                            }
                        }
                        var6_3 = null;
                        if (inStream != null) {
                            try {
                                inStream.close();
                            }
                            catch (IOException ignore) {}
                        }
                        break block29;
                    }
                    catch (Exception ex) {
                        WBEMDebug.trace1((String)("ModifyJobs: ERROR: Error retrieving " + ModifyJobs.access$200()));
                        var6_3 = null;
                        if (inStream != null) {
                            try {
                                inStream.close();
                            }
                            catch (IOException ignore) {}
                        }
                    }
                }
            }
            if (disjobs == null) {
                WBEMDebug.trace3((String)"ModifyJobs: ERROR: Discovery returned no jobs.");
                return;
            }
            WBEMDebug.trace3((String)("ModifyJobs: num of Jobs = " + disjobs.size()));
            updated = false;
            for (i = 0; i < disjobs.size(); ++i) {
                disjob = (CIMInstance)disjobs.get(i);
                WBEMDebug.trace3((String)("ModifyJobs: " + i + disjob.getObjectPath()));
                instanceId = (String)disjob.getProperty("InstanceID").getValue().getValue();
                if (this.activeJobCopy == null || !this.activeJobCopy.type.equalsIgnoreCase("createPool") && !this.activeJobCopy.type.equalsIgnoreCase("initializePool") || !this.activeJobCopy.jobStatus.equalsIgnoreCase("initializing") || !ModifyJobs.access$300(ModifyJobs.this, this.activeJobCopy.instanceId, instanceId)) continue;
                WBEMDebug.trace3((String)"ModifyJobs: is this.activeJobCopy job");
                oldPercentComplete = this.activeJobCopy.percentComplete;
                this.activeJobCopy.percentComplete = ((UnsignedInt16)disjob.getProperty("PercentComplete").getValue().getValue()).intValue();
                if (oldPercentComplete > this.activeJobCopy.percentComplete) {
                    this.activeJobCopy.percentComplete = 99;
                }
                desc = (String)disjob.getProperty("Description").getValue().getValue();
                this.activeJobCopy.volWWN = desc.substring(0, desc.indexOf(58));
                WBEMDebug.trace3((String)("ModifyJobs: volWWN:volStatus:volOper = " + desc));
                desc = desc.substring(desc.indexOf(58) + 1, desc.length());
                volstatus = desc.substring(0, desc.indexOf(58));
                running = true;
                if (desc.indexOf(58) == desc.length() - 1 && ModifyJobs.access$400((ModifyJobs)ModifyJobs.this).initstarted) {
                    running = false;
                }
                if (desc.indexOf(58) != desc.length() - 1) {
                    ModifyJobs.access$400((ModifyJobs)ModifyJobs.this).initstarted = true;
                }
                this.activeJobCopy.elapsedTime = System.currentTimeMillis();
                WBEMDebug.trace3((String)("ModifyJobs: running=" + running));
                WBEMDebug.trace3((String)("ModifyJobs: volOperProgress=" + this.activeJobCopy.percentComplete));
                WBEMDebug.trace3((String)("ModifyJobs: status=" + this.activeJobCopy.jobStatus));
                if (ModifyJobs.access$400((ModifyJobs)ModifyJobs.this).initstarted || this.activeJobCopy.elapsedTime - ModifyJobs.access$400((ModifyJobs)ModifyJobs.this).initstarttime > 600000L) {
                    ModifyJobs.access$400((ModifyJobs)ModifyJobs.this).initstarted = true;
                }
                if (!running || this.activeJobCopy.percentComplete == 100) {
                    if (volstatus.equalsIgnoreCase("unmounted")) {
                        this.activeJobCopy.jobStatus = "initialized";
                    } else {
                        this.activeJobCopy.jobStatus = volstatus;
                        this.activeJobCopy.status = "Error";
                    }
                }
                RequestBroker.getInstance().addSyntheticCacheInstance(this.activeJobCopy.getInstance());
                updated = true;
                return;
            }
            if (!updated && this.activeJobCopy != null && !this.activeJobCopy.deleted && ModifyJobs.access$400((ModifyJobs)ModifyJobs.this).initstarted && this.activeJobCopy.jobStatus.equalsIgnoreCase("initializing") && (this.activeJobCopy.type.equalsIgnoreCase("createPool") || this.activeJobCopy.type.equalsIgnoreCase("initializePool"))) {
                WBEMDebug.trace3((String)"ModifyJobs: Aborting Pool this.activeJobCopy");
                this.activeJobCopy.status = "Error";
                ModifyJobs.access$400(ModifyJobs.this).trigger();
            }
        }
    }
}

