/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.se6120.internal;

import com.sun.netstorage.array.mgmt.se6120.internal.ArrayException;
import com.sun.netstorage.array.mgmt.se6120.internal.ArrayInventory;
import com.sun.netstorage.array.mgmt.se6120.internal.ArrayObject;
import com.sun.netstorage.array.mgmt.se6120.internal.DevComm;
import com.sun.netstorage.array.mgmt.se6120.internal.ModifyModule;
import com.sun.netstorage.array.mgmt.se6120.internal.ModifyRequest;
import com.sun.netstorage.array.mgmt.se6120.internal.RequestBroker;
import com.sun.netstorage.array.mgmt.se6120.internal.SetRequest;
import com.sun.netstorage.array.mgmt.se6120.internal.StorEdgeIOException;
import com.sun.netstorage.array.mgmt.util.WBEMDebug;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.UnsignedInt16;

public class ModifyControllerSystem
extends ModifyModule {
    private static String STORAGE_CTRL_SYS_CLASS = "SunStorEdge_6120ControllerSystem";
    private static int ENABLED_STAT_ENABLED = 2;
    private static int ENABLED_STAT_DISABLED = 3;
    private static int ENABLED_STAT_NO_CHANGE_HOWEVER_REFRESH_CACHE_COMMA_AND_PLEASE_DONT_ABUSE_THIS = 5;
    private static int ENABLED_STAT_OFFLINE = 6;

    public void shutdown() {
    }

    public boolean handleRequest(ModifyRequest request) throws CIMException, ArrayException, StorEdgeIOException {
        String METHOD = "handleRequest";
        String classname = request.getCIMClassName();
        if (!classname.equals(STORAGE_CTRL_SYS_CLASS)) {
            return false;
        }
        if (!(request instanceof SetRequest)) {
            WBEMDebug.trace2((String)(STORAGE_CTRL_SYS_CLASS + METHOD + "Class does not support any change other than setInstance"));
            throw new CIMException("CIM_ERR_NOT_SUPPORTED");
        }
        Object ops = null;
        String cmd = null;
        String unit = null;
        int newStatus = -1;
        ops = ((SetRequest)request).getPropertyValue("RequestedStatus");
        if (ops != null) {
            CIMInstance controller = RequestBroker.getInstance().getInstance(request.getObjectPath(), false, true, false, null, null);
            if (controller != null) {
                CIMProperty unitProp = controller.getProperty("Caption");
                if (unitProp.getValue() != null && unitProp.getValue().getValue() != null) {
                    unit = (String)unitProp.getValue().getValue();
                } else {
                    WBEMDebug.trace3((String)(STORAGE_CTRL_SYS_CLASS + METHOD + ":Could not find controller to match"));
                    throw new CIMException("CIM_ERR_INVALID_PARAMETER");
                }
            }
            if ((newStatus = ((UnsignedInt16)ops).intValue()) == ENABLED_STAT_ENABLED) {
                cmd = "enable " + unit;
                DevComm.getInstance().telnetPost(this.getSystem(), cmd);
            } else if (newStatus == ENABLED_STAT_DISABLED) {
                cmd = "disable " + unit;
                DevComm.getInstance().telnetPost(this.getSystem(), cmd);
            } else {
                if (newStatus == ENABLED_STAT_NO_CHANGE_HOWEVER_REFRESH_CACHE_COMMA_AND_PLEASE_DONT_ABUSE_THIS) {
                    ArrayObject ao = ArrayInventory.getInstance().getArrayObject(RequestBroker.getInstance().getHostName(controller.getObjectPath()));
                    RequestBroker.getInstance().invalidateCache(ao);
                    return true;
                }
                if (newStatus == ENABLED_STAT_OFFLINE) {
                    cmd = "unconfig " + unit;
                    DevComm.getInstance().telnetPost(this.getSystem(), cmd);
                } else {
                    throw new CIMException("CIM_ERR_INVALID_PARAMETER");
                }
            }
            RequestBroker.getInstance().invalidateCache(this.getSystem());
        }
        return true;
    }

    public ModifyControllerSystem(ArrayObject array) {
        super(array);
    }
}

