/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.se6120.internal;

import com.sun.netstorage.array.mgmt.se6120.internal.ArrayException;
import com.sun.netstorage.array.mgmt.se6120.internal.ArrayInventory;
import com.sun.netstorage.array.mgmt.se6120.internal.ArrayObject;
import com.sun.netstorage.array.mgmt.se6120.internal.DevComm;
import com.sun.netstorage.array.mgmt.se6120.internal.InvokeRequest;
import com.sun.netstorage.array.mgmt.se6120.internal.ModifyJobs;
import com.sun.netstorage.array.mgmt.se6120.internal.ModifyModule;
import com.sun.netstorage.array.mgmt.se6120.internal.ModifyRequest;
import com.sun.netstorage.array.mgmt.se6120.internal.RequestBroker;
import com.sun.netstorage.array.mgmt.se6120.internal.StorEdgeIOException;
import com.sun.netstorage.array.mgmt.util.StorEdge_PersistentStorage;
import com.sun.netstorage.array.mgmt.util.WBEMDebug;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.wbem.cim.CIMArgument;
import javax.wbem.cim.CIMDataType;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt16;
import javax.wbem.cim.UnsignedInt32;
import javax.wbem.cim.UnsignedInt64;

public class ModifyConfigService
extends ModifyModule {
    static Vector classMap = new Vector();
    public static final int MAX_NAME_LENGTH_VOL = 12;
    public static final int MAX_NAME_LENGTH_POOL = 12;
    public static final int _LOCK_FILE_VOL_CREATE_ = 0;
    public static final int _LOCK_FILE_VOL_DELETE_ = 1;
    public static final int _LOCK_FILE_POOL_CREATE_ = 2;
    public static final int _LOCK_FILE_POOL_DELETE_ = 3;
    public static final int _LOCK_FILE_POOL_MOUNT_ = 4;
    public static final int _LOCK_FILE_POOL_UNMOUNT_ = 5;
    public static final int _LOCK_FILE_ARRAY_STANDBY_ADD_ = 6;
    public static final int _LOCK_FILE_ARRAY_STANDBY_REMOVE_ = 7;
    private static final CIMValue _CONF_SERVICE_FAILURE;
    private static final CIMValue _CONF_SERVICE_NOT_SUPPORTED;
    private static final CIMValue _CONF_SERVICE_INVALID_PARAMETER;
    private static final CIMValue _CONF_SERVICE_COMPLETE_SUCCESSFUL;
    private static final CIMValue _CONF_SERVICE_JOB_STARTED;
    private static String CLASSNAME;
    private static Pattern DEVIDPATTERN;

    public ModifyConfigService(ArrayObject host) {
        super(host);
    }

    public boolean handleRequest(ModifyRequest request) throws CIMException, ArrayException, StorEdgeIOException {
        String METHOD = "handleRequest";
        boolean reqReturn = false;
        WBEMDebug.trace3((String)(CLASSNAME + "." + METHOD + " entered"));
        if (classMap.contains(request.getCIMClassName())) {
            if (request instanceof InvokeRequest) {
                try {
                    reqReturn = this.invokeStorageConfigurationService((InvokeRequest)request);
                }
                catch (CIMException e) {
                    WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " threw an exception: " + e.getMessage()), (Throwable)e);
                    throw e;
                }
            } else {
                throw new CIMException("CIM_ERR_NOT_SUPPORTED");
            }
        }
        return reqReturn;
    }

    private boolean invokeStorageConfigurationService(InvokeRequest request) throws CIMException, ArrayException, StorEdgeIOException {
        boolean ret;
        block10: {
            String METHOD = "invokeStorageConfigurationService";
            ret = false;
            WBEMDebug.trace3((String)(CLASSNAME + "." + METHOD + " entered"));
            String method = request.getMethodName();
            try {
                if (method.equalsIgnoreCase("DeleteStoragePool")) {
                    ret = true;
                    this.deleteStoragePool(request);
                    break block10;
                }
                if (method.equalsIgnoreCase("CreateOrModifyStoragePool")) {
                    ret = true;
                    this.createOrModifyStoragePool(request);
                    break block10;
                }
                if (method.equalsIgnoreCase("ReturnToStoragePool")) {
                    ret = true;
                    this.returnToStoragePool(request);
                    break block10;
                }
                if (method.equalsIgnoreCase("CreateOrModifyElementFromStoragePool")) {
                    ret = true;
                    this.createOrModifyElementFromStoragePool(request, false);
                    break block10;
                }
                if (method.equalsIgnoreCase("CreateMappedElementFromStoragePool")) {
                    ret = true;
                    this.createMappedElementFromStoragePool(request);
                    break block10;
                }
                if (method.equalsIgnoreCase("CreateOrModifyArraySparedSet")) {
                    ret = true;
                    this.createOrModifyArraySparedSet(request);
                    break block10;
                }
                if (method.equalsIgnoreCase("InitializeStoragePool")) {
                    ret = true;
                    this.initializeStoragePool(request);
                    break block10;
                }
                throw new CIMException("CIM_ERR_FAILED");
            }
            catch (ArrayException ae) {
                request.setResults(_CONF_SERVICE_FAILURE);
                WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " encountered an" + " exception, " + ae), (Throwable)ae);
                throw ae;
            }
            catch (StorEdgeIOException ioe) {
                request.setResults(_CONF_SERVICE_FAILURE);
                WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " encountered an" + " exception, " + ioe), (Throwable)ioe);
                throw ioe;
            }
        }
        return ret;
    }

    public void shutdown() {
    }

    private void createMappedElementFromStoragePool(InvokeRequest request) throws CIMException, ArrayException, StorEdgeIOException {
        this.createOrModifyElementFromStoragePool(request, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createOrModifyElementFromStoragePool(InvokeRequest request, boolean isMapped) throws CIMException, ArrayException, StorEdgeIOException {
        Vector oiivv;
        CIMValue oiiv;
        CIMProperty oii;
        int i;
        int currentVolCount;
        CIMObjectPath volPath;
        CIMInstance[] volumeInst;
        BigDecimal capacity;
        String poolName;
        String vIndex;
        String uIndex;
        CIMArgument[] inArgs;
        BigDecimal _MIN_SLICE_SIZE;
        BigDecimal _MEG_VALUE;
        BigDecimal _GIG_VALUE;
        int _MAX_SLICE_NUMBER;
        int _ACCESS_MODE_INDEX;
        int _DEVICE_NUMBER_INDEX;
        int _JOB_DESCRIPTION_INDEX;
        int _POOL_SIZE_INDEX;
        CIMObjectPath jobOp;
        String volSliceIndex;
        String volSliceName;
        CIMInstance aInst;
        Vector<String> tokenArgs;
        String METHOD;
        block43: {
            block44: {
                int _ELEMENT_TYPE_INDEX;
                block42: {
                    METHOD = "createOrModifyElementFromStoragePool";
                    CIMInstance poolInst = null;
                    tokenArgs = new Vector<String>();
                    CIMValue retCode = _CONF_SERVICE_FAILURE;
                    Object thisVol = null;
                    Object vInst = null;
                    aInst = null;
                    volSliceName = null;
                    volSliceIndex = null;
                    jobOp = null;
                    Object storVols = null;
                    _ELEMENT_TYPE_INDEX = 1;
                    int _ELEMENT_NAME_INDEX = 0;
                    _POOL_SIZE_INDEX = 3;
                    int _STORAGE_POOL_INDEX = 4;
                    _JOB_DESCRIPTION_INDEX = 6;
                    _DEVICE_NUMBER_INDEX = 7;
                    _ACCESS_MODE_INDEX = 8;
                    _MAX_SLICE_NUMBER = 64;
                    _GIG_VALUE = new BigDecimal(1.073741824E9);
                    _MEG_VALUE = new BigDecimal(1048576.0);
                    _MIN_SLICE_SIZE = new BigDecimal(1.048576E7);
                    int _STORAGE_VOLUME = 2;
                    UnsignedInt16 elementType = null;
                    long availPoolSpace = 0L;
                    int[] paramIndex = new int[]{_ELEMENT_NAME_INDEX, _ELEMENT_TYPE_INDEX, _POOL_SIZE_INDEX, _STORAGE_POOL_INDEX};
                    String[] paramNames = new String[]{"ElementName", "ElementType", "Size", "Pool"};
                    WBEMDebug.trace3((String)(CLASSNAME + "." + METHOD + " entered"));
                    try {
                        int badIndex = this.checkForNullParams(paramIndex, request);
                        if (badIndex != -1) {
                            request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
                            WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + ": Encountered a null parameter: " + paramNames[badIndex]));
                            return;
                        }
                    }
                    catch (Exception e) {
                        request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
                        WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + ": Encountered an exception. " + e), (Throwable)e);
                        return;
                    }
                    inArgs = request.getInParams();
                    elementType = (UnsignedInt16)inArgs[_ELEMENT_TYPE_INDEX].getValue().getValue();
                    CIMInstance[] gaa = RequestBroker.getInstance().enumerateInstances(this.getSystem(), new CIMObjectPath("SunStorEdge_6120PortSCSIController"), false, true, false, null, null);
                    if (gaa == null) {
                        WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + ": Failed to discover instance of PortSCSIController for" + " this cluster. "));
                        request.setResults(_CONF_SERVICE_FAILURE);
                        return;
                    }
                    CIMInstance gaai = gaa[0];
                    CIMProperty prop = gaai.getProperty("MaxNumberControlled");
                    if (prop.getValue() == null || prop.getValue().getValue() == null) {
                        request.setResults(_CONF_SERVICE_FAILURE);
                        WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + ": Failed to discover MaxNumberControlled property of" + " Storage Pool: " + gaai));
                        return;
                    }
                    _MAX_SLICE_NUMBER = ((UnsignedInt32)prop.getValue().getValue()).intValue();
                    if (elementType.intValue() != _STORAGE_VOLUME || inArgs[_STORAGE_POOL_INDEX].getType().getType() != 28) break block42;
                    if (!inArgs[_STORAGE_POOL_INDEX].getType().getRefClassName().equalsIgnoreCase("SunStorEdge_6120StoragePool")) {
                        request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
                        WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " failed to discover the correct parameters:" + " StoragePool name = " + inArgs[_STORAGE_POOL_INDEX].getType().getRefClassName()));
                        return;
                    }
                    CIMObjectPath op = (CIMObjectPath)inArgs[_STORAGE_POOL_INDEX].getValue().getValue();
                    poolInst = RequestBroker.getInstance().getInstance(op, false, true, false, null, null);
                    WBEMDebug.trace3((String)(CLASSNAME + "." + METHOD + ": gotInstance: " + poolInst.getObjectPath()));
                    if (poolInst == null) {
                        request.setResults(_CONF_SERVICE_FAILURE);
                        WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + ": Failed to discover instance of Storage Pool: " + op));
                        return;
                    }
                    prop = poolInst.getProperty("PoolID");
                    if (prop.getValue() == null || prop.getValue().getValue() == null) {
                        request.setResults(_CONF_SERVICE_FAILURE);
                        WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + ": Failed to discover PoolID property of StoragePool: " + poolInst));
                        return;
                    }
                    String poolid = (String)prop.getValue().getValue();
                    uIndex = poolid.substring(poolid.indexOf("u") + 1, poolid.indexOf("v"));
                    vIndex = poolid.substring(poolid.indexOf("v") + 1);
                    WBEMDebug.trace3((String)(CLASSNAME + "." + METHOD + ": pool id val:" + poolid + " unitIndex: " + uIndex + " volIndex: " + vIndex));
                    prop = poolInst.getProperty("ElementName");
                    if (prop.getValue() == null || prop.getValue().getValue() == null) {
                        request.setResults(_CONF_SERVICE_FAILURE);
                        WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + ": Failed to discover ElementName property of StoragePool: " + poolInst));
                        return;
                    }
                    poolName = (String)prop.getValue().getValue();
                    prop = poolInst.getProperty("MaxVolumeSizeAvailable");
                    if (prop.getValue() == null || prop.getValue().getValue() == null) {
                        request.setResults(_CONF_SERVICE_FAILURE);
                        WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + ": Failed to discover " + "MaxVolumeSizeAvailable" + "property of Storage Pool: " + poolInst));
                        return;
                    }
                    capacity = new BigDecimal(prop.getValue().getValue().toString());
                    capacity = capacity.multiply(_MEG_VALUE);
                    WBEMDebug.trace3((String)(CLASSNAME + "." + METHOD + ": determined available capacity to be: " + capacity));
                    volumeInst = null;
                    volPath = new CIMObjectPath("SunStorEdge_6120StorageVolume", "\\root\\se6x20");
                    volumeInst = RequestBroker.getInstance().enumerateInstances(this.getSystem(), volPath, true, false, false, null, null);
                    volSliceName = (String)inArgs[_ELEMENT_NAME_INDEX].getValue().getValue();
                    if (volSliceName.length() > 12) {
                        request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
                        WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + ": Name given for volume " + volSliceName + " exceeds" + " the name length limit, " + 12));
                        return;
                    }
                    currentVolCount = 0;
                    if (volumeInst == null) break block43;
                    break block44;
                }
                request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
                WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " failed to discover the correct parameters:" + " Element Type = " + inArgs[_ELEMENT_TYPE_INDEX].getValue().getValue()));
                return;
            }
            for (i = 0; i < volumeInst.length; ++currentVolCount, ++i) {
                aInst = volumeInst[i];
                oii = aInst.getProperty("OtherIdentifyingInfo");
                if (oii.getValue() == null || oii.getValue().getValue() == null) {
                    request.setResults(_CONF_SERVICE_FAILURE);
                    WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + ": Failed to discover OtherIdentyingInfo" + " from instance of StorageVolume: " + aInst));
                    return;
                }
                oiiv = oii.getValue();
                oiivv = (Vector)oiiv.getValue();
                String tempName = (String)oiivv.firstElement();
                WBEMDebug.trace3((String)(CLASSNAME + "." + METHOD + ": comparing " + tempName));
                if (!tempName.equals(volSliceName)) continue;
                request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
                WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " was given a duplicate StorageVolume name: " + volSliceName));
                return;
            }
        }
        volumeInst = null;
        volPath = new CIMObjectPath("SunStorEdge_6120CreateStorageVolumeJob", "\\root\\se6x20");
        volumeInst = RequestBroker.getInstance().enumerateInstances(this.getSystem(), volPath, true, false, false, null, null);
        if (volumeInst != null) {
            for (i = 0; i < volumeInst.length; ++i) {
                aInst = volumeInst[i];
                oii = aInst.getProperty("OperationalStatus");
                if (oii.getValue() == null || oii.getValue().getValue() == null) {
                    request.setResults(_CONF_SERVICE_FAILURE);
                    WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + ": Failed to discover " + "OperationalStatus" + " from instance of: " + "SunStorEdge_6120CreateStorageVolumeJob" + " in: " + aInst));
                    return;
                }
                oiiv = oii.getValue();
                oiivv = (Vector)oiiv.getValue();
                boolean isComplete = false;
                for (int j = 0; j < oiivv.size(); ++j) {
                    int stat = ((UnsignedInt16)oiivv.get(j)).intValue();
                    if (stat != 17) continue;
                    isComplete = true;
                }
                if (isComplete) continue;
                ++currentVolCount;
                oii = aInst.getProperty("StorageVolumeName");
                if (oii.getValue() == null || oii.getValue().getValue() == null) {
                    request.setResults(_CONF_SERVICE_FAILURE);
                    WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + ": Failed to discover name of requested volume."));
                    return;
                }
                if (!volSliceName.equals((String)oii.getValue().getValue())) continue;
                request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
                WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " was given a duplicate StorageVolume name to" + " to a requested volume: " + volSliceName));
                return;
            }
        }
        if (currentVolCount >= _MAX_SLICE_NUMBER) {
            request.setResults(_CONF_SERVICE_NOT_SUPPORTED);
            WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " maximum number of volumes (" + _MAX_SLICE_NUMBER + ") already reached."));
        }
        Vector<String> sliceIndex = new Vector<String>();
        Vector otherPools = new Vector();
        CIMInstance ourCluster = null;
        CIMInstance[] clustInsts = null;
        CIMObjectPath qualified = request.getObjectPath();
        qualified.setNameSpace("\\root\\se6x20");
        clustInsts = RequestBroker.getInstance().associators(new CIMObjectPath("SunStorEdge_6120HostedConfigService"), qualified, "SunStorEdge_6120Cluster", null, null, true, false, null);
        if (clustInsts == null) {
            request.setResults(_CONF_SERVICE_FAILURE);
            WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + ": Failed to return an instance for associators of " + " this ConfigService to a cluster: " + request.getObjectPath()));
            return;
        }
        ourCluster = clustInsts[0];
        if (ourCluster == null) {
            request.setResults(_CONF_SERVICE_FAILURE);
            WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + ": No Cluster found for this system!" + this.getSystem().getHost()));
            return;
        }
        CIMInstance[] poolInsts = null;
        WBEMDebug.trace3((String)(CLASSNAME + "." + METHOD + ": checking for pool - cluster association "));
        qualified = ourCluster.getObjectPath();
        qualified.setNameSpace("\\root\\se6x20");
        poolInsts = RequestBroker.getInstance().associators(new CIMObjectPath("SunStorEdge_6120HostedStoragePool"), qualified, "SunStorEdge_6120StoragePool", null, null, true, false, null);
        if (poolInsts == null) {
            request.setResults(_CONF_SERVICE_FAILURE);
            WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + ": Failed to return an instance of HostedStoragePool" + " for cluster: " + request.getObjectPath()));
            return;
        }
        int i2 = 0;
        while (true) {
            int vollength;
            CIMInstance[] vols;
            if (i2 < poolInsts.length) {
                CIMInstance aPool = poolInsts[i2];
                vols = null;
                WBEMDebug.trace3((String)(CLASSNAME + "." + METHOD + ": checking for pool - volume association"));
                qualified = aPool.getObjectPath();
                qualified.setNameSpace("\\root\\se6x20");
                vols = RequestBroker.getInstance().associators(new CIMObjectPath("SunStorEdge_6120AllocatedFromStoragePool"), qualified, "SunStorEdge_6120StorageVolume", null, null, true, false, null);
                vollength = 0;
                if (vols != null) {
                    vollength = vols.length;
                }
            } else {
                WBEMDebug.trace3((String)(CLASSNAME + "." + METHOD + ": finding slice value for volume "));
                volSliceIndex = this.getLowSeqValue(sliceIndex);
                UnsignedInt64 sliceSizeIn = (UnsignedInt64)inArgs[_POOL_SIZE_INDEX].getValue().getValue();
                WBEMDebug.trace3((String)(CLASSNAME + "." + METHOD + ": calculating GB for size entered: " + sliceSizeIn));
                BigDecimal sliceSize = null;
                try {
                    sliceSize = new BigDecimal(sliceSizeIn.toString());
                }
                catch (Exception nfe) {
                    request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
                    WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + ": Value given for Size is invalid: " + sliceSizeIn), (Throwable)nfe);
                    return;
                }
                if (sliceSize.compareTo(_MIN_SLICE_SIZE) < 0 || sliceSize.compareTo(capacity) > 0) {
                    request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
                    WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + ": Size for this volSlice is invalid: " + sliceSize + " min size is : " + _MIN_SLICE_SIZE + " remaining capacity is: " + capacity));
                    return;
                }
                WBEMDebug.trace3((String)(CLASSNAME + "." + METHOD + ": requested size is valid : " + sliceSize));
                String volSliceSize = null;
                if (sliceSize.compareTo(_GIG_VALUE) >= 0) {
                    sliceSize = sliceSize.divide(_GIG_VALUE, 2, 1);
                    volSliceSize = sliceSize.toString() + "gb";
                } else {
                    sliceSize = sliceSize.divide(_MEG_VALUE, 2, 1);
                    volSliceSize = sliceSize.toString() + "mb";
                }
                WBEMDebug.trace3((String)(CLASSNAME + "." + METHOD + ": size determined as " + volSliceSize));
                tokenArgs.add("unitIndex=" + uIndex);
                tokenArgs.add("volIndex=" + vIndex);
                tokenArgs.add("volSliceIndex=" + volSliceIndex);
                tokenArgs.add("volSliceName=" + volSliceName);
                tokenArgs.add("volSliceSize=" + volSliceSize);
                String jobCommand = "createVolume";
                if (isMapped) {
                    UnsignedInt16 lunNum = null;
                    if (inArgs[_DEVICE_NUMBER_INDEX].getValue() != null) {
                        lunNum = (UnsignedInt16)inArgs[_DEVICE_NUMBER_INDEX].getValue().getValue();
                    }
                    UnsignedInt16 accVal = (UnsignedInt16)inArgs[_ACCESS_MODE_INDEX].getValue().getValue();
                    if (lunNum != null || accVal != null) {
                        tokenArgs.add((String)lunNum);
                        tokenArgs.add((String)accVal);
                        jobCommand = "createMappedVolume";
                    }
                }
                tokenArgs.add(poolName);
                tokenArgs.add((String)sliceSizeIn);
                WBEMDebug.trace3((String)(CLASSNAME + "." + METHOD + ": arguments for tokens are:"));
                for (int i3 = 0; i3 < tokenArgs.size(); ++i3) {
                    WBEMDebug.trace3((String)(CLASSNAME + "." + METHOD + "" + tokenArgs.get(i3)));
                }
                String[] telnetcmds = new String[]{"volslice create " + volSliceName + " -z " + volSliceSize + " " + poolName, this.getSystem().getHost()};
                String jobDesc = null;
                try {
                    jobDesc = (String)inArgs[_JOB_DESCRIPTION_INDEX].getValue().getValue();
                }
                catch (NullPointerException ne) {
                }
                catch (ArrayIndexOutOfBoundsException ae) {
                }
                catch (Exception e) {
                    request.setResults(_CONF_SERVICE_FAILURE);
                    WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + ": Encountered an exception. " + e.getMessage()), (Throwable)e);
                    return;
                }
                jobOp = jobDesc != null ? ModifyJobs.getInstance(this.getSystem().getHost()).createJob(jobCommand, tokenArgs, telnetcmds, jobDesc) : ModifyJobs.getInstance(this.getSystem().getHost()).createJob(jobCommand, tokenArgs, telnetcmds);
                request.setResults(_CONF_SERVICE_JOB_STARTED);
                CIMArgument[] outArgs = request.getOutParams();
                outArgs[0] = new CIMArgument("Job", new CIMValue((Object)jobOp));
                outArgs[1] = new CIMArgument("Size", new CIMValue((Object)jobOp));
                outArgs[2] = new CIMArgument("TheElement", new CIMValue(null));
                return;
            }
            for (int j = 0; j < vollength; ++j) {
                if (vols[j].getProperty("Name").getValue() == null || vols[j].getProperty("Name").getValue().getValue() == null) {
                    request.setResults(_CONF_SERVICE_FAILURE);
                    WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + ": Failed to discover property Name " + "for StorageVolume : " + vols[j]));
                    return;
                }
                sliceIndex.add((String)vols[j].getProperty("Name").getValue().getValue());
                CIMProperty otherProp = vols[j].getProperty("OtherIdentifyingInfo");
                if (otherProp.getValue() == null || otherProp.getValue().getValue() == null) {
                    request.setResults(_CONF_SERVICE_FAILURE);
                    WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + ": Failed to discover OtherIdentifyingInfo " + "for StorageVolume : " + vols[j]));
                    return;
                }
                String tempName = (String)((Vector)otherProp.getValue().getValue()).firstElement();
                WBEMDebug.trace3((String)(CLASSNAME + "." + METHOD + ": comparing " + tempName));
                if (!tempName.equals(volSliceName)) continue;
                request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
                WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " was given a duplicate StorageVolume name: " + volSliceName));
                return;
            }
            ++i2;
        }
    }

    private void createOrModifyStoragePool(InvokeRequest request) throws CIMException, ArrayException, StorEdgeIOException {
        String METHOD = "createOrModifyStoragePool";
        int _POOL_REF_INDEX = 5;
        int[] paramIndex = new int[]{5};
        try {
            int badIndex = this.checkForNullParams(paramIndex, request);
            if (badIndex == -1) {
                this.modifyStoragePool(request);
            } else {
                this.createStoragePool(request);
            }
        }
        catch (Exception e) {
            request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
            WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + ": Encountered an exception. "), (Throwable)e);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void modifyStoragePool(InvokeRequest request) throws CIMException, ArrayException, StorEdgeIOException {
        String oldProfile;
        String profile;
        String WWN;
        boolean updateCache;
        CIMInstance caps;
        CIMInstance storSet;
        block39: {
            int newDataMin;
            int newPackageMin;
            int oldDataMin;
            int oldDataMax;
            int oldPackageDef;
            int oldPackageMin;
            int oldPackageMax;
            boolean support;
            String METHOD;
            block38: {
                storSet = null;
                CIMInstance pool = null;
                caps = null;
                Vector<CIMInstance> existingExtents = null;
                METHOD = "modifyStoragePool";
                support = false;
                boolean addSpare = false;
                boolean removeSpare = false;
                updateCache = false;
                boolean hasDedicatedSpare = false;
                boolean _STOR_SETT_INDEX = true;
                int _POOL_REF_INDEX = 5;
                int[] paramIndex = new int[]{1};
                String[] paramNames = new String[]{"Goal"};
                WBEMDebug.trace3((String)(CLASSNAME + "." + METHOD + " entered"));
                try {
                    int badIndex = this.checkForNullParams(paramIndex, request);
                    if (badIndex != -1) {
                        request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
                        WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + ": Encountered a null parameter: " + paramNames[badIndex]));
                        return;
                    }
                }
                catch (Exception e) {
                    request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
                    WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + ": Encountered an exception. " + e));
                    return;
                }
                try {
                    CIMArgument[] inArgs = request.getInParams();
                    for (int i = 0; i < inArgs.length; ++i) {
                        if (inArgs[i].getName().equalsIgnoreCase("Pool")) {
                            pool = RequestBroker.getInstance().getInstance((CIMObjectPath)inArgs[i].getValue().getValue(), false, true, false, null, null);
                        }
                        if (!inArgs[i].getName().equalsIgnoreCase("Goal")) continue;
                        storSet = RequestBroker.getInstance().getInstance((CIMObjectPath)inArgs[i].getValue().getValue(), false, true, false, null, null);
                    }
                }
                catch (Exception e) {
                    request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
                    WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + ": Encountered an exception while enumerating " + " StoragePool or StorageSettings: " + e), (Throwable)e);
                    return;
                }
                CIMInstance[] insts = null;
                CIMObjectPath qualified = pool.getObjectPath();
                qualified.setNameSpace("\\root\\se6x20");
                String name = null;
                if (pool != null) {
                    name = this.getString(pool.getProperty("ElementName"));
                    insts = RequestBroker.getInstance().associators(new CIMObjectPath("SunStorEdge_6120ExtentConcreteComponent"), qualified, "SunStorEdge_6120StorageExtent", null, null, true, false, null);
                    if (insts == null) {
                        request.setResults(_CONF_SERVICE_FAILURE);
                        WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + ": Failed to discover the StorageExtents for pool: " + pool.getObjectPath()));
                        return;
                    }
                    existingExtents = new Vector<CIMInstance>();
                    for (int i = 0; i < insts.length; ++i) {
                        existingExtents.add(insts[i]);
                    }
                }
                insts = null;
                if (pool != null) {
                    CIMObjectPath op = new CIMObjectPath("SunStorEdge_6120PoolSparedSet");
                    op.setNameSpace("\\root\\se6x20");
                    insts = RequestBroker.getInstance().enumerateInstances(this.getSystem(), op, false, true, false, null, null);
                    if (insts == null) {
                        hasDedicatedSpare = false;
                    } else {
                        for (int i = 0; i < insts.length; ++i) {
                            if (!name.equals(insts[i].getProperty("ElementName").getValue().getValue().toString())) continue;
                            hasDedicatedSpare = true;
                            break;
                        }
                    }
                }
                insts = null;
                if (pool != null && (insts = RequestBroker.getInstance().associators(new CIMObjectPath("SunStorEdge_6120PoolElementCapabilities"), qualified, "SunStorEdge_6120PoolStorageCapabilities", null, null, true, false, null)) == null) {
                    request.setResults(_CONF_SERVICE_FAILURE);
                    WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + ": Failed to discover the StorageCapabilities for pool: " + pool.getObjectPath()));
                    return;
                }
                caps = insts[0];
                if (ArrayInventory.getInstance().getArrayObject(this.getSystem().getHost()).isFeatureSupported(3)) {
                    support = true;
                }
                oldPackageMax = this.getInt16(caps.getProperty("PackageRedundancyMax"));
                oldPackageMin = this.getInt16(caps.getProperty("PackageRedundancyMin"));
                oldPackageDef = this.getInt16(caps.getProperty("PackageRedundancyDefault"));
                oldDataMax = this.getInt16(caps.getProperty("DataRedundancyMax"));
                oldDataMin = this.getInt16(caps.getProperty("DataRedundancyMin"));
                WWN = this.getString(caps.getProperty("InstanceID"));
                profile = this.getString(storSet.getProperty("Description"));
                newPackageMin = this.getInt16(storSet.getProperty("PackageRedundancyMin"));
                newDataMin = this.getInt16(storSet.getProperty("DataRedundancyMin"));
                if (!support || newDataMin == -1 || newPackageMin == -1) break block38;
                if (oldDataMin != newDataMin) {
                    request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
                    WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + ": An invalid RAID & Spare setting was given for the " + "current configuration."));
                    WBEMDebug.trace2((String)(CLASSNAME + "." + METHOD + " Old capabilities: " + "DataRedundancyMax=" + oldDataMax + " DataRedundancyMin=" + oldDataMin + " PackageRedundancyMax=" + oldPackageMax + " PackageRedundancyMin=" + oldPackageMin + " Request: " + " DataRedundancyMin=" + newDataMin + " PackageRedundancyMin=" + newPackageMin));
                    return;
                }
                if (oldPackageMin != newPackageMin) {
                    if (oldDataMax == 1 && oldDataMin == 1 && oldPackageMax == 0 && oldPackageMin == 0) {
                        request.setResults(_CONF_SERVICE_NOT_SUPPORTED);
                        WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + ": An invalid operation was attempted.  This" + " pool is RAID 0, which does not allow for" + " adding/removing a spare. "));
                        WBEMDebug.trace2((String)(CLASSNAME + "." + METHOD + " Old capabilities: " + "DataRedundancyMax=" + oldDataMax + " DataRedundancyMin=" + oldDataMin + " PackageRedundancyMax=" + oldPackageMax + " PackageRedundancyMin=" + oldPackageMin + " Request: " + " DataRedundancyMin=" + newDataMin + " PackageRedundancyMin=" + newPackageMin));
                        return;
                    }
                    if (newPackageMin > oldPackageMin) {
                        addSpare = true;
                    } else {
                        removeSpare = true;
                    }
                    String[] cmds = null;
                    String[] prompts = null;
                    String[] resp = null;
                    String[] errs = null;
                    if (removeSpare && support) {
                        if (!hasDedicatedSpare) {
                            request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
                            WBEMDebug.trace2((String)(CLASSNAME + "." + METHOD + ": Request was made to remove a spare " + "for a pool which has none.  Pool: " + name));
                            return;
                        }
                        cmds = new String[2];
                        prompts = new String[2];
                        resp = new String[3];
                        errs = new String[3];
                        resp[0] = "WARNING - The standby will be removed.";
                        resp[1] = ">";
                        resp[2] = ">";
                        errs[0] = "There is no standby drive";
                        errs[1] = "invalid argument value";
                        errs[2] = "ERROR";
                        cmds[0] = "vol remove_standby " + name;
                        prompts[0] = "[N]";
                        cmds[1] = "Y";
                    } else if (addSpare && support) {
                        if (hasDedicatedSpare) {
                            request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
                            WBEMDebug.trace2((String)(CLASSNAME + "." + METHOD + ": Request was made to add a dedicated spare " + "for a pool that has one.  Pool: " + name));
                            return;
                        }
                        String hotSpare = null;
                        try {
                            hotSpare = this.getHotSpareFruID(existingExtents, support, true);
                            if (null == hotSpare) {
                                request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
                                WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + ": No valid spare was discovered to add."));
                                return;
                            }
                        }
                        catch (CIMException ce) {
                            request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
                            WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + ": No valid spare was discovered to add."), (Throwable)ce);
                            return;
                        }
                        cmds = new String[1];
                        prompts = null;
                        resp = new String[1];
                        errs = new String[3];
                        resp[0] = ">";
                        errs[0] = "bad drive number";
                        errs[1] = "There is already a standby drive";
                        errs[2] = "ERROR";
                        cmds[0] = "vol add_standby " + name + " standby " + hotSpare;
                    }
                    try {
                        DevComm.getInstance().telnetMultiPost(this.getSystem(), cmds, resp, errs, prompts, new int[0]);
                    }
                    catch (StorEdgeIOException ioe) {
                        request.setResults(_CONF_SERVICE_FAILURE);
                        WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + ": Exception occurred from communication " + "between the provider and the array." + ioe.getMessage()), (Throwable)ioe);
                        return;
                    }
                    catch (ArrayException ae) {
                        request.setResults(_CONF_SERVICE_FAILURE);
                        WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + ": Exception occurred from communication " + "between the provider and the array."), (Throwable)ae);
                        return;
                    }
                    updateCache = true;
                    break block39;
                } else {
                    removeSpare = false;
                    addSpare = false;
                }
                break block39;
            }
            if (!support && newPackageMin != -1 && newPackageMin != oldPackageDef) {
                request.setResults(_CONF_SERVICE_NOT_SUPPORTED);
                WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + ": An invalid operation was attempted.  This" + " array does not support changing the spare" + " for a pool. "));
                WBEMDebug.trace2((String)(CLASSNAME + "." + METHOD + " Old capabilities: " + "DataRedundancyMax=" + oldDataMax + " DataRedundancyMin=" + oldDataMin + " PackageRedundancyMax=" + oldPackageMax + " PackageRedundancyMin=" + oldPackageMin + " Request: " + " DataRedundancyMin=" + newDataMin + " PackageRedundancyMin=" + newPackageMin));
                return;
            }
        }
        if (profile != null && !profile.equals(oldProfile = this.getString(caps.getProperty("Description")))) {
            StorEdge_PersistentStorage.getInstance().setPersistentString("SunStorEdge_6120StoragePool." + WWN + ".ProfileKey", profile, true);
            if (!updateCache) {
                caps.setProperty("Description", new CIMValue((Object)profile));
                RequestBroker.getInstance().addInstance(caps);
            }
        }
        if (RequestBroker.getInstance().isSyntheticCacheInstance(storSet.getObjectPath())) {
            RequestBroker.getInstance().deleteInstance(storSet.getObjectPath());
        }
        if (updateCache) {
            RequestBroker.getInstance().invalidateCache(this.getSystem());
        }
        CIMArgument[] outParams = request.getOutParams();
        outParams[0] = new CIMArgument("Job", null);
        outParams[1] = new CIMArgument("Size", null);
        outParams[2] = new CIMArgument("Pool", null);
        request.setResults(_CONF_SERVICE_COMPLETE_SUCCESSFUL);
    }

    private synchronized void createStoragePool(InvokeRequest request) throws CIMException, ArrayException, StorEdgeIOException {
        String METHOD = "createStoragePool";
        Vector extents = new Vector();
        Vector<CIMInstance> newDrives = new Vector<CIMInstance>();
        CIMInstance storSet = null;
        CIMInstance cluster = null;
        String unitIndex = "-1";
        String volName = null;
        String volRaidLevel = "raid";
        String hotSpare = null;
        String volIndex = null;
        int _VOL_INIT_RATE = 8;
        boolean _VOL_SAFETY_LEVEL = true;
        boolean _INSTANCE_NAME_INDEX = false;
        boolean _STOR_SETT_INDEX = true;
        int _POOL_SIZE_INDEX = 2;
        int _EXTENT_ARRAY_INDEX = 4;
        int _JOB_DESCRIPTION_INDEX = 6;
        int[] paramIndex = new int[]{0, 1, 4};
        String[] paramNames = new String[]{"Name", "Goal", "InExtents[]"};
        WBEMDebug.trace3((String)(CLASSNAME + "." + METHOD + " entered"));
        try {
            int badIndex = this.checkForNullParams(paramIndex, request);
            if (badIndex != -1) {
                request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
                WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + ": Encountered a null parameter: " + paramNames[badIndex]));
                return;
            }
        }
        catch (Exception e) {
            request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
            WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + ": Encountered an exception. "), (Throwable)e);
            return;
        }
        CIMArgument[] inArgs = request.getInParams();
        for (int i = 0; i < inArgs.length; ++i) {
            if (inArgs[i].getName().equalsIgnoreCase("InExtents")) {
                extents = (Vector)inArgs[i].getValue().getValue();
            }
            if (!inArgs[i].getName().equalsIgnoreCase("Goal")) continue;
            storSet = RequestBroker.getInstance().getInstance((CIMObjectPath)inArgs[i].getValue().getValue(), false, false, false, null, null);
            WBEMDebug.trace2((String)(CLASSNAME + "." + METHOD + ": StorageSetting" + storSet.toString()));
        }
        if (extents.isEmpty()) {
            request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
            WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " failed to discover any StorageExtents for this Pool"));
            return;
        }
        volName = (String)inArgs[0].getValue().getValue();
        if (volName == null) {
            request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
            WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " No name found for the intended pool "));
            return;
        }
        if (volName.length() >= 12) {
            volName = volName.substring(0, Math.min(volName.length(), 12));
        }
        int numDrives = extents.size();
        Vector<String> fruIds = new Vector<String>();
        Iterator driveIter = extents.iterator();
        while (driveIter.hasNext()) {
            String extent = (String)driveIter.next();
            Matcher devIdMatcher = DEVIDPATTERN.matcher(extent);
            if (!devIdMatcher.find()) {
                request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
                WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " No name found for the intended pool "));
                return;
            }
            fruIds.add("u" + devIdMatcher.group(1) + "d" + devIdMatcher.group(2));
        }
        CIMInstance[] poolDrives = null;
        try {
            poolDrives = RequestBroker.getInstance().enumerateInstances(this.getSystem(), new CIMObjectPath("SunStorEdge_6120StorageExtent"), false, true, false, null, null);
        }
        catch (CIMException ce) {
            WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " An exception occurred while retrieving the " + "StorageExtents: " + (Object)((Object)ce)), (Throwable)ce);
            request.setResults(_CONF_SERVICE_FAILURE);
            return;
        }
        for (int i = 0; i < poolDrives.length; ++i) {
            CIMInstance aDrive = poolDrives[i];
            CIMProperty prop = aDrive.getProperty("DeviceID");
            if (prop.getValue() == null && prop.getValue().getValue() == null) {
                WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " Could not find the DeviceID property for " + "StorageExtent: " + aDrive));
                request.setResults(_CONF_SERVICE_FAILURE);
                return;
            }
            if (!fruIds.contains((String)prop.getValue().getValue())) continue;
            newDrives.add(aDrive);
        }
        int dmin = 15;
        int dmax = 0;
        String inUnitIndex = null;
        Iterator fruIter = fruIds.iterator();
        while (fruIter.hasNext()) {
            String elementname = (String)fruIter.next();
            inUnitIndex = elementname.substring(elementname.indexOf("u") + 1, elementname.indexOf("d"));
            if (unitIndex.equals("-1")) {
                unitIndex = inUnitIndex;
            }
            if (!unitIndex.equals(inUnitIndex)) {
                request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
                WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " StorageExtents for Pool aren't within the same tray"));
                return;
            }
            int dval = new Integer(elementname.substring(elementname.indexOf("d") + 1));
            if (dval < dmin) {
                dmin = dval;
            }
            if (dval <= dmax) continue;
            dmax = dval;
        }
        if (dmax - dmin + 1 > numDrives || dmax < dmin) {
            request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
            WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " StorageExtents Not Proper"));
            return;
        }
        CIMObjectPath clusOp = new CIMObjectPath();
        clusOp.setNameSpace(request.getObjectPath().getNameSpace());
        clusOp.setObjectName("SunStorEdge_6120Cluster");
        CIMInstance[] insts = null;
        CIMObjectPath qualified = request.getObjectPath();
        qualified.setNameSpace("\\root\\se6x20");
        insts = RequestBroker.getInstance().associators(new CIMObjectPath("SunStorEdge_6120HostedConfigService"), qualified, "SunStorEdge_6120Cluster", null, null, true, false, null);
        if (insts == null) {
            request.setResults(_CONF_SERVICE_FAILURE);
            WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + ": Failed to discover the ConfigService for cluster: " + request.getObjectPath()));
            return;
        }
        cluster = insts[0];
        if (cluster == null) {
            WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " Could not find the Cluster this array is supposed to map to: " + this.getSystem().getHost()));
            request.setResults(_CONF_SERVICE_FAILURE);
            return;
        }
        CIMObjectPath assocName = new CIMObjectPath("SunStorEdge_6120ComputerSystemPackage");
        qualified = cluster.getObjectPath();
        qualified.setNameSpace("\\root\\se6x20");
        insts = RequestBroker.getInstance().associators(assocName, qualified, "SunStorEdge_6120Chassis", null, null, true, false, null);
        if (insts.length == 0) {
            WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " : There are no trays for this pool to be created, on to: " + this.getSystem().getHost()));
            request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
            return;
        }
        WBEMDebug.trace3((String)(CLASSNAME + "." + METHOD + ": found Cluster for this system."));
        HashSet<String> usedVolIndices = new HashSet<String>();
        assocName = new CIMObjectPath("SunStorEdge_6120HostedStoragePool");
        qualified = cluster.getObjectPath();
        qualified.setNameSpace("\\root\\se6x20");
        insts = RequestBroker.getInstance().associators(assocName, qualified, "SunStorEdge_6120StoragePool", null, null, true, false, null);
        int iUnitIndex = Integer.parseInt(unitIndex);
        if (insts != null) {
            for (int i = 0; i < insts.length; ++i) {
                CIMInstance poolInst = insts[i];
                CIMProperty poolProp = poolInst.getProperty("PoolID");
                if (poolProp.getValue() == null || poolProp.getValue().getValue() == null) {
                    WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " Could not find the PoolID property for " + "Pool: " + poolInst));
                    request.setResults(_CONF_SERVICE_FAILURE);
                    return;
                }
                String poolid = (String)poolProp.getValue().getValue();
                String uIndex = poolid.substring(poolid.indexOf("u") + 1, poolid.indexOf("v"));
                if (Integer.parseInt(uIndex) + 1 != iUnitIndex) continue;
                String vIndex = poolid.substring(poolid.indexOf("v") + 1);
                WBEMDebug.trace3((String)(CLASSNAME + "." + METHOD + " adding to usedVolIndices: " + vIndex));
                usedVolIndices.add(vIndex);
            }
        }
        if (usedVolIndices.size() >= 2) {
            WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + ": Maximum pools already exist on this tray!"));
            request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
            return;
        }
        volIndex = usedVolIndices.contains("0") ? "1" : "0";
        Vector props = storSet.getProperties();
        Iterator iter = props.iterator();
        boolean noSinglePoint = false;
        int dataRedunMin = -1;
        int packageRedunMin = -1;
        String profileDesc = "";
        while (iter.hasNext()) {
            CIMProperty settProp = (CIMProperty)iter.next();
            if (settProp.getValue() == null || settProp.getValue().getValue() == null) {
                if (!settProp.getName().equalsIgnoreCase("PackageRedundancyMin") && !settProp.getName().equalsIgnoreCase("NoSinglePointOfFailure") && !settProp.getName().equalsIgnoreCase("DataRedundancyMin")) continue;
                request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
                WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " Volume index not accepted:  " + unitIndex));
                return;
            }
            if (settProp.getName().equalsIgnoreCase("PackageRedundancyMin")) {
                packageRedunMin = this.getInt16(settProp);
                continue;
            }
            if (settProp.getName().equalsIgnoreCase("NoSinglePointOfFailure")) {
                if (settProp.getType().getType() != 9) continue;
                Boolean b = (Boolean)settProp.getValue().getValue();
                noSinglePoint = b;
                continue;
            }
            if (settProp.getName().equalsIgnoreCase("DataRedundancyMin")) {
                dataRedunMin = this.getInt16(settProp);
                continue;
            }
            if (!settProp.getName().equalsIgnoreCase("Description")) continue;
            profileDesc = this.getString(settProp);
        }
        int raid = -1;
        try {
            raid = this.getRaidLevel(packageRedunMin, noSinglePoint, dataRedunMin);
        }
        catch (CIMException ce) {
            request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
            WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " RAID level is not within defined parameters,  " + " PackageRedundancyMin = " + packageRedunMin + " NoSinglePointOfFailure = " + noSinglePoint + " DataRedundancyMin = " + dataRedunMin), (Throwable)ce);
            return;
        }
        boolean useAnyHotSpare = false;
        boolean requestingDedicatedSpare = false;
        if (ArrayInventory.getInstance().getArrayObject(this.getSystem().getHost()).isFeatureSupported(3)) {
            useAnyHotSpare = true;
        }
        boolean invalidRequest = false;
        if (raid == 1 || raid == 5) {
            if (packageRedunMin == 1) {
                requestingDedicatedSpare = false;
            } else if (packageRedunMin == 2) {
                requestingDedicatedSpare = true;
            } else {
                invalidRequest = true;
            }
        } else if (raid == 0 && packageRedunMin == 0) {
            requestingDedicatedSpare = false;
        } else {
            invalidRequest = true;
        }
        if (invalidRequest) {
            request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
            WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " Provided RAID and spare request is not valid for " + " the given parameters and configuration of the " + " array.   Requested RAID level: " + raid + " PackageRedundancyMin: " + packageRedunMin + " DataRedundancyMin: " + dataRedunMin));
            return;
        }
        if (requestingDedicatedSpare) {
            try {
                hotSpare = this.getHotSpareFruID(newDrives, useAnyHotSpare, false);
                if (null == hotSpare) {
                    request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
                    WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + ": No valid spare was discovered to add."));
                    return;
                }
            }
            catch (CIMException ce) {
                request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
                WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " Provided spare request is not valid for the " + " given parameters and configuration of the array. " + " Requested RAID level: " + raid + " Drives requested: " + newDrives), (Throwable)ce);
                return;
            }
        }
        String drives = "u" + unitIndex + "d";
        drives = dmin > 9 ? drives + dmin : drives + "0" + dmin;
        drives = dmax > 9 ? drives + "-" + dmax : drives + "-0" + dmax;
        String cmd = "vol add " + volName + " data " + drives + " raid " + raid;
        if (requestingDedicatedSpare) {
            cmd = cmd + " standby " + hotSpare;
        }
        if (RequestBroker.getInstance().isSyntheticCacheInstance(storSet.getObjectPath())) {
            RequestBroker.getInstance().deleteInstance(storSet.getObjectPath());
        }
        String[] telnetcmds = new String[4];
        WBEMDebug.trace3((String)(CLASSNAME + ": telnet create pool cmd = " + cmd));
        telnetcmds[0] = cmd;
        telnetcmds[1] = cmd = "vol init " + volName + " data";
        telnetcmds[2] = cmd = "vol mount " + volName;
        telnetcmds[3] = this.getSystem().getHost();
        unitIndex = this.subtractOne(unitIndex);
        Vector<Object> tokenArgs = new Vector<Object>();
        tokenArgs.add("unitIndex=" + unitIndex);
        tokenArgs.add("volIndex=" + volIndex);
        tokenArgs.add("volName=" + volName);
        tokenArgs.add("volArrayWidth=" + numDrives);
        tokenArgs.add("volRaidLevel=" + volRaidLevel + raid);
        tokenArgs.add("volSafety=1");
        tokenArgs.add("volInitRate=8");
        tokenArgs.add("unitStandby=" + hotSpare);
        tokenArgs.add(extents);
        tokenArgs.add(profileDesc);
        CIMInstance hsInst = null;
        Vector<String> hsVector = new Vector<String>();
        if (requestingDedicatedSpare) {
            hsInst = this.getHotSpareInstance(newDrives, useAnyHotSpare, false);
            hsVector.add(hsInst.getObjectPath().toString());
        }
        tokenArgs.add(hsVector);
        String jobDesc = null;
        try {
            jobDesc = (String)inArgs[6].getValue().getValue();
        }
        catch (NullPointerException ne) {
        }
        catch (ArrayIndexOutOfBoundsException ae) {
        }
        catch (Exception e) {
            request.setResults(_CONF_SERVICE_FAILURE);
            WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + ": Encountered an exception. " + e.getMessage()), (Throwable)e);
            return;
        }
        CIMObjectPath jobOp = null;
        jobOp = jobDesc != null ? ModifyJobs.getInstance(this.getSystem().getHost()).createJob("createPool", tokenArgs, telnetcmds, jobDesc) : ModifyJobs.getInstance(this.getSystem().getHost()).createJob("createPool", tokenArgs, telnetcmds);
        CIMArgument[] outParams = request.getOutParams();
        outParams[0] = new CIMArgument("Job", new CIMValue((Object)jobOp));
        outParams[1] = new CIMArgument("Size", null);
        outParams[2] = new CIMArgument("Pool", null);
        request.setResults(_CONF_SERVICE_JOB_STARTED);
    }

    private void initializeStoragePool(InvokeRequest request) throws CIMException, ArrayException, StorEdgeIOException {
        String METHOD = "initializeStoragePool";
        boolean _POOL_INDEX = false;
        boolean _JOB_DESCRIPTION_INDEX = true;
        CIMInstance poolInst = null;
        Vector<String> tokenArgs = new Vector<String>();
        int[] paramIndex = new int[]{0};
        String[] paramNames = new String[]{"Pool"};
        WBEMDebug.trace3((String)(CLASSNAME + "." + METHOD + " entered"));
        try {
            int badIndex = this.checkForNullParams(paramIndex, request);
            if (badIndex != -1) {
                request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
                WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + ": Encountered a null parameter: " + paramNames[badIndex]));
                return;
            }
        }
        catch (Exception e) {
            request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
            WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + ": Encountered an exception. "), (Throwable)e);
            return;
        }
        CIMArgument[] inArgs = request.getInParams();
        if (inArgs == null) {
            request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
            WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " Did not have any parameters"));
            return;
        }
        if (inArgs[0].getValue().getType().getType() == 28) {
            WBEMDebug.trace3((String)(CLASSNAME + "." + METHOD + " have reference type"));
            if (inArgs[0].getType().getRefClassName().equalsIgnoreCase("SunStorEdge_6120StoragePool")) {
                CIMArgument delArg;
                WBEMDebug.trace3((String)(CLASSNAME + "." + METHOD + " have storage pool to initialize"));
                CIMObjectPath op = (CIMObjectPath)inArgs[0].getValue().getValue();
                poolInst = RequestBroker.getInstance().getInstance(op, false, false, false, null, null);
                if (poolInst == null) {
                    request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
                    WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " Could not find instance of Pool to initialize"));
                    return;
                }
                CIMProperty prop = poolInst.getProperty("PoolID");
                if (prop.getValue() == null || prop.getValue().getValue() == null) {
                    request.setResults(_CONF_SERVICE_FAILURE);
                    WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " Could not discover PoolID property for Pool: " + poolInst));
                    return;
                }
                String poolid = (String)prop.getValue().getValue();
                WBEMDebug.trace3((String)(CLASSNAME + "." + METHOD + " parsing poolId: " + poolid));
                String uIndex = poolid.substring(poolid.indexOf("u") + 1, poolid.indexOf("v"));
                String vIndex = poolid.substring(poolid.indexOf("v") + 1);
                WBEMDebug.trace3((String)(CLASSNAME + "." + METHOD + " parsed uIndex: " + uIndex + " vIndex: " + vIndex));
                prop = poolInst.getProperty("ElementName");
                if (prop.getValue() == null || prop.getValue().getValue() == null) {
                    request.setResults(_CONF_SERVICE_FAILURE);
                    WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " Could not discover ElementName property for Pool: " + poolInst));
                    return;
                }
                String volName = (String)prop.getValue().getValue();
                WBEMDebug.trace3((String)(CLASSNAME + "." + METHOD + " have volName: " + volName));
                tokenArgs.add("unitIndex=" + uIndex);
                tokenArgs.add("volIndex=" + vIndex);
                tokenArgs.add("volName=" + volName);
                tokenArgs.add(poolid);
                String[] telnetcmds = new String[]{"padding to match createStoragePool indexing", "vol init " + volName + " data", "vol mount " + volName, this.getSystem().getHost()};
                String jobDesc = null;
                try {
                    jobDesc = (String)inArgs[1].getValue().getValue();
                }
                catch (NullPointerException ne) {
                }
                catch (ArrayIndexOutOfBoundsException ae) {
                }
                catch (Exception e) {
                    request.setResults(_CONF_SERVICE_FAILURE);
                    WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + ": Encountered an exception. " + e.getMessage()), (Throwable)e);
                    return;
                }
                CIMObjectPath jobOp = null;
                jobOp = jobDesc != null ? ModifyJobs.getInstance(this.getSystem().getHost()).createJob("initializePool", tokenArgs, telnetcmds, jobDesc) : ModifyJobs.getInstance(this.getSystem().getHost()).createJob("initializePool", tokenArgs, telnetcmds);
                CIMArgument[] outParams = request.getOutParams();
                CIMValue jobVal = new CIMValue((Object)jobOp);
                outParams[0] = delArg = new CIMArgument("Job", jobVal);
                request.setResults(_CONF_SERVICE_JOB_STARTED);
            }
        } else {
            request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
        }
    }

    private void createOrModifyArraySparedSet(InvokeRequest request) throws CIMException, ArrayException, StorEdgeIOException {
        String METHOD = "createOrModifyArraySparedSet";
        boolean _SPARED_SET_INDEX = true;
        boolean _REDUNDANT_EXTENT_INDEX = false;
        int _JOB_DESCRIPTION_INDEX = 2;
        int _EXTENT_STATE_INDEX = 2;
        int _EXTENT_ROLE_INDEX = 3;
        int _MAX_GLOBAL_STANDBY_DRIVE_COUNT = 8;
        String _TELNET_ERROR_INVALID_DRIVE = "ERROR (20001F) VN_DEVINVALID: invalid drive specified";
        String _TELNET_ERROR_INVALID_DRIVE_REMOVE = "is not found in the Global Standby pool.";
        String _TELNET_ERROR_REDUNDANT_DRIVE = "ERROR (200035) VN_DEVINGHSDB: The drive is already in";
        CIMInstance spareSet = null;
        Vector tokenArgs = new Vector();
        Vector newextents = new Vector();
        Vector<String> tobeRemoved = new Vector<String>();
        int[] paramIndex = new int[]{0};
        String[] paramNames = new String[]{"RedundantExtents"};
        WBEMDebug.trace3((String)(CLASSNAME + "." + METHOD + " entered"));
        try {
            int badIndex = this.checkForNullParams(paramIndex, request);
            if (badIndex != -1) {
                request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
                WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + ": Encountered a null parameter: " + paramNames[badIndex]));
                return;
            }
        }
        catch (Exception e) {
            request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
            WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + ": Encountered an exception. "), (Throwable)e);
            return;
        }
        CIMArgument[] inArgs = request.getInParams();
        if (inArgs == null) {
            request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
            WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " Did not have any parameters"));
            return;
        }
        if (!ArrayInventory.getInstance().getArrayObject(this.getSystem().getHost()).isFeatureSupported(3)) {
            request.setResults(_CONF_SERVICE_NOT_SUPPORTED);
            WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " Firmware version does not support this operation."));
            return;
        }
        for (int i = 0; i < inArgs.length; ++i) {
            if (!inArgs[i].getName().equalsIgnoreCase("RedundantExtents")) continue;
            newextents = (Vector)inArgs[i].getValue().getValue();
            break;
        }
        if (newextents.size() > 8) {
            request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
            WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " Number of extents exceeds the maximum allowable " + "number of drives to be participant in the array" + "spare set, " + 8));
            return;
        }
        CIMInstance[] cacheExtents = RequestBroker.getInstance().enumerateInstances(this.getSystem(), new CIMObjectPath("SunStorEdge_6120StorageExtent"), false, true, false, null, null);
        HashMap<String, CIMInstance> templist = new HashMap<String, CIMInstance>();
        block12: for (int i = 0; i < newextents.size(); ++i) {
            String piece = (String)newextents.get(i);
            Matcher devIdMatcher = DEVIDPATTERN.matcher(piece);
            if (!devIdMatcher.find()) {
                request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
                WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " No name found for the intended pool "));
                return;
            }
            String matched = "u" + devIdMatcher.group(1) + "d" + devIdMatcher.group(2);
            if (devIdMatcher.group(2).equalsIgnoreCase("01")) {
                request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
                WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " The first drive in a tray is not valid for Array Spares."));
                return;
            }
            try {
                for (int k = 0; k < cacheExtents.length; ++k) {
                    CIMInstance anExtent = cacheExtents[k];
                    CIMProperty uid = anExtent.getProperty("DeviceID");
                    if (!matched.equals((String)uid.getValue().getValue())) continue;
                    templist.put(matched, anExtent);
                    continue block12;
                }
                continue;
            }
            catch (NullPointerException npe) {
                request.setResults(_CONF_SERVICE_FAILURE);
                WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " A NullPointerException was encountered while attempting " + "to extract property data for a StorageExtent:" + npe), (Throwable)npe);
                return;
            }
        }
        if (templist.size() != newextents.size()) {
            request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
            WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " Could not find the StorageExtents in cache to match!"));
            return;
        }
        newextents.removeAllElements();
        newextents.addAll(templist.values());
        if (inArgs[1].getValue().getType().getType() == 28) {
            WBEMDebug.trace3((String)(CLASSNAME + "." + METHOD + " have reference type"));
            if (inArgs[1].getType().getRefClassName().equalsIgnoreCase("SunStorEdge_6120ArraySparedSet")) {
                CIMArgument delArg;
                WBEMDebug.trace3((String)(CLASSNAME + "." + METHOD + " have spared set to modify"));
                CIMObjectPath op = (CIMObjectPath)inArgs[1].getValue().getValue();
                spareSet = RequestBroker.getInstance().getInstance(op, false, false, false, null, null);
                if (spareSet == null) {
                    request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
                    WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " Could not find instance of SparedSet to modify"));
                    return;
                }
                boolean extentInUse = false;
                try {
                    Iterator extentIter = newextents.iterator();
                    while (extentIter.hasNext()) {
                        CIMInstance anExtent = (CIMInstance)extentIter.next();
                        CIMProperty extProp = anExtent.getProperty("OtherIdentifyingInfo");
                        Vector propVec = (Vector)extProp.getValue().getValue();
                        String extRole = (String)propVec.get(3);
                        String extState = (String)propVec.get(2);
                        if (extRole.equalsIgnoreCase("globalStandbyDisk") || extState.equalsIgnoreCase("enabled") && extRole.equalsIgnoreCase("unassigned")) continue;
                        extentInUse = true;
                        break;
                    }
                }
                catch (NullPointerException npe) {
                    request.setResults(_CONF_SERVICE_FAILURE);
                    WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " A NullPointerException was encountered while attempting " + "to extract property data for a StorageExtent:" + npe), (Throwable)npe);
                    return;
                }
                if (extentInUse) {
                    request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
                    WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " Passed in extent is currently in use as part " + "of a data volume or unavailable."));
                    return;
                }
                op = new CIMObjectPath("SunStorEdge_6120ArraySparedSet");
                CIMInstance[] oldSets = RequestBroker.getInstance().enumerateInstances(this.getSystem(), op, false, true, false, null, null);
                CIMInstance oldSet = oldSets[0];
                if (oldSet != null) {
                    CIMObjectPath qualified = oldSet.getObjectPath();
                    qualified.setNameSpace("\\root\\se6x20");
                    CIMObjectPath assoc = new CIMObjectPath("SunStorEdge_6120IsArraySpare");
                    CIMInstance[] oldextents = RequestBroker.getInstance().associators(assoc, qualified, "SunStorEdge_6120StorageExtent", null, null, true, false, null);
                    if (oldextents != null) {
                        try {
                            for (int i = 0; i < oldextents.length; ++i) {
                                CIMInstance modextent = oldextents[i];
                                String fruId = (String)modextent.getProperty("DeviceID").getValue().getValue();
                                if (templist.containsKey(fruId)) {
                                    templist.remove(fruId);
                                    continue;
                                }
                                tobeRemoved.add(fruId);
                            }
                        }
                        catch (NullPointerException npe) {
                            request.setResults(_CONF_SERVICE_FAILURE);
                            WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " A NullPointerException was encountered while " + "attempting to extract property data for a " + "StorageExtent:" + npe), (Throwable)npe);
                            return;
                        }
                        if (oldextents.length - tobeRemoved.size() + templist.size() > 8) {
                            request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
                            WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " Passed in extents exceed the maximum size of " + "the array standby set."));
                            return;
                        }
                        if (tobeRemoved.size() > 0) {
                            String base = "global_standby remove ";
                            for (int i = 0; i < tobeRemoved.size(); ++i) {
                                tobeRemoved.set(i, base.concat((String)tobeRemoved.get(i)));
                            }
                        }
                    }
                }
                String[] resp = new String[tobeRemoved.size() + templist.size()];
                String[] telnetcmds = new String[tobeRemoved.size() + templist.size()];
                for (int i = 0; i < tobeRemoved.size(); ++i) {
                    telnetcmds[i] = (String)tobeRemoved.get(i);
                    resp[i] = ">";
                }
                Iterator keyIter = templist.keySet().iterator();
                int i = tobeRemoved.size();
                while (keyIter.hasNext()) {
                    String devId = (String)keyIter.next();
                    telnetcmds[i] = "global_standby add " + devId;
                    resp[i] = ">";
                    ++i;
                }
                String[] dserrs = new String[]{"usage: ", "Command not reentrant", "Command not found", "ERROR (20001F) VN_DEVINVALID: invalid drive specified", "ERROR", "It can't be removed"};
                try {
                    DevComm.getInstance().telnetMultiPost(this.getSystem(), telnetcmds, resp, dserrs, new int[0]);
                }
                catch (StorEdgeIOException ioe) {
                    request.setResults(_CONF_SERVICE_FAILURE);
                    WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + ": Exception occurred from communication " + "between the provider and the array." + ioe.getMessage()), (Throwable)ioe);
                    return;
                }
                catch (ArrayException ae) {
                    request.setResults(_CONF_SERVICE_FAILURE);
                    WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + ": Exception occurred from communication " + "between the provider and the array." + ae.getMessage()), (Throwable)ae);
                    return;
                }
                CIMArgument[] outParams = request.getOutParams();
                CIMValue jobVal = new CIMValue(null);
                outParams[0] = delArg = new CIMArgument("Job", jobVal);
                request.setResults(_CONF_SERVICE_COMPLETE_SUCCESSFUL);
                RequestBroker.getInstance().invalidateCache(this.getSystem());
            } else {
                request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
                WBEMDebug.trace3((String)(CLASSNAME + "." + METHOD + " Unable to find the spared set in the parameters. Found class name: " + inArgs[1].getType().getRefClassName() + "  and found type: " + inArgs[1].getType()));
            }
        } else {
            request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
        }
    }

    private void deleteStoragePool(InvokeRequest request) throws CIMException, ArrayException, StorEdgeIOException {
        String METHOD = "deleteStoragePool";
        boolean _POOL_INDEX = false;
        boolean _JOB_DESCRIPTION_INDEX = true;
        CIMInstance poolInst = null;
        Vector<String> tokenArgs = new Vector<String>();
        int[] paramIndex = new int[]{0};
        String[] paramNames = new String[]{"Pool"};
        WBEMDebug.trace3((String)(CLASSNAME + "." + METHOD + " entered"));
        try {
            int badIndex = this.checkForNullParams(paramIndex, request);
            if (badIndex != -1) {
                request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
                WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + ": Encountered a null parameter: " + paramNames[badIndex]));
                return;
            }
        }
        catch (Exception e) {
            request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
            WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + ": Encountered an exception. " + e), (Throwable)e);
            return;
        }
        CIMArgument[] inArgs = request.getInParams();
        if (inArgs == null) {
            request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
            WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " Did not have any parameters"));
            return;
        }
        if (inArgs[0].getValue().getType().getType() == 28) {
            WBEMDebug.trace3((String)(CLASSNAME + "." + METHOD + " have reference type"));
            if (inArgs[0].getType().getRefClassName().equalsIgnoreCase("SunStorEdge_6120StoragePool")) {
                CIMArgument delArg;
                WBEMDebug.trace3((String)(CLASSNAME + "." + METHOD + " have storage pool to delete"));
                CIMObjectPath op = (CIMObjectPath)inArgs[0].getValue().getValue();
                poolInst = RequestBroker.getInstance().getInstance(op, false, false, false, null, null);
                if (poolInst == null) {
                    request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
                    WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " Could not find instance of Pool to delete"));
                    return;
                }
                CIMProperty prop = poolInst.getProperty("PoolID");
                if (prop.getValue() == null || prop.getValue().getValue() == null) {
                    request.setResults(_CONF_SERVICE_FAILURE);
                    WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " Could not discover PoolID property for Pool: " + poolInst));
                    return;
                }
                String poolid = (String)prop.getValue().getValue();
                WBEMDebug.trace3((String)(CLASSNAME + "." + METHOD + " parsing poolId: " + poolid));
                String uIndex = poolid.substring(poolid.indexOf("u") + 1, poolid.indexOf("v"));
                String vIndex = poolid.substring(poolid.indexOf("v") + 1);
                WBEMDebug.trace3((String)(CLASSNAME + "." + METHOD + " parsed uIndex: " + uIndex + " vIndex: " + vIndex));
                prop = poolInst.getProperty("ElementName");
                if (prop.getValue() == null || prop.getValue().getValue() == null) {
                    request.setResults(_CONF_SERVICE_FAILURE);
                    WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " Could not discover ElementName property for Pool: " + poolInst));
                    return;
                }
                CIMProperty poolWWN = poolInst.getProperty("InstanceID");
                String WWN = null;
                if (poolWWN != null && poolWWN.getValue() != null && poolWWN.getValue().getValue() != null) {
                    WWN = poolWWN.getValue().getValue().toString();
                    StorEdge_PersistentStorage.getInstance().removePersistentString("SunStorEdge_6120StoragePool." + WWN + ".ProfileKey", true);
                }
                String volName = (String)prop.getValue().getValue();
                WBEMDebug.trace3((String)(CLASSNAME + "." + METHOD + " have volName: " + volName));
                tokenArgs.add("unitIndex=" + uIndex);
                tokenArgs.add("volIndex=" + vIndex);
                tokenArgs.add("volName=" + volName);
                tokenArgs.add(poolid);
                String[] telnetcmds = new String[]{"vol unmount " + volName, "vol -y remove " + volName, this.getSystem().getHost()};
                String jobDesc = null;
                try {
                    jobDesc = (String)inArgs[1].getValue().getValue();
                }
                catch (NullPointerException ne) {
                }
                catch (ArrayIndexOutOfBoundsException ae) {
                }
                catch (Exception e) {
                    request.setResults(_CONF_SERVICE_FAILURE);
                    WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + ": Encountered an exception. " + e.getMessage()), (Throwable)e);
                    return;
                }
                CIMObjectPath jobOp = null;
                jobOp = jobDesc != null ? ModifyJobs.getInstance(this.getSystem().getHost()).createJob("deletePool", tokenArgs, telnetcmds, jobDesc) : ModifyJobs.getInstance(this.getSystem().getHost()).createJob("deletePool", tokenArgs, telnetcmds);
                CIMArgument[] outParams = request.getOutParams();
                CIMValue jobVal = new CIMValue((Object)jobOp);
                outParams[0] = delArg = new CIMArgument("Job", jobVal);
                request.setResults(_CONF_SERVICE_JOB_STARTED);
            }
        } else {
            request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
        }
    }

    private void returnToStoragePool(InvokeRequest request) throws CIMException, ArrayException, StorEdgeIOException {
        String METHOD = "returnToStoragePool";
        boolean _JOB_DESCRIPTION_INDEX = true;
        CIMInstance poolInst = null;
        Vector<Object> tokenArgs = new Vector<Object>();
        boolean _VOLSLICE_INDEX = false;
        CIMInstance volInst = null;
        String uIndex = null;
        String vIndex = null;
        CIMInstance[] assocs = null;
        int[] paramIndex = new int[]{0};
        String[] paramNames = new String[]{"TheElement"};
        WBEMDebug.trace3((String)(CLASSNAME + "." + METHOD + " entered"));
        try {
            int badIndex = this.checkForNullParams(paramIndex, request);
            if (badIndex != -1) {
                request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
                WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + ": Encountered a null parameter: " + paramNames[badIndex]));
                return;
            }
        }
        catch (Exception e) {
            request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
            WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + ": Encountered an exception. " + e), (Throwable)e);
            return;
        }
        CIMArgument[] inArgs = request.getInParams();
        if (inArgs[0].getType().getType() == 28) {
            if (inArgs[0].getType().getRefClassName().equalsIgnoreCase("SunStorEdge_6120StorageVolume")) {
                CIMProperty prop;
                int i;
                CIMObjectPath op = (CIMObjectPath)inArgs[0].getValue().getValue();
                volInst = RequestBroker.getInstance().getInstance(op, false, true, false, null, null);
                if (volInst == null) {
                    WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " Could not discover instance of StorageVolume" + " in cache to delete."));
                    request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
                    return;
                }
                CIMObjectPath qualified = volInst.getObjectPath();
                qualified.setNameSpace("\\root\\se6x20");
                assocs = RequestBroker.getInstance().associators(new CIMObjectPath("SunStorEdge_6120MappedProtocolControllerForUnit"), qualified, "SunStorEdge_6120AuthorizationViewSCSIController", null, null, true, false, null);
                if (assocs != null) {
                    for (i = 0; i < assocs.length; ++i) {
                        CIMInstance mapInst = assocs[i];
                        CIMProperty defGlobAcc = mapInst.getProperty("DefaultGlobalAccess");
                        if (defGlobAcc.getValue() == null || defGlobAcc.getValue().getValue() == null) {
                            WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " Could not discover instance of StorageVolume" + " in cache to delete."));
                            request.setResults(_CONF_SERVICE_FAILURE);
                            return;
                        }
                        if (((Boolean)defGlobAcc.getValue().getValue()).booleanValue()) continue;
                        WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + ": There remains an ACI non-default instance for " + "this StorageVolume: " + volInst));
                        request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
                        return;
                    }
                }
                qualified = volInst.getObjectPath();
                qualified.setNameSpace("\\root\\se6x20");
                assocs = RequestBroker.getInstance().associators(new CIMObjectPath("SunStorEdge_6120AllocatedFromStoragePool"), qualified, "SunStorEdge_6120StoragePool", null, null, true, false, null);
                if (assocs == null) {
                    WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " Did not find allocation for this storage volume."));
                    request.setResults(_CONF_SERVICE_FAILURE);
                    return;
                }
                i = 0;
                if (i < assocs.length) {
                    poolInst = assocs[i];
                    CIMProperty prop2 = poolInst.getProperty("PoolID");
                    if (prop2.getValue() == null || prop2.getValue().getValue() == null) {
                        WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " Did not find property PoolID for Pool: " + poolInst));
                        request.setResults(_CONF_SERVICE_FAILURE);
                        return;
                    }
                    String poolId = (String)poolInst.getProperty("PoolID").getValue().getValue();
                    if (poolId != null) {
                        uIndex = poolId.substring(poolId.indexOf("u") + 1, poolId.indexOf("v"));
                        vIndex = poolId.substring(poolId.indexOf("v") + 1);
                    } else {
                        WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + "No PoolID existed for this StoragePool"));
                        request.setResults(_CONF_SERVICE_FAILURE);
                        return;
                    }
                }
                if ((prop = volInst.getProperty("OtherIdentifyingInfo")).getType().isArrayType()) {
                    String volSliceName = (String)((Vector)prop.getValue().getValue()).get(0);
                    tokenArgs.add("unitIndex=" + uIndex);
                    tokenArgs.add("volIndex=" + vIndex);
                    tokenArgs.add("volSliceName=" + volSliceName);
                    CIMProperty poolName = poolInst.getProperty("ElementName");
                    if (poolName.getValue() == null || poolName.getValue().getValue() == null) {
                        WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " Did not find property ElementName for Pool: " + poolInst));
                        request.setResults(_CONF_SERVICE_FAILURE);
                        return;
                    }
                    tokenArgs.add(poolName.getValue().getValue());
                    String[] telnetcmds = new String[]{"volslice remove " + volSliceName, this.getSystem().getHost()};
                    String jobDesc = null;
                    try {
                        jobDesc = (String)inArgs[1].getValue().getValue();
                    }
                    catch (NullPointerException ne) {
                    }
                    catch (ArrayIndexOutOfBoundsException ae) {
                    }
                    catch (Exception e) {
                        request.setResults(_CONF_SERVICE_FAILURE);
                        WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + ": Encountered an exception. " + e.getMessage()), (Throwable)e);
                        return;
                    }
                    CIMObjectPath jobOp = null;
                    jobOp = jobDesc != null ? ModifyJobs.getInstance(this.getSystem().getHost()).createJob("deleteVolume", tokenArgs, telnetcmds, jobDesc) : ModifyJobs.getInstance(this.getSystem().getHost()).createJob("deleteVolume", tokenArgs, telnetcmds);
                    request.setResults(_CONF_SERVICE_JOB_STARTED);
                    CIMArgument[] outParams = request.getOutParams();
                    outParams[0] = new CIMArgument("Job", new CIMValue((Object)jobOp));
                } else {
                    request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
                    WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " unitIndex and volIndex were not discovered in" + " OtherIdentifyingInfo array"));
                }
            } else {
                request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
                WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + "Discovered element is not an instance of StorEdge" + "_6120StoragePool, required for this method"));
            }
        } else {
            request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
            WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + "The discovered element provided is not a Reference type, " + " required for this method"));
        }
    }

    private String convertBooleanToYes(boolean in) {
        if (in) {
            return "yes";
        }
        return "no";
    }

    private String getString(CIMProperty target) {
        String retString = null;
        if (target.getValue() != null && target.getValue().getValue() != null) {
            retString = target.getValue().getValue().toString();
        }
        return retString;
    }

    private int getInt16(CIMProperty target) {
        int retInt = -1;
        if (target.getValue() != null && target.getValue().getValue() != null) {
            retInt = ((UnsignedInt16)target.getValue().getValue()).intValue();
        }
        return retInt;
    }

    private String getHotSpareFruID(Vector extents, boolean anyHotSpare, boolean changePool) throws CIMException {
        String fruId = null;
        CIMInstance extent = this.getHotSpareInstance(extents, anyHotSpare, changePool);
        CIMProperty aProp = extent.getProperty("DeviceID");
        if (aProp.getValue() != null && aProp.getValue().getValue() != null) {
            fruId = (String)aProp.getValue().getValue();
        }
        return fruId;
    }

    private CIMInstance getHotSpareInstance(Vector extents, boolean anyHotSpare, boolean changePool) throws CIMException {
        CIMInstance retVal = null;
        CIMInstance thisExtent = null;
        Object cacheExtents = null;
        Vector<String> fruInUse = new Vector<String>();
        String trayNum = "-1";
        int _EXTENT_STATE_INDEX = 2;
        int _EXTENT_ROLE_INDEX = 3;
        String _STATE_ENABLED = "enabled";
        String _ROLE_STANDBY = "standbyDisk";
        String _ROLE_UNASSIGNED = "unassigned";
        String _ROLE_DATA_DISK = "dataDisk";
        String _LAST_DRIVE_ID = "d14";
        String _RESERVED_DRIVE_ID = "d01";
        String METHOD = "getHotSpareInstance";
        boolean extentInvalid = false;
        BigInteger smallest = null;
        Iterator exIter = extents.iterator();
        while (exIter.hasNext()) {
            thisExtent = (CIMInstance)exIter.next();
            CIMProperty prop = thisExtent.getProperty("OtherIdentifyingInfo");
            Vector propVec = (Vector)prop.getValue().getValue();
            String extRole = (String)propVec.get(3);
            String extState = (String)propVec.get(2);
            if (!changePool) {
                if (!extState.equalsIgnoreCase("enabled") || !extRole.equalsIgnoreCase("unassigned")) {
                    extentInvalid = true;
                    WBEMDebug.trace1((String)(CLASSNAME + "." + "getHotSpareInstance" + "The provided extent is not available for use as " + "a data drive. " + thisExtent));
                    break;
                }
            } else if (!extState.equalsIgnoreCase("enabled") || !extRole.equalsIgnoreCase("dataDisk")) {
                extentInvalid = true;
                WBEMDebug.trace1((String)(CLASSNAME + "." + "getHotSpareInstance" + "The provided extent is not currently used as " + "a data drive. " + thisExtent.getObjectPath()));
                break;
            }
            prop = thisExtent.getProperty("NumberOfBlocks");
            BigInteger blkSize = ((UnsignedInt64)prop.getValue().getValue()).bigIntValue();
            smallest = smallest == null ? blkSize : smallest.min(blkSize);
            prop = thisExtent.getProperty("DeviceID");
            String tempId = (String)prop.getValue().getValue();
            fruInUse.add(tempId);
            String parts = tempId.substring(tempId.indexOf("u") + 1, tempId.indexOf("d"));
            if (!trayNum.equals("-1")) {
                if (trayNum.equals(parts)) continue;
                WBEMDebug.trace1((String)(CLASSNAME + "." + "getHotSpareInstance" + "The requested StoragePool cannot be constructed because " + "a requested drive does not exist in the tray."));
                extentInvalid = true;
                break;
            }
            trayNum = parts;
        }
        if (extentInvalid) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
        CIMInstance[] gaa = RequestBroker.getInstance().enumerateInstances(this.getSystem(), new CIMObjectPath("SunStorEdge_6120StorageExtent"), false, true, false, null, null);
        trayNum = "u" + trayNum;
        Vector<CIMInstance> evalExtent = new Vector<CIMInstance>();
        CIMInstance[] poolJobs = this.getCreatePoolJobs();
        boolean supportsHotSpare = ArrayInventory.getInstance().getArrayObject(this.getSystem().getHost()).isFeatureSupported(3);
        for (int i = 0; i < gaa.length; ++i) {
            CIMInstance anExtent = gaa[i];
            CIMProperty aProp = anExtent.getProperty("DeviceID");
            String fruId = (String)aProp.getValue().getValue();
            if (!fruId.startsWith(trayNum) || fruInUse.contains(fruId) || fruId.indexOf("d01") != -1) continue;
            aProp = anExtent.getProperty("OtherIdentifyingInfo");
            Vector propVec = (Vector)aProp.getValue().getValue();
            String extRole = (String)propVec.get(3);
            String extState = (String)propVec.get(2);
            if (!anyHotSpare) {
                if (!changePool) {
                    if (!fruId.equals(trayNum + "d" + "14") || !extState.equalsIgnoreCase("enabled") || !extRole.equalsIgnoreCase("unassigned") && !extRole.equalsIgnoreCase("standbyDisk")) continue;
                    return anExtent;
                }
                WBEMDebug.trace1((String)(CLASSNAME + "." + "getHotSpareInstance" + "The requested operation for changing the spare " + "is not supported for this firmware level."));
                throw new CIMException("CIM_ERR_NOT_SUPPORTED");
            }
            if (!extState.equalsIgnoreCase("enabled") || !extRole.equalsIgnoreCase("unassigned") || !supportsHotSpare || this.isSpareInList(anExtent.getObjectPath(), poolJobs)) continue;
            evalExtent.add(anExtent);
        }
        if (evalExtent.isEmpty()) {
            WBEMDebug.trace1((String)(CLASSNAME + "." + "getHotSpareInstance" + "The requested StoragePool assignment cannot be performed because " + "the lack of available drives as a dedicated spare."));
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
        String bigFru = null;
        for (int i = evalExtent.size() - 1; i >= 0; --i) {
            CIMInstance extent = (CIMInstance)evalExtent.get(i);
            BigInteger cap = ((UnsignedInt64)extent.getProperty("NumberOfBlocks").getValue().getValue()).bigIntValue();
            String fruId = (String)extent.getProperty("DeviceID").getValue().getValue();
            if (cap.compareTo(smallest) == 0) {
                return extent;
            }
            if (cap.compareTo(smallest) <= 0 || bigFru != null) continue;
            bigFru = fruId;
            retVal = extent;
        }
        if (retVal != null) {
            return retVal;
        }
        throw new CIMException("CIM_ERR_INVALID_PARAMETER");
    }

    private int getRaidLevel(int packageRedun, boolean noSinglePoint, int dataRedun) throws CIMException {
        String METHOD = "getRaidLevel ";
        int level = -1;
        WBEMDebug.trace3((String)(CLASSNAME + "." + METHOD + " entered"));
        if (!noSinglePoint && dataRedun == 1 && packageRedun == 0) {
            level = 0;
        } else if (noSinglePoint && dataRedun == 2) {
            if (packageRedun == 1 || packageRedun == 2) {
                level = 1;
            }
        } else if (noSinglePoint && dataRedun == 1 && (packageRedun == 1 || packageRedun == 2)) {
            level = 5;
        }
        if (level == -1) {
            WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " Invalid RAID level given in as parameters: " + " packageRedundancy = " + packageRedun + " noSinglePointOfFailure = " + noSinglePoint + " dataRedundancyMin = " + dataRedun));
            throw new CIMException("CIM_ERR_INVALID_PARAMETERinvalid RAID level");
        }
        return level;
    }

    private String getLowSeqValue(Vector valueVec) {
        int tempVal;
        if (valueVec.isEmpty()) {
            return "0";
        }
        int maxVal = Integer.parseInt((String)Collections.max(valueVec));
        WBEMDebug.trace3((String)(CLASSNAME + "." + "getLowSeqValue" + " Have maxVal: " + maxVal + ", minVal: " + tempVal));
        if (tempVal <= 0) {
            for (tempVal = Integer.parseInt((String)Collections.min(valueVec)); tempVal < maxVal; ++tempVal) {
                if (valueVec.contains(Integer.toString(tempVal + 1))) {
                    continue;
                }
                WBEMDebug.trace3((String)(CLASSNAME + "." + "getLowSeqValue" + " will inside return: " + (tempVal + 1)));
                return Integer.toString(tempVal + 1);
            }
            WBEMDebug.trace3((String)(CLASSNAME + "." + "getLowSeqValue" + " will return: " + (maxVal + 1)));
            return Integer.toString(maxVal + 1);
        }
        return "0";
    }

    private boolean isContiguous(Vector values, String cSize) {
        int i;
        int size = Integer.parseInt(cSize);
        int maxcontinuity = 0;
        int continuity = 0;
        int[] vals = new int[values.size()];
        for (i = 0; i < vals.length; ++i) {
            vals[i] = Integer.parseInt((String)values.get(i));
        }
        for (i = 0; i < vals.length - 1; ++i) {
            if (vals[i + 1] == vals[i] + 1) {
                ++continuity;
                continue;
            }
            maxcontinuity = Math.max(continuity, maxcontinuity);
            continuity = 0;
        }
        return maxcontinuity >= size;
    }

    private int checkForNullParams(int[] paramIndices, InvokeRequest request) throws Exception {
        for (int i = 0; i < paramIndices.length; ++i) {
            if (request.getInParamValue(paramIndices[i]) == null) {
                return i;
            }
            WBEMDebug.trace3((String)("Parameter " + i + " passed null value checking"));
            continue;
        }
        return -1;
    }

    private String subtractOne(String val) {
        String result = val;
        try {
            val = Integer.toString(Integer.parseInt(val) - 1);
        }
        catch (NumberFormatException nfe) {
            WBEMDebug.trace3((String)("subtractOne received non-number string: " + val));
        }
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void createStorADELock(String sysId, int code) {
        String[] lockFileDesc = new String[]{"Creating new StorageVolume", "Deleting existing StorageVolume", "Creating new StoragePool", "Deleting existing StoragePool", "Mounting a StoragePool", "Unmounting a StoragePool"};
        String METHOD = "createStorADELock";
        String MGMT_SOFT = "management_sw";
        File f = null;
        BufferedWriter w = null;
        f = new File("/tmp/" + sysId);
        w = new BufferedWriter(new FileWriter(f));
        w.write(MGMT_SOFT);
        w.newLine();
        w.write(code + ": " + lockFileDesc[code]);
        w.flush();
        Object var9_7 = null;
        if (w == null) return;
        try {
            w.close();
            return;
        }
        catch (IOException ioe) {
            WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD), (Throwable)ioe);
        }
        return;
        {
            catch (Exception ex) {
                WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD), (Throwable)ex);
                Object var9_8 = null;
                if (w == null) return;
                try {
                    w.close();
                    return;
                }
                catch (IOException ioe) {
                    WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD), (Throwable)ioe);
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (w == null) throw throwable;
            try {
                w.close();
                throw throwable;
            }
            catch (IOException ioe) {
                WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD), (Throwable)ioe);
            }
            throw throwable;
        }
    }

    public static void removeStorADELock(String sysId) {
        String METHOD = "removeStorADELock";
        File f = null;
        try {
            f = new File("/tmp/" + sysId);
            f.delete();
        }
        catch (Exception ex) {
            WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD), (Throwable)ex);
        }
    }

    private CIMInstance[] getCreatePoolJobs() throws CIMException {
        String METHOD = "getCreatePoolJobs";
        CIMObjectPath poolCreateJobPath = new CIMObjectPath("SunStorEdge_6120CreateStoragePoolJob", "\\root\\se6x20");
        return RequestBroker.getInstance().enumerateInstances(this.getSystem(), poolCreateJobPath, true, false, false, null, null);
    }

    private boolean isSpareInList(CIMObjectPath spare, CIMInstance[] jobList) throws CIMException {
        boolean retVal = false;
        String METHOD = "isSpareInList";
        boolean getOut = false;
        if (jobList != null) {
            for (int i = 0; i < jobList.length; ++i) {
                String objectPathString;
                getOut = false;
                CIMInstance aInst = jobList[i];
                CIMProperty statusProp = aInst.getProperty("OperationalStatus");
                if (statusProp.getValue() == null || statusProp.getValue().getValue() == null) continue;
                CIMValue statusVal = statusProp.getValue();
                Vector stausVector = (Vector)statusVal.getValue();
                for (int j = 0; j < stausVector.size(); ++j) {
                    int stat = ((UnsignedInt16)stausVector.get(j)).intValue();
                    if (stat != 17) continue;
                    getOut = true;
                    break;
                }
                if (getOut) continue;
                CIMProperty hsProp = aInst.getProperty("HotSpareExtents");
                if (hsProp.getValue() == null || hsProp.getValue().getValue() == null) {
                    WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + ": Failed to discover " + "HotSpareExtents" + " from instance of: " + "SunStorEdge_6120CreateStoragePoolJob" + " in: " + aInst));
                    return false;
                }
                CIMValue hsValue = hsProp.getValue();
                Vector hsVector = (Vector)hsValue.getValue();
                if (null == hsVector || hsVector.size() <= 0 || !(objectPathString = (String)hsVector.elementAt(0)).equals(spare.toString())) continue;
                retVal = true;
            }
        }
        return retVal;
    }

    static {
        classMap.add("SunStorEdge_6120StorageConfigurationService");
        _CONF_SERVICE_FAILURE = new CIMValue((Object)new UnsignedInt32(4L), new CIMDataType(4));
        _CONF_SERVICE_NOT_SUPPORTED = new CIMValue((Object)new UnsignedInt32(1L), new CIMDataType(4));
        _CONF_SERVICE_INVALID_PARAMETER = new CIMValue((Object)new UnsignedInt32(5L), new CIMDataType(4));
        _CONF_SERVICE_COMPLETE_SUCCESSFUL = new CIMValue((Object)new UnsignedInt32(0L), new CIMDataType(4));
        _CONF_SERVICE_JOB_STARTED = new CIMValue((Object)new UnsignedInt32(4096L), new CIMDataType(4));
        CLASSNAME = "ModifyConfigService";
        DEVIDPATTERN = Pattern.compile("DeviceID=\\W+u(\\d+)d(\\d+)");
    }
}

