/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.se6120.internal;

import com.sun.netstorage.array.mgmt.se6120.internal.ArrayException;
import com.sun.netstorage.array.mgmt.se6120.internal.ExpectSession;
import com.sun.netstorage.array.mgmt.se6120.internal.InteractiveSession;
import com.sun.netstorage.array.mgmt.se6120.internal.InteractiveSessionException;
import com.sun.netstorage.array.mgmt.se6120.internal.PatchProProperties;
import com.sun.netstorage.array.mgmt.util.WBEMDebug;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Vector;

public abstract class InteractiveSessionPrtl
implements InteractiveSession {
    private static String CLASSNAME = "InteractiveSessionPrtl";
    protected static final String CR = "\r";
    protected static final String NL = "\n";
    private BufferedReader pStdOut = null;
    private BufferedReader pStdErr = null;
    private ByteArrayOutputStream byteArray = null;
    private ByteArrayOutputStream sessionByteArray = null;
    private Process process = null;
    private OutputStreamWriter writer = null;
    private Vector expectSessionList = new Vector();
    private PatchProProperties properties = PatchProProperties.getInstance();
    private boolean terminate = false;
    private boolean debug = this.properties.getProperty("patchpro.debug", "false").equals("true");

    public void send(String stdin_data) throws InteractiveSessionException {
        String METHOD = "send";
        try {
            this.writer.write(stdin_data);
            this.writer.flush();
        }
        catch (IOException ioe) {
            WBEMDebug.trace1((String)(CLASSNAME + "." + "send"), (Throwable)ioe);
            throw new InteractiveSessionException(ioe.getMessage());
        }
    }

    public void send(String stdin_data, int millis) throws InteractiveSessionException {
        String METHOD = "send";
        try {
            this.resetBuffer();
            this.writer.write(stdin_data);
            this.writer.flush();
            int HALF_SECOND = 500;
            int FIVE_MIN = 600;
            int count = 0;
            while (this.byteArray.size() == 0) {
                try {
                    Thread.sleep(HALF_SECOND);
                    if (count++ <= FIVE_MIN) continue;
                    throw new InteractiveSessionException("Communications with device timed out");
                }
                catch (InterruptedException iex) {
                    WBEMDebug.trace1((String)"TelnetSession interrupted");
                }
            }
            this.waitUntilQuiesed(millis);
        }
        catch (IOException ioe) {
            WBEMDebug.trace1((String)(CLASSNAME + "." + "send"), (Throwable)ioe);
            throw new InteractiveSessionException(ioe.getMessage());
        }
    }

    public boolean waitfor(String pattern) {
        return this.waitfor(pattern, 5000);
    }

    public boolean waitfor(String pattern, int millis) {
        boolean found = false;
        long now = System.currentTimeMillis();
        long exp = System.currentTimeMillis() + (long)millis;
        while (now <= exp) {
            String resultsSoFar = this.byteArray.toString();
            if (resultsSoFar.indexOf(pattern) != -1) {
                found = true;
                break;
            }
            String fixedResults = resultsSoFar.replaceAll("[\\x00\\x0a\\x0d]", "");
            if (fixedResults.indexOf(pattern) != -1) {
                found = true;
                break;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            now = System.currentTimeMillis();
        }
        return found;
    }

    public void waitfor(int millis) {
        String METHOD = "waitfor";
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException ex) {
            WBEMDebug.trace1((String)(CLASSNAME + "." + "waitfor"), (Throwable)ex);
        }
    }

    public boolean expectedResponse(String stdin_data, String pattern) {
        return this.expectedResponse(stdin_data, pattern, 5000);
    }

    public boolean expectedResponse(String stdin_data, String pattern, int millis) {
        try {
            this.resetBuffer();
            this.send(stdin_data);
            while (this.byteArray.size() == 0) {
                try {
                    Thread.sleep(2L);
                }
                catch (InterruptedException iex) {
                    WBEMDebug.trace1((String)"TelnetSession interrupted");
                }
            }
            return this.waitfor(pattern, millis);
        }
        catch (InteractiveSessionException ise) {
            return false;
        }
    }

    public void expect(String pattern, String response) {
        for (int i = 0; i < this.expectSessionList.size(); ++i) {
            ExpectSession eS = (ExpectSession)this.expectSessionList.elementAt(i);
            if (!eS.getPattern().equals(pattern)) continue;
            eS.setResponse(response);
            return;
        }
        this.expectSessionList.addElement(new ExpectSession(pattern, response));
    }

    public void expectRemove(String pattern) {
        ExpectSession eS;
        int i;
        String METHOD = "expectRemove";
        for (i = 0; i < this.expectSessionList.size() && !(eS = (ExpectSession)this.expectSessionList.elementAt(i)).getPattern().equals(pattern); ++i) {
        }
        if (i < this.expectSessionList.size()) {
            this.expectSessionList.removeElementAt(i);
        } else {
            WBEMDebug.trace2((String)(CLASSNAME + "." + "expectRemove" + ":" + " Session pattern not registered" + pattern));
        }
    }

    public String getSessionMessages() throws ArrayException {
        if (this.sessionByteArray.size() == 0) {
            throw new ArrayException("Could not communicate with device");
        }
        return this.byteArray.toString();
    }

    public String getAllSessionMessages() throws ArrayException {
        if (this.sessionByteArray.size() == 0) {
            throw new ArrayException("Could not communicate with device");
        }
        return this.sessionByteArray.toString();
    }

    protected BufferedReader getStdInputReader() {
        return this.pStdOut;
    }

    public boolean getTerminateStatus() {
        return this.terminate;
    }

    public void setTerminateStatus() {
        this.terminate = true;
    }

    protected void setStdInputReader(BufferedReader stdout) {
        this.pStdOut = stdout;
    }

    protected void closeStdInputReader() {
        try {
            if (this.pStdOut != null) {
                this.pStdOut.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected BufferedReader getStdErrorReader() {
        return this.pStdErr;
    }

    protected void setStdErrorReader(BufferedReader stderr) {
        this.pStdErr = stderr;
    }

    protected void closeStdErrorReader() {
        try {
            if (this.pStdErr != null) {
                this.pStdErr.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected ByteArrayOutputStream getArrayOutputStream() {
        return this.byteArray;
    }

    protected void setArrayOutputStream(ByteArrayOutputStream stream) {
        this.byteArray = stream;
    }

    protected ByteArrayOutputStream getSessionArrayOutputStream() {
        return this.sessionByteArray;
    }

    protected void setSessionArrayOutputStream(ByteArrayOutputStream stream) {
        this.sessionByteArray = stream;
    }

    protected void setOutPutStreamWriter(OutputStreamWriter w) {
        this.writer = w;
    }

    protected void closeOutPutStreamWriter() {
        try {
            if (this.writer != null) {
                this.writer.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected Vector getExpectSessionList() {
        return this.expectSessionList;
    }

    private void resetBuffer() {
        this.byteArray.reset();
    }

    private void waitUntilQuiesed(int millis) {
        int count = 0;
        int oldSize = 0;
        do {
            oldSize = this.byteArray.size();
            this.waitfor(millis / 10);
            if (oldSize != this.byteArray.size()) continue;
            ++count;
        } while (count != 10);
    }
}

