/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.se6120.internal;

import com.sun.netstorage.array.mgmt.logger.LogAPI;
import com.sun.netstorage.array.mgmt.se6120.internal.ArrayException;
import com.sun.netstorage.array.mgmt.se6120.internal.ArrayObject;
import com.sun.netstorage.array.mgmt.se6120.internal.InteractiveSessionException;
import com.sun.netstorage.array.mgmt.se6120.internal.StorEdgeIOException;
import com.sun.netstorage.array.mgmt.se6120.internal.SunStorEdge_6120ArrayProvider;
import com.sun.netstorage.array.mgmt.se6120.internal.TelnetSession;
import com.sun.netstorage.array.mgmt.util.WBEMDebug;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import sun.misc.BASE64Encoder;

public class DevComm {
    private HashMap arrayMap = new HashMap();
    private static DevComm singleton = null;
    private static long ARRAY_RESPONSE_TIMEOUT_IN_MILLI = 300000L;
    private static int DEFAULT_CMD_TIMEOUT_IN_SEC = 180;
    private static long DEFAULT_CONNECT_TIMEOUT_IN_MILLI = 60000L;
    private static long RESET_TIMEOUT_IN_MILLI = 120000L;
    private static int INVALID_PASSWORD_SLEEP = 11000;
    private static final String ARRAY_RESPONSE_TIMEOUT_IN_MILLI_KEY = "DevComm.arrayResponseTimeoutInMilli";
    private static final String DEFAULT_CMD_TIMEOUT_IN_SEC_KEY = "DevComm.defaultCMDTimeoutInSec";
    private static final String DEFAULT_CONNECT_TIMEOUT_IN_MILLI_KEY = "DevComm.defaultConnectTimeoutInMilli";
    private static final String RESET_TIMEOUT_IN_MILLI_KEY = "DevComm.resetTimeoutInMilli";
    private static final String INVALID_PASSWORD_SLEEP_KEY = "DevComm.invalidPasswordSleepInMilli";
    private static final String sccs_id = "@(#)DevComm.java.m4 1.41    03/02/13 SMI";

    private DevComm() {
        try {
            FileInputStream propStream = new FileInputStream(SunStorEdge_6120ArrayProvider.getPropertyFilePath());
            Properties props = new Properties();
            props.load(propStream);
            ARRAY_RESPONSE_TIMEOUT_IN_MILLI = Long.parseLong(props.getProperty(ARRAY_RESPONSE_TIMEOUT_IN_MILLI_KEY, new Long(ARRAY_RESPONSE_TIMEOUT_IN_MILLI).toString()));
            DEFAULT_CMD_TIMEOUT_IN_SEC = Integer.parseInt(props.getProperty(DEFAULT_CMD_TIMEOUT_IN_SEC_KEY, new Integer(DEFAULT_CMD_TIMEOUT_IN_SEC).toString()));
            DEFAULT_CONNECT_TIMEOUT_IN_MILLI = Long.parseLong(props.getProperty(DEFAULT_CONNECT_TIMEOUT_IN_MILLI_KEY, new Long(DEFAULT_CONNECT_TIMEOUT_IN_MILLI).toString()));
            RESET_TIMEOUT_IN_MILLI = Long.parseLong(props.getProperty(RESET_TIMEOUT_IN_MILLI_KEY, new Long(RESET_TIMEOUT_IN_MILLI).toString()));
            INVALID_PASSWORD_SLEEP = Integer.parseInt(props.getProperty(INVALID_PASSWORD_SLEEP_KEY, new Integer(INVALID_PASSWORD_SLEEP).toString()));
        }
        catch (Exception e) {
            WBEMDebug.trace1((String)"DevComm Unable to load properties!", (Throwable)e);
        }
    }

    public static DevComm getInstance() {
        if (singleton == null) {
            singleton = new DevComm();
        }
        return singleton;
    }

    public void init(ArrayList inventory) {
        WBEMDebug.trace2((String)"DevComm:Init - Enter");
        for (int i = 0; i < inventory.size(); ++i) {
            ArrayObject arrayObject = (ArrayObject)inventory.get(i);
            WBEMDebug.trace2((String)"DevComm:Init - Adding: arrayObject.getHost()");
            this.arrayMap.put(new String(arrayObject.getHost()), new ArrayAccess(arrayObject));
        }
        WBEMDebug.trace2((String)"DevComm:Init - Exit");
    }

    boolean isValidArray(ArrayObject array) {
        String method = "isValidArray";
        if (this.arrayMap.get(array.getHost()) == null) {
            this.arrayMap.put(new String(array.getHost()), new ArrayAccess(array));
        }
        return true;
    }

    public InputStream get(ArrayObject array, String fileName) throws ArrayException, StorEdgeIOException {
        return this.get(array, fileName, false, true);
    }

    public InputStream get(ArrayObject array, String fileName, boolean useCRAM, boolean retryflag) throws ArrayException, StorEdgeIOException {
        String method = "get";
        if (!this.isValidArray(array)) {
            WBEMDebug.trace1((String)(method + "Invalid array: " + array.getHost() + " in method: " + method));
            throw new ArrayException("Invalid array = " + array.getHost());
        }
        ArrayAccess tmpAccess = (ArrayAccess)this.arrayMap.get(array.getHost());
        return tmpAccess.get(fileName, useCRAM, retryflag);
    }

    public void post(ArrayObject array, Vector urlRequestData, String method) throws ArrayException, StorEdgeIOException {
        String thisMethod = "post";
        if (!this.isValidArray(array)) {
            WBEMDebug.trace1((String)("Invalid array: " + array.getHost() + " in method: " + thisMethod));
            throw new ArrayException("Invalid array = " + array.getHost());
        }
        ArrayAccess tmpAccess = (ArrayAccess)this.arrayMap.get(array.getHost());
        tmpAccess.post(urlRequestData, method);
    }

    public void telnetMultiPost(ArrayObject array, String[] cmd, String[] t4Responses, String[] errorResponses, int[] maxTimeouts) throws ArrayException, StorEdgeIOException {
        this.telnetMultiPost(array, cmd, t4Responses, errorResponses, null, maxTimeouts);
    }

    public void telnetMultiPost(ArrayObject array, String[] cmd, String[] t4Responses, String[] errorResponses, String[] prompts, int[] maxTimeouts) throws ArrayException, StorEdgeIOException {
        String thisMethod = "telnetMultPost";
        if (!this.isValidArray(array)) {
            WBEMDebug.trace1((String)("Invalid array: " + array.getHost() + " in method: " + thisMethod));
            throw new ArrayException("Invalid array = " + array.getHost());
        }
        ArrayAccess tmpAccess = (ArrayAccess)this.arrayMap.get(array.getHost());
        tmpAccess.telnetMultiPost(cmd, t4Responses, errorResponses, prompts, maxTimeouts);
    }

    public void telnetPost(ArrayObject array, String cmd) throws ArrayException, StorEdgeIOException {
        String thisMethod = "telnetPost";
        if (!this.isValidArray(array)) {
            WBEMDebug.trace1((String)("Invalid array: " + array.getHost() + " in method: " + thisMethod));
            throw new ArrayException("Invalid array = " + array.getHost());
        }
        ArrayAccess tmpAccess = (ArrayAccess)this.arrayMap.get(array.getHost());
        tmpAccess.telnetPost(cmd);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void post(ArrayObject array, String url) throws ArrayException {
        String method = "post";
        if (!this.isValidArray(array)) {
            WBEMDebug.trace1((String)("Invalid array: " + array.getHost() + " in method: " + method));
            throw new ArrayException("Invalid array = " + array.getHost());
        }
        ArrayAccess tmpAccess = (ArrayAccess)this.arrayMap.get(array.getHost());
        InputStream results = null;
        try {
            try {
                String line;
                results = tmpAccess.get(url, true);
                BufferedReader buf = new BufferedReader(new InputStreamReader(results, "UTF-8"));
                StringBuffer data = new StringBuffer(200);
                while ((line = buf.readLine()) != null) {
                    data.append(line.trim() + "\n");
                }
                WBEMDebug.trace3((String)data.toString());
            }
            catch (IOException ex) {
                throw new ArrayException(ex);
            }
            Object var10_10 = null;
            if (results == null) return;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            if (results == null) throw throwable;
            try {
                results.close();
                throw throwable;
            }
            catch (IOException ignore) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException ignore) {}
        results.close();
        return;
    }

    public InputStream readFile(ArrayObject array, String file) throws ArrayException, StorEdgeIOException {
        String method = "readFile";
        if (!this.isValidArray(array)) {
            WBEMDebug.trace1((String)("Invalid array: " + array.getHost() + " in method: " + method));
            throw new ArrayException("Invalid array = " + array.getHost());
        }
        ArrayAccess tmpAccess = (ArrayAccess)this.arrayMap.get(array.getHost());
        return tmpAccess.get(file, false);
    }

    public void setSysProp(ArrayObject array, String key, String value) throws ArrayException {
    }

    public String getSysProp(ArrayObject array, String key) throws ArrayException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties getSysProps(ArrayObject array, String[] propNames) throws ArrayException, StorEdgeIOException {
        Properties properties;
        block14: {
            String method = "getSysProps";
            if (!this.isValidArray(array)) {
                WBEMDebug.trace1((String)("Invalid array: " + array.getHost() + " in method: " + method));
                throw new ArrayException("Invalid array = " + array.getHost());
            }
            InputStream results = null;
            try {
                ArrayAccess tmpAccess = (ArrayAccess)this.arrayMap.get(array.getHost());
                StringBuffer request = new StringBuffer("update?sysProp");
                results = tmpAccess.get(request.toString(), true);
                Properties inProps = new Properties();
                Properties outProps = new Properties();
                try {
                    BufferedReader in = new BufferedReader(new InputStreamReader(results));
                    String tmp = in.readLine();
                    while (tmp != null) {
                        StringTokenizer tokenizer = new StringTokenizer(tmp, "=");
                        try {
                            String property = tokenizer.nextToken();
                            String value = tokenizer.nextToken();
                            inProps.setProperty(property, value);
                        }
                        catch (NoSuchElementException ex) {
                            WBEMDebug.trace1((String)(method + "NoSuchElementException: " + tmp));
                        }
                        tmp = in.readLine();
                    }
                    if (propNames == null || propNames != null && propNames.length == 0) {
                        outProps = inProps;
                    } else {
                        for (int i = 0; i < propNames.length; ++i) {
                            String propValue = inProps.getProperty(propNames[i]);
                            if (propValue == null) continue;
                            outProps.setProperty(propNames[i], propValue);
                        }
                    }
                    in.close();
                }
                catch (IOException ex) {
                    throw new ArrayException(ex);
                }
                properties = outProps;
                Object var15_17 = null;
                if (results == null) break block14;
            }
            catch (Throwable throwable) {
                block15: {
                    Object var15_18 = null;
                    if (results == null) break block15;
                    try {
                        results.close();
                    }
                    catch (IOException ignore) {}
                }
                throw throwable;
            }
            try {
                results.close();
            }
            catch (IOException ignore) {
                // empty catch block
            }
        }
        return properties;
    }

    public void setSysProps(ArrayObject array, Properties props) throws ArrayException, StorEdgeIOException {
        String method = "setSysProps";
        if (!this.isValidArray(array)) {
            WBEMDebug.trace1((String)("Invalid array: " + array.getHost() + " in method: " + method));
            throw new ArrayException("Invalid array = " + array.getHost());
        }
        try {
            ArrayAccess tmpAccess = (ArrayAccess)this.arrayMap.get(array.getHost());
            Vector<String> sets = new Vector<String>();
            Enumeration<?> enumeration = props.propertyNames();
            while (enumeration.hasMoreElements()) {
                String property = (String)enumeration.nextElement();
                String request = "sysProp=" + property + "%3D" + URLEncoder.encode(props.getProperty(property), "UTF-8");
                sets.add(request);
            }
            tmpAccess.post(sets, "sysApplySettings");
        }
        catch (UnsupportedEncodingException ex) {
            throw new ArrayException(ex);
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean validate(ArrayObject ao, String fileName) throws StorEdgeIOException {
        block16: {
            retVal = true;
            devComm = DevComm.getInstance();
            inStream = null;
            try {
                try {
                    inStream = devComm.get(ao, fileName, true, false);
                    try {
                        inStream.close();
                    }
                    catch (IOException ex) {
                    }
                    var8_9 = null;
                    if (inStream == null) break block16;
                }
                catch (StorEdgeIOException ex) {
                    switch (ex.getType()) {
                        case 3: {
                            retVal = false;
                            break;
                        }
                        case 1: {
                            retVal = true;
                            break;
                        }
                        default: {
                            throw ex;
                        }
                    }
                    var8_10 = null;
                    if (inStream != null) {
                        try {
                            inStream.close();
                        }
                        catch (IOException ignore) {}
                    }
                    break block16;
                }
                catch (ArrayException ex) {
                    throw new StorEdgeIOException(0);
                }
            }
            catch (Throwable var7_15) {
                var8_11 = null;
                if (inStream == null) throw var7_15;
                ** try [egrp 3[TRYBLOCK] [6 : 117->125)] { 
lbl40:
                // 1 sources

                inStream.close();
                throw var7_15;
lbl42:
                // 1 sources

                catch (IOException ignore) {
                    // empty catch block
                }
                throw var7_15;
            }
            try {}
            catch (IOException ignore) {}
            inStream.close();
        }
        WBEMDebug.trace2((String)("DevComm.validate returning:" + retVal));
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        block47: {
            if (args.length < 5) {
                System.out.println("usage   : <--read webfile > <--post urlpathonly> 6120name username password <useCRAM>");
                System.out.println("example : --get system.htm auggie root pass");
                System.out.println("example : --post \"sysCacheMode=auto\" auggie root pass");
                return;
            }
            try {
                ArrayObject array;
                DevComm devComm = null;
                boolean useCRAM = true;
                if (args.length == 6) {
                    ArrayObject array2;
                    String host = args[2];
                    String user = args[3];
                    String pass = args[4];
                    try {
                        String CRAM = args[5];
                        if (CRAM.equalsIgnoreCase("false")) {
                            useCRAM = false;
                        }
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    if ("--get".equals(args[0]) && args.length >= 5) {
                        String line;
                        System.out.println("\n\nReading " + args[1] + ":\n");
                        devComm = DevComm.getInstance();
                        array2 = ArrayObject.getInstance(host, 80, user, pass);
                        ArrayList<ArrayObject> arrayList = new ArrayList<ArrayObject>();
                        arrayList.add(array2);
                        devComm.init(arrayList);
                        BufferedReader buf = new BufferedReader(new InputStreamReader(devComm.get(array2, args[1], true, true), "UTF-8"));
                        StringBuffer data = new StringBuffer(200);
                        while ((line = buf.readLine()) != null) {
                            data.append(line.trim() + "\n");
                        }
                        WBEMDebug.trace3((String)"***  Data  ***");
                        WBEMDebug.trace3((String)data.toString());
                        WBEMDebug.trace3((String)"**************");
                        System.out.println(data.toString());
                        try {
                            buf.close();
                        }
                        catch (IOException e) {}
                    } else if ("--post".equals(args[0]) && args.length >= 5) {
                        System.out.println("\n\nPosting " + args[1] + ":\n");
                        devComm = DevComm.getInstance();
                        array2 = ArrayObject.getInstance(host, 80, user, pass);
                        ArrayList<ArrayObject> arrayList = new ArrayList<ArrayObject>();
                        arrayList.add(array2);
                        devComm.init(arrayList);
                        Vector<String> updates = new Vector<String>();
                        updates.add(args[1]);
                        devComm.post(array2, updates, "sysApplySettings");
                    }
                    break block47;
                }
                if (args.length != 5) break block47;
                String host = args[1];
                String user = args[2];
                String pass = args[3];
                try {
                    String CRAM = args[4];
                    if (CRAM.equalsIgnoreCase("false")) {
                        useCRAM = false;
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
                if ("--sysprop".equals(args[0]) && args.length >= 5) {
                    System.out.println("\n\nSetting/Getting sysProps\n");
                    devComm = DevComm.getInstance();
                    array = ArrayObject.getInstance(host, 80, user, pass);
                    ArrayList<ArrayObject> arrayList = new ArrayList<ArrayObject>();
                    arrayList.add(array);
                    devComm.init(arrayList);
                    Properties setProps = new Properties();
                    String[] testProps = new String[]{"DevCommTest1", "DevCommTest2", "DevCommTest3"};
                    String[] testVals = new String[]{"val1", "2", "A 20 value with spaces and !."};
                    System.out.println("\n\nSetting:");
                    for (int i = 0; i < testProps.length; ++i) {
                        System.out.println("\tSetting: " + testProps[i] + " = " + testVals[i]);
                        setProps.setProperty(testProps[i], testVals[i]);
                    }
                    devComm.setSysProps(array, setProps);
                    System.out.println("\n\nGetting:");
                    Properties getProps = devComm.getSysProps(array, testProps);
                    Enumeration<?> enumeration = getProps.propertyNames();
                    while (enumeration.hasMoreElements()) {
                        String property = (String)enumeration.nextElement();
                        System.out.println("\tProperty: " + property + " = " + getProps.getProperty(property));
                    }
                    System.out.println("\n\nDeleting:");
                    for (int i = 0; i < testProps.length; ++i) {
                        System.out.println("\tSetting: " + testProps[i] + " = " + "");
                        setProps.setProperty(testProps[i], "");
                    }
                    devComm.setSysProps(array, setProps);
                    System.out.println("\n\nVerifying Delete:");
                    getProps = devComm.getSysProps(array, testProps);
                    enumeration = getProps.propertyNames();
                    boolean deleteSuccess = true;
                    while (enumeration.hasMoreElements()) {
                        deleteSuccess = false;
                        String property = (String)enumeration.nextElement();
                        System.out.println("\tProperty: " + property + " = " + getProps.getProperty(property));
                    }
                    if (!deleteSuccess) {
                        System.out.println("Delete FAILED...");
                    } else {
                        System.out.println("Delete succeeded...");
                    }
                    break block47;
                }
                if ("--telnetpost".equals(args[0]) && args.length >= 5) {
                    devComm = DevComm.getInstance();
                    array = ArrayObject.getInstance(host, 80, user, pass);
                    ArrayList<ArrayObject> arrayList = new ArrayList<ArrayObject>();
                    arrayList.add(array);
                    devComm.init(arrayList);
                    try {
                        devComm.telnetPost(array, "ls");
                        devComm.telnetPost(array, "cd web");
                    }
                    catch (ArrayException ex) {
                        System.out.println("--telnetPost FAILED!" + ex.getMessage());
                    }
                    boolean exceptionCaught = false;
                    try {
                        devComm.telnetPost(array, "vol add v1 data u1d1-8 raid 1\r");
                    }
                    catch (ArrayException ex) {
                        exceptionCaught = true;
                        System.out.println("Caught expected exception: " + ex.getMessage());
                    }
                    finally {
                        if (!exceptionCaught) {
                            System.out.println("--telnetPost VolumeExists FAILED!");
                        }
                    }
                    exceptionCaught = false;
                    try {
                        devComm.telnetPost(array, "abc\r");
                    }
                    catch (ArrayException ex) {
                        exceptionCaught = true;
                        System.out.println("Caught expected exception: " + ex.getMessage());
                    }
                    finally {
                        if (!exceptionCaught) {
                            System.out.println("--telnetPost BadParam FAILED!");
                        }
                    }
                    exceptionCaught = false;
                    try {
                        devComm.telnetPost(array, "cat\r");
                        break block47;
                    }
                    catch (ArrayException ex) {
                        exceptionCaught = true;
                        System.out.println("Caught expected exception: " + ex.getMessage());
                        break block47;
                    }
                    finally {
                        if (!exceptionCaught) {
                            System.out.println("--telnetPost Usage FAILED!");
                        }
                    }
                }
                if (!"--validate".equals(args[0]) || args.length < 5) break block47;
                devComm = DevComm.getInstance();
                array = ArrayObject.getInstance(host, 80, user, pass);
                ArrayList<ArrayObject> arrayList = new ArrayList<ArrayObject>();
                arrayList.add(array);
                devComm.init(arrayList);
                try {
                    if (devComm.validate(array, "cim200602141153.htm")) {
                        System.out.println("Validation SUCCEEDED");
                        break block47;
                    }
                    System.out.println("Validation FAILED - Invalid Password");
                }
                catch (Exception ex) {
                    System.out.println("Validation FAILED: " + ex.getMessage());
                }
            }
            catch (Exception ex) {
                WBEMDebug.trace1((String)("Exception in main" + ex.getMessage()));
                ex.printStackTrace();
            }
        }
    }

    static /* synthetic */ long access$200() {
        return ARRAY_RESPONSE_TIMEOUT_IN_MILLI;
    }

    private class ArrayAccess {
        private static final int ONE_SECOND = 1000;
        private static final int ONE_MINUTE = 60000;
        private static final int TWO_MINUTES = 120000;
        private static final String SYS_SHUTDOWN = "sysShutdown";
        private static final String SYS_RESET = "sysReset";
        private static final String BOOT_W = "boot -w";
        private ArrayObject array;
        private String localHost;

        public ArrayAccess(ArrayObject array) {
            this.array = array;
            try {
                this.localHost = InetAddress.getLocalHost().toString();
            }
            catch (Exception e) {
                this.localHost = "localhost";
            }
        }

        public boolean getCRAMFlag() {
            return this.array.getCRAMFlag();
        }

        public String getHost() {
            return this.array.getHost();
        }

        public int getPort() {
            return this.array.getPort();
        }

        public String getUser() {
            return this.array.getUser();
        }

        public String getPass() {
            return this.array.getPassword();
        }

        public String getName() {
            return this.array.getHost() + ":" + this.array.getPort();
        }

        public synchronized InputStream get(String fileName) throws ArrayException {
            return this.get(fileName);
        }

        public synchronized InputStream get(String file, boolean useCRAMAuthorization) throws ArrayException, StorEdgeIOException {
            return this.get(file, useCRAMAuthorization, true);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public synchronized InputStream get(String file, boolean useCRAMAuthorization, boolean retryflag) throws ArrayException, StorEdgeIOException {
            BufferedInputStream bufferedInputStream;
            boolean error = false;
            InputStream inStream = null;
            try {
                try {
                    BufferedInputStream bufInStream;
                    inStream = this.getStream(file, useCRAMAuthorization, retryflag);
                    bufferedInputStream = bufInStream = new BufferedInputStream(inStream);
                    Object var9_11 = null;
                }
                catch (ArrayException e) {
                    error = true;
                    throw e;
                }
                catch (StorEdgeIOException e) {
                    error = true;
                    throw e;
                }
                catch (Exception e) {
                    error = true;
                    throw new ArrayException(e);
                }
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                try {
                    if (!error) throw throwable;
                    if (inStream == null) throw throwable;
                    inStream.close();
                    throw throwable;
                }
                catch (Exception ignore) {
                    throw throwable;
                }
            }
            try {}
            catch (Exception ignore) {
                // empty catch block
                return bufferedInputStream;
            }
            if (!error) return bufferedInputStream;
            if (inStream == null) return bufferedInputStream;
            inStream.close();
            return bufferedInputStream;
        }

        private InputStream getStream(String file, boolean useCRAMAuthorization) throws ArrayException, StorEdgeIOException {
            return this.getStream(file, useCRAMAuthorization, true);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private InputStream getStream(String file, boolean useCRAMAuthorization, boolean retryflag) throws ArrayException, StorEdgeIOException {
            ByteArrayInputStream byteArrayInputStream;
            String METHOD = "getStream";
            WBEMDebug.trace2((String)("getStream - Enter: " + this.array.getHost() + ":" + this.array.getPort()));
            HttpURLConnection connection = null;
            try {
                try {
                    if (!file.startsWith("/")) {
                        file = "/" + file;
                    }
                    URL url = new URL("http", this.array.getHost(), this.array.getPort(), file);
                    WBEMDebug.trace2((String)("DevComm.getStream URL : " + url));
                    int response = 0;
                    ConnectThread connectThread = null;
                    for (int attempt = 0; attempt < 4; ++attempt) {
                        if (!retryflag) {
                            attempt = 3;
                        }
                        connection = (HttpURLConnection)url.openConnection();
                        if (useCRAMAuthorization) {
                            WBEMDebug.trace2((String)"Using CRAM - Write/Post");
                            connection.setRequestProperty("Authorization", "CRAM");
                            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                        } else {
                            WBEMDebug.trace2((String)"NOT Using CRAM - Discovery/Get");
                            String userPasswd = "guest";
                            String encoding = new BASE64Encoder().encode(userPasswd.getBytes());
                            connection.setRequestProperty("Authorization", "Basic " + encoding);
                        }
                        connection.setAllowUserInteraction(false);
                        connection.setRequestMethod("GET");
                        connectThread = new ConnectThread(connection);
                        connectThread.connect();
                        response = connectThread.getResponseCode();
                        if (response == 401 && useCRAMAuthorization) {
                            String cramChallenge = connection.getHeaderField("CRAM-Challenge");
                            if (response == 401 && cramChallenge != null) {
                                byte[] cramResponse = null;
                                try {
                                    cramResponse = this.getCRAMResponse(this.array.getUser(), this.array.getPassword(), cramChallenge);
                                }
                                catch (NoSuchAlgorithmException na) {
                                    WBEMDebug.trace1((String)("NoSuchAlgorithm: " + this.array.getHost() + this.array.getPort()));
                                    throw new ArrayException(na);
                                }
                                String encoding = new BASE64Encoder().encode(cramResponse);
                                connection = (HttpURLConnection)url.openConnection();
                                connection.setRequestProperty("Authorization", "CRAM");
                                connection.setRequestProperty("credential", encoding);
                                connection.setAllowUserInteraction(false);
                                connection.setUseCaches(false);
                                connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                                connection.setRequestMethod("GET");
                                connection.setDoOutput(true);
                                connectThread = new ConnectThread(connection);
                                connectThread.connect();
                                response = connectThread.getResponseCode();
                            }
                        }
                        WBEMDebug.trace2((String)("HTTPResponse code: " + response));
                        if (response == 401 && useCRAMAuthorization) {
                            Thread.sleep(INVALID_PASSWORD_SLEEP);
                        }
                        if (response == 200 || response == 401 || response == 404 || response == 503) break;
                        WBEMDebug.trace2((String)("DevComm HTTP failure attempt " + (attempt + 1)));
                        WBEMDebug.trace2((String)"Unknown HTTPResponse code:", (Throwable)new Exception());
                        connection.disconnect();
                        String[] logargs = new String[]{String.valueOf(response), String.valueOf(attempt + 1), "4", "30"};
                        LogAPI.staticLog((String)"DEVCOMM_INVALID_HTTP_CODE", (String[])logargs, (String[])new String[0]);
                        Thread.sleep(30000L);
                    }
                    int errorCode = 0;
                    switch (response) {
                        case 200: {
                            break;
                        }
                        case 401: {
                            errorCode = 3;
                            break;
                        }
                        case 404: {
                            errorCode = 1;
                            break;
                        }
                        case 503: {
                            errorCode = 2;
                            break;
                        }
                        default: {
                            errorCode = 0;
                        }
                    }
                    if (response != 200) {
                        connection.disconnect();
                        throw new StorEdgeIOException(errorCode, connection.getErrorStream());
                    }
                    ReadThread readThread = new ReadThread(connectThread.getInputStream(), 300000L);
                    readThread.read();
                    byteArrayInputStream = new ByteArrayInputStream(readThread.getByteArray());
                    Object var14_17 = null;
                }
                catch (StorEdgeIOException ex) {
                    throw ex;
                }
                catch (IOException ex) {
                    throw new StorEdgeIOException(0);
                }
                catch (Exception e) {
                    WBEMDebug.trace1((String)("Exception in get: " + e.getMessage()));
                    throw new ArrayException(e);
                }
            }
            catch (Throwable throwable) {
                Object var14_18 = null;
                WBEMDebug.trace2((String)("getStream - Exit " + this.array.getHost() + ":" + this.array.getPort()));
                throw throwable;
            }
            WBEMDebug.trace2((String)("getStream - Exit " + this.array.getHost() + ":" + this.array.getPort()));
            return byteArrayInputStream;
        }

        private byte[] getCRAMResponse(String username, String password, String cramChallenge) throws NoSuchAlgorithmException {
            int i;
            int offset;
            String credential = username + ":" + cramChallenge;
            MessageDigest classMD = MessageDigest.getInstance("MD5");
            if (password != null) {
                byte[] passwdbuff = password.getBytes();
                classMD.update(passwdbuff, 0, passwdbuff.length);
            }
            byte[] passwdDigest = classMD.digest();
            byte[] chbuff = cramChallenge.getBytes();
            byte[] cbuff = new byte[passwdDigest.length + chbuff.length + 1];
            for (int i2 = 0; i2 < passwdDigest.length; ++i2) {
                cbuff[i2] = passwdDigest[i2];
            }
            cbuff[passwdDigest.length] = 38;
            for (int i3 = offset = passwdDigest.length + 1; i3 < offset + chbuff.length; ++i3) {
                cbuff[i3] = chbuff[i3 - offset];
            }
            classMD.update(cbuff, 0, cbuff.length);
            byte[] classdigest = classMD.digest();
            byte[] userbuff = (username + ":").getBytes();
            byte[] credentialbuff = new byte[userbuff.length + classdigest.length];
            for (i = 0; i < userbuff.length; ++i) {
                credentialbuff[i] = userbuff[i];
            }
            for (i = offset = userbuff.length; i < offset + classdigest.length; ++i) {
                credentialbuff[i] = classdigest[i - offset];
            }
            return credentialbuff;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public synchronized void post(Vector urlRequestData, String method) throws ArrayException, StorEdgeIOException {
            StringBuffer postRequest = new StringBuffer();
            postRequest.append("update?");
            if (urlRequestData == null) {
                WBEMDebug.trace1((String)"Invalid urlRequestData");
                throw new ArrayException("Invalid urlRequestData");
            }
            for (int i = 0; i < urlRequestData.size(); ++i) {
                String tokenValuePair = (String)urlRequestData.get(i);
                if (!this.IsValidTokenValuePair(tokenValuePair)) {
                    WBEMDebug.trace2((String)("Invald token-value pair: " + tokenValuePair));
                    throw new ArrayException("Invalid token-value pair: " + tokenValuePair);
                }
                tokenValuePair.trim();
                postRequest.append(tokenValuePair + "&");
            }
            if (method != null && method != "") {
                postRequest.append(method + "=Apply");
            }
            InputStream is = null;
            try {
                is = this.get(postRequest.toString(), true);
                Object var7_7 = null;
                if (is == null) return;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                if (is == null) throw throwable;
                try {
                    is.close();
                    throw throwable;
                }
                catch (IOException ignore) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                is.close();
                return;
            }
            catch (IOException ignore) {}
        }

        /*
         * Loose catch block
         */
        public synchronized void telnetMultiPost(String[] cmd, String[] t4Responses, String[] errorResponses, String[] prompts, int[] maxSecTimeouts) throws ArrayException, StorEdgeIOException {
            long startTime;
            String METHOD;
            block16: {
                METHOD = "telnetMultiPost";
                TelnetSession session = null;
                long st = 0L;
                long et = 0L;
                Object line = null;
                String prompt = null;
                String response = null;
                boolean retvalue = false;
                boolean sendExit = true;
                startTime = System.currentTimeMillis();
                String hostname = this.array.getHost();
                String username = this.array.getUser();
                String password = this.array.getPassword();
                prompt = ":/:<";
                session = new TelnetSession();
                session.connect(hostname, username, password);
                session.waitfor(prompt, 10000);
                response = session.getSessionMessages();
                if (response.indexOf("Login incorrect") != -1) {
                    WBEMDebug.trace2((String)(METHOD + ": Invalid credentials"));
                    throw new StorEdgeIOException(3);
                }
                WBEMDebug.trace2((String)(METHOD + ": Connected"));
                st = System.currentTimeMillis();
                for (int i = 0; i < cmd.length; ++i) {
                    if (cmd[i] != null && cmd[i].indexOf(BOOT_W) != -1) {
                        sendExit = false;
                    }
                    if (i == 0 || t4Responses[i - 1] != null && response.indexOf(t4Responses[i - 1]) != -1) {
                        int timeout = maxSecTimeouts.length > i ? maxSecTimeouts[i] : DEFAULT_CMD_TIMEOUT_IN_SEC;
                        WBEMDebug.trace0((String)(METHOD + ": Sending..." + cmd[i]));
                        session.send(cmd[i] + "\r", 1);
                        WBEMDebug.trace2((String)("Waiting(max " + timeout + " secs)"));
                        if (prompts != null && prompts[i] != null) {
                            session.waitfor(prompts[i], timeout * 1000);
                        } else {
                            session.waitfor(prompt, timeout * 1000);
                        }
                        et = System.currentTimeMillis();
                        response = session.getSessionMessages();
                        WBEMDebug.trace2((String)(METHOD + ": Response String..." + response));
                    }
                    for (int j = 0; j < errorResponses.length; ++j) {
                        if (response == null || response.indexOf(errorResponses[j]) == -1) continue;
                        WBEMDebug.trace0((String)(METHOD + ": ERROR DETECTED!"));
                        WBEMDebug.trace0((String)(METHOD + ": RESPONSE WAS: " + response));
                        throw new ArrayException(response);
                    }
                }
                WBEMDebug.trace2((String)(METHOD + ": Time taken = " + (et - st) + " ms"));
                Object var25_25 = null;
                try {
                    WBEMDebug.trace2((String)(METHOD + "Disconnecting with: " + sendExit));
                    session.disconnect(sendExit);
                    break block16;
                }
                catch (Exception ex) {
                    WBEMDebug.trace2((String)(METHOD + ": Exception disconnecting" + ex.getMessage()));
                }
                {
                    break block16;
                    catch (StorEdgeIOException ex) {
                        throw ex;
                    }
                    catch (ArrayException ex) {
                        throw ex;
                    }
                    catch (Exception ex) {
                        WBEMDebug.trace2((String)(METHOD + ": Exception =  " + ex.getMessage()));
                        throw new ArrayException(ex);
                    }
                }
                catch (Throwable throwable) {
                    Object var25_26 = null;
                    try {
                        WBEMDebug.trace2((String)(METHOD + "Disconnecting with: " + sendExit));
                        session.disconnect(sendExit);
                    }
                    catch (Exception ex) {
                        WBEMDebug.trace2((String)(METHOD + ": Exception disconnecting" + ex.getMessage()));
                    }
                    WBEMDebug.trace2((String)(METHOD + ": Disconnected."));
                    throw throwable;
                }
            }
            WBEMDebug.trace2((String)(METHOD + ": Disconnected."));
            long endTime = System.currentTimeMillis();
            double totalTime = (double)(endTime - startTime) / 1000.0;
            WBEMDebug.trace2((String)(METHOD + ": TelnetPost Time = " + totalTime));
        }

        /*
         * Loose catch block
         */
        public synchronized void telnetPost(String cmd) throws ArrayException, StorEdgeIOException {
            long startTime;
            String METHOD;
            block24: {
                METHOD = "telnetPost";
                TelnetSession session = null;
                Object line = null;
                String prompt = null;
                String response = null;
                boolean retvalue = false;
                startTime = System.currentTimeMillis();
                String hostname = this.array.getHost();
                String username = this.array.getUser();
                String password = this.array.getPassword();
                prompt = ":/:<";
                for (int attempt = 0; attempt < 4; ++attempt) {
                    try {
                        session = new TelnetSession();
                        session.connect(hostname, username, password);
                        session.waitfor(prompt, 10000);
                        response = session.getSessionMessages();
                        if (response.indexOf("Login incorrect") == -1) break;
                        WBEMDebug.trace2((String)(METHOD + ": Invalid credentials"));
                        try {
                            session.disconnect();
                        }
                        catch (Exception ex2) {
                            WBEMDebug.trace2((String)(METHOD + ": Exception in disconnect" + ex2.getMessage()));
                        }
                        throw new StorEdgeIOException(3);
                    }
                    catch (InteractiveSessionException ex) {
                        WBEMDebug.trace1((String)(METHOD + ": Telnet connect failure attempt " + (attempt + 1) + " " + ex.getMessage()), (Throwable)ex);
                        try {
                            session.disconnect();
                        }
                        catch (Exception ex2) {
                            WBEMDebug.trace2((String)(METHOD + ": Exception in disconnect" + ex2.getMessage()));
                        }
                        if (attempt == 3) {
                            throw ex;
                        }
                        Thread.sleep(30000L);
                        continue;
                    }
                }
                WBEMDebug.trace2((String)(METHOD + ": Connected"));
                WBEMDebug.trace0((String)(METHOD + ": Sending Command: " + cmd));
                long st = System.currentTimeMillis();
                session.send(cmd + "\r", 1);
                WBEMDebug.trace2((String)"Waiting(max 2mins)");
                session.waitfor(prompt, 30000);
                long et = System.currentTimeMillis();
                response = session.getSessionMessages();
                WBEMDebug.trace0((String)(METHOD + ": Response String... " + response));
                if (response.indexOf("Continue ?") != -1) {
                    WBEMDebug.trace2((String)(METHOD + ": Sending confirmation y..."));
                    session.send("y\r", 1);
                    session.waitfor(prompt, 300000);
                    response = session.getSessionMessages();
                } else {
                    session.waitfor(prompt, 300000);
                    response = response + session.getSessionMessages();
                }
                if (response.indexOf("VN_BAD_DRIVE_STATE") != -1) {
                    throw new ArrayException("VN_BAD_DRIVE_STATE");
                }
                if (response.indexOf("ERROR") != -1 || response.indexOf("usage: ") != -1 || response.indexOf("Command not reentrant") != -1 || response.indexOf("Command not found") != -1) {
                    WBEMDebug.trace2((String)(METHOD + ": ERROR DETECTED!"));
                    throw new ArrayException(response);
                }
                WBEMDebug.trace2((String)(METHOD + ": Time taken = " + (et - st) + " ms"));
                Object var21_22 = null;
                try {
                    if (cmd != null && cmd.indexOf(BOOT_W) > 0) {
                        session.disconnect(false);
                    } else {
                        session.disconnect(true);
                    }
                    break block24;
                }
                catch (Exception ex) {
                    WBEMDebug.trace2((String)(METHOD + ": Exception disconnecting" + ex.getMessage()));
                }
                {
                    break block24;
                    catch (ArrayException ex) {
                        throw ex;
                    }
                    catch (Exception ex) {
                        WBEMDebug.trace2((String)(METHOD + ": Exception =  " + ex.getMessage()));
                        throw new ArrayException(ex);
                    }
                }
                catch (Throwable throwable) {
                    Object var21_23 = null;
                    try {
                        if (cmd != null && cmd.indexOf(BOOT_W) > 0) {
                            session.disconnect(false);
                        } else {
                            session.disconnect(true);
                        }
                    }
                    catch (Exception ex) {
                        WBEMDebug.trace2((String)(METHOD + ": Exception disconnecting" + ex.getMessage()));
                    }
                    WBEMDebug.trace2((String)(METHOD + ": Disconnected."));
                    throw throwable;
                }
            }
            WBEMDebug.trace2((String)(METHOD + ": Disconnected."));
            long endTime = System.currentTimeMillis();
            double totalTime = (double)(endTime - startTime) / 1000.0;
            WBEMDebug.trace2((String)(METHOD + ": TelnetPost Time = " + totalTime));
        }

        private boolean IsValidTokenValuePair(String tokenValuePair) throws ArrayException {
            return tokenValuePair != null && tokenValuePair.indexOf("=") > 0;
        }

        protected class ConnectThread
        extends Thread {
            transient HttpURLConnection connection;
            transient int response = -1;
            transient InputStream stream;
            transient Exception e = null;

            public ConnectThread(HttpURLConnection connection) {
                super("6120HttpReader:ConnectThread");
                this.connection = connection;
            }

            public void connect() throws ArrayException {
                this.start();
                long timeout = DEFAULT_CONNECT_TIMEOUT_IN_MILLI;
                boolean update = false;
                URL url = this.connection.getURL();
                String file = url.getFile();
                if (file.startsWith("/update") && file.indexOf(ArrayAccess.SYS_SHUTDOWN) == -1 && file.indexOf(ArrayAccess.SYS_RESET) == -1) {
                    timeout = RESET_TIMEOUT_IN_MILLI;
                }
                try {
                    this.join(timeout);
                }
                catch (InterruptedException ex) {
                    WBEMDebug.trace1((String)"Join exception");
                    throw new ArrayException(ex);
                }
                if (this.isAlive()) {
                    this.interrupt();
                    throw new ArrayException("Connection Timeout");
                }
            }

            public void run() {
                try {
                    try {
                        this.stream = this.connection.getInputStream();
                        this.response = this.connection.getResponseCode();
                    }
                    catch (SocketException se) {
                        throw se;
                    }
                    catch (IOException io) {
                        try {
                            this.response = this.connection.getResponseCode();
                        }
                        catch (IOException i) {
                            throw io;
                        }
                    }
                    this.response = this.connection.getResponseCode();
                }
                catch (Exception e) {
                    this.e = e;
                }
            }

            public int getResponseCode() throws Exception {
                if (this.e != null) {
                    throw this.e;
                }
                return this.response;
            }

            public InputStream getInputStream() {
                return this.stream;
            }
        }

        protected class ReadThread
        extends Thread {
            transient InputStream inStream;
            transient ByteArrayOutputStream outStream;
            transient Exception e = null;
            transient long timeOut = DevComm.access$200();

            public ReadThread(InputStream inStream, long timeOut) {
                super("6120HttpReader:ReadThread");
                this.inStream = inStream;
                this.timeOut = timeOut;
            }

            public byte[] getByteArray() {
                return this.outStream.toByteArray();
            }

            public void read() throws Exception {
                this.start();
                this.join(this.timeOut);
                if (this.isAlive()) {
                    this.interrupt();
                    this.e = new Exception("Read Timeout");
                }
                if (this.e != null) {
                    throw this.e;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            public void run() {
                block11: {
                    String METHOD = "ReadThread";
                    this.outStream = new ByteArrayOutputStream();
                    long startTime = System.currentTimeMillis();
                    long endTime = 0L;
                    double totalTime = 0.0;
                    boolean done = false;
                    long totalBytes = 0L;
                    while (!done) {
                        byte[] buf = new byte[1024];
                        int bytesRead = this.inStream.read(buf);
                        if (totalBytes == 0L) {
                            endTime = System.currentTimeMillis();
                            totalTime = (double)(endTime - startTime) / 1000.0;
                            WBEMDebug.trace2((String)(METHOD + ": Device Latency = " + totalTime + " seconds"));
                            startTime = System.currentTimeMillis();
                        }
                        totalBytes += (long)bytesRead;
                        if (bytesRead == -1) {
                            done = true;
                            break;
                        }
                        this.outStream.write(buf, 0, bytesRead);
                    }
                    endTime = System.currentTimeMillis();
                    totalTime = (double)(endTime - startTime) / 1000.0;
                    WBEMDebug.trace2((String)(METHOD + ": Data Transfer = " + totalTime + " seconds"));
                    WBEMDebug.trace2((String)(METHOD + ": Tranfer Rate  = " + (int)((double)totalBytes / totalTime) + " bytes/sec"));
                    Object var14_10 = null;
                    try {
                        this.inStream.close();
                    }
                    catch (IOException ex2) {
                        WBEMDebug.trace2((String)(METHOD + ": Error closing stream - " + ex2.getMessage()));
                    }
                    break block11;
                    {
                        catch (Exception ex) {
                            this.e = ex;
                            Object var14_11 = null;
                            try {
                                this.inStream.close();
                            }
                            catch (IOException ex2) {
                                WBEMDebug.trace2((String)(METHOD + ": Error closing stream - " + ex2.getMessage()));
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        Object var14_12 = null;
                        try {
                            this.inStream.close();
                        }
                        catch (IOException ex2) {
                            WBEMDebug.trace2((String)(METHOD + ": Error closing stream - " + ex2.getMessage()));
                        }
                        throw throwable;
                    }
                }
            }
        }
    }
}

