/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.se6120.internal;

import com.sun.netstorage.array.mgmt.cfg.core.CIMOMHandleWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.MethodCallStatus;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.ini.Repository;
import com.sun.netstorage.array.mgmt.cfg.jobs.business.JobInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.DiskInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.InstanceWrapper;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageT4sFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageT4sInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.RaidGroupInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageProfile;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageVolumeInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.T4Interface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.TrayInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.AvailableSpaceForRaidSets;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.PoolBreakdownForTray;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.RaidSetGroup;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.mr3.ManageStorageVolumes;
import com.sun.netstorage.array.mgmt.se6120.internal.ProviderToBOLConnection;
import com.sun.netstorage.array.mgmt.se6120.internal.RequestBroker;
import com.sun.netstorage.array.mgmt.util.RaidSetExistenceListener;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt16;

public class CreateRaidSets {
    public static final int STATUS_UNINITIALIZED = -1;
    public static final int STATUS_VALIDATION_STARTED = 0;
    public static final int STATUS_VALID = 10;
    public static final int STATUS_NO_EXTENTS_INCLUDED = 40000;
    public static final int STATUS_DUPLICATE_EXTENT = 40001;
    public static final int STATUS_TRAY_OUT_OF_RANGE = 40002;
    public static final int STATUS_SLOT_OUT_OF_RANGE = 40003;
    public static final int STATUS_INVALID_EXTENT_GROUPING = 40004;
    public static final int STATUS_NOT_ENOUGH_DISKS_FOR_RAID = 40005;
    public static final int STATUS_REQUESTED_SPARE_NOT_AVAILABLE = 40006;
    public static final int STATUS_REQUESTED_DISK_IN_USE = 40007;
    public static final int STATUS_TOO_MANY_RAID_SETS_REQUESTED = 40008;
    public static final int STATUS_FAILURE_UNKNOWN = 40009;
    public static final int STATUS_UNSUPPORTED_CONFIGURATION = 40010;
    public static final int STATUS_ARRAY_WITH_RAID_SETS_HAS_WRONG_SEGMENT_SIZE = 40011;
    public static final int STATUS_ARRAY_WITH_RAID_SETS_HAS_WRONG_READ_AHEAD = 40012;
    public static final int STATUS_ARRAY_NOT_HEALTHY = 40013;
    public static final int STATUS_ARRAY_WRONG_ARRAY_TYPE = 40014;
    public static final int STATUS_ARRAY_WRONG_READAHEAD_MODE = 40015;
    public static final int STATUS_ARRAY_WRONG_SEGMENT_SIZE = 40016;
    private ConfigContext context;
    private int arrayType;
    private int segmentSize;
    private int segmentSizeForT4;
    private boolean readAheadMode;
    private int numberOfDisks;
    private int raidLevel;
    private boolean usesDedicatedSpare;
    HashSet validArrays = new HashSet();
    private StorageProfile profile = null;
    private RaidSetExistenceListener listener;
    private int validationStatus = -1;
    private int numberOfRaidSets = -1;
    private static boolean haveConfiguredRepository = false;
    public static final int GENERAL_ERROR = 1;
    public static final int BAD_DISK_ERROR = 2;

    public CreateRaidSets(String namespace, int arrayType, int segmentSize, boolean readAheadMode, int numberOfDisks, int raidLevel, boolean usesDedicatedSpare, Vector extentObjectPaths, RaidSetExistenceListener listener) {
        if (!haveConfiguredRepository) {
            this.configureRepository();
        }
        Trace.constructor((Object)this);
        Trace.methodBegin((Object)this, (String)"constructor with extents");
        this.context = new ConfigContext((CIMOMHandleWrapper)new ProviderToBOLConnection(namespace));
        this.arrayType = arrayType;
        this.segmentSize = segmentSize;
        this.readAheadMode = readAheadMode;
        this.numberOfDisks = numberOfDisks;
        this.raidLevel = raidLevel;
        this.usesDedicatedSpare = usesDedicatedSpare;
        this.listener = listener;
        try {
            this.validationStatus = 0;
            if (extentObjectPaths != null && extentObjectPaths.size() > 0) {
                List raidSetDataList = this.validateExtents(extentObjectPaths);
                if (raidSetDataList != null) {
                    this.numberOfRaidSets = raidSetDataList.size();
                    this.validationStatus = 10;
                    this.createRaidSets(raidSetDataList);
                }
            } else {
                Trace.verbose((Object)this, (String)"constructor with extents", (String)"No extents passed.");
                this.validationStatus = 40000;
            }
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, (ConfigMgmtException)cme);
            this.validationStatus = 40009;
        }
    }

    public CreateRaidSets(String namespace, int arrayType, int segmentSize, boolean readAheadMode, int numberOfDisks, int raidLevel, boolean usesDedicatedSpare, BigInteger requestedSize, RaidSetExistenceListener listener) {
        if (!haveConfiguredRepository) {
            this.configureRepository();
        }
        Trace.constructor((Object)this);
        Trace.methodBegin((Object)this, (String)"constructor with size");
        this.context = new ConfigContext((CIMOMHandleWrapper)new ProviderToBOLConnection(namespace));
        this.arrayType = arrayType;
        this.segmentSize = segmentSize;
        this.readAheadMode = readAheadMode;
        this.numberOfDisks = numberOfDisks;
        this.raidLevel = raidLevel;
        this.usesDedicatedSpare = usesDedicatedSpare;
        this.listener = listener;
        List raidSetDataList = this.obtainSuitableExtents(requestedSize);
        if (raidSetDataList != null) {
            this.numberOfRaidSets = raidSetDataList.size();
            this.validationStatus = 10;
            this.createRaidSets(raidSetDataList);
        }
    }

    private void configureRepository() {
        Repository rep = Repository.getRepository();
        rep.setNameSpace("\\root\\se6x20");
        rep.setHostName("localhost");
        rep.setConfigValue("ENT1");
        rep.setTestEnvironment(false);
        haveConfiguredRepository = true;
    }

    public int getValidationStatus() {
        return this.validationStatus;
    }

    public int getNumberOfRaidSets() {
        return this.numberOfRaidSets;
    }

    private List validateExtents(Vector extents) throws ConfigMgmtException {
        String METHOD = "validateExtents";
        Trace.methodBegin((Object)this, (String)"validateExtents");
        ArrayList<RaidSetData> newList = new ArrayList<RaidSetData>();
        HashMap neededArraysAndTrays = this.getNeededArraysTraysAndDisks(extents);
        if (neededArraysAndTrays == null) {
            return null;
        }
        ManageT4sInterface manageT4s = ManageT4sFactory.getManager();
        Iterator neededT4sIter = neededArraysAndTrays.keySet().iterator();
        while (neededT4sIter.hasNext()) {
            String ip = (String)neededT4sIter.next();
            BitSet[] traysAndSlots = (BitSet[])neededArraysAndTrays.get(ip);
            Trace.verbose((Object)this, (String)"validateExtents", (String)("Obtaining T4 with IP: " + ip));
            manageT4s.init(this.context, null);
            T4Interface newT4 = manageT4s.getT4ByIP(ip);
            int isValid = AvailableSpaceForRaidSets.isSuitableArray((T4Interface)newT4, (int)this.arrayType, (int)this.segmentSize, (boolean)this.readAheadMode);
            if (0 != isValid) {
                Trace.verbose((Object)this, (String)"validateExtents", (String)("have invalid array settings on array: " + ip));
                if (isValid == 1) {
                    this.validationStatus = 40013;
                } else if (isValid == 2) {
                    this.validationStatus = 40014;
                } else if (isValid == 3) {
                    this.validationStatus = 40015;
                } else if (isValid == 4) {
                    this.validationStatus = 40016;
                }
                return null;
            }
            List trays = newT4.getTrays();
            int traySize = trays.size();
            for (int trayId = 0; trayId < traysAndSlots.length; ++trayId) {
                if (traysAndSlots[trayId] == null) continue;
                TrayInterface tray = null;
                for (int trayI = 0; tray == null && trayI < traySize; ++trayI) {
                    tray = (TrayInterface)trays.get(trayI);
                    Trace.verbose((Object)this, (String)"validateExtents", (String)("examining tray interface with id:" + tray.getId()));
                    if (tray.getId().equals("" + trayId)) continue;
                    Trace.verbose((Object)this, (String)"validateExtents", (String)("tray interface with id:" + tray.getId() + " has wrong id, not: " + trayId));
                    tray = null;
                }
                if (tray == null) {
                    Trace.verbose((Object)this, (String)"validateExtents", (String)("Sent in extents for tray id: " + trayId + " but this array does not have such a tray number."));
                    this.validationStatus = 40002;
                    return null;
                }
                Trace.verbose((Object)this, (String)"validateExtents", (String)("Found slots in index: " + trayId + ": " + traysAndSlots[trayId] + " and this is on tray id: " + tray.getId()));
                int totalDisksForTray = 0;
                int numPools = traysAndSlots[trayId].cardinality() / this.numberOfDisks;
                PoolBreakdownForTray pbd = tray.getPoolBreakdownForTray(numPools, this.numberOfDisks * numPools, this.raidLevel, this.usesDedicatedSpare);
                if (!pbd.canBeSupported()) {
                    Trace.verbose((Object)this, (String)"validateExtents", (String)("unable to support breakdown for reason: " + pbd.getFailureReason()));
                    switch (pbd.getFailureReason()) {
                        case 2: {
                            this.validationStatus = 40008;
                            break;
                        }
                        case 3: {
                            this.validationStatus = 40007;
                            break;
                        }
                        case 4: {
                            this.validationStatus = 40006;
                            break;
                        }
                        case 5: {
                            this.validationStatus = 40005;
                            break;
                        }
                        default: {
                            this.validationStatus = 40009;
                        }
                    }
                    return null;
                }
                for (int poolCtr = 0; poolCtr < numPools; ++poolCtr) {
                    List disks = pbd.getDisksForPool(poolCtr);
                    int disksSize = disks.size();
                    for (int diskIndex = 0; diskIndex < disksSize; ++diskIndex) {
                        DiskInterface disk = (DiskInterface)disks.get(diskIndex);
                        ++totalDisksForTray;
                        if (traysAndSlots[trayId].get(disk.getSlotNumber())) continue;
                        Trace.verbose((Object)this, (String)"validateExtents", (String)("Found disk that should be used, but not requested. On IP: " + ip + " for trayId: " + trayId + " should use disk in slot: " + disk.getSlotNumber()));
                        this.validationStatus = 40010;
                        return null;
                    }
                }
                if (totalDisksForTray != traysAndSlots[trayId].cardinality()) {
                    Trace.verbose((Object)this, (String)"validateExtents", (String)("Found requested that would not be used in the breakdown. On IP: " + ip + " for trayId: " + trayId));
                    this.validationStatus = 40010;
                    return null;
                }
                Trace.verbose((Object)this, (String)"validateExtents", (String)("Valid raid set request... On IP: " + ip + " and trayId: " + trayId));
                RaidSetData rsd = new RaidSetData(tray, pbd);
                newList.add(rsd);
            }
        }
        return newList;
    }

    private void createRaidSets(List raidSets) {
        String METHOD = "createRaidSets";
        ArrayList<RaidSetMaker> workerThreads = new ArrayList<RaidSetMaker>();
        Trace.methodBegin((Object)this, (String)"createRaidSets");
        int raidSetCounter = 0;
        int raidSetsSize = 0;
        if (raidSets != null) {
            raidSetsSize = raidSets.size();
        }
        for (int i = 0; i < raidSetsSize; ++i) {
            RaidSetData rsd = (RaidSetData)raidSets.get(i);
            TrayInterface tray = rsd.getTray();
            PoolBreakdownForTray pbd = rsd.getBreakdown();
            for (int raidSetCount = 0; raidSetCount < pbd.getNumPools(); ++raidSetCount) {
                if (!rsd.isValidPoolIndex(raidSetCount)) {
                    Trace.verbose((Object)this, (String)"createRaidSets", (String)"Skipping pool index, since not requested.");
                    continue;
                }
                try {
                    this.ensureArrayPropertiesSet(tray.getT4Interface());
                    if (this.profile == null) {
                        this.profile = this.getStorageProfile();
                    }
                    ++raidSetCounter;
                    RaidSetMaker rsm = new RaidSetMaker(pbd.getSuggestedName(raidSetCount), tray, pbd, raidSetCount);
                    workerThreads.add(rsm);
                    continue;
                }
                catch (ConfigMgmtException cme) {
                    Trace.error((Object)this, (String)"createRaidSets", (String)"Failed to create a raid set.");
                    Trace.error((Object)this, (ConfigMgmtException)cme);
                    this.notifyListenerOfFailedRaidSet(1, null);
                }
            }
        }
        Trace.verbose((Object)this, (String)"createRaidSets", (String)("Reporting number of raid sets: " + raidSetCounter));
        try {
            this.listener.setNumRaidSets(raidSetCounter);
        }
        catch (Exception e) {
            ConfigMgmtException cme = new ConfigMgmtException(e);
            Trace.verbose((Object)this, (String)"ignoring this unexpected exception", (Throwable)cme);
        }
        this.startAndWaitForJobCreation(workerThreads);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startAndWaitForJobCreation(List workerThreads) {
        String METHOD = "startAndWaitForJobCreation(List)";
        Trace.methodBegin((Object)this, (String)"startAndWaitForJobCreation(List)");
        int numWorkers = workerThreads.size();
        if (numWorkers == 0) {
            Trace.verbose((Object)this, (String)"startAndWaitForJobCreation(List)", (String)"No threads to start.");
            return;
        }
        for (int i = 0; i < numWorkers; ++i) {
            if (i == 0) {
                Trace.verbose((Object)this, (String)"startAndWaitForJobCreation(List)", (String)"Starting work threads.");
            }
            RaidSetMaker t = (RaidSetMaker)workerThreads.get(i);
            t.start();
        }
        int index = 0;
        RaidSetMaker waitThread = (RaidSetMaker)workerThreads.get(index);
        while (waitThread != null) {
            RaidSetMaker raidSetMaker = waitThread;
            synchronized (raidSetMaker) {
                if (!waitThread.isPoolJobCreated()) {
                    Trace.verbose((Object)this, (String)"startAndWaitForJobCreation(List)", (String)("Waiting on: " + waitThread.getName()));
                    try {
                        waitThread.wait();
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                }
            }
            if (waitThread == null || !waitThread.isPoolJobCreated()) continue;
            if (++index < numWorkers) {
                waitThread = (RaidSetMaker)workerThreads.get(index);
                continue;
            }
            waitThread = null;
        }
        Trace.verbose((Object)this, (String)"startAndWaitForJobCreation(List)", (String)"done waiting");
    }

    private List obtainSuitableExtents(BigInteger requestedSize) {
        String METHOD = "obtainSuitableExtents";
        Trace.methodBegin((Object)this, (String)"obtainSuitableExtents");
        ArrayList<RaidSetData> rsdList = new ArrayList<RaidSetData>();
        try {
            AvailableSpaceForRaidSets avail = new AvailableSpaceForRaidSets(this.context, this.arrayType, this.segmentSize, this.readAheadMode, this.numberOfDisks, this.raidLevel, this.usesDedicatedSpare);
            RaidSetGroup rsg = avail.getRaidSetGroupForSize(requestedSize);
            if (rsg == null) {
                Trace.verbose((Object)this, (String)"obtainSuitableExtents", (String)("Requested size not obtainable: " + requestedSize.toString()));
                this.validationStatus = 40010;
                return null;
            }
            List breakdowns = rsg.getBreakdowns();
            if (breakdowns == null) {
                Trace.verbose((Object)this, (String)"obtainSuitableExtents", (String)"No breakdowns for requested size.");
                this.validationStatus = 40010;
                return null;
            }
            int bdsize = breakdowns.size();
            Trace.verbose((Object)this, (String)"obtainSuitableExtents", (String)("Have breakdowns to process: " + bdsize));
            for (int i = 0; i < bdsize; ++i) {
                RaidSetGroup.RaidSetBreakdown bd = (RaidSetGroup.RaidSetBreakdown)breakdowns.get(i);
                TrayInterface tray = bd.getBreakdown().getTray();
                RaidSetData rsd = new RaidSetData(tray, bd.getBreakdown(), new int[]{bd.getIndex()});
                rsdList.add(rsd);
            }
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, (ConfigMgmtException)cme);
            this.validationStatus = 40009;
            return null;
        }
        return rsdList;
    }

    private HashMap getNeededArraysTraysAndDisks(Vector v) {
        String METHOD = "getNeededArraysTraysAndDisks";
        HashMap<String, BitSet[]> hm = new HashMap<String, BitSet[]>();
        Pattern getArrayIPAddrPattern = Pattern.compile("SystemName=\\W+([\\d\\.]+)");
        Pattern getTrayAndSlotPattern = Pattern.compile("DeviceID=\\W+u(\\d+)d(\\d+)");
        if (v == null || v.size() == 0) {
            this.validationStatus = 40000;
            return null;
        }
        int vecSize = v.size();
        for (int i = 0; i < vecSize; ++i) {
            BitSet bits;
            String data = (String)v.get(i);
            Matcher mIP = getArrayIPAddrPattern.matcher(data);
            if (!mIP.find()) continue;
            String ip = mIP.group(1);
            Trace.verbose((Object)this, (String)"getNeededArraysTraysAndDisks", (String)("found IP: " + ip));
            Matcher mTrayAndSlot = getTrayAndSlotPattern.matcher(data);
            if (!mTrayAndSlot.find()) continue;
            String tray = mTrayAndSlot.group(1);
            int trayId = Integer.parseInt(tray) - 1;
            String slot = mTrayAndSlot.group(2);
            int slotId = Integer.parseInt(slot);
            Trace.verbose((Object)this, (String)"getNeededArraysTraysAndDisks", (String)("found tray: " + tray + " and slot: " + slot));
            if (slotId < 1 || slotId > 14) {
                Trace.error((Object)this, (String)"getNeededArraysTraysAndDisks", (String)("Terminating validation since slot (" + slot + ") is out of range on: " + data));
                this.validationStatus = 40003;
                return null;
            }
            if (trayId < 0 || trayId >= 6) {
                Trace.error((Object)this, (String)"getNeededArraysTraysAndDisks", (String)("Terminating validation since tray ID (" + trayId + ") is out of range on: " + data));
                this.validationStatus = 40002;
                return null;
            }
            if (hm.get(ip) == null) {
                BitSet[] newList = new BitSet[6];
                bits = new BitSet(15);
                bits.set(slotId);
                newList[trayId] = bits;
                hm.put(ip, newList);
                continue;
            }
            BitSet[] list = (BitSet[])hm.get(ip);
            bits = list[trayId];
            if (bits != null) {
                if (bits.get(slotId)) {
                    Trace.verbose((Object)this, (String)"getNeededArraysTraysAndDisks", (String)("Terminating validation since duplicate extent passed in: " + data));
                    this.validationStatus = 40001;
                    return null;
                }
                bits.set(slotId);
                continue;
            }
            bits = new BitSet(15);
            bits.set(slotId);
            list[trayId] = bits;
        }
        Iterator t4s = hm.keySet().iterator();
        while (t4s.hasNext()) {
            String ip = (String)t4s.next();
            BitSet[] trays = (BitSet[])hm.get(ip);
            Trace.verbose((Object)this, (String)"getNeededArraysTraysAndDisks", (String)("Examining groupings on array: " + ip + " will examine one less trays than: " + trays.length));
            for (int i = 0; i < trays.length; ++i) {
                Trace.verbose((Object)this, (String)"getNeededArraysTraysAndDisks", (String)("On array: " + ip + "and tray: " + i + " have bitSet: " + trays[i]));
                if (trays[i] == null) continue;
                BitSet slots = trays[i];
                int contigCount = 0;
                boolean lastSlot = false;
                for (int j = 1; j <= 14; ++j) {
                    boolean current = slots.get(j);
                    if (j > 1 && !current && current != lastSlot && contigCount != this.numberOfDisks && contigCount != 2 * this.numberOfDisks) {
                        Trace.verbose((Object)this, (String)"getNeededArraysTraysAndDisks", (String)("Found invalid groupings of storage extents. On array: " + ip + " on zero-based trayId: " + i + " found: " + contigCount + " disks grouped which is not a multiple of: " + this.numberOfDisks));
                        this.validationStatus = 40004;
                        return null;
                    }
                    contigCount = current ? ++contigCount : 0;
                    lastSlot = current;
                }
                if (!lastSlot || contigCount == this.numberOfDisks || contigCount == 2 * this.numberOfDisks) continue;
                Trace.verbose((Object)this, (String)"getNeededArraysTraysAndDisks", (String)("Found invalid groupings of storage extents. On array: " + ip + " on zero-based trayId: " + i + " found: " + contigCount + " disks grouped which is not a multiple of: " + this.numberOfDisks));
                this.validationStatus = 40004;
                return null;
            }
        }
        return hm;
    }

    private void ensureArrayPropertiesSet(T4Interface t4) throws ConfigMgmtException {
        String METHOD = "ensureArrayPropertiesSet";
        Trace.methodBegin((Object)this, (String)"ensureArrayPropertiesSet");
        if (!this.validArrays.contains(t4.getClusterName())) {
            Trace.verbose((Object)this, (String)"ensureArrayPropertiesSet", (String)("Beginning to validate IP: " + t4.getClusterName()));
            boolean needsToBeSaved = false;
            if (!AvailableSpaceForRaidSets.meetsReadAhead((boolean)this.readAheadMode, (int)t4.getReadaheadMode())) {
                needsToBeSaved = true;
                t4.setReadaheadMode(this.readAheadMode ? 0 : 1);
            }
            if (!AvailableSpaceForRaidSets.meetsSegSize((int)this.segmentSize, (int)t4.getBlockSize())) {
                needsToBeSaved = true;
                int newBlockSize = this.convertProfileSegmentSizeToArray(this.segmentSize);
                t4.setBlockSize(newBlockSize);
            }
            if (needsToBeSaved) {
                Trace.verbose((Object)this, (String)"ensureArrayPropertiesSet", (String)"Saving changes to array.");
                t4.save();
                t4.reload();
            }
            this.validArrays.add(t4.getClusterName());
        }
    }

    private int convertProfileSegmentSizeToArray(int segSize) throws ConfigMgmtException {
        int newBlockSize = -1;
        if (segSize == 0) {
            newBlockSize = 4096;
        } else if (segSize == 1) {
            newBlockSize = 8192;
        } else if (segSize == 2) {
            newBlockSize = 16384;
        } else if (segSize == 3) {
            newBlockSize = 32768;
        } else if (segSize == 4) {
            newBlockSize = 65536;
        } else {
            throw new ConfigMgmtException("DATA_INCONSISTENCY", "Invalid segment size could not be processed: " + segSize);
        }
        return newBlockSize;
    }

    private void notifyListenerOfFailedRaidSet(int errorCode, Object context) {
        try {
            this.listener.addFailedRaidSet(errorCode, context);
        }
        catch (Exception e) {
            ConfigMgmtException cme = new ConfigMgmtException(e);
            Trace.verbose((Object)this, (String)"ignoring exception for failed job", (Throwable)cme);
        }
    }

    private StorageProfile getStorageProfile() throws ConfigMgmtException {
        return new StorageProfile("", "", this.raidLevel, this.convertProfileSegmentSizeToArray(this.segmentSize), this.readAheadMode ? 0 : 1, "" + this.numberOfDisks, this.usesDedicatedSpare ? 1 : 0, this.arrayType);
    }

    class RaidSetMaker
    extends Thread {
        private TrayInterface tray;
        private CIMObjectPath raidGroupJob;
        private String raidGroupName;
        private String storageVolumeName;
        private boolean poolJobCreated = false;
        private RaidGroupInterface raidGroup = null;
        private PoolBreakdownForTray pbd = null;
        private int raidSetCount;
        private int failureCount = 0;
        private static final int MAX_FAILURE_COUNT = 4;
        private static final int MAX_ATTEMPT_COUNT = 180;
        private boolean keepRunning = true;

        public RaidSetMaker(String raidGroupName, TrayInterface tray, PoolBreakdownForTray pbd, int raidSetCount) {
            super("Thread for " + raidGroupName);
            this.raidGroupName = raidGroupName;
            this.tray = tray;
            this.storageVolumeName = "v" + raidGroupName;
            this.pbd = pbd;
            this.raidSetCount = raidSetCount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            String METHOD = "run for: " + this.raidGroupName;
            Trace.methodBegin((Object)this, (String)METHOD);
            try {
                Trace.verbose((Object)this, (String)METHOD, (String)("Attempting Raid Group creation on IP: " + this.tray.getT4Interface().getClusterName() + " and trayId: " + this.tray.getId()));
                MethodCallStatus mcs = this.tray.createRAIDGroup(this.pbd.getSuggestedName(this.raidSetCount), this.pbd.getDisksForPool(this.raidSetCount), CreateRaidSets.this.profile, CreateRaidSets.this.usesDedicatedSpare);
                this.setPoolJobCreatedAndNotify();
                if (mcs.getReturnCode() != 0) {
                    Trace.verbose((Object)this, (String)METHOD, (String)("Failed to create Raid Group with return code: " + mcs.getReturnCode()));
                    CreateRaidSets.this.notifyListenerOfFailedRaidSet(1, null);
                }
                Trace.verbose((Object)this, (String)METHOD, (String)("Next step is slice creation on IP: " + this.tray.getT4Interface().getClusterName() + " and trayId: " + this.tray.getId() + " for RaidGroup named: " + this.raidGroupName));
                ArrayList allJobs = mcs.getJobs();
                this.raidGroupJob = ((JobInterface)allJobs.get(0)).getObjectPath();
                Trace.verbose((Object)this, (String)METHOD, (String)("Found job: " + this.raidGroupJob));
                int numAttempts = 0;
                while (this.keepRunning) {
                    UnsignedInt16 errorCode;
                    CIMInstance job;
                    try {
                        Thread.sleep(60000L);
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                    ++numAttempts;
                    if (this.raidGroup == null) {
                        this.findRaidGroup();
                    } else {
                        this.findSlice();
                    }
                    if (numAttempts > 180) {
                        Trace.verbose((Object)this, (String)METHOD, (String)"Gave up waiting for the data to show up.");
                        this.keepRunning = false;
                        CreateRaidSets.this.notifyListenerOfFailedRaidSet(1, null);
                    }
                    if (null == this.raidGroupJob || null == (job = RequestBroker.getInstance().findInstance(this.raidGroupJob)) || (errorCode = (UnsignedInt16)job.getProperty("ErrorCode").getValue().getValue()).intValue() != 2) continue;
                    this.keepRunning = false;
                    CreateRaidSets.this.notifyListenerOfFailedRaidSet(2, this.pbd.getDisksForPool(this.raidSetCount));
                }
                Trace.verbose((Object)this, (String)METHOD, (String)"Exiting run method.");
            }
            catch (ConfigMgmtException cme) {
                Trace.error((Object)this, (ConfigMgmtException)cme);
                if (cme.getExceptionKey() == "POOL_CREATE_DISK_OFFLINE_ERROR") {
                    CreateRaidSets.this.notifyListenerOfFailedRaidSet(2, cme.getExceptionContext());
                } else {
                    CreateRaidSets.this.notifyListenerOfFailedRaidSet(1, null);
                }
            }
            catch (Exception e) {
                ConfigMgmtException cme = new ConfigMgmtException(e);
                Trace.error((Object)this, (ConfigMgmtException)cme);
                if (this.keepRunning) {
                    Trace.error((Object)this, (String)METHOD, (String)"exited unexpectedly.");
                    CreateRaidSets.this.notifyListenerOfFailedRaidSet(1, null);
                }
            }
            finally {
                this.setPoolJobCreatedAndNotify();
            }
        }

        private void findRaidGroup() throws Exception {
            block5: {
                String METHOD = "findRaidGroup:" + this.raidGroupName;
                Trace.methodBegin((Object)this, (String)METHOD);
                try {
                    this.tray.reload();
                    List rgs = this.tray.getRaidGroups();
                    if (rgs != null) {
                        for (int i = 0; i < rgs.size(); ++i) {
                            RaidGroupInterface rg = (RaidGroupInterface)rgs.get(i);
                            if (!this.raidGroupName.equals(rg.getName())) continue;
                            Trace.verbose((Object)this, (String)METHOD, (String)"Found raid group.");
                            this.raidGroup = rg;
                            ManageStorageVolumes msv = new ManageStorageVolumes();
                            msv.setScope((InstanceWrapper)rg);
                            msv.init(CreateRaidSets.this.context, null);
                            Trace.verbose((Object)this, (String)METHOD, (String)"Creating slice of full size.");
                            MethodCallStatus mcs = msv.createVolume(this.storageVolumeName, this.tray.getT4Interface(), this.raidGroup, this.raidGroup.getAvailableCapacity(), "Read/Write", -1, null);
                            if (mcs.getReturnCode() != 0) {
                                Trace.error((Object)this, (String)METHOD, (String)("Failed to create the slice on raid group: " + this.raidGroupName + " got error code returned: " + mcs.getReturnCode()));
                                this.keepRunning = false;
                                CreateRaidSets.this.notifyListenerOfFailedRaidSet(1, null);
                            }
                            Trace.verbose((Object)this, (String)METHOD, (String)"Creating slice passed parameter checking.");
                            this.requestDeletionOfSliceJob(mcs.getJobs());
                        }
                    }
                }
                catch (ConfigMgmtException cme) {
                    Trace.error((Object)this, (ConfigMgmtException)cme);
                    ++this.failureCount;
                    if (this.failureCount <= 4) break block5;
                    throw new Exception("Failed too many times to discover raid group: " + this.raidGroupName);
                }
            }
        }

        private void findSlice() throws Exception {
            block6: {
                String METHOD = "findSlice:" + this.storageVolumeName;
                Trace.methodBegin((Object)this, (String)METHOD);
                try {
                    this.raidGroup.reload();
                    List vols = this.raidGroup.getVolumes();
                    if (vols != null) {
                        for (int i = 0; i < vols.size(); ++i) {
                            StorageVolumeInterface vol = (StorageVolumeInterface)vols.get(i);
                            if (!vol.getName().equals(this.storageVolumeName)) continue;
                            Trace.verbose((Object)this, (String)METHOD, (String)"Found slice tied to pool.");
                            String wwn = vol.getDeviceID();
                            this.keepRunning = false;
                            Trace.verbose((Object)this, (String)METHOD, (String)("Reporting WWN: " + wwn));
                            try {
                                CreateRaidSets.this.listener.addRaidSet(wwn, this.raidGroupJob);
                                continue;
                            }
                            catch (Exception e) {
                                Trace.error((Object)this, (String)METHOD, (String)"Unexpected error when notifying listener about raid set.");
                                ConfigMgmtException cme = new ConfigMgmtException(e);
                                Trace.error((Object)this, (ConfigMgmtException)cme);
                            }
                        }
                    }
                }
                catch (ConfigMgmtException cme) {
                    Trace.error((Object)this, (ConfigMgmtException)cme);
                    ++this.failureCount;
                    if (this.failureCount <= 4) break block6;
                    throw new Exception("Failed too many times to discover slice on raid group: " + this.raidGroupName);
                }
            }
        }

        private void requestDeletionOfSliceJob(List jobs) {
            String METHOD = "requestDeletionOfSliceJob(List)";
            Trace.methodBegin((Object)this, (String)"requestDeletionOfSliceJob(List)");
            for (int i = 0; jobs != null && i < jobs.size(); ++i) {
                try {
                    JobInterface job = (JobInterface)jobs.get(i);
                    CIMObjectPath cop = job.getObjectPath();
                    CIMInstance cimi = CreateRaidSets.this.context.getClient().getInstance(cop, false, true, false, null);
                    cimi.setProperty("DeleteOnCompletion", new CIMValue((Object)new Boolean(true)));
                    String[] prop = new String[]{"InstanceID", "DeleteOnCompletion"};
                    CreateRaidSets.this.context.getClient().setInstance(cimi.getObjectPath(), cimi, true, prop);
                    continue;
                }
                catch (Exception e) {
                    Trace.error((Object)this, (String)"requestDeletionOfSliceJob(List)", (String)("Caught excpetion attempting to set the DeleteOnCompletion in jobs" + e.toString() + " " + e.getMessage()));
                }
            }
        }

        public synchronized boolean isPoolJobCreated() {
            return this.poolJobCreated;
        }

        private synchronized void setPoolJobCreatedAndNotify() {
            if (!this.poolJobCreated) {
                Trace.verbose((Object)this, (String)"setPoolJobCreatedAndNotify", (String)("entered for Thread: " + this.getName()));
                this.poolJobCreated = true;
                this.notify();
            }
        }
    }

    class RaidSetData {
        private TrayInterface tray;
        private int[] poolIndexes = null;
        private PoolBreakdownForTray breakdown;

        public RaidSetData(TrayInterface tray, PoolBreakdownForTray breakdown) {
            this.tray = tray;
            this.breakdown = breakdown;
        }

        public RaidSetData(TrayInterface tray, PoolBreakdownForTray breakdown, int[] validIndexes) {
            Trace.constructor((Object)this);
            this.tray = tray;
            this.breakdown = breakdown;
            this.poolIndexes = validIndexes;
        }

        public TrayInterface getTray() {
            return this.tray;
        }

        public PoolBreakdownForTray getBreakdown() {
            return this.breakdown;
        }

        public int[] getValidIndexes() {
            return this.poolIndexes;
        }

        public boolean isValidPoolIndex(int index) {
            Trace.methodBegin((Object)this, (String)"isValidPoolIndex");
            if (this.poolIndexes != null) {
                for (int i = 0; i < this.poolIndexes.length; ++i) {
                    if (index != this.poolIndexes[i]) continue;
                    return true;
                }
            } else {
                return true;
            }
            return false;
        }
    }
}

