/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.se6120.internal;

import com.sun.netstorage.array.mgmt.se6120.internal.ArrayObject;
import com.sun.netstorage.array.mgmt.se6120.internal.CIMUtils;
import com.sun.netstorage.array.mgmt.se6120.internal.CacheAddr;
import com.sun.netstorage.array.mgmt.se6120.internal.RequestBroker;
import com.sun.netstorage.array.mgmt.se6120.internal.UpdateClusterDiskUsage;
import com.sun.netstorage.array.mgmt.util.ObjectPath;
import com.sun.netstorage.array.mgmt.util.StorEdge_PersistentStorage;
import com.sun.netstorage.array.mgmt.util.WBEMDebug;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Vector;
import javax.wbem.cim.CIMDataType;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt16;
import javax.wbem.cim.UnsignedInt8;

public class CIMInstanceCache {
    private HashMap copIndex = new HashMap();
    private HashMap conIndex = new HashMap();
    private HashMap cimInsts = new HashMap();
    private static final UnsignedInt16 CONTROLLER_CHASSIS_TYPE_VAL = new UnsignedInt16(17);

    public void addArray(ArrayObject array) {
        this.addArray(array, null);
    }

    public void addArray(ArrayObject array, CIMInstance tlo) {
        if (array == null) {
            return;
        }
        if (this.cimInsts.get(array) != null) {
            this.removeArray(array);
        }
        HashMap<Integer, CIMInstance> cimMap = new HashMap<Integer, CIMInstance>();
        if (tlo != null) {
            Integer hs = new Integer(tlo.getObjectPath().toString().hashCode());
            cimMap.put(hs, tlo);
            CIMObjectPath cop = tlo.getObjectPath();
            CacheAddr addr = new CacheAddr(array, cop.toString().hashCode());
            this.copIndex.put(new ObjectPath(tlo.getObjectPath()), addr);
            LinkedHashMap<Integer, CacheAddr> conMap = (LinkedHashMap<Integer, CacheAddr>)this.conIndex.get(cop.getObjectName());
            if (null == conMap) {
                conMap = new LinkedHashMap<Integer, CacheAddr>();
            }
            conMap.put(new Integer(cop.toString().hashCode()), addr);
            this.conIndex.put(cop.getObjectName(), conMap);
        }
        this.cimInsts.put(array, cimMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addArrayWithInstances(ArrayObject array, CIMInstance[] mos) {
        if (array == null) {
            return;
        }
        HashMap hashMap = this.cimInsts;
        synchronized (hashMap) {
            this.addArray(array);
            if (mos == null) {
                return;
            }
            ArrayList<CIMInstance> allDisks = new ArrayList<CIMInstance>();
            CIMInstance cluster = null;
            int numControllers = 0;
            int numExpansion = 0;
            for (int i = 0; i < mos.length; ++i) {
                CIMProperty chassisTypesProp;
                if (mos[i].getClassName().equals("SunStorEdge_6120Cluster")) {
                    Vector info;
                    int indexOfFirmware = CIMUtils.getArrayPropertyIndex(mos[i], "IdentifyingDescriptions", "Firmware Version");
                    if (indexOfFirmware > -1 && null != (info = (Vector)CIMUtils.getPropertyValue(mos[i], "OtherIdentifyingInfo"))) {
                        array.setFirmwareVersion((String)info.elementAt(indexOfFirmware));
                    }
                    cluster = mos[i];
                } else if (mos[i].getClassName().equals("SunStorEdge_6120PoolStorageCapabilities")) {
                    try {
                        CIMProperty poolWWN = mos[i].getProperty("InstanceID");
                        String WWN = poolWWN.getValue().getValue().toString();
                        String profile = StorEdge_PersistentStorage.getInstance().getPersistentString("SunStorEdge_6120StoragePool." + WWN + ".ProfileKey");
                        if (null == profile) {
                            profile = "";
                        }
                        mos[i].setProperty("Description", new CIMValue((Object)profile, new CIMDataType(8)));
                    }
                    catch (Exception ex) {
                        WBEMDebug.trace2((String)"Could not set profile on PoolStorageCapabilities instance ", (Throwable)ex);
                    }
                } else if (mos[i].getClassName().equals("SunStorEdge_6120StorageExtent")) {
                    allDisks.add(mos[i]);
                } else if (mos[i].getClassName().equals("SunStorEdge_6120Chassis") && (chassisTypesProp = mos[i].getProperty("ChassisTypes")) != null && chassisTypesProp.getValue() != null && chassisTypesProp.getValue().getValue() != null) {
                    Vector chassisTypes = (Vector)chassisTypesProp.getValue().getValue();
                    if (chassisTypes.contains(CONTROLLER_CHASSIS_TYPE_VAL)) {
                        ++numControllers;
                    } else {
                        ++numExpansion;
                    }
                }
                this.add(array, mos[i]);
            }
            try {
                cluster.setProperty("NumberOfControllerChassis", new CIMValue((Object)new UnsignedInt8((short)numControllers), new CIMDataType(0)));
                cluster.setProperty("NumberOfExpansionChassis", new CIMValue((Object)new UnsignedInt8((short)numExpansion), new CIMDataType(0)));
            }
            catch (CIMException cime) {
                WBEMDebug.trace1((String)"CIMInstanceCache failed to update types of chassis", (Throwable)cime);
            }
            UpdateClusterDiskUsage updater = new UpdateClusterDiskUsage();
            updater.updateDiskInfoForCluster(this, cluster, array, allDisks);
            RequestBroker.getInstance();
            if (RequestBroker.hasVirtualControllers(array)) {
                try {
                    RequestBroker.getInstance().setClusterOperationalStatus(array, 1, "Invalid Configuration");
                }
                catch (Exception ex) {
                    WBEMDebug.trace2((String)"Could not find instance ", (Throwable)ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(ArrayObject array, CIMInstance mo) {
        if (array == null || mo == null) {
            return;
        }
        CIMObjectPath cop = mo.getObjectPath();
        String con = cop.getObjectName();
        Integer hs = new Integer(cop.toString().hashCode());
        CacheAddr addr = new CacheAddr(array, cop);
        HashMap hashMap = this.cimInsts;
        synchronized (hashMap) {
            HashMap<Integer, CIMInstance> cims = (HashMap<Integer, CIMInstance>)this.cimInsts.get(array);
            if (cims == null) {
                cims = new HashMap<Integer, CIMInstance>();
                this.cimInsts.put(array, cims);
            }
            cims.put(hs, mo);
            this.copIndex.put(new ObjectPath(cop), addr);
            LinkedHashMap<Integer, CacheAddr> conMap = (LinkedHashMap<Integer, CacheAddr>)this.conIndex.get(con);
            if (conMap == null) {
                conMap = new LinkedHashMap<Integer, CacheAddr>();
                this.conIndex.put(con, conMap);
            }
            conMap.put(hs, addr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(ArrayObject array, CIMInstance[] mos) {
        if (array == null || mos == null) {
            return;
        }
        HashMap hashMap = this.cimInsts;
        synchronized (hashMap) {
            for (int i = 0; i < mos.length; ++i) {
                this.add(array, mos[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeArray(ArrayObject array) {
        if (array == null) {
            return;
        }
        HashMap hashMap = this.cimInsts;
        synchronized (hashMap) {
            HashMap cimMap = (HashMap)this.cimInsts.get(array);
            if (cimMap == null) {
                return;
            }
            if (cimMap.size() < 1) {
                this.cimInsts.remove(array);
                return;
            }
            Collection col = cimMap.values();
            boolean LAZY = false;
            if (!LAZY) {
                CIMInstance[] cims = col.toArray(new CIMInstance[0]);
                for (int i = 0; i < cims.length; ++i) {
                    CIMObjectPath cop = cims[i].getObjectPath();
                    String con = cop.getObjectName();
                    Integer hs = new Integer(cop.toString().hashCode());
                    this.copIndex.remove(new ObjectPath(cop));
                    LinkedHashMap conMap = (LinkedHashMap)this.conIndex.get(con);
                    if (conMap == null) continue;
                    conMap.remove(hs);
                }
            }
            this.cimInsts.remove(array);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(CIMObjectPath cop) {
        if (cop == null) {
            return;
        }
        HashMap hashMap = this.cimInsts;
        synchronized (hashMap) {
            CacheAddr addr = (CacheAddr)this.copIndex.get(new ObjectPath(cop));
            if (addr == null) {
                return;
            }
            ArrayObject array = addr.getArray();
            if (array == null) {
                return;
            }
            HashMap cimMap = (HashMap)this.cimInsts.get(array);
            if (cimMap == null || cimMap.size() < 1) {
                return;
            }
            String con = cop.getObjectName();
            Integer hs = new Integer(addr.getCOPHashCode());
            this.copIndex.remove(new ObjectPath(cop));
            LinkedHashMap conMap = (LinkedHashMap)this.conIndex.get(con);
            if (conMap != null) {
                conMap.remove(hs);
            }
            cimMap.remove(hs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(ArrayObject array, CIMObjectPath cop) {
        if (array == null || cop == null) {
            return;
        }
        HashMap hashMap = this.cimInsts;
        synchronized (hashMap) {
            HashMap cimMap = (HashMap)this.cimInsts.get(array);
            if (cimMap == null || cimMap.size() < 1) {
                return;
            }
            String con = cop.getObjectName();
            Integer hs = new Integer(cop.toString().hashCode());
            this.copIndex.remove(new ObjectPath(cop));
            LinkedHashMap conMap = (LinkedHashMap)this.conIndex.get(con);
            if (conMap != null) {
                conMap.remove(hs);
            }
            cimMap.remove(hs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll(ArrayObject array, CIMObjectPath[] cops) {
        if (array == null || cops == null) {
            return;
        }
        HashMap hashMap = this.cimInsts;
        synchronized (hashMap) {
            HashMap cimMap = (HashMap)this.cimInsts.get(array);
            if (cimMap == null || cimMap.size() < 1) {
                return;
            }
            for (int i = 0; i < cops.length; ++i) {
                String con = cops[i].getObjectName();
                Integer hs = new Integer(cops[i].toString().hashCode());
                this.copIndex.remove(new ObjectPath(cops[i]));
                LinkedHashMap conMap = (LinkedHashMap)this.conIndex.get(con);
                if (conMap != null) {
                    conMap.remove(hs);
                }
                cimMap.remove(hs);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CIMInstance find(CIMObjectPath cop) {
        if (cop == null) {
            return null;
        }
        CIMInstance mo = null;
        HashMap hashMap = this.cimInsts;
        synchronized (hashMap) {
            CacheAddr addr = (CacheAddr)this.copIndex.get(new ObjectPath(cop));
            if (addr != null) {
                ArrayObject array = addr.getArray();
                Integer hs = new Integer(addr.getCOPHashCode());
                HashMap cimMap = (HashMap)this.cimInsts.get(array);
                if (cimMap == null) {
                    this.copIndex.remove(new ObjectPath(cop));
                    return null;
                }
                mo = (CIMInstance)cimMap.get(hs);
            } else {
                String bucketName = cop.getObjectName();
                HashMap bucket = (HashMap)this.conIndex.get(bucketName);
                Iterator it = bucket.values().iterator();
                while (it.hasNext()) {
                    addr = (CacheAddr)it.next();
                    HashMap cimMap = (HashMap)this.cimInsts.get(addr.getArray());
                    CIMInstance inst = (CIMInstance)cimMap.get(new Integer(addr.getCOPHashCode()));
                    if (!ObjectPath.objectPathsAreEqual((CIMObjectPath)inst.getObjectPath(), (CIMObjectPath)cop)) continue;
                    mo = inst;
                    break;
                }
            }
        }
        return mo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CIMInstance find(ArrayObject array, CIMObjectPath cop) {
        if (array == null || cop == null) {
            return null;
        }
        Integer hs = new Integer(cop.toString().hashCode());
        CIMInstance mo = null;
        HashMap hashMap = this.cimInsts;
        synchronized (hashMap) {
            HashMap cimMap = (HashMap)this.cimInsts.get(array);
            if (cimMap == null) {
                this.copIndex.remove(new ObjectPath(cop));
                return null;
            }
            mo = (CIMInstance)cimMap.get(hs);
        }
        return mo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CIMInstance[] enumerate(ArrayObject array) {
        Collection list;
        HashMap hashMap = this.cimInsts;
        synchronized (hashMap) {
            HashMap cimMap = (HashMap)this.cimInsts.get(array);
            if (cimMap == null || cimMap.size() < 1) {
                return null;
            }
            list = cimMap.values();
        }
        return list == null ? null : list.toArray(new CIMInstance[0]);
    }

    public CIMInstance[] enumerate(ArrayObject array, CIMObjectPath cop) {
        if (array == null) {
            return this.enumerate(cop);
        }
        if (cop == null) {
            return this.enumerate(array);
        }
        return this.enumerate(array, cop.getObjectName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CIMInstance[] enumerate(ArrayObject array, String con) {
        if (con == null) {
            return this.enumerate(array);
        }
        ArrayList<CIMInstance> list = new ArrayList<CIMInstance>();
        HashMap hashMap = this.cimInsts;
        synchronized (hashMap) {
            LinkedHashMap conMap = (LinkedHashMap)this.conIndex.get(con);
            if (conMap == null || conMap.size() < 1) {
                this.conIndex.remove(con);
                return null;
            }
            Collection col = conMap.values();
            Iterator addrs = col.iterator();
            HashMap cimMap = (HashMap)this.cimInsts.get(array);
            HashSet<Integer> hcToRemove = null;
            while (addrs != null && addrs.hasNext()) {
                CacheAddr addr = (CacheAddr)addrs.next();
                Integer hs = new Integer(addr.getCOPHashCode());
                if (cimMap == null) {
                    CacheAddr tmpADDR = (CacheAddr)conMap.get(hs);
                    WBEMDebug.trace3((String)("WOULD have removed " + tmpADDR));
                    continue;
                }
                if (!array.equals(addr.getArray())) continue;
                CIMInstance nci = (CIMInstance)cimMap.get(hs);
                if (nci != null) {
                    list.add(nci);
                    continue;
                }
                if (hcToRemove == null) {
                    hcToRemove = new HashSet<Integer>();
                }
                hcToRemove.add(hs);
                WBEMDebug.trace3((String)"CIMInstanceCache.enumerate(ArrayObject, String) found null CIM object will remove the stale index.");
            }
            if (hcToRemove != null) {
                Iterator i = hcToRemove.iterator();
                while (i.hasNext()) {
                    conMap.remove(i.next());
                }
            }
        }
        return list.size() == 0 ? null : list.toArray(new CIMInstance[0]);
    }

    public CIMInstance[] enumerate(CIMObjectPath cop) {
        if (cop == null) {
            return null;
        }
        return this.enumerate(cop.getObjectName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CIMInstance[] enumerate(String con) {
        if (con == null || "".equals(con)) {
            return null;
        }
        ArrayList<CIMInstance> list = new ArrayList<CIMInstance>();
        HashMap hashMap = this.cimInsts;
        synchronized (hashMap) {
            LinkedHashMap conMap = (LinkedHashMap)this.conIndex.get(con);
            if (conMap == null || conMap.size() < 1) {
                this.conIndex.remove(con);
                return null;
            }
            Collection col = conMap.values();
            Iterator addrs = col.iterator();
            ArrayObject prev = null;
            HashMap cimMap = null;
            HashSet<Integer> hcToRemove = null;
            while (addrs != null && addrs.hasNext()) {
                CacheAddr addr = (CacheAddr)addrs.next();
                Integer hs = new Integer(addr.getCOPHashCode());
                ArrayObject curr = addr.getArray();
                if (prev == null || !prev.equals(curr)) {
                    cimMap = (HashMap)this.cimInsts.get(curr);
                    prev = curr;
                }
                if (cimMap != null) {
                    CIMInstance nci = (CIMInstance)cimMap.get(hs);
                    if (nci != null) {
                        list.add(nci);
                        continue;
                    }
                    if (hcToRemove == null) {
                        hcToRemove = new HashSet();
                    }
                    hcToRemove.add(hs);
                    WBEMDebug.trace3((String)"CIMInstanceCache.enumerate(String) found null CIMInstance will remove it from index.");
                    continue;
                }
                if (hcToRemove == null) {
                    hcToRemove = new HashSet<Integer>();
                }
                hcToRemove.add(hs);
                WBEMDebug.trace3((String)"CIMInstanceCache.enumerate(String) found null cimMap from old array--will remove it from index.");
            }
            if (hcToRemove != null) {
                Iterator i = hcToRemove.iterator();
                while (i.hasNext()) {
                    conMap.remove(i.next());
                }
            }
        }
        return list.size() == 0 ? null : list.toArray(new CIMInstance[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized CacheAddr getCacheAddr(CIMObjectPath cop) {
        CacheAddr addr = null;
        HashMap hashMap = this.cimInsts;
        synchronized (hashMap) {
            addr = (CacheAddr)this.copIndex.get(new ObjectPath(cop));
        }
        return addr;
    }
}

