/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.se6120.internal;

import com.sun.netstorage.array.mgmt.se6120.internal.Constants;
import com.sun.netstorage.array.mgmt.se6120.internal.RequestBroker;
import com.sun.netstorage.array.mgmt.se6120.internal.SunStorEdge_6120ArrayProvider;
import com.sun.netstorage.array.mgmt.util.WBEMDebug;
import java.io.FileInputStream;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMDataType;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt16;
import javax.wbem.cim.UnsignedInt8;

public class ArrayObject
implements Constants {
    private String host;
    private int port = 80;
    private String user;
    private String password;
    private String firwareVersion = "unknown";
    private boolean useCRAM = true;
    private boolean isAlive = true;
    private int CIMStatus = 1;
    private Thread refreshThread = null;
    private boolean keepRunning = true;
    private boolean cacheBeingUpdated = false;
    private boolean pauseRefresh = false;
    private int retries = 0;
    private static final int SLEEP_A_MINUTE = 60000;
    private static final int DISCOVERY_INTERVAL_IN_MIN_DEFAULT = 5;
    private static final int STARTING_DISCOVERY_INTERVAL_IN_MIN = 5;
    private static final int DISCOVERY_MAX_RETRIES = 4;
    private int discoveryIntervalInMin = 5;
    private static String DISCOVERY_INTERVAL_IN_MIN_KEY = "ArrayObject.discoveryIntervalInMin";
    private static HashMap instances = new HashMap();
    static final int FEATURE_DISK_SCRUBBING = 1;
    static final int FEATURE_PARALLEL_INIT = 2;
    static final int FEATURE_ARRAY_HOT_SPARE = 3;
    static final int FEATURE_BOOT_R = 4;
    private int major = 0;
    private int minor = 0;
    private int patch = 0;

    private ArrayObject() {
        this.readProperties();
    }

    public void readProperties() {
        try {
            FileInputStream propStream = new FileInputStream(SunStorEdge_6120ArrayProvider.getPropertyFilePath());
            Properties props = new Properties();
            props.load(propStream);
            this.discoveryIntervalInMin = Integer.parseInt(props.getProperty(DISCOVERY_INTERVAL_IN_MIN_KEY, new Integer(5).toString()));
        }
        catch (Exception e) {
            this.discoveryIntervalInMin = 5;
            WBEMDebug.trace1((String)"Unable to load properties!", (Throwable)e);
        }
    }

    public static ArrayObject getInstance(String host, String user, String pass) {
        ArrayObject ao = (ArrayObject)instances.get(host);
        if (null == ao) {
            ao = new ArrayObject();
            ao.host = host;
        }
        ao.user = user;
        ao.password = null == pass ? "" : pass;
        instances.put(ao.host, ao);
        return ao;
    }

    public static ArrayObject getInstance(String host, int port, String user, String pass) {
        ArrayObject ao = ArrayObject.getInstance(host, user, pass);
        ao.port = port;
        return ao;
    }

    public static void removeArray(ArrayObject ao) {
        instances.remove(ao.getHost());
    }

    public String getHost() {
        return this.host;
    }

    public String getHostName() {
        String hostName = this.host;
        String ipAddress = this.host;
        if (ipAddress != null) {
            try {
                StringTokenizer ipTokenizer = new StringTokenizer(ipAddress, ".");
                byte[] ipByteArray = new byte[ipTokenizer.countTokens()];
                int i = 0;
                while (ipTokenizer.hasMoreTokens()) {
                    String ipToken = ipTokenizer.nextToken();
                    int ipValue = Integer.parseInt(ipToken);
                    ipByteArray[i] = (byte)ipValue;
                    ++i;
                }
                InetAddress inet = InetAddress.getByAddress(ipByteArray);
                hostName = inet.getHostName();
            }
            catch (Exception e) {
                WBEMDebug.trace2((String)(this + " could not get hostname "));
                hostName = this.host;
            }
        }
        return hostName;
    }

    public int getPort() {
        return this.port;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean getCRAMFlag() {
        return this.useCRAM;
    }

    public void endRefreshThread() {
        this.keepRunning = false;
        if (null != this.refreshThread) {
            this.refreshThread.interrupt();
        }
    }

    public void cacheRefreshed() {
        if (null != this.refreshThread && !this.cacheBeingUpdated) {
            this.refreshThread.interrupt();
        }
    }

    public boolean equals(Object obj) {
        boolean ret = false;
        if (null != obj && obj instanceof ArrayObject) {
            ret = this.host.equals(((ArrayObject)obj).getHost());
        }
        return ret;
    }

    public int hashCode() {
        return this.host.hashCode();
    }

    void startRefreshThread() {
        if (null != this.refreshThread) {
            return;
        }
        this.refreshThread = new Thread(new Runnable(){

            public void run() {
                while (ArrayObject.this.keepRunning) {
                    try {
                        if (!ArrayObject.this.cacheBeingUpdated) {
                            WBEMDebug.trace2((String)(ArrayObject.this + " Cache expiring... "));
                            ArrayObject.this.cacheBeingUpdated = true;
                            RequestBroker.getInstance().invalidateCache(ArrayObject.this);
                        }
                        ArrayObject.this.cacheBeingUpdated = false;
                        try {
                            int i = 0;
                            int refreshRate = ArrayObject.this.discoveryIntervalInMin;
                            while (i < refreshRate) {
                                WBEMDebug.trace2((String)(ArrayObject.this + " CIMStatus =  " + ArrayObject.this.getCIMStatus()));
                                if (ArrayObject.this.getCIMStatus() == 8 && refreshRate >= 5) {
                                    refreshRate = 5;
                                }
                                WBEMDebug.trace2((String)(ArrayObject.this + " Current refresh rate =  " + refreshRate));
                                WBEMDebug.trace2((String)(ArrayObject.this + " Refreshing in " + (refreshRate - i) + " minutes"));
                                Thread.sleep(60000L);
                                if (ArrayObject.this.pauseRefresh) continue;
                                ++i;
                            }
                        }
                        catch (InterruptedException iex) {
                            WBEMDebug.trace2((String)(ArrayObject.this + " Interrupted... "));
                            ArrayObject.this.cacheBeingUpdated = true;
                        }
                    }
                    catch (Exception ex) {
                        WBEMDebug.trace1((String)"", (Throwable)ex);
                    }
                }
            }
        });
        this.refreshThread.setName(this + " Refresh");
        this.refreshThread.setDaemon(true);
        this.refreshThread.start();
    }

    protected synchronized void pauseRefresh(boolean pause) {
        this.pauseRefresh = pause;
    }

    public boolean permitUpload() {
        return true;
    }

    public String toString() {
        return "ArrayObject:" + this.getHost();
    }

    protected void setFirmwareVersion(String firwareVersion) {
        this.major = 0;
        this.minor = 0;
        this.patch = 0;
        try {
            this.major = Integer.parseInt(firwareVersion.substring(0, 2));
            this.minor = Integer.parseInt(firwareVersion.substring(2, 4));
            this.patch = Integer.parseInt(firwareVersion.substring(4, 6));
        }
        catch (Exception ex) {
            WBEMDebug.trace2((String)("Could not parse firmware version for frimware version: " + firwareVersion), (Throwable)ex);
        }
        this.firwareVersion = firwareVersion;
    }

    protected String getFirwareVersion() {
        return this.firwareVersion;
    }

    public static boolean isFeatureSupported(int feature, int major, int minor, int patch) {
        boolean retVal = false;
        switch (feature) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                if (major <= 3 && (major != 3 || minor < 1)) break;
                retVal = true;
                break;
            }
        }
        return retVal;
    }

    public boolean isFeatureSupported(int feature) {
        return ArrayObject.isFeatureSupported(feature, this.major, this.minor, this.patch);
    }

    public CIMInstance getCIMCluster(int status, String otherStatDesc) {
        WBEMDebug.trace2((String)(this + " createCIMCluster  status = " + status));
        CIMObjectPath cop = new CIMObjectPath("SunStorEdge_6120Cluster", "\\root\\se6x20");
        CIMInstance cluster = null;
        this.setCIMStatus(status);
        try {
            CIMClass clusterClass = SunStorEdge_6120ArrayProvider.getCIMOMHandle().getClass(cop, false, true, true, null);
            cluster = clusterClass.newInstance();
            cluster.setProperty("Name", new CIMValue((Object)this.getHost()));
            cluster.setProperty("NumberOfControllerChassis", new CIMValue((Object)new UnsignedInt8(1)));
            cluster.setProperty("NumberOfExpansionChassis", new CIMValue((Object)new UnsignedInt8(0)));
            cluster.setProperty("EnabledState", new CIMValue((Object)new Integer(6)));
            Vector<Object> data = new Vector<Object>();
            data.add(new UnsignedInt16(status));
            CIMValue val = new CIMValue(data, new CIMDataType(16));
            cluster.setProperty("OperationalStatus", val);
            if (null != otherStatDesc) {
                data = new Vector();
                data.add(otherStatDesc);
                cluster.setProperty("StatusDescriptions", new CIMValue(data, new CIMDataType(22)));
            }
        }
        catch (Exception ex) {
            WBEMDebug.trace1((String)(this + " Could not create CIMCluster "), (Throwable)ex);
        }
        return cluster;
    }

    public int getStartRetries() {
        return this.retries;
    }

    public void setStartRetries(int num) {
        this.retries = num;
    }

    public boolean reachedMaxRetries() {
        return this.getStartRetries() >= 4;
    }

    public int getCIMStatus() {
        return this.CIMStatus;
    }

    public void setCIMStatus(int status) {
        this.CIMStatus = status;
        if (this.CIMStatus != 8) {
            this.setStartRetries(0);
        }
    }
}

