/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.dm.util.logic;

import com.sun.netstorage.mgmt.dm.util.logic.Key;
import java.math.BigInteger;

public abstract class XBits
implements Key {
    public static final int PARSE_AS_HEX = 16;
    private BigInteger value;

    protected abstract int getMaxBytes();

    public XBits(String hexForm) throws NumberFormatException {
        this.value = new BigInteger(hexForm, 16);
        if (this.value.bitCount() > this.getMaxBytes() * 8) {
            throw new NumberFormatException("Value was too large: \"" + hexForm + "\" (" + this.value.bitCount() + " bits) should only be " + this.getMaxBytes() * 8 + "bits");
        }
    }

    public XBits(byte[] rawForm) throws NumberFormatException {
        this.value = new BigInteger(rawForm);
        if (this.value.bitCount() > this.getMaxBytes() * 8) {
            throw new NumberFormatException("Value was too large: \"" + rawForm + "\" (" + this.value.bitCount() + " bits) should only be " + this.getMaxBytes() * 8 + "bits");
        }
    }

    public byte[] getBytes() {
        byte[] ret = this.value.toByteArray();
        if (ret.length != this.getMaxBytes()) {
            byte[] newRet = new byte[this.getMaxBytes()];
            int i = ret.length - 1;
            for (int j = this.getMaxBytes() - 1; i >= 0 && j >= 0; --i, --j) {
                newRet[j] = ret[i];
            }
            ret = newRet;
        }
        return ret;
    }

    public String toHex() {
        return this.value.toString(16);
    }

    public int compareTo(XBits val) {
        return this.value.compareTo(val.value);
    }

    public String toString() {
        return this.toHex();
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object obj) {
        return this.compareTo((XBits)obj) == 0;
    }
}

