/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.dm.util.logic;

import com.sun.netstorage.mgmt.dm.util.logic.Storable;
import java.io.File;
import java.io.RandomAccessFile;
import java.util.Vector;

public class MetaStore {
    private static MetaStore filestore = new MetaStore();
    public final String DATA_FILE = "store";
    public final String META_FILE = "metastore";
    private final int LENGTH_BUFFER = 10;
    private final int SIZE_OF_INT = 4;
    private RandomAccessFile datafile = null;
    private RandomAccessFile metafile = null;
    private int objcount = 0;
    private Vector ids = null;
    private Vector cache = null;
    private int[] size = null;
    private int[] offset = null;

    private MetaStore() {
        this.initialize();
    }

    private void initialize() {
        try {
            this.metafile = new RandomAccessFile(new File("metastore"), "rw");
            this.datafile = new RandomAccessFile(new File("store"), "rw");
            if (this.metafile.length() < 4L) {
                System.out.println("Empty meta file");
                this.metafile.writeInt(0);
                this.metafile.seek(0L);
            }
            this.objcount = this.metafile.readInt();
            this.ids = new Vector(this.objcount + 10);
            this.cache = new Vector(this.objcount + 10);
            this.size = new int[this.objcount + 10];
            this.offset = new int[this.objcount + 10];
            this.offset[0] = 0;
            for (int i = 0; i < this.objcount; ++i) {
                this.size[i] = this.metafile.readInt();
                if (i > 0) {
                    this.offset[i] = this.offset[i - 1] + (this.size[i - 1] + 4);
                }
                byte[] buffer = new byte[this.metafile.readInt()];
                this.metafile.read(buffer);
                this.ids.insertElementAt(new String(buffer), i);
                buffer = new byte[this.metafile.readInt()];
                this.metafile.read(buffer);
                this.cache.insertElementAt(Class.forName(new String(buffer)).newInstance(), i);
                this.datafile.seek(this.offset[i]);
                buffer = new byte[this.datafile.readInt()];
                this.datafile.read(buffer);
                ((Storable)this.cache.elementAt(i)).setBytes(buffer, buffer.length);
            }
        }
        catch (Exception e) {
            System.out.println("exception:" + e);
            e.printStackTrace();
        }
    }

    public static MetaStore getInstance() {
        return filestore;
    }

    public Object retrieve(String key) throws Exception {
        for (int i = 0; i < this.objcount; ++i) {
            if (!this.ids.elementAt(i).equals(key)) continue;
            return this.cache.elementAt(i);
        }
        return null;
    }

    public synchronized Object retrieve(String key, Storable instance) throws Exception {
        for (int i = 0; i < this.objcount; ++i) {
            if (!this.ids.elementAt(i).equals(key)) continue;
            if (instance.getMaxBytes() < this.size[i]) {
                throw new Exception("size mismatch: " + instance);
            }
            try {
                this.datafile.seek(this.offset[i]);
                byte[] data = new byte[this.datafile.readInt()];
                this.datafile.read(data);
                instance.setBytes(data, data.length);
                return instance;
            }
            catch (Exception e) {
                System.out.println("exception:" + e);
                e.printStackTrace();
            }
        }
        return null;
    }

    public synchronized int store(String key, Storable instance) throws Exception {
        for (int i = 0; i < this.objcount; ++i) {
            if (!((String)this.ids.elementAt(i)).equals(key)) continue;
            byte[] data = instance.getBytes();
            if (data.length > this.size[i]) {
                throw new Exception("size mismatch: " + instance);
            }
            try {
                this.datafile.seek(this.offset[i]);
                this.datafile.writeInt(data.length);
                this.datafile.write(data);
            }
            catch (Exception e) {
                System.out.println("exception:" + e);
                e.printStackTrace();
            }
            return data.length;
        }
        this.add(key, instance);
        return 0;
    }

    public synchronized void add(String key, Storable instance) throws Exception {
        int i;
        for (i = 0; i < this.objcount; ++i) {
            if (!this.ids.elementAt(i).equals(key)) continue;
            throw new Exception("key already exists");
        }
        if (this.objcount >= this.size.length || this.objcount >= this.offset.length) {
            this.metafile.close();
            this.datafile.close();
            this.initialize();
        }
        this.size[this.objcount] = instance.getMaxBytes();
        this.offset[this.objcount] = this.objcount > 0 ? this.offset[this.objcount - 1] + (this.size[this.objcount - 1] + 4) : 0;
        this.ids.insertElementAt(key, this.objcount);
        this.cache.insertElementAt(instance, this.objcount);
        ++this.objcount;
        this.metafile.seek(0L);
        this.metafile.writeInt(this.objcount);
        for (i = 0; i < this.objcount; ++i) {
            this.metafile.writeInt(this.size[i]);
            this.metafile.writeInt(((String)this.ids.elementAt(i)).getBytes().length);
            this.metafile.write(((String)this.ids.elementAt(i)).getBytes());
            this.metafile.writeInt(this.cache.elementAt(i).getClass().getName().getBytes().length);
            this.metafile.write(this.cache.elementAt(i).getClass().getName().getBytes());
        }
        if (this.objcount > 0) {
            this.datafile.setLength(this.offset[this.objcount - 1] + (this.size[this.objcount - 1] + 4));
        } else {
            this.datafile.setLength(0L);
        }
        this.store(key, instance);
    }

    public synchronized void remove(String key) throws Exception {
        int i;
        int deldex = 0;
        for (deldex = 0; deldex < this.objcount && !this.ids.elementAt(deldex).equals(key); ++deldex) {
        }
        if (deldex == this.objcount) {
            throw new Exception("key does not exist");
        }
        this.ids.removeElementAt(deldex);
        this.cache.removeElementAt(deldex);
        for (i = deldex + 1; i < this.objcount; ++i) {
            this.size[i - 1] = this.size[i];
            this.offset[i] = this.offset[i - 1] + this.size[i - 1] + 4;
        }
        if (deldex < this.objcount - 1) {
            byte[] tail = new byte[(int)this.datafile.length() - this.offset[deldex + 1]];
            this.datafile.seek(this.offset[deldex + 1]);
            this.datafile.read(tail);
            this.datafile.seek(this.offset[deldex]);
            this.datafile.write(tail);
        }
        --this.objcount;
        if (this.objcount > 0) {
            this.datafile.setLength(this.offset[this.objcount]);
        } else {
            this.datafile.setLength(0L);
        }
        this.metafile.seek(0L);
        this.metafile.writeInt(this.objcount);
        for (i = 0; i < this.objcount; ++i) {
            this.metafile.writeInt(this.size[i]);
            this.metafile.writeInt(((String)this.ids.elementAt(i)).getBytes().length);
            this.metafile.write(((String)this.ids.elementAt(i)).getBytes());
            this.metafile.writeInt(this.cache.elementAt(i).getClass().getName().getBytes().length);
            this.metafile.write(this.cache.elementAt(i).getClass().getName().getBytes());
        }
        this.metafile.setLength(this.metafile.getFilePointer());
        if (this.objcount >= this.size.length || this.objcount >= this.offset.length) {
            this.metafile.close();
            this.datafile.close();
            this.initialize();
        }
    }

    public static void main(String[] args) {
        for (int i = 0; i < MetaStore.filestore.objcount; ++i) {
            System.out.println(MetaStore.filestore.cache.elementAt(i));
        }
    }
}

