<html>

<%@page info="Tasks" language="java" pageEncoding="utf-8" contentType="text/html; charset=UTF-8"%>
<%@taglib uri="/WEB-INF/jato.tld" prefix="jato"%>
<%@taglib uri="/WEB-INF/uwc.tld" prefix="uwc"%>

<%@include file="../../uwc/js/resourceBundleUtils.js"%>

<jato:useViewBean className="com.sun.uwc.calclient.TasksViewBean">

<head>
<title><%= getLocalizedLabel(session, "uwc-calclient-tasks-title", "Calendar Tasks - Communications Express") %></title>
<script src="../uwc/js/browserVersion.js" type="text/javascript"> </script><noscript></noscript>
<script type="text/javascript">
//<!--
  if (is_ie5up) // IE5
  {
   document.write("<LINK href=<%= getLocalizedLabel(session, "skinModel", "Style-Sheet-IE", "../uwc/css/css_ie5win.css") %> type=text/css rel=stylesheet>")
  }
  else if (is_gecko) // Netscape 6/7 or Mozilla
  {
   document.write("<LINK href=<%= getLocalizedLabel(session, "skinModel", "Style-Sheet-NN", "../uwc/css/css_ns6up.css") %> type=text/css rel=stylesheet>")
  }
  else  // All others
  {
   document.write("<LINK href=<%= getLocalizedLabel(session, "skinModel", "Style-Sheet-NN", "../uwc/css/css_ns6up.css") %> type=text/css rel=stylesheet>")
  }

  function handleEnter(event) {
    if(is_ie5up) {
      if(13 == event.keyCode) {
        document.TasksInputForm.elements["SearchButton"].click();
        return false;
      }
    }
    else {
      if(13 == event.which) {
        document.TasksInputForm.elements["SearchButton"].click();
        return false;
      }
    }

    return true;
  }

//-->
</script><noscript></noscript>
</head>

<body leftmargin="0" topmargin="0" marginwidth="0" marginheight="0" class="Page" onUnload="return unloadPage();">

<jato:form name="TasksInputForm" method="post" defaultCommandChild="/Search">

<input type="hidden" name="tasksSrchMode" value="false">
<input type="hidden" name="submitType">
<jato:hidden name="SelectedDateInUTC"/>
<jato:hidden name="TimeZone"/>
<jato:hidden name="SortCriteria"/>

<table cellspacing=0 cellpadding=0 width="100%" border=0 bgcolor="#CCCCFF">
  <tr>
    <td class="SkpMst"><a href=#tabs><img src="../uwc/images/spacer.gif" height="1" width="1" border="0" alt="<%= getLocalizedLabel(session, "uwc-common-skiplink-Masthead-message", "Skip Masthead") %>"></a></td>
    <td class="SkpMst"><a href=#calendarviewtabs><img src="../uwc/images/spacer.gif" height="1" width="1" border="0" alt="<%= getLocalizedLabel(session, "uwc-common-skiplink-GlobalTabs-message", "Skip Global Tabs") %>"></a></td>
    <td class="SkpMst"><a href=#toolbar><img src="../uwc/images/spacer.gif" height="1" width="1" border="0" alt="<%= getLocalizedLabel(session, "uwc-common-skiplink-CalendarViewTabs-message", "Skip Calendar View Tabs") %>"></a></td>
    <td class="SkpMst"><a href=#searchtasks><img src="../uwc/images/spacer.gif" height="1" width="1" border="0" alt="<%= getLocalizedLabel(session, "uwc-calclient-tasks-skiplink-SearchTasks-message", "Search for Tasks") %>"></a></td>
    <td class="SkpMst"><a href=#viewmenus><img src="../uwc/images/spacer.gif" height="1" width="1" border="0" alt="<%= getLocalizedLabel(session, "uwc-calclient-tasks-skiplink-ViewMenus-message", "Jump to the view menus") %>"></a></td>
    <td class="SkpMst"><a href=#taskslist><img src="../uwc/images/spacer.gif" height="1" width="1" border="0" alt="<%= getLocalizedLabel(session, "uwc-calclient-tasks-skiplink-TasksList-message", "Skip to the Tasks List") %>"></a></td>
    <td class="SkpMst"><a href=#quickaddtask><img src="../uwc/images/spacer.gif" height="1" width="1" border="0" alt="<%= getLocalizedLabel(session, "uwc-calclient-tasks-skiplink-QuickAddTask-message", "Skip to Quick Add Task") %>"></a></td>
  </tr>
</table>

<jato:containerView name="MasterHead">
  <%@include file="/uwc/common/MasterHeadNormal.jsp"%>
</jato:containerView>

<jato:containerView name="CalApplBar">
  <%@include file="/uwc/calclient/CalApplBarNormal.jsp"%>
</jato:containerView>

<!-- Calendar view tabs are starting from here -->
<div class="Tab2"> <a name="calendarviewtabs"></a>
    <table border="0" cellspacing="0" cellpadding="0" class="Tab2Tbl" width="100%" summary="Table that contains the Calendar View Tabs">
      <tr> 
        <td colspan="19"><img src="../uwc/images/spacer.gif" width="1" height="10" alt=""></td>
      </tr>
      <tr> 
        <td colspan="13"><img src="../uwc/images/spacer.gif" width="10" height="1" alt=""></td>
        <td colspan="5" class="Tab2LineBkgd"><img src="../uwc/images/spacer.gif" width="1" height="1" alt=""></td>
        <td colspan="1"><img src="../uwc/images/spacer.gif" width="1" height="1" alt=""></td>
      </tr>
      <tr> 
        <td><img src="../uwc/images/spacer.gif" width="10" height="1" alt=""></td>
        <td class="Tab2NotSel"> 
          <div class="Tab2NotSel"><a title="<%= getLocalizedLabel(session, "uwc-calclient-toolbar-tooltip-Day", "Calendar Day View") %>" href="<%= getContextURI(request) %>/calclient/DayView?<jato:text name='ContextQueryString' escape='false'/>" class="TabLblNormal"><%= getLocalizedLabel(session, "uwc-calclient-toolbar-Day", "Day") %></a></div>
        </td>
        <td><img src="../uwc/images/dividerbar.gif" alt="" width="24" height="20"></td>
        <td class="Tab2NotSel"> 
          <div class="Tab2NotSel"><a title="<%= getLocalizedLabel(session, "uwc-calclient-toolbar-tooltip-Week", "Calendar Week View") %>" href="<%= getContextURI(request) %>/calclient/WeekView?<jato:text name='ContextQueryString' escape='false'/>" class="TabLblNormal"><%= getLocalizedLabel(session, "uwc-calclient-toolbar-Week", "Week") %></a></div>
        </td>
        <td><img src="../uwc/images/dividerbar.gif" alt="" width="24" height="20"></td>
        <td class="Tab2NotSel"> 
          <div class="Tab2NotSel"><a title="<%= getLocalizedLabel(session, "uwc-calclient-toolbar-tooltip-Month", "Calendar Month View") %>" href="<%= getContextURI(request) %>/calclient/MonthView?<jato:text name='ContextQueryString' escape='false'/>" class="TabLblNormal"><%= getLocalizedLabel(session, "uwc-calclient-toolbar-Month", "Month") %></a></div>
        </td>
        <td><img src="../uwc/images/dividerbar.gif" alt=""></td>
        <td class="Tab2NotSel"> 
          <div class="Tab2NotSel"><a title="<%= getLocalizedLabel(session, "uwc-calclient-toolbar-tooltip-Year", "Calendar Year View") %>" href="<%= getContextURI(request) %>/calclient/YearView?<jato:text name='ContextQueryString' escape='false'/>" class="TabLblNormal"><%= getLocalizedLabel(session, "uwc-calclient-toolbar-Year", "Year") %></a></div>
        </td>
		<td><img src="../uwc/images/dividerbar.gif" alt=""></td>
        <td class="Tab2NotSel"> 
          <div class="Tab2NotSel"><a title="<%= getLocalizedLabel(session, "uwc-calclient-toolbar-tooltip-Events", "Event List") %>" href="<%= getContextURI(request) %>/calclient/Events?<jato:text name='ContextQueryString' escape='false'/>" class="TabLblNormal"><%= getLocalizedLabel(session, "uwc-calclient-toolbar-Events", "Events") %></a></div>
        </td>
        <td><img src="../uwc/images/dividerbar.gif" alt="" width="24" height="20"></td>
        <td class="Tab2NotSel"> 
      <jato:content name="ShowInvitationsTab">
          <div class="Tab2NotSel"><a title="<%= getLocalizedLabel(session, "uwc-calclient-toolbar-tooltip-Invitations", "Invitations List") %>" href="<%= getContextURI(request) %>/calclient/Invitations?<jato:text name='ContextQueryString' escape='false'/>" class="TabLblNormal"><%= getLocalizedLabel(session, "uwc-calclient-toolbar-Invitations", "Invitations") %><%-- &nbsp;(<jato:text name="InvitationsCount"/>) --%></a></div>
      </jato:content>
      <jato:content name="HideInvitationsTab">
          <div class="Tab2NotSel"><%= getLocalizedLabel(session, "uwc-calclient-toolbar-Invitations", "Invitations") %><%-- &nbsp;(<jato:text name="InvitationsCount"/>) --%></div>
      </jato:content>
		</td>
		<td><img src="../uwc/images/spacer.gif" width="10" height="1" alt=""></td>
        <td class="Tab2LineBkgd"><img src="../uwc/images/spacer.gif" width="1" height="12" alt=""></td>
        <td class="Tab2Sel"><img src="../uwc/images/spacer.gif" width="10" height="1" alt=""></td>
        <td class="Tab2Sel"> 
          <div class="Tab2Sel"><span class="TabLblSel" title="<%= getLocalizedLabel(session, "uwc-calclient-toolbar-tooltip-Tasks", "Task List") %>"><%= getLocalizedLabel(session, "uwc-calclient-toolbar-Tasks", "Tasks") %></span></div>
        </td>
        <td class="Tab2Sel"><img src="../uwc/images/spacer.gif" width="10" height="1" alt=""></td>
        <td class="Tab2LineBkgd"><img src="../uwc/images/spacer.gif" width="1" height="12" alt=""></td>
        <td width="90%"><img src="../uwc/images/spacer.gif" width="10" height="1" alt=""></td>
      </tr>
      <tr> 
        <td class="Tab2LineBkgd"><img src="../uwc/images/spacer.gif" width="1" height="1" alt=""></td>
        <td colspan="13" class="Tab2LineBkgd"><img src="../uwc/images/spacer.gif" width="1" height="1" alt=""></td>
        <td colspan="3"><img src="../uwc/images/spacer.gif" width="1" height="1" alt=""></td>
        <td colspan="2" class="Tab2LineBkgd"><img src="../uwc/images/spacer.gif" width="1" height="1" alt=""></td>
      </tr>
    </table>
</div>

<!-- Error pagelet -->
<jato:containerView name="errorPlugin">
  <%@include file="/uwc/common/error.jsp"%>
</jato:containerView>

<!-- Page Title with Save Button -->
<div class="TtlTxtDiv">
<TABLE width="100%" border="0" cellspacing="0" cellpadding="0" title="">
  <TR> 
    <TD><IMG src="../uwc/images/spacer.gif" width="10" height="1" alt=""></TD>
        <TD width="100%"><SPAN class="TtlTxt"><%= getLocalizedLabel(session, "uwc-calclient-tasks-banner", "Tasks") %></SPAN></TD>
    <TD align="right"> 
  <jato:content name="NonZeroTasks">
      <jato:button styleClass="Btn1" name="Save" defaultValue=" Save " onFocus="if (this.disabled==0) this.className='Btn1Hov'" onMouseOver="if (this.disabled==0) this.className='Btn1Hov'" onMouseOut="if (this.disabled==0) this.className='Btn1'" onBlur="if (this.disabled==0) this.className='Btn1'" onClick="return getSaveConfirm();" tabIndex="1"/>
  </jato:content>
  <jato:content name="ZeroTasks">
      <INPUT class="Btn1Dis" type="submit" name="DisabledSave" value=" <%= getLocalizedLabel(session, "uwc-common-save", "Save") %> " disabled onFocus="if (this.disabled==0) this.className='Btn1Hov'" onMouseOver="if (this.disabled==0) this.className='Btn1Hov'" onMouseOut="if (this.disabled==0) this.className='Btn1'" onBlur="if (this.disabled==0) this.className='Btn1'" onClick="return false;" title="<%= getLocalizedLabel(session, "uwc-calclient-tasks-DisabledSave-title", "Save Changes to Task List has been disabled") %>" tabindex="1">
  </jato:content>
    </TD>
    <TD><IMG src="../uwc/images/spacer.gif" width="10" height="1" alt=""></TD>
  </TR>
</TABLE>
<!-- Horizontal Top/Bottom of Page Line -->
<TABLE width="100%" border="0" cellspacing="0" cellpadding="0" title="">
  <TR> 
    <TD><IMG src="../uwc/images/spacer.gif" width="10" height="1" alt=""></TD>
    <TD class="TtlLin" width="100%"><IMG src="../uwc/images/spacer.gif" width="1" height="1" alt=""></TD>
  </TR>
</TABLE>
</div>

<jato:containerView name="CalToolBar">
  <%@include file="/uwc/calclient/CalToolBarNormal.jsp"%>
</jato:containerView>

<div class="SearchDiv"> <a name="searchtasks"></a>
<table border="0" cellspacing="0" cellpadding="0" summary="Table that contains Task Search">
  <tr> 
    <td><img src="../uwc/images/spacer.gif" width="10" height="1" alt=""></td>
    <td class="CalSearchBar1"><label for="taskSearch"><span class="Lbl2"><%= getLocalizedLabel(session, "uwc-calclient-tasks-SearchTasksLabel", "Search for Tasks:") %></span></label> 
      <jato:textField name="SearchText" elementId="taskSearch" size="40" tabIndex="1" onKeyPress="return handleEnter(event);"/>
      <jato:button styleClass="Btn1" name="Search" elementId="SearchButton" defaultValue="Search" onMouseOver="if (this.disabled==0) this.className='Btn1Hov'" onFocus="if (this.disabled==0) this.className='Btn1Hov'" onMouseOut="if (this.disabled==0) this.className='Btn1'" onBlur="if (this.disabled==0) this.className='Btn1'" onClick="return handleSearch();" tabIndex="2"/>
    </td>
  </tr>
</table>
</div>

<div class="ViewDiv"> <a name="viewmenus"></a>
<table width="100%" border="0" cellspacing="0" cellpadding="0" title="">
  <tr> 
	<td><img src="../uwc/images/spacer.gif" width="10" height="1" alt=""></td>
    <td nowrap width="100%"><label for="monthSelect"><span class="Lbl2"><%= getLocalizedLabel(session, "uwc-calclient-tasks-ViewLabel", "View:") %></span></label> 
      <jato:combobox name="CurrentMonth" elementId="monthSelect" tabIndex="6"/>
      <jato:combobox name="CurrentDay" elementId="daySelect" tabIndex="7"/>
      <jato:combobox name="CurrentYear" elementId="yearSelect" tabIndex="8"/>
      &nbsp;<label for="TaskShow"><span class="Lbl2"><%= getLocalizedLabel(session, "uwc-calclient-tasks-ShowLabel", "Show:") %></span></label>
      <jato:combobox name="ViewContext" elementId="TaskShow" tabIndex="3"/>
      &nbsp;<label for="TaskType"><span class="Lbl2"><%= getLocalizedLabel(session, "uwc-calclient-tasks-TypeLabel", "Type:") %></span></label> 
      <jato:combobox name="ViewCategory" elementId="TaskType" tabIndex="4"/>
      <jato:button styleClass="Btn1" name="Go" elementId="GoButton" defaultValue=" Go " onMouseOver="if (this.disabled==0) this.className='Btn1Hov'" onFocus="if (this.disabled==0) this.className='Btn1Hov'" onMouseOut="if (this.disabled==0) this.className='Btn1'" onBlur="if (this.disabled==0) this.className='Btn1'" onClick="return handleGo();" tabIndex="5"/>
    </td>
    <td><img src="../uwc/images/spacer.gif" width="10" height="1" alt=""></td>
  </tr>
</table>
</div>

<table border="0" cellpadding="0" cellspacing="0" width="100%" summary="Table used for layout only">
  <tr>
    <td><img src="../uwc/images/spacer.gif" width="10" height="1" alt=""></td>
    <td width="98%"> 
      <div class="TableDiv"> <a name="taskslist"></a>
        <table border="0" cellpadding="0" cellspacing="0" class="Tbl" bordercolor="#cccccc" width="100%" summary="Table contains list of Tasks.">
          <tbody> 
          <tr> 
            <td scope="col" class="TblTtlTd" colspan="7"><span class="TblTtlTxt"><%= getLocalizedLabel(session, "uwc-calclient-tasks-banner", "Tasks") %></span>&nbsp;&nbsp;&nbsp; 
              <a href="javascript: void(0)" onClick="handleBackDate(); return false;" title="<jato:text name="TasksForPrevCtx"/>"><img src="<%= getLocalizedLabel(session, "skinModel", "uwc-calclient-Back-Arrow-image", "../uwc/images/back.gif") %>" width="13" height="13" align="absmiddle" title="<jato:text name="TasksForPrevCtx"/>" alt="<jato:text name="TasksForPrevCtx"/>" border="0" tabindex="11"></a>&nbsp; 
              <span class="TblTtlTxt"><jato:text name="ContextName"/>:&nbsp;<jato:text name="ContextDuration"/></span>&nbsp; 
              <a href="javascript: void(0)" onClick="handleForwardDate(); return false;" title="<jato:text name="TasksForNextCtx"/>"><img src="<%= getLocalizedLabel(session, "skinModel", "uwc-calclient-Forward-Arrow-image", "../uwc/images/forward.gif") %>" width="13" height="13" align="absmiddle" title="<jato:text name="TasksForNextCtx"/>" alt="<jato:text name="TasksForNextCtx"/>" border="0" tabindex="12"></a></td>
          </tr>
          <tr> 
            <td scope="col" class="TblActTd" colspan="2"> 
  <jato:content name="NonZeroTasks">
              <jato:button styleClass="Btn1" name="Delete" defaultValue=" Delete " onFocus="if (this.disabled==0) this.className='Btn1Hov'" onMouseOver="if (this.disabled==0) this.className='Btn1Hov'" onMouseOut="if (this.disabled==0) this.className='Btn1'" onBlur="if (this.disabled==0) this.className='Btn1'" onClick="return getDeleteConfirm();"/>
  </jato:content>
  <jato:content name="ZeroTasks">
              <input class="Btn1Dis" type="submit" name="DisabledDelete" value=" <%= getLocalizedLabel(session, "uwc-common-delete", "Delete") %> "  disabled onFocus="if (this.disabled==0) this.className='Btn1Hov'" onMouseOver="if (this.disabled==0) this.className='Btn1Hov'" onMouseOut="if (this.disabled==0) this.className='Btn1'" onBlur="if (this.disabled==0) this.className='Btn1'" onClick="return false;" title="<%= getLocalizedLabel(session, "uwc-calclient-tasks-DisabledDelete-title", "Delete Task(s) is Disabled") %>">
  </jato:content>
            </td>
            <td scope="col" class="TblActTd" colspan="5" nowrap>&nbsp;</td>
          </tr>
  <jato:content name="ZeroTasks">
          <tr> 
              <th class="TblThCl1" scope="col" nowrap><%= getLocalizedLabel(session, "uwc-calclient-tasks-Priority", "Priority") %></th>
              <th scope="col" nowrap><%= getLocalizedLabel(session, "uwc-calclient-tasks-Title", "Title") %></th>
              <th scope="col" nowrap><%= getLocalizedLabel(session, "uwc-calclient-tasks-DueDate", "Due Date") %></th>
              <th scope="col" nowrap><%= getLocalizedLabel(session, "uwc-calclient-tasks-Status", "Status") %></th>
              <th scope="col" nowrap><%= getLocalizedLabel(session, "uwc-calclient-tasks-Type", "Type") %></th>
              <th scope="col" nowrap><%= getLocalizedLabel(session, "uwc-calclient-tasks-Actions", "Actions") %></th>
          </tr>
          <tr> 
              <td scope="col" class="TblTdCl1Lst" colspan="6"><%= getLocalizedLabel(session, "uwc-calclient-tasks-NoTasksToDisplay-message", "This view does not have any tasks to display. Choose another filter or search for tasks.") %></td>
          </tr>
  </jato:content>
  <jato:content name="NonZeroTasks">
          <tr> 
            <th width="1%" nowrap class="TblThCl1"> 
              <div align="center"> 
                <input name="SelectAllTasks" type="image" value="SelectAllTasks" src="<%= getLocalizedLabel(session, "skinModel", "uwc-calclient-Select-All-image", "../uwc/images/check_all.gif") %>" alt="<%= getLocalizedLabel(session, "uwc-common-SelectAll-title", "Select All Items Displayed in Table") %>" align="top" width="15" height="13" border="0" title="<%= getLocalizedLabel(session, "uwc-common-SelectAll-title", "Select All Items Displayed in Table") %>" onclick="selectTasks(true); return false;">
                <input name="DeselectAllTasks" type="image" value="DeselectAllTasks" src="<%= getLocalizedLabel(session, "skinModel", "uwc-calclient-Deselect-All-image", "../uwc/images/uncheck_all.gif") %>" alt="<%= getLocalizedLabel(session, "uwc-common-DeselectAll-title", "Deselect All Items Displayed in Table") %>" align="top" width="15" height="13" border="0" title="<%= getLocalizedLabel(session, "uwc-common-DeselectAll-title", "Deselect All Items Displayed in Table") %>" onclick="selectTasks(false); return false;">
              </div>
            </th>
            <th <jato:content name="PriorityHdrColumnStyle"/> scope="col" nowrap><a href="#" onClick="prioritySort(); return false;" class="TblHdrLnk" title="<jato:content name="PriorityColumnTitle"/>"><%= getLocalizedLabel(session, "uwc-calclient-tasks-Priority", "Priority") %><img src="<jato:content name="PriorityColumnImage"/>" width="27" height="6" border="0"  alt="Sort Ascending (smallest values first)" title="<jato:content name="PriorityColumnTitle"/>"></a> 
            </th>
            <th width="35%" <jato:content name="TitleHdrColumnStyle"/> scope="col" nowrap><a href="#" onClick="titleSort(); return false;" class="TblHdrLnk" title="<jato:content name="TitleColumnTitle"/>"><%= getLocalizedLabel(session, "uwc-calclient-tasks-Title", "Title") %><img src="<jato:content name="TitleColumnImage"/>" width="27" height="6" border="0" alt="Sort Ascending (Aa before Zz)" title="<jato:content name="TitleColumnTitle"/>"></a></th>
            <th <jato:content name="DueDateHdrColumnStyle"/> scope="col" nowrap><a href="#" onClick="dueDateSort(); return false;" class="TblHdrLnk" title="<jato:content name="DueDateColumnTitle"/>"><%= getLocalizedLabel(session, "uwc-calclient-tasks-DueDate", "Due Date") %><img src="<jato:content name="DueDateColumnImage"/>" width="27" height="6" border="0" align="bottom" alt="Sort Ascending (oldest dates first)" title="<jato:content name="DueDateColumnTitle"/>"></a></th>
            <th <jato:content name="StatusHdrColumnStyle"/> scope="col" nowrap><a href="#" onClick="percentStatusSort(); return false;" class="TblHdrLnk" title="<jato:content name="StatusColumnTitle"/>"><%= getLocalizedLabel(session, "uwc-calclient-tasks-Status", "Status") %><img src="<jato:content name="StatusColumnImage"/>" width="27" height="6" border="0" alt="Sort Ascending (smallest values first)" title="<jato:content name="StatusColumnTitle"/>"></a></th>
<!--
            <th <jato:content name="CategoryHdrColumnStyle"/> scope="col" nowrap><a href="#" onClick="categorySort(); return false;" class="TblHdrLnk" title="<jato:content name="CategoryColumnTitle"/>"><%= getLocalizedLabel(session, "uwc-calclient-tasks-Type", "Type") %><img src="<jato:content name="CategoryColumnImage"/>" width="27" height="6" border="0" alt="Sort Ascending (Aa before Zz)" title="<jato:content name="CategoryColumnTitle"/>"></a></th>
-->
            <th scope="col" class="TblThNoWrapOnly"><%= getLocalizedLabel(session, "uwc-calclient-tasks-Type", "Type") %></th>
            <th scope="col" class="TblThNoWrapOnly"><%= getLocalizedLabel(session, "uwc-calclient-tasks-Actions", "Actions") %></th>
          </tr>
      <jato:tiledView name="TasksTiledView" type="com.sun.uwc.calclient.TasksTileView">
          <jato:hidden name="TaskCalID"/>
          <jato:hidden name="TaskUID"/>
          <jato:hidden name="TaskRID"/>
          <jato:hidden name="TaskTZN"/>
          <tr> 
            <td scope="col" <jato:content name="FirstColumnStyle"/>>
              <div align="center"> 
                <jato:content name="CanDelete">
                  <jato:checkbox name="SelectTask" elementId="SelectTask"/>
                </jato:content>
              </div>
            </td>
            <td scope="col" <jato:content name="PriorityColumnStyle"/>><jato:text name="Priority" escape="false"/></td>
        <jato:content name="IsConfidential">
            <td scope="col" <jato:content name="TitleColumnStyle"/>><%= getLocalizedLabel(session, "i18nModel", "uwc-calclient-view-Busy", "Busy") %></td>
        </jato:content>
        <jato:content name="IsNotConfidential">
            <td scope="col" <jato:content name="TitleColumnStyle"/>><a href="javascript: void(0)" class="LnkBold" onClick="openWinAutoHeight('<jato:text name="ViewTaskUrl" escape="false"/>','','scrollbars=yes,resizable=yes,width=700')"><uwc:text name="Title"/></a><br>
              <jato:content name="HasAlarm">
                <img src="<%= getLocalizedLabel(session, "skinModel", "uwc-calclient-NotifyImage", "../uwc/images/LrlNotify_1.gif") %>" width="12" height="12" border="0" hspace="2" align="absmiddle" alt="<%= getLocalizedLabel(session, "uwc-calclient-tasks-Notify", "Notify") %>" title="<%= getLocalizedLabel(session, "uwc-calclient-tasks-Notify", "Notify") %>">
              </jato:content>
              <jato:content name="IsRecurring">
                <img src="<%= getLocalizedLabel(session, "skinModel", "uwc-calclient-RecurringImage", "../uwc/images/LrlRecur_1.gif") %>" width="12" height="12" border="0" align="absmiddle" hspace="2" title="<%= getLocalizedLabel(session, "uwc-calclient-tasks-Recurring", "Recurring") %>" alt="<%= getLocalizedLabel(session, "uwc-calclient-tasks-Recurring", "Recurring") %>">
              </jato:content>
              <jato:content name="IsPublic">
                <img src="<%= getLocalizedLabel(session, "skinModel", "uwc-calclient-PublicImage", "../uwc/images/LrlPrvPub_1.gif") %>" width="12" height="12" border="0" hspace="2" title="<%= getLocalizedLabel(session, "uwc-calclient-tasks-Public", "Public") %>" alt="<%= getLocalizedLabel(session, "uwc-calclient-tasks-Public", "Public") %>"> 
              </jato:content>
              <jato:content name="IsExternal">
                <br>
                [<jato:text name="OwnerName"/>&nbsp;(<jato:text name="CalendarName"/>)]
              </jato:content>
            </td>
        </jato:content>
            <td scope="col" <jato:content name="DueDateColumnStyle"/>><jato:text name="DueDate"/>&nbsp;<jato:text name="DueTime"/></td>
            <jato:content name="IsWritable">
              <td scope="col" <jato:content name="StatusColumnStyle"/>>
                <jato:combobox name="PercentStatus" elementId="PercentStatus" onChange="setDirtyCache()"/>
                <jato:hidden name="PreviousPercentStatus"/>
              </td>
            </jato:content>
            <jato:content name="IsNotWritable">
              <td scope="col" <jato:content name="StatusColumnStyle"/>><jato:text name="PercentStatusAsText" escape="false"/></td>
            </jato:content>
            <td scope="col" <jato:content name="CategoryColumnStyle"/>><jato:text name="Category" escape="false"/></td>
            <jato:content name="IsWritable">
              <td scope="col" <jato:content name="NormalColumnStyle"/>><img src="../uwc/images/table-act-sep.gif" width="1" height="11" alt="Table Action Separator">&nbsp;&nbsp;<a href="javascript:void(0)" title="<%= getLocalizedLabel(session, "uwc-calclient-tasks-Edit-title", "Edit Task") %>" onClick="openWinAutoHeight('<jato:text name="EditTaskUrl" escape="false"/>','','scrollbars=yes,resizable=yes,width=700')" class="TblActLnk"><%= getLocalizedLabel(session, "uwc-calclient-tasks-Edit", "Edit") %></a>&nbsp;&nbsp;<img src="../uwc/images/table-act-sep.gif" width="1" height="11" alt="Table Action Separator"></td>
            </jato:content>
            <jato:content name="IsNotWritable">
              <td scope="col" <jato:content name="NormalColumnStyle"/>>&nbsp;</td>
            </jato:content>
          </tr>
      </jato:tiledView>
          <tr> 
            <td scope="col" class="TblActTdLst" colspan="2"> 
              <jato:button styleClass="Btn1" name="Delete" defaultValue=" Delete " onFocus="if (this.disabled==0) this.className='Btn1Hov'" onMouseOver="if (this.disabled==0) this.className='Btn1Hov'" onMouseOut="if (this.disabled==0) this.className='Btn1'" onBlur="if (this.disabled==0) this.className='Btn1'" onClick="return getDeleteConfirm();"/>
            </td>
            <td scope="col" class="TblActTdLst" colspan="5" align="right" nowrap>&nbsp;</td>
          </tr>
          </tbody> 
  </jato:content>
        </table>
      </div>
    </td>
    <td><img src="../uwc/images/spacer.gif" width="10" height="1" alt=""></td>
  </tr>
  <tr>
    <td>&nbsp;</td>
    <td> 

</jato:form>

<jato:form name="QuickTaskInputForm" method="post" defaultCommandChild="/QTaskAddTask">

<jato:hidden name="QTaskCalID"/> 
<jato:hidden name="QTaskCalllTTType"/> 
<jato:hidden name="QTaskTimeZone"/> 
<jato:hidden name="QTaskQuickAddTaskDefaultDateInUTC"/>

      <div class="QaddDiv"> <a name="quickaddtask"></a>

<table width="100%" border="0" cellspacing="0" cellpadding="0" class="Qadd">
  <tr> 
    <td class="BlockHeader"><span class="BlockHeaderText"><%= getLocalizedLabel(session, "uwc-calclient-tasks-AddTask", "Add Task") %></span></td>
  </tr>
  <tr> 
    <td class="QaddBkgd">
      <table border="0" cellspacing="0" cellpadding="0" width="100%" class="QaddBkgd">
        <tr> 
          <td scope="col" class="QaddTd"><label for="event_title"><span class="Lbl2"><%= getLocalizedLabel(session, "uwc-calclient-tasks-AddTask-TaskTitle", "Task Title:") %></span></label><br> 
            <jato:textField name="QTaskTitle" elementId="event_title" size="25"/> 
          </td>
          <td scope="col" class="QaddTd" nowrap><label for="QTaskNoDueDateMenu"><span class="Lbl2"><%= getLocalizedLabel(session, "uwc-calclient-tasks-AddTask-DueDate", "Due Date :") %></span></label><br>
            <input type="radio" name="QTaskNoDueDate" id="QTaskNoDueDateMenu" value="false" onClick="return activateDueDate();" checked>
            <label for="QTaskMonthMenu"></label>
            <jato:combobox name="QTaskStartDateMonth" elementId="QTaskMonthMenu"/>
            <label for="QTaskDayMenu"></label>            
            <jato:combobox name="QTaskStartDateDay" elementId="QTaskDayMenu"/>
            <label for="QTaskYearMenu"></label>            
            <jato:combobox name="QTaskStartDateYear" elementId="QTaskYearMenu"/>
            <br>
            <label for="QTaskNoDueDate"></label>
            <input type="radio" name="QTaskNoDueDate" id="QTaskNoDueDate" value="true" onClick="return disableDueDate();"><%= getLocalizedLabel(session, "uwc-calclient-tasks-AddTask-NoDueDate", "No Due Date") %> 
          </td>
          <td scope="col" class="QaddTd" nowrap><label for="QTaskNoDueTime"><span class="Lbl2"><%= getLocalizedLabel(session, "uwc-calclient-tasks-AddTask-Time", "Time:") %></span></label><br> 
		    <input type="radio" name="QTaskNoDueTime" id="QTaskNoDueTime" value="false" onClick="return activateTime();" checked>
		    <label for="QTaskHourMenu"></label>
            <jato:combobox name="QTaskStartTimeHours" elementId="QTaskHourMenu"/>
		    <label for="QTaskMinutesMenu"></label>            
            <jato:combobox name="QTaskStartTimeMinutes" elementId="QTaskMinutesMenu"/>
            <br>
                         <label for="QTaskNoDueTime"></label>
			<input type="radio" name="QTaskNoDueTime" id="QTaskNoDueTime" value="true" onClick="return disableTime();"><%= getLocalizedLabel(session, "uwc-calclient-tasks-AddTask-NoDueTime", "No Due Time") %>
          </td>
          <td scope="col" class="QaddBtnTd"> 
            <jato:button styleClass="Btn1" name="QTaskAddTask" elementId="QTaskAddTask" defaultValue="Add Task" onMouseOver="if (this.disabled==0) this.className='Btn1Hov'" onFocus="if (this.disabled==0) this.className='Btn1Hov'" onMouseOut="if (this.disabled==0) this.className='Btn1'" onBlur="if (this.disabled==0) this.className='Btn1'" onClick="return handleAddTask();"/>
          </td>
        </tr>
      </table> 
	</td>
  </tr>
</table>

      </div>
</jato:form>
    </td>
    <td><img src="../uwc/images/spacer.gif" width="10" height="1" alt=""></td>
  </tr>
</table>

<!-- Spacer -->
<TABLE width="100%" border="0" cellspacing="0" cellpadding="0" title="">
  <TR> 
    <TD><IMG src="../uwc/images/spacer.gif" width="1" height="20" alt=""></TD>
  </TR>
</TABLE>
<!-- Horizontal Top/Bottom of Page Line -->
<TABLE width="100%" border="0" cellspacing="0" cellpadding="0" title="">
  <TR> 
    <TD><IMG src="../uwc/images/spacer.gif" width="10" height="1" alt=""></TD>
    <TD class="TtlLin" width="100%"><IMG src="../uwc/images/spacer.gif" width="1" height="1" alt=""></TD>
  </TR>
</TABLE>
<!-- Bottom of Page Buttons -->
<TABLE width="100%" border="0" cellspacing="0" cellpadding="0" title="">
  <TR> 
    <TD colspan="3"><IMG src="../uwc/images/spacer.gif" width="1" height="5" alt=""></TD>
  </TR>
  <TR> 
    <TD><IMG src="../uwc/images/spacer.gif" width="10" height="1" alt=""></TD>
    <TD align="right" width="100%"> 
  <jato:content name="NonZeroTasks">
      <jato:button styleClass="Btn1" name="Save" defaultValue=" Save " onFocus="if (this.disabled==0) this.className='Btn1Hov'" onMouseOver="if (this.disabled==0) this.className='Btn1Hov'" onMouseOut="if (this.disabled==0) this.className='Btn1'" onBlur="if (this.disabled==0) this.className='Btn1'" onClick="handleSave(); return false;" tabIndex="15"/>
  </jato:content>
  <jato:content name="ZeroTasks">
      <INPUT class="Btn1Dis" type="submit" name="DisabledSave" value=" <%= getLocalizedLabel(session, "uwc-common-save", "Save") %> " disabled onFocus="if (this.disabled==0) this.className='Btn1Hov'" onMouseOver="if (this.disabled==0) this.className='Btn1Hov'" onMouseOut="if (this.disabled==0) this.className='Btn1'" onBlur="if (this.disabled==0) this.className='Btn1'" onClick="return false;" title="<%= getLocalizedLabel(session, "uwc-calclient-tasks-DisabledSave-title", "Save Changes to Task List has been disabled") %>" tabindex="1">
  </jato:content>
    </TD>
    <TD><IMG src="../uwc/images/spacer.gif" width="10" height="1" alt=""></TD>
  </TR>
</TABLE>
<!-- Spacer -->
<TABLE width="100%" border="0" cellspacing="0" cellpadding="0" title="">
  <TR> 
    <TD><IMG src="../uwc/images/spacer.gif" width="1" height="20" alt=""></TD>
  </TR>
</TABLE>

<script src="../uwc/js/scripts.js" type="text/javascript"> </script><noscript></noscript>
<script src="../uwc/js/uwcUtils.js" type="text/javascript"> </script><noscript></noscript>
<script src="../uwc/js/date_utils.js" type="text/javascript"> </script><noscript></noscript>

<script>
<!--

  var dirtyCache = 0;
  var doNotShowSaveConfirmAlert = 0;
  var isThisUnloadTrigger = 0;

  function setDirtyCache() {
    dirtyCache = 1;
  }

  function setDoNotShowSaveConfirmAlert() {
    doNotShowSaveConfirmAlert = 1;
  }

  // the uwc view url
  var uwcViewUrl = '<%=getContextURI(request)%>/calclient/Tasks?<jato:text name="ContextQueryString" escape="false"/>';

  function handleGo() {
    var monthOptions = document.TasksInputForm.elements["monthSelect"].options;
    var theMonth = monthOptions.selectedIndex;
    var theDay = document.TasksInputForm.elements["daySelect"].value;
    var theYear = document.TasksInputForm.elements["yearSelect"].value;
 
    if(false == isValidDate(theDay ,theMonth, theYear)) {
      UWCAlert('<%= getLocalizedLabel(session, "uwc-calclient-tasks-invalid-date", "In the Tasks section, please select a valid date from the View drop-down list.") %>');
      return false;
    }
 
    return true;
  }

  function handleBackDate() {
    document.TasksInputForm.submitType.value = "BackDate";
    document.TasksInputForm.elements["GoButton"].click();  
  }

  function handleForwardDate() {
    document.TasksInputForm.submitType.value = "ForwardDate";
    document.TasksInputForm.elements["GoButton"].click(); 
  }

  function getDeleteConfirm() {
    if(false == isAnyTasksExists()) {
      UWCAlert('<%= getLocalizedLabel(session, "uwc-calclient-tasks-alertMessage-NoTasksExistsToDelete", "Please select the task to be deleted.") %>');
      return false;
    }
    if(false == isAnyTaskSelected()) {
      UWCAlert('<%= getLocalizedLabel(session, "uwc-calclient-tasks-alertMessage-SelectTasksToDelete", "Please select the tasks to be deleted") %>');
      return false;
    }
    return UWCConfirm("<%= getLocalizedLabel(session, "uwc-calclient-tasks-DeleteTasksConfirmQuestion", "Are you sure you want to delete the selected tasks?") %>");
  }

  function getSaveConfirm() {
    setDoNotShowSaveConfirmAlert();
    if(false == isAnyTasksExists()) {
      UWCAlert('<%= getLocalizedLabel(session, "uwc-calclient-tasks-alertMessage-NoTasksExistsToSave", "No tasks exists!") %>');
      return false;
    }
    if(1 == dirtyCache) {
      if(1 == isThisUnloadTrigger) return UWCConfirm('<%= getLocalizedLabel(session, "uwc-calclient-tasks-SaveTasksConfirmQuestion", "Do you want to save the edited task details?") %>');
      else return true;
    }
    else {
      UWCAlert('<%= getLocalizedLabel(session, "uwc-calclient-tasks-alertMessage-NoTasksChangedToSave", "No tasks modified!") %>');
      return false;
    }
  }

  function unloadPage() {
    isThisUnloadTrigger = 1;
    if(0 == doNotShowSaveConfirmAlert) {
      if((isAnyTasksExists()) && (1 == dirtyCache)) {
        document.TasksInputForm.elements["Tasks.Save"].click();
      }
    }
  }

  function handleSearch() {
    var inputText = document.TasksInputForm.elements["Tasks.SearchText"].value;
    if((null == inputText) || ("" == trim(inputText))) {
      UWCAlert('<%= getLocalizedLabel(session, "uwc-common-EnterSearchString-alert", "Please enter a search string") %>');
      return false;
    }

    document.TasksInputForm.tasksSrchMode.value = "true";

    return true;
  }

  function handleSave() {
    document.TasksInputForm.elements["Tasks.Save"].click();
  }

  function isAnyTasksExists() {
    var elementArray = document.TasksInputForm.elements;
    for(var i=0; i < elementArray.length; i++) 
    {
      if("checkbox" == elementArray[i].type) {
        if(-1 != elementArray[i].name.indexOf("SelectTask")) {
          return true;
        }
      }
    }
    return false;
  }

  function isAnyTaskSelected() {
    var elementArray = document.TasksInputForm.elements;
    for(var i=0; i < elementArray.length; i++) 
    {
      if("checkbox" == elementArray[i].type) {
        if(-1 != elementArray[i].name.indexOf("SelectTask")) {
          if(elementArray[i].checked) {
            return true;
          }
        }
      }
    }
    return false;
  }

  function selectTasks(isChecked) {
    var elementArray = document.TasksInputForm.elements;
    for(var i=0; i < elementArray.length; i++) 
    {
      if("checkbox" == elementArray[i].type) {
        if(-1 != elementArray[i].name.indexOf("SelectTask")) {
          elementArray[i].checked = isChecked;
        }
      }
    }
  }

  var SORT_CRITERIA_PRIORITY_ASCENDING = "PriorityAscending";
  var SORT_CRITERIA_PRIORITY_DECENDING = "PriorityDescending";
  var SORT_CRITERIA_TITLE_ASCENDING = "TitleAscending";
  var SORT_CRITERIA_TITLE_DECENDING = "TitleDescending";
  var SORT_CRITERIA_DUE_DATE_ASCENDING = "DueDateAscending";
  var SORT_CRITERIA_DUE_DATE_DECENDING = "DueDateDescending";
  var SORT_CRITERIA_PERCENT_STATUS_ASCENDING = "PercentStatusAscending";
  var SORT_CRITERIA_PERCENT_STATUS_DECENDING = "PercentStatusDescending";
  var SORT_CRITERIA_CATEGORY_ASCENDING = "CategoryAscending";
  var SORT_CRITERIA_CATEGORY_DECENDING = "CategoryDescending";

  function getSortCriteria() {
    var sortCriteria = document.TasksInputForm.elements["Tasks.SortCriteria"].value;
    sortCriteria = trim(sortCriteria);
    return sortCriteria;
  }

  function setSortCriteria(theCriteria) {
    theCriteria = trim(theCriteria);
    document.TasksInputForm.elements["Tasks.SortCriteria"].value = theCriteria;
  }

  function prioritySort() {
    var sortCriteria = getSortCriteria();
    if(SORT_CRITERIA_PRIORITY_DECENDING == sortCriteria) {
      setSortCriteria(SORT_CRITERIA_PRIORITY_ASCENDING);
    }
    else if(SORT_CRITERIA_PRIORITY_ASCENDING == sortCriteria) {
      setSortCriteria(SORT_CRITERIA_PRIORITY_DECENDING);
    }
    else {
      setSortCriteria(SORT_CRITERIA_PRIORITY_ASCENDING);
    }
    document.TasksInputForm.submitType.value = "Sorting";
    document.TasksInputForm.elements["GoButton"].click();  
  }

  function titleSort() {
    var sortCriteria = getSortCriteria();
    if(SORT_CRITERIA_TITLE_DECENDING == sortCriteria) {
      setSortCriteria(SORT_CRITERIA_TITLE_ASCENDING);
    }
    else if(SORT_CRITERIA_TITLE_ASCENDING == sortCriteria) {
      setSortCriteria(SORT_CRITERIA_TITLE_DECENDING);
    }
    else {
      setSortCriteria(SORT_CRITERIA_TITLE_ASCENDING);
    }
    document.TasksInputForm.submitType.value = "Sorting";
    document.TasksInputForm.elements["GoButton"].click();  
  }

  function dueDateSort() {
    var sortCriteria = getSortCriteria();
    if(SORT_CRITERIA_DUE_DATE_DECENDING == sortCriteria) {
      setSortCriteria(SORT_CRITERIA_DUE_DATE_ASCENDING);
    }
    else if(SORT_CRITERIA_DUE_DATE_ASCENDING == sortCriteria) {
      setSortCriteria(SORT_CRITERIA_DUE_DATE_DECENDING);
    }
    else {
      setSortCriteria(SORT_CRITERIA_DUE_DATE_ASCENDING);
    }
    document.TasksInputForm.submitType.value = "Sorting";
    document.TasksInputForm.elements["GoButton"].click();  
  }

  function percentStatusSort() {
    var sortCriteria = getSortCriteria();
    if(SORT_CRITERIA_PERCENT_STATUS_DECENDING == sortCriteria) {
      setSortCriteria(SORT_CRITERIA_PERCENT_STATUS_ASCENDING);
    }
    else if(SORT_CRITERIA_PERCENT_STATUS_ASCENDING == sortCriteria) {
      setSortCriteria(SORT_CRITERIA_PERCENT_STATUS_DECENDING);
    }
    else {
      setSortCriteria(SORT_CRITERIA_PERCENT_STATUS_ASCENDING);
    }
    document.TasksInputForm.submitType.value = "Sorting";
    document.TasksInputForm.elements["GoButton"].click();  
  }

  function categorySort() {
    NotImplemented("Sorting by calendar category");
    // var sortCriteria = getSortCriteria();
    // if(SORT_CRITERIA_CATEGORY_DECENDING == sortCriteria) {
    //   setSortCriteria(SORT_CRITERIA_CATEGORY_ASCENDING);
    // }
    // else if(SORT_CRITERIA_CATEGORY_ASCENDING == sortCriteria) {
    //   setSortCriteria(SORT_CRITERIA_CATEGORY_DECENDING);
    // }
    // else {
    //   setSortCriteria(SORT_CRITERIA_CATEGORY_ASCENDING);
    // }
    // document.TasksInputForm.submitType.value = "Sorting";
    // document.TasksInputForm.elements["GoButton"].click();  
  }

//-->
</script><noscript></noscript>

<script type="text/javascript">
//<!--
// Quick add task utils

function disableDueDate() {
  document.QuickTaskInputForm.elements["QTaskMonthMenu"].disabled = true;
  document.QuickTaskInputForm.elements["QTaskDayMenu"].disabled = true;
  document.QuickTaskInputForm.elements["QTaskYearMenu"].disabled = true;
  disableTime();
  document.QuickTaskInputForm.QTaskNoDueTime[1].checked = true;
  return true;
}

function activateDueDate() {
  document.QuickTaskInputForm.elements["QTaskMonthMenu"].disabled = false;
  document.QuickTaskInputForm.elements["QTaskDayMenu"].disabled = false;
  document.QuickTaskInputForm.elements["QTaskYearMenu"].disabled = false;
  return true;
}

function disableTime() {
  document.QuickTaskInputForm.elements["QTaskHourMenu"].disabled = true;
  document.QuickTaskInputForm.elements["QTaskMinutesMenu"].disabled = true;
  return true;
}

function activateTime() {
  document.QuickTaskInputForm.elements["QTaskHourMenu"].disabled = false;
  document.QuickTaskInputForm.elements["QTaskMinutesMenu"].disabled = false;
  activateDueDate();
  document.QuickTaskInputForm.QTaskNoDueDate[0].checked = true;
  return true;
}

function handleAddTask() {
   var monthOptions = document.QuickTaskInputForm.elements["QTaskMonthMenu"].options;
   var theMonth = monthOptions.selectedIndex;
   var theDay = document.QuickTaskInputForm.elements["QTaskDayMenu"].value;
   var theYear = document.QuickTaskInputForm.elements["QTaskYearMenu"].value;

   if(false == isValidDate(theDay ,theMonth, theYear)) {
     UWCAlert('<%= getLocalizedLabel(session, "uwc-calclient-tasks-AddTask-invalid-date", "In the Add Task section, please select a valid date from the Due Date drop-down list.") %>');
     return false;
   }

   return true;
}

//-->
</script><noscript></noscript>

</body>

</jato:useViewBean>

</html>
