<html>

<%@page info="Events" language="java" contentType="text/html; charset=UTF-8"%>
<%@taglib uri="/WEB-INF/jato.tld" prefix="jato"%>
<%@taglib uri="/WEB-INF/uwc.tld" prefix="uwc"%>

<%@include file="../../uwc/js/resourceBundleUtils.js"%>
<script src="../uwc/js/uwcUtils.js" type="text/javascript"> </script><noscript></noscript>

<jato:useViewBean className="com.sun.uwc.calclient.EventsViewBean">
<head>
<title><%= getLocalizedLabel(session, "uwc-calclient-events-title", "Events - Sun&#153;ONE Unified Messaging Client") %></title>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<script src="../uwc/js/browserVersion.js" type="text/javascript"> </script>
<script src="../uwc/js/scripts.js" type="text/javascript"> </script>
<script src="../uwc/js/uwcUtils.js" type="text/javascript"> </script>
<script src="../uwc/js/date_utils.js" type="text/javascript"> </script>
<script type="text/javascript">
//<!--
  if (is_ie5up) // IE5
  {
   document.write("<LINK href=<%= getLocalizedLabel(session, "skinModel", "Style-Sheet-IE", "../uwc/css/css_ie5win.css") %> type=text/css rel=stylesheet>")
  }
  else if (is_gecko) // Netscape 6/7 or Mozilla
  {
   document.write("<LINK href=<%= getLocalizedLabel(session, "skinModel", "Style-Sheet-NN", "../uwc/css/css_ns6up.css") %> type=text/css rel=stylesheet>")
  }
  else  // All others
  {
   document.write("<LINK href=<%= getLocalizedLabel(session, "skinModel", "Style-Sheet-NN", "../uwc/css/css_ns6up.css") %> type=text/css rel=stylesheet>")
  }
//-->
</script>
</head>

<script>
<!--

  var dirtyCache = 0;
  var doNotShowSaveConfirmAlert = 0;

  function setDirtyCache() {
    dirtyCache = 1;
  }

  function setDoNotShowSaveConfirmAlert() {
    doNotShowSaveConfirmAlert = 1;
  }

  function handleGo() {
    var monthOptions = document.EventsInputForm.elements["monthSelect"].options;
    var theMonth = monthOptions.selectedIndex;
    var theDay = document.EventsInputForm.elements["daySelect"].value;
    var theYear = document.EventsInputForm.elements["yearSelect"].value;
 
    if(false == isValidDate(theDay ,theMonth, theYear)) {
      UWCAlert('<%= getLocalizedLabel(session, "uwc-calclient-events-invalid-date", "Invalid dates selected in events View section!") %>');
      return false;
    }
 
    return true;
  }

  function handleBackDate() {
    document.EventsInputForm.submitType.value = "BackDate";
    document.EventsInputForm.elements["SearchButton"].click();  
  }

  function handleForwardDate() {
    document.EventsInputForm.submitType.value = "ForwardDate";
    document.EventsInputForm.elements["SearchButton"].click(); 
  }

  function getDeleteConfirm() {
    if(false == isAnyEventsExists()) {
      UWCAlert("<%= getLocalizedLabel(session, "uwc-calclient-events-alertMessage-NoeventsExistsToDelete", "No events exists - Nothing to delete!") %>");
      return false;
    }
    if(false == isAnyEventsSelected()) {
      UWCAlert("<%= getLocalizedLabel(session, "uwc-calclient-events-alertMessage-SelectEventsToDelete", "Please select some events to delete!") %>");
      return false;
    }
    return UWCConfirm("<%= getLocalizedLabel(session, "uwc-calclient-events-DeleteEventsConfirmQuestion", "Are you sure you want to delete the selected events?") %>");
  }

  function getSaveConfirm() {
    setDoNotShowSaveConfirmAlert();
    if(false == isAnyEventsExists()) {
      UWCAlert("<%= getLocalizedLabel(session, "uwc-calclient-events-alertMessage-NoEventsExistsToSave", "No events exists - Nothing to save!") %>");
      return false;
    }
    if(1 == dirtyCache) {
      return UWCConfirm("<%= getLocalizedLabel(session, "uwc-calclient-events-SaveEventsConfirmQuestion", "Are you sure you want to save the changed events?") %>");
    }
    else {
      UWCAlert("<%= getLocalizedLabel(session, "uwc-calclient-events-alertMessage-NoEventsChangedToSave", "No events changed - Nothing to save!") %>");
      return false;
    }
  }

  function unloadPage() {
    if(0 == doNotShowSaveConfirmAlert) {
      if((isAnyEventsExists()) && (1 == dirtyCache)) {
        document.EventsInputForm.elements["Events.Save"].click();
      }
    }
  }

  function handleSearch() {
    document.EventsInputForm.EnableSearchMode.value = "true";

    var inputText = document.EventsInputForm.elements["Events.SearchText"].value;
    if((null == inputText) || ("" == trim(inputText))) {
      return UWCCoonfirm("<%= getLocalizedLabel(session, "uwc-calclient-events-BlankSearchTextConfirmQuestion", "The search text entered by you is blank. Are you sure you want to proceed with searching the events?") %>");
    }

    return true;
  }

  function handleSave() {
    document.EventsInputForm.elements["Events.Save"].click();
  }

  function isAnyEventsExists() {
    var elementArray = document.EventsInputForm.elements;
    for(var i=0; i < elementArray.length; i++) 
    {
      if("checkbox" == elementArray[i].type) {
        if(-1 != elementArray[i].name.indexOf("SelectEvent")) {
          return true;
        }
      }
    }
    return false;
  }

  function isAnyEventSelected() {
    var elementArray = document.EventsInputForm.elements;
    for(var i=0; i < elementArray.length; i++) 
    {
      if("checkbox" == elementArray[i].type) {
        if(-1 != elementArray[i].name.indexOf("SelectEvent")) {
          if(elementArray[i].checked) {
            return true;
          }
        }
      }
    }
    return false;
  }

  function selectEvents(isChecked) {
    var elementArray = document.EventsInputForm.elements;
    for(var i=0; i < elementArray.length; i++) 
    {
      if("checkbox" == elementArray[i].type) {
        if(-1 != elementArray[i].name.indexOf("SelectEvent")) {
          elementArray[i].checked = isChecked;
        }
      }
    }
  }

  var SORT_CRITERIA_TITLE_ASCENDING = "TitleAscending";
  var SORT_CRITERIA_TITLE_DECENDING = "TitleDescending";
  var SORT_CRITERIA_START_DATE_ASCENDING = "StartDateAscending";
  var SORT_CRITERIA_START_DATE_DECENDING = "StartDateDescending";
  
  function getSortCriteria() {
    var sortCriteria = document.EventsInputForm.elements["Events.SortCriteria"].value;
    sortCriteria = trim(sortCriteria);
    return sortCriteria;
  }

  function setSortCriteria(theCriteria) {
    theCriteria = trim(theCriteria);
    document.EventsInputForm.elements["Events.SortCriteria"].value = theCriteria;
  }

  
  function titleSort() {
    var sortCriteria = getSortCriteria();
    if(SORT_CRITERIA_TITLE_DECENDING == sortCriteria) {
      setSortCriteria(SORT_CRITERIA_TITLE_ASCENDING);
    }
    else if(SORT_CRITERIA_TITLE_ASCENDING == sortCriteria) {
      setSortCriteria(SORT_CRITERIA_TITLE_DECENDING);
    }
    else {
      setSortCriteria(SORT_CRITERIA_TITLE_ASCENDING);
    }
    document.EventsInputForm.submitType.value = "Sorting";
    document.EventsInputForm.elements["SearchButton"].click();  
  }

  function startDateSort() {
    var sortCriteria = getSortCriteria();
    if(SORT_CRITERIA_START_DATE_DECENDING == sortCriteria) {
      setSortCriteria(SORT_CRITERIA_START_DATE_ASCENDING);
    }
    else if(SORT_CRITERIA_START_DATE_ASCENDING == sortCriteria) {
      setSortCriteria(SORT_CRITERIA_START_DATE_DECENDING);
    }
    else {
      setSortCriteria(SORT_CRITERIA_START_DATE_ASCENDING);
    }
    document.EventsInputForm.submitType.value = "Sorting";
    document.EventsInputForm.elements["SearchButton"].click();  
  }

  
//-->
</script>

<body leftmargin="0" topmargin="0" marginwidth="0" marginheight="0" class="Page" onUnload="return unloadPage();">

<jato:form name="EventsInputForm" method="post" defaultCommandChild="/Search">

<table cellspacing=0 cellpadding=0 width="100%" border=0 bgcolor="#CCCCFF">
    <tr>
    	<td class="SkpMst"><a href=#tabs><img src="../uwc/images/spacer.gif" height="1" width="1" border="0" alt="<%=getLocalizedLabel(session, "i18nModel", "uwc-common-skiplink-Masthead-message", "Skip Masthead")%>"></a></td>
		<td class="SkpMst"><a href=#calendarviewtabs><img src="../uwc/images/spacer.gif" height="1" width="1" border="0" alt="<%=getLocalizedLabel(session, "i18nModel", "uwc-common-skiplink-GlobalTabs-message", "Skip Global Tabs")%>"></a></td>
		<td class="SkpMst"><a href=#toolbar><img src="../uwc/images/spacer.gif" height="1" width="1" border="0" alt="<%=getLocalizedLabel(session, "i18nModel", "uwc-common-skiplink-CalendarViewTabs-message", "Skip Calendar View Tabs")%>"></a></td>
		<td class="SkpMst"><a href=#searchevents><img src="../uwc/images/spacer.gif" height="1" width="1" border="0" alt="<%=getLocalizedLabel(session, "i18nModel", "uwc-common-skiplink-SearchEvents-message", "Search for Events")%>"></a></td>
		<td class="SkpMst"><a href=#jumptomenus><img src="../uwc/images/spacer.gif" height="1" width="1" border="0" alt="<%=getLocalizedLabel(session, "i18nModel","uwc-common-skiplink-jumpToDayMonthYear", "Jump to a day, month or year")%>"></a></td>
		<td class="SkpMst"><a href=#calendargrid><img src="../uwc/images/spacer.gif" height="1" width="1" border="0" alt="<%=getLocalizedLabel(session, "i18nModel","uwc-common-skiplink-calendarGrid","Skip to calendar grid")%>"></a></td>
	</tr>
</table>

<input type="hidden" name="EnableSearchMode" value="false">
<input type="hidden" name="submitType">
<jato:hidden name="SelectedDateInUTC"/>
<jato:hidden name="TimeZone"/>
<jato:hidden name="SortCriteria"/>

<script>
var theEventListViewUrl = '<%=getContextURI(request)%>/calclient/Events?<jato:text name="ContextQueryString" escape="false"/>&forceEventsList=true';

  function openEventsListView() {
    window.location = theEventListViewUrl;
  }
</script>

<jato:containerView name="MasterHead">
  <%@include file="/uwc/common/MasterHeadAnon.jsp"%>
</jato:containerView>

<jato:containerView name="CalApplBar">
  <%@include file="/uwc/calclient/CalApplBarAnon.jsp"%>
</jato:containerView>

<!-- Calendar view tabs are starting from here -->
<div class="Tab2">
    <table border="0" cellspacing="0" cellpadding="0" class="Tab2Tbl" width="100%" summary="Table that contains the Calendar View Tabs">
      <tr> 
        <td colspan="18"><img src="../uwc/images/spacer.gif" width="1" height="10" alt=""></td>
      </tr>
      <tr> 
        <td colspan="9"><img src="../uwc/images/spacer.gif" width="10" height="1" alt=""></td>
        <td colspan="5" class="Tab2LineBkgd"><img src="../uwc/images/spacer.gif" width="1" height="1" alt=""></td>
        <td colspan="4"><img src="../uwc/images/spacer.gif" width="1" height="1" alt=""></td>
      </tr>
      <tr> 
        <td><img src="../uwc/images/spacer.gif" width="10" height="1" alt=""></td>
        <td class="Tab2NotSel"> 
          <div class="Tab2NotSel"><a title="<%= getLocalizedLabel(session, "uwc-calclient-toolbar-tooltip-Day", "Calendar Day View") %>" href="<%= getContextURI(request) %>/calclient/DayView?<jato:text name='ContextQueryString' escape='false'/>&anon=true" class="TabLblNormal" onmouseout="status=';'"><%= getLocalizedLabel(session, "uwc-calclient-toolbar-Day", "Day") %></a></div>
        </td>
        <td><img src="../uwc/images/dividerbar.gif" alt="" width="24" height="20"></td>
        <td class="Tab2NotSel"> 
          <div class="Tab2NotSel"><a title="<%= getLocalizedLabel(session, "uwc-calclient-toolbar-tooltip-Week", "Calendar Week View") %>" href="<%= getContextURI(request) %>/calclient/WeekView?<jato:text name='ContextQueryString' escape='false'/>&anon=true" class="TabLblNormal" onmouseout="status=';'"><%= getLocalizedLabel(session, "uwc-calclient-toolbar-Week", "Week") %></a></div>
        </td>
        <td><img src="../uwc/images/dividerbar.gif" alt="" width="24" height="20"></td>
        <td class="Tab2NotSel"> 
          <div class="Tab2NotSel"><a title="<%= getLocalizedLabel(session, "uwc-calclient-toolbar-tooltip-Month", "Calendar Month View") %>" href="<%= getContextURI(request) %>/calclient/MonthView?<jato:text name='ContextQueryString' escape='false'/>&anon=true" class="TabLblNormal"  onmouseout="status=';'"><%= getLocalizedLabel(session, "uwc-calclient-toolbar-Month", "Month") %></a></div>
        </td>
        <td><img src="../uwc/images/dividerbar.gif" width="24" height="20" alt=""></td>
        <td class="Tab2NotSel"> 
          <div class="Tab2NotSel"><a title="<%= getLocalizedLabel(session, "uwc-calclient-toolbar-tooltip-Year", "Calendar Year View") %>" href="<%= getContextURI(request) %>/calclient/YearView?<jato:text name='ContextQueryString' escape='false'/>&anon=true" class="TabLblNormal" onmouseout="status=';'"><%= getLocalizedLabel(session, "uwc-calclient-toolbar-Year", "Year") %></a></div>
        <td><img src="../uwc/images/dividerbar.gif" width="10" height="1" alt=""></td>
        <td class="Tab2LineBkgd"><img src="../uwc/images/spacer.gif" width="1" height="12" alt=""></td>
    	<td class="Tab2Sel"><img src="../uwc/images/spacer.gif" width="10" height="1" alt=""></td>
    	<td class="Tab2Sel"> 
      		<div class="Tab2Sel"><span class="TabLblSel" title="<%= getLocalizedLabel(session, "uwc-calclient-toolbar-tooltip-Events", "Event List") %>"><%= getLocalizedLabel(session, "uwc-calclient-toolbar-Events", "Events") %></span></div>
    	</td>
    	<td class="Tab2Sel"><img src="../uwc/images/spacer.gif" width="10" height="1" alt=""></td>
    	<td class="Tab2LineBkgd"><img src="../uwc/images/spacer.gif" width="1" height="12" alt=""></td>
    	<td><img src="../uwc/images/spacer.gif" width="10" height="1" alt=""></td>
    	<td class="Tab2NotSel" width="90%" colspan="3"> 
      		<div class="Tab2NotSel"></div>
    	</td>
        </tr>
      <tr> 
        <td class="Tab2LineBkgd"><img src="../uwc/images/spacer.gif" width="1" height="1" alt=""></td>
        <td colspan="9" class="Tab2LineBkgd"><img src="../uwc/images/spacer.gif" width="1" height="1" alt=""></td>
        <td colspan="3"><img src="../uwc/images/spacer.gif" width="1" height="1" alt=""></td>
        <td colspan="5" class="Tab2LineBkgd"><img src="../uwc/images/spacer.gif" width="1" height="1" alt=""></td>
      </tr>
    </table>
</div>

<!-- Error pagelet -->
<jato:containerView name="errorPlugin">
  <%@include file="/uwc/common/error.jsp"%>
</jato:containerView>

<table width="99%" border="0" cellspacing="0" cellpadding="0">
    <tr> 
      <td width="1%">&nbsp;</td>
      <td width="99%">&nbsp;</td>
    </tr>
    <tr> 
      <td width="1%"><img src="../uwc/images/spacer.gif" width="10" height="1" alt=""></td>
      <td width="99%"><a class=Lnk href="javascript:void(0)" onClick="openEventsListView(); return false;"><%= getLocalizedLabel(session, "uwc-calclient-events-EventsList", "Events List") %></a> &gt; <span class=Lbl2><%= getLocalizedLabel(session, "uwc-calclient-events-SearchResults", "Search Results") %></span></td>
    </tr>
    <tr>
      <td width="1%">&nbsp;</td>
      <td width="99%">&nbsp;</td>
    </tr>
  </table>

<!-- Page Title with Save Button -->
<div class="TtlTxtDiv">
<TABLE width="100%" border="0" cellspacing="0" cellpadding="0">
 <tbody>
  <TR> 
    <TD><IMG src="../uwc/images/spacer.gif" width="10" height="1" alt=""></TD>
        <TD class="TtlTxt"><SPAN class="TtlTxt"><%= getLocalizedLabel(session, "uwc-calclient-events-banner", "Events") %></SPAN></TD>
    </tr>
    <tr> 
        <td><img src="../uwc/images/spacer.gif" width="10" height="1" alt=""></td>
        <td class="TtlLin" width="100%"><img src="../uwc/images/spacer.gif" width="1" height="1" alt=""></td>
    </tr>
  </tbody>
 </TABLE>
</div>

<jato:containerView name="CalToolBar">
  <%@include file="/uwc/calclient/CalToolBarAnon.jsp"%>
</jato:containerView>

<table border="0" cellspacing="0" cellpadding="0" summary="Table that contains Event Search">
  <tr>
    <td><img src="../uwc/images/spacer.gif" width="10" height="1" alt=""></td>
    <td><label for="eventSearch"><span class="Lbl2"><%= getLocalizedLabel(session, "uwc-calclient-events-SearchEventsLabel", "Search for Events:") %></span></label>
      <jato:textField name="SearchText" elementId="eventSearch" size="40" tabIndex="1"/>
      <jato:button styleClass="Btn1" name="Search" elementId="SearchButton" defaultValue="Search" onMouseOver="if (this.disabled==0) this.className='Btn1Hov'" onFocus="if (this.disabled==0) this.className='Btn1Hov'" onMouseOut="if (this.disabled==0) this.className='Btn1'" onBlur="if (this.disabled==0) this.className='Btn1'" onClick="return handleSearch();" tabIndex="2"/>
    </td>
  </tr>
</table>

<table border="0" cellpadding="0" cellspacing="0" width="100%" summary="Table used for layout only">
  <tr>
    <td><img src="../uwc/images/spacer.gif" width="10" height="1" alt=""></td>
    <td width="100%"> 
      <div class="TableDiv"> 
        <table border="0" cellpadding="0" cellspacing="0" class="Tbl" width="100%" summary="Table contains list of Events.">
          <tbody> 
          <tr>
           <td class="TblTtlTd" colspan="7"><span class="TblTtlTxt"><%= getLocalizedLabel(session, "uwc-calclient-events-SearchResults", "Search Results") %>:&nbsp;"<jato:text name="SearchText"/>"</span></td>
          </tr>
          <tr>
          <jato:content name="isNonEmptyEvents">
            <th  <jato:content name="StartDateHdrColumnStyle"/> width="31%" scope="col" nowrap><a href="#" onClick="startDateSort(); return false;" class="TblHdrLnk"  title="<jato:content name="StartDateColumnTitle"/>"  onmouseout="status=';'"><%= getLocalizedLabel(session, "uwc-calclient-tasks-StartDate", "Start Date") %><img src="<jato:content name="StartDateColumnImage"/>" width="27" height="6" border="0" align="bottom" alt="<jato:content name="StartDateColumnTitle"/>" title="<jato:content name="StartDateColumnTitle"/>"></a></th>
            <th <jato:content name="TitleHdrColumnStyle" /> scope="col" width="47%"><a href="#" onClick="titleSort(); return false;" class="TblHdrLnk" title="<jato:content name="TitleColumnTitle"/>"  onmouseout="status=';'"><%= getLocalizedLabel(session, "uwc-calclient-events-Title", "Title") %><img src="<jato:content name="TitleColumnImage"/>" width="27" height="6" border="0" alt="<jato:content name="TitleColumnTitle"/>" title="<jato:content name="TitleColumnTitle"/>"></a></th>
            <th scope="col" width="22%"><%= getLocalizedLabel(session, "uwc-calclient-events-Type", "Type") %></th>
           </tr>
    </jato:content>
    <jato:content name="isEmptyEvents">
      <tr> 
       <th scope="col" nowrap><%= getLocalizedLabel(session, "uwc-calclient-tasks-StartDate","Start Date") %></th>
       <th scope="col" nowrap><%= getLocalizedLabel(session, "uwc-calclient-events-Title","Title") %></th>
       <th scope="col" nowrap><%= getLocalizedLabel(session, "uwc-calclient-events-Type", "Type") %></th>
     </tr>
    </jato:content>
     <jato:content name="isNonEmptyEvents">
      <jato:tiledView name="EventsTiledView" type="com.sun.uwc.calclient.EventsTileView">
          <jato:hidden name="EventCalID"/>
          <jato:hidden name="EventUID"/>
          <jato:hidden name="EventRID"/>
          <tr> 
            <td <jato:content name="StartDateColumnStyle"/> width="31%" ><jato:text name="StartDate"/>
               <jato:content name="NonAllDayEventInformation">
                  <jato:text name="StartTime"/>&nbsp;<jato:text name="DurationHrs"/>
               </jato:content>
            </td>
            <td <jato:content name="TitleColumnStyle"/> width="47%">
             <jato:content name="ShowEventsLink">
              <a href="javascript: void(0)" class="LnkBold" onClick="openWinAutoHeight('<jato:text name="ViewEventUrl" escape="false"/>','','scrollbars=yes,resizable=yes,width=700')">
             </jato:content>
             <uwc:text name="Title"/>
             <jato:content name="ShowEventsLink"></a></jato:content><br>
              <jato:content name="HasAlarm">
                <img src="<%= getLocalizedLabel(session, "skinModel", "uwc-calclient-NotifyImage", "../uwc/images/LrlNotify_1.gif") %>" width="12" height="12" border="0" hspace="2" align="absmiddle" alt="<%= getLocalizedLabel(session, "uwc-calclient-events-Notify", "Notify") %>" title="<%= getLocalizedLabel(session, "uwc-calclient-events-Notify", "Notify") %>">
              </jato:content>
              <jato:content name="IsRecurring">
                <img src="<%= getLocalizedLabel(session, "skinModel", "uwc-calclient-RecurringImage", "../uwc/images/LrlRecur_1.gif") %>" width="12" height="12" border="0" align="absmiddle" hspace="2" title="<%= getLocalizedLabel(session, "uwc-calclient-events-Recurring", "Recurring") %>" alt="<%= getLocalizedLabel(session, "uwc-calclient-events-Recurring", "Recurring") %>">
              </jato:content>
              <jato:content name="IsPublic">
                <img src="<%= getLocalizedLabel(session, "skinModel", "uwc-calclient-PublicImage", "../uwc/images/LrlPrvPub_1.gif") %>" width="12" height="12" border="0" hspace="2" title="<%= getLocalizedLabel(session, "uwc-calclient-events-Public", "Public") %>" alt="<%= getLocalizedLabel(session, "uwc-calclient-events-Public", "Public") %>"> 
              </jato:content>
               <br>
              <%= getLocalizedLabel(session, "uwc-calclient-Location", "Location") %>:&nbsp;<uwc:text name="Location"/>
              <jato:content name="IsExternal">
                <br>
                [<jato:text name="OwnerName"/>&nbsp;(<jato:text name="CalendarName"/>)]
              </jato:content>
            </td>
            <td width="22%"><jato:text name="Category" escape="false"/></td>
           </tr>
      </jato:tiledView>
     </jato:content>
     <jato:content name="isEmptyEvents">
       <tr>
        <td class="TblTdCl1Lst" colspan="4"><%= getLocalizedLabel(session, "uwc-calclient-events-noevents", "This view does not have any events to display. Choose another filteror search for events") %>
        </td>
       </tr>
     </jato:content>  
         </tbody> 
        </table>
      </div>
    </td>
    <td><img src="../uwc/images/spacer.gif" width="10" height="1" alt=""></td>
  </tr>
  </table>

<!-- Spacer -->
<table width="100%" border="0" cellspacing="0" cellpadding="0" title="">
  <tr> 
    <td><img src="../uwc/images/spacer.gif" width="1" height="20" alt=""></td>
  </tr>
</table>
</jato:form>
</body>
</jato:useViewBean>
</html>
