<?xml version="1.0"?>
<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>

<xsl:stylesheet version='1.0' xmlns:xsl='http://www.w3.org/1999/XSL/Transform'>

<xsl:output method="html" version="4" encoding="UTF-8"/>

<xsl:include href="commonattributes-hidden.xsl"/>
<xsl:include href="commonjavascript.xsl"/>
<!-- <xsl:include href="search-template.xsl"/> -->
<xsl:include href="errors.xsl"/>
<xsl:include href="context.xsl"/>

<!--
*******************************************************************************
* Core of the template stylesheet select-popup_return.xsl
*******************************************************************************
-->
<xsl:template match="/">
  <html>
    <head>
      <title>
        <xsl:text>_iPlanet Address Book</xsl:text>
      </title>
      <script language="javascript">
        <xsl:call-template name="commonjavascript"/>
        <xsl:call-template name="search-popup-javascript"/>        
        
        if (opener) {
          var inputObj = parent.opener.GetSharedObject();
          var nidStr   = (inputObj.nid != null)?inputObj.nid.toString():"";
          var sidStr   = (inputObj.sid != null)?inputObj.sid.toString():"";
        }
        function returnAndClose() {
          var returnArray = new Array();
          var entryIDArray = new Array();
          <xsl:for-each select="/xslui/iab/alreadyselected/*">
            entryIDArray[entryIDArray.length] = '<xsl:value-of select="./entry/@entryID"/>';
          </xsl:for-each>
          for (var i=0; i &#60; inputObj.fieldsToReturn.length; i++) {
            var fieldValues = new Array();
            for (var j = 0; j &#60; entryIDArray.length; j++) {              
              if (eval("document.iabform['id_"+entryIDArray[j]+"_"+inputObj.fieldsToReturn[i]+"']")) {
                fieldValues[fieldValues.length] = eval("document.iabform['id_"+entryIDArray[j]+"_"+inputObj.fieldsToReturn[i]+"'].value");
              }
              else
                fieldValues[fieldValues.length] = '';
            }
            returnArray[returnArray.length] = fieldValues;
          }
          parent.opener.AcceptData(returnArray);
          parent.opener.focus();
          parent.close();
        }
      </script>
    </head>
    <body onLoad="returnAndClose()">
      <form method="post" name="iabform" action="" onsubmit="return false" >
        <xsl:apply-templates mode="hidden" select="/xslui/iab/alreadyselected/*"/>
      </form>
    </body>
  </html>
</xsl:template>
</xsl:stylesheet>
