<?xml version="1.0"?>
<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>

<xsl:stylesheet version='1.0' xmlns:xsl='http://www.w3.org/1999/XSL/Transform'>
<xsl:output method="html" version="4" encoding="UTF-8"/>

<xsl:include href="commonimages.xsl"/>
<xsl:include href="commonattributes.xsl"/>
<xsl:include href="common-uielements.xsl"/>
<xsl:include href="commonjavascript.xsl"/>
<xsl:include href="commonattributes-hidden.xsl"/>
<xsl:include href="commonattributes-list.xsl"/>
<xsl:include href="entries-list.xsl"/>
<xsl:include href="errors.xsl"/>
<xsl:include href="search-template.xsl"/>
<xsl:include href="search-images.xsl"/>
<xsl:include href="css-select.xsl"/>

<!--
*******************************************************************************
* Core of the template stylesheet select-popup.xsl
*******************************************************************************
-->
<xsl:template match="/">
  <html>
    <head>
      <title>
        <xsl:text>_SunONE Address Book</xsl:text>
      </title>
      <script language="javascript" src="../absjs/common.js"/><noscript></noscript>
      <script language="javascript" src="../absjs/integration.js"/>  <noscript></noscript>     
                
      <script src="../absjs/scripts.js"></script><noscript></noscript>
      <script src="../absjs/browserVersion.js"></script><noscript></noscript>
      <script>           
          if (is_ie5up) // IE5
          {    
           document.write('&lt;link type="text/css" rel="stylesheet" href="../absimx/ab_css_ie5win.css"&gt;');
          }
          else if (is_gecko) // Netscape 6/7 or Mozilla
          {
            document.write('&lt;link type="text/css" rel="stylesheet" href="../absimx/ab_css_ns6up.css"&gt;');
          }
          else  // All others
          {
           document.write('&lt;link type="text/css" rel="stylesheet" href="../absimx/ab_css_ns6up.css"&gt;');
          }
      </script><noscript></noscript>
      <script language="Javascript">                
        <xsl:call-template name="commonjavascript"/>
        <xsl:call-template name="search-popup-javascript"/>
         openerWin = parent.opener;
         var nidStr = null;
         var sidStr = null;
         if (openerWin) {          
           var inputObj = openerWin.GetSharedObject();          
           nidStr   = (inputObj.nid != null)?inputObj.nid.toString():"";
           sidStr   = (inputObj.sid != null)?inputObj.sid.toString():"";
         }
        function cancel() {
          document.iabform.stopsearch.value = "1";          
          location.replace('closesearchpopup.xml');
        }

        function acceptAndClose(callback) {
          var returnArray = new Array();           
          if ((inputObj.fieldsToReturn != null) &#38;&#38; (inputObj.fieldsToReturn.length > 0)) {
            for (var i=0; i &#60; inputObj.fieldsToReturn.length; i++) {
              var fieldValues = new Array();              
              var tmp = inputObj.fieldsToReturn[i]; 
              
              if( callback ) {
              //    var fieldName = tmp;
              //    if( (index=tmp.indexOf("_")) > -1 ) //it has priority attached to it
              //    {
              //      fieldName = tmp.substring(0, index);
              //      fieldName += "[@priority='" + tmp.substring(index+1) + "']";
              //    }

              //This cumbersome looking check is because combination of javascript and xsl doesn't work
                <xsl:for-each select="/xslui/iab/alreadyselected/*">
                  var fieldDataValue = null;
                    if( tmp == 'displayname' ) {
                       var displayname = "<xsl:call-template name="escape"><xsl:with-param name="text" select="entry/displayname"/></xsl:call-template>";
                       fieldDataValue = displayname;
                    }
                    else if (tmp == 'uid' ) {
                      var uid = "<xsl:call-template name="escape"><xsl:with-param name="text" select="@uid"/></xsl:call-template>";
                      fieldDataValue = uid;
                    }
                    else if (tmp == 'email_1' )
                      fieldDataValue = "<xsl:value-of select="email[@priority='1']"/>";
                    else if (tmp == 'entryid' )
                      fieldDataValue = "<xsl:value-of select="entry/@entryID"/>";
                  fieldValues[fieldValues.length] = fieldDataValue;
                </xsl:for-each>

              } else {
                buildArray(document.iabform.selectedentry, fieldValues, tmp);
                buildArray(document.iabform.alreadyselectedentry, fieldValues, tmp);
              }

              if( fieldValues.length > 0 )
                returnArray[returnArray.length] = fieldValues;
            }
            parent.opener.AcceptData(returnArray);
          }

          //document.iabform.stopsearch.value = "1";
          goToUsingForm('closesearchpopup.xml');
        }

        function ok() {           
          if (inputObj != null) {            
            var entryArray = new Array();
            var sEntry = document.iabform.selectedentry;
            var asEntry = document.iabform.alreadyselectedentry;
            var flag = buildArrayFromSelected(false, sEntry, entryArray, 'entryid');
            var asFlag = buildArrayFromSelected(false, asEntry, entryArray, 'entryid');
            
            if (flag || asFlag) {
                document.iabform.expandselectedgroup.value= 1;
                //document.iabform.stopsearch.value = "1";
                submitForm('callerAcceptData');
            }
            else {
              if ( entryArray.length == 0) {
                alert("<xsl:text>_Please select some entries first!!</xsl:text>");
                return false;
              } else { 
                acceptAndClose(false);
              }
            }
          }
        }

        function onLoad() {          
          <xsl:if test="/xslui/@uiaction = 'callerAcceptData'">
            acceptAndClose(true);
          </xsl:if> 
          document.iabform.searchstring.focus();
        }

        function writeSelect(entryID) {
          <!-- looks for the entry ID in the arrays nid and sid -->
          id = entryID.trim();
          re = new RegExp(","+id+",|^"+id+",|,"+id+"$|^"+id+"$","g");
          if (nidStr == null || (nidStr != null &#38;&#38; nidStr.search(re) == -1) ) {
            if (sidStr != null &#38;&#38; sidStr.search(re) > -1) {
              document.write('&lt;img src="<xsl:value-of select="$checkmark_skinny.gif"/>" width="16" height="16"&gt;');
            }
            else {
              document.write('&lt;input type="checkbox" name="selectedentry" value="'+entryID.replace(/\"/,"&amp;#34;")+'"&gt;');
            }
          }          
        }
      </script>  <noscript></noscript>

      <xsl:call-template name="search-template-javascript"/>
    </head>

    <body class="Popup" leftmargin="0" topmargin="0" rightmargin="0" marginwidth="0" marginheight="0" onload="onLoad()">
      <form method="post" name="iabform" action="select-popup.xml" onsubmit="return false">
        <input type="hidden" name="j_encoding" value="{/xslui/@charset}"/>
        <input type="hidden" name="uiaction" value=""/>
        <input type="hidden" name="entryid" value=""/>

        <xsl:variable name="pagedSearch" select="/xslui/iab/pagedsearch"/>
        <xsl:variable name="selectedBook" select="/xslui/iab/booklist/book[entry/@entryID = /xslui/iab/pagedsearch/searchresult/@bookid]"/> 
        <xsl:variable name="searchmode" select="boolean(/xslui/iab/entrycontext/layoutinfo/searchmode[@value='true'])"/>         
        <xsl:variable name="searchResult" select="/xslui/iab/pagedsearch/searchresult"/>        
        <xsl:variable name="htmlPrefs" select="xslui/profileinfo/xmlprofile/htmlprefs"/>
        <xsl:variable name="isCorporateAB" select="boolean(/xslui/iab/booklist/book[entry/@entryID = /xslui/iab/pagedsearch/searchresult/@bookid]/@bookremoteurl)"/>
        
        <table width="100%" border="0" cellspacing="0" cellpadding="0" title="">
          <tr>
           <td><img src="{$spacer.gif}" height="10" alt=""/></td>                        
          </tr>
        </table>
        <xsl:call-template name="contextKeeper">
          <xsl:with-param name="pagedSearch" select="/xslui/iab/pagedsearch"/>
        </xsl:call-template>
        <xsl:variable name="bookType" select="/xslui/iab/entrycontext/layoutinfo/abtype/@display"/>
        <!-- Page Title -->
        <table width="100%" border="0" cellspacing="0" cellpadding="0" title="">
          <tr>
            <td with="100%" class="PopupTitle">
             <span class="PopupTitleText">
               <xsl:choose>
               <xsl:when test="$bookType = 1">
                 <xsl:text>_Search Remote Address Book</xsl:text>
               </xsl:when>
               <xsl:otherwise> 
                 <xsl:text>_Search Address Book</xsl:text>
               </xsl:otherwise>
               </xsl:choose>
             </span>
            </td>  
          </tr>
        </table>
       
       <xsl:variable name="personalab" select="/xslui/iab/booklist/book[string-length(@bookurl) &gt; 0]"/>
       <xsl:variable name="corporateab" select="/xslui/iab/booklist/book[string-length(@corporatedir) &gt; 0]"/>        
        
       <xsl:variable name="error" select="/xslui/errormessages/error"/>
       <xsl:apply-templates select="$error" mode="plain">                                                        
          <xsl:with-param name="type" >
           <xsl:choose>     
            <xsl:when test="$error/@errnum=7">
              <xsl:value-of select="'warning'"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:value-of select="'error'"/>
            </xsl:otherwise>
           </xsl:choose>
         </xsl:with-param>          
        </xsl:apply-templates>          
          
        <xsl:call-template name="search-template-searchbar">
          <xsl:with-param name="bookList" select="/xslui/iab/booklist"/>
          <xsl:with-param name="bookType" select="$bookType"/>
          <xsl:with-param name="selectedBook" select="$selectedBook"/>
          <xsl:with-param name="selectedBookID">
            <xsl:choose>
              <xsl:when test="$searchmode">
                 <xsl:value-of select="$selectedBook/entry/@entryID"/>
              </xsl:when>
              <xsl:when test="$bookType = 0">
                <xsl:value-of select="/xslui/iab/booklist/book[string-length(@bookurl) &gt; 0]/entry/@entryID"/>          
              </xsl:when>
              <xsl:when test="$bookType = 1">
                <xsl:value-of select="/xslui/iab/booklist/book[string-length(@corporatedir) &gt; 0]/entry/@entryID"/> 
              </xsl:when>
              <xsl:otherwise>
                 <xsl:value-of select="$selectedBook/entry/@entryID"/>
              </xsl:otherwise>
              </xsl:choose>   
          </xsl:with-param>
          <xsl:with-param name="searchmode" select="$searchmode"/>               
          <xsl:with-param name="popup" select="true()"/>
          <xsl:with-param name="showBookList" select="boolean(/xslui/iab/entrycontext/layoutinfo/ablist[@display='1'])"/>            
        </xsl:call-template>        
        
      <table border="0" cellpadding="0" cellspacing="0" width="100%" title="">
      <tr>        
        <td><img src="{$spacer.gif}" width="10" height="1" alt=""/></td> 
        <td width="98%"> 
        <div class="TableDiv"> 
        <table class="TblMail" border="0" cellpadding="0" cellspacing="0" width="100%" title="">                  
        <xsl:call-template name="search-template-header">          
          <xsl:with-param name="header">
             <xsl:choose>
               <xsl:when test="not($searchmode) and $bookType = 0">
                 <xsl:copy-of select="$personalab/entry/displayname"/>          
               </xsl:when>
               <xsl:when test="not($searchmode) and $bookType = 1">
                  <xsl:copy-of select="$corporateab/entry/displayname"/> 
               </xsl:when>
               <xsl:otherwise>
                 <xsl:copy-of select="$selectedBook/entry/displayname"/>
               </xsl:otherwise>
             </xsl:choose>
          </xsl:with-param>
          <xsl:with-param name="searchmode" select="$searchmode"/>
          <xsl:with-param name="searchCriteria" select="$searchResult/@filter"/>
          <xsl:with-param name="popup" select="true()"/>        
        </xsl:call-template>                
        
        <xsl:choose>          
          <xsl:when test="$searchmode">
           <tr>
           <xsl:call-template name="search-template-paging">
             <xsl:with-param name="searchresult" select="$searchResult"/>            
             <xsl:with-param name="tdClass" select="'TblActTd'"/>
           </xsl:call-template> 
           </tr>     
          </xsl:when>
          <xsl:otherwise>
           <tr>
           <td class="TblActTd" colspan="4">
             <xsl:attribute name="nowrap"/>
             <xsl:text>&nbsp;</xsl:text>
           </td>
           </tr>
          </xsl:otherwise>
        </xsl:choose>

        <xsl:choose>
          <xsl:when test="$searchResult/@error">
            <xsl:value-of select="$searchResult/@error"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:variable name="layoutinfo" select="/xslui/iab/entrycontext[@formentryname='layoutinfo']/layoutinfo"/>
            <xsl:if test="$layoutinfo">
              <input type="hidden" name="prefix" value="wcfg_"/>
              <input type="hidden" name="wcfg_entrytype" value="layoutinfo"/>
              <input type="hidden" name="wcfg_ablist" value="{/xslui/iab/entrycontext/layoutinfo/ablist/@display}"/>
              <input type="hidden" name="wcfg_showconf" value="{/xslui/iab/entrycontext/layoutinfo/showconf/@value}"/>
              <input type="hidden" name="wcfg_abtype" value="{/xslui/iab/entrycontext/layoutinfo/abtype/@display}"/>
              <input type="hidden" name="wcfg_buttonlabel" value="{/xslui/iab/entrycontext/layoutinfo/buttonlabel/@display}"/>
              <input type="hidden" name="wcfg_searchmode" value="{/xslui/iab/entrycontext/layoutinfo/searchmode/@value}"/>              
              <xsl:for-each select="$layoutinfo/displayelt">
                <input type="hidden" name="wcfg_col{./@order}" value="{.}"/>
              </xsl:for-each> 
            </xsl:if>      
                       
            <xsl:call-template name="search-template-searchresult">
              <xsl:with-param name="pagedSearch" select="/xslui/iab/pagedsearch"/>              
              <xsl:with-param name="selectedbook" select="$selectedBook"/>
              <xsl:with-param name="searchmode" select="$searchmode"/>                              
              <xsl:with-param name="formaction" select="'select-popup.xml'"/>
              <xsl:with-param name="popup" select="true()"/>
              <xsl:with-param name="linkOnIcon" select="false()"/>
              <xsl:with-param name="displayAttr1">
                <xsl:choose>
                  <xsl:when test="boolean($layoutinfo)">
                    <xsl:value-of select="$layoutinfo/displayelt[@order='1']" /> 
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:value-of select="'dnnolink'" /> 
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:with-param>
              <xsl:with-param name="displayAttr2">
                <xsl:choose>
                  <xsl:when test="boolean($layoutinfo)">
                    <xsl:value-of select="$layoutinfo/displayelt[@order='2']" /> 
                  </xsl:when>
                  <xsl:otherwise>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:with-param>
              <xsl:with-param name="displayAttr3">
                <xsl:choose>
                  <xsl:when test="boolean($layoutinfo)">
                    <xsl:value-of select="$layoutinfo/displayelt[@order='3']" /> 
                  </xsl:when>
                  <xsl:otherwise>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:with-param>
              <xsl:with-param name="displayAttr4">
                <xsl:choose>
                  <xsl:when test="boolean($layoutinfo)">
                    <xsl:value-of select="$layoutinfo/displayelt[@order='4']" /> 
                  </xsl:when>
                  <xsl:otherwise>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:with-param>
              <xsl:with-param name="displayAttr5">
                <xsl:choose>
                  <xsl:when test="boolean($layoutinfo)">
                    <xsl:value-of select="$layoutinfo/displayelt[@order='5']" /> 
                  </xsl:when>
                  <xsl:otherwise>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:with-param>
              <xsl:with-param name="displayAttr6">
                <xsl:choose>
                  <xsl:when test="boolean($layoutinfo)">
                    <xsl:value-of select="$layoutinfo/displayelt[@order='6']" /> 
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:value-of select="''" /> 
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:with-param>
              <xsl:with-param name="displayAttr7">
                <xsl:choose>
                  <xsl:when test="boolean($layoutinfo)">
                    <xsl:value-of select="$layoutinfo/displayelt[@order='7']" /> 
                  </xsl:when>
                  <xsl:otherwise>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:with-param>
            </xsl:call-template>
          </xsl:otherwise>
        </xsl:choose>
             
           
       <xsl:variable name="totalentries" select="number($searchResult/@totalentries)"/>       
        <xsl:choose>          
          <xsl:when test="$searchmode and $totalentries > 0">
           <xsl:call-template name="search-template-alreadyselected">
            <xsl:with-param name="alreadySelected" select="/xslui/iab/alreadyselected"/>
           </xsl:call-template>
           <tr>           
           <xsl:call-template name="search-template-paging">
             <xsl:with-param name="searchresult" select="$searchResult"/>            
             <xsl:with-param name="tdClass" select="'TblActTdLst'"/>
           </xsl:call-template> 
           </tr>     
          </xsl:when>
          <xsl:when test="$totalentries=0">
          <tr>
           <td colspan="4">
            <xsl:attribute name="class"><xsl:value-of select="'TblTdCl1Lst'"/></xsl:attribute> 
            <xsl:text>_No cards found. Verify or review your search criteria.</xsl:text>
           </td>
           </tr>
           <xsl:call-template name="search-template-alreadyselected">
            <xsl:with-param name="alreadySelected" select="/xslui/iab/alreadyselected"/>
           </xsl:call-template>
          </xsl:when>
          <xsl:otherwise>
           <tr>
           <td colspan="4">
            <xsl:attribute name="class"><xsl:value-of select="'TblTdCl1Lst'"/></xsl:attribute> 
            <xsl:text>_This table contains no cards. Use Search to view cards.</xsl:text>
           </td>
           </tr>
          </xsl:otherwise>
        </xsl:choose>      
       
        </table>
        </div>
       </td>      
       <td><img src="{$spacer.gif}" width="10" height="1" alt=""/></td>
      </tr>
      </table>        
      </form>
    </body>
  </html>
</xsl:template>


<!--
*******************************************************************************
* This template displays the check mark for the already selected items in the list
*******************************************************************************
-->
<xsl:template name="displaySelect">
  <td width="5%" align="center" class="TblTdCl1">
    <xsl:choose>
      <xsl:when test="/xslui/iab/alreadyselected/*[entry/@entryID = current()/entry/@entryID]">
        <img src="{$checkmark_skinny.gif}" width="12" height="18">
          <xsl:attribute name="alt">
            <xsl:text>_Already Selected</xsl:text>
          </xsl:attribute>
        </img>
      </xsl:when>
      <xsl:otherwise>

      <script language="javascript">
         writeSelect("<xsl:call-template name="escape"><xsl:with-param name="text" select="./entry/@entryID"/></xsl:call-template>")
      </script><noscript></noscript>
<!--
        <xsl:choose>
          <xsl:when test="/xslui/iab/alreadymembers/entry[@entryID = current()/entry/@entryID]">
            <img src="{$checkmark_skinny.gif}" width="12" height="18">
              <xsl:attribute name="alt">
                <xsl:text>_Already in group</xsl:text>
              </xsl:attribute>
            </img>
          </xsl:when>
          <xsl:when test="/xslui/iab/unselectable/entry[@entryID = current()/entry/@entryID]">
            <xsl:text>&nbsp;</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <input type="checkbox" name="selectedentry">
              <xsl:attribute name="value">
                <xsl:value-of select="entry/@entryID"/>
              </xsl:attribute>
            </input>
          </xsl:otherwise>
        </xsl:choose> 
-->
      </xsl:otherwise>
    </xsl:choose>
  </td>
</xsl:template>

<!--
*******************************************************************************
* This prints the error messages on the search page
* @param err The error element from which to extract the error code
*******************************************************************************
-->
<xsl:template name="error-message">
  <xsl:param name="err" select="." />

  <xsl:choose>
  <xsl:when test="$err/@errnum = '7'">            
      <script> printLocalizedLabel("<xsl:text>_Min Char Warning</xsl:text>", new Array("<xsl:value-of select="/xslui/iab/booklist/book[entry/@entryID = $err/@bookid]/@wildcardsearch"/>"));</script>  <noscript></noscript>    
  </xsl:when>
  <xsl:when test="$err/@errnum = '286'">
      <xsl:text>_Timeout exceeded</xsl:text>
      <xsl:text>&nbsp;</xsl:text>
  </xsl:when>
  <xsl:when test="$err/@errnum = '512'">
      <xsl:text>_Search Limit Exceeded</xsl:text>
      <xsl:text>&nbsp;</xsl:text>
  </xsl:when>
  <xsl:otherwise>
     <xsl:text>_Unknown error (</xsl:text>
     <xsl:value-of select="$err/@errnum" /> 
     <xsl:text>)</xsl:text>
     <xsl:if test="$err/@rawmsg">
       <br/>
       <xsl:value-of select="$err/@rawmsg" />&nbsp;
     </xsl:if> 
  </xsl:otherwise>
  </xsl:choose>
</xsl:template> 


</xsl:stylesheet>
