<?xml version="1.0"?>
<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>

<xsl:stylesheet version='1.0' xmlns:xsl='http://www.w3.org/1999/XSL/Transform'>

<xsl:output method="html" version="4" encoding="UTF-8"/>

<xsl:include href="banner.xsl"/>
<xsl:include href="commonimages.xsl"/>
<xsl:include href="commonjavascript.xsl"/>
<xsl:include href="commonattributes-hidden.xsl"/>
<xsl:include href="common-uielements.xsl"/>
<xsl:include href="css-select.xsl"/>
<xsl:include href="errors.xsl"/>

<!--
*******************************************************************************
*
-->

<xsl:template name="error-message">
  <xsl:param name="err" select="." />
  <script> 
      var displayname = "<xsl:call-template name="escape"><xsl:with-param name="text" select="/xslui/iab/booklist/book/entry[@entryID = $err/@bookid]/displayname"/></xsl:call-template>";
  </script>
  <xsl:choose>
    <xsl:when test="$err/@errnum = '0'">
     <script>
      var posParams = new Array('<xsl:value-of select="$err/@nbimported"/>', '<xsl:value-of select="$err/@importtype"/>', displayname); var sourcestr = "<xsl:text>_Import Success Message</xsl:text>"; printLocalizedLabel(sourcestr, posParams);</script>
    </xsl:when>
    <xsl:when test="$err/@errnum = '64'">
       <script>printLocalizedLabel("<xsl:text>_Import Failure Message</xsl:text>", new Array('<xsl:value-of select="$err/@importtype"/>', displayname));</script> 
       <br/>
        <xsl:choose>
        <xsl:when test="$err/@nbimported != '0'">
          <script>printLocalizedLabel("<xsl:text>_Partial Import Success Message</xsl:text>", new Array('<xsl:value-of select="$err/@nbimported"/>', '<xsl:value-of select="$err/@nbbadentries"/>'));</script>          
          &nbsp;<xsl:text>_These entries may be empty or corrupted.</xsl:text>
        </xsl:when>
        <xsl:otherwise>
          <xsl:text>_The file you submitted may be of an incorrect type or corrupted.</xsl:text>
        </xsl:otherwise>
        </xsl:choose>
    </xsl:when>
    <xsl:when test="$err/@errnum = '272' or $err/@errnum = '271'">      
      <script>printLocalizedLabel("<xsl:text>_Import Failure Message</xsl:text>", new Array('<xsl:value-of select="$err/@importtype"/>', displayname));</script> 
      <br/>
      <xsl:text>_The file to import is empty or does not exist.</xsl:text>
    </xsl:when>    
  </xsl:choose>
  <xsl:if test="$err/@rawmsg">
    <br/><br/>
    <xsl:value-of select="$err/@rawmsg" />&nbsp;
  </xsl:if> 
</xsl:template> 

<!--
*****************************************************************************
* This template displays the import/export page.
-->

<xsl:template match="/">  
<html>
<head> 
  <title>
    <xsl:text>Import/Export</xsl:text>
  </title>
  <script src="../absjs/browserVersion.js"></script>
  <script src="../absjs/scripts.js"></script>
  <script>      
 
  if (is_ie5up) // IE5
  {    
   document.write('&lt;link type="text/css" rel="stylesheet" href="../absimx/ab_css_ie5win.css"&gt;');
  }
  else if (is_gecko) // Netscape 6/7 or Mozilla
  {
    document.write('&lt;link type="text/css" rel="stylesheet" href="../absimx/ab_css_ns6up.css"&gt;');
  }
  else  // All others
  {
   document.write('&lt;link type="text/css" rel="stylesheet" href="../absimx/ab_css_ns6up.css"&gt;');
  }
  </script>

  <script language="javascript" src="../absjs/common.js"/>
  <script language="javascript">
    <xsl:call-template name="commonjavascript"/>
    <xsl:call-template name="bannerScripts"/>
    <!-- JavaScript executed on an exportAB click-->
    function exportAB() {      
      var ext = '';
      var exportType = getSelectValue(document.iabform.exportformat);
      if(exportType == "ldif") {
        ext = "ldif";
      } else if(exportType == "vcard") {
      	ext = "vcf";
      }
      else {
        ext = exportType.substring(0,3);
      }
      document.iabform.action='iab'+exportType+'.'+ext;
      submitForm('');
    }
    
    function importAB() {
      if(document.iabform.file.value != '') {        
        submitForm('import') 
      }
      else alert("<xsl:text>_No file has been selected to be imported</xsl:text>");               
    }

    function help() {
        var helpurl = '<xsl:value-of select="/xslui/@contexturi"/>/help/<xsl:text>_languagepath</xsl:text>/addressbk/imptxprt.html';
        openhelp(helpurl);
    }
    function done() {
     var err = '<xsl:value-of select="/xslui/errormessages/error/@errnum"/>';

     if( err != null  &#38;&#38; err != '') {
       var reloadWin = parent.opener.parent;

       if( !reloadWin )
       reloadWin = parent.opener;

       reloadWin.location.href = reloadWin.location.href;
       reloadWin.focus();
     }

     parent.close();
    }    

  </script>        
</head> 
<body leftmargin="0" topmargin="0" rightmargin="0" marginwidth="0" marginheight="0">
<form method="post" name="iabform" enctype="multipart/form-data">
  <input type="hidden" name="j_encoding" value="{/xslui/@charset}"/>
  <input type="hidden" name="uiaction" value=""/>
  <input type="hidden" name="bookid" value="{/xslui/iab/pagedsearch/searchresult/@bookid}"/>
  <table width="100%" border="0" cellspacing="0" cellpadding="0" summary="This table contains the page title.">
    <tbody>
      <tr>
      <td class="PopupTitle" width="100%">
      <span class="PopupTitleText"><xsl:text>_Import and Export Address Book</xsl:text></span>
      </td>
    </tr>
    </tbody>
  </table>
  <xsl:apply-templates select="/xslui/errormessages/error" mode="plain">  
    <xsl:with-param name="type">
      <xsl:choose>
      <xsl:when test="/xslui/errormessages/error/@errnum=0">
        <xsl:value-of select="'information'"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="'error'"/>
      </xsl:otherwise>
      </xsl:choose>
    </xsl:with-param>
  </xsl:apply-templates>
  
  <table width="100%" border="0" cellspacing="0" cellpadding="0">
    <tr>
      <td align="right"><img src="../absimx/required.gif" width="7" height="14">
        <xsl:attribute name="alt">
         <xsl:text>_Indicates a required field</xsl:text>
        </xsl:attribute>
        </img>
        <xsl:text>_Indicates a required field</xsl:text>
       <img src="{$spacer.gif}" alt="" width="10" height="15"/></td>
    </tr>
    <tr> 
      <td class="SectionHeader"><span class="SectionHeader"><xsl:text>_Import</xsl:text></span></td>
    </tr>
  </table>
  <table class="FormInputTable" width="100%" border="0" cellspacing="0" cellpadding="0" summary="This table contains contact properties">
    <tr> 
      <td class="PropLabel" width="20%"><span class="Lbl2"><label for="importfromfile">
      <img src="../absimx/required.gif" width="7" height="14">
        <xsl:attribute name="alt">
         <xsl:text>_Indicates a required field</xsl:text>
        </xsl:attribute>
      </img>
       &nbsp;<xsl:text>_Import from File</xsl:text>:</label></span> </td>
      <td class="PropInput" width="80%"> 
        <input type="file" name="file" size="25" tabindex="1"/>
      </td>
    </tr>
    <tr> 
      <td class="PropLabel" align="top" width="20%"><span class="Lbl2"><label for="Importformat">
      <xsl:text>_Import Format</xsl:text>: </label></span> </td>
      <td class="PropInput" width="80%"> 
        <select name="importformat" tabindex="2">
          <option value="ldif"><xsl:text>_Netscape Ldif</xsl:text></option>
          <option value="csvus"><xsl:text>_Outlook CSV</xsl:text></option>
          <option value="iabs"><xsl:text>_SunONE CSV</xsl:text></option>
          <option value="vcard"><xsl:text>_vCard</xsl:text></option>
        </select>
      </td>
    </tr>
    <tr> 
      <td width="20%">&nbsp;</td>
      <td class="PropInput" width="80%"> 
        <input class="Btn1" type="button" name="Button" id="button" onmouseover="if (this.disabled==0) this.className='Btn1Hov'" onfocus="if (this.disabled==0) this.className='Btn1Hov'" onmouseout="if (this.disabled==0) this.className='Btn1'" onblur="if (this.disabled==0) this.className='Btn1'" onClick="javascript:importAB();" tabindex="3">
          <xsl:attribute name="value">
            <xsl:text>_Import</xsl:text>
          </xsl:attribute>
          <xsl:attribute name="title">
            <xsl:text>_Import Address Book</xsl:text>
          </xsl:attribute>
        </input>
	  </td>
    </tr>
  </table>
  <table width="100%" border="0" cellspacing="0" cellpadding="0">
    <tr> 
     <td class="PropLabel" colspan="5"><img src="{$spacer.gif}" alt="" width="10" height="8"/></td>
    </tr>
    <tr> 
     <td colspan="5">
	   <table width="100%" border="0" cellspacing="0" cellpadding="0">
        <tr> 
          <td width="1%"><img src="{$spacer.gif}" width="10" height="5"/></td>
          <td width="98%" class="SectionDivider"><img src="{$spacer.gif}" alt="" width="1" height="5"/></td>
          <td width="1%"><img src="{$spacer.gif}" alt="" width="10" height="5"/></td>
        </tr>
      </table>
	 </td>
  </tr>
  <tr> 
    <td class="SectionHeader" colspan="3"><span class="SectionHeader"><xsl:text>_Export</xsl:text></span></td>
  </tr>
  </table>
  <table class="FormInputTable" width="100%" border="0" cellspacing="0" cellpadding="0" summary="This table contains contact properties">
    <tr> 
      <td class="PropLabel" align="top" width="20%"><span class="Lbl2"><label for="exportformat">
      <xsl:text>_Export Format</xsl:text>: </label></span> </td>
      <td class="PropInput" width="80%"> 
        <select name="exportformat" tabindex="4">
          <option value="ldif"><xsl:text>_Netscape Ldif</xsl:text></option>
          <option value="csvus"><xsl:text>_Outlook CSV</xsl:text></option>
          <option value="iabs"><xsl:text>_SunONE CSV</xsl:text></option>
          <option value="vcard"><xsl:text>_vCard</xsl:text></option>
        </select>
      </td>
    </tr>
    <tr> 
      <td width="20%">&nbsp;</td>
      <td class="PropInput" width="80%"> 
        <input class="Btn1" type="button" name="Button2" id="button" onMouseOver="if (this.disabled==0) this.className='Btn1Hov'" onFocus="if (this.disabled==0) this.className='Btn1Hov'" onMouseOut="if (this.disabled==0) this.className='Btn1'" onBlur="if (this.disabled==0) this.className='Btn1'" onClick="javascript:exportAB()" tabindex="5">
        <xsl:attribute name="value">
            <xsl:text>_Export</xsl:text>
          </xsl:attribute>
          <xsl:attribute name="title">
            <xsl:text>_Export Address Book</xsl:text>
          </xsl:attribute>
        </input>
      </td>
    </tr>
  </table>   
  </form>
</body>
</html>
</xsl:template>
</xsl:stylesheet>
