<?xml version="1.0"?>
<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>
<!--
*******************************************************************************
* This template formats an exports an address book in a csv format.
*******************************************************************************
-->
<xsl:stylesheet version='1.0' xmlns:xsl='http://www.w3.org/1999/XSL/Transform'>

<xsl:output method="text" encoding="UTF-8" omit-xml-declaration="yes"/>

<xsl:include href="common-export.xsl"/>
 
 <!--
 * Output CSV fields name in english. This is the first line of the exported csv file
 * To have these fields name in another language replace the text by the text of your choice.
 -->
<xsl:template name="fields-name-export-csv-iabs">
  <xsl:text>First Name,Middle Name,Last Name,Company,Department,Job Title,Business Street,Business City,Business State,Business Postal Code,Business Country,Home Street,Home City,Home State,Home Postal Code,Home Country,Business Fax,Business Phone,Home Phone,Mobile Phone,Pager,Anniversary,Birthday,E-mail Address,E-mail 2 Address,E-mail 3 Address,Notes,Office Location,Personal Web Page,Business Web Page,Name,IM1ID,IM2ID,IM3ID,IM1Service,IM2Service,IM3Service,inetCalendar,inetFreeBusy,otherDate,otherDateDescr,campus,building,floor,hphoneprio,wphoneprio,mphoneprio,pphoneprio,fphoneprio,mailtype1,mailtype2,mailtype3</xsl:text>
  <xsl:text>&#xA;</xsl:text>
</xsl:template>

 <!--
 * Output all iabs data
 -->
<xsl:template name="data-export-csv-iabs">
  <xsl:for-each select="/xslui/simplesearch/searchresult/abperson">
    <xsl:text>&quot;</xsl:text>
    <xsl:if test="person/givenname">
     <xsl:variable name="replaced_text">
        <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="person/givenname"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>
    <xsl:text>&quot;</xsl:text>
    <xsl:text>,</xsl:text>
    <xsl:text>&quot;</xsl:text>
    <xsl:if test="person/middlename">
      <xsl:variable name="replaced_text">
        <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="person/middlename"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>
    <xsl:text>&quot;</xsl:text>
    <xsl:text>,</xsl:text>
    <xsl:text>&quot;</xsl:text>  
    <xsl:if test="person/surname">
      <xsl:variable name="replaced_text">
        <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="person/surname"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>
    <xsl:text>&quot;</xsl:text>
    <xsl:text>,</xsl:text>
    <xsl:text>&quot;</xsl:text>  
    <xsl:if test="organization/company">  
      <xsl:variable name="replaced_text">
        <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="organization/company"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>  
    <xsl:text>&quot;</xsl:text>
    <xsl:text>,</xsl:text>
    <xsl:text>&quot;</xsl:text>
    <xsl:if test="organization/organizationalunit">  
      <xsl:variable name="replaced_text">
        <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="organization/organizationalunit"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>  
    <xsl:text>&quot;</xsl:text>
    <xsl:text>,</xsl:text>
    <xsl:text>&quot;</xsl:text>  
    <xsl:if test="organization/title">
      <xsl:variable name="replaced_text">
        <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="organization/title"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>
    <xsl:text>&quot;</xsl:text>
    <xsl:text>,</xsl:text>
    <xsl:text>&quot;</xsl:text>
    <xsl:if test="postaladdress[@type='work']/street">  
        <xsl:variable name="replaced_text">
        <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="postaladdress[@type='work']/street"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>
    <xsl:text>&quot;</xsl:text>  
    <xsl:text>,</xsl:text>
    <xsl:text>&quot;</xsl:text>
    <xsl:if test="postaladdress[@type='work']/city">  
      <xsl:variable name="replaced_text">
        <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="postaladdress[@type='work']/city"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>
    <xsl:text>&quot;</xsl:text>  
    <xsl:text>,</xsl:text>
    <xsl:text>&quot;</xsl:text>
    <xsl:if test="postaladdress[@type='work']/state">  
      <xsl:variable name="replaced_text">
        <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="postaladdress[@type='work']/state"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>
    <xsl:text>&quot;</xsl:text>  
    <xsl:text>,</xsl:text>
    <xsl:text>&quot;</xsl:text>
    <xsl:if test="postaladdress[@type='work']/postalcode">  
      <xsl:variable name="replaced_text">
        <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="postaladdress[@type='work']/postalcode"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>
    <xsl:text>&quot;</xsl:text>  
    <xsl:text>,</xsl:text>
    <xsl:text>&quot;</xsl:text>
    <xsl:if test="postaladdress[@type='work']/country">  
     <xsl:variable name="replaced_text">
        <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="postaladdress[@type='work']/country"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>
    <xsl:text>&quot;</xsl:text>  
    <xsl:text>,</xsl:text>
    <xsl:text>&quot;</xsl:text>
    <xsl:if test="postaladdress[@type='home']/street">  
      <xsl:variable name="replaced_text">
        <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="postaladdress[@type='home']/street"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>
    <xsl:text>&quot;</xsl:text>  
    <xsl:text>,</xsl:text>
    <xsl:text>&quot;</xsl:text>
    <xsl:if test="postaladdress[@type='home']/city">  
      <xsl:variable name="replaced_text">
        <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="postaladdress[@type='home']/city"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>
    <xsl:text>&quot;</xsl:text>  
    <xsl:text>,</xsl:text>
    <xsl:text>&quot;</xsl:text>
    <xsl:if test="postaladdress[@type='home']/state">  
       <xsl:variable name="replaced_text">
        <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="postaladdress[@type='home']/state"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>
    <xsl:text>&quot;</xsl:text>  
    <xsl:text>,</xsl:text>
    <xsl:text>&quot;</xsl:text>
    <xsl:if test="postaladdress[@type='home']/postalcode">  
       <xsl:variable name="replaced_text">
        <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="postaladdress[@type='home']/postalcode"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>
    <xsl:text>&quot;</xsl:text>  
    <xsl:text>,</xsl:text>
    <xsl:text>&quot;</xsl:text>
    <xsl:if test="postaladdress[@type='home']/country">  
       <xsl:variable name="replaced_text">
        <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="postaladdress[@type='home']/country"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>
    <xsl:text>&quot;</xsl:text>  
    <xsl:text>,</xsl:text>
    <xsl:text>&quot;</xsl:text>
    <xsl:if test="phone[@priority='1']">
       <xsl:variable name="replaced_text">
        <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="phone[@priority='1']"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>
    <xsl:text>&quot;</xsl:text>
    <xsl:text>,</xsl:text>
    <xsl:text>&quot;</xsl:text>
    <xsl:if test="phone[@priority='2']">
      <xsl:variable name="replaced_text">
        <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="phone[@priority='2']"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>
    <xsl:text>&quot;</xsl:text>  
    <xsl:text>,</xsl:text>
    <xsl:text>&quot;</xsl:text>
    <xsl:if test="phone[@priority='3']">
      <xsl:variable name="replaced_text">
        <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="phone[@priority='3']"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>
    <xsl:text>&quot;</xsl:text>  
    <xsl:text>,</xsl:text>
    <xsl:text>&quot;</xsl:text>
    <xsl:if test="phone[@priority='4']">
     <xsl:variable name="replaced_text">
        <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="phone[@priority='4']"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>
    <xsl:text>&quot;</xsl:text>  
    <xsl:text>,</xsl:text>
    <xsl:text>&quot;</xsl:text>  
    <xsl:if test="phone[@priority='5']">
      <xsl:variable name="replaced_text">
        <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="phone[@priority='5']"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>
    <xsl:text>&quot;</xsl:text> 
    <xsl:text>,</xsl:text>
    <xsl:text>&quot;</xsl:text>  
    <xsl:if test="person/date[@type='anniversary']">
      <xsl:variable name="replaced_text">
        <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="person/date[@type='anniversary']"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>    
    <xsl:text>&quot;</xsl:text>
    <xsl:text>,</xsl:text>
    <xsl:text>&quot;</xsl:text>
    <xsl:if test="person/date[@type='birthday']">
      <xsl:variable name="replaced_text">
        <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="person/date[@type='birthday']"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>    
    <xsl:text>&quot;</xsl:text>
    <xsl:text>,</xsl:text>
    <xsl:text>&quot;</xsl:text>
    <xsl:if test="email[@priority='1']">
      <xsl:variable name="replaced_text">
        <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="email[@priority='1']"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>    
    <xsl:text>&quot;</xsl:text>
    <xsl:text>,</xsl:text>
    <xsl:text>&quot;</xsl:text>
    <xsl:if test="email[@priority='2']">
      <xsl:variable name="replaced_text">
        <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="email[@priority='2']"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>    
    <xsl:text>&quot;</xsl:text>
    <xsl:text>,</xsl:text>
    <xsl:text>&quot;</xsl:text>
    <xsl:if test="email[@priority='3']">
     <xsl:variable name="replaced_text">
        <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="email[@priority='3']"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>    
    <xsl:text>&quot;</xsl:text>
    <xsl:text>,</xsl:text>
    <xsl:text>&quot;</xsl:text>  
    <xsl:if test="entry/description">    
      <xsl:variable name="replaced_text">
      <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="entry/description"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
      </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>  
    <xsl:text>&quot;</xsl:text>
    <xsl:text>,</xsl:text>
    <xsl:text>&quot;</xsl:text>
    <xsl:if test="organization/location/office">
       <xsl:variable name="replaced_text">
        <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="organization/location/office"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>
    <xsl:text>&quot;</xsl:text>
    <xsl:text>,</xsl:text>
    <xsl:text>&quot;</xsl:text>
    <xsl:if test="weburl[@priority='1']/urladdr">
      <xsl:variable name="replaced_text">
        <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="weburl[@priority='1']/urladdr"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>
    <xsl:text>&quot;</xsl:text>
    <xsl:text>,</xsl:text>
    <xsl:text>&quot;</xsl:text>
    <xsl:if test="weburl[@priority='2']/urladdr">
      <xsl:variable name="replaced_text">
      <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="weburl[@priority='2']/urladdr"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>
    <xsl:text>&quot;</xsl:text>
    <xsl:text>,</xsl:text>
    <xsl:text>&quot;</xsl:text>
    <xsl:if test="entry/displayname">
      <xsl:variable name="replaced_text">
      <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="entry/displayname"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>
    <xsl:text>&quot;</xsl:text>
    <xsl:text>,</xsl:text>
    <xsl:text>&quot;</xsl:text>
    <xsl:if test="im[@priority='1']">
      <xsl:variable name="replaced_text">
      <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="im[@priority='1']"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>
    <xsl:text>&quot;</xsl:text>
    <xsl:text>,</xsl:text>
    <xsl:text>&quot;</xsl:text>
    <xsl:if test="im[@priority='2']">
      <xsl:variable name="replaced_text">
      <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="im[@priority='2']"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>
    <xsl:text>&quot;</xsl:text>
    <xsl:text>,</xsl:text>
    <xsl:text>&quot;</xsl:text>
    <xsl:if test="im[@priority='3']">
      <xsl:variable name="replaced_text">
      <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="im[@priority='3']"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>
    <xsl:text>&quot;</xsl:text>
    <xsl:text>,</xsl:text>
    <xsl:text>&quot;</xsl:text>
    <xsl:if test="im[@priority='1']/@service">
      <xsl:variable name="replaced_text">
      <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="im[@priority='1']/@service"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>
    <xsl:text>&quot;</xsl:text>
    <xsl:text>,</xsl:text>
    <xsl:text>&quot;</xsl:text>
    <xsl:if test="im[@priority='2']/@service">
      <xsl:variable name="replaced_text">
      <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="im[@priority='2']/@service"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>
    <xsl:text>&quot;</xsl:text>
    <xsl:text>,</xsl:text>
    <xsl:text>&quot;</xsl:text>
    <xsl:if test="im[@priority='3']/@service">
      <xsl:variable name="replaced_text">
      <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="im[@priority='3']/@service"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>
    <xsl:text>&quot;</xsl:text>
    <xsl:text>,</xsl:text>
    <xsl:text>&quot;</xsl:text>
    <xsl:if test="calendar[@type='calendar']">
      <xsl:variable name="replaced_text">
      <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="calendar[@type='calendar']"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>
    <xsl:text>&quot;</xsl:text>
    <xsl:text>,</xsl:text>
    <xsl:text>&quot;</xsl:text>
    <xsl:if test="calendar[@type='freebusy']">
      <xsl:variable name="replaced_text">
      <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="calendar[@type='freebusy']"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>
    <xsl:text>&quot;</xsl:text>
    <xsl:text>,</xsl:text>
    <xsl:text>&quot;</xsl:text>
    <xsl:if test="person/date[@type='other']">
      <xsl:variable name="replaced_text">
      <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="person/date[@type='other']"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>
    <xsl:text>&quot;</xsl:text>
    <xsl:text>,</xsl:text>
    <xsl:text>&quot;</xsl:text>
    <xsl:if test="person/date[@type='other']/@description">
      <xsl:variable name="replaced_text">
      <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="person/date[@type='other']/@description"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>
    <xsl:text>&quot;</xsl:text>
    <xsl:text>,</xsl:text>
    <xsl:text>&quot;</xsl:text>
    <xsl:if test="location/campus">
      <xsl:variable name="replaced_text">
      <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="location/campus"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>
    <xsl:text>&quot;</xsl:text>
    <xsl:text>,</xsl:text>
    <xsl:text>&quot;</xsl:text>
    <xsl:if test="location/building">
      <xsl:variable name="replaced_text">
      <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="location/building"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>
    <xsl:text>&quot;</xsl:text>
    <xsl:text>,</xsl:text>
    <xsl:text>&quot;</xsl:text>
    <xsl:if test="location/floor">
      <xsl:variable name="replaced_text">
      <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="location/floor"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>
    <xsl:text>&quot;</xsl:text>
    <xsl:text>,</xsl:text>
    <xsl:text>&quot;</xsl:text>
    <xsl:if test="phone[@priority='1']/@type">
      <xsl:variable name="replaced_text">
        <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="phone[@priority='1']/@type"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>
    <xsl:text>&quot;</xsl:text>  
    <xsl:text>,</xsl:text>
    <xsl:text>&quot;</xsl:text>
    <xsl:if test="phone[@priority='2']/@type">
      <xsl:variable name="replaced_text">
        <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="phone[@priority='2']/@type"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>
    <xsl:text>&quot;</xsl:text>  
    <xsl:text>,</xsl:text>
    <xsl:text>&quot;</xsl:text>
    <xsl:if test="phone[@priority='3']/@type">
      <xsl:variable name="replaced_text">
        <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="phone[@priority='3']/@type"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>
    <xsl:text>&quot;</xsl:text>
    <xsl:text>,</xsl:text>
    <xsl:text>&quot;</xsl:text>
    <xsl:if test="phone[@priority='4']/@type">
      <xsl:variable name="replaced_text">
        <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="phone[@priority='4']/@type"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>
    <xsl:text>&quot;</xsl:text> 
    <xsl:text>,</xsl:text>
    <xsl:text>&quot;</xsl:text>
    <xsl:if test="phone[@priority='5']/@type">
      <xsl:variable name="replaced_text">
        <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="phone[@priority='5']/@type"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>
    <xsl:text>&quot;</xsl:text> 
    <xsl:text>,</xsl:text>
    <xsl:text>&quot;</xsl:text>
    <xsl:if test="email[@priority='1']/@type">
      <xsl:variable name="replaced_text">
        <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="email[@priority='1']/@type"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>
    <xsl:text>&quot;</xsl:text> 
    <xsl:text>,</xsl:text>
    <xsl:text>&quot;</xsl:text>
    <xsl:if test="email[@priority='2']/@type">
      <xsl:variable name="replaced_text">
        <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="email[@priority='2']/@type"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>
    <xsl:text>&quot;</xsl:text> 
    <xsl:text>,</xsl:text>
    <xsl:text>&quot;</xsl:text>
    <xsl:if test="email[@priority='3']/@type">
      <xsl:variable name="replaced_text">
        <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="email[@priority='3']/@type"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>
    <xsl:text>&quot;</xsl:text>
    <xsl:text>&#xA;</xsl:text>
  </xsl:for-each>
</xsl:template>

<!--
*******************************************************************************
* Core of the template stylesheet export-csv-us.xsl
*******************************************************************************
-->
<xsl:template match="/">
  <xsl:call-template name="fields-name-export-csv-iabs"/>
  <xsl:call-template name="data-export-csv-iabs"/>
</xsl:template>
</xsl:stylesheet>
