<?xml version="1.0"?>
<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>

<xsl:stylesheet version='1.0' xmlns:xsl='http://www.w3.org/1999/XSL/Transform'>
<!--
* This template match an abperson node. It formats and prints the node.
* @param depth Current depth in the tree used for expanded groups for example
* @param pagedSearch Element containing both nodes searchresult and expandedgroups
-->
<xsl:template match="abperson | abconferenceroom" mode="list">
<xsl:param name="pagedSearch"/>  
<xsl:param name="depth"/>
<xsl:param name="popup" select="false()"/>
<xsl:param name="linkOnIcon" select="true()" />
<xsl:param name="displayAttr1"/>
<xsl:param name="displayAttr2"/>
<xsl:param name="displayAttr3"/>
<xsl:param name="displayAttr4"/>
<xsl:param name="displayAttr5"/>
<xsl:param name="displayAttr6"/>
<xsl:param name="displayAttr7"/>

  <!-- Render the hidden field for the already selected feature -->
  <xsl:apply-templates mode="hidden" select=".">
    <xsl:with-param name="currentBookID" select="$pagedSearch/searchresult/@bookid" />
  </xsl:apply-templates>

  <tr>
    <!-- 
    * First print the select (the template that will be called is
    * actually dependant on the context (might be a simple select
    * or a To/Cc/Bcc
    -->
    <xsl:call-template name="displaySelect"/>
    <!--
    <td>&nbsp;</td>
    -->
    <!-- then print the little tree and the first attribute -->
    <td class="TblTdSrt">
      <xsl:attribute name="nowrap"/>
      <!--
      <table cellspacing="0" cellpadding="0" border="0" align="left">
        <tr>
        -->
          <xsl:if test="$depth > 0">
            <xsl:call-template name="indentEntry">
              <xsl:with-param name="depth" select="$depth"/>
            </xsl:call-template>
          </xsl:if>
          <!--
          <td>
          -->
          <xsl:if test="not($popup)">
            <img src="{$spacer.gif}" alt="" width="18" height="18" align="absmiddle"/>
            <!--
            </td>
            <td width="18" align="center">
            -->           
            <xsl:choose>
              <xsl:when test="$linkOnIcon">
                <a onkeypress="linkHandler()" class="Lnk">
                  <xsl:attribute name="href">
                    <xsl:text>javascript:viewEntry("</xsl:text>
                    <xsl:call-template name="escape"><xsl:with-param name="text" select="entry/@entryID"/></xsl:call-template>
                    <xsl:text>","</xsl:text>
                    <xsl:call-template name="escape"><xsl:with-param name="text" select="name(.)"/> </xsl:call-template>
                    <xsl:text>");</xsl:text>
                  </xsl:attribute>                 
                  <xsl:attribute name="title">
                    <xsl:text>_View Contact</xsl:text>
                  </xsl:attribute>         
                  <xsl:if test="name(.) = 'abperson'">
                    <img src="{$User_16.gif}" width="16" height="16" border="0" align="absmiddle">
                      <xsl:attribute name="alt">
                         <xsl:text>_View Contact</xsl:text>
                      </xsl:attribute>
                    </img>
                  </xsl:if>
                </a>
              </xsl:when>
              <xsl:otherwise>                 
                <xsl:if test="name(.) = 'abperson'">
                  <img src="{$User_16.gif}" width="16" height="16" border="0" align="absmiddle">
                    <xsl:attribute name="alt">
                      <xsl:text>_View Contact</xsl:text>
                    </xsl:attribute>
                  </img>
                 </xsl:if>
              </xsl:otherwise>
            </xsl:choose> 
          </xsl:if>
          <xsl:if test="name(.) = 'abconferenceroom'">
            <img src="{$Conference_16.gif}" width="16" height="16" border="0" align="absmiddle">                  
              <xsl:attribute name="title">
                <xsl:text>_Conference Room</xsl:text>
              </xsl:attribute>
            </img> 
          </xsl:if>

          <!--
          </td>          
          <td>
          We don't indent in if it's a popup
          -->
          <xsl:if test="not($popup)">
            <img src="{$spacer.gif}" alt=""  width="4" height="1" align="absmiddle"/>
          </xsl:if>
          <!--
          </td>
          -->
          <xsl:if test="string-length($displayAttr1)">
            <!--
            <td>
            -->
              <xsl:call-template name="displayAttr">
                <xsl:with-param name="displayAttribute" select="$displayAttr1"/>
              </xsl:call-template>
              <xsl:text>&nbsp;</xsl:text>
            <!--
            </td>
            -->
          </xsl:if>
        <!--
        </tr>
      </table>
      -->
      <xsl:text>&nbsp;</xsl:text>
    </td>
    <xsl:if test="string-length($displayAttr2)"> 
    <td>      
        <xsl:call-template name="displayAttr">
          <xsl:with-param name="displayAttribute" select="$displayAttr2"/>
        </xsl:call-template>
        <xsl:text>&nbsp;</xsl:text>     
    </td>
     </xsl:if>      
    <xsl:if test="string-length($displayAttr3)">
    <td>
        <xsl:call-template name="displayAttr">
          <xsl:with-param name="displayAttribute" select="$displayAttr3"/>
        </xsl:call-template>      
      <xsl:text>&nbsp;</xsl:text>
    </td>
    </xsl:if>
    
    <xsl:if test="string-length($displayAttr4) > 0">
    <td>    
        <xsl:call-template name="displayAttr">
          <xsl:with-param name="displayAttribute" select="$displayAttr4"/>
        </xsl:call-template>
      
      <xsl:text>&nbsp;</xsl:text>
    </td>
    </xsl:if>
    
    <xsl:if test="string-length($displayAttr5) > 0">    
    <td>
      
        <xsl:call-template name="displayAttr">
          <xsl:with-param name="displayAttribute" select="$displayAttr5"/>
        </xsl:call-template>    
      <xsl:text>&nbsp;</xsl:text>
    </td>
    </xsl:if>
   
    <xsl:if test="string-length($displayAttr6) > 0"> 
    <td>     
        <xsl:call-template name="displayAttr">
          <xsl:with-param name="displayAttribute" select="$displayAttr6"/>
        </xsl:call-template>    
      <xsl:text>&nbsp;</xsl:text>
    </td>
    </xsl:if>  
    
    <xsl:if test="string-length($displayAttr7) > 0">
    <td>
        <xsl:call-template name="displayAttr">
          <xsl:with-param name="displayAttribute" select="$displayAttr7"/>
        </xsl:call-template>      
      <xsl:text>&nbsp;</xsl:text>
    </td>
    </xsl:if>

  </tr>
</xsl:template>


<!--
* This template match a group node. It formats and prints the node.
* @param depth Current depth in the tree used for expanded groups for example
* @param pagedSearch Element containing both nodes searchresult and expandedgroups
-->
<xsl:template match="group" mode="list">
  <xsl:param name="pagedSearch"/>
  <xsl:param name="depth"/>
  <xsl:param name="formaction"/>
  <xsl:param name="linkOnIcon" select="true()" />
  <xsl:param name="displayAttr1"/>
  <xsl:param name="displayAttr2"/>
  <xsl:param name="displayAttr3"/>
  <xsl:param name="displayAttr4"/>
  <xsl:param name="displayAttr5"/>
  <xsl:param name="displayAttr6"/>
  <xsl:param name="displayAttr7"/>

  <xsl:variable name="expandedgroup" select="$pagedSearch/expandedgroups/expandedgroup[@entryID = current()/entry/@entryID]"/>
  <xsl:variable name="isexpanded" select="count($expandedgroup)"/>

  <!-- Render the hidden field for the already selected feature -->
  <xsl:apply-templates mode="hidden" select=".">
    <xsl:with-param name="currentBookID" select="$pagedSearch/searchresult/@bookid" />
  </xsl:apply-templates>

 <tr>
    <!-- 
     first print the select (the template that will be called is
     actually dependant on the context (might be a simple select
     or a To/Cc/Bcc
    -->
    <!--
    <td>
      <img src="{$spacer.gif}"  alt="" height="1" width="1"/>
    </td>
    -->

    <xsl:call-template name="displaySelect"/>
    <!--
    <td>
      <img src="{$spacer.gif}"  alt="" height="1" width="1"/>
    </td>
    -->
    <!-- then print the little tree and the first attribute -->
    <td class="TblTdSrt">
      <!--
      <table cellspacing="0" cellpadding="0" border="0">
        <tr> 
      -->
          <xsl:if test="$depth > 0">
            <xsl:call-template name="indentEntry">
              <xsl:with-param name="depth" select="$depth"/>
            </xsl:call-template>
          </xsl:if>
          <!--
          <td>
          -->
            <xsl:choose>
              <xsl:when test="$isexpanded">
                <a>
                  <xsl:attribute name="href">
                   <xsl:text>javascript:collapseGroup("</xsl:text>
                   <xsl:call-template name="escape"><xsl:with-param name="text" select="entry/@entryID"/></xsl:call-template>
                   <xsl:text>",'</xsl:text>
                   <xsl:value-of select="$formaction"/>
                   <xsl:text>');</xsl:text>
                  </xsl:attribute>
                  <img width="18" height="18" border="0" src="{$tree_minustop.gif}" align="absmiddle">
                    <xsl:attribute name="alt">
                      <xsl:text>_Collapse this group</xsl:text>
                    </xsl:attribute>
                  </img>
                </a>
              </xsl:when>
              <xsl:otherwise>
                <a> 
                  <xsl:attribute name="href">
                   <xsl:text>javascript:expandGroup("</xsl:text>
                   <xsl:call-template name="escape"><xsl:with-param name="text" select="entry/@entryID"/></xsl:call-template>
                   <xsl:text>",'</xsl:text>
                   <xsl:value-of select="$formaction"/>
                   <xsl:text>');</xsl:text>
                  </xsl:attribute>
                  <img width="18" height="18" border="0" align="absmiddle">
                    <xsl:attribute name="src">
                      <xsl:value-of select="$tree_plusonly.gif"/>
                    </xsl:attribute>
                    <xsl:attribute name="alt">
                      <xsl:text>_Expand group</xsl:text>
                    </xsl:attribute>
                  </img>
                </a>
              </xsl:otherwise>
            </xsl:choose>
          <!--
          </td>
          <td width="18" align="center">
          -->
            <xsl:choose>
              <xsl:when test="$linkOnIcon">
                <a>
                  <xsl:attribute name="href">
                    <xsl:text>javascript:viewEntry("</xsl:text>
                    <xsl:call-template name="escape"><xsl:with-param name="text" select="entry/@entryID"/></xsl:call-template>
                    <xsl:text>","</xsl:text>
                    <xsl:call-template name="escape"><xsl:with-param name="text" select="name(.)"/></xsl:call-template>
                    <xsl:text>");</xsl:text>
                  </xsl:attribute> 
                  <img src="{$Group_16.gif}" width="16" height="16" border="0" align="absmiddle">
                          <xsl:attribute name="alt">
                           <xsl:text>_View Group</xsl:text>
                          </xsl:attribute>
                        </img>
                </a>
              </xsl:when>
              <xsl:otherwise>
                <img src="{$Group_16.gif}" width="16" height="16" border="0" align="absmiddle"/>
              </xsl:otherwise>
            </xsl:choose> 
          <!--
          </td>
          <td>
          -->
         <img src="{$spacer.gif}"  alt="" width="4" height="1" align="absmiddle"/>
          <!--
          </td>
          -->
          <xsl:if test="string-length($displayAttr1)">
            <!--
            <td>
            -->
              <xsl:call-template name="displayAttr">
                <xsl:with-param name="displayAttribute" select="$displayAttr1"/>
              </xsl:call-template>
            <!--
            </td>
            -->
          </xsl:if>
      <!--
        </tr>
      </table>
      -->
      <xsl:text>&nbsp;</xsl:text>
    </td>

    <xsl:if test="string-length($displayAttr2)">
    <td>
        <xsl:call-template name="displayAttr">
          <xsl:with-param name="displayAttribute" select="$displayAttr2"/>
        </xsl:call-template>     
        <xsl:text>&nbsp;</xsl:text>     
    </td>
    </xsl:if>

    <xsl:if test="string-length($displayAttr3)">
    <td>      
        <xsl:call-template name="displayAttr">
          <xsl:with-param name="displayAttribute" select="$displayAttr3"/>
        </xsl:call-template>      
      <xsl:text>&nbsp;</xsl:text> 
    </td>
  </xsl:if>

    <xsl:if test="string-length($displayAttr4) > 0">
    <td>      
        <xsl:call-template name="displayAttr">
          <xsl:with-param name="displayAttribute" select="$displayAttr4"/>
        </xsl:call-template>      
      <xsl:text>&nbsp;</xsl:text> 
    </td>
    </xsl:if>

    <xsl:if test="string-length($displayAttr5) > 0">
    <td>      
        <xsl:call-template name="displayAttr">
          <xsl:with-param name="displayAttribute" select="$displayAttr5"/>
        </xsl:call-template>    
      <xsl:text>&nbsp;</xsl:text> 
    </td>
    </xsl:if>
    
    <xsl:if test="string-length($displayAttr6) > 0">
    <td>    
        <xsl:call-template name="displayAttr">
          <xsl:with-param name="displayAttribute" select="$displayAttr6"/>
        </xsl:call-template>    
      <xsl:text>&nbsp;</xsl:text> 
    </td>
    </xsl:if>
    
  <xsl:if test="string-length($displayAttr7) > 0">
    <td>      
        <xsl:call-template name="displayAttr">
          <xsl:with-param name="displayAttribute" select="$displayAttr7"/>
        </xsl:call-template>      
      <xsl:text>&nbsp;</xsl:text> 
    </td>
  </xsl:if>
  </tr>

  <xsl:if test="$isexpanded">
    <!-- Recursive call to expand groups -->
    <xsl:apply-templates mode="list" select="$expandedgroup/*"> 
      <xsl:with-param name="pagedSearch" select="$pagedSearch"/>
      <xsl:with-param name="depth" select="$depth + 1" />
      <xsl:with-param name="formaction" select="$formaction"/>
      <xsl:with-param name="displayAttr1" select="$displayAttr1" />
      <xsl:with-param name="displayAttr2" select="$displayAttr2" />
      <xsl:with-param name="displayAttr3" select="$displayAttr3" />
      <xsl:with-param name="displayAttr4" select="$displayAttr4" />
      <xsl:with-param name="displayAttr5" select="$displayAttr5" />
      <xsl:with-param name="displayAttr6" select="$displayAttr6" />
      <xsl:with-param name="displayAttr7" select="$displayAttr7" />
    </xsl:apply-templates>
  </xsl:if>

</xsl:template>

<!--
*******************************************************************************
* Print the indentation when contact or group belong to a group
*******************************************************************************
-->
<xsl:template name="indentEntry">
  <xsl:param name="depth"/>
  <!--
  <td>
  -->
    <img src="{$spacer.gif}"  alt="" width="18" align="absmiddle"/>
  <!--
  </td>
  -->
  <xsl:if test="$depth > 1">
    <xsl:call-template name="indentEntry">
      <xsl:with-param name="depth" select="$depth - 1"/>
    </xsl:call-template>
  </xsl:if>
</xsl:template>

</xsl:stylesheet>

