<?xml version="1.0"?>
<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>

<xsl:stylesheet version='1.0' xmlns:xsl='http://www.w3.org/1999/XSL/Transform'>

  <xsl:output method="html" version="4" encoding="UTF-8"/>

  <xsl:include href="banner.xsl"/>
  <xsl:include href="common-uielements.xsl"/>
  <xsl:include href="common-editab.xsl"/>
  <xsl:include href="commonattributes-list.xsl"/>
  <xsl:include href="commonimages.xsl"/>
  <xsl:include href="commonjavascript.xsl"/>
  <xsl:include href="context.xsl"/>
  <xsl:include href="css-select.xsl"/>


  <!--
  *******************************************************************************
  * Core of the template stylesheet search.xsl
  *******************************************************************************
  -->
  <xsl:template match="/">
    <html>
      <head>
        <title>
          <xsl:text>_iPlanet Address Book - Address books</xsl:text>
        </title>
        <link type="text/css" rel="stylesheet" href="{$commonCSS.css}"/> 

        <xsl:call-template name="styleSheetSelector">
          <xsl:with-param name="htmlprefs" select="/xslui/profileinfo/xmlprofile/htmlprefs"/>     
        </xsl:call-template>
        <xsl:call-template name="fontMaker">
          <xsl:with-param name="htmlprefs" select="/xslui/profileinfo/xmlprofile/htmlprefs"/>     
        </xsl:call-template>

        <script language="javascript" src="../absjs/common.js"/>
        <script language="javascript" src="../absjs/entries.js"/>
        <script language="Javascript">
          <xsl:call-template name="commonjavascript"/>
          <xsl:call-template name="bannerScripts"/>
          
          function cancel() {
            goToUsingForm("search.xml");
          }
          function save() {
           if((document.iabform["<xsl:value-of select="$fieldPrefix"/>displayName"].value).trim()=="")
          {
           alert("<xsl:text>_Display name cannot be blank or only whitespaces</xsl:text>");
           return;
          }
          if(document.iabform["<xsl:value-of select="$fieldPrefix"/>abOldEntriesPerPage"].value!=document.iabform["<xsl:value-of select="$fieldPrefix"/>abEntriesPerPage"].value)
          {
          document.iabform.stopsearch.value=1;
          document.iabform.firstentry.value=1;
          }
            document.iabform.stopsearch.value=1;
            submitForm('editbook');
          }
        </script>
      </head>

      <body leftmargin="0" topmargin="0" rightmargin="0" marginwidth="0" marginheight="0">
        <xsl:attribute name="onload">
          document.iabform.<xsl:value-of select="$fieldPrefix"/>displayName.focus();
        </xsl:attribute> 

      <form method="post" name="iabform" action="search.xml" onsubmit="return(false)">
        <input type="hidden" name="j_encoding" value="{/xslui/@charset}"/>
        <input type="hidden" name="uiaction" value=""/>
        <input type="hidden" name="entryid" value="{/xslui/iab/bookentry/book/entry/@entryID}"/>
        <input type="hidden" name="prefix" value="{$fieldPrefix}"/>
        <input type="hidden" name="{$fieldPrefix}entryID" value="{/xslui/iab/bookentry/book/entry/@entryID}"/>
        <input type="hidden" name="{$fieldPrefix}abOldEntriesPerPage" value="{/xslui/iab/bookentry/book/layoutinfo/@entriesperpage}"/>
        <input type="hidden" name="{$fieldPrefix}entrytype" value="abook"/>

        <xsl:call-template name="contextKeeper">
          <xsl:with-param name="pagedSearch" select="/xslui/iab/pagedsearch"/>
        </xsl:call-template>

        <xsl:call-template name="banner"/>

        <xsl:call-template name="contextBanner">
          <xsl:with-param name="text">
            <xsl:text>_Address Books</xsl:text>:&nbsp;
            <xsl:text>_Edit address book</xsl:text>
          </xsl:with-param>
        </xsl:call-template>

        <xsl:apply-templates select="/xslui/errormessages/error" mode="box"/>

        <xsl:call-template name="save-cancel-help-bar">
          <xsl:with-param name="helpurl">../help/<xsl:text>_languagepath</xsl:text>/help4.htm</xsl:with-param>
        </xsl:call-template>

        <xsl:variable name="bookfromcontext" select="/xslui/iab/entrycontext/book"/>
        <xsl:variable name="bookfromentry" select="/xslui/iab/bookentry/book"/>
        
        <table width="100&#37;" border="0" cellspacing="0" cellpadding="0" class="second-strip">
          <tr> 
            <td colspan="5" class="first-strip">
              <img src="{$spacer.gif}" width="1" height="4"/>
            </td>
          </tr>
          <tr> 
            <td colspan="5">
              <img src="{$spacer.gif}" width="1" height="6"/>
            </td>
          </tr>
          <tr>
            <td>&nbsp;</td>
            <td colspan="4">
              <xsl:choose>
                <xsl:when test="$bookfromentry and $bookfromentry/@bookremoteurl">
                  <xsl:call-template name="button">
                    <xsl:with-param name="label">
                      <xsl:text>_Unsubscribe</xsl:text>
                    </xsl:with-param>
                    <xsl:with-param name="href">javascript:unsubscribe('<xsl:value-of select="$bookfromentry/entry/@entryID"/>','<xsl:value-of select="/xslui/iab/profileinfo/xmlprofile/defaultbook/@bookid"/>')</xsl:with-param> 
                  </xsl:call-template>
                </xsl:when>
                <xsl:otherwise>
                  <xsl:call-template name="button">
                    <xsl:with-param name="label">
                      <xsl:text>_Delete Address Book</xsl:text>
                    </xsl:with-param>
                    <xsl:with-param name="href">javascript:deleteAB('<xsl:value-of select="$bookfromentry/entry/@entryID"/>','<xsl:value-of select="/xslui/iab/profileinfo/xmlprofile/defaultbook/@bookid"/>')</xsl:with-param> 
                  </xsl:call-template>
                </xsl:otherwise>
              </xsl:choose> 
            </td>
          </tr>
          <tr> 
            <td colspan="5">
              <img src="{$spacer.gif}" width="1" height="6"/>
            </td>
          </tr>
          <xsl:choose>
            <xsl:when test="$bookfromcontext">
              <xsl:call-template name="abDetails">
                <xsl:with-param name="ab" select="$bookfromcontext"/>
                <xsl:with-param name="edit" select="true()"/>
              </xsl:call-template>
              <xsl:call-template name="abLayout">
                <xsl:with-param name="book" select="$bookfromcontext"/>
              </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
              <xsl:call-template name="abDetails">
                <xsl:with-param name="ab" select="$bookfromentry"/>
                <xsl:with-param name="edit" select="true()"/>
              </xsl:call-template>
              <xsl:call-template name="abLayout">
                <xsl:with-param name="book" select="$bookfromentry"/>
              </xsl:call-template>
            </xsl:otherwise>
          </xsl:choose>
          <xsl:call-template name="sharingPermissions"/>
          <tr> 
            <td colspan="5" class="first-strip">
              <img src="{$spacer.gif}" width="1" height="2"/>
            </td>
          </tr>
        </table>
        <xsl:call-template name="requiredInfo"/>
        <xsl:call-template name="save-cancel-help-bar">
          <xsl:with-param name="helpurl">../help/<xsl:text>_languagepath</xsl:text>/help4.htm</xsl:with-param>
        </xsl:call-template>

        </form>
      </body>
    </html>
  </xsl:template>
</xsl:stylesheet>
