<?xml version="1.0"?>
<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>

<xsl:stylesheet version='1.0' xmlns:xsl='http://www.w3.org/1999/XSL/Transform'>

<!--
*******************************************************************************
* This template match a postal address it prints the node as a link to a showmap
*******************************************************************************
-->
<xsl:template match="postaladdress" mode="list">
<!--
    <xsl:attribute name="href">
      <xsl:text>javascript:popupLocationMap('</xsl:text>
      <xsl:value-of select="./country"/>
      <xsl:text>','</xsl:text>
      <xsl:value-of select="./city"/>
      <xsl:text>','</xsl:text>
      <xsl:value-of select="./postalcode"/>
      <xsl:text>','</xsl:text>
      <xsl:value-of select="./street"/>
      <xsl:text>','</xsl:text>
      <xsl:value-of select="./state"/>
      <xsl:text>')</xsl:text>
    </xsl:attribute>
    <xsl:attribute name="alt">
      <xsl:text>_Show Map</xsl:text>
    </xsl:attribute>
-->
    <xsl:value-of select="./street"/>&nbsp;<xsl:value-of select="./city"/>&nbsp;<xsl:value-of select="./state"/>&nbsp;<xsl:value-of select="./postalcode"/>&nbsp;<xsl:value-of select="./country"/>  
</xsl:template>

<!--
*******************************************************************************
* This template match a displayname node then formats and prints the node
*******************************************************************************
-->
<xsl:template match="displayname" mode="list">
  <a onkeypress="linkHandler()" class="Lnk">
    <xsl:choose>
	<xsl:when test="name(../..) = 'group'">
          <xsl:attribute name="title">
      		<xsl:text>_View Group</xsl:text>
	  </xsl:attribute>
	</xsl:when>
	<xsl:otherwise>
          <xsl:attribute name="title">
      		<xsl:text>_View Contact</xsl:text>
	  </xsl:attribute>
	</xsl:otherwise>
    </xsl:choose>
    <xsl:attribute name="href">
      <xsl:text>javascript:viewEntry("</xsl:text>
      <xsl:call-template name="escape"><xsl:with-param name="text" select="../@entryID"/></xsl:call-template>
      <xsl:text>",'</xsl:text>
      <xsl:value-of select="name(../..)" /> 
      <xsl:text>');</xsl:text>
    </xsl:attribute>
    <xsl:choose>
    	<xsl:when test="string-length(.) &lt;= 30">
		<xsl:value-of select="."/>
    	</xsl:when>
    	<xsl:otherwise>
		<xsl:value-of select="concat(substring(.,1,30),' ...')" />
    	</xsl:otherwise>
   </xsl:choose>
  </a>
</xsl:template>

<!--
*******************************************************************************
* This template match a phone node then formats and prints the node
* @param displayType whether or not to display the type of phone (work/home/...)
*******************************************************************************
-->
<xsl:template match="phone" mode="list">
  <xsl:param name="displayType" select="false()"/>

  <xsl:if test="string-length(.) > 0">
      <xsl:value-of select="."/>
      <xsl:if test="$displayType">
        <xsl:text> (</xsl:text>
        <xsl:choose>
          <xsl:when test="@type = 'work'">
            <xsl:text>_work</xsl:text>
          </xsl:when>
          <xsl:when test="@type = 'home'">
            <xsl:text>_home</xsl:text>
          </xsl:when>
          <xsl:when test="@type = 'mobile'">
            <xsl:text>_Mobile</xsl:text>
          </xsl:when>
          <xsl:when test="@type = 'fax'">
            <xsl:text>_Fax</xsl:text>
          </xsl:when>
          <xsl:when test="@type = 'pager'">
            <xsl:text>_Pager</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>_other</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
        <xsl:text>) </xsl:text>
      </xsl:if>
  </xsl:if>
</xsl:template>

<!--
*******************************************************************************
* This template adds an edit/copy widget
*******************************************************************************
-->
<xsl:template match="entry" mode="list">
  <xsl:variable name="isRemoteAB" select="boolean(/xslui/iab/booklist/book[entry/@entryID = /xslui/iab/pagedsearch/searchresult/@bookid]/@bookremoteurl)"/>
  <xsl:choose>
    <xsl:when test="$isRemoteAB">
<!-- we are not supporting row-level action but a table level action hence commenting it
      <xsl:variable name="firstLocalAB" select="/xslui/iab/booklist/book[@bookurl][1]"/>
      <xsl:choose>
        <xsl:when test="$firstLocalAB">
          <a>
            <xsl:attribute name="href">javascript:copyAndEditContact('<xsl:value-of select="@entryID"/>','<xsl:value-of select="/xslui/iab/pagedsearch/searchresult/@bookid"/>','<xsl:value-of select="$firstLocalAB/entry/@entryID"/>');</xsl:attribute>
            <xsl:text>_Edit as new</xsl:text>
          </a>
        </xsl:when>
        <xsl:otherwise>
          <a class="disabled-action">
            <xsl:attribute name="href">javascript:alert(unescape('<xsl:text>_No local adress book found</xsl:text>'))</xsl:attribute>
            <xsl:text>_Edit as new...</xsl:text>
          </a>
        </xsl:otherwise>
      </xsl:choose> 
-->
      &nbsp;
    </xsl:when>
    <xsl:otherwise>
      <a onkeypress="linkHandler()">
        <xsl:attribute name="title">
          <xsl:text>_Edit</xsl:text>
        </xsl:attribute>
        <xsl:attribute name="href">javascript:editEntry("<xsl:call-template name="escape"><xsl:with-param name="text" select="@entryID"/></xsl:call-template>","<xsl:call-template name="escape"><xsl:with-param name="text" select="name(..)"/></xsl:call-template>",'search.xml', true);</xsl:attribute>
        <xsl:text>_Edit</xsl:text>
      </a>
    </xsl:otherwise>
  </xsl:choose> 
</xsl:template>
<!--
*******************************************************************************
* This template is the default match for most node: just print the content
*******************************************************************************
-->
<xsl:template match="*" mode="list">  
    <xsl:value-of select="."/>  
</xsl:template>
<!--
*******************************************************************************
* This template is the default match for most node: just print the content
*******************************************************************************
-->
<xsl:template match="*" mode="nolink">  
    <xsl:value-of select="."/>  
</xsl:template>

<xsl:template name="date">
  <xsl:param name="date-param"/>
  <script>document.write(dateFormater(
                "<xsl:value-of select="/xslui/profileinfo/xmlprofile/generalprefs/@dateorder"/>",
                "<xsl:value-of select="/xslui/profileinfo/xmlprofile/generalprefs/@dateseparator"/>",
                "<xsl:value-of select="$date-param"/>"))
  </script>
</xsl:template>
<!--
*******************************************************************************
* This template prints the header of the columns in the search view
* @param attr The name of the param to display in the column
* @param sortby The current field being used to sort and way of sorting e.g.: +displayname
*******************************************************************************
-->
<xsl:template name="attr_display_name">
  <xsl:param name="attr"/>
  <xsl:param name="sortby"/>
  <xsl:param name="showsortby" select="true()"/>

      <xsl:choose>
        <xsl:when test="$attr='displayname' or $attr='dnnolink'">
          <xsl:text>_Name</xsl:text>
        </xsl:when>
        <xsl:when test="$attr='primaryemail' or $attr='primemailnolink'">
          <xsl:text>_Email (primary)</xsl:text>
        </xsl:when>
        <xsl:when test="$attr='emailsnolink'">
          <xsl:text>_Email</xsl:text>
        </xsl:when>
        <xsl:when test="$attr='primaryphone'">
          <xsl:text>_Phone (primary)</xsl:text>
        </xsl:when>
        <xsl:when test="$attr='company'">
          <xsl:text>_Company</xsl:text>
        </xsl:when>
        <xsl:when test="$attr='ou'">
          <xsl:text>_Organizational Unit</xsl:text>
        </xsl:when>
        <xsl:when test="$attr='im'">
          <xsl:text>&nbsp;</xsl:text>
        </xsl:when>
        <xsl:when test="$attr='viewcalendar'">
          <xsl:text>&nbsp;</xsl:text>
        </xsl:when>
        <xsl:when test="$attr='givenname'">
          <xsl:text>_First Name</xsl:text>
        </xsl:when>
        <xsl:when test="$attr='surname'">
          <xsl:text>_Last Name</xsl:text>
        </xsl:when>
        <xsl:when test="$attr='edit'">
          <xsl:text>&nbsp;</xsl:text>
        </xsl:when>
        <xsl:when test="$attr='homeaddress'">
          <xsl:text>_Home Address</xsl:text>
        </xsl:when>
        <xsl:when test="$attr='workaddress'">
          <xsl:text>_Work Address</xsl:text>
        </xsl:when>
        <xsl:when test="$attr='email2'">
          <xsl:text>_Email 2</xsl:text>
        </xsl:when>
        <xsl:when test="$attr='email3'">
          <xsl:text>_Email 3</xsl:text>
        </xsl:when>
        <xsl:when test="$attr='homephone'">
          <xsl:text>_Phone (home)</xsl:text>
        </xsl:when>
        <xsl:when test="$attr='workphone'">
          <xsl:text>_Phone (work)</xsl:text>
        </xsl:when>
        <xsl:when test="$attr='mobilephone'">
          <xsl:text>_Mobile</xsl:text>
        </xsl:when>
        <xsl:when test="$attr='faxphone'">
          <xsl:text>_Fax</xsl:text>
        </xsl:when>
        <xsl:when test="$attr='pagerphone'">
          <xsl:text>_Pager</xsl:text>
        </xsl:when>
        <xsl:when test="$attr='otherphone'">
          <xsl:text>_Other phone</xsl:text>
        </xsl:when>
        <xsl:when test="$attr='title'">
          <xsl:text>_Job Title</xsl:text>
        </xsl:when>
        <xsl:when test="$attr='calendarurl' or $attr='calendarurlnolink'">
          <xsl:text>_Calendar Address</xsl:text>
        </xsl:when>
        <xsl:when test="$attr='freebusyurl'">
          <xsl:text>_Availability Address</xsl:text>
        </xsl:when>
        <xsl:when test="$attr='birthday'">
          <xsl:text>_Birthday</xsl:text>
        </xsl:when>
        <xsl:when test="$attr='anniversary'">
          <xsl:text>_Anniversary</xsl:text>
        </xsl:when>
        <xsl:when test="$attr='otherdate'">
          <xsl:text>_Other date</xsl:text>
        </xsl:when>
        <xsl:when test="$attr='weburl1'">
          <xsl:text>_Web Address</xsl:text>
        </xsl:when>
        <xsl:when test="$attr='weburl2'">
          <xsl:text>_Web Address </xsl:text>2
        </xsl:when>
        <xsl:when test="$attr='location'">
          <xsl:text>_Location</xsl:text>
        </xsl:when>
        <xsl:otherwise>
          <xsl:text>_Unknown attribute:</xsl:text>
        </xsl:otherwise>
      </xsl:choose>        

      <xsl:if test="$showsortby">
      <xsl:text>&nbsp;</xsl:text>
          <!-- then print the sorting arrow if the field is sortable -->
          <xsl:choose>
            <xsl:when test="$attr='displayname' or $attr='dnnolink'">              
                <xsl:call-template name="attr_display_sortby">
                  <xsl:with-param name="sortby" select="$sortby"/>
                  <xsl:with-param name="fieldpath" select="'entry/displayname'"/>
                  <xsl:with-param name="fieldname">
                    <xsl:text>_Name</xsl:text>
                  </xsl:with-param>
                </xsl:call-template>          
            </xsl:when>
            <xsl:when test="$attr='primaryemail' or $attr='primemailnolink'">
              <xsl:call-template name="attr_display_sortby">
                  <xsl:with-param name="sortby" select="$sortby"/>
                  <xsl:with-param name="fieldpath">
                    <xsl:text>email[@priority='1']</xsl:text>
                  </xsl:with-param>
                  <xsl:with-param name="fieldname">
                    <xsl:text>_email (primary)</xsl:text>
                  </xsl:with-param>
                </xsl:call-template>      
            </xsl:when>
            <xsl:when test="$attr='company'">  
                <xsl:call-template name="attr_display_sortby">
                  <xsl:with-param name="sortby" select="$sortby"/>
                  <xsl:with-param name="fieldpath" select="'organization/company'"/>
                  <xsl:with-param name="fieldname">
                    <xsl:text>_Company</xsl:text>
                  </xsl:with-param>
                </xsl:call-template>    
            </xsl:when>
            <xsl:when test="$attr='givenname'">   
                <xsl:call-template name="attr_display_sortby">
                  <xsl:with-param name="sortby" select="$sortby"/>
                  <xsl:with-param name="fieldpath" select="'person/givenname'"/>
                  <xsl:with-param name="fieldname">
                    <xsl:text>_First Name</xsl:text>
                  </xsl:with-param>
                </xsl:call-template>   
            </xsl:when>
            <xsl:when test="$attr='surname'">  
                <xsl:call-template name="attr_display_sortby">
                  <xsl:with-param name="sortby" select="$sortby"/>
                  <xsl:with-param name="fieldpath" select="'person/surname'"/>
                  <xsl:with-param name="fieldname">
                    <xsl:text>_Last Name</xsl:text>
                  </xsl:with-param>
                </xsl:call-template>    
            </xsl:when>
          </xsl:choose>
      </xsl:if>
</xsl:template>


<xsl:template name="attr_display_sortby">
  <xsl:param name="sortby"/>
  <xsl:param name="fieldpath"/>
  <xsl:param name="fieldname"/>

  <xsl:variable name="translatedpath" 
                select='translate($fieldpath,"&#39;","#")'/>
  <xsl:choose>
    <xsl:when test="concat('+',$fieldpath)=$sortby">
      <a href="javascript:sortBy('-{$translatedpath}','search.xml');">
          <xsl:attribute name="title">
            <xsl:text>_Sort Descending by </xsl:text>
            <xsl:value-of select="$fieldname"/>
          </xsl:attribute>
        <img src="{$ascending.gif}" width="9" height="8" border="0">        
          <xsl:attribute name="alt">
            <xsl:text>_Sort Descending by </xsl:text>
            <xsl:value-of select="$fieldname"/>
          </xsl:attribute>
        </img>
      </a>
    </xsl:when>
    <xsl:when test="concat('-',$fieldpath)=$sortby">
      <a href="javascript:sortBy('+{$translatedpath}','search.xml');">        
          <xsl:attribute name="title">
            <xsl:text>_Sort Ascending by </xsl:text>
            <xsl:value-of select="$fieldname"/>
          </xsl:attribute>
      <img src="{$descending.gif}" width="27" height="6" border="0">
          <xsl:attribute name="alt">
            <xsl:text>_Sort Ascending by </xsl:text>
            <xsl:value-of select="$fieldname"/>
          </xsl:attribute>
        </img>
      </a>
    </xsl:when>
    <xsl:otherwise>
      <a href="javascript:sortBy('+{$translatedpath}','search.xml');">
          <xsl:attribute name="title">
            <xsl:text>_Sort Ascending by </xsl:text>
            <xsl:value-of select="$fieldname"/>
          </xsl:attribute>
        <img src="{$not_selected.gif}" width="9" height="8" border="0">
          <xsl:attribute name="alt">
            <xsl:text>_Sort Ascending by </xsl:text>
            <xsl:value-of select="$fieldname"/>
          </xsl:attribute>
        </img>
      </a>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>


<!--
*******************************************************************************
* Print the attribute in its column
* @param displayAttribute The name of the attribute to display
*******************************************************************************
-->
<xsl:template name="displayAttr">
  <xsl:param name="displayAttribute"/>

  <xsl:choose>
    <xsl:when test="$displayAttribute='displayname'">
      <xsl:apply-templates select="entry/displayname" mode="list"/>
    </xsl:when>
    <xsl:when test="$displayAttribute='dnnolink'">
      <xsl:apply-templates select="entry/displayname" mode="nolink"/>
    </xsl:when>
    <xsl:when test="$displayAttribute='primaryemail'">
      <xsl:apply-templates select="email[@priority=1]" mode="common"/>
    </xsl:when>
    <xsl:when test="$displayAttribute='emailsnolink'">
      <script>
      var recordFound = false;
      <xsl:variable name="thisEntry" select="./entry/@entryID"/>
      <xsl:variable name="emailWPrefix">
        <xsl:text>id_</xsl:text><xsl:call-template name="escape">
        <xsl:with-param name="text" select="$thisEntry"/>
        </xsl:call-template>
        <xsl:text>_email_1</xsl:text>
      </xsl:variable>
      var hiddenEmailPar = document.iabform.elements["<xsl:value-of select="$emailWPrefix"/>"];
      <xsl:for-each select="/xslui/iab/alreadyselected/*">
         <xsl:if test="entry/@entryID=$thisEntry">
          document.write("<xsl:apply-templates select="email[@priority=1]" mode="nolink"/>");
           recordFound = true;
           if( hiddenEmailPar )
              hiddenEmailPar.value = '<xsl:value-of select="email[@priority=1]"/>';
         </xsl:if>
      </xsl:for-each>
      if( !recordFound ) {
        <xsl:variable name="cnt" select="count(email)"/>
        <xsl:choose> 
        <xsl:when test="$cnt=1">
          document.write("<xsl:apply-templates select="email" mode="nolink"/>");
        </xsl:when>
        <xsl:when test="$cnt>1">
          var listStr = '&lt;select id="email" name="email" onChange="javascript:setHiddenEmailParam(\'';
          listStr += "<xsl:value-of select="$emailWPrefix"/>";
          listStr += '\')"&gt;'; 
          <xsl:for-each select="email">
            var val = '<xsl:value-of select="."/>';
            listStr += '&lt;option value="' + val + '"&gt;' + val + '&lt;/option&gt;';
          </xsl:for-each>
          listStr += '&lt;/select&gt;';
          document.write(listStr);
          if( hiddenEmailPar ) {
              var emailSelected = document.iabform.elements["email"];
              hiddenEmailPar.value = emailSelected.options[emailSelected.selectedIndex].value;
          }
        </xsl:when>
        </xsl:choose>
      } 
      </script>
    </xsl:when>
    <xsl:when test="$displayAttribute='primemailnolink'">
      <xsl:apply-templates select="email[@priority=1]" mode="nolink"/>
    </xsl:when>
    <xsl:when test="$displayAttribute='primaryphone'">
      <xsl:apply-templates select="phone[@priority=1]" mode="list">
        <xsl:with-param name="displayType" select="true()"/>
      </xsl:apply-templates>
    </xsl:when>
    <xsl:when test="$displayAttribute='im'">
      <xsl:apply-templates select="im" mode="common"/>
    </xsl:when>
    <xsl:when test="$displayAttribute='calendaricon' or $displayAttribute='viewcalendar'">
      <xsl:apply-templates select="calendar[@type = 'calendar']" mode="common">
        <xsl:with-param name="display" select="'icon'"/>
      </xsl:apply-templates>
    </xsl:when>
    <xsl:when test="$displayAttribute='givenname'">
      <xsl:apply-templates select="person/givenname" mode="list"/>
    </xsl:when>
    <xsl:when test="$displayAttribute='surname'">
      <xsl:apply-templates select="person/surname" mode="list"/>
    </xsl:when>
    <xsl:when test="$displayAttribute='company'">
      <xsl:apply-templates select="organization/company" mode="list"/>
    </xsl:when>
    <xsl:when test="$displayAttribute='ou'">
      <xsl:apply-templates select="organization/organizationalunit" mode="list"/>
    </xsl:when>
    <xsl:when test="$displayAttribute='edit'">
      <xsl:apply-templates select="entry" mode="list"/>
    </xsl:when>
    <xsl:when test="$displayAttribute='homeaddress'">
      <xsl:apply-templates select="postaladdress[@type='home']" mode="list"/>
    </xsl:when>
    <xsl:when test="$displayAttribute='workaddress'">
      <xsl:apply-templates select="postaladdress[@type='work']" mode="list"/>
    </xsl:when>
    <xsl:when test="$displayAttribute='email2'">
      <xsl:apply-templates select="email[@type='work']" mode="common"/>
    </xsl:when>
    <xsl:when test="$displayAttribute='email3'">
      <xsl:apply-templates select="email[@type='home']" mode="common"/>
    </xsl:when>
    <xsl:when test="$displayAttribute='workphone'">
      <xsl:apply-templates select="phone[@type='work']" mode="list"/>
    </xsl:when>
    <xsl:when test="$displayAttribute='homephone'">
      <xsl:apply-templates select="phone[@type='home']" mode="list"/>
    </xsl:when>
    <xsl:when test="$displayAttribute='mobilephone'">
      <xsl:apply-templates select="phone[@type='mobile']" mode="list"/>
    </xsl:when>
    <xsl:when test="$displayAttribute='faxphone'">
      <xsl:apply-templates select="phone[@type='fax']" mode="list"/>
    </xsl:when>
    <xsl:when test="$displayAttribute='pagerphone'">
      <xsl:apply-templates select="phone[@type='pager']" mode="list"/>
    </xsl:when>
    <xsl:when test="$displayAttribute='otherphone'">
      <xsl:apply-templates select="phone[@type='other']" mode="list"/>
    </xsl:when>
    <xsl:when test="$displayAttribute='calendarurl'">
      <xsl:apply-templates select="calendar[@type = 'calendar']" mode="common">
        <xsl:with-param name="display" select="'url'"/>
      </xsl:apply-templates>
    </xsl:when>
    <xsl:when test="$displayAttribute='calendarurlnolink'">
      <xsl:apply-templates select="calendar[@type = 'calendar']" mode="nolink">
        <xsl:with-param name="display" select="'url'"/>
      </xsl:apply-templates>
    </xsl:when>
    <xsl:when test="$displayAttribute='freebusyurl'">
      <xsl:apply-templates select="calendar[@type = 'freebusy']" mode="common">
        <xsl:with-param name="display" select="'url'"/>
      </xsl:apply-templates>
    </xsl:when>
    <xsl:when test="$displayAttribute='title'">
      <xsl:apply-templates select="organization/title" mode="list"/>
    </xsl:when>
    <xsl:when test="$displayAttribute='birthday'">      
      <xsl:call-template name="date">
        <xsl:with-param name="date-param" select="person/date[@type='birthday']"/>
      </xsl:call-template>
    </xsl:when>
    <xsl:when test="$displayAttribute='anniversary'">      
      <xsl:call-template name="date">
        <xsl:with-param name="date-param" select="person/date[@type='anniversary']"/>
      </xsl:call-template>
    </xsl:when>
    <xsl:when test="$displayAttribute='otherdate'">      
        <xsl:apply-templates select="person/date[@type='other']" mode="common"/>      
    </xsl:when>
    <xsl:when test="$displayAttribute='weburl1'">
      <xsl:apply-templates select="weburl[@priority=1]" mode="common"/>
    </xsl:when>
    <xsl:when test="$displayAttribute='weburl2'">
      <xsl:apply-templates select="weburl[@priority=2]" mode="common"/>
    </xsl:when>
    <xsl:when test="$displayAttribute='location'">
        <xsl:apply-templates select="organization/location" mode="list"/>
    </xsl:when>
    <xsl:when test="$displayAttribute='manager'">
      <xsl:apply-templates select="organization/manager" mode="common"/>
    </xsl:when>
    <xsl:otherwise>
      <xsl:text>_Unknown attribute:</xsl:text>
      <xsl:value-of select="$displayAttribute"/>
    </xsl:otherwise>
  </xsl:choose> 
</xsl:template>

<!--
*******************************************************************************
* This template prints the combo box containing address books available to user.
* @param selectedBook Represents the address book that user is currently browsing
*******************************************************************************
-->
<xsl:template match="booklist" mode="list">
  <xsl:param name="selectedEntryID"/>
  <xsl:param name="name"/>
  <xsl:param name="onlyLocals" select="false()"/>
  <xsl:param name="bookType" select="2"/>
  <xsl:param name="onChangeAction"/>
  <xsl:param name="forid"/>
    <select name="{$name}" id="{$forid}">
      <xsl:if test="$onChangeAction">
        <xsl:attribute name="onChange">
          <xsl:value-of select="$onChangeAction" /> 
        </xsl:attribute>
      </xsl:if> 
              
      <xsl:attribute name="title">
        <xsl:text>_Address Book</xsl:text>
      </xsl:attribute>

      <xsl:if test="not($bookType=1)">         
          <xsl:for-each select="book[not(@bookremoteurl)]">
            <option>             
              <xsl:attribute name="value">
                <xsl:value-of select="entry/@entryID"/>
              </xsl:attribute>
              <xsl:if test="$selectedEntryID = entry/@entryID">
                <xsl:attribute name="selected"/>            
              </xsl:if>            
              <xsl:value-of select="entry/displayname"/>
            </option>
          </xsl:for-each>
      </xsl:if>
            
      <xsl:if test="not($onlyLocals) and not($bookType=0)">
        <xsl:choose>
        <xsl:when test="$bookType=1">
          <xsl:for-each select="book[@corporatedir]">
            <option>
              <xsl:attribute name="value">
                <xsl:value-of select="entry/@entryID"/>
              </xsl:attribute>
              <xsl:if test="$selectedEntryID = entry/@entryID">
                <xsl:attribute name="selected"/>
              </xsl:if>
              <xsl:value-of select="entry/displayname"/>
            </option>
          </xsl:for-each>
        </xsl:when>
        <xsl:otherwise>
          <optgroup>
            <xsl:attribute name="label"> 
            <xsl:text>_--- Remote Address Books ---</xsl:text>
            </xsl:attribute>
          <xsl:for-each select="book[@bookremoteurl]">          
            <option>
              <xsl:attribute name="value">
                <xsl:value-of select="entry/@entryID"/>
              </xsl:attribute>
              <xsl:if test="$selectedEntryID = entry/@entryID">
                <xsl:attribute name="selected"/>
              </xsl:if>
              <xsl:value-of select="entry/displayname"/>
            </option>
          </xsl:for-each>
          </optgroup>
        </xsl:otherwise>
        </xsl:choose>
      </xsl:if> 
    </select>  
</xsl:template>

<!--
*********************************************************************
* This template returns the name of the attribut to display for each
*   column.
* @param id which column we're looking for.
* @param selectedbook The book 
*******************************************************************************
-->
<xsl:template name="getColumnFieldName">
  <xsl:param name="id"/>
  <xsl:param name="xmlprofile"/>

  <xsl:choose>
    <xsl:when test="$xmlprofile and $xmlprofile/layoutinfo/displayelt">
      <xsl:value-of select="$xmlprofile/layoutinfo/displayelt[@order=$id]"/>
    </xsl:when>
    <xsl:otherwise>
      <xsl:choose>
        <xsl:when test="$id=1">displayname</xsl:when>
        <xsl:when test="$id=2">primaryemail</xsl:when>
        <xsl:when test="$id=3">primaryphone</xsl:when>        
        <xsl:otherwise></xsl:otherwise>
      </xsl:choose>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>
</xsl:stylesheet>

