<?xml version="1.0"?>
<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>

<xsl:stylesheet version='1.0' xmlns:xsl='http://www.w3.org/1999/XSL/Transform'>

<!--
****************************************************************
* Keeps the displayname of an entry in an hidden HTML input called
*  $prefix_displayname
* @param prefix The prefix of the hidden field (typically the
*  entryID of the entry we want to keep track of.
****************************************************************
-->
<xsl:template match="displayname" mode="hidden">
  <xsl:param name="prefix"/>

  <input type="hidden" value="{.}">
    <xsl:attribute name="name"><xsl:value-of select="$prefix"/>_displayname</xsl:attribute>
  </input>

</xsl:template>

<!--
****************************************************************
* Keeps an email of an entry in an hidden HTML input called
*  $prefix_email_$priority
* @param prefix The prefix of the hidden field (typically the
*  entryID of the entry we want to keep track of.
****************************************************************
-->
<xsl:template match="email" mode="hidden">
  <xsl:param name="prefix"/>

  <input type="hidden" value="{.}">
    <xsl:attribute name="name"><xsl:value-of select="$prefix"/>_email_<xsl:value-of select="@priority"/></xsl:attribute>
  </input>

</xsl:template>

<!--
****************************************************************
* Keeps the iPlanet IM id of an entry in an hidden HTML input called
*  $prefix_iim
* @param prefix The prefix of the hidden field (typically the
*  entryID of the entry we want to keep track of.
****************************************************************
-->
<xsl:template match="im" mode="hidden">
  <xsl:param name="prefix"/>

  <input type="hidden" value="{.}">
    <xsl:attribute name="name"><xsl:value-of select="$prefix"/>_iim</xsl:attribute>
  </input>

</xsl:template>
<!--
****************************************************************
* Keeps the calendar of an entry in an hidden HTML input called
*  $prefix_calendar
* @param prefix The prefix of the hidden field (typically the
*  entryID of the entry we want to keep track of.
****************************************************************
-->
<xsl:template match="calendar" mode="hidden">
  <xsl:param name="prefix"/>

  <input type="hidden" value="{urladdr[1]}">
    <xsl:attribute name="name"><xsl:value-of select="$prefix"/>_calendar</xsl:attribute>
  </input>

</xsl:template>

<!--
****************************************************************
* Keeps the context of a selected abperson using HTML hidden fields.
* The param is currently not used for abperson.
*  
* @param currentBookID The current Book EntryID this entry belongs to.
****************************************************************
-->
<xsl:template match="abperson|abconferenceroom" mode="hidden">
  <xsl:param name="currentBookID" select="''"/>

  <xsl:variable name="prefix">id_<xsl:value-of select="entry/@entryID"/></xsl:variable>

  <!-- adding the entryid first -->
  <input type="hidden" value='{entry/@entryID}'>
    <xsl:attribute name="name">
      <xsl:value-of select="concat($prefix, '_entryid')"/></xsl:attribute>
  </input>

  <!-- then the entrytype -->
  <input type="hidden" value="{name(.)}">
    <xsl:attribute name="name">
      <xsl:value-of select="concat($prefix, '_entrytype')"/>
    </xsl:attribute>
  </input>

  <!-- the bookid -->
  <input type="hidden">
    <xsl:attribute name="name"><xsl:value-of select="$prefix"/>_bookid</xsl:attribute>
    <xsl:attribute name="value">
      <xsl:choose>
        <xsl:when test="string-length($currentBookID) > 0">
          <xsl:value-of select="$currentBookID"/>
        </xsl:when>
        <xsl:when test="memberofbook">
          <xsl:value-of select="memberofbook"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:text>No BookID</xsl:text>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:attribute>
  </input>

  <input type="hidden" value="{@uid}">
    <xsl:attribute name="name">
      <xsl:value-of select="concat($prefix, '_uid')"/>
    </xsl:attribute>
  </input>
  <xsl:apply-templates select="entry/displayname" mode="hidden">
    <xsl:with-param name="prefix" select="$prefix"/>
  </xsl:apply-templates>
  <xsl:apply-templates select="email[@priority=1]" mode="hidden">
        <xsl:with-param name="prefix" select="$prefix"/>
  </xsl:apply-templates>
  <xsl:apply-templates select="calendar[@type = 'calendar']" mode="hidden">
    <xsl:with-param name="prefix" select="$prefix"/>
  </xsl:apply-templates>
  <xsl:apply-templates select="im[@service = 'iPlanet']" mode="hidden">
    <xsl:with-param name="prefix" select="$prefix"/>
  </xsl:apply-templates>


</xsl:template>

<!--
****************************************************************
* Keeps the context of a selected group using HTML hidden fields.
*
* The entryID of the book this group belongs to is stored as well.
*  If the currentBookID parameter is not empty, we use it.
*  Otherwise, we use the memberofbook element of the current group.
*  
* @param currentBookID The current Book EntryID this entry belongs to.
****************************************************************
-->
<xsl:template match="group" mode="hidden">
  <xsl:param name="currentBookID" select="''"/>
  <xsl:variable name="lcletters">abcdefghijklmnopqrstuvwxyz</xsl:variable>
  <xsl:variable name="ucletters">ABCDEFGHIJKLMNOPQRSTUVWXYZ</xsl:variable>
  <xsl:variable name="prefix">id_<xsl:value-of select="entry/@entryID"/></xsl:variable>

  <!-- adding the entryid first -->
  <input type="hidden" value='{entry/@entryID}'>
    <xsl:attribute name="name"><xsl:value-of select="$prefix"/>_entryid</xsl:attribute>
  </input>
  <!-- groupoc -->
  <xsl:for-each select="groupoc">
    <xsl:variable name="ocval" select="translate(.,$ucletters,$lcletters)"/>
    <input type="hidden">
      <xsl:attribute name="value"><xsl:value-of select="$ocval"/></xsl:attribute>
      <xsl:attribute name="name"><xsl:value-of select="$prefix"/>_oc</xsl:attribute>
    </input>
  </xsl:for-each>
  <xsl:for-each select="members/member">
    <input type="hidden" value="{.}">
      <xsl:attribute name="name"><xsl:value-of select="$prefix"/>_uniqueMember</xsl:attribute>
     </input>
  </xsl:for-each>

  <!-- mail -->
  <xsl:if test="email">
    <input type="hidden" value="{email}">
      <xsl:attribute name="name"><xsl:value-of select="$prefix"/>_email_1</xsl:attribute>
    </input>
  </xsl:if>

  <!-- the bookid -->
  <input type="hidden">
    <xsl:attribute name="name"><xsl:value-of select="$prefix"/>_bookid</xsl:attribute>
    <xsl:attribute name="value">
      <xsl:choose>
        <xsl:when test="string-length($currentBookID) > 0">
          <xsl:value-of select="$currentBookID"/>
        </xsl:when>
        <xsl:when test="memberofbook">
          <xsl:value-of select="memberofbook"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:text>No BookID</xsl:text>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:attribute>
  </input>

  <!-- then the entrytype -->
  <input type="hidden" value="group">
    <xsl:attribute name="name"><xsl:value-of select="$prefix"/>_entrytype</xsl:attribute>
  </input>

  <xsl:apply-templates select="entry/displayname" mode="hidden">
    <xsl:with-param name="prefix" select="$prefix"/>
  </xsl:apply-templates>
  <xsl:apply-templates select="calendar[@type = 'calendar']" mode="hidden">
    <xsl:with-param name="prefix" select="$prefix"/>
  </xsl:apply-templates>
</xsl:template>

<xsl:template match="book" mode="hidden">
  <xsl:variable name="prefix">id_<xsl:value-of select="entry/@entryID"/></xsl:variable>

  <!-- adding the entryid first -->
  <input type="hidden" value="{entry/@entryID}">
    <xsl:attribute name="name"><xsl:value-of select="$prefix"/>_entryid</xsl:attribute>
  </input>
  <!-- then the entrytype -->
  <input type="hidden" value="{@booktype}">
    <xsl:attribute name="name"><xsl:value-of select="$prefix"/>_entrytype</xsl:attribute>
  </input>
  <xsl:apply-templates select="entry/displayname" mode="hidden">
    <xsl:with-param name="prefix" select="$prefix"/>
  </xsl:apply-templates>
 
</xsl:template> 


</xsl:stylesheet>

