<?xml version="1.0"?>
<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>

<xsl:stylesheet version='1.0' xmlns:xsl='http://www.w3.org/1999/XSL/Transform'>

<xsl:variable name="fieldPrefix" select="'abperson_'"/>
<xsl:variable name="valueSeparator" select="';'"/>

<!--
*******************************************************************************
* This template prints the Name and Company part of contact detail
* @param abperson The node in which to extract the name and company
*******************************************************************************
-->
<xsl:template name="nameAndCompany">
  <xsl:param name="abperson"/>
  <xsl:param name="autoFillDisplayName" select="false()"/>

  <tr> 
    <td class="PropLabelAb" width="24%">
      <span class="Lbl2"><label for="firstName"><xsl:text>_First Name</xsl:text></label>:</span> 
        <xsl:choose>
        <xsl:when test="$abperson">
          <input type="text" id="firstName" name="{$fieldPrefix}givenName" size="25" value="{$abperson/person/givenname}" tabindex="8">
            <xsl:attribute name="onChange">
              <xsl:text>javascript:this.value = this.value.trim();</xsl:text>
              <xsl:if test="$autoFillDisplayName">autoFillDisplayName(this)</xsl:if> 
            </xsl:attribute> 
            <xsl:attribute name="onBlur">
              <xsl:text>javascript:this.value = this.value.trim();</xsl:text>
              <xsl:if test="$autoFillDisplayName">autoFillDisplayName(this)</xsl:if> 
            </xsl:attribute> 
          </input>
        </xsl:when>
        <xsl:otherwise>
          <input type="text" id="firstname" name="{$fieldPrefix}givenName" size="25" tabindex="8">
            <xsl:attribute name="onChange">
               <xsl:text>javascript:this.value = this.value.trim();</xsl:text>
              <xsl:if test="$autoFillDisplayName">autoFillDisplayName(this)</xsl:if> 
            </xsl:attribute> 
            <xsl:attribute name="onBlur">
              <xsl:text>javascript:this.value = this.value.trim();</xsl:text>
              <xsl:if test="$autoFillDisplayName">autoFillDisplayName(this)</xsl:if> 
            </xsl:attribute> 
          </input>
        </xsl:otherwise>
        </xsl:choose>
    </td>
    <td class="PropLabel" width="24%">
     <span class="Lbl2"><label for="middleName"><xsl:text>_Middle</xsl:text></label>:</span>
     <xsl:choose>
        <xsl:when test="$abperson">
          <input type="text" id="middleName" name="{$fieldPrefix}middleName" size="20"  value="{$abperson/person/middlename}" tabindex="9" onChange="javascipt:this.value=this.value.trim()"/>
        </xsl:when>
        <xsl:otherwise>
          <input type="text" id="middleName" name="{$fieldPrefix}middleName" size="20" tabindex="9" onChange="javascipt:this.value=this.value.trim()"/>
        </xsl:otherwise>
     </xsl:choose>       
    </td>
    <td class="PropLabel" width="28%">
      <span class="Lbl2"><label for="lastName"><xsl:text>_Last Name</xsl:text></label>:</span> 
        <xsl:choose>
        <xsl:when test="$abperson">
          <input type="text" id="lastName" name="{$fieldPrefix}sn" size="25" value="{$abperson/person/surname}" tabindex="10">
            <xsl:attribute name="onChange">
              <xsl:text>javascript:this.value = this.value.trim();</xsl:text>
              <xsl:if test="$autoFillDisplayName">autoFillDisplayName(this)</xsl:if> 
            </xsl:attribute> 
            <xsl:attribute name="onBlur">
              <xsl:text>javascript:this.value = this.value.trim();</xsl:text>
              <xsl:if test="$autoFillDisplayName">autoFillDisplayName(this)</xsl:if> 
            </xsl:attribute> 
          </input>
        </xsl:when>
        <xsl:otherwise>
          <input type="text" id="lastName" name="{$fieldPrefix}sn" size="25" tabindex="10">
            <xsl:attribute name="onChange">
              <xsl:text>javascript:this.value = this.value.trim();</xsl:text>
              <xsl:if test="$autoFillDisplayName">autoFillDisplayName(this)</xsl:if> 
            </xsl:attribute> 
            <xsl:attribute name="onBlur">
              <xsl:text>javascript:this.value = this.value.trim();</xsl:text>
              <xsl:if test="$autoFillDisplayName">autoFillDisplayName(this)</xsl:if> 
            </xsl:attribute> 
          </input>
        </xsl:otherwise>
      </xsl:choose> 
    </td>
    <td width="18%">&nbsp;</td>
    <td width="6%">&nbsp;</td>
  </tr>
  <tr> 
    <td class="PropLabelAb" colspan="2">
      <span class="Lbl2"><label for="displayName"><img alt="required field" src="../absimx/required.gif" width="7" height="14"/>&nbsp;<xsl:text>_Display Name</xsl:text></label></span><br/>
        <xsl:choose>
        <xsl:when test="$abperson">
          <input type="text" id="displayName" name="{$fieldPrefix}displayName" size="25" value="{$abperson/entry/displayname}" tabindex="11" onkeypress="javascript:window.display_entered = true;window.curr_val_is_autofill = false;" onChange="javascipt:this.value=this.value.trim()" onBlur="javascipt:this.value=this.value.trim()"/>
        </xsl:when>
        <xsl:otherwise>
          <input type="text" id="displayName" name="{$fieldPrefix}displayName" size="25" tabindex="11" onkeypress="javascript:window.display_entered = true;window.curr_val_is_autofill = false;" onChange="javascipt:this.value=this.value.trim()" onBlur="javascipt:this.value=this.value.trim()"/>
        </xsl:otherwise>
      </xsl:choose> 
    </td>
    <td width="28%">&nbsp;</td>
    <td width="18%">&nbsp;</td>
    <td width="6%">&nbsp;</td>
  </tr>
  <tr> 
    <td class="PropLabelAb" width="24%"><span class="Lbl2"><label for="company"><xsl:text>_Company</xsl:text></label>:</span> 
      <xsl:choose>
       <xsl:when test="$abperson">
          <input type="text" id="company" name="{$fieldPrefix}company" size="25" value="{$abperson/organization/company}" tabindex="12">
            <xsl:attribute name="onChange">
              <xsl:text>javascript:this.value = this.value.trim();</xsl:text>
              <xsl:if test="$autoFillDisplayName">autoFillDisplayName(this)</xsl:if> 
            </xsl:attribute> 
            <xsl:attribute name="onBlur">
              <xsl:text>javascript:this.value = this.value.trim();</xsl:text>
              <xsl:if test="$autoFillDisplayName">autoFillDisplayName(this)</xsl:if> 
            </xsl:attribute> 
          </input>
        </xsl:when>
        <xsl:otherwise>
          <input type="text" id="company" name="{$fieldPrefix}company" size="25" tabindex="12">
            <xsl:attribute name="onChange">
              <xsl:text>javascript:this.value = this.value.trim();</xsl:text>
              <xsl:if test="$autoFillDisplayName">autoFillDisplayName(this)</xsl:if> 
            </xsl:attribute> 
            <xsl:attribute name="onBlur">
              <xsl:text>javascript:this.value = this.value.trim();</xsl:text>
              <xsl:if test="$autoFillDisplayName">autoFillDisplayName(this)</xsl:if> 
            </xsl:attribute> 
          </input>
        </xsl:otherwise>
      </xsl:choose> 
    </td>
    <td class="PropLabel" width="24%"><span class="Lbl2"><label for="jobTitle"><xsl:text>_Job Title</xsl:text></label>:</span> 
        <xsl:choose>
        <xsl:when test="$abperson">
          <input type="text" id="jobTitle" name="{$fieldPrefix}jobTitle" size="25" value="{$abperson/organization/title}" tabindex="13" onChange="javascipt:this.value=this.value.trim()"/>
        </xsl:when>
        <xsl:otherwise>
          <input type="text" id="jobTitle" name="{$fieldPrefix}jobTitle" size="25" tabindex="13" onChange="javascipt:this.value=this.value.trim()"/>
        </xsl:otherwise>
      </xsl:choose>
    </td>
    <td width="28%">&nbsp;</td>
    <td width="18%">&nbsp;</td>
    <td width="6%">&nbsp;</td>
  </tr>
  <tr> 
    <td class="PropLabel" colspan="5"><a href="#top" class="Lnk" tabindex="14">
      <xsl:attribute name="title">
        <xsl:text>_Jump Down to top</xsl:text>
      </xsl:attribute>
      <img src="../absimx/LrlToTop_1.gif" width="11" height="10" alt="Jump Down to top" border="0"/><xsl:text>_Jump Down to top</xsl:text></a>
    </td>
  </tr>
</xsl:template> 


<!--
*******************************************************************************
* This template prints the Phone Email and IM part of contact detail
* @param abperson The node in which to extract the Phone, Email and IM
*******************************************************************************
-->
<xsl:template name="phoneEmailAndIM">
  <xsl:param name="abperson" />
  <tr> 
    <td class="PropLabel" colspan="5"><img alt="" src="{$spacer.gif}" width="10" height="8"/><a name="phone"></a></td>
  </tr>
  <tr> 
    <td colspan="5"> 
      <table width="100%" border="0" cellspacing="0" cellpadding="0">
        <tr> 
          <td width="1%"><img alt="" src="{$spacer.gif}" width="10" height="5"/></td>
          <td width="98%" class="SectionDivider"><img alt="" src="{$spacer.gif}" width="1" height="5"/></td>
          <td width="1%"><img alt="" src="{$spacer.gif}" width="10" height="5"/></td>
        </tr>
       </table>
     </td>
   </tr>
   <tr> 
     <td class="SectionHeader" colspan="5"><span class="SectionHeader"><xsl:text>_Phone</xsl:text></span></td>
   </tr>

  <tr> 
  <td colspan="5"> 
    <table width="100%" border="0" cellspacing="0" cellpadding="0"  summary="This table contains phone and email information">
      <tr>         
        <xsl:call-template name="phone">
         <xsl:with-param name="abperson" select="$abperson"/>
         <xsl:with-param name="priority" select="'1'"/>
         <xsl:with-param name="width" select="43"/>
	 <xsl:with-param name="tabindex" select="'15'"/>
        </xsl:call-template>        
        
        <xsl:call-template name="phone">
          <xsl:with-param name="abperson" select="$abperson"/>
          <xsl:with-param name="priority" select="'4'"/>
          <xsl:with-param name="width" select="57"/>
          <xsl:with-param name="tabindex" select="'17'"/>
         </xsl:call-template>       
      </tr>
      <tr>         
        <xsl:call-template name="phone">
         <xsl:with-param name="abperson" select="$abperson"/>
         <xsl:with-param name="priority" select="'2'"/>
         <xsl:with-param name="width" select="43"/>
         <xsl:with-param name="tabindex" select="'19'"/>
        </xsl:call-template>        
        
        <xsl:call-template name="phone">
          <xsl:with-param name="abperson" select="$abperson"/>
          <xsl:with-param name="priority" select="'5'"/>
          <xsl:with-param name="width" select="57"/>
          <xsl:with-param name="tabindex" select="'21'"/>
         </xsl:call-template>       
      </tr>
      <tr>         
        <xsl:call-template name="phone">
         <xsl:with-param name="abperson" select="$abperson"/>
         <xsl:with-param name="priority" select="'3'"/>
         <xsl:with-param name="width" select="43"/>
         <xsl:with-param name="tabindex" select="'23'"/>
        </xsl:call-template>        
        <td width="57%">&nbsp;</td>
      </tr>
      <tr> 
        <td class="PropLabel" colspan="5"><a class="Lnk" href="#top" tabindex="25">
        <xsl:attribute name="title">
        <xsl:text>_Jump Down to top</xsl:text>
        </xsl:attribute>
        <img src="../absimx/LrlToTop_1.gif" width="11" height="10" alt="Jump Down to top" border="0"/><xsl:text>_Jump Down to top</xsl:text></a></td>
      </tr>
      <tr> 
        <td class="PropLabel" colspan="5"><img alt="" src="{$spacer.gif}" width="10" height="8"/><a name="email"></a></td>
      </tr>
      </table>
    </td>
  </tr>
  <!-- 
    Email part 
  -->
  <tr> 
      <td colspan="5"> 
        <table width="100%" border="0" cellspacing="0" cellpadding="0">
          <tr> 
            <td width="1%"><img alt="" src="{$spacer.gif}" width="10" height="5"/></td>
            <td width="98%" class="SectionDivider"><img alt="" src="{$spacer.gif}" width="1" height="5"/></td>
            <td width="1%"><img alt="" src="{$spacer.gif}" width="10" height="5"/></td>
          </tr>
        </table>
      </td>
    </tr>
    <tr> 
      <td class="SectionHeader" colspan="5"><span class="SectionHeader"><xsl:text>_Email</xsl:text></span></td>
    </tr>
    <tr> 
     <td colspan="5"> 
      <table width="100%" border="0" cellspacing="0" cellpadding="0" summary="This table contains email information">     
      <tr> 
       <xsl:call-template name="email">
        <xsl:with-param name="abperson" select="$abperson"/>
        <xsl:with-param name="priority" select="'1'"/>
        <xsl:with-param name="tabindex" select="'26'"/>
       </xsl:call-template>
  
       <xsl:call-template name="email">
        <xsl:with-param name="abperson" select="$abperson"/>
        <xsl:with-param name="priority" select="'3'"/>
        <xsl:with-param name="tabindex" select="'28'"/>
       </xsl:call-template>
      </tr>
      <tr>
      <xsl:call-template name="email">
        <xsl:with-param name="abperson" select="$abperson"/>
        <xsl:with-param name="priority" select="'2'"/>
        <xsl:with-param name="tabindex" select="'30'"/>
      </xsl:call-template>
     </tr>
     <tr>
      <td class="PropLabelAb" colspan="5"><img src="../absimx/LrlToTop_1.gif" width="11" height="10" alt="Jump Down to top"/>
      <a href="#top" class="JmpLnk" title="Jump Down to top" tabindex="31">
      <xsl:attribute name="title">
         <xsl:text>_Jump Down to top</xsl:text>
      </xsl:attribute>
      <xsl:text>_Jump Down to top</xsl:text></a>
      </td>
    </tr>  
    <tr> 
      <td class="PropLabel" colspan="5"><img alt="" src="{$spacer.gif}" width="10" height="8"/><a name="addresses"></a></td>
    </tr>
    </table>
   </td>
  </tr>  
</xsl:template> 


<!--
*******************************************************************************
* This template prints the Address part of contact detail
* @param abperson The node in which to extract the address node 
* @param type The type of the address to be printed
*******************************************************************************
-->
<xsl:template name="address">
  <xsl:param name="abperson" />

  <tr> 
    <td colspan="5"> 
      <table width="100%" border="0" cellspacing="0" cellpadding="0">
        <tr> 
          <td width="1%"><img alt="" src="{$spacer.gif}" width="10" height="5"/></td>
          <td width="98%" class="SectionDivider"><img alt="" src="{$spacer.gif}" width="1" height="5"/></td>
          <td width="1%"><img alt="" src="{$spacer.gif}" width="10" height="5"/></td>
        </tr>
       </table>
     </td>
   </tr>
   <tr> 
     <td class="SectionHeader" colspan="5"><span class="SectionHeader"><xsl:text>_Addresses</xsl:text></span></td>
   </tr>  
   <xsl:variable name="type" select="'work'"/>
  <tr> 
    <td colspan="5"> 
      <table width="100%" border="0" cellspacing="0" cellpadding="0" summary="This table contains address information">
      <tr> 
       <td class="PropLabelAb" colspan="4"><span class="Lbl2"><label for="workstreet">      
        <xsl:text>_Work Street</xsl:text>:</label></span><br/>
          <textarea id="workstreet" cols="40" tabindex="32" onChange="javascipt:this.value=this.value.trim()">
             <xsl:attribute name="name">
                <xsl:value-of select="$fieldPrefix" /> 
                <xsl:value-of select="$type"/>  
                <xsl:text>PostalAddress</xsl:text>
             </xsl:attribute>
              <xsl:if test="$abperson">
                <xsl:value-of select="$abperson/postaladdress[@type = $type]/street"/>
              </xsl:if> 
           </textarea>
        </td>
       </tr>
       <tr> 
         <td class="PropLabelAb" width="25%"><span class="Lbl2"><label for="workcity">    
           <xsl:text>_Work City</xsl:text>:</label></span>
           <br/>
           <input type="text" id="workcity" name="{$fieldPrefix}{$type}City" size="15" tabindex="33" onChange="javascipt:this.value=this.value.trim()">
            <xsl:if test="$abperson">
             <xsl:attribute name="value">
              <xsl:value-of select="$abperson/postaladdress[@type = $type]/city"/>
             </xsl:attribute> 
            </xsl:if> 
           </input>
         </td>
         <td width="19%"><span class="Lbl2"><label for="workstate"><xsl:text>_Work State</xsl:text>:</label></span> 
           <br/>
           <input type="text" id="workstate" name="{$fieldPrefix}{$type}State" size="15" tabindex="34" onChange="javascipt:this.value=this.value.trim()">
           <xsl:if test="$abperson">
            <xsl:attribute name="value">
              <xsl:value-of select="$abperson/postaladdress[@type = $type]/state"/>
            </xsl:attribute> 
           </xsl:if> 
           </input>
         </td>
         <td width="26%"><span class="Lbl2"><label for="workzip"><xsl:text>_Work Zip/Postal Code</xsl:text>:</label></span> 
           <br/>
           <input type="text" id="workzip" name="{$fieldPrefix}{$type}PostalCode" size="15" tabindex="35" onChange="javascipt:this.value=this.value.trim()">
           <xsl:if test="$abperson">
            <xsl:attribute name="value">
              <xsl:value-of select="$abperson/postaladdress[@type = $type]/postalcode"/>
            </xsl:attribute> 
           </xsl:if> 
           </input>
         </td>
         <td width="35%"><span class="Lbl2"><label for="workcountry"><xsl:text>_Work Country</xsl:text>:</label></span> 
          <br/>
          <input type="text" id="workcountry" name="{$fieldPrefix}{$type}Country" size="15" tabindex="36" onChange="javascipt:this.value=this.value.trim()">
          <xsl:if test="$abperson">
            <xsl:attribute name="value">
              <xsl:value-of select="$abperson/postaladdress[@type = $type]/country"/>
            </xsl:attribute> 
          </xsl:if> 
          </input>
          </td>
     </tr>
     <xsl:variable name="type-h" select="'home'"/>
     <tr> 
       <td class="PropLabelAb" colspan="4"><span class="Lbl2"><label for="homestreet">      
        <xsl:text>_Home Street</xsl:text>:</label></span><br/>
          <textarea cols="40" tabindex="37" onChange="javascipt:this.value=this.value.trim()">
             <xsl:attribute name="name">
                <xsl:value-of select="$fieldPrefix" /> 
                <xsl:value-of select="$type-h"/>  
                <xsl:text>PostalAddress</xsl:text>
             </xsl:attribute>
              <xsl:if test="$abperson">
                <xsl:value-of select="$abperson/postaladdress[@type = $type-h]/street"/>
              </xsl:if> 
           </textarea>
        </td>
       </tr>
       <tr> 
         <td class="PropLabelAb" width="25%"><span class="Lbl2"><label for="homecity">    
           <xsl:text>_Home City</xsl:text>:</label></span>
           <br/>
           <input type="text" id="homecity" name="{$fieldPrefix}{$type-h}City" size="15" tabindex="38" onChange="javascipt:this.value=this.value.trim()">
            <xsl:if test="$abperson">
             <xsl:attribute name="value">
              <xsl:value-of select="$abperson/postaladdress[@type = $type-h]/city"/>
             </xsl:attribute> 
            </xsl:if> 
           </input>
         </td>
         <td width="19%"><span class="Lbl2"><label for="homestate"><xsl:text>_Home State</xsl:text>:</label></span> 
           <br/>
           <input type="text" id="homestate" name="{$fieldPrefix}{$type-h}State" size="15" tabindex="39" onChange="javascipt:this.value=this.value.trim()">
           <xsl:if test="$abperson">
            <xsl:attribute name="value">
              <xsl:value-of select="$abperson/postaladdress[@type = $type-h]/state"/>
            </xsl:attribute> 
           </xsl:if> 
           </input>
         </td>
         <td width="26%"><span class="Lbl2"><label for="homezip"><xsl:text>_Home Zip/Postal Code</xsl:text>:</label></span> 
           <br/>
           <input type="text" id="homezip" name="{$fieldPrefix}{$type-h}PostalCode" size="15" tabindex="40" onChange="javascipt:this.value=this.value.trim()">
           <xsl:if test="$abperson">
            <xsl:attribute name="value">
              <xsl:value-of select="$abperson/postaladdress[@type = $type-h]/postalcode"/>
            </xsl:attribute> 
           </xsl:if> 
           </input>
         </td>
         <td width="35%"><span class="Lbl2"><label for="homecountry"><xsl:text>_Home Country</xsl:text>:</label></span> 
          <br/>
          <input type="text" id="homecountry" name="{$fieldPrefix}{$type-h}Country" size="15" tabindex="41" onChange="javascipt:this.value=this.value.trim()">
          <xsl:if test="$abperson">
            <xsl:attribute name="value">
              <xsl:value-of select="$abperson/postaladdress[@type = $type-h]/country"/>
            </xsl:attribute> 
          </xsl:if> 
          </input>
          </td>
       </tr>
     <tr>
      <td class="PropLabelAb" colspan="5"><img src="../absimx/LrlToTop_1.gif" width="11" height="10" alt="Jump Down to top"/>
      <a href="#top" class="JmpLnk" title="Jump Down to top" tabindex="42">
      <xsl:attribute name="title">
         <xsl:text>_Jump Down to top</xsl:text>
       </xsl:attribute>
       <xsl:text>_Jump Down to top</xsl:text></a>
      </td>
    </tr>  
    <tr> 
        <td class="PropLabel" colspan="5"><img alt="" src="{$spacer.gif}" width="10" height="8"/><a name="online"></a></td>
    </tr>
    </table>
   </td>
  </tr>    
</xsl:template> 


<!--
*******************************************************************************
* This template prints the Online Informations part of contact detail
* @param abperson The node in which to extract the onlineInfos
*******************************************************************************
-->
<xsl:template name="onlineInfos">
  <xsl:param name="abperson" />
  <tr> 
    <td colspan="5"> 
      <table width="100%" border="0" cellspacing="0" cellpadding="0">
        <tr> 
          <td width="1%"><img alt="" src="{$spacer.gif}" width="10" height="5"/></td>
          <td width="98%" class="SectionDivider"><img alt="" src="{$spacer.gif}" width="1" height="5"/></td>
          <td width="1%"><img alt="" src="{$spacer.gif}" width="10" height="5"/></td>
        </tr>
      </table>
    </td>
  </tr>
  <tr> 
    <td class="SectionHeader" colspan="5"><span class="SectionHeader"><xsl:text>_Online</xsl:text></span></td>
  </tr>
  <tr> 
    <td colspan="5"> 
    <table width="100%" border="0" cellspacing="0" cellpadding="0" summary="This table contains online-availability information">
      <tr> 
        <xsl:call-template name="weburl">
          <xsl:with-param name="abperson" select="$abperson"/>
          <xsl:with-param name="priority" select="'1'"/>
	  <xsl:with-param name="tabindex" select="'43'"/>
        </xsl:call-template>
        <xsl:call-template name="weburl">
         <xsl:with-param name="abperson" select="$abperson"/>
         <xsl:with-param name="priority" select="'2'"/>
	  <xsl:with-param name="tabindex" select="'44'"/>
        </xsl:call-template>
      </tr>
      <tr> 
        <xsl:call-template name="calendar">
          <xsl:with-param name="abperson" select="$abperson"/>
          <xsl:with-param name="type" select="'calendar'"/>
	  <xsl:with-param name="tabindex" select="'45'"/>
        </xsl:call-template>
        <xsl:call-template name="calendar">
          <xsl:with-param name="abperson" select="$abperson"/>
          <xsl:with-param name="type" select="'freebusy'"/>
	  <xsl:with-param name="tabindex" select="'46'"/>
        </xsl:call-template>
      </tr>
      <tr> 
         <td class="SubSectionHeader" colspan="2"><span class="SubSectionHeader"><xsl:text>_Instant Messaging (IM) Nickname and Service</xsl:text></span></td>
      </tr>
      <tr> 
        <xsl:call-template name="im">
          <xsl:with-param name="abperson" select="$abperson"/>
          <xsl:with-param name="priority" select="'1'"/>
          <xsl:with-param name="width" select="40"/>
	  <xsl:with-param name="tabindex" select="'47'"/>
        </xsl:call-template>
        <xsl:call-template name="im">
          <xsl:with-param name="abperson" select="$abperson"/>
          <xsl:with-param name="priority" select="'2'"/>
          <xsl:with-param name="width" select="60"/>
	  <xsl:with-param name="tabindex" select="'49'"/>
        </xsl:call-template>
      </tr>
      <tr>
        <td class="PropLabelAb" colspan="5"><img src="../absimx/LrlToTop_1.gif" width="11" height="10" alt="Jump Down to top"/>
        <a href="#top" class="JmpLnk" title="Jump Down to top" tabindex="51">
         <xsl:attribute name="title">
         <xsl:text>_Jump Down to top</xsl:text>
         </xsl:attribute>
         <xsl:text>_Jump Down to top</xsl:text></a>
        </td>
      </tr>
      <tr> 
        <td class="PropLabel" colspan="5"><img alt="" src="{$spacer.gif}" width="10" height="8"/><a name="dates"></a></td>
      </tr>
      </table>
    </td>
  </tr>
</xsl:template> 


<!--
*****************************************************************************
* This template prints the Important dates part of contact detail
* @param abperson which is a abperson node
* @param @dateFormat The output format for the dates
*****************************************************************************
-->
<xsl:template name="importantDates">
  <xsl:param name="abperson"/>
  <xsl:param name="dateFormat" />
  
  <tr> 
    <td colspan="5"> 
      <table width="100%" border="0" cellspacing="0" cellpadding="0">
        <tr> 
          <td width="1%"><img alt="" src="{$spacer.gif}" width="10" height="5"/></td>
          <td width="98%" class="SectionDivider"><img alt="" src="{$spacer.gif}" width="1" height="5"/></td>
          <td width="1%"><img alt="" src="{$spacer.gif}" width="10" height="5"/></td>
        </tr>
      </table>
    </td>
  </tr>
  <tr> 
    <td class="SectionHeader" colspan="5"><span class="SectionHeader"><xsl:text>_Dates</xsl:text></span></td>
  </tr>

  <tr> 
   <td colspan="5"> 
    <table width="100%" border="0" cellspacing="0" cellpadding="0" summary="This table contains important dates">  
    <tr> 
      <xsl:call-template name="date">
        <xsl:with-param name="abperson" select="$abperson"/>
        <xsl:with-param name="type" select="'birthday'"/>
        <xsl:with-param name="index" select="'1'"/>
        <xsl:with-param name="dateFormat" select="$dateFormat"/>
        <xsl:with-param name="width" select="40"/>
        <xsl:with-param name="fieldName" >
          <xsl:value-of select="$fieldPrefix" /> 
          <xsl:text>dateOfBirth</xsl:text>
        </xsl:with-param>
        <xsl:with-param name="label">
          <xsl:text>_Birthday</xsl:text>
        </xsl:with-param>
	<xsl:with-param name="tabindex" select="'52'"/>
      </xsl:call-template>

      <xsl:call-template name="date">
        <xsl:with-param name="abperson" select="$abperson"/>
        <xsl:with-param name="type" select="'anniversary'"/>
        <xsl:with-param name="index" select="'2'"/>
        <xsl:with-param name="dateFormat" select="$dateFormat"/>
        <xsl:with-param name="width" select="65"/>
        <xsl:with-param name="fieldName" >
          <xsl:value-of select="$fieldPrefix" /> 
          <xsl:text>anniversary</xsl:text>
        </xsl:with-param>
        <xsl:with-param name="label">
          <xsl:text>_Anniversary</xsl:text>
        </xsl:with-param>
	<xsl:with-param name="tabindex" select="'55'"/>
      </xsl:call-template>
    </tr>
    <tr>
      <td class="PropLabelAb" colspan="5"><img src="../absimx/LrlToTop_1.gif" width="11" height="10" alt="Jump Down to top"/>
      <a href="#top" class="JmpLnk" title="Jump Down to top" tabindex="58">
       <xsl:attribute name="title">
         <xsl:text>_Jump Down to top</xsl:text>
       </xsl:attribute>
       <xsl:text>_Jump Down to top</xsl:text></a>
      </td>
    </tr> 
    <tr> 
        <td class="PropLabel" colspan="5"><img alt="" src="{$spacer.gif}" width="10" height="8"/><a name="notes"></a></td>
    </tr> 
    </table>
   </td>
  </tr>  
</xsl:template> 

<!--
*******************************************************************************
* This template prints the Notes part of contact detail
* @param abperson The node in which to extract the notes node 
*******************************************************************************
-->
<xsl:template name="notes">
  <xsl:param name="abperson" />
  <tr> 
    <td colspan="5"> 
      <table width="100%" border="0" cellspacing="0" cellpadding="0">
        <tr> 
          <td width="1%"><img alt="" src="{$spacer.gif}" width="10" height="5"/></td>
          <td width="98%" class="SectionDivider"><img alt="" src="{$spacer.gif}" width="1" height="5"/></td>
          <td width="1%"><img alt="" src="{$spacer.gif}" width="10" height="5"/></td>
        </tr>
      </table>
    </td>
  </tr>
  <tr> 
    <td class="SectionHeader" colspan="5"><span class="SectionHeader"><xsl:text>_Notes</xsl:text></span></td>
  </tr>
  <tr> 
    <td class="PropLabelAb" colspan="5"> 
      <textarea name="{$fieldPrefix}description" cols="50" rows="5" tabindex="59">
      <xsl:if test="$abperson and $abperson/entry/description">
        <xsl:value-of select="$abperson/entry/description"/>
      </xsl:if> 
      </textarea>      
    </td>
  </tr>
  <tr>
    <td class="PropLabelAb" colspan="5"><img src="../absimx/LrlToTop_1.gif" width="11" height="10" alt="Jump Down to top"/>
    <a href="#top" class="JmpLnk" title="Jump Down to top" tabindex="60">
       <xsl:attribute name="title">
         <xsl:text>_Jump Down to top</xsl:text>
       </xsl:attribute>
       <xsl:text>_Jump Down to top</xsl:text>
    </a>
    </td>
  </tr>  

</xsl:template> 

<!--
*****************************************************************************
* This template formats and prints a phone element
*****************************************************************************
-->
<xsl:template name="phone">
  <xsl:param name="abperson"/>
  <xsl:param name="priority"/>
  <xsl:param name="width"/>
  <xsl:param name="tdClass" select="'PropLabelAb'"/>
  <xsl:param name="tabindex"/>	
  
  <td>
    <xsl:attribute name="class">
      <xsl:value-of select="$tdClass"/>
    </xsl:attribute>
    <xsl:attribute name="width">
      <xsl:value-of select="$width"/><xsl:text>%</xsl:text>
    </xsl:attribute>
    <span class="Lbl2"><label for="phone">
    <xsl:choose>
     <xsl:when test="$priority='1'">
      <xsl:text>_Primary Phone</xsl:text>
     </xsl:when>
     <xsl:otherwise>
       <xsl:text>_Phone</xsl:text>&nbsp;(<xsl:value-of select="$priority"/>)
     </xsl:otherwise>
    </xsl:choose>:</label></span><br/>
    <select id="phone" >
       <xsl:attribute name="tabindex">
          <xsl:value-of select="$tabindex"/> 
       </xsl:attribute>
       <xsl:attribute name="name">
          <xsl:value-of select="$fieldPrefix"/> 
          <xsl:text>piPhone</xsl:text>
          <xsl:value-of select="$priority"/> 
          <xsl:text>Type</xsl:text>
       </xsl:attribute>
       <option value="work">
        <xsl:choose>
            <xsl:when test="$abperson">
              <xsl:choose>
                <xsl:when test="$abperson/phone[@priority = $priority]">
                  <xsl:if test="$abperson/phone[@priority = $priority]/@type = 'work'">
                   <xsl:attribute name="selected"/>              
                  </xsl:if> 
                </xsl:when>
                <xsl:otherwise>
                  <xsl:if test="$priority = '1'">
                   <xsl:attribute name="selected"/>              
                  </xsl:if> 
                </xsl:otherwise>
              </xsl:choose> 
            </xsl:when>
            <xsl:otherwise>
              <xsl:if test="$priority = '1'">
               <xsl:attribute name="selected"/>              
              </xsl:if> 
            </xsl:otherwise>
          </xsl:choose> 
         <xsl:text>_Work</xsl:text>
       </option>
       <option value="home">
         <xsl:choose>
            <xsl:when test="$abperson">
              <xsl:choose>
                <xsl:when test="$abperson/phone[@priority = $priority]">
                  <xsl:if test="$abperson/phone[@priority = $priority]/@type = 'home'">
                   <xsl:attribute name="selected"/>              
                  </xsl:if> 
                </xsl:when>
                <xsl:otherwise>
                  <xsl:if test="$priority = '2'">
                   <xsl:attribute name="selected"/>              
                  </xsl:if> 
                </xsl:otherwise>
              </xsl:choose> 
            </xsl:when>
            <xsl:otherwise>
              <xsl:if test="$priority = '2'">
               <xsl:attribute name="selected"/>              
              </xsl:if> 
            </xsl:otherwise>
          </xsl:choose> 
          <xsl:text>_Home</xsl:text>
        </option>
        <option value="mobile">
          <xsl:choose>
            <xsl:when test="$abperson">
              <xsl:choose>
                <xsl:when test="$abperson/phone[@priority = $priority]">
                  <xsl:if test="$abperson/phone[@priority = $priority]/@type = 'mobile'">
                   <xsl:attribute name="selected"/>              
                  </xsl:if> 
                </xsl:when>
                <xsl:otherwise>
                  <xsl:if test="$priority = '3'">
                   <xsl:attribute name="selected"/>              
                  </xsl:if> 
                </xsl:otherwise>
              </xsl:choose> 
            </xsl:when>
            <xsl:otherwise>
              <xsl:if test="$priority = '3'">
               <xsl:attribute name="selected"/>              
              </xsl:if> 
            </xsl:otherwise>
          </xsl:choose> 
          <xsl:text>_Mobile</xsl:text>
        </option>
        <option value="pager">
          <xsl:choose>
            <xsl:when test="$abperson">
              <xsl:choose>
                <xsl:when test="$abperson/phone[@priority = $priority]">
                  <xsl:if test="$abperson/phone[@priority = $priority]/@type = 'pager'">
                   <xsl:attribute name="selected"/>              
                  </xsl:if> 
                </xsl:when>
                <xsl:otherwise>
                  <xsl:if test="$priority = '4'">
                   <xsl:attribute name="selected"/>              
                  </xsl:if> 
                </xsl:otherwise>
              </xsl:choose> 
            </xsl:when>
            <xsl:otherwise>
              <xsl:if test="$priority = '4'">
               <xsl:attribute name="selected"/>              
              </xsl:if> 
            </xsl:otherwise>
          </xsl:choose> 
          <xsl:text>_Pager</xsl:text>
        </option>
        <option value="fax">
          <xsl:choose>
            <xsl:when test="$abperson">
              <xsl:choose>
                <xsl:when test="$abperson/phone[@priority = $priority]">
                  <xsl:if test="$abperson/phone[@priority = $priority]/@type = 'fax'">
                   <xsl:attribute name="selected"/>              
                  </xsl:if> 
                </xsl:when>
                <xsl:otherwise>
                  <xsl:if test="$priority = '5'">
                   <xsl:attribute name="selected"/>              
                  </xsl:if> 
                </xsl:otherwise>
              </xsl:choose> 
            </xsl:when>
            <xsl:otherwise>
              <xsl:if test="$priority = '5'">
               <xsl:attribute name="selected"/>              
              </xsl:if> 
            </xsl:otherwise>
          </xsl:choose> 
          <xsl:text>_Fax</xsl:text>
        </option>
        <option value="other">
          <xsl:choose>
            <xsl:when test="$abperson">
              <xsl:choose>
                <xsl:when test="$abperson/phone[@priority = $priority]">
                  <xsl:if test="$abperson/phone[@priority = $priority]/@type = 'other'">
                   <xsl:attribute name="selected"/>              
                  </xsl:if> 
                </xsl:when>
                <xsl:otherwise>
                </xsl:otherwise>
              </xsl:choose> 
            </xsl:when>
            <xsl:otherwise>
            </xsl:otherwise>
          </xsl:choose> 
          <xsl:text>_Other</xsl:text>
        </option>
      </select>    

    <xsl:text>&nbsp;</xsl:text>
    <xsl:choose>
      <xsl:when test="$abperson">
        <input type="text" id="phone" name="{$fieldPrefix}piPhone{$priority}" size="25" value="{$abperson/phone[@priority = $priority]}" onChange="javascipt:this.value=this.value.trim()">
           <xsl:attribute name="tabindex">
             <xsl:number value="$tabindex + 1" /> 
           </xsl:attribute>
	</input>
      </xsl:when>
      <xsl:otherwise>
        <input type="text" id="phone" name="{$fieldPrefix}piPhone{$priority}" size="25" onChange="javascipt:this.value=this.value.trim()">
           <xsl:attribute name="tabindex">
             <xsl:value-of select="$tabindex + 1" /> 
           </xsl:attribute>
	</input>
      </xsl:otherwise>
    </xsl:choose> 
  </td>
</xsl:template> 

<!--
*****************************************************************************
* This template formats and prints an im element
* @param abperson The node in which to extract the im node 
* @param priority The priority of the im to be printed
*****************************************************************************
-->
<xsl:template name="im">
  <xsl:param name="abperson"/>
  <xsl:param name="priority"/>
  <xsl:param name="width"/>
  <xsl:param name="tabindex"/>  
  <td class="PropLabelAb">
    <xsl:attribute name="width">
      <xsl:value-of select="$width"/><xsl:text>%</xsl:text>
    </xsl:attribute>
    <span class="Lbl2"><label for="iim"><xsl:text>_Nickname</xsl:text>&nbsp;(<xsl:value-of select="$priority"/>):</label></span>
    <br/>
    <select id="iim" >
       <xsl:attribute name="tabindex">
	 <xsl:value-of select="$tabindex" /> 
       </xsl:attribute>
       <xsl:attribute name="name">
          <xsl:value-of select="$fieldPrefix" /> 
          <xsl:text>piIM</xsl:text>
          <xsl:value-of select="$priority"/> 
          <xsl:text>Service</xsl:text>
        </xsl:attribute>    
        <option value="SunONE">
          <xsl:choose>
            <xsl:when test="$abperson and $abperson/im[@priority=$priority]">
              <xsl:if test="$abperson/im[@priority=$priority]/@service = 'SunONE'">
               <xsl:attribute name="selected"/>
              </xsl:if> 
            </xsl:when>
            <xsl:otherwise>
              <xsl:if test="$priority= '1'">
               <xsl:attribute name="selected"/>
              </xsl:if> 
            </xsl:otherwise>
          </xsl:choose> 
          <xsl:text>_iPlanet</xsl:text>
        </option>     
        <option value="AIM">
          <xsl:choose>
            <xsl:when test="$abperson and $abperson/im[@priority=$priority]">
              <xsl:if test="$abperson/im[@priority=$priority]/@service = 'AIM'">
               <xsl:attribute name="selected"/>
              </xsl:if> 
            </xsl:when>
            <xsl:otherwise>
             <xsl:if test="$priority = '2'">
               <xsl:attribute name="selected"/>
              </xsl:if> 
            </xsl:otherwise>
          </xsl:choose> 
          <xsl:text>AIM</xsl:text>
        </option>
        <option value="Yahoo">
          <xsl:choose>
            <xsl:when test="$abperson and $abperson/im[@priority=$priority]">
              <xsl:if test="$abperson/im[@priority=$priority]/@service = 'Yahoo'">
               <xsl:attribute name="selected"/>
              </xsl:if> 
            </xsl:when>
            <xsl:otherwise>
              <xsl:if test="$priority = '3'">
               <xsl:attribute name="selected"/>
              </xsl:if> 
            </xsl:otherwise>
          </xsl:choose> 
          <xsl:text>Yahoo</xsl:text>
        </option>
        <option value="ICQ">
          <xsl:choose>
            <xsl:when test="$abperson">
              <xsl:if test="$abperson/im[@priority=$priority]/@service = 'ICQ'">
               <xsl:attribute name="selected"/>
              </xsl:if> 
            </xsl:when>
          </xsl:choose> 
          <xsl:text>ICQ</xsl:text>
        </option>
        <option value="MSN">
          <xsl:choose>
            <xsl:when test="$abperson">
              <xsl:if test="$abperson/im[@priority=$priority]/@service = 'MSN'">
               <xsl:attribute name="selected"/>
              </xsl:if> 
            </xsl:when>
            <xsl:otherwise>
            </xsl:otherwise>
          </xsl:choose> 
          <xsl:text>MSN</xsl:text>
        </option>
      </select>
    <xsl:text>&nbsp;</xsl:text>
    <xsl:choose>
      <xsl:when test="$abperson">
        <input type="text" id="iim" name="{$fieldPrefix}piIM{$priority}ID" size="25" value="{$abperson/im[@priority = $priority]}" onChange="javascipt:this.value=this.value.trim()">
       	  <xsl:attribute name="tabindex">
	    <xsl:number value="$tabindex + 1" />
          </xsl:attribute>
	</input>
      </xsl:when>
      <xsl:otherwise>
        <input type="text" id="iim" name="{$fieldPrefix}piIM{$priority}ID" size="25" onChange="javascipt:this.value=this.value.trim()">
       	  <xsl:attribute name="tabindex">
	    <xsl:number value="$tabindex + 1" /> 
          </xsl:attribute>
	</input>
      </xsl:otherwise>
    </xsl:choose> 
  </td>
</xsl:template> 


<!--
*******************************************************************************
* This template formats and prints an email element
* @param abperson The node in which to extract the email node 
* @param priority The priority of the email to be printed
*******************************************************************************
-->
<xsl:template name="email">
  <xsl:param name="abperson"/>
  <xsl:param name="priority"/>
  <xsl:param name="width"/>
  <xsl:param name="tabindex"/>
  <xsl:param name="tdClass" select="'PropLabelAb'"/>
  
  <td>
    <xsl:attribute name="class">
      <xsl:value-of select="$tdClass"/>
    </xsl:attribute>
    <xsl:attribute name="width">
      <xsl:value-of select="$width"/><xsl:text>%</xsl:text>
    </xsl:attribute>
    <span class="Lbl2"><label for="email1">
    <xsl:choose>
    <xsl:when test="$priority='1'">
      <xsl:text>_Primary Email</xsl:text>
    </xsl:when>
    <xsl:otherwise>
      <xsl:text>_Email</xsl:text>&nbsp;(<xsl:value-of select="$priority"/>)
    </xsl:otherwise>
    </xsl:choose>:
    </label></span>
    <br/>
    <select id="email1" >
       <xsl:attribute name="tabindex">
          <xsl:value-of select="$tabindex"/> 
       </xsl:attribute>
       <xsl:attribute name="name">
          <xsl:value-of select="$fieldPrefix"/> 
          <xsl:text>piEmail</xsl:text>
          <xsl:value-of select="$priority"/> 
          <xsl:text>Type</xsl:text>
       </xsl:attribute>
        <option value="work">
          <xsl:choose>
            <xsl:when test="$abperson">
              <xsl:choose>
                <xsl:when test="$abperson/email[@priority = $priority]">
                  <xsl:if test="$abperson/email[@priority = $priority]/@type = 'work'">
                   <xsl:attribute name="selected"/>              
                  </xsl:if> 
                </xsl:when>
                <xsl:otherwise>
                  <xsl:if test="$priority = '1'">
                   <xsl:attribute name="selected"/>
                  </xsl:if> 
                </xsl:otherwise>
              </xsl:choose> 
            </xsl:when>
            <xsl:otherwise>
              <xsl:if test="$priority = '1'">
               <xsl:attribute name="selected"/>
              </xsl:if> 
            </xsl:otherwise>
          </xsl:choose> 
          <xsl:text>_Work</xsl:text>
        </option>
        <option value="home">
          <xsl:choose>
            <xsl:when test="$abperson">
              <xsl:choose>
                <xsl:when test="$abperson/email[@priority = $priority]">
                  <xsl:if test="$abperson/email[@priority = $priority]/@type = 'home'">
                   <xsl:attribute name="selected"/>              
                  </xsl:if> 
                </xsl:when>
                <xsl:otherwise>
                  <xsl:if test="$priority = '2'">
                   <xsl:attribute name="selected"/>              
                  </xsl:if> 
                </xsl:otherwise>
              </xsl:choose> 
            </xsl:when>
            <xsl:otherwise>
              <xsl:if test="$priority = '2'">
               <xsl:attribute name="selected"/>              
              </xsl:if> 
            </xsl:otherwise>
          </xsl:choose> 
          <xsl:text>_Home</xsl:text>
        </option>             
         <option value="sms">
          <xsl:choose>
            <xsl:when test="$abperson">
              <xsl:choose>
                <xsl:when test="$abperson/email[@priority = $priority]">
                  <xsl:if test="$abperson/email[@priority = $priority]/@type = 'sms'">
                   <xsl:attribute name="selected"/>              
                  </xsl:if> 
                </xsl:when>
                <xsl:otherwise>
                </xsl:otherwise>
              </xsl:choose> 
            </xsl:when>
            <xsl:otherwise>
            </xsl:otherwise>
          </xsl:choose> 
          <xsl:text>_SMS</xsl:text>
         </option>
         <option value="pager">
          <xsl:choose>
            <xsl:when test="$abperson">
              <xsl:choose>
                <xsl:when test="$abperson/email[@priority = $priority]">
                  <xsl:if test="$abperson/email[@priority = $priority]/@type = 'pager'">
                   <xsl:attribute name="selected"/>              
                  </xsl:if> 
                </xsl:when>
                <xsl:otherwise>
                 <xsl:if test="$priority = '3'">
                   <xsl:attribute name="selected"/>
                  </xsl:if> 
                </xsl:otherwise>
              </xsl:choose> 
            </xsl:when>
            <xsl:otherwise>
             <xsl:if test="$priority = '3'">
               <xsl:attribute name="selected"/>
             </xsl:if> 
            </xsl:otherwise>
          </xsl:choose> 
          <xsl:text>_Pager</xsl:text>
         </option>
         <option value="other">
          <xsl:choose>
            <xsl:when test="$abperson">
              <xsl:choose>
                <xsl:when test="$abperson/email[@priority = $priority]">
                  <xsl:if test="$abperson/email[@priority = $priority]/@type = 'other'">
                   <xsl:attribute name="selected"/>              
                  </xsl:if> 
                </xsl:when>
                <xsl:otherwise>                
                </xsl:otherwise>
              </xsl:choose> 
            </xsl:when>
            <xsl:otherwise>             
            </xsl:otherwise>
          </xsl:choose> 
          <xsl:text>_Other</xsl:text>
         </option>
      </select>
     <xsl:text>&nbsp;</xsl:text>
     <input type="text" id="email1" name="{$fieldPrefix}piEmail{$priority}" size="25" onChange="javascipt:this.value=this.value.trim()">
       <xsl:attribute name="tabindex">
          <xsl:number value="$tabindex + 1"/> 
       </xsl:attribute>
       <xsl:if test="$abperson">
        <xsl:attribute name="value">
          <xsl:value-of select="$abperson/email[@priority = $priority]"/>
        </xsl:attribute> 
      </xsl:if> 
    </input>
  </td>
</xsl:template> 


<!--
*****************************************************************************
* This template formats and prints a weburl element
* @param abperson The abperson node from which to extract the weburl
* @param priority The priority of the url to display
*****************************************************************************
-->
<xsl:template name="weburl" >
  <xsl:param name="abperson"/>
  <xsl:param name="priority"/>
  <xsl:param name="width"/>
  <xsl:param name="tabindex"/>
  
  <td class="PropLabelAb">
    <xsl:attribute name="width">
      <xsl:value-of select="$width"/><xsl:text>%</xsl:text>
    </xsl:attribute>
    <span class="Lbl2"><xsl:text>_Web Address </xsl:text>
          (<xsl:value-of select="$priority"/>):        
    </span>
    <br/>
    <input type="text" name="{$fieldPrefix}piWebSite{$priority}" size="30" maxlength="128" onChange="javascipt:this.value=this.value.trim()">
      <xsl:attribute name="tabindex">
      	<xsl:value-of select="$tabindex"/> 
      </xsl:attribute>
      <xsl:if test="$abperson">
        <xsl:attribute name="value">
          <xsl:value-of select="$abperson/weburl[@priority = $priority]/urladdr"/>
        </xsl:attribute> 
      </xsl:if> 
    </input>
  </td>

</xsl:template> 


<!--
*******************************************************************************
* This template formats and prints a calendar element
* @param abperson The abperson node from which to extract the calendar
* @param type Keyword determining the type of the url : Calendar or FreeBusy
*******************************************************************************
-->
<xsl:template name="calendar">
  <xsl:param name="abperson"/>
  <xsl:param name="type"/>
  <xsl:param name="width"/>
  <xsl:param name="tabindex"/>
  
  <td class="PropLabelAb">
    <xsl:attribute name="width">
      <xsl:value-of select="$width"/><xsl:text>%</xsl:text>
    </xsl:attribute>
    <span class="Lbl2">
        <xsl:choose>
        <xsl:when test="$type = 'calendar'">
          <xsl:text>_Calendar Address</xsl:text>:
        </xsl:when>
        <xsl:when test="$type = 'freebusy'">
          <xsl:text>_Availability Address</xsl:text>:
        </xsl:when>        
      </xsl:choose> 
    </span>
    <br/>
    <xsl:variable name="fieldName">
      <xsl:choose>
        <xsl:when test="$type = 'calendar'">
          <xsl:text>inetCalendar</xsl:text>
        </xsl:when>
        <xsl:when test="$type = 'freebusy'">
          <xsl:text>inetFreeBusy</xsl:text>
        </xsl:when>        
      </xsl:choose> 
    </xsl:variable> 
    <input type="text" name="{$fieldPrefix}{$fieldName}" size="30" maxlength="128" onChange="javascipt:this.value=this.value.trim()">
     <xsl:attribute name="tabindex">
       <xsl:value-of select="$tabindex"/>
     </xsl:attribute>
     <xsl:if test="$abperson">
        <xsl:attribute name="value">
          <xsl:value-of select="$abperson/calendar[@type = $type]/urladdr"/>
        </xsl:attribute> 
     </xsl:if> 
    </input>
  </td>
</xsl:template>

<!--
*******************************************************************************
* This template formats and prints inputs for a date element
* @param abperson The abperson node from which to extract the calendar
* @param type The type of the date to display this determine the label to output
* @param dateFormat The format to use when outputing the date
* @param index The index (position) of the date to display, kind of ID
* @param fieldName The name of the field which is going to be created
* @param label The label of the field to be printed
*******************************************************************************
-->
<xsl:template name="date">
  <xsl:param name="abperson"/>
  <xsl:param name="type"/>
  <xsl:param name="dateFormat"/>
  <xsl:param name="index"/>
  <xsl:param name="fieldName"/>
  <xsl:param name="label"/>
  <xsl:param name="width"/>
  <xsl:param name="tabindex"/>
<td class="PropLabelAb"> 
  <xsl:attribute name="width"><xsl:value-of select="$width"/><xsl:text>%</xsl:text></xsl:attribute>
  <span class="Lbl2">
    <label>
      <xsl:attribute name="for">
	<xsl:value-of select="$label"/>
      </xsl:attribute>  		
      <xsl:value-of select="$label"/>  
    </label>    
  </span>
  <br/>
    <!-- Month or Day based on global option dateformat -->
    <xsl:choose>
        <xsl:when test="$dateFormat = 'M/D/Y'">
          <xsl:call-template name="month-select">
            <xsl:with-param name="index" select="$index"/>
            <xsl:with-param name="fieldName" select="$fieldName"/>
	    <xsl:with-param name="tabindex">
		 <xsl:number value="$tabindex"/>	
	    </xsl:with-param>
            <xsl:with-param name="label">	
		 <xsl:value-of select="$label"/>	
	    </xsl:with-param>
          </xsl:call-template>
        </xsl:when>
        <xsl:when test="$dateFormat = 'D/M/Y'">
          <xsl:call-template name="day-select">
            <xsl:with-param name="index" select="$index"/>
            <xsl:with-param name="fieldName" select="$fieldName"/>
	    <xsl:with-param name="tabindex">
		 <xsl:number value="$tabindex"/>	
	    </xsl:with-param>
            <xsl:with-param name="label">	
		 <xsl:value-of select="$label"/>	
	    </xsl:with-param>
          </xsl:call-template>
        </xsl:when>
        <xsl:when test="$dateFormat = 'Y/M/D'">
          <xsl:call-template name="year-input">
            <xsl:with-param name="index" select="$index"/>
            <xsl:with-param name="fieldName" select="$fieldName"/>
	    <xsl:with-param name="tabindex">
		 <xsl:number value="$tabindex"/>	
	    </xsl:with-param>
            <xsl:with-param name="label">	
		 <xsl:value-of select="$label"/>	
	    </xsl:with-param>
          </xsl:call-template>
        </xsl:when>
        <xsl:otherwise> <!--Default is Day / Month / Year-->
          <xsl:call-template name="day-select">
            <xsl:with-param name="index" select="$index"/>
            <xsl:with-param name="fieldName" select="$fieldName"/>
	    <xsl:with-param name="tabindex">
		 <xsl:number value="$tabindex"/>	
	    </xsl:with-param>
            <xsl:with-param name="label">	
		 <xsl:value-of select="$label"/>	
	    </xsl:with-param>
          </xsl:call-template>
        </xsl:otherwise>
     </xsl:choose> 
     
     <xsl:choose>
        <xsl:when test="$dateFormat = 'M/D/Y'">
           <xsl:call-template name="day-select">
             <xsl:with-param name="index" select="$index"/>
              <xsl:with-param name="fieldName" select="$fieldName"/>
	      <xsl:with-param name="tabindex">
		<xsl:number value="$tabindex + 1"/>	
	      </xsl:with-param>
            <xsl:with-param name="label">	
		 <xsl:value-of select="$label"/>	
	    </xsl:with-param>
           </xsl:call-template>
        </xsl:when>
        <xsl:otherwise> <!--Default is Day / Month / Year-->
           <xsl:call-template name="month-select">
             <xsl:with-param name="index" select="$index"/>
              <xsl:with-param name="fieldName" select="$fieldName"/>
	      <xsl:with-param name="tabindex">
		<xsl:number value="$tabindex + 1"/>	
	      </xsl:with-param>
            <xsl:with-param name="label">	
		 <xsl:value-of select="$label"/>	
	    </xsl:with-param>
           </xsl:call-template>
          </xsl:otherwise>
     </xsl:choose> 
     
     <xsl:choose>
        <xsl:when test="$dateFormat = 'Y/M/D'">
           <xsl:call-template name="day-select">
             <xsl:with-param name="index" select="$index"/>
             <xsl:with-param name="fieldName" select="$fieldName"/>
	      <xsl:with-param name="tabindex">
		<xsl:number value="$tabindex + 2"/>	
	      </xsl:with-param>
            <xsl:with-param name="label">	
		 <xsl:value-of select="$label"/>	
	    </xsl:with-param>
           </xsl:call-template>
        </xsl:when>
        <xsl:otherwise> <!--Default is Day / Month / Year-->
           <xsl:call-template name="year-input">
             <xsl:with-param name="index" select="$index"/>
             <xsl:with-param name="fieldName" select="$fieldName"/>
	      <xsl:with-param name="tabindex">
		<xsl:number value="$tabindex + 2"/>	
	      </xsl:with-param>
            <xsl:with-param name="label">	
		 <xsl:value-of select="$label"/>	
	    </xsl:with-param>
           </xsl:call-template>
        </xsl:otherwise>
     </xsl:choose> 
   <xsl:choose>
    <xsl:when test="$abperson and $abperson/person">
      <input type="hidden" name="{$fieldName}" value="{$abperson/person/date[@type = $type]}"/>
    </xsl:when>
    <xsl:otherwise>
      <input type="hidden" name="{$fieldName}" value=""/>
    </xsl:otherwise>
  </xsl:choose> 
</td>      

<script language="javascript">
<xsl:choose>
  <xsl:when test="$abperson and $abperson/person">
    buildDateSelect(<xsl:value-of select="$index"/>, '<xsl:value-of select="$abperson/person/date[@type = $type]"/>');
  </xsl:when> 
  <xsl:otherwise>
    buildDateSelect(<xsl:value-of select="$index"/>, '');
  </xsl:otherwise>
</xsl:choose>
</script>  
</xsl:template>

<!--
*******************************************************************************
* Prints the day HTML select field
* @param fieldName The name to give to the output HTML field
* @param index A unique ID representing the index of the date the select is going to act for.
*******************************************************************************
-->
<xsl:template name="day-select">
  <xsl:param name="fieldName" />
  <xsl:param name="index" />
  <xsl:param name="tabindex" />
  <xsl:param name="label" />
  <select onChange="onDateChange(this, '{$fieldName}')">
    <xsl:attribute name="tabindex">
      <xsl:value-of select="$tabindex"/>
    </xsl:attribute>
    <xsl:attribute name="id">
      <xsl:value-of select="$label"/>
    </xsl:attribute>
    <xsl:attribute name="name">
      <xsl:text>day_</xsl:text>
      <xsl:value-of select="$index"/>
    </xsl:attribute>
    <option>10</option>
    <option>11</option>
    <option>20</option>
    <option>31</option>
  </select>
</xsl:template> 

<!--
*******************************************************************************
* Prints the month HTML select field
* @param fieldName The name to give to the output HTML field
* @param index A unique ID representing the index of the date the select is going to act for.
*******************************************************************************
-->
<xsl:template name="month-select">
  <xsl:param name="fieldName" />
  <xsl:param name="index" /> 
  <xsl:param name="tabindex" />
  <xsl:param name="label" />
    <select onChange="onDateChange(this, '{$fieldName}')">
      <xsl:attribute name="tabindex">
        <xsl:value-of select="$tabindex"/>
      </xsl:attribute>
      <xsl:attribute name="id">
        <xsl:value-of select="$label"/>
      </xsl:attribute>
      <xsl:attribute name="name">
        <xsl:text>month_</xsl:text>
        <xsl:value-of select="$index"/>
      </xsl:attribute>   
      <option value="1">
        <xsl:text>_January</xsl:text>
      </option>
      <option value="2">
        <xsl:text>_February</xsl:text>
      </option>
      <option value="9">
        <xsl:text>_September</xsl:text>
      </option>
      <option value="12">
        <xsl:text>_December</xsl:text>
      </option>
    </select>  
  
</xsl:template>

<!--
*******************************************************************************
* Prints the year HTML text field
* @param fieldName The name to give to the output HTML field
* @param index A unique ID representing the index of the date the select is going to act for.
*******************************************************************************
-->
<xsl:template name="year-input">
  <xsl:param name="fieldName" />
  <xsl:param name="index" />
  <xsl:param name="tabindex"/>
  <xsl:param name="label" />
  <input type="text" name="year_{$index}" maxlength="4" size="4" onChange="onDateChange(this, '{$fieldName}')" tabindex="$tabindex">
    <xsl:attribute name="tabindex">
      <xsl:value-of select="$tabindex"/>
    </xsl:attribute>
    <xsl:attribute name="id">
      <xsl:value-of select="$label"/>
    </xsl:attribute>
  </input>
</xsl:template> 

<!--
*******************************************************************************
* This prints the error messages on the edit/add contact page
* @param err The error element from which to extract the error code
*******************************************************************************
-->
  <xsl:template name="error-message">
    <xsl:param name="err" select="." />
    
    <xsl:choose>
      <xsl:when test="$err/@errnum = '3'">        
        <script> 
         var eDisplayname = "<xsl:call-template name="escape"><xsl:with-param name="text" select="$err/@displayname"/></xsl:call-template>";
         var bDisplayname = "<xsl:call-template name="escape"><xsl:with-param name="text" select="/xslui/iab/booklist/book/entry[@entryID = $err/@bookid]/displayname"/></xsl:call-template>";
         printLocalizedLabel("<xsl:text>_Card Added Success Message</xsl:text>", new Array(eDisplayname, bDisplayname));</script>      
      </xsl:when>
      <xsl:when test="$err/@errnum = '129'">
        <ul>
          <xsl:for-each select="$err/field">
            <li class="normal">
            <xsl:call-template name="elementName-to-fieldName">
              <xsl:with-param name="eltName" select="./@elementname"/>
            </xsl:call-template>
            </li>
          </xsl:for-each> 
        </ul>
      </xsl:when>
      <xsl:when test="$err/@errnum = '261' or $err/@errnum = '287'">
        <script>
         var eDisplayname = "<xsl:call-template name="escape"><xsl:with-param name="text" select="$err/@displayname"/></xsl:call-template>";
        printLocalizedLabel("<xsl:text>_Contact Addition Failure Message</xsl:text>", new Array(eDisplayname));</script>                       
      </xsl:when>
      <xsl:otherwise>
        <xsl:text>_Unknown error (</xsl:text>
        <xsl:value-of select="$err/@errnum" /> 
        <xsl:text>)</xsl:text>
      </xsl:otherwise>
    </xsl:choose>
<!--
    <xsl:if test="$err/@rawmsg">
      <br/>
      <xsl:value-of select="$err/@rawmsg" />&nbsp;
    </xsl:if> 
-->
  </xsl:template>



<!--
*******************************************************************************
* Translate an element name into a field name understable by user
* @param eltName The name of the element to translate
*******************************************************************************
-->
  <xsl:template name="elementName-to-fieldName">
    <xsl:param name="eltName"/>
    <xsl:if test="string-length($eltName) > 0">
      <xsl:choose>
        <xsl:when test="$eltName = 'displayname'">
          <xsl:text>_Display Name</xsl:text>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="$eltName" /> 
        </xsl:otherwise>
      </xsl:choose> 
    </xsl:if> 
  </xsl:template>   

</xsl:stylesheet>

