<?xml version="1.0"?>
<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>

<xsl:stylesheet version='1.0' xmlns:xsl='http://www.w3.org/1999/XSL/Transform'>

<xsl:output method="html" version="4" encoding="UTF-8"/>

<xsl:include href="banner.xsl"/>
<xsl:include href="commonimages.xsl"/>
<xsl:include href="viewcontact-images.xsl"/>
<xsl:include href="common-uielements.xsl"/>
<xsl:include href="commonjavascript.xsl"/>
<xsl:include href="commonattributes-hidden.xsl"/>
<xsl:include href="common-editcontact.xsl"/>
<xsl:include href="errors.xsl"/>
<xsl:include href="css-select.xsl"/>

<!--
*******************************************************************************
* Core of the template stylesheet addcontact.xsl
*******************************************************************************
-->
<xsl:template match="/">
<xsl:variable name="curBookID">
  <xsl:choose>
    <xsl:when test="/xslui/iab/bookentry/abperson">
      <xsl:choose>
        <xsl:when test="/xslui/iab/entrycontext/book">
          <xsl:value-of select="/xslui/iab/entrycontext/book/entry/@entryID" /> 
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="/xslui/iab/booklist/book[string-length(@bookurl)>0][1]/entry/@entryID" /> 
        </xsl:otherwise>
      </xsl:choose> 
    </xsl:when>
    <xsl:otherwise>
      <xsl:value-of select="/xslui/iab/pagedsearch/searchresult/@bookid" /> 
    </xsl:otherwise>
  </xsl:choose> 
</xsl:variable> 
  
<html>
<head>
  <title>    
    <xsl:text>_Add Contact</xsl:text>
  </title>
  <script language="javascript" src="../absjs/common.js"/><noscript></noscript>
  <script language="javascript" src="../absjs/integration.js"/>  <noscript></noscript>     
            
  <script src="../absjs/scripts.js"></script><noscript></noscript>
  <script src="../absjs/browserVersion.js"></script><noscript></noscript>
  <script>         
      if (is_ie5up) // IE5
      {    
       document.write('&lt;link type="text/css" rel="stylesheet" href="../absimx/ab_css_ie5win.css"&gt;');
      }
      else if (is_gecko) // Netscape 6/7 or Mozilla
      {
        document.write('&lt;link type="text/css" rel="stylesheet" href="../absimx/ab_css_ns6up.css"&gt;');
      }
      else  // All others
      {
       document.write('&lt;link type="text/css" rel="stylesheet" href="../absimx/ab_css_ns6up.css"&gt;');
      }
  </script><noscript></noscript>
  
  <script language="javascript" src="../absjs/contact.js"/><noscript></noscript>
  <script language="javascript" src="../absjs/dates.js"/><noscript></noscript>
  <script language="javascript">
    <xsl:call-template name="autoFillDisplayName"/>
    <xsl:call-template name="commonjavascript"/>
    <xsl:call-template name="i18n-dates"/>
    openerWin = parent.opener; 
    var inputObj = null;        
    if (openerWin) {          
        inputObj = openerWin.GetSharedObject();                
    }
    
    function save() {                    
      if((document.iabform["<xsl:value-of select="$fieldPrefix"/>displayName"].value).trim()=="")
      {
       alert("<xsl:text>_Display name cannot be blank or only whitespaces</xsl:text>");
       return false;
      }      
      
      <!-- Compulsary for the add to personnal address book feature -->
      document.iabform.bookid.value = (document.iabform.localBooks != null)?getSelectValue(document.iabform.localBooks)
                                                                           :'<xsl:value-of select='$curBookID'/>';       
      addContact();
      parent.close();
    }

    function cancel() {            
      parent.opener.focus();
      parent.close();
    }
  
    function help() {
          var helpurl = '<xsl:value-of select="/xslui/@contexturi"/>/help/<xsl:text>_languagepath</xsl:text>/addressbk/mcontact.html#wp14944';
          openhelp(helpurl);
    }
  
    function initPage() {      
      if( inputObj != null ) {
        var field = inputObj.givenname;
        document.iabform.<xsl:value-of select="$fieldPrefix"/>givenName.value = field==null?"":field;
        field = inputObj.sn;
        document.iabform.<xsl:value-of select="$fieldPrefix"/>sn.value = field==null?"":field;
        field = inputObj.cn;
        document.iabform.<xsl:value-of select="$fieldPrefix"/>displayName.value = field==null?"":field;
        field = inputObj.mail;
        document.iabform.<xsl:value-of select="$fieldPrefix"/>piEmail1.value = field==null?"":field;
        document.iabform.<xsl:value-of select="$fieldPrefix"/>givenName.focus();
      } else {
        alert("inputObj is null");
      }
    }
  </script><noscript></noscript>
</head>
<body leftmargin="0" topmargin="0" rightmargin="0" marginwidth="0" marginheight="0">
<xsl:attribute name="onload">
  javascript:initPage();
</xsl:attribute> 

<form method="post" name="iabform" action="search.xml">
  <input type="hidden" name="j_encoding" value="{/xslui/@charset}"/>
  <input type="hidden" name="uiaction" value=""/>
  <input type="hidden" name="entryid" value=""/>
  <input type="hidden" name="prefix" value="{$fieldPrefix}"/>
  <input type="hidden" name="{$fieldPrefix}entrytype" value="abperson"/>
  <xsl:call-template name="contextKeeper">
    <xsl:with-param name="pagedSearch" select="/xslui/iab/pagedsearch"/>
  </xsl:call-template>     
 <xsl:apply-templates select="/xslui/errormessages/error" mode="new-contact"/>
 <a name="top"></a> 
 <table width="100%" border="0" cellspacing="0" cellpadding="0">
   <xsl:attribute name="summary">
     <xsl:text>_This table displays a form for quick add</xsl:text>
   </xsl:attribute>
  <!-- Heading -->
  <tr> 
    <td class="PopupTitle" width="100%" colspan="5"><span class="PopupTitleText"><xsl:text>_Add Contact</xsl:text></span></td>
  </tr>
  <tr> 
    <td align="right" colspan="5"><img alt="required field" src="../absimx/required.gif" width="7" height="14"/> 
      <xsl:text>_indicates a required field</xsl:text><img alt="" src="{$spacer.gif}" width="10" height="15"/></td>
  </tr>                    
  </table>
  <!-- Contents -->
  <xsl:call-template name="edit-abperson">
   <xsl:with-param name="abperson" select="/xslui/iab/bookentry/abperson"/>
   <xsl:with-param name="curBookID" select="$curBookID"/>
  </xsl:call-template>         
 
  <!-- These calls keeps the already selected context -->
  <xsl:for-each select="/xslui/iab/alreadyselected/*">
    <input type="hidden" name="selectedentry" value="{entry/@entryID}"/>
  </xsl:for-each>
  <xsl:apply-templates select="/xslui/iab/alreadyselected" mode="hidden"/>
</form>
</body>
</html>
</xsl:template>

<!--
*******************************************************************************
* Match the node abperson and print the HTML Form
*******************************************************************************
-->
<xsl:template name="edit-abperson">
<xsl:param name="abperson" select="''" />
<xsl:param name="curBookID" select="''" />

<table width="100&#37;" cellspacing="0" cellpadding="0" border="0" summary="This table displays a form for quick add">
  <tbody>    
  <tr> 
  <td class="PropLabel">
    <span class="Lbl2"><label for="firstName"><xsl:text>_First Name</xsl:text></label></span><br/>         
    <input id="firstName" type="text" name="{$fieldPrefix}givenName" size="25" tabindex="1">
     <xsl:attribute name="onChange">
      <xsl:text>javascript:this.value = this.value.trim();autoFillDisplayName(this);</xsl:text>
     </xsl:attribute> 
    </input>      
  </td>
  </tr>    
  <tr>
  <td class="PropLabel">
    <span class="Lbl2"><label for="lastName"><xsl:text>_Last Name</xsl:text></label></span><br/>         
    <input id="lastName" type="text" name="{$fieldPrefix}sn" size="25" tabindex="2">
      <xsl:attribute name="onChange">
        <xsl:text>javascript:this.value = this.value.trim();autoFillDisplayName(this);</xsl:text>
      </xsl:attribute> 
    </input>      
  </td>    
  </tr>
  <tr> 
  <td class="PropLabel">
    <span class="Lbl2"><label for="displayName"><img alt="required field" src="../absimx/required.gif" width="7" height="14"/><xsl:text>_Display Name</xsl:text></label></span><br/>        
    <input id="displayName" type="text" name="{$fieldPrefix}displayName" size="25" tabindex="3"/>      
  </td>    
  </tr>         
  <tr> 
   <xsl:call-template name="email">      
    <xsl:with-param name="priority" select="'1'"/>
    <xsl:with-param name="tdClass" select="'PropLabel'"/>
    <xsl:with-param name="tabindex" select="'4'"/>
   </xsl:call-template>
  </tr>
  <tr> 
   <xsl:call-template name="phone">      
    <xsl:with-param name="priority" select="'1'"/>
    <xsl:with-param name="tdClass" select="'PropLabel'"/>
    <xsl:with-param name="tabindex" select="'5'"/>
   </xsl:call-template>
  </tr>
  </tbody>
</table>
<xsl:if test="$curBookID and string-length($curBookID)&#62;0">
 <script language="javascript">
   autoFillDisplayName();
 </script><noscript></noscript>
</xsl:if>       
</xsl:template> 

<xsl:template match="error" mode="new-contact">
  <xsl:choose>
    <xsl:when test="./@errtype = 0">
      <xsl:apply-templates select="." mode="plain"/>
    </xsl:when>
    <xsl:otherwise>
      <xsl:apply-templates select="." mode="plain"/>
    </xsl:otherwise>
  </xsl:choose> 
</xsl:template> 
</xsl:stylesheet>
