<?xml version="1.0"?>
<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>

<xsl:stylesheet version='1.0' xmlns:xsl='http://www.w3.org/1999/XSL/Transform'>

  <xsl:output method="html" version="4" encoding="UTF-8"/>

  <xsl:include href="banner.xsl"/>
  <xsl:include href="common-uielements.xsl"/>
  <xsl:include href="common-editab.xsl"/>
  <xsl:include href="common-tabs.xsl"/>
  <xsl:include href="commonattributes-list.xsl"/>
  <xsl:include href="commonimages.xsl"/>
  <xsl:include href="commonjavascript.xsl"/>
  <xsl:include href="context.xsl"/>
  <xsl:include href="errors.xsl"/>
  <xsl:include href="css-select.xsl"/>


  <!--
  *******************************************************************************
  * Core of the template stylesheet search.xsl
  *******************************************************************************
  -->
  <xsl:template match="/">
    <html>
      <head>
        <title>
          <xsl:text>_iPlanet Address Book - Address books</xsl:text>
        </title>
        <link type="text/css" rel="stylesheet" href="{$commonCSS.css}"/> 

        <xsl:call-template name="styleSheetSelector">
          <xsl:with-param name="htmlprefs" select="/xslui/profileinfo/xmlprofile/htmlprefs"/>     
        </xsl:call-template>
        <xsl:call-template name="fontMaker">
          <xsl:with-param name="htmlprefs" select="/xslui/profileinfo/xmlprofile/htmlprefs"/>     
        </xsl:call-template>

        <script language="javascript" src="../absjs/common.js"/>
        <script language="Javascript">
          <xsl:call-template name="commonjavascript"/>
          <xsl:call-template name="bannerScripts"/>
          function cancel() {
            goToUsingForm("search.xml");
          }
          function save() {
          if((document.iabform["<xsl:value-of select="$fieldPrefix"/>displayName"].value).trim()=="")
          {
           alert("<xsl:text>_Display name cannot be blank or only whitespaces</xsl:text>");
           return;
          }
            document.iabform.stopsearch.value=1;
            submitForm('addbook');
          }
        </script>
      </head>

      <body leftmargin="0" topmargin="0" rightmargin="0" marginwidth="0" marginheight="0">
        <xsl:attribute name="onload">
          document.iabform.<xsl:value-of select="$fieldPrefix"/>displayName.focus();
        </xsl:attribute> 

      <form method="post" name="iabform" action="search.xml" onsubmit="return(false)">
        <input type="hidden" name="j_encoding" value="{/xslui/@charset}"/>
        <input type="hidden" name="uiaction" value=""/>
        <input type="hidden" name="entryid" value=""/>
        <input type="hidden" name="prefix" value="{$fieldPrefix}"/>
        <input type="hidden" name="{$fieldPrefix}entrytype" value="abook"/>

        <xsl:call-template name="contextKeeper">
          <xsl:with-param name="pagedSearch" select="/xslui/iab/pagedsearch"/>
        </xsl:call-template>

        <xsl:call-template name="banner"/>

        <xsl:call-template name="contextBanner">
          <xsl:with-param name="text">
            <xsl:text>_New Address Book</xsl:text>
          </xsl:with-param>
        </xsl:call-template>

        <xsl:apply-templates select="/xslui/errormessages/error" mode="plain"/>

        <xsl:call-template name="save-cancel-help-bar">
          <xsl:with-param name="helpurl">../help/<xsl:text>_languagepath</xsl:text>/help3.htm</xsl:with-param>
        </xsl:call-template>

        <xsl:variable name="bookfromcontext" select="/xslui/iab/entrycontext/book"/>
        <table width="100&#37;" border="0" cellspacing="0" cellpadding="0" class="second-strip">
          <tr> 
            <td colspan="5" class="first-strip">
              <img src="{$spacer.gif}" width="1" height="4"/>
            </td>
          </tr>
          <tr> 
            <td colspan="5">
              <img src="{$spacer.gif}" width="1" height="6"/>
            </td>
          </tr>
          <xsl:choose>
            <xsl:when test="boolean($bookfromcontext)">
              <xsl:call-template name="abDetails">
                <xsl:with-param name="ab" select="$bookfromcontext"/>
              </xsl:call-template>
              <xsl:call-template name="abLayout">
                <xsl:with-param name="book" select="$bookfromcontext"/>
              </xsl:call-template>
              <xsl:call-template name="sharingPermissions">
                <xsl:with-param name="book" select="$bookfromcontext"/>
              </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
              <xsl:call-template name="abDetails"/>
              <xsl:call-template name="abLayout"/>
              <xsl:call-template name="sharingPermissions"/>
            </xsl:otherwise>
          </xsl:choose>
          <tr> 
            <td colspan="5" class="first-strip">
              <img src="{$spacer.gif}" width="1" height="2"/>
            </td>
          </tr>
        </table>
        <xsl:call-template name="requiredInfo"/>
        <xsl:call-template name="save-cancel-help-bar">
          <xsl:with-param name="helpurl">../help/<xsl:text>_languagepath</xsl:text>/help3.htm</xsl:with-param>
        </xsl:call-template>
      </form>
      </body>
    </html>
  </xsl:template>
</xsl:stylesheet>
