//Contains the frequently used static javascript functions

//Define a trim method for a string

function trimString (str) {
  str = this != window? this : str;
  return str.replace(/^\s+/g, '').replace(/\s+$/g, '');
}
String.prototype.trim = trimString;

function execSelectAction(task){ 
  if((task.options[task.selectedIndex].value != null)
     &&(task.options[task.selectedIndex].value.length > 0)) {      
    eval(task.options[task.selectedIndex].value);
  } else {
    alert(i18n['Please make a valid selection']); 
  }
  
 task.selectedIndex = 0;
}

function actionNotAvailable() 
{
  alert(i18n['This action is unavailable in this context.']);
}

function goTo(url,param) {
  window.location = addSession(url) + param;
}

function goToUsingForm(url) {
  document.iabform.action = url;
  submitForm('');
}

function submitForm(action) {
  submitForm(action, false, '');
}

function submitForm(action, openInPopup, popupName) {
  if (action == "")
  { //Then maybe we can use a get instead of a post
    doPost = false;
    //Here are all the reasons to use a POST instead of a GET
    doPost = ((doPost) || (document.iabform.action.indexOf("select-popup.xml") != -1));
    doPost = ((doPost) || (document.iabform.action.indexOf("addressing-popup.xml") != -1));
    doPost = ((doPost) || (document.iabform.action.indexOf("addtogroup-popup.xml") != -1));
    doPost = ((doPost) || (document.iabform.action.indexOf("copyandeditcontact.xml") != -1));
    doPost = ((doPost) || (  (document.iabform.selectedentry != null) 
                           &&(document.iabform.selectedentry.length > 0) 
                           &&(document.iabform.selectedentry[0].type != 'checkbox'))); 
    doPost = ((doPost) || (  (document.iabform.alreadyselectedentry != null) 
                           &&(document.iabform.alreadyselectedentry.length > 0) 
                           &&(document.iabform.alreadyselectedentry[0].type != 'checkbox')));
    doPost = ((doPost) || ((document.iabform.expandgroup!= null) && (document.iabform.expandgroup.value.length > 0)));
    doPost = ((doPost) || (document.iabform.expandedgroup!= null));
    doPost = ((doPost) || (document.iabform.tabid!= null));
    if (!doPost && (document.iabform.selectedentry != null))
    {
      //Search for checked checkboxe(s)
      if (document.iabform.selectedentry.length == null)
        doPost = document.iabform.selectedentry.checked || document.iabform.selectedentry.type == 'hidden';
      else
        for (i=0; ((i<document.iabform.selectedentry.length) && !doPost); i++)
        {
          doPost = document.iabform.selectedentry[i].checked || document.iabform.selectedentry[i].type == 'hidden';
        }
    }
    if (!doPost && (document.iabform.alreadyselectedentry != null))
    {
      //Search for checked checkboxe(s)
      if (document.iabform.alreadyselectedentry.length == null)
        doPost = document.iabform.alreadyselectedentry.checked || document.iabform.alreadyselectedentry.type == 'hidden';
      else
        for (i=0; ((i<document.iabform.alreadyselectedentry.length) && !doPost); i++)
        {
          doPost = document.iabform.alreadyselectedentry[i].checked || document.iabform.alreadyselectedentry[i].type == 'hidden';
        }
    }
    if (!doPost)
    {
      //Get all the required fields and build the QueryString for the GET request
      qs = "?";

      if ((document.iabform.bookid     != null) &&
          (document.iabform.bookid.value.length     > 0))
        qs += "bookid="+document.iabform.bookid.value;

      //Get the filter field
      filter = "";
      if ((document.iabform.filter != null) &&
          (document.iabform.filter.value.length > 0))
        filter = escape(document.iabform.filter.value);
      if (filter.length > 0)
      {
        pos = -1;
        pos = filter.indexOf("%C3%");
        if (pos != -1)
        {
          while (filter.indexOf("%C3%") != -1)
          {
            tmpFilter = filter.substring(0, pos);
            c = parseInt(filter.substr(pos+4, 2), 16) + 64;
            filter = tmpFilter+"%"+c.toString(16).toUpperCase()+filter.substr(pos+6);
            pos = filter.indexOf("%C3%");
          }
        }
        qs += "&filter="+filter;
      }
      
      if ((document.iabform.firstentry != null) &&
          (document.iabform.firstentry.value.length > 0))
        qs += "&firstentry="+document.iabform.firstentry.value;

      if ((document.iabform.sortby != null) &&
          (document.iabform.sortby.value.length > 0)) {
        sortby = escape(document.iabform.sortby.value);
        sortby = sortby.replace(/\+/g, "%2B").replace(/\-/g, "%2D").replace(/\[/g, "%5B").replace(/\]/g, "%5D")
        qs += "&sortby=" + sortby;
      }

      if ((document.iabform.entryid    != null) && 
          (document.iabform.entryid.value.length     > 0)) 
        qs += "&entryid="+document.iabform.entryid.value;

      if ((document.iabform.searchid   != null) &&
          (document.iabform.searchid.value.length    > 0))
        qs += "&searchid="+document.iabform.searchid.value;

      if ((document.iabform.stopsearch != null) &&
          (document.iabform.stopsearch.value.length  > 0))
        qs += "&stopsearch="+document.iabform.stopsearch.value;

      if ((document.iabform.expandgroup!= null) &&
          (document.iabform.expandgroup.value.length > 0))
        qs += "&expandgroup="+document.iabform.expandgroup.value;

       if ((document.iabform.nextview != null) &&
          (document.iabform.nextview.value.length > 0))
        qs += "&nextview="+document.iabform.nextview.value;

       if((document.iabform.wcfg_searchmode != null) &&
          (document.iabform.wcfg_searchmode.value.length > 0 ))
        qs += "&wcfg_searchmode="+document.iabform.wcfg_searchmode.value;
        
       if((document.iabform.wcfg_groupmode != null) &&
          (document.iabform.wcfg_groupmode.value.length > 0 ))
        qs += "&wcfg_groupmode="+document.iabform.wcfg_groupmode.value;
        
       if((document.iabform.type != null) &&
          (document.iabform.type.value.length > 0 ))
        qs += "&type="+document.iabform.type.value;
      
       if((document.iabform.wcfg_showconf != null) &&
          (document.iabform.wcfg_showconf.value.length > 0 ))
        qs += "&wcfg_showconf="+document.iabform.wcfg_showconf.value;
      if( !openInPopup )//Finally change the current location
        window.location = addSession(document.iabform.action) + qs;
      else 
        selectWnd = window.open(addSession(document.iabform.action) + qs, popupName, 'scrollbars=yes,resizable=yes,width=700');               
    }
    else {
      document.iabform.action = addSession(document.iabform.action);
      document.iabform.uiaction.value = action;
      document.iabform.submit();
    }
        
  }
  else {
    if ((document.iabform.bookid     != null)) {
	    document.iabform.action = addSession(document.iabform.action) + "?bookid="+document.iabform.bookid.value;
    } else {
	    document.iabform.action = addSession(document.iabform.action);
    }

    document.iabform.uiaction.value = action;
    document.iabform.submit();
  }
}

function switchBook(bookEntryID, action) {
  if (bookEntryID != null)
    document.iabform.bookid.value = unescape(bookEntryID);
  document.iabform.firstentry.value = 1;
  document.iabform.stopsearch.value = 1;  
  setFilter('*', 'allEntries');
  document.iabform.wcfg_searchmode.value="";
  document.iabform.action=action;
  submitForm('');
}

function encode(str){
  var result="";
  str=unescape(str);
  str=str.replace(/,/g," ");
  for(i=0; i < str.length ; i++){	
    if (str.charAt(i) == " ") 
      result += "+";
    else 
      result += str.charAt(i);
  }
  str=escape(result);      
  return str;
}

function urlNotYetAvailable() 
{
  alert('Sorry, this page has not been integrated yet');
}

function getFieldValue(field)
{
  var toReturn = null;
  switch (field.type) {
    case "text": 
      toReturn = field.value;
      break;
    case "select-one":
      toReturn = getSelectValue(field);
      break;
    case "select-multiple":
      toReturn = getSelectValue(field);
      break;
  }
  return toReturn;
}

// Function to 'turn-on' the target image.
function imageon(imgName) {
  if (document.images) {
    document[imgName].src = eval(imgName + "on.src");
    }
}

// Function to handle mouse overs
function over(imgName) {
  document[imgName].src= eval(imgName + "over.src");
}

// Function to handle mouse outs
function out(imgName) {
  document[imgName].src= eval(imgName + "off.src");
}

// Handle select inputs
function getSelectValue(field)
{
  if (field.selectedIndex >= 0)
    switch(field.type) {
      case "select-one" :
        return(field.options[field.selectedIndex].value);
      case "select-multiple" :
        var valArray = new Array();
        for (var i=0; i < field.options.length; i++) {
          if (field.options[i].selected) valArray[valArray.length++] = field.options[i].value;
        }
        return (valArray);
    }
  else
    return(null);
}

// Handle select inputs
function getSelectText(field)
{
  if (field.selectedIndex >= 0)
    switch(field.type) {
      case "select-one" :
        return(field.options[field.selectedIndex].text);
      case "select-multiple" :
        var txtArray = new Array();
        for (var i=0; i < field.options.length; i++) {
          if (field.options[i].selected) txtArray[valArray.length++] = field.options[i].text;
        }
        return (txtArray);
    }
  else
    return(null);
}

function selectAllElts(field) {
  for (var i = 0; i < field.options.length; i++) {
    field.options[i].selected = true;
  }
}

function resetDropDown(dropDown,defaultValue)
{
  if(dropDown[dropDown.selectedIndex].value=="n/a")
  {
    if(defaultValue=='')
    {
      dropDown.selectedIndex=0;
      return;
    }
    for(var i=0; i<dropDown.length; i++)
      if(dropDown[i].value==defaultValue)
      {
        dropDown.selectedIndex=i
        return
      }
  }
}

function openPopup(url, title) {
 wnd = window.open(url,title,"height=600,width=715,resizable=yes,scrollbars=yes"); 
}

function openhelp(helpurl) {
  openWinAutoHeightAndFocus(helpurl, "UWCHelp", "titlebar=yes,scrollbars=yes,resizable=yes,width=700,menubar=yes");
}

function openWinAutoHeightAndFocus(theURL,winName,features) { //v2.0
  winHeight = screen.availHeight * .85
  winHndle = window.open(theURL, winName, features + ', height=' + winHeight);
  winHndle.focus();
}

function checkEmail(emailAddr) {
  if (/^\w+([\.-]?\w+)*@\w+([\.-]?\w+)*(\.\w{2,})+$/.test(emailAddr)){
   return true;
  }
  return (false);
}

function areEmailsValid() {
  
  var emailVal;
  emailVal = document.iabform.abperson_piEmail1.value;
  if ((trimString(emailVal) != "") && checkEmail(emailVal) == false)
    return false;
  emailVal = document.iabform.abperson_piEmail2.value;
  if ((trimString(emailVal) != "") && checkEmail(emailVal) == false)
    return false;
  emailVal = document.iabform.abperson_piEmail3.value;
  if ((trimString(emailVal) != "") && checkEmail(emailVal) == false)
    return false;

  return true;
}

function getQueryStringArgVal(queryString, arg) {
	
  var argVal = '';
  var argPos = queryString.indexOf(arg + '=');
  if(argPos != -1) {
    var argValPos = argPos + arg.length + 1;
    if(argValPos+1 <= queryString.length) {
      var nextAmpPos;
      if((nextAmpPos = queryString.indexOf('&',argValPos)) != -1) {
        argVal = queryString.substring(argValPos, nextAmpPos);
      } else {
        argVal = queryString.substr(argValPos);
      }	
    }
  }
  return trimString(argVal);

}
