/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.smtp;

import com.sun.mail.smtp.DigestMD5;
import com.sun.mail.smtp.SMTPMessage;
import com.sun.mail.smtp.SMTPOutputStream;
import com.sun.mail.smtp.SMTPSendFailedException;
import com.sun.mail.smtp.SMTPSendSucceededException;
import com.sun.mail.util.ASCIIUtility;
import com.sun.mail.util.BASE64EncoderStream;
import com.sun.mail.util.LineInputStream;
import com.sun.mail.util.SocketFetcher;
import com.sun.mail.util.TraceInputStream;
import com.sun.mail.util.TraceOutputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringReader;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.SendFailedException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.URLName;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;
import javax.mail.internet.ParseException;

public class SMTPTransport
extends Transport {
    private String name = "smtp";
    private int defaultPort = 25;
    private boolean isSSL = false;
    private MimeMessage message;
    private Address[] addresses;
    private Address[] validSentAddr;
    private Address[] validUnsentAddr;
    private Address[] invalidAddr;
    boolean sendPartiallyFailed = false;
    MessagingException exception;
    private Hashtable extMap;
    private boolean noAuth = false;
    private boolean quitWait = false;
    private String saslRealm = "UNKNOWN";
    private boolean reportSuccess;
    private boolean useStartTLS;
    private PrintStream out;
    private String localHostName;
    private String lastServerResponse;
    private static final String[] ignoreList = new String[]{"Bcc", "Content-Length"};
    private static final byte[] CRLF = new byte[]{13, 10};
    private static final String UNKNOWN = "UNKNOWN";
    private DigestMD5 md5support;
    private BufferedInputStream serverInput;
    private LineInputStream lineInputStream;
    private OutputStream serverOutput;
    private Socket serverSocket;
    private static char[] hexchar = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public SMTPTransport(Session session, URLName urlname) {
        this(session, urlname, "smtp", 25, false);
    }

    protected SMTPTransport(Session session, URLName urlname, String name, int defaultPort, boolean isSSL) {
        super(session, urlname);
        if (urlname != null) {
            name = urlname.getProtocol();
        }
        this.name = name;
        this.defaultPort = defaultPort;
        this.isSSL = isSSL;
        this.out = session.getDebugOut();
        String s = session.getProperty("mail." + name + ".quitwait");
        this.quitWait = s != null && s.equalsIgnoreCase("true");
        s = session.getProperty("mail." + name + ".reportsuccess");
        this.reportSuccess = s != null && s.equalsIgnoreCase("true");
        s = session.getProperty("mail." + name + ".starttls.enable");
        this.useStartTLS = s != null && s.equalsIgnoreCase("true");
    }

    public String getLocalHost() {
        try {
            if (this.localHostName == null || this.localHostName.length() <= 0) {
                this.localHostName = this.session.getProperty("mail." + this.name + ".localhost");
            }
            if (this.localHostName == null || this.localHostName.length() <= 0) {
                this.localHostName = InetAddress.getLocalHost().getHostName();
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return this.localHostName;
    }

    public void setLocalHost(String localhost) {
        this.localHostName = localhost;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void connect() throws MessagingException {
        try {
            this.noAuth = true;
            super.connect();
        }
        finally {
            this.noAuth = false;
        }
    }

    public String getSASLRealm() {
        if (this.saslRealm == UNKNOWN) {
            this.saslRealm = this.session.getProperty("mail." + this.name + ".saslrealm");
        }
        return this.saslRealm;
    }

    public void setSASLRealm(String saslRealm) {
        this.saslRealm = saslRealm;
    }

    public boolean getReportSuccess() {
        return this.reportSuccess;
    }

    public void setReportSuccess(boolean reportSuccess) {
        this.reportSuccess = reportSuccess;
    }

    public boolean getStartTLS() {
        return this.useStartTLS;
    }

    public void setStartTLS(boolean useStartTLS) {
        this.useStartTLS = useStartTLS;
    }

    public String getLastServerResponse() {
        return this.lastServerResponse;
    }

    private synchronized DigestMD5 getMD5() {
        if (this.md5support == null) {
            this.md5support = new DigestMD5(this.debug ? this.out : null);
        }
        return this.md5support;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean protocolConnect(String host, int port, String user, String passwd) throws MessagingException {
        DigestMD5 md5;
        boolean useAuth;
        String ehloStr = this.session.getProperty("mail." + this.name + ".ehlo");
        boolean useEhlo = ehloStr == null || !ehloStr.equalsIgnoreCase("false");
        String authStr = this.session.getProperty("mail." + this.name + ".auth");
        boolean bl = useAuth = authStr != null && authStr.equalsIgnoreCase("true");
        if (this.debug) {
            this.out.println("DEBUG SMTP: useEhlo " + useEhlo + ", useAuth " + useAuth);
        }
        if (useAuth && (user == null || passwd == null)) {
            return false;
        }
        if (port == -1) {
            String portstring = this.session.getProperty("mail." + this.name + ".port");
            port = portstring != null ? Integer.parseInt(portstring) : this.defaultPort;
        }
        if (host == null || host.length() == 0) {
            host = "localhost";
        }
        boolean succeed = false;
        this.openServer(host, port);
        if (useEhlo) {
            succeed = this.ehlo(this.getLocalHost());
        }
        if (!succeed) {
            this.helo(this.getLocalHost());
        }
        if (this.useStartTLS && this.supportsExtension("STARTTLS")) {
            this.startTLS();
        }
        if (!useAuth || !this.supportsExtension("AUTH") && !this.supportsExtension("AUTH=LOGIN")) return true;
        if (this.debug) {
            this.out.println("DEBUG SMTP: Attempt to authenticate");
            if (!this.supportsAuthentication("LOGIN") && this.supportsExtension("AUTH=LOGIN")) {
                this.out.println("DEBUG SMTP: use AUTH=LOGIN hack");
            }
        }
        if (this.supportsAuthentication("LOGIN") || this.supportsExtension("AUTH=LOGIN")) {
            int resp = this.simpleCommand("AUTH LOGIN");
            if (resp == 530) {
                this.startTLS();
                resp = this.simpleCommand("AUTH LOGIN");
            }
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                BASE64EncoderStream b64os = new BASE64EncoderStream(bos, Integer.MAX_VALUE);
                if (resp == 334) {
                    ((OutputStream)b64os).write(ASCIIUtility.getBytes(user));
                    ((OutputStream)b64os).flush();
                    resp = this.simpleCommand(bos.toByteArray());
                    bos.reset();
                }
                if (resp != 334) return true;
                ((OutputStream)b64os).write(ASCIIUtility.getBytes(passwd));
                ((OutputStream)b64os).flush();
                resp = this.simpleCommand(bos.toByteArray());
                bos.reset();
                return true;
            }
            catch (IOException ex) {
                if (resp == 235) return true;
                this.closeConnection();
                return false;
            }
            finally {
                if (resp != 235) {
                    this.closeConnection();
                    return false;
                }
            }
        }
        if (this.supportsAuthentication("PLAIN")) {
            int resp = this.simpleCommand("AUTH PLAIN");
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                BASE64EncoderStream b64os = new BASE64EncoderStream(bos, Integer.MAX_VALUE);
                if (resp != 334) return true;
                ((OutputStream)b64os).write(0);
                ((OutputStream)b64os).write(ASCIIUtility.getBytes(user));
                ((OutputStream)b64os).write(0);
                ((OutputStream)b64os).write(ASCIIUtility.getBytes(passwd));
                ((OutputStream)b64os).flush();
                resp = this.simpleCommand(bos.toByteArray());
                return true;
            }
            catch (IOException ex) {
                if (resp == 235) return true;
                this.closeConnection();
                return false;
            }
            finally {
                if (resp != 235) {
                    this.closeConnection();
                    return false;
                }
            }
        }
        if (!this.supportsAuthentication("DIGEST-MD5") || (md5 = this.getMD5()) == null) return true;
        int resp = this.simpleCommand("AUTH DIGEST-MD5");
        try {
            byte[] b;
            if (resp != 334 || (resp = this.simpleCommand(b = md5.authClient(host, user, passwd, this.getSASLRealm(), this.lastServerResponse))) != 334) return true;
            resp = !md5.authServer(this.lastServerResponse) ? -1 : this.simpleCommand(new byte[0]);
            return true;
        }
        catch (Exception ex) {
            if (this.debug) {
                this.out.println("DEBUG SMTP: DIGEST-MD5: " + ex);
            }
        }
        finally {
            if (resp == 235) return true;
            this.closeConnection();
            return false;
        }
    }

    public synchronized void sendMessage(Message message, Address[] addresses) throws MessagingException, SendFailedException {
        this.checkConnected();
        if (!(message instanceof MimeMessage)) {
            if (this.debug) {
                this.out.println("DEBUG SMTP: Can only send RFC822 msgs");
            }
            throw new MessagingException("SMTP can only send RFC822 messages");
        }
        for (int i = 0; i < addresses.length; ++i) {
            if (addresses[i] instanceof InternetAddress) continue;
            throw new MessagingException(addresses[i] + " is not an InternetAddress");
        }
        this.message = (MimeMessage)message;
        this.addresses = addresses;
        this.expandGroups();
        boolean use8bit = false;
        if (message instanceof SMTPMessage) {
            use8bit = ((SMTPMessage)message).getAllow8bitMIME();
        }
        if (!use8bit) {
            String ebStr = this.session.getProperty("mail." + this.name + ".allow8bitmime");
            boolean bl = use8bit = ebStr != null && ebStr.equalsIgnoreCase("true");
        }
        if (this.debug) {
            this.out.println("DEBUG SMTP: use8bit " + use8bit);
        }
        if (use8bit && this.supportsExtension("8BITMIME")) {
            this.convertTo8Bit(this.message);
        }
        try {
            try {
                this.mailFrom();
                this.rcptTo();
                this.message.writeTo(this.data(), ignoreList);
                this.finishData();
                if (this.sendPartiallyFailed) {
                    if (this.debug) {
                        this.out.println("DEBUG SMTP: Sending partially failed because of invalid destination addresses");
                    }
                    this.notifyTransportListeners(3, this.validSentAddr, this.validUnsentAddr, this.invalidAddr, this.message);
                    throw new SendFailedException("Message partially delivered", this.exception, this.validSentAddr, this.validUnsentAddr, this.invalidAddr);
                }
                this.notifyTransportListeners(1, this.validSentAddr, this.validUnsentAddr, this.invalidAddr, this.message);
            }
            catch (IOException ex) {
                if (this.debug) {
                    ex.printStackTrace(this.out);
                }
                try {
                    this.closeConnection();
                }
                catch (MessagingException mex) {
                    // empty catch block
                }
                this.notifyTransportListeners(2, this.validSentAddr, this.validUnsentAddr, this.invalidAddr, this.message);
                throw new MessagingException("IOException while sending message", ex);
            }
            Object var7_6 = null;
            this.invalidAddr = null;
            this.validUnsentAddr = null;
            this.validSentAddr = null;
            this.addresses = null;
            this.message = null;
            this.exception = null;
            this.sendPartiallyFailed = false;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.invalidAddr = null;
            this.validUnsentAddr = null;
            this.validSentAddr = null;
            this.addresses = null;
            this.message = null;
            this.exception = null;
            this.sendPartiallyFailed = false;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws MessagingException {
        if (!super.isConnected()) {
            return;
        }
        try {
            if (this.serverSocket != null) {
                int resp;
                this.sendCommand("QUIT");
                if (this.quitWait && (resp = this.readServerResponse()) != 221 && resp != -1) {
                    this.out.println("DEBUG SMTP: QUIT failed with " + resp);
                }
            }
        }
        finally {
            this.closeConnection();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void closeConnection() throws MessagingException {
        try {
            block4: {
                try {
                    if (this.serverSocket == null) break block4;
                    this.serverSocket.close();
                }
                catch (IOException ioex) {
                    throw new MessagingException("Server Close Failed", ioex);
                }
            }
            Object var3_1 = null;
            this.serverSocket = null;
            this.serverOutput = null;
            this.serverInput = null;
            this.lineInputStream = null;
            if (!super.isConnected()) return;
            super.close();
            return;
        }
        catch (Throwable throwable) {
            Object var3_2 = null;
            this.serverSocket = null;
            this.serverOutput = null;
            this.serverInput = null;
            this.lineInputStream = null;
            if (!super.isConnected()) throw throwable;
            super.close();
            throw throwable;
        }
    }

    public synchronized boolean isConnected() {
        if (!super.isConnected()) {
            return false;
        }
        try {
            this.sendCommand("NOOP");
            int resp = this.readServerResponse();
            if (resp >= 0 && resp != 421) {
                return true;
            }
            try {
                this.closeConnection();
            }
            catch (MessagingException mex) {
                // empty catch block
            }
            return false;
        }
        catch (Exception ex) {
            try {
                this.closeConnection();
            }
            catch (MessagingException messagingException) {
                // empty catch block
            }
            return false;
        }
    }

    private void expandGroups() {
        Vector<InternetAddress> groups = null;
        for (int i = 0; i < this.addresses.length; ++i) {
            InternetAddress a = (InternetAddress)this.addresses[i];
            if (a.isGroup()) {
                if (groups == null) {
                    groups = new Vector<InternetAddress>();
                    for (int k = 0; k < i; ++k) {
                        groups.addElement((InternetAddress)this.addresses[k]);
                    }
                }
                try {
                    InternetAddress[] ia = a.getGroup(true);
                    if (ia != null) {
                        for (int j = 0; j < ia.length; ++j) {
                            groups.addElement(ia[j]);
                        }
                        continue;
                    }
                    groups.addElement(a);
                }
                catch (ParseException pex) {
                    groups.addElement(a);
                }
                continue;
            }
            if (groups == null) continue;
            groups.addElement(a);
        }
        if (groups != null) {
            Object[] newa = new InternetAddress[groups.size()];
            groups.copyInto(newa);
            this.addresses = newa;
        }
    }

    private void convertTo8Bit(MimePart part) {
        try {
            if (part.isMimeType("text/*")) {
                InputStream is;
                String enc = part.getEncoding();
                if ((enc.equalsIgnoreCase("quoted-printable") || enc.equalsIgnoreCase("base64")) && this.is8Bit(is = part.getInputStream())) {
                    part.setHeader("Content-Transfer-Encoding", "8bit");
                }
            } else if (part.isMimeType("multipart/*")) {
                MimeMultipart mp = (MimeMultipart)part.getContent();
                int count = mp.getCount();
                for (int i = 0; i < count; ++i) {
                    this.convertTo8Bit((MimePart)((Object)mp.getBodyPart(i)));
                }
            }
        }
        catch (IOException ioex) {
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
    }

    private boolean is8Bit(InputStream is) {
        int linelen = 0;
        boolean need8bit = false;
        try {
            int b;
            while ((b = is.read()) >= 0) {
                if ((b &= 0xFF) == 13 || b == 10) {
                    linelen = 0;
                } else {
                    if (b == 0) {
                        return false;
                    }
                    if (++linelen > 998) {
                        return false;
                    }
                }
                if (b <= 127) continue;
                need8bit = true;
            }
        }
        catch (IOException ex) {
            return false;
        }
        if (this.debug && need8bit) {
            this.out.println("DEBUG SMTP: found an 8bit part");
        }
        return need8bit;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        try {
            this.closeConnection();
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
    }

    private void helo(String domain) throws MessagingException {
        if (domain != null) {
            this.issueCommand("HELO " + domain, 250);
        } else {
            this.issueCommand("HELO", 250);
        }
    }

    private boolean ehlo(String domain) throws MessagingException {
        String cmd = domain != null ? "EHLO " + domain : "EHLO";
        this.sendCommand(cmd);
        int resp = this.readServerResponse();
        if (resp == 250) {
            BufferedReader rd = new BufferedReader(new StringReader(this.lastServerResponse));
            this.extMap = new Hashtable();
            try {
                String line;
                boolean first = true;
                while ((line = rd.readLine()) != null) {
                    if (first) {
                        first = false;
                        continue;
                    }
                    if (line.length() < 5) continue;
                    line = line.substring(4);
                    int i = line.indexOf(32);
                    String arg = "";
                    if (i > 0) {
                        arg = line.substring(i + 1);
                        line = line.substring(0, i);
                    }
                    if (this.debug) {
                        this.out.println("DEBUG SMTP: Found extension \"" + line + "\", arg \"" + arg + "\"");
                    }
                    this.extMap.put(line.toUpperCase(), arg);
                }
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        return resp == 250;
    }

    private void mailFrom() throws MessagingException {
        String cmd;
        block15: {
            String from = null;
            if (this.message instanceof SMTPMessage) {
                from = ((SMTPMessage)this.message).getEnvelopeFrom();
            }
            if (from == null || from.length() <= 0) {
                from = this.session.getProperty("mail." + this.name + ".from");
            }
            if (from == null || from.length() <= 0) {
                Address[] fa;
                Address me = this.message != null && (fa = this.message.getFrom()) != null && fa.length > 0 ? fa[0] : InternetAddress.getLocalAddress(this.session);
                if (me != null) {
                    from = me.getAddress();
                } else {
                    throw new MessagingException("can't determine local email address");
                }
            }
            cmd = "MAIL FROM:" + this.normalizeAddress(from);
            if (this.supportsExtension("DSN")) {
                String ret = null;
                if (this.message instanceof SMTPMessage) {
                    ret = ((SMTPMessage)this.message).getDSNRet();
                }
                if (ret == null) {
                    ret = this.session.getProperty("mail." + this.name + ".dsn.ret");
                }
                if (ret != null) {
                    cmd = cmd + " RET=" + ret;
                }
            }
            if (this.supportsExtension("AUTH")) {
                String submitter = null;
                if (this.message instanceof SMTPMessage) {
                    submitter = ((SMTPMessage)this.message).getSubmitter();
                }
                if (submitter == null) {
                    submitter = this.session.getProperty("mail." + this.name + ".submitter");
                }
                if (submitter != null) {
                    try {
                        String s = this.xtext(submitter);
                        cmd = cmd + " AUTH=" + s;
                    }
                    catch (IllegalArgumentException ex) {
                        if (!this.debug) break block15;
                        this.out.println("DEBUG SMTP: ignoring invalid submitter: " + submitter + ", Exception: " + ex);
                    }
                }
            }
        }
        this.issueCommand(cmd, 250);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rcptTo() throws MessagingException {
        int i;
        Vector<InternetAddress> valid = new Vector<InternetAddress>();
        Vector<InternetAddress> validUnsent = new Vector<InternetAddress>();
        Vector<InternetAddress> invalid = new Vector<InternetAddress>();
        int retCode = -1;
        MessagingException mex = null;
        boolean sendFailed = false;
        MessagingException sfex = null;
        this.invalidAddr = null;
        this.validUnsentAddr = null;
        this.validSentAddr = null;
        boolean sendPartial = false;
        if (this.message instanceof SMTPMessage) {
            sendPartial = ((SMTPMessage)this.message).getSendPartial();
        }
        if (!sendPartial) {
            String sp = this.session.getProperty("mail." + this.name + ".sendpartial");
            sendPartial = sp != null && sp.equalsIgnoreCase("true");
        }
        boolean dsn = false;
        String notify = null;
        if (this.supportsExtension("DSN")) {
            if (this.message instanceof SMTPMessage) {
                notify = ((SMTPMessage)this.message).getDSNNotify();
            }
            if (notify == null) {
                notify = this.session.getProperty("mail." + this.name + ".dsn.notify");
            }
            if (notify != null) {
                dsn = true;
            }
        }
        block12: for (i = 0; i < this.addresses.length; ++i) {
            sfex = null;
            InternetAddress ia = (InternetAddress)this.addresses[i];
            String cmd = "RCPT TO:" + this.normalizeAddress(ia.getAddress());
            if (dsn) {
                cmd = cmd + " NOTIFY=" + notify;
            }
            this.sendCommand(cmd);
            retCode = this.readServerResponse();
            switch (retCode) {
                case 250: 
                case 251: {
                    valid.addElement(ia);
                    if (!this.reportSuccess) continue block12;
                    sfex = new SMTPSendSucceededException(ia, cmd, retCode, this.lastServerResponse);
                    if (mex == null) {
                        mex = sfex;
                        continue block12;
                    }
                    mex.setNextException(sfex);
                    continue block12;
                }
                case 501: 
                case 503: 
                case 550: 
                case 551: 
                case 553: {
                    if (!sendPartial) {
                        sendFailed = true;
                    }
                    invalid.addElement(ia);
                    sfex = new SMTPSendFailedException(ia, cmd, retCode, this.lastServerResponse);
                    if (mex == null) {
                        mex = sfex;
                        continue block12;
                    }
                    mex.setNextException(sfex);
                    continue block12;
                }
                case 450: 
                case 451: 
                case 452: 
                case 552: {
                    if (!sendPartial) {
                        sendFailed = true;
                    }
                    validUnsent.addElement(ia);
                    sfex = new SMTPSendFailedException(ia, cmd, retCode, this.lastServerResponse);
                    if (mex == null) {
                        mex = sfex;
                        continue block12;
                    }
                    mex.setNextException(sfex);
                    continue block12;
                }
                default: {
                    if (retCode >= 400 && retCode <= 499) {
                        validUnsent.addElement(ia);
                    } else if (retCode >= 500 && retCode <= 599) {
                        invalid.addElement(ia);
                    } else {
                        if (this.debug) {
                            this.out.println("DEBUG SMTP: got response code " + retCode + ", with response: " + this.lastServerResponse);
                        }
                        String _lsr = this.lastServerResponse;
                        if (this.serverSocket != null) {
                            this.issueCommand("RSET", 250);
                        }
                        this.lastServerResponse = _lsr;
                        throw new SMTPSendFailedException(ia, cmd, retCode, _lsr);
                    }
                    if (!sendPartial) {
                        sendFailed = true;
                    }
                    sfex = new SMTPSendFailedException(ia, cmd, retCode, this.lastServerResponse);
                    if (mex == null) {
                        mex = sfex;
                        continue block12;
                    }
                    mex.setNextException(sfex);
                }
            }
        }
        if (sendPartial && valid.size() == 0) {
            sendFailed = true;
        }
        if (sendFailed) {
            int j;
            this.invalidAddr = new Address[invalid.size()];
            invalid.copyInto(this.invalidAddr);
            this.validUnsentAddr = new Address[valid.size() + validUnsent.size()];
            i = 0;
            for (j = 0; j < valid.size(); ++j) {
                this.validUnsentAddr[i++] = (Address)valid.elementAt(j);
            }
            for (j = 0; j < validUnsent.size(); ++j) {
                this.validUnsentAddr[i++] = (Address)validUnsent.elementAt(j);
            }
        } else if (this.reportSuccess || sendPartial && (invalid.size() > 0 || validUnsent.size() > 0)) {
            this.sendPartiallyFailed = true;
            this.exception = mex;
            this.invalidAddr = new Address[invalid.size()];
            invalid.copyInto(this.invalidAddr);
            this.validUnsentAddr = new Address[validUnsent.size()];
            validUnsent.copyInto(this.validUnsentAddr);
            this.validSentAddr = new Address[valid.size()];
            valid.copyInto(this.validSentAddr);
        } else {
            this.validSentAddr = this.addresses;
        }
        if (this.debug) {
            if (this.validSentAddr != null && this.validSentAddr.length > 0) {
                this.out.println("DEBUG SMTP: Verified Addresses");
                for (int l = 0; l < this.validSentAddr.length; ++l) {
                    this.out.println("DEBUG SMTP:   " + this.validSentAddr[l]);
                }
            }
            if (this.validUnsentAddr != null && this.validUnsentAddr.length > 0) {
                this.out.println("DEBUG SMTP: Valid Unsent Addresses");
                for (int j = 0; j < this.validUnsentAddr.length; ++j) {
                    this.out.println("DEBUG SMTP:   " + this.validUnsentAddr[j]);
                }
            }
            if (this.invalidAddr != null && this.invalidAddr.length > 0) {
                this.out.println("DEBUG SMTP: Invalid Addresses");
                for (int k = 0; k < this.invalidAddr.length; ++k) {
                    this.out.println("DEBUG SMTP:   " + this.invalidAddr[k]);
                }
            }
        }
        if (sendFailed) {
            if (this.debug) {
                this.out.println("DEBUG SMTP: Sending failed because of invalid destination addresses");
            }
            this.notifyTransportListeners(2, this.validSentAddr, this.validUnsentAddr, this.invalidAddr, this.message);
            String lsr = this.lastServerResponse;
            try {
                if (this.serverSocket != null) {
                    this.issueCommand("RSET", 250);
                }
            }
            catch (MessagingException ex) {
                try {
                    this.close();
                }
                catch (MessagingException ex2) {
                    if (this.debug) {
                        ex2.printStackTrace(this.out);
                    }
                }
            }
            finally {
                this.lastServerResponse = lsr;
            }
            throw new SendFailedException("Invalid Addresses", mex, this.validSentAddr, this.validUnsentAddr, this.invalidAddr);
        }
    }

    private OutputStream data() throws MessagingException {
        this.issueCommand("DATA", 354);
        return new SMTPOutputStream(this.serverOutput);
    }

    private void finishData() throws MessagingException {
        this.issueCommand("\r\n.", 250);
    }

    private void startTLS() throws MessagingException {
        this.issueCommand("STARTTLS", 220);
        try {
            this.serverSocket = SocketFetcher.startTLS(this.serverSocket);
            this.initStreams();
        }
        catch (IOException ioex) {
            this.closeConnection();
            throw new MessagingException("Could not convert socket to TLS", ioex);
        }
    }

    private void openServer(String server, int port) throws MessagingException {
        if (this.debug) {
            this.out.println("DEBUG SMTP: trying to connect to host \"" + server + "\", port " + port + ", isSSL " + this.isSSL);
        }
        try {
            Properties props = this.session.getProperties();
            this.serverSocket = SocketFetcher.getSocket(server, port, props, "mail." + this.name, this.isSSL);
            port = this.serverSocket.getPort();
            this.initStreams();
            int r = -1;
            r = this.readServerResponse();
            if (r != 220) {
                this.serverSocket.close();
                this.serverSocket = null;
                this.serverOutput = null;
                this.serverInput = null;
                this.lineInputStream = null;
                if (this.debug) {
                    this.out.println("DEBUG SMTP: could not connect to host \"" + server + "\", port: " + port + ", response: " + r + "\n");
                }
                throw new MessagingException("Could not connect to SMTP host: " + server + ", port: " + port + ", response: " + r);
            }
            if (this.debug) {
                this.out.println("DEBUG SMTP: connected to host \"" + server + "\", port: " + port + "\n");
            }
        }
        catch (UnknownHostException uhex) {
            throw new MessagingException("Unknown SMTP host: " + server, uhex);
        }
        catch (IOException ioe) {
            throw new MessagingException("Could not connect to SMTP host: " + server + ", port: " + port, ioe);
        }
    }

    private void initStreams() throws IOException {
        Properties props = this.session.getProperties();
        PrintStream out = this.session.getDebugOut();
        boolean debug = this.session.getDebug();
        String s = props.getProperty("mail.debug.quote");
        boolean quote = s != null && s.equalsIgnoreCase("true");
        TraceInputStream traceInput = new TraceInputStream(this.serverSocket.getInputStream(), out);
        traceInput.setTrace(debug);
        traceInput.setQuote(quote);
        TraceOutputStream traceOutput = new TraceOutputStream(this.serverSocket.getOutputStream(), out);
        traceOutput.setTrace(debug);
        traceOutput.setQuote(quote);
        this.serverOutput = new BufferedOutputStream(traceOutput);
        this.serverInput = new BufferedInputStream(traceInput);
        this.lineInputStream = new LineInputStream(this.serverInput);
    }

    private void issueCommand(String cmd, int expect) throws MessagingException {
        this.sendCommand(cmd);
        if (this.readServerResponse() != expect) {
            throw new MessagingException(this.lastServerResponse);
        }
    }

    private int simpleCommand(String cmd) throws MessagingException {
        this.sendCommand(cmd);
        return this.readServerResponse();
    }

    private int simpleCommand(byte[] cmd) throws MessagingException {
        this.sendCommand(cmd);
        return this.readServerResponse();
    }

    private void sendCommand(String cmd) throws MessagingException {
        this.sendCommand(ASCIIUtility.getBytes(cmd));
    }

    private void sendCommand(byte[] cmdBytes) throws MessagingException {
        try {
            this.serverOutput.write(cmdBytes);
            this.serverOutput.write(CRLF);
            this.serverOutput.flush();
        }
        catch (IOException ex) {
            throw new MessagingException("Can't send command to SMTP host", ex);
        }
    }

    private int readServerResponse() throws MessagingException {
        String serverResponse = "";
        int returnCode = 0;
        StringBuffer buf = new StringBuffer(100);
        try {
            String line = null;
            do {
                if ((line = this.lineInputStream.readLine()) == null) {
                    serverResponse = buf.toString();
                    if (serverResponse.length() == 0) {
                        serverResponse = "[EOF]";
                    }
                    this.lastServerResponse = serverResponse;
                    if (this.debug) {
                        this.out.println("DEBUG SMTP: EOF: " + serverResponse);
                    }
                    return -1;
                }
                buf.append(line);
                buf.append("\n");
            } while (this.isNotLastLine(line));
            serverResponse = buf.toString();
        }
        catch (IOException ioex) {
            if (this.debug) {
                this.out.println("DEBUG SMTP: exception reading response: " + ioex);
            }
            this.lastServerResponse = "";
            throw new MessagingException("Exception reading response", ioex);
        }
        if (serverResponse != null && serverResponse.length() >= 3) {
            try {
                returnCode = Integer.parseInt(serverResponse.substring(0, 3));
            }
            catch (NumberFormatException nfe) {
                block17: {
                    try {
                        this.close();
                    }
                    catch (MessagingException mex) {
                        if (!this.debug) break block17;
                        mex.printStackTrace(this.out);
                    }
                }
                returnCode = -1;
            }
            catch (StringIndexOutOfBoundsException ex) {
                block18: {
                    try {
                        this.close();
                    }
                    catch (MessagingException mex) {
                        if (!this.debug) break block18;
                        mex.printStackTrace(this.out);
                    }
                }
                returnCode = -1;
            }
        } else {
            returnCode = -1;
        }
        if (returnCode == -1 && this.debug) {
            this.out.println("DEBUG SMTP: bad server response: " + serverResponse);
        }
        this.lastServerResponse = serverResponse;
        return returnCode;
    }

    private void checkConnected() {
        if (!super.isConnected()) {
            throw new IllegalStateException("Not connected");
        }
    }

    private boolean isNotLastLine(String line) {
        return line != null && line.length() >= 4 && line.charAt(3) == '-';
    }

    private String normalizeAddress(String addr) {
        if (!addr.startsWith("<") && !addr.endsWith(">")) {
            return "<" + addr + ">";
        }
        return addr;
    }

    private boolean supportsExtension(String ext) {
        return this.extMap != null && this.extMap.get(ext.toUpperCase()) != null;
    }

    private boolean supportsAuthentication(String auth) {
        if (this.extMap == null) {
            return false;
        }
        String a = (String)this.extMap.get("AUTH");
        if (a == null) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(a);
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            if (!tok.equalsIgnoreCase(auth)) continue;
            return true;
        }
        return false;
    }

    private String xtext(String s) {
        StringBuffer sb = null;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c >= '\u0080') {
                throw new IllegalArgumentException("Non-ASCII character in SMTP submitter: " + s);
            }
            if (c < '!' || c > '~' || c == '+' || c == '=') {
                if (sb == null) {
                    sb = new StringBuffer(s.length() + 4);
                    sb.append(s.substring(0, i));
                }
                sb.append('+');
                sb.append(hexchar[(c & 0xF0) >> 4]);
                sb.append(hexchar[c & 0xF]);
                continue;
            }
            if (sb == null) continue;
            sb.append(c);
        }
        return sb != null ? sb.toString() : s;
    }
}

