/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.pop3;

import com.sun.mail.pop3.Response;
import com.sun.mail.pop3.SharedByteArrayOutputStream;
import com.sun.mail.pop3.Status;
import com.sun.mail.util.LineInputStream;
import com.sun.mail.util.SocketFetcher;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.Properties;
import java.util.StringTokenizer;

class Protocol {
    private Socket socket;
    private DataInputStream input;
    private PrintWriter output;
    private static final int POP3_PORT = 110;
    private static final String CRLF = "\r\n";
    private boolean debug = false;
    private PrintStream out;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Protocol(String host, int port, boolean debug, PrintStream out, Properties props, String prefix, boolean isSSL) throws IOException {
        Response r;
        this.debug = debug;
        this.out = out;
        try {
            if (port == -1) {
                port = 110;
            }
            if (debug) {
                out.println("DEBUG POP3: connecting to host \"" + host + "\", port " + port + ", isSSL " + isSSL);
            }
            this.socket = SocketFetcher.getSocket(host, port, props, prefix, isSSL);
            this.input = new DataInputStream(new BufferedInputStream(this.socket.getInputStream()));
            this.output = new PrintWriter(new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream(), "iso-8859-1")));
            r = this.simpleCommand(null);
        }
        catch (IOException ioe) {
            try {
                this.socket.close();
            }
            finally {
                throw ioe;
            }
        }
        if (!r.ok) {
            try {
                this.socket.close();
            }
            finally {
                throw new IOException("Connect failed");
            }
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.socket != null) {
            this.quit();
        }
    }

    synchronized String login(String user, String password) throws IOException {
        Response r = this.simpleCommand("USER " + user);
        if (!r.ok) {
            return r.data != null ? r.data : "USER command failed";
        }
        r = this.simpleCommand("PASS " + password);
        if (!r.ok) {
            return r.data != null ? r.data : "login failed";
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized boolean quit() throws IOException {
        Object v1;
        boolean ok;
        block5: {
            ok = false;
            try {
                Response r = this.simpleCommand("QUIT");
                ok = r.ok;
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object v0;
                Object var4_4 = null;
                try {
                    this.socket.close();
                    v0 = null;
                }
                catch (Throwable throwable2) {
                    v0 = null;
                }
                Object var6_8 = v0;
                this.socket = null;
                this.input = null;
                this.output = null;
                throw throwable;
            }
            try {
                this.socket.close();
                v1 = null;
                break block5;
            }
            catch (Throwable throwable) {
                v1 = null;
            }
            {
            }
        }
        Object var6_7 = v1;
        this.socket = null;
        this.input = null;
        this.output = null;
        return ok;
    }

    synchronized Status stat() throws IOException {
        Response r = this.simpleCommand("STAT");
        Status s = new Status();
        if (r.ok && r.data != null) {
            try {
                StringTokenizer st = new StringTokenizer(r.data);
                s.total = Integer.parseInt(st.nextToken());
                s.size = Integer.parseInt(st.nextToken());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return s;
    }

    synchronized int list(int msg) throws IOException {
        Response r = this.simpleCommand("LIST " + msg);
        int size = -1;
        if (r.ok && r.data != null) {
            try {
                StringTokenizer st = new StringTokenizer(r.data);
                st.nextToken();
                size = Integer.parseInt(st.nextToken());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return size;
    }

    synchronized InputStream retr(int msg, int size) throws IOException {
        Response r = this.multilineCommand("RETR " + msg, size);
        return r.bytes;
    }

    synchronized InputStream top(int msg, int n) throws IOException {
        Response r = this.multilineCommand("TOP " + msg + " " + n, 0);
        return r.bytes;
    }

    synchronized boolean dele(int msg) throws IOException {
        Response r = this.simpleCommand("DELE " + msg);
        return r.ok;
    }

    synchronized String uidl(int msg) throws IOException {
        Response r = this.simpleCommand("UIDL " + msg);
        if (!r.ok) {
            return null;
        }
        int i = r.data.indexOf(32);
        if (i > 0) {
            return r.data.substring(i + 1);
        }
        return null;
    }

    synchronized boolean uidl(String[] uids) throws IOException {
        Response r = this.multilineCommand("UIDL", 15 * uids.length);
        if (!r.ok) {
            return false;
        }
        LineInputStream lis = new LineInputStream(r.bytes);
        String line = null;
        while ((line = lis.readLine()) != null) {
            int n;
            int i = line.indexOf(32);
            if (i < 1 || i >= line.length() || (n = Integer.parseInt(line.substring(0, i))) <= 0 || n > uids.length) continue;
            uids[n - 1] = line.substring(i + 1);
        }
        return true;
    }

    synchronized boolean noop() throws IOException {
        Response r = this.simpleCommand("NOOP");
        return r.ok;
    }

    synchronized boolean rset() throws IOException {
        Response r = this.simpleCommand("RSET");
        return r.ok;
    }

    private Response simpleCommand(String cmd) throws IOException {
        String line;
        if (this.socket == null) {
            throw new IOException("Folder is closed");
        }
        if (cmd != null) {
            if (this.debug) {
                this.out.println("C: " + cmd);
            }
            cmd = cmd + CRLF;
            this.output.print(cmd);
            this.output.flush();
        }
        if ((line = this.input.readLine()) == null) {
            if (this.debug) {
                this.out.println("S: EOF");
            }
            throw new EOFException("EOF on socket");
        }
        if (this.debug) {
            this.out.println("S: " + line);
        }
        Response r = new Response();
        if (line.startsWith("+OK")) {
            r.ok = true;
        } else if (line.startsWith("-ERR")) {
            r.ok = false;
        } else {
            throw new IOException("Unexpected response: " + line);
        }
        int i = line.indexOf(32);
        if (i >= 0) {
            r.data = line.substring(i + 1);
        }
        return r;
    }

    private Response multilineCommand(String cmd, int size) throws IOException {
        int b;
        Response r = this.simpleCommand(cmd);
        if (!r.ok) {
            return r;
        }
        SharedByteArrayOutputStream buf = new SharedByteArrayOutputStream(size);
        int lastb = 10;
        while ((b = this.input.read()) >= 0) {
            if (lastb == 10 && b == 46 && (b = this.input.read()) == 13) {
                this.input.read();
                break;
            }
            buf.write(b);
            if (this.debug) {
                this.out.write(b);
            }
            lastb = b;
        }
        if (b < 0) {
            throw new EOFException("EOF on socket");
        }
        r.bytes = buf.toStream();
        return r;
    }
}

