/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.jato.view.html;

import com.iplanet.jato.model.Model;
import com.iplanet.jato.view.BooleanDisplayField;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.DisplayFieldDescriptor;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.html.HtmlDisplayFieldBase;

public class CheckBox
extends HtmlDisplayFieldBase
implements BooleanDisplayField {
    private Object checkedValue;
    private Object uncheckedValue;

    public CheckBox(ContainerView parent, String name, Object checkedValue, Object uncheckedValue, boolean checked) {
        super(parent, parent.getDefaultModel(), name, name, null, null);
        this.setCheckedValue(checkedValue);
        this.setUncheckedValue(uncheckedValue);
        if (checked) {
            this.setValue(checkedValue, false);
        } else {
            this.setValue(uncheckedValue, false);
        }
    }

    public CheckBox(View parent, Model model, String name, Object checkedValue, Object uncheckedValue, boolean checked) {
        super(parent, model, name, name, null, null);
        this.setCheckedValue(checkedValue);
        this.setUncheckedValue(uncheckedValue);
        if (checked) {
            this.setValue(checkedValue, false);
        } else {
            this.setValue(uncheckedValue, false);
        }
    }

    public CheckBox(View parent, Model model, String name, String boundName, Object checkedValue, Object uncheckedValue, boolean checked, DisplayFieldDescriptor descriptor) {
        super(parent, model, name, boundName, null, descriptor);
        this.setCheckedValue(checkedValue);
        this.setUncheckedValue(uncheckedValue);
        if (checked) {
            this.setValue(checkedValue, false);
        } else {
            this.setValue(uncheckedValue, false);
        }
    }

    public boolean isChecked() {
        return this.getValue() != null && this.getValue().toString().equals(this.getCheckedValue());
    }

    public void setChecked(boolean value) {
        super.setValue(value ? this.getCheckedValue() : this.getUncheckedValue());
    }

    public void setValue(Object value) {
        this.setValue(value, true);
    }

    public void setValue(Object value, boolean overwrite) {
        if (value == null) {
            super.setValue(this.getUncheckedValue(), overwrite);
        } else if (value.equals(this.getCheckedValue()) || value.equals(this.getUncheckedValue())) {
            super.setValue(value, overwrite);
        } else {
            throw new IllegalArgumentException("Attempt to set Field [" + this.getName() + "]" + " to a value [" + value + "]" + " which is not equal to the checked value [" + this.getCheckedValue() + "]" + " or unchecked value [" + this.getUncheckedValue() + "]");
        }
    }

    public Object getValue() {
        Object value = super.getValue();
        if (value instanceof Boolean) {
            if (((Boolean)value).booleanValue()) {
                return this.getCheckedValue();
            }
            return this.getUncheckedValue();
        }
        return value;
    }

    public Object getCheckedValue() {
        return this.checkedValue;
    }

    public void setCheckedValue(Object value) {
        this.checkedValue = value;
    }

    public Object getUncheckedValue() {
        return this.uncheckedValue;
    }

    public void setUncheckedValue(Object value) {
        this.uncheckedValue = value;
    }

    public boolean booleanValue() {
        return this.isChecked();
    }

    public boolean getState() {
        return this.isChecked();
    }

    public Object getTrueValue() {
        return this.getCheckedValue();
    }

    public Object getFalseValue() {
        return this.getUncheckedValue();
    }
}

