/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.jato.view;

import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.ModelFieldBinding;
import com.iplanet.jato.model.ModelReference;
import com.iplanet.jato.model.SimpleModelReference;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.DisplayField;
import com.iplanet.jato.view.DisplayFieldDescriptor;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBase;

public class BasicDisplayField
extends ViewBase
implements DisplayField {
    private ModelReference modelReference;
    private ModelFieldBinding modelFieldBinding;
    private DisplayFieldDescriptor descriptor;

    public BasicDisplayField() {
    }

    public BasicDisplayField(View parent, String name) {
        super(parent, name);
        if (parent instanceof ContainerView) {
            this.modelReference = new SimpleModelReference(((ContainerView)parent).getDefaultModel());
        } else {
            this.modelFieldBinding = new LocalStorageModelFieldBinding();
        }
    }

    public BasicDisplayField(View parent, String name, ModelReference reference, ModelFieldBinding binding) {
        this(parent, name);
        this.modelReference = reference;
        this.modelFieldBinding = binding;
    }

    protected ModelReference getDefaultModelReference() {
        if (this.getParent() instanceof ContainerView) {
            return new SimpleModelReference(((ContainerView)this.getParent()).getDefaultModel());
        }
        return null;
    }

    public ModelReference getModelReference() {
        if (this.modelReference == null) {
            this.modelReference = this.getDefaultModelReference();
        }
        return this.modelReference;
    }

    public void setModelReference(ModelReference value) {
        this.modelReference = value;
    }

    protected ModelFieldBinding getDefaultModelFieldBinding() {
        return new DisplayFieldNameModelFieldBinding();
    }

    public ModelFieldBinding getModelFieldBinding() {
        if (this.modelFieldBinding == null) {
            this.modelFieldBinding = this.getDefaultModelFieldBinding();
        }
        return this.modelFieldBinding;
    }

    public void setModelFieldBinding(ModelFieldBinding value) {
        this.modelFieldBinding = value;
    }

    public DisplayFieldDescriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(DisplayFieldDescriptor value) {
        this.descriptor = value;
    }

    public String getRequestValue() {
        return RequestManager.getRequestContext().getRequest().getParameter(this.getQualifiedName());
    }

    public String[] getRequestValues() {
        return RequestManager.getRequestContext().getRequest().getParameterValues(this.getQualifiedName());
    }

    public Object getValue() {
        return this.getModelFieldBinding().getValue(this.getModelReference());
    }

    public void setValue(Object value) {
        this.getModelFieldBinding().setValue(this.getModelReference(), value);
    }

    public void setValue(Object value, boolean overwrite) {
        if (overwrite) {
            this.getModelFieldBinding().setValue(this.getModelReference(), value);
        } else if (this.getModelFieldBinding().getValue(this.getModelReference()) == null) {
            this.getModelFieldBinding().setValue(this.getModelReference(), value);
        }
    }

    public Object[] getValues() {
        return this.getModelFieldBinding().getValues(this.getModelReference());
    }

    public void setValues(Object[] values) {
        this.getModelFieldBinding().setValues(this.getModelReference(), values);
    }

    public void setValues(Object[] values, boolean overwrite) {
        if (overwrite) {
            this.getModelFieldBinding().setValues(this.getModelReference(), values);
        } else {
            Object[] v = this.getModelFieldBinding().getValues(this.getModelReference());
            if (v == null || v.length == 0) {
                this.getModelFieldBinding().setValues(this.getModelReference(), values);
            }
        }
    }

    public String stringValue() {
        Object o = this.getModelFieldBinding().getValue(this.getModelReference());
        return o != null ? o.toString() : "";
    }

    private static class LocalStorageModelFieldBinding
    extends ModelFieldBinding {
        private Object[] values;

        public Object getValue(ModelReference reference) {
            return this.values != null ? this.values[0] : null;
        }

        public void setValue(ModelReference reference, Object value) {
            this.values = new Object[]{value};
        }

        public Object[] getValues(ModelReference reference) {
            return this.values;
        }

        public void setValues(ModelReference reference, Object[] values) {
            this.values = values;
        }
    }

    private static class NoopModelFieldBinding
    extends ModelFieldBinding {
        public Object getValue(ModelReference reference) {
            return null;
        }

        public void setValue(ModelReference reference, Object value) {
        }

        public Object[] getValues(ModelReference reference) {
            return null;
        }

        public void setValues(ModelReference reference, Object[] values) {
        }
    }

    class DisplayFieldNameModelFieldBinding
    extends ModelFieldBinding {
        public DisplayFieldNameModelFieldBinding() {
            super(BasicDisplayField.this.getName());
        }
    }
}

