/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.jato.util;

public class ProfileTimer {
    private static InheritableThreadLocal timers = new InheritableThreadLocal();
    private int numInvocations = 0;
    private long startTime = 0L;
    private long stopTime = 0L;
    private long lastTime = 0L;
    private long totalTime = 0L;

    public synchronized void start() {
        this._start();
    }

    private void _start() {
        this.startTime = System.currentTimeMillis();
    }

    public synchronized long stop() {
        return this._stop();
    }

    private long _stop() {
        this.stopTime = System.currentTimeMillis();
        this.update(this.stopTime - this.startTime);
        return this.lastTime;
    }

    public synchronized long restart() {
        return this._restart();
    }

    private long _restart() {
        long result = this.stop();
        this.start();
        return result;
    }

    public synchronized void update(long interval) {
        this._update(interval);
    }

    private void _update(long interval) {
        ++this.numInvocations;
        this.lastTime = interval;
        this.totalTime += this.lastTime;
    }

    public long getLastTime() {
        return this._getLastTime();
    }

    private long _getLastTime() {
        return this.lastTime;
    }

    public long getTotalTime() {
        return this._getTotalTime();
    }

    private long _getTotalTime() {
        return this.totalTime;
    }

    public synchronized double getAverageTime(boolean reset) {
        return this._getAverageTime(reset);
    }

    private double _getAverageTime(boolean reset) {
        if (this.numInvocations == 0) {
            return 0.0;
        }
        if (reset) {
            double result = (double)this.totalTime / (double)this.numInvocations;
            this.reset();
            return result;
        }
        return (double)this.totalTime / (double)this.numInvocations;
    }

    public synchronized void reset() {
        this._reset();
    }

    private void _reset() {
        this.startTime = 0L;
        this.stopTime = 0L;
        this.numInvocations = 0;
        this.lastTime = 0L;
        this.totalTime = 0L;
    }

    public static ProfileTimer getThreadTimer() {
        ProfileTimer result = (ProfileTimer)timers.get();
        if (result == null) {
            result = new ProfileTimer();
            ProfileTimer.setThreadTimer(result);
        }
        return result;
    }

    public static void setThreadTimer(ProfileTimer timer) {
        timers.set(timer);
    }

    public static void threadStart() {
        ProfileTimer.getThreadTimer()._start();
    }

    public static long threadStop() {
        return ProfileTimer.getThreadTimer()._stop();
    }

    public static long threadRestart() {
        return ProfileTimer.getThreadTimer()._restart();
    }

    public static void threadUpdate(long interval) {
        ProfileTimer.getThreadTimer()._update(interval);
    }

    public static long getThreadLastTime() {
        return ProfileTimer.getThreadTimer()._getLastTime();
    }

    public static long getThreadTotalTime() {
        return ProfileTimer.getThreadTimer()._getTotalTime();
    }

    public static double getThreadAverageTime(boolean reset) {
        return ProfileTimer.getThreadTimer()._getAverageTime(reset);
    }

    public static void threadReset() {
        ProfileTimer.getThreadTimer()._reset();
    }
}

