/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.jato.taglib.html;

import com.iplanet.jato.taglib.AbstractVisualTag;
import com.iplanet.jato.util.HtmlUtil;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.iplanet.jato.view.BasicChoiceDisplayField;
import com.iplanet.jato.view.Choice;
import com.iplanet.jato.view.ChoiceDisplayField;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.html.HtmlDisplayField;
import com.iplanet.jato.view.html.Option;
import com.iplanet.jato.view.html.SelectableGroup;
import java.util.Arrays;
import java.util.HashSet;
import javax.servlet.jsp.JspException;

public abstract class SelectTag
extends AbstractVisualTag {
    protected abstract void checkChildType(View var1) throws JspException;

    protected void generateTagContent(NonSyncStringBuffer buffer) throws JspException {
        ContainerView parentContainer = this.getParentContainerView();
        View child = parentContainer.getChild(this.getName());
        this.checkChildType(child);
        if (child instanceof SelectableGroup) {
            this.doEndTagSelectableGroup((SelectableGroup)child, buffer);
        } else if (child instanceof ChoiceDisplayField) {
            this.doEndTagChoiceDisplayField((ChoiceDisplayField)child, buffer);
        } else {
            throw new JspException("Unknown child type: " + child);
        }
    }

    protected void doEndTagChoiceDisplayField(ChoiceDisplayField field, NonSyncStringBuffer buffer) throws JspException {
        boolean noneSelected = true;
        Choice[] choices = field.getChoices();
        if (choices == null) {
            choices = new Choice[]{};
        }
        Choice[] selectedChoices = BasicChoiceDisplayField.getSelectedChoices(field);
        HashSet<Choice> choiceSet = new HashSet<Choice>();
        if (selectedChoices != null) {
            choiceSet.addAll(Arrays.asList(selectedChoices));
        }
        int i = 0;
        while (i < choices.length) {
            boolean isSelected = choiceSet.contains(choices[i]);
            if (isSelected) {
                noneSelected = false;
            }
            buffer.append("\n<option value=\"").append(choices[i].getValue() == null ? "" : HtmlUtil.escapeQuotes(choices[i].getValue().toString())).append("\"");
            if (isSelected) {
                buffer.append(" selected");
            }
            buffer.append(">").append(choices[i].getLabel()).append("</option>");
            ++i;
        }
        NonSyncStringBuffer buffer2 = new NonSyncStringBuffer("<select name=\"", 32);
        buffer2.append(field.getQualifiedName()).append("\"");
        if (this.getSize() != null) {
            buffer2.append(" size=\"").append(this.getSize()).append("\"");
        }
        if (this.getMultiple() == null) {
            if (field.getAllowMultipleValues()) {
                buffer2.append(" multiple");
            }
        } else if (this.isMultiple()) {
            buffer2.append(" multiple");
        }
        this.appendCommonHtmlAttributes(buffer2);
        this.appendJavaScriptAttributes(buffer2);
        this.appendStyleAttributes(buffer2);
        if (field instanceof HtmlDisplayField) {
            this.appendExtraHtml((HtmlDisplayField)((Object)field), buffer2);
        }
        buffer2.append(">");
        this.appendNullChoiceHtmlString(buffer2, field.getNullChoiceLabel(), noneSelected);
        buffer.insert(0, buffer2).append("\n</select>");
    }

    protected void appendNullChoiceHtmlString(NonSyncStringBuffer buffer, Object nullChoiceLabel, boolean nullChoiceSelected) throws JspException {
        String label;
        if (nullChoiceLabel != null && (label = nullChoiceLabel.toString()).length() > 0) {
            buffer.append("\n<option value=\"\"");
            if (nullChoiceSelected) {
                buffer.append(" selected");
            }
            buffer.append(">").append(label).append("</option>");
        }
    }

    protected void doEndTagSelectableGroup(SelectableGroup field, NonSyncStringBuffer buffer) throws JspException {
        boolean noneSelected = true;
        Option[] options = field.getOptions().toOptionArray();
        int i = 0;
        while (i < options.length) {
            boolean isSelected = field.isSelected(options[i].getValue());
            if (isSelected) {
                noneSelected = false;
            }
            buffer.append("\n<option value=\"").append(HtmlUtil.escapeQuotes(options[i].getValue())).append("\"");
            if (isSelected) {
                buffer.append(" selected");
            }
            buffer.append(">").append(options[i].getLabel()).append("</option>");
            ++i;
        }
        NonSyncStringBuffer buffer2 = new NonSyncStringBuffer("<select name=\"", 32);
        buffer2.append(field.getQualifiedName()).append("\"");
        if (this.getSize() != null) {
            buffer2.append(" size=\"").append(this.getSize()).append("\"");
        }
        if (this.getMultiple() == null) {
            if (field.isMultiSelect()) {
                buffer2.append(" multiple");
            }
        } else if (this.isMultiple()) {
            buffer2.append(" multiple");
        }
        this.appendCommonHtmlAttributes(buffer2);
        this.appendJavaScriptAttributes(buffer2);
        this.appendStyleAttributes(buffer2);
        this.appendExtraHtml(field, buffer2);
        buffer2.append(">").append(this.getNoneSelectedHtmlString(field, noneSelected));
        buffer.insert(0, buffer2).append("\n</select>");
    }

    protected boolean isSelected(Object[] values, String value) {
        int i = 0;
        while (i < values.length) {
            if (values[i] != null && values[i].toString().equals(value)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected String getNoneSelectedHtmlString(SelectableGroup field, boolean noneSelected) throws JspException {
        NonSyncStringBuffer buffer = new NonSyncStringBuffer(64);
        if (field.getLabelForNoneSelected() != null && field.getLabelForNoneSelected().length() > 0) {
            buffer.append("\n<option value=\"").append("").append("\"");
            if (noneSelected) {
                buffer.append(" selected");
            }
            buffer.append(">").append(field.getLabelForNoneSelected()).append("</option>");
        }
        return buffer.toString();
    }

    protected String getSize() {
        return (String)this.getValue("size");
    }

    protected void setSize(String value) {
        this.setValue("size", value);
    }

    protected String getMultiple() {
        return (String)this.getValue("multiple");
    }

    protected void setMultiple(String value) {
        this.setValue("multiple", value);
    }

    protected boolean isMultiple() throws JspException {
        boolean isMultiple = false;
        if (this.getMultiple() != null) {
            isMultiple = this.isTrue(this.getMultiple());
        }
        return isMultiple;
    }
}

