/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.jato.model.object;

import com.iplanet.jato.model.object.ObjectPath;
import com.iplanet.jato.util.StringTokenizer2;

public class Path
implements ObjectPath {
    private String _path = "/";
    private boolean _isroot = true;

    public Path(String path) {
        if (path != null && path.trim().length() != 0) {
            this._path = Path.eliminateMultipleSeparators(path.trim());
            this._path = path.trim();
            this._isroot = this._path.equals("/");
            if (!this.isRoot() && this._path.endsWith("/")) {
                this._path = this._path.substring(0, this._path.length() - 1);
            }
        }
    }

    public static String eliminateMultipleSeparators(String value) {
        if (value.indexOf("//") == -1) {
            return value;
        }
        char[] buf = value.toCharArray();
        int len = buf.length;
        int newlen = 0;
        int cnt = 0;
        while (cnt < len) {
            buf[newlen] = buf[cnt];
            if (buf[cnt] == '/') {
                ++cnt;
                while (cnt < len && buf[cnt] == '/') {
                    ++cnt;
                }
                --cnt;
            }
            ++cnt;
            ++newlen;
        }
        return new String(buf, 0, newlen);
    }

    public ObjectPath getParent() {
        if (this.isRoot()) {
            return null;
        }
        return new Path(this._path.substring(0, this._path.lastIndexOf("/")));
    }

    public String[] elements() {
        StringTokenizer2 temp = new StringTokenizer2(this._path, "/");
        int len = temp.countTokens();
        String[] results = new String[len];
        int count = 0;
        while (count < len) {
            results[count] = temp.nextToken();
            ++count;
        }
        return results;
    }

    public String lastElement() {
        if (this.isRoot()) {
            return null;
        }
        return this._path.substring(this._path.lastIndexOf("/") + 1);
    }

    public boolean isRoot() {
        return this._isroot;
    }

    public boolean isIndexed() {
        return this._path.endsWith("[]");
    }

    public String toString() {
        return this._path;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) ? true : obj instanceof Path && this._path.equals(((Path)obj).toString());
    }
}

