/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.jato.model;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestParticipant;
import com.iplanet.jato.model.Model;
import com.iplanet.jato.model.ModelFieldGroup;
import com.iplanet.jato.model.ResourceBundleFieldDescriptor;
import java.util.Locale;
import java.util.ResourceBundle;

public class ResourceBundleModel
implements Model,
RequestParticipant {
    private String name;
    private ResourceBundle bundle;
    private String bundleName;
    private Locale locale;
    private transient ModelFieldGroup fieldGroup;
    private transient RequestContext requestContext;

    public ResourceBundleModel() {
    }

    public ResourceBundleModel(ResourceBundle bundle) {
        if (bundle == null) {
            throw new IllegalArgumentException("Parameter \"bundle\" cannot be null");
        }
        this.bundle = bundle;
    }

    public ResourceBundleModel(String bundleName) {
        if (bundleName == null) {
            throw new IllegalArgumentException("Parameter \"bundleName\" cannot be null");
        }
        this.loadBundle(bundleName);
    }

    public ResourceBundleModel(String bundleName, Locale locale) {
        if (bundleName == null) {
            throw new IllegalArgumentException("Parameter \"bundleName\" cannot be null");
        }
        if (locale == null) {
            throw new IllegalArgumentException("Parameter \"locale\" cannot be null");
        }
        this.loadBundle(bundleName, locale);
    }

    public RequestContext getRequestContext() {
        return this.requestContext;
    }

    public void setRequestContext(RequestContext value) {
        this.requestContext = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public String getBundleName() {
        return this.bundleName;
    }

    public void setBundleName(String value) {
        this.bundleName = value;
        this.loadBundle();
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale value) {
        this.locale = value;
        this.loadBundle();
    }

    public void loadBundle(String bundleName) {
        if (bundleName == null) {
            throw new IllegalArgumentException("Parameter \"bundleName\" cannot be null");
        }
        this.locale = null;
        this.bundleName = bundleName;
        this.loadBundle();
    }

    public void loadBundle(String bundleName, Locale locale) {
        if (bundleName == null) {
            throw new IllegalArgumentException("Parameter \"bundleName\" cannot be null");
        }
        this.locale = locale;
        this.bundleName = bundleName;
        this.loadBundle();
    }

    public void loadBundle() {
        this.bundle = this.getLocale() == null && this.getBundleName() != null ? ResourceBundle.getBundle(this.getBundleName()) : ResourceBundle.getBundle(this.getBundleName(), this.getLocale());
    }

    public ResourceBundle getResourceBundle() {
        if (null == this.bundle) {
            this.loadBundle();
        }
        return this.bundle;
    }

    public void setResourceBundle(ResourceBundle value) {
        if (this.bundle == null) {
            throw new IllegalArgumentException("Parameter \"bundle\" cannot be null");
        }
        this.bundle = value;
    }

    protected String validateName(String name) {
        ResourceBundleFieldDescriptor field;
        if (null == name || name.trim().length() == 0) {
            throw new IllegalArgumentException("The 'name' parameter cannot be null or blank");
        }
        ResourceBundleFieldDescriptor resourceBundleFieldDescriptor = field = null != this.getFieldGroup() ? (ResourceBundleFieldDescriptor)this.getFieldGroup().getFieldDescriptor(name) : null;
        if (null == field || null == field.getResourceName() || field.getResourceName().trim().length() == 0) {
            return name;
        }
        return field.getResourceName();
    }

    public Object getValue(String name) {
        name = this.validateName(name);
        Object result = null;
        if (this.getResourceBundle() != null) {
            result = this.getResourceBundle().getObject(name);
        }
        return result;
    }

    public void setValue(String name, Object value) {
    }

    public Object[] getValues(String name) {
        Object result = this.getValue(name);
        if (result != null) {
            if (result.getClass().isArray()) {
                return (Object[])result;
            }
            return new Object[]{result};
        }
        return new Object[0];
    }

    public void setValues(String name, Object[] value) {
    }

    public void setFieldGroup(ModelFieldGroup group) {
        this.fieldGroup = group;
    }

    public ModelFieldGroup getFieldGroup() {
        return this.fieldGroup;
    }
}

