/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.jato;

import com.iplanet.jato.CompleteRequestException;
import com.iplanet.jato.Log;
import com.iplanet.jato.NavigationException;
import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestContextImpl;
import com.iplanet.jato.RequestHandler;
import com.iplanet.jato.RequestManager;
import com.iplanet.jato.ViewBeanManager;
import com.iplanet.jato.taglib.TagBase;
import com.iplanet.jato.util.RootCauseException;
import com.iplanet.jato.util.StringTokenizer2;
import com.iplanet.jato.util.TypeConverter;
import com.iplanet.jato.util.WrapperException;
import com.iplanet.jato.util.WrapperRuntimeException;
import com.iplanet.jato.view.ViewBase;
import com.iplanet.jato.view.ViewBean;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ApplicationServletBase
extends HttpServlet {
    public static final String RESERVED_PARAMETER_NAME_PREFIX = "jato";
    public static final String HANDLING_SERVLET_ATTRIBUTE_NAME = "jato.handlingServlet";
    public static final String REQUEST_CONTEXT_ATTRIBUTE_NAME = "jato.requestContext";
    public static final String PARAM_DEBUG = "jato.debug";
    public static final String PARAM_HANDLER_BEAN = "page";
    public static final String MESSAGE_AREA_PREFIX = "<hr size=\"1\"><b><font face=\"Arial, Helvetica, sans-serif\">Application Messages:</font></b><pre>";
    public static final String MESSAGE_AREA_POSTFIX = "</pre>";
    public static final String SHOW_MESSAGE_BUFFER_ATTRIBUTE_NAME = "jato.showMessages";
    public static final String GENERATE_UNIQUE_URLS = "jato.generateUniqueURLs";
    static boolean OPTION_USE_FALLBACK_PAGE_BEAN_NAME;
    private static String MESSAGE_KEY_PREFIX;
    private static String MESSAGE_RESOURCE_BUNDLE_NAME;
    private static String MESSAGE_RESOURCE_BUNDLE_INIT_FAILURE;
    private static final String ECHO_TO_SYSTEM_OUT = "echoLogToSystemOut";
    private static final String LOG_MESSAGE_PREFIX = "logMessagePrefix";
    private static final String ENABLED_LOG_LEVELS = "enabledLogLevels";
    public static final String APPLICATION_ERROR_MESSAGE_I18N = "<html>\n<head>\n<title>{0}</title>\n</head>\n<body bgcolor=\"#FFFFFF\" text=\"#000000\">\n<h2><font face=\"Arial, Helvetica, sans-serif\">{0}</font></h2>\n<h4><font face=\"Arial, Helvetica, sans-serif\">{1}</font></h4>\n{2}\n<hr size=\"1\">\n<font size=\"1\" face=\"Arial, Helvetica, sans-serif\"><i>{3} {4}</i></font>\n\n<!-- {5} -->\n<!--\n{6}-->\n\n</body>\n</html>";
    public static final String DEVELOPER_EVENT_OVERRIDE_HELP_MESSAGE_I18N = "\n<hr size=\"1\">\n<font face=\"Arial, Helvetica, sans-serif\" size=\"2\">{0}</font>\n<ul>\n <li><font face=\"Arial, Helvetica, sans-serif\" size=\"2\">{1}</font></li>\n <li><font face=\"Arial, Helvetica, sans-serif\" size=\"2\">{2}</font></li>\n</ul>";
    private static Map FALLBACK_MESSAGES;
    private String servletName;
    private String defaultHandlerName;
    private String moduleURL;
    private boolean outputDebug = false;
    private boolean showMessageBuffer = true;
    private ResourceBundle msgRb = null;
    private boolean isMessageResourceBundleMissing = true;
    private boolean showMissingModuleURLWarning = true;
    private boolean enforceStrictSessionTimeout = false;
    private String logPrefix;
    private boolean allowShortViewBeanNames = false;
    static /* synthetic */ Class class$com$iplanet$jato$Log;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(ServletConfig config) throws ServletException {
        String message;
        super.init(config);
        this.servletName = config.getServletName();
        Class clazz = class$com$iplanet$jato$Log == null ? (class$com$iplanet$jato$Log = ApplicationServletBase.class$("com.iplanet.jato.Log")) : class$com$iplanet$jato$Log;
        synchronized (clazz) {
            if (Log.getServletContext() == null) {
                Log.setServletContext(this.getServletContext());
            }
        }
        this.setGlobalServletProperties(config.getServletContext());
        this.setLocalServletProperties(config);
        if (this.getModuleURL() != null) {
            config.getServletContext().setAttribute(ApplicationServletBase.getModuleURLParameterName(((Object)((Object)this)).getClass().getName()), (Object)this.getModuleURL());
        } else if (this.getShowMissingModuleURLWarning()) {
            message = this.getLocalizedMessage(MESSAGE_KEY_PREFIX + "noModuleURL");
            message = MessageFormat.format(message, ((Object)((Object)this)).getClass().getName());
            Log.log(32, this.getLogPrefix() + message);
        }
        try {
            this.msgRb = ResourceBundle.getBundle(MESSAGE_RESOURCE_BUNDLE_NAME);
            this.isMessageResourceBundleMissing = false;
        }
        catch (MissingResourceException e) {
            Log.log(32, this.getLogPrefix() + MESSAGE_RESOURCE_BUNDLE_INIT_FAILURE, e);
            System.err.println(MESSAGE_RESOURCE_BUNDLE_INIT_FAILURE);
            e.printStackTrace(System.err);
        }
        if (!this.getEnforceStrictSessionTimeout()) {
            message = this.getLocalizedMessage(MESSAGE_KEY_PREFIX + "sessionTimeout_lenient3");
            message = MessageFormat.format(message, this.getServletName());
            Log.log(32, this.getLogPrefix() + message);
        }
    }

    private void setGlobalServletProperties(ServletContext context) {
        try {
            Enumeration e = context.getInitParameterNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                if (!this.propertyMatches(name, ECHO_TO_SYSTEM_OUT)) continue;
                this.setProperty(name, context.getInitParameter(name));
                break;
            }
            Enumeration e2 = context.getInitParameterNames();
            while (e2.hasMoreElements()) {
                String name = (String)e2.nextElement();
                if (!this.propertyMatches(name, LOG_MESSAGE_PREFIX)) continue;
                this.setProperty(name, context.getInitParameter(name));
                break;
            }
            Enumeration e3 = context.getInitParameterNames();
            while (e3.hasMoreElements()) {
                String name = (String)e3.nextElement();
                if (!this.propertyMatches(name, ENABLED_LOG_LEVELS)) continue;
                this.setProperty(name, context.getInitParameter(name));
                break;
            }
            Enumeration e4 = context.getInitParameterNames();
            while (e4.hasMoreElements()) {
                String name = (String)e4.nextElement();
                if (this.propertyMatches(name, ENABLED_LOG_LEVELS) || this.propertyMatches(name, LOG_MESSAGE_PREFIX) || this.propertyMatches(name, ECHO_TO_SYSTEM_OUT) || !this.propertyApplies(name)) continue;
                this.setProperty(name, context.getInitParameter(name));
            }
        }
        catch (IntrospectionException e) {
            Log.log(64, this.getLogPrefix() + "Exception setting global servlet properties by " + "introspection", e);
        }
    }

    private void setLocalServletProperties(ServletConfig config) {
        try {
            Enumeration e = config.getInitParameterNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                if (!this.propertyMatches(name, ECHO_TO_SYSTEM_OUT)) continue;
                this.setProperty(name, config.getInitParameter(name));
                break;
            }
            Enumeration e2 = config.getInitParameterNames();
            while (e2.hasMoreElements()) {
                String name = (String)e2.nextElement();
                if (!this.propertyMatches(name, LOG_MESSAGE_PREFIX)) continue;
                this.setProperty(name, config.getInitParameter(name));
                break;
            }
            Enumeration e3 = config.getInitParameterNames();
            while (e3.hasMoreElements()) {
                String name = (String)e3.nextElement();
                if (!this.propertyMatches(name, ENABLED_LOG_LEVELS)) continue;
                this.setProperty(name, config.getInitParameter(name));
                break;
            }
            Enumeration e4 = config.getInitParameterNames();
            while (e4.hasMoreElements()) {
                String name = (String)e4.nextElement();
                if (!this.propertyApplies(name)) {
                    Log.log(8, this.getLogPrefix() + "Servlet init param \"" + name + "\" does not apply and will be ignored");
                    continue;
                }
                if (this.propertyMatches(name, ENABLED_LOG_LEVELS) || this.propertyMatches(name, LOG_MESSAGE_PREFIX) || this.propertyMatches(name, ECHO_TO_SYSTEM_OUT)) continue;
                this.setProperty(name, config.getInitParameter(name));
            }
        }
        catch (IntrospectionException e) {
            Log.log(64, this.getLogPrefix() + "Exception setting local " + "servlet properties by introspection", e);
        }
    }

    protected void setProperty(String fullPropertyName, Object propertyValue) throws IntrospectionException {
        if (!this.propertyApplies(fullPropertyName)) {
            Log.log(8, this.getLogPrefix() + "Parameter \"" + fullPropertyName + "\" does not apply");
            return;
        }
        String propertyName = this.getBeanPropertyName(fullPropertyName);
        Map propertyDescriptors = this.catalogPropertyDescriptors();
        PropertyDescriptor desc = (PropertyDescriptor)propertyDescriptors.get(propertyName);
        if (desc != null) {
            Method mutator = desc.getWriteMethod();
            if (mutator != null) {
                Object value = null;
                if (propertyValue != null) {
                    value = TypeConverter.asType(desc.getPropertyType(), propertyValue);
                }
                if (value != null) {
                    try {
                        Log.log(8, this.getLogPrefix() + "Setting parameter \"" + fullPropertyName + "\" = \"" + value + "\" (" + value.getClass().getName() + ")");
                        mutator.invoke((Object)this, value);
                    }
                    catch (Exception ex) {
                        String message = this.getLogPrefix() + "Exception setting servlet property \"" + propertyName + "\": " + ex;
                        System.err.println(message);
                        ex.printStackTrace();
                        Log.log(message, ex);
                    }
                }
            } else {
                Log.log(8, this.getLogPrefix() + "Servlet does not have a writable property \"" + propertyName + "\"; property \"" + fullPropertyName + "\" not set");
            }
        } else {
            Log.log(8, this.getLogPrefix() + "Servlet does not have a property called \"" + propertyName + "\"; property \"" + fullPropertyName + "\" ignored");
        }
    }

    private boolean propertyApplies(String name) {
        if (name.startsWith(RESERVED_PARAMETER_NAME_PREFIX)) {
            int endIndex;
            int startIndex = name.indexOf(":");
            if (startIndex == (endIndex = name.lastIndexOf(":"))) {
                return true;
            }
            String classSpec = name.substring(startIndex + 1, endIndex);
            int wildcardIndex = classSpec.indexOf("*");
            if (wildcardIndex != -1) {
                classSpec = classSpec.substring(0, wildcardIndex);
                return ((Object)((Object)this)).getClass().getName().startsWith(classSpec);
            }
            return name.substring(startIndex + 1, endIndex).equals(((Object)((Object)this)).getClass().getName());
        }
        return false;
    }

    private boolean propertyMatches(String name, String propertyName) {
        boolean result = false;
        if (name.startsWith(RESERVED_PARAMETER_NAME_PREFIX)) {
            int startIndex = name.indexOf(":");
            int endIndex = name.lastIndexOf(":");
            result = name.length() >= endIndex + 1 && name.substring(endIndex + 1).equals(propertyName);
        }
        return result;
    }

    private String getBeanPropertyName(String propertyName) {
        int index = propertyName.lastIndexOf(":");
        if (index != -1) {
            return propertyName.substring(index + 1);
        }
        return propertyName;
    }

    private Map catalogPropertyDescriptors() throws IntrospectionException {
        HashMap<String, PropertyDescriptor> result = new HashMap<String, PropertyDescriptor>();
        BeanInfo beanInfo = Introspector.getBeanInfo(((Object)((Object)this)).getClass());
        PropertyDescriptor[] descriptors = beanInfo.getPropertyDescriptors();
        int i = 0;
        while (i < descriptors.length) {
            result.put(descriptors[i].getName(), descriptors[i]);
            ++i;
        }
        return result;
    }

    private String getLogPrefix() {
        if (this.logPrefix == null) {
            this.logPrefix = "Servlet[" + this.getServletName() + "@" + ((Object)((Object)this)).hashCode() + "]: ";
        }
        return this.logPrefix;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(this.getPageName(request), request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(this.getPageName(request), request, response);
    }

    protected String getPageName(HttpServletRequest request) {
        String pageName = null;
        String pathInfo = request.getPathInfo();
        if (pathInfo != null) {
            pageName = this.parsePathInfo(pathInfo);
        }
        if (pageName == null && OPTION_USE_FALLBACK_PAGE_BEAN_NAME) {
            pageName = request.getParameter(PARAM_HANDLER_BEAN);
        }
        return pageName;
    }

    protected String parsePathInfo(String pathInfo) {
        int slashEndIndex;
        int semiEndIndex;
        int startIndex = pathInfo.indexOf("/") + 1;
        if (startIndex == 0) {
            return null;
        }
        int dotEndIndex = pathInfo.indexOf(".", startIndex);
        if (dotEndIndex == -1) {
            dotEndIndex = Integer.MAX_VALUE;
        }
        if ((semiEndIndex = pathInfo.indexOf(";", startIndex)) == -1) {
            semiEndIndex = Integer.MAX_VALUE;
        }
        if ((slashEndIndex = pathInfo.indexOf("/", startIndex)) == -1) {
            slashEndIndex = Integer.MAX_VALUE;
        }
        int endIndex = Math.min(Math.min(dotEndIndex, semiEndIndex), slashEndIndex);
        String pageName = null;
        pageName = endIndex == Integer.MAX_VALUE ? pathInfo.substring(startIndex) : pathInfo.substring(startIndex, endIndex);
        if (pageName.trim().length() == 0) {
            pageName = null;
        }
        return pageName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processRequest(String pageName, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block11: {
            RequestContext requestContext = null;
            try {
                try {
                    request.setAttribute(HANDLING_SERVLET_ATTRIBUTE_NAME, (Object)this);
                    requestContext = this.createRequestContext(request, response);
                    request.setAttribute(REQUEST_CONTEXT_ATTRIBUTE_NAME, (Object)requestContext);
                    this.initializeRequestContext(requestContext);
                    if (this.isShowMessageBuffer()) {
                        request.setAttribute(SHOW_MESSAGE_BUFFER_ATTRIBUTE_NAME, (Object)new Boolean(true));
                    }
                    RequestManager.setRequestContext(requestContext);
                    this.fireBeforeRequestEvent(requestContext);
                    this.addResponseHeaders(requestContext);
                    if (pageName == null && (pageName = this.getDefaultHandlerName(request)) == null) {
                        this.fireRequestHandlerNotSpecifiedEvent(requestContext);
                    }
                    this.fireSessionEvents(requestContext);
                    ViewBean viewBean = this.getViewBeanInstance(pageName, requestContext);
                    try {
                        this.dispatchRequest(viewBean, requestContext);
                    }
                    catch (NavigationException e) {
                        if (e.getRootCause() instanceof IOException) {
                            throw (IOException)e.getRootCause();
                        }
                        if (e.getRootCause() instanceof ServletException) {
                            throw (ServletException)e.getRootCause();
                        }
                        throw e;
                    }
                    Object var8_9 = null;
                }
                catch (CompleteRequestException e) {
                    Object var8_10 = null;
                    this.notifyRequestCompletionListeners(requestContext);
                    this.fireAfterRequestEvent(requestContext);
                    break block11;
                }
                catch (Exception e) {
                    Log.log(64, "Uncaught application exception", e);
                    this.fireUncaughtException(requestContext, e);
                    Object var8_11 = null;
                    this.notifyRequestCompletionListeners(requestContext);
                    this.fireAfterRequestEvent(requestContext);
                }
                this.notifyRequestCompletionListeners(requestContext);
                this.fireAfterRequestEvent(requestContext);
            }
            catch (Throwable throwable) {
                Object var8_12 = null;
                this.notifyRequestCompletionListeners(requestContext);
                this.fireAfterRequestEvent(requestContext);
                throw throwable;
            }
        }
    }

    protected String getDefaultHandlerName(HttpServletRequest request) {
        return this.defaultHandlerName;
    }

    public void setDefaultHandlerName(String value) {
        this.defaultHandlerName = value;
    }

    protected void addResponseHeaders(RequestContext requestContext) {
        requestContext.getResponse().addHeader("Cache-Control", "private");
    }

    protected RequestContext createRequestContext(HttpServletRequest request, HttpServletResponse response) {
        RequestContextImpl result = new RequestContextImpl(this.getServletName(), this.getServletContext(), request, response);
        ViewBeanManager manager = new ViewBeanManager(result, ApplicationServletBase.getPackageName(((Object)((Object)this)).getClass().getName()));
        result.setViewBeanManager(manager);
        return result;
    }

    protected void initializeRequestContext(RequestContext requestContext) {
    }

    public void notifyRequestCompletionListeners(RequestContext requestContext) {
        if (requestContext instanceof RequestContextImpl) {
            ((RequestContextImpl)requestContext).notifyRequestCompletionListeners();
        }
    }

    protected void fireSessionEvents(RequestContext requestContext) throws ServletException {
        HttpServletRequest request = requestContext.getRequest();
        String requestedSessionID = request.getRequestedSessionId();
        if (this.isNewSession(requestContext)) {
            this.fireNewSessionEvent(requestContext);
        }
        if (this.isSessionTimedOut(requestContext, requestedSessionID)) {
            this.fireSessionTimeoutEvent(requestContext);
        }
    }

    protected boolean isNewSession(RequestContext requestContext) {
        HttpServletRequest request = requestContext.getRequest();
        return !request.isRequestedSessionIdValid();
    }

    protected boolean isSessionTimedOut(RequestContext requestContext, String requestedSessionID) {
        HttpServletRequest request = requestContext.getRequest();
        return requestedSessionID != null && request.getSession().isNew();
    }

    protected ViewBean getViewBeanInstance(String pageName, RequestContext requestContext) throws ServletException {
        ViewBean viewBean = null;
        try {
            viewBean = requestContext.getViewBeanManager().getLocalViewBean(pageName);
        }
        catch (ClassNotFoundException e) {
            this.fireRequestHandlerNotFoundEvent(requestContext, pageName);
        }
        this.fireInitializeHandlerEvent(requestContext, viewBean);
        requestContext.getViewBeanManager().registerInstance(viewBean);
        return viewBean;
    }

    protected void dispatchRequest(ViewBean viewBean, RequestContext requestContext) throws Exception {
        if (viewBean == null) {
            throw new ServletException("Invalid request - handler view bean == null");
        }
        if (!viewBean.invokeRequestHandler()) {
            if (requestContext.getRequest().getParameter("jato.pageSession") == null) {
                viewBean.forwardTo(requestContext);
            } else {
                throw new ServletException("The request was not handled by the specified handler \"" + viewBean.toString() + "\"");
            }
        }
    }

    protected void outputServletErrorMessage(RequestContext requestContext, int statusCode, String message, String detail, Throwable e) throws ServletException {
        this.getServletContext().log("Application Error", e);
        if (requestContext.getResponse().isCommitted()) {
            return;
        }
        requestContext.getResponse().reset();
        requestContext.getResponse().setStatus(statusCode);
        try {
            StringWriter stringWriter = new StringWriter(1024);
            PrintWriter printWriter = new PrintWriter(stringWriter);
            Throwable currentException = e;
            boolean skipStackTrace = false;
            while (currentException != null) {
                Throwable rootCause;
                if (!skipStackTrace) {
                    currentException.printStackTrace(printWriter);
                }
                if (currentException instanceof ServletException) {
                    skipStackTrace = false;
                    rootCause = ((ServletException)currentException).getRootCause();
                    if (rootCause != null) {
                        printWriter.println("\nRoot cause:");
                    }
                    currentException = rootCause;
                    continue;
                }
                if (currentException instanceof RootCauseException) {
                    rootCause = ((RootCauseException)((Object)currentException)).getRootCause();
                    boolean bl = skipStackTrace = currentException instanceof WrapperRuntimeException || currentException instanceof WrapperException;
                    if (rootCause != null && !skipStackTrace) {
                        printWriter.println("\nRoot cause:");
                    }
                    currentException = rootCause;
                    continue;
                }
                currentException = null;
            }
            printWriter.flush();
            String errorHtml = this.prepareServletErrorMessage(message, detail, stringWriter);
            PrintWriter writer = requestContext.getResponse().getWriter();
            writer.println(errorHtml);
            writer.flush();
        }
        catch (IOException ex) {
            throw new ServletException("Error writing servlet error message", e);
        }
    }

    protected void fireNewSessionEvent(RequestContext requestContext) throws ServletException {
        this.onNewSession(requestContext);
    }

    protected void fireSessionTimeoutEvent(RequestContext requestContext) throws ServletException {
        this.onSessionTimeout(requestContext);
    }

    protected void fireBeforeRequestEvent(RequestContext requestContext) throws ServletException {
        this.onBeforeRequest(requestContext);
    }

    protected void fireRequestHandlerNotSpecifiedEvent(RequestContext requestContext) throws ServletException {
        this.onRequestHandlerNotSpecified(requestContext);
    }

    protected void fireRequestHandlerNotFoundEvent(RequestContext requestContext, String handlerName) throws ServletException {
        this.onRequestHandlerNotFound(requestContext, handlerName);
    }

    protected void fireInitializeHandlerEvent(RequestContext requestContext, RequestHandler requestHandler) throws ServletException {
        this.onInitializeHandler(requestContext, requestHandler);
    }

    protected final void fireAfterRequestEvent(RequestContext requestContext) {
        this.onAfterRequest(requestContext);
    }

    protected final void fireUncaughtException(RequestContext requestContext, Exception e) throws ServletException, IOException {
        this.onUncaughtException(requestContext, e);
    }

    protected void onNewSession(RequestContext requestContext) throws ServletException {
    }

    protected void onSessionTimeout(RequestContext requestContext) throws ServletException {
        if (this.getEnforceStrictSessionTimeout()) {
            requestContext.getRequest().getSession().invalidate();
            String devMessage = this.prepareEventOverrideMessage("onSessionTimeout()");
            this.outputServletErrorMessage(requestContext, 500, this.getLocalizedMessage(MESSAGE_KEY_PREFIX + "sessionTimeout"), devMessage, (Throwable)new ServletException("This session has timed out"));
            throw new CompleteRequestException();
        }
        String message1 = this.getLocalizedMessage(MESSAGE_KEY_PREFIX + "sessionTimeout_lenient");
        String message2 = this.getLocalizedMessage(MESSAGE_KEY_PREFIX + "sessionTimeout_lenient2");
        requestContext.getMessageWriter().println(message1);
        requestContext.getMessageWriter().println(message2);
        Log.log(message1);
        Log.log(message2);
    }

    protected void onBeforeRequest(RequestContext requestContext) throws ServletException {
    }

    protected void onRequestHandlerNotSpecified(RequestContext requestContext) throws ServletException {
        String devMessage = this.prepareEventOverrideMessage("onRequestHandlerNotSpecified()");
        this.outputServletErrorMessage(requestContext, 500, this.getLocalizedMessage(MESSAGE_KEY_PREFIX + "unspecifiedRequestHandler"), devMessage, (Throwable)new ServletException("Request handler not specified"));
        throw new CompleteRequestException();
    }

    protected void onRequestHandlerNotFound(RequestContext requestContext, String handlerName) throws ServletException {
        String errMessage = MessageFormat.format(this.getLocalizedMessage(MESSAGE_KEY_PREFIX + "unfoundRequestHandler"), handlerName);
        String devMessage = this.prepareEventOverrideMessage("onRequestHandlerNotFound()");
        this.outputServletErrorMessage(requestContext, 404, errMessage, devMessage, (Throwable)new ServletException("Invalid request - request handler \"" + handlerName + "\" not found"));
        throw new CompleteRequestException();
    }

    protected void onInitializeHandler(RequestContext requestContext, RequestHandler requestHandler) throws ServletException {
    }

    protected void onAfterRequest(RequestContext requestContext) {
    }

    protected void onUncaughtException(RequestContext requestContext, Exception e) throws ServletException, IOException {
        if (requestContext.getResponse().isCommitted()) {
            if (e instanceof ServletException) {
                throw (ServletException)e;
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new ServletException("Uncaught exception", (Throwable)e);
        }
        String devMessage = this.prepareEventOverrideMessage("onUncaughtException()");
        this.outputServletErrorMessage(requestContext, 500, e.toString(), devMessage, e);
    }

    protected final void onNewSession(HttpServletRequest request, HttpServletResponse response) throws ServletException {
    }

    protected final void onSessionTimeout(HttpServletRequest request, HttpServletResponse response) throws ServletException {
    }

    protected final void onBeforeRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException {
    }

    protected final void onInitializeHandler(HttpServletRequest request, HttpServletResponse response, ViewBean viewBean) {
    }

    protected final void onInitializeHandler(RequestContext requestContext, ViewBean viewBean) throws ServletException {
    }

    protected final void onAfterRequest(HttpServletRequest request, HttpServletResponse response) {
    }

    protected final void onBeforeHeader(HttpServletRequest request, HttpServletResponse response) {
    }

    protected final void onBeforeSessionUpdate(HttpServletRequest request, HttpServletResponse response) {
    }

    public String getServletName() {
        return this.servletName;
    }

    public String getModuleURL() {
        return this.moduleURL;
    }

    public void setModuleURL(String value) {
        this.moduleURL = value;
    }

    public boolean isShowMessageBuffer() {
        return this.showMessageBuffer;
    }

    public void setShowMessageBuffer(boolean value) {
        this.showMessageBuffer = value;
    }

    public boolean getGenerateUniqueURLs() {
        Boolean result = (Boolean)this.getServletConfig().getServletContext().getAttribute(GENERATE_UNIQUE_URLS);
        return result != null ? result : false;
    }

    public void setGenerateUniqueURLs(boolean value) {
        this.getServletConfig().getServletContext().setAttribute(GENERATE_UNIQUE_URLS, (Object)new Boolean(value));
    }

    protected boolean getShowMissingModuleURLWarning() {
        return this.showMissingModuleURLWarning;
    }

    protected void setShowMissingModuleURLWarning(boolean value) {
        this.showMissingModuleURLWarning = value;
    }

    public String getLogMessagePrefix() {
        return Log.getMessagePrefix();
    }

    public void setLogMessagePrefix(String value) {
        Log.setMessagePrefix(value);
    }

    public boolean getEchoLogToSystemOut() {
        return Log.getEchoToSystemOut();
    }

    public void setEchoLogToSystemOut(boolean value) {
        Log.setEchoToSystemOut(value);
    }

    public String getEnabledLogLevels() {
        return Log.getEnabledLevelsString();
    }

    public void setEnabledLogLevels(String levelsString) {
        int levels = Log.parseLogLevelString(levelsString);
        Log.setEnabledLevels(levels);
        String enabledLevels = this.getLogPrefix() + "Enabled log levels: " + Log.getEnabledLevelsString();
        Log.log(8, enabledLevels);
    }

    public boolean getEnforceStrictSessionTimeout() {
        return this.enforceStrictSessionTimeout;
    }

    public void setEnforceStrictSessionTimeout(boolean value) {
        this.enforceStrictSessionTimeout = value;
    }

    public boolean getAllowShortViewBeanNames() {
        return this.allowShortViewBeanNames;
    }

    public void setAllowShortViewBeanNames(boolean value) {
        this.allowShortViewBeanNames = value;
    }

    public String getQualifiedViewNameSeparator() {
        return ViewBase.getQualifiedViewNameSeparator();
    }

    public void setQualifiedViewNameSeparator(String value) {
        ViewBase.setQualifiedViewNameSeparator(value);
    }

    public boolean getUseTaglibTEI() {
        return TagBase.USE_TEI;
    }

    public void setUseTaglibTEI(boolean value) {
        TagBase.USE_TEI = value;
    }

    public static String getPackageName(String className) {
        if (className == null) {
            return null;
        }
        int index = className.lastIndexOf(".");
        if (index != -1) {
            return className.substring(0, index);
        }
        return className;
    }

    public static String getModuleURLParameterName(String className) {
        return "jato:" + ApplicationServletBase.getPackageName(className) + ".*:moduleURL";
    }

    public static String getModuleURL(RequestContext context, Class classInModule) {
        String propertyName = ApplicationServletBase.getModuleURLParameterName(classInModule.getName());
        String result = (String)context.getServletContext().getAttribute(propertyName);
        if (result == null) {
            result = context.getServletContext().getInitParameter(propertyName);
        }
        return result;
    }

    protected String prepareServletErrorMessage(String message, String detail, StringWriter stringWriter) {
        String errorHtml = MessageFormat.format(APPLICATION_ERROR_MESSAGE_I18N, this.getLocalizedMessage(MESSAGE_KEY_PREFIX + "applicationError"), StringTokenizer2.replace(message, "\n", "<br>"), detail, this.getLocalizedMessage(MESSAGE_KEY_PREFIX + "generated"), new Date().toString(), this.getLocalizedMessage(MESSAGE_KEY_PREFIX + "stackTrace"), stringWriter.toString());
        return errorHtml;
    }

    protected String prepareEventOverrideMessage(String eventMethodName) {
        String eventMsg = MessageFormat.format(this.getLocalizedMessage(MESSAGE_KEY_PREFIX + "eventOverride2"), eventMethodName);
        String errorHtml = MessageFormat.format(DEVELOPER_EVENT_OVERRIDE_HELP_MESSAGE_I18N, this.getLocalizedMessage(MESSAGE_KEY_PREFIX + "eventOverride1"), eventMsg, this.getLocalizedMessage(MESSAGE_KEY_PREFIX + "eventOverride3"));
        return errorHtml;
    }

    protected String getLocalizedMessage(String key) {
        String msg = null;
        if (!this.isMessageResourceBundleMissing) {
            try {
                msg = this.msgRb.getString(key);
            }
            catch (MissingResourceException e) {
                this.log("Unable to find local message for key \"" + key + "\"", e);
            }
        }
        if (msg == null) {
            msg = (String)FALLBACK_MESSAGES.get(key);
        }
        if (msg == null) {
            msg = "[Missing message resource]";
        }
        return msg;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        RESERVED_PARAMETER_NAME_PREFIX = RESERVED_PARAMETER_NAME_PREFIX;
        HANDLING_SERVLET_ATTRIBUTE_NAME = HANDLING_SERVLET_ATTRIBUTE_NAME;
        REQUEST_CONTEXT_ATTRIBUTE_NAME = REQUEST_CONTEXT_ATTRIBUTE_NAME;
        PARAM_DEBUG = PARAM_DEBUG;
        PARAM_HANDLER_BEAN = PARAM_HANDLER_BEAN;
        MESSAGE_AREA_PREFIX = MESSAGE_AREA_PREFIX;
        MESSAGE_AREA_POSTFIX = MESSAGE_AREA_POSTFIX;
        SHOW_MESSAGE_BUFFER_ATTRIBUTE_NAME = SHOW_MESSAGE_BUFFER_ATTRIBUTE_NAME;
        GENERATE_UNIQUE_URLS = GENERATE_UNIQUE_URLS;
        OPTION_USE_FALLBACK_PAGE_BEAN_NAME = false;
        MESSAGE_KEY_PREFIX = "jato.com.iplanet.jato.ApplicationServletBase.";
        MESSAGE_RESOURCE_BUNDLE_NAME = "com.iplanet.jato.Messages";
        MESSAGE_RESOURCE_BUNDLE_INIT_FAILURE = "Exception initializing messages resource bundle; using hard coded English messages:\n";
        ECHO_TO_SYSTEM_OUT = ECHO_TO_SYSTEM_OUT;
        LOG_MESSAGE_PREFIX = LOG_MESSAGE_PREFIX;
        ENABLED_LOG_LEVELS = ENABLED_LOG_LEVELS;
        APPLICATION_ERROR_MESSAGE_I18N = APPLICATION_ERROR_MESSAGE_I18N;
        DEVELOPER_EVENT_OVERRIDE_HELP_MESSAGE_I18N = DEVELOPER_EVENT_OVERRIDE_HELP_MESSAGE_I18N;
        FALLBACK_MESSAGES = new HashMap();
        FALLBACK_MESSAGES.put(MESSAGE_KEY_PREFIX + "applicationError", "Application Error");
        FALLBACK_MESSAGES.put(MESSAGE_KEY_PREFIX + "generated", "Generated");
        FALLBACK_MESSAGES.put(MESSAGE_KEY_PREFIX + "stackTrace", "Exception stack trace");
        FALLBACK_MESSAGES.put(MESSAGE_KEY_PREFIX + "eventOverride1", "Notes for application developers:");
        FALLBACK_MESSAGES.put(MESSAGE_KEY_PREFIX + "eventOverride2", "To prevent users from seeing this error message, override the <code>{0}</code> method in the module servlet and take action specific to the application");
        FALLBACK_MESSAGES.put(MESSAGE_KEY_PREFIX + "eventOverride3", "To see a stack trace from this error, see the source for this page");
        FALLBACK_MESSAGES.put(MESSAGE_KEY_PREFIX + "sessionTimeout", "The HTTP session has timed out");
        FALLBACK_MESSAGES.put(MESSAGE_KEY_PREFIX + "unspecifiedRequestHandler", "Invalid request - request handler not specified");
        FALLBACK_MESSAGES.put(MESSAGE_KEY_PREFIX + "unfoundRequestHandler", "Invalid request - request handler <code>{0}</code> not found");
    }
}

