/*
 * Decompiled with CFR 0.152.
 */
package com.sun.uwc.common.util;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.logging.XMLFormatter;

public class UWCLogger {
    private static final String enableLoggingProperty = "uwc.logging.enable";
    private static final String logLevelProperty = "uwc.log.level";
    private static final String logFileProperty = "uwc.log.file";
    private static final String logFormatterProperty = "uwc.log.formatter";
    private static final String logHandlerProperty = "uwc.log.handler";
    private static final String defaultDebugFileName = "/tmp/UWC.log";
    private static final String SIMPLE_FORMATTER = "SimpleFormatter";
    private static final String XML_FORMATTER = "XMLFormatter";
    private static final String defaultLogHandler = "FileHandler";
    private static PropertyResourceBundle _rb = null;
    private static String _logFileName = null;
    private static String _logEnable = null;
    private static String _logFormatter = null;
    private static String _logHandler = null;
    private static Handler _uwcLogHandler = null;
    private static LogManager _logManager = null;
    private static String _uwcLogLevel = null;
    private static String _logPropertiesFile = null;

    private static Logger getUWCLogger(String string) {
        Logger logger = null;
        if (_logManager == null) {
            _logManager = LogManager.getLogManager();
        }
        if (_logManager != null) {
            logger = _logManager.getLogger(string);
            if (logger == null) {
                logger = Logger.getLogger(string);
                logger = UWCLogger.setUWCLoggerProperties(logger);
            }
        } else {
            logger = Logger.getLogger(string);
            if (logger != null) {
                logger.setLevel(Level.OFF);
            }
        }
        return logger;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Logger setUWCLoggerProperties(Logger logger) {
        String string = "OFF";
        FileInputStream fileInputStream = null;
        if (_rb == null) {
            if (_logPropertiesFile == null) {
                logger.setLevel(Level.OFF);
                return logger;
            }
            try {
                fileInputStream = new FileInputStream(_logPropertiesFile);
                if (fileInputStream != null) {
                    _rb = new PropertyResourceBundle(fileInputStream);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                logger.setLevel(Level.OFF);
                return logger;
            }
            catch (SecurityException securityException) {
                logger.setLevel(Level.OFF);
                return logger;
            }
            catch (IOException iOException) {
                logger.setLevel(Level.OFF);
                return logger;
            }
            catch (Exception exception) {
                logger.setLevel(Level.OFF);
                return logger;
            }
        }
        if (!UWCLogger.isLoggingEnabled()) {
            logger.setLevel(Level.OFF);
            return logger;
        }
        _logFileName = UWCLogger.getLogFileName();
        _logHandler = UWCLogger.getLogHandler();
        _logFormatter = UWCLogger.getLogFormatter();
        Handler[] handlerArray = logger.getHandlers();
        if (handlerArray != null) {
            for (int i = 0; i < handlerArray.length; ++i) {
                logger.removeHandler(handlerArray[i]);
            }
        }
        if (_logHandler.equalsIgnoreCase(defaultLogHandler)) {
            if (_logFileName == null) {
                logger.setLevel(Level.OFF);
                return logger;
            }
            logger = UWCLogger.addFileHandlerToLogger(logger, _logFileName, _logFormatter);
        } else {
            logger = UWCLogger.addConsoleHandlerToLogger(logger, _logFormatter);
        }
        string = UWCLogger.getLoggerLevel(logger.getName());
        Level level = UWCLogger.getLevel(string);
        logger.setLevel(level);
        logger.setUseParentHandlers(false);
        return logger;
    }

    private static String getLogFileName() {
        String string = null;
        if (_rb != null) {
            if (_logFileName != null) {
                string = _logFileName;
            } else {
                try {
                    string = _rb.getString(logFileProperty);
                }
                catch (MissingResourceException missingResourceException) {
                    string = defaultDebugFileName;
                }
                if (string == null) {
                    string = defaultDebugFileName;
                }
            }
        }
        return string;
    }

    private static boolean isLoggingEnabled() {
        if (_logEnable == null) {
            if (_rb != null) {
                try {
                    _logEnable = _rb.getString(enableLoggingProperty);
                }
                catch (MissingResourceException missingResourceException) {
                    _logEnable = "NO";
                }
            }
            if (_logEnable == null) {
                _logEnable = "NO";
            }
        }
        return (_logEnable = _logEnable.trim()).equalsIgnoreCase("YES");
    }

    private static String getLoggerLevel(String string) {
        String string2 = null;
        if (_rb != null) {
            try {
                string2 = _rb.getString(string + ".loglevel");
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        if (string2 == null) {
            string2 = UWCLogger.getUWCLogLevel();
        }
        return string2;
    }

    private static String getUWCLogLevel() {
        String string = "OFF";
        if (_uwcLogLevel != null) {
            string = _uwcLogLevel;
            return string;
        }
        if (_rb != null) {
            try {
                _uwcLogLevel = _rb.getString(logLevelProperty);
            }
            catch (MissingResourceException missingResourceException) {
                _uwcLogLevel = "OFF";
            }
            string = _uwcLogLevel;
        }
        return string;
    }

    private static String getLogFormatter() {
        String string = SIMPLE_FORMATTER;
        if (_logFormatter != null) {
            return _logFormatter;
        }
        if (_rb != null) {
            try {
                _logFormatter = _rb.getString(logFormatterProperty);
            }
            catch (MissingResourceException missingResourceException) {
                _logFormatter = SIMPLE_FORMATTER;
            }
            string = _logFormatter;
        }
        return string;
    }

    private static String getLogHandler() {
        String string = defaultLogHandler;
        if (_logHandler != null) {
            return _logHandler;
        }
        if (_rb != null) {
            try {
                _logHandler = _rb.getString(logHandlerProperty);
            }
            catch (MissingResourceException missingResourceException) {
                _logHandler = defaultLogHandler;
            }
            string = _logHandler;
        }
        return string;
    }

    private static Logger addFileHandlerToLogger(Logger logger, String string, String string2) {
        try {
            if (_uwcLogHandler == null) {
                _uwcLogHandler = new FileHandler(string, true);
                if (string2.equalsIgnoreCase(XML_FORMATTER)) {
                    _uwcLogHandler.setFormatter(new XMLFormatter());
                } else {
                    _uwcLogHandler.setFormatter(new SimpleFormatter());
                }
            }
            logger.addHandler(_uwcLogHandler);
        }
        catch (IOException iOException) {
            logger.setLevel(Level.OFF);
            return logger;
        }
        catch (Exception exception) {
            logger.setLevel(Level.OFF);
            return logger;
        }
        return logger;
    }

    private static Logger addConsoleHandlerToLogger(Logger logger, String string) {
        if (_uwcLogHandler == null) {
            _uwcLogHandler = new ConsoleHandler();
            if (string.equalsIgnoreCase(XML_FORMATTER)) {
                _uwcLogHandler.setFormatter(new XMLFormatter());
            } else {
                _uwcLogHandler.setFormatter(new SimpleFormatter());
            }
        }
        logger.addHandler(_uwcLogHandler);
        return logger;
    }

    public static synchronized Logger getLogger(String string) {
        return UWCLogger.getUWCLogger(string);
    }

    public static void setConfigFile(String string) {
        _logPropertiesFile = string;
    }

    private static Level getLevel(String string) {
        if (string.equalsIgnoreCase("SEVERE")) {
            return Level.SEVERE;
        }
        if (string.equalsIgnoreCase("WARNING")) {
            return Level.WARNING;
        }
        if (string.equalsIgnoreCase("INFO")) {
            return Level.INFO;
        }
        if (string.equalsIgnoreCase("CONFIG")) {
            return Level.CONFIG;
        }
        if (string.equalsIgnoreCase("FINE")) {
            return Level.FINE;
        }
        if (string.equalsIgnoreCase("FINER")) {
            return Level.FINER;
        }
        if (string.equalsIgnoreCase("FINEST")) {
            return Level.FINEST;
        }
        if (string.equalsIgnoreCase("ALL")) {
            return Level.ALL;
        }
        if (string.equalsIgnoreCase("OFF")) {
            return Level.OFF;
        }
        return Level.OFF;
    }
}

