/*
 * Decompiled with CFR 0.152.
 */
package com.sun.uwc.common.util;

import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.uwc.common.UWCException;
import com.sun.uwc.common.auth.Domain;
import com.sun.uwc.common.auth.LDAPDomainMap;
import com.sun.uwc.common.util.UWCLogger;
import com.sun.uwc.common.util.UWCPreferences;
import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class UWCDomainManager {
    public static final String CONFIG_DEFAULTDOMAIN = "defaultdomain";
    public static final String CONFIG_IDENTITY_ENABLED = "uwcauth.identity.enabled";
    public static final String CONFIG_BINDDN = "uwcauth.identity.binddn";
    public static final String CONFIG_BINDCRED = "uwcauth.identity.bindcred";
    private HashMap domainmap = new HashMap();
    private boolean isISEnabled = false;
    private static final Logger log = UWCLogger.getLogger("uwc");
    private String defaultdomain = null;
    private UWCPreferences uwcconfig;
    private UWCPreferences uwcauth;
    private LDAPDomainMap ldapDomainMap = null;
    private SSOTokenManager manager = null;
    private String amadmindn = null;
    private String amadmincred = null;
    private String CLASS_NAME = "UWCDomainManager";

    public void init(UWCPreferences uWCPreferences, UWCPreferences uWCPreferences2) throws UWCException {
        log.entering(this.CLASS_NAME, "init()");
        if (null == uWCPreferences) {
            throw new UWCException("Config Object is null");
        }
        if (null == uWCPreferences2) {
            throw new UWCException("Config Object is null");
        }
        this.uwcconfig = uWCPreferences;
        this.uwcauth = uWCPreferences2;
        this.isISEnabled = this.uwcauth.getBoolean(CONFIG_IDENTITY_ENABLED, false);
        this.defaultdomain = this.uwcauth.get(CONFIG_DEFAULTDOMAIN, "india.sun.com");
        if (!this.isISEnabled) {
            log.finest("IS Enabled");
            this.ldapDomainMap = LDAPDomainMap.getInstance(this.uwcauth);
            if (null == this.ldapDomainMap) {
                log.finest("Domain Map is NULL !!");
                log.exiting(this.CLASS_NAME, "init()");
                throw new UWCException("ldapdomainmap is  null");
            }
        } else {
            this.amadmindn = this.uwcauth.get(CONFIG_BINDDN, null);
            this.amadmincred = this.uwcauth.get(CONFIG_BINDCRED, null);
            if (null == this.amadmindn || null == this.amadmincred) {
                throw new UWCException("amadmin information is  null");
            }
            try {
                this.manager = SSOTokenManager.getInstance();
            }
            catch (Exception exception) {
                log.severe("SSOException.." + exception.getMessage());
                throw new UWCException(exception.getMessage());
            }
        }
        log.exiting(this.CLASS_NAME, "init()");
    }

    public String getAttributeValue(String string, String string2) throws UWCException {
        log.entering(this.CLASS_NAME, "getAttributeValue()");
        String string3 = null;
        if (!this.isISEnabled) {
            Domain domain = this.loadDomainFromLDAP(string);
            if (null == domain) {
                log.finest("DomaiObj is NULL !!");
                return null;
            }
            string3 = domain.getAttribute(string2);
            log.finest("Value for Attribute" + string2 + " is " + string3);
        } else {
            AMOrganization aMOrganization = this.loadDomainFromIS(string);
            if (null == aMOrganization) {
                return null;
            }
            try {
                string3 = aMOrganization.getStringAttribute(string2);
            }
            catch (Exception exception) {
                log.warning("AMException.." + exception.getMessage());
                return null;
            }
        }
        log.exiting(this.CLASS_NAME, "getAttributeValue()");
        return string3;
    }

    public boolean loadDomain(String string) throws UWCException {
        if (null == string) {
            throw new UWCException("domain is null");
        }
        return !(!this.isISEnabled ? this.loadDomainFromLDAP(string) == null : this.loadDomainFromIS(string) == null);
    }

    private Domain loadDomainFromLDAP(String string) throws UWCException {
        Domain domain = this.ldapDomainMap.getDomainObject(string, true);
        return domain;
    }

    public AMOrganization loadDomainFromIS(String string) throws UWCException {
        AMOrganization aMOrganization;
        block11: {
            aMOrganization = null;
            try {
                Object object;
                aMOrganization = (AMOrganization)this.domainmap.get(string);
                if (null != aMOrganization) break block11;
                UWCDomainManagerPrincipal uWCDomainManagerPrincipal = (UWCDomainManagerPrincipal)this.getAdminPrincipal();
                SSOToken sSOToken = this.manager.createSSOToken((Principal)uWCDomainManagerPrincipal, this.amadmincred);
                AMStoreConnection aMStoreConnection = new AMStoreConnection(sSOToken);
                String string2 = aMStoreConnection.getOrganizationDN(string, null);
                if (null == string2) {
                    return null;
                }
                aMOrganization = aMStoreConnection.getOrganization(string2);
                if (null == aMOrganization) {
                    return null;
                }
                Map map = aMOrganization.getAttributes();
                if (map == null) {
                    return null;
                }
                log.finest("MAP=" + map.toString());
                Object object2 = null;
                Object object3 = null;
                Object object4 = map.keySet().iterator();
                while (object4.hasNext()) {
                    object = (String)object4.next();
                    log.finest("KEY:" + (String)object);
                    if (object2 != null && object3 != null) break;
                    if (object2 == null && ((String)object).equalsIgnoreCase("associateddomain")) {
                        object2 = object;
                        continue;
                    }
                    if (object3 != null || !((String)object).equalsIgnoreCase("sunpreferreddomain")) continue;
                    object3 = object;
                }
                if (object2 == null && object3 == null) {
                    return null;
                }
                object4 = null;
                object = null;
                if (object2 != null) {
                    object4 = aMOrganization.getAttribute(object2);
                }
                if (object3 != null) {
                    object = aMOrganization.getAttribute(object3);
                }
                if (this.srchDomain((Set)object4, string) || this.srchDomain((Set)object, string)) {
                    log.finest("org=" + aMOrganization.toString() + " domain=" + string + " orgDN" + string2);
                    this.domainmap.put(aMOrganization, string);
                    break block11;
                }
                return null;
            }
            catch (Exception exception) {
                log.severe("Exception.." + exception.getMessage());
                this.dump_stack(exception);
                return null;
            }
        }
        return aMOrganization;
    }

    private boolean srchDomain(Set set, String string) {
        Object[] objectArray;
        if (set != null && (objectArray = set.toArray()) != null && objectArray.length > 0) {
            for (int i = 0; i < objectArray.length; ++i) {
                String string2 = (String)objectArray[i];
                if (!string2.equalsIgnoreCase(string)) continue;
                return true;
            }
        }
        return false;
    }

    private void dump_stack(Exception exception) {
        log.finest("*** Start Stack Trace ******");
        StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            StackTraceElement stackTraceElement = stackTraceElementArray[i];
            log.finest(stackTraceElement.getClassName() + "." + stackTraceElement.getMethodName() + "@" + stackTraceElement.getLineNumber());
        }
        log.finest("****** End Stack Trace ******");
    }

    public Principal getAdminPrincipal() {
        UWCDomainManagerPrincipal uWCDomainManagerPrincipal = new UWCDomainManagerPrincipal(this.amadmindn);
        return uWCDomainManagerPrincipal;
    }

    static class UWCDomainManagerPrincipal
    implements Principal {
        String name;

        UWCDomainManagerPrincipal(String string) {
            this.name = string;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            return object.toString().equals(this.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }
}

